/*
 * Decompiled with CFR 0.152.
 */
package zio.schema.doc.generator;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;
import zio.schema.doc.generator.Main;
import zio.schema.doc.generator.Main$StandardTypeForDoc$;

public final class Main$ {
    public static Main$ MODULE$;
    private final File standardTypeFile;

    static {
        new Main$();
    }

    private File standardTypeFile() {
        return this.standardTypeFile;
    }

    private String convertBooleanToText(boolean bool) {
        if (bool) {
            return "\u2705";
        }
        return "\u274c";
    }

    private String generateStandardTypeFileText(File standardTypeFile) {
        String string;
        Regex standardTypeRegex = new StringOps(Predef$.MODULE$.augmentString("StandardType\\[.*")).r();
        Regex suffixRegex = new StringOps(Predef$.MODULE$.augmentString("((])(?!.*])).*")).r();
        ObjectRef unsortedStandardTypes = ObjectRef.create((Object)package$.MODULE$.Vector().empty());
        ObjectRef markdownFile = ObjectRef.create((Object)new StringOps(Predef$.MODULE$.augmentString("---\n        |id: standard-type-reference\n        |title: \"Standard Type Reference\"\n        |---\n        |# Standard Type Reference\n        |\n        |ZIO Schema provides a number of built-in primitive types, that we can use to represent our data. These can be seen in the following table:\n        |\n        ||Standard Type|JVM Support|ScalaJS Support|Scala Native Support|\n        ||--------------|:--------------:|:--------------:|:--------------:|")).stripMargin());
        try (BufferedSource source = Source$.MODULE$.fromFile(standardTypeFile, Codec$.MODULE$.fallbackSystemCodec());){
            source.getLines().foreach((Function1 & Serializable & scala.Serializable)line -> {
                Main$.$anonfun$generateStandardTypeFileText$1(standardTypeRegex, suffixRegex, unsortedStandardTypes, line);
                return BoxedUnit.UNIT;
            });
            ((Vector)((Vector)unsortedStandardTypes.elem).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)standardType -> {
                Main$.$anonfun$generateStandardTypeFileText$4(markdownFile, standardType);
                return BoxedUnit.UNIT;
            });
            string = (String)markdownFile.elem;
        }
        return string;
    }

    public void main(String[] args) {
        String table = this.generateStandardTypeFileText(this.standardTypeFile());
        Files.write(Paths.get(".", "docs", "standard-type-reference.md"), table.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static final /* synthetic */ void $anonfun$generateStandardTypeFileText$1(Regex standardTypeRegex$1, Regex suffixRegex$1, ObjectRef unsortedStandardTypes$1, String line) {
        if (line.contains("implicit object")) {
            Main.StandardTypeForDoc standardTypeForDoc;
            String lineWithoutPrefix = ((String)standardTypeRegex$1.findFirstIn((CharSequence)line).getOrElse((Function0 & Serializable & scala.Serializable)() -> "Expected StandardType to be present in line while parsing standard type doc")).trim().replace("StandardType[", "");
            String standardTypeStr = suffixRegex$1.replaceFirstIn((CharSequence)lineWithoutPrefix, "");
            if ("java.util.UUID".equals(standardTypeStr)) {
                String x$1 = "java.util.UUID";
                boolean x$2 = false;
                boolean x$3 = Main$StandardTypeForDoc$.MODULE$.apply$default$2();
                boolean x$4 = Main$StandardTypeForDoc$.MODULE$.apply$default$4();
                standardTypeForDoc = new Main.StandardTypeForDoc(x$1, x$3, x$2, x$4);
            } else if ("java.util.Currency".equals(standardTypeStr)) {
                String x$5 = "java.util.Currency";
                boolean x$6 = false;
                boolean x$7 = false;
                boolean x$8 = Main$StandardTypeForDoc$.MODULE$.apply$default$2();
                standardTypeForDoc = new Main.StandardTypeForDoc(x$5, x$8, x$6, x$7);
            } else {
                standardTypeForDoc = new Main.StandardTypeForDoc(standardTypeStr, Main$StandardTypeForDoc$.MODULE$.apply$default$2(), Main$StandardTypeForDoc$.MODULE$.apply$default$3(), Main$StandardTypeForDoc$.MODULE$.apply$default$4());
            }
            Main.StandardTypeForDoc standardTypeForDoc2 = standardTypeForDoc;
            unsortedStandardTypes$1.elem = (Vector)((Vector)unsortedStandardTypes$1.elem).$colon$plus((Object)standardTypeForDoc2, Vector$.MODULE$.canBuildFrom());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$generateStandardTypeFileText$4(ObjectRef markdownFile$1, Main.StandardTypeForDoc standardType) {
        String jsSupport = MODULE$.convertBooleanToText(standardType.isJSSupported());
        String jvmSupport = MODULE$.convertBooleanToText(standardType.isJVMSupported());
        String nativeSupport = MODULE$.convertBooleanToText(standardType.isNativeSupported());
        markdownFile$1.elem = new StringBuilder(8).append((String)markdownFile$1.elem).append("\n|`").append(standardType.name()).append("`|").append(jvmSupport).append("|").append(jsSupport).append("|").append(nativeSupport).append("|").toString();
    }

    private Main$() {
        MODULE$ = this;
        this.standardTypeFile = Paths.get(".", "zio-schema", "jvm", "src", "main", "scala", "zio", "schema", "StandardType.scala").toFile();
    }
}

