/*
 * Decompiled with CFR 0.152.
 */
package zio.schema.codec;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Month;
import java.time.MonthDay;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.annotation.StaticAnnotation;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Either$;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scala.util.matching.Regex;
import zio.Chunk;
import zio.Chunk$;
import zio.schema.CaseSet;
import zio.schema.CaseSet$;
import zio.schema.Schema;
import zio.schema.Schema$;
import zio.schema.StandardType;
import zio.schema.TypeId$;
import zio.schema.codec.AvroAnnotations;
import zio.schema.codec.AvroAnnotations$DecimalType$;
import zio.schema.codec.AvroAnnotations$DecimalType$Bytes$;
import zio.schema.codec.AvroAnnotations$FieldOrderType$;
import zio.schema.codec.AvroAnnotations$TimePrecisionType$;
import zio.schema.codec.AvroAnnotations$TimePrecisionType$Micros$;
import zio.schema.codec.AvroAnnotations$TimePrecisionType$Millis$;
import zio.schema.codec.AvroAnnotations$error$;
import zio.schema.codec.AvroAnnotations$formatToString$;
import zio.schema.codec.AvroAnnotations$precision$;
import zio.schema.codec.AvroAnnotations$scale$;
import zio.schema.codec.AvroPropMarker;
import zio.schema.codec.AvroPropMarker$;
import zio.schema.codec.AvroPropMarker$EitherWrapper$;
import zio.schema.codec.AvroPropMarker$Formatter$;
import zio.schema.codec.AvroPropMarker$UnionWrapper$;
import zio.schema.codec.AvroSchemaCodec;
import zio.schema.codec.AvroSchemaCodec$EitherUnion$;
import zio.schema.codec.AvroSchemaCodec$OptionUnion$;
import zio.schema.codec.IntType;
import zio.schema.codec.IntType$;
import zio.schema.codec.IntType$Char$;
import zio.schema.codec.IntType$DayOfWeek$;
import zio.schema.codec.IntType$Month$;
import zio.schema.codec.IntType$Short$;
import zio.schema.codec.IntType$Year$;
import zio.schema.codec.IntType$ZoneOffset$;
import zio.schema.codec.RecordType;
import zio.schema.codec.RecordType$;
import zio.schema.codec.RecordType$Duration$;
import zio.schema.codec.RecordType$MonthDay$;
import zio.schema.codec.RecordType$Period$;
import zio.schema.codec.RecordType$Tuple$;
import zio.schema.codec.RecordType$YearMonth$;
import zio.schema.codec.StringType;
import zio.schema.codec.StringType$;
import zio.schema.codec.StringType$Instant$;
import zio.schema.codec.StringType$LocalDate$;
import zio.schema.codec.StringType$LocalDateTime$;
import zio.schema.codec.StringType$LocalTime$;
import zio.schema.codec.StringType$OffsetDateTime$;
import zio.schema.codec.StringType$OffsetTime$;
import zio.schema.codec.StringType$ZoneDateTime$;
import zio.schema.codec.StringType$ZoneId$;
import zio.schema.meta.ExtensibleMetaSchema$;
import zio.schema.meta.SchemaInstances$;
import zio.schema.validation.Validation;

public final class AvroSchemaCodec$
implements AvroSchemaCodec {
    public static final AvroSchemaCodec$ MODULE$ = new AvroSchemaCodec$();
    private static Seq<Schema.Field<MonthDay, Object>> monthDayStructure;
    private static Seq<Schema.Field<Period, Object>> periodStructure;
    private static Seq<Schema.Field<YearMonth, Object>> yearMonthStructure;
    private static Seq<Schema.Field<Duration, ?>> durationStructure;
    private static volatile byte bitmap$0;

    @Override
    public Either<String, String> encode(Schema<?> schema) {
        return this.toAvroSchema(schema).map((Function1 & Serializable)x$1 -> x$1.toString());
    }

    @Override
    public Either<String, org.apache.avro.Schema> encodeToApacheAvro(Schema<?> schema) {
        return this.toAvroSchema(schema);
    }

    @Override
    public Either<String, Schema<?>> decode(Chunk<Object> bytes2) {
        Schema.Parser avroSchemaParser = new Schema.Parser();
        return ((Either)Try$.MODULE$.apply((Function0 & Serializable)() -> avroSchemaParser.parse(new String((byte[])bytes2.toArray((ClassTag)ClassTag$.MODULE$.Byte()), StandardCharsets.UTF_8))).fold((Function1 & Serializable)e -> package$.MODULE$.Left().apply((Object)e.getMessage()), (Function1 & Serializable)s -> new Right(s))).flatMap((Function1 & Serializable)avroSchema -> MODULE$.toZioSchema((org.apache.avro.Schema)avroSchema));
    }

    @Override
    public Function1<org.apache.avro.Schema, Either<String, Schema<?>>> decodeFromApacheAvro() {
        return (Function1 & Serializable)avroSchema -> MODULE$.toZioSchema((org.apache.avro.Schema)avroSchema);
    }

    private Either<String, Schema<?>> toZioSchema(org.apache.avro.Schema avroSchema) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> LogicalTypes.fromSchema((org.apache.avro.Schema)avroSchema)).toEither().left().map((Function1 & Serializable)e -> e.getMessage()).flatMap((Function1 & Serializable)x$15 -> {
            Right right;
            Schema.Type type = avroSchema.getType();
            if (Schema.Type.RECORD.equals(type)) {
                RecordType recordType;
                RecordType recordType2;
                RecordType recordType3;
                RecordType recordType4;
                boolean bl = false;
                Some some = null;
                Option<RecordType> option = RecordType$.MODULE$.fromAvroRecord(avroSchema);
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    RecordType recordType5 = (RecordType)some.value();
                    if (RecordType$Period$.MODULE$.equals(recordType5)) {
                        right = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.PeriodType$.MODULE$));
                        return right.map((Function1 & Serializable)result -> result);
                    }
                }
                if (bl && RecordType$YearMonth$.MODULE$.equals(recordType4 = (RecordType)some.value())) {
                    right = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.YearMonthType$.MODULE$));
                    return right.map((Function1 & Serializable)result -> result);
                }
                if (bl && RecordType$Tuple$.MODULE$.equals(recordType3 = (RecordType)some.value())) {
                    right = MODULE$.toZioTuple(avroSchema);
                    return right.map((Function1 & Serializable)result -> result);
                }
                if (bl && RecordType$MonthDay$.MODULE$.equals(recordType2 = (RecordType)some.value())) {
                    right = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.MonthDayType$.MODULE$));
                    return right.map((Function1 & Serializable)result -> result);
                }
                if (bl && RecordType$Duration$.MODULE$.equals(recordType = (RecordType)some.value())) {
                    right = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.DurationType$.MODULE$));
                    return right.map((Function1 & Serializable)result -> result);
                }
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                right = MODULE$.toZioRecord(avroSchema);
                return right.map((Function1 & Serializable)result -> result);
            }
            if (Schema.Type.ENUM.equals(type)) {
                right = MODULE$.toZioStringEnum(avroSchema);
                return right.map((Function1 & Serializable)result -> result);
            }
            if (Schema.Type.ARRAY.equals(type)) {
                right = MODULE$.toZioSchema(avroSchema.getElementType()).map((Function1 & Serializable)x$2 -> Schema$.MODULE$.list(x$2));
                return right.map((Function1 & Serializable)result -> result);
            }
            if (Schema.Type.MAP.equals(type)) {
                right = MODULE$.toZioSchema(avroSchema.getValueType()).map((Function1 & Serializable)x$3 -> Schema$.MODULE$.map(Schema$.MODULE$.primitive((StandardType)StandardType.StringType$.MODULE$), x$3));
                return right.map((Function1 & Serializable)result -> result);
            }
            if (Schema.Type.UNION.equals(type)) {
                Option<Tuple2<org.apache.avro.Schema, org.apache.avro.Schema>> option;
                Option<org.apache.avro.Schema> option2 = AvroSchemaCodec$OptionUnion$.MODULE$.unapply(avroSchema);
                if (!option2.isEmpty()) {
                    org.apache.avro.Schema optionSchema = (org.apache.avro.Schema)option2.get();
                    right = MODULE$.toZioSchema(optionSchema).map((Function1 & Serializable)x$4 -> Schema$.MODULE$.option(x$4));
                    return right.map((Function1 & Serializable)result -> result);
                }
                if (avroSchema != null && !(option = AvroSchemaCodec$EitherUnion$.MODULE$.unapply(avroSchema)).isEmpty()) {
                    org.apache.avro.Schema left = (org.apache.avro.Schema)((Tuple2)option.get())._1();
                    org.apache.avro.Schema right2 = (org.apache.avro.Schema)((Tuple2)option.get())._2();
                    right = MODULE$.toZioSchema(left).flatMap((Function1 & Serializable)l -> MODULE$.toZioSchema(right2).map((Function1 & Serializable)r -> Schema$.MODULE$.either(l, r)));
                    return right.map((Function1 & Serializable)result -> result);
                }
                right = MODULE$.toZioEnumeration(avroSchema);
                return right.map((Function1 & Serializable)result -> result);
            }
            if (Schema.Type.FIXED.equals(type)) {
                Left left;
                if (avroSchema.getLogicalType() == null) {
                    left = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.BinaryType$.MODULE$));
                } else if (avroSchema.getLogicalType() instanceof LogicalTypes.Decimal) {
                    int size = avroSchema.getFixedSize();
                    left = MODULE$.toZioDecimal(avroSchema, new AvroAnnotations.DecimalType.Fixed(size));
                } else {
                    left = package$.MODULE$.Left().apply((Object)new StringBuilder(31).append("Unsupported fixed logical type ").append(avroSchema.getLogicalType()).toString());
                }
                right = left.map((Function1 & Serializable)x$5 -> MODULE$.SchemaExtensions((Schema<?>)x$5).addAllAnnotations(MODULE$.buildZioAnnotations(avroSchema)));
                return right.map((Function1 & Serializable)result -> result);
            }
            if (Schema.Type.STRING.equals(type)) {
                Option<StringType> option = StringType$.MODULE$.fromAvroString(avroSchema);
                if (option instanceof Some) {
                    StringType stringType = (StringType)((Some)option).value();
                    right = AvroPropMarker$Formatter$.MODULE$.fromAvroStringOrDefault(avroSchema, stringType).map((Function1 & Serializable)x$6 -> x$6.dateTimeFormatter()).flatMap((Function1 & Serializable)x$7 -> {
                        if (StringType$ZoneId$.MODULE$.equals(stringType)) {
                            return new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.ZoneIdType$.MODULE$));
                        }
                        if (StringType$Instant$.MODULE$.equals(stringType)) {
                            return new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.InstantType$.MODULE$).annotate((Object)AvroAnnotations$formatToString$.MODULE$));
                        }
                        if (StringType$LocalDate$.MODULE$.equals(stringType)) {
                            return new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.LocalDateType$.MODULE$).annotate((Object)AvroAnnotations$formatToString$.MODULE$));
                        }
                        if (StringType$LocalTime$.MODULE$.equals(stringType)) {
                            return new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.LocalTimeType$.MODULE$).annotate((Object)AvroAnnotations$formatToString$.MODULE$));
                        }
                        if (StringType$LocalDateTime$.MODULE$.equals(stringType)) {
                            return new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.LocalDateTimeType$.MODULE$).annotate((Object)AvroAnnotations$formatToString$.MODULE$));
                        }
                        if (StringType$OffsetTime$.MODULE$.equals(stringType)) {
                            return new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.OffsetTimeType$.MODULE$));
                        }
                        if (StringType$OffsetDateTime$.MODULE$.equals(stringType)) {
                            return new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.OffsetDateTimeType$.MODULE$));
                        }
                        if (StringType$ZoneDateTime$.MODULE$.equals(stringType)) {
                            return new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.ZonedDateTimeType$.MODULE$));
                        }
                        throw new MatchError((Object)stringType);
                    });
                    return right.map((Function1 & Serializable)result -> result);
                }
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                if (avroSchema.getLogicalType() == null) {
                    right = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.StringType$.MODULE$));
                    return right.map((Function1 & Serializable)result -> result);
                }
                String string = avroSchema.getLogicalType().getName();
                String string2 = LogicalTypes.uuid().getName();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    right = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.UUIDType$.MODULE$));
                    return right.map((Function1 & Serializable)result -> result);
                }
                right = package$.MODULE$.Left().apply((Object)new StringBuilder(33).append("Unsupported string logical type: ").append(avroSchema.getLogicalType().getName()).toString());
                return right.map((Function1 & Serializable)result -> result);
            }
            if (Schema.Type.BYTES.equals(type)) {
                if (avroSchema.getLogicalType() == null) {
                    right = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.BinaryType$.MODULE$));
                    return right.map((Function1 & Serializable)result -> result);
                }
                if (avroSchema.getLogicalType() instanceof LogicalTypes.Decimal) {
                    right = MODULE$.toZioDecimal(avroSchema, AvroAnnotations$DecimalType$Bytes$.MODULE$);
                    return right.map((Function1 & Serializable)result -> result);
                }
                right = package$.MODULE$.Left().apply((Object)new StringBuilder(31).append("Unsupported bytes logical type ").append(avroSchema.getLogicalType().getName()).toString());
                return right.map((Function1 & Serializable)result -> result);
            }
            if (Schema.Type.INT.equals(type)) {
                IntType intType;
                IntType intType2;
                IntType intType3;
                IntType intType4;
                IntType intType5;
                boolean bl = false;
                Some some = null;
                Option<IntType> option = IntType$.MODULE$.fromAvroInt(avroSchema);
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    IntType intType6 = (IntType)some.value();
                    if (IntType$Char$.MODULE$.equals(intType6)) {
                        right = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.CharType$.MODULE$));
                        return right.map((Function1 & Serializable)result -> result);
                    }
                }
                if (bl && IntType$DayOfWeek$.MODULE$.equals(intType5 = (IntType)some.value())) {
                    right = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.DayOfWeekType$.MODULE$));
                    return right.map((Function1 & Serializable)result -> result);
                }
                if (bl && IntType$Year$.MODULE$.equals(intType4 = (IntType)some.value())) {
                    right = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.YearType$.MODULE$));
                    return right.map((Function1 & Serializable)result -> result);
                }
                if (bl && IntType$Short$.MODULE$.equals(intType3 = (IntType)some.value())) {
                    right = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.ShortType$.MODULE$));
                    return right.map((Function1 & Serializable)result -> result);
                }
                if (bl && IntType$Month$.MODULE$.equals(intType2 = (IntType)some.value())) {
                    right = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.MonthType$.MODULE$));
                    return right.map((Function1 & Serializable)result -> result);
                }
                if (bl && IntType$ZoneOffset$.MODULE$.equals(intType = (IntType)some.value())) {
                    right = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.ZoneOffsetType$.MODULE$));
                    return right.map((Function1 & Serializable)result -> result);
                }
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                if (avroSchema.getLogicalType() == null) {
                    right = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.IntType$.MODULE$));
                    return right.map((Function1 & Serializable)result -> result);
                }
                LogicalType logicalType = avroSchema.getLogicalType();
                if (logicalType instanceof LogicalTypes.TimeMillis) {
                    right = AvroPropMarker$Formatter$.MODULE$.fromAvroStringOrDefault(avroSchema, avroSchema.getLogicalType()).map((Function1 & Serializable)x$8 -> Schema$.MODULE$.primitive((StandardType)StandardType.LocalTimeType$.MODULE$));
                    return right.map((Function1 & Serializable)result -> result);
                }
                if (logicalType instanceof LogicalTypes.Date) {
                    right = AvroPropMarker$Formatter$.MODULE$.fromAvroStringOrDefault(avroSchema, avroSchema.getLogicalType()).map((Function1 & Serializable)x$9 -> Schema$.MODULE$.primitive((StandardType)StandardType.LocalDateType$.MODULE$));
                    return right.map((Function1 & Serializable)result -> result);
                }
                right = package$.MODULE$.Left().apply((Object)new StringBuilder(29).append("Unsupported int logical type ").append(avroSchema.getLogicalType().getName()).toString());
                return right.map((Function1 & Serializable)result -> result);
            }
            if (Schema.Type.LONG.equals(type)) {
                if (avroSchema.getLogicalType() == null) {
                    right = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.LongType$.MODULE$));
                    return right.map((Function1 & Serializable)result -> result);
                }
                LogicalType logicalType = avroSchema.getLogicalType();
                if (logicalType instanceof LogicalTypes.TimeMicros) {
                    right = AvroPropMarker$Formatter$.MODULE$.fromAvroStringOrDefault(avroSchema, avroSchema.getLogicalType()).map((Function1 & Serializable)x$10 -> Schema$.MODULE$.primitive((StandardType)StandardType.LocalTimeType$.MODULE$));
                    return right.map((Function1 & Serializable)result -> result);
                }
                if (logicalType instanceof LogicalTypes.TimestampMillis) {
                    right = AvroPropMarker$Formatter$.MODULE$.fromAvroStringOrDefault(avroSchema, avroSchema.getLogicalType()).map((Function1 & Serializable)x$11 -> Schema$.MODULE$.primitive((StandardType)StandardType.InstantType$.MODULE$));
                    return right.map((Function1 & Serializable)result -> result);
                }
                if (logicalType instanceof LogicalTypes.TimestampMicros) {
                    right = AvroPropMarker$Formatter$.MODULE$.fromAvroStringOrDefault(avroSchema, avroSchema.getLogicalType()).map((Function1 & Serializable)x$12 -> Schema$.MODULE$.primitive((StandardType)StandardType.InstantType$.MODULE$));
                    return right.map((Function1 & Serializable)result -> result);
                }
                if (logicalType instanceof LogicalTypes.LocalTimestampMillis) {
                    right = AvroPropMarker$Formatter$.MODULE$.fromAvroStringOrDefault(avroSchema, avroSchema.getLogicalType()).map((Function1 & Serializable)x$13 -> Schema$.MODULE$.primitive((StandardType)StandardType.LocalDateTimeType$.MODULE$));
                    return right.map((Function1 & Serializable)result -> result);
                }
                if (logicalType instanceof LogicalTypes.LocalTimestampMicros) {
                    right = AvroPropMarker$Formatter$.MODULE$.fromAvroStringOrDefault(avroSchema, avroSchema.getLogicalType()).map((Function1 & Serializable)x$14 -> Schema$.MODULE$.primitive((StandardType)StandardType.LocalDateTimeType$.MODULE$));
                    return right.map((Function1 & Serializable)result -> result);
                }
                right = package$.MODULE$.Left().apply((Object)new StringBuilder(30).append("Unsupported long logical type ").append(avroSchema.getLogicalType().getName()).toString());
                return right.map((Function1 & Serializable)result -> result);
            }
            if (Schema.Type.FLOAT.equals(type)) {
                right = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.FloatType$.MODULE$));
                return right.map((Function1 & Serializable)result -> result);
            }
            if (Schema.Type.DOUBLE.equals(type)) {
                right = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.DoubleType$.MODULE$));
                return right.map((Function1 & Serializable)result -> result);
            }
            if (Schema.Type.BOOLEAN.equals(type)) {
                right = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.BoolType$.MODULE$));
                return right.map((Function1 & Serializable)result -> result);
            }
            if (Schema.Type.NULL.equals(type)) {
                right = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.UnitType$.MODULE$));
                return right.map((Function1 & Serializable)result -> result);
            }
            if (type != null) throw new MatchError((Object)type);
            right = package$.MODULE$.Left().apply((Object)new StringBuilder(17).append("Unsupported type ").append(avroSchema.getType()).toString());
            return right.map((Function1 & Serializable)result -> result);
        });
    }

    @Override
    public org.apache.avro.Schema toAvroBinary(Schema<?> schema) {
        return (org.apache.avro.Schema)schema.annotations().collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                AvroAnnotations.BytesType bytesType;
                if (x1 instanceof AvroAnnotations.bytes && (bytesType = ((AvroAnnotations.bytes)x1).bytesType()) instanceof AvroAnnotations.BytesType.Fixed) {
                    AvroAnnotations.BytesType.Fixed fixed = (AvroAnnotations.BytesType.Fixed)bytesType;
                    int size = fixed.size();
                    String name2 = fixed.name();
                    String doc2 = fixed.doc();
                    String space = fixed.space();
                    return (B1)org.apache.avro.Schema.createFixed((String)name2, (String)doc2, (String)space, (int)size);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                return x1 instanceof AvroAnnotations.bytes && ((AvroAnnotations.bytes)x1).bytesType() instanceof AvroAnnotations.BytesType.Fixed;
            }
        }).getOrElse((Function0 & Serializable)() -> org.apache.avro.Schema.create((Schema.Type)Schema.Type.BYTES));
    }

    private Seq<Schema.Field<MonthDay, Object>> monthDayStructure$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 1) == 0) {
                Schema.Primitive x$2 = new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2());
                Function1 & Serializable x$3 = (Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.getMonthValue());
                Function2 & Serializable x$4 = (Function2 & Serializable)(a, b) -> a.with(Month.of(BoxesRunTime.unboxToInt((Object)b)));
                Chunk x$5 = Schema.Field$.MODULE$.apply$default$3();
                Validation x$6 = Schema.Field$.MODULE$.apply$default$4();
                Schema.Primitive x$8 = new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2());
                Function1 & Serializable x$9 = (Function1 & Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.getDayOfMonth());
                Function2 & Serializable x$10 = (Function2 & Serializable)(a, b) -> a.withDayOfMonth(BoxesRunTime.unboxToInt((Object)b));
                Chunk x$11 = Schema.Field$.MODULE$.apply$default$3();
                Validation x$12 = Schema.Field$.MODULE$.apply$default$4();
                monthDayStructure = new .colon.colon((Object)Schema.Field$.MODULE$.apply("month", (Schema)x$2, x$5, x$6, (Function1)x$3, (Function2)x$4), (List)new .colon.colon((Object)Schema.Field$.MODULE$.apply("day", (Schema)x$8, x$11, x$12, (Function1)x$9, (Function2)x$10), (List)Nil$.MODULE$));
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return monthDayStructure;
    }

    public Seq<Schema.Field<MonthDay, Object>> monthDayStructure() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.monthDayStructure$lzycompute();
        }
        return monthDayStructure;
    }

    private Seq<Schema.Field<Period, Object>> periodStructure$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 2) == 0) {
                Schema.Primitive x$2 = new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2());
                Function1 & Serializable x$3 = (Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18.getYears());
                Function2 & Serializable x$4 = (Function2 & Serializable)(a, b) -> a.withYears(BoxesRunTime.unboxToInt((Object)b));
                Chunk x$5 = Schema.Field$.MODULE$.apply$default$3();
                Validation x$6 = Schema.Field$.MODULE$.apply$default$4();
                Schema.Primitive x$8 = new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2());
                Function1 & Serializable x$9 = (Function1 & Serializable)x$19 -> BoxesRunTime.boxToInteger((int)x$19.getMonths());
                Function2 & Serializable x$10 = (Function2 & Serializable)(a, b) -> a.withMonths(BoxesRunTime.unboxToInt((Object)b));
                Chunk x$11 = Schema.Field$.MODULE$.apply$default$3();
                Validation x$12 = Schema.Field$.MODULE$.apply$default$4();
                Schema.Primitive x$14 = new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2());
                Function1 & Serializable x$15 = (Function1 & Serializable)x$20 -> BoxesRunTime.boxToInteger((int)x$20.getDays());
                Function2 & Serializable x$16 = (Function2 & Serializable)(a, b) -> a.withDays(BoxesRunTime.unboxToInt((Object)b));
                Chunk x$17 = Schema.Field$.MODULE$.apply$default$3();
                Validation x$182 = Schema.Field$.MODULE$.apply$default$4();
                periodStructure = new .colon.colon((Object)Schema.Field$.MODULE$.apply("years", (Schema)x$2, x$5, x$6, (Function1)x$3, (Function2)x$4), (List)new .colon.colon((Object)Schema.Field$.MODULE$.apply("months", (Schema)x$8, x$11, x$12, (Function1)x$9, (Function2)x$10), (List)new .colon.colon((Object)Schema.Field$.MODULE$.apply("days", (Schema)x$14, x$17, x$182, (Function1)x$15, (Function2)x$16), (List)Nil$.MODULE$)));
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return periodStructure;
    }

    public Seq<Schema.Field<Period, Object>> periodStructure() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.periodStructure$lzycompute();
        }
        return periodStructure;
    }

    private Seq<Schema.Field<YearMonth, Object>> yearMonthStructure$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 4) == 0) {
                Schema.Primitive x$2 = new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2());
                Function1 & Serializable x$3 = (Function1 & Serializable)x$21 -> BoxesRunTime.boxToInteger((int)x$21.getYear());
                Function2 & Serializable x$4 = (Function2 & Serializable)(a, b) -> a.with(Year.of(BoxesRunTime.unboxToInt((Object)b)));
                Chunk x$5 = Schema.Field$.MODULE$.apply$default$3();
                Validation x$6 = Schema.Field$.MODULE$.apply$default$4();
                Schema.Primitive x$8 = new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2());
                Function1 & Serializable x$9 = (Function1 & Serializable)x$22 -> BoxesRunTime.boxToInteger((int)x$22.getMonthValue());
                Function2 & Serializable x$10 = (Function2 & Serializable)(a, b) -> a.with(Month.of(BoxesRunTime.unboxToInt((Object)b)));
                Chunk x$11 = Schema.Field$.MODULE$.apply$default$3();
                Validation x$12 = Schema.Field$.MODULE$.apply$default$4();
                yearMonthStructure = new .colon.colon((Object)Schema.Field$.MODULE$.apply("year", (Schema)x$2, x$5, x$6, (Function1)x$3, (Function2)x$4), (List)new .colon.colon((Object)Schema.Field$.MODULE$.apply("month", (Schema)x$8, x$11, x$12, (Function1)x$9, (Function2)x$10), (List)Nil$.MODULE$));
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return yearMonthStructure;
    }

    public Seq<Schema.Field<YearMonth, Object>> yearMonthStructure() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.yearMonthStructure$lzycompute();
        }
        return yearMonthStructure;
    }

    private Seq<Schema.Field<Duration, ?>> durationStructure$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 8) == 0) {
                Schema.Primitive x$2 = new Schema.Primitive((StandardType)StandardType.LongType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2());
                Function1 & Serializable x$3 = (Function1 & Serializable)x$23 -> BoxesRunTime.boxToLong((long)x$23.getSeconds());
                Function2 & Serializable x$4 = (Function2 & Serializable)(a, b) -> a.plusSeconds(BoxesRunTime.unboxToLong((Object)b));
                Chunk x$5 = Schema.Field$.MODULE$.apply$default$3();
                Validation x$6 = Schema.Field$.MODULE$.apply$default$4();
                Schema.Primitive x$8 = new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2());
                Function1 & Serializable x$9 = (Function1 & Serializable)x$24 -> BoxesRunTime.boxToInteger((int)x$24.getNano());
                Function2 & Serializable x$10 = (Function2 & Serializable)(a, b) -> a.plusNanos(BoxesRunTime.unboxToInt((Object)b));
                Chunk x$11 = Schema.Field$.MODULE$.apply$default$3();
                Validation x$12 = Schema.Field$.MODULE$.apply$default$4();
                durationStructure = new .colon.colon((Object)Schema.Field$.MODULE$.apply("seconds", (Schema)x$2, x$5, x$6, (Function1)x$3, (Function2)x$4), (List)new .colon.colon((Object)Schema.Field$.MODULE$.apply("nanos", (Schema)x$8, x$11, x$12, (Function1)x$9, (Function2)x$10), (List)Nil$.MODULE$));
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        return durationStructure;
    }

    public Seq<Schema.Field<Duration, ?>> durationStructure() {
        if ((byte)(bitmap$0 & 8) == 0) {
            return this.durationStructure$lzycompute();
        }
        return durationStructure;
    }

    private Either<String, org.apache.avro.Schema> toAvroSchema(Schema<?> schema) {
        while (true) {
            if (schema instanceof Schema.Enum) {
                Schema.Enum enum_ = (Schema.Enum)schema;
                return this.toAvroEnum(enum_);
            }
            if (schema instanceof Schema.Record) {
                Schema.Record record = (Schema.Record)schema;
                return this.toAvroRecord(record);
            }
            if (schema instanceof Schema.Map) {
                Schema.Map map = (Schema.Map)schema;
                return this.toAvroMap(map);
            }
            if (schema instanceof Schema.Sequence) {
                Schema.Sequence sequence = (Schema.Sequence)schema;
                return this.toAvroSchema(sequence.elementSchema()).map((Function1 & Serializable)elementType -> org.apache.avro.Schema.createArray((org.apache.avro.Schema)elementType));
            }
            if (schema instanceof Schema.Set) {
                Schema.Set set = (Schema.Set)schema;
                return this.toAvroSchema(set.elementSchema()).map((Function1 & Serializable)elementType -> org.apache.avro.Schema.createArray((org.apache.avro.Schema)elementType));
            }
            if (schema instanceof Schema.Transform) {
                schema = ((Schema.Transform)schema).schema();
                continue;
            }
            if (schema instanceof Schema.Primitive) {
                StandardType standardType = ((Schema.Primitive)schema).standardType();
                if (StandardType.UnitType$.MODULE$.equals(standardType)) {
                    return new Right((Object)org.apache.avro.Schema.create((Schema.Type)Schema.Type.NULL));
                }
                if (StandardType.StringType$.MODULE$.equals(standardType)) {
                    return new Right((Object)org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING));
                }
                if (StandardType.BoolType$.MODULE$.equals(standardType)) {
                    return new Right((Object)org.apache.avro.Schema.create((Schema.Type)Schema.Type.BOOLEAN));
                }
                if (StandardType.ShortType$.MODULE$.equals(standardType)) {
                    return new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT)).addMarkerProp(new AvroPropMarker.IntDiscriminator(IntType$Short$.MODULE$)));
                }
                if (StandardType.ByteType$.MODULE$.equals(standardType)) {
                    return new Right((Object)org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT));
                }
                if (StandardType.IntType$.MODULE$.equals(standardType)) {
                    return new Right((Object)org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT));
                }
                if (StandardType.LongType$.MODULE$.equals(standardType)) {
                    return new Right((Object)org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG));
                }
                if (StandardType.FloatType$.MODULE$.equals(standardType)) {
                    return new Right((Object)org.apache.avro.Schema.create((Schema.Type)Schema.Type.FLOAT));
                }
                if (StandardType.DoubleType$.MODULE$.equals(standardType)) {
                    return new Right((Object)org.apache.avro.Schema.create((Schema.Type)Schema.Type.DOUBLE));
                }
                if (StandardType.BinaryType$.MODULE$.equals(standardType)) {
                    return new Right((Object)this.toAvroBinary(schema));
                }
                if (StandardType.CharType$.MODULE$.equals(standardType)) {
                    return new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT)).addMarkerProp(new AvroPropMarker.IntDiscriminator(IntType$Char$.MODULE$)));
                }
                if (StandardType.UUIDType$.MODULE$.equals(standardType)) {
                    return new Right((Object)LogicalTypes.uuid().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)));
                }
                if (StandardType.BigDecimalType$.MODULE$.equals(standardType)) {
                    return this.toAvroDecimal(schema);
                }
                if (StandardType.BigIntegerType$.MODULE$.equals(standardType)) {
                    return this.toAvroDecimal(schema);
                }
                if (StandardType.DayOfWeekType$.MODULE$.equals(standardType)) {
                    return new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT)).addMarkerProp(new AvroPropMarker.IntDiscriminator(IntType$DayOfWeek$.MODULE$)));
                }
                if (StandardType.MonthType$.MODULE$.equals(standardType)) {
                    return new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT)).addMarkerProp(new AvroPropMarker.IntDiscriminator(IntType$Month$.MODULE$)));
                }
                if (StandardType.YearType$.MODULE$.equals(standardType)) {
                    return new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT)).addMarkerProp(new AvroPropMarker.IntDiscriminator(IntType$Year$.MODULE$)));
                }
                if (StandardType.ZoneIdType$.MODULE$.equals(standardType)) {
                    return new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.StringDiscriminator(StringType$ZoneId$.MODULE$)));
                }
                if (StandardType.ZoneOffsetType$.MODULE$.equals(standardType)) {
                    return new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT)).addMarkerProp(new AvroPropMarker.IntDiscriminator(IntType$ZoneOffset$.MODULE$)));
                }
                if (StandardType.MonthDayType$.MODULE$.equals(standardType)) {
                    return new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.RecordDiscriminator(RecordType$MonthDay$.MODULE$)));
                }
                if (StandardType.PeriodType$.MODULE$.equals(standardType)) {
                    return new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.RecordDiscriminator(RecordType$Period$.MODULE$)));
                }
                if (StandardType.YearMonthType$.MODULE$.equals(standardType)) {
                    return new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.RecordDiscriminator(RecordType$YearMonth$.MODULE$)));
                }
                if (StandardType.DurationType$.MODULE$.equals(standardType)) {
                    return new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.RecordDiscriminator(RecordType$Duration$.MODULE$)));
                }
                if (StandardType.InstantType$.MODULE$.equals(standardType)) {
                    return new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.StringDiscriminator(StringType$Instant$.MODULE$)));
                }
                if (StandardType.LocalDateType$.MODULE$.equals(standardType)) {
                    return new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.StringDiscriminator(StringType$LocalDate$.MODULE$)));
                }
                if (StandardType.LocalTimeType$.MODULE$.equals(standardType)) {
                    return new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.StringDiscriminator(StringType$LocalTime$.MODULE$)));
                }
                if (StandardType.LocalDateTimeType$.MODULE$.equals(standardType)) {
                    return new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.StringDiscriminator(StringType$LocalDateTime$.MODULE$)));
                }
                if (StandardType.OffsetTimeType$.MODULE$.equals(standardType)) {
                    return new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.StringDiscriminator(StringType$OffsetTime$.MODULE$)));
                }
                if (StandardType.OffsetDateTimeType$.MODULE$.equals(standardType)) {
                    return new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.StringDiscriminator(StringType$OffsetDateTime$.MODULE$)));
                }
                if (StandardType.ZonedDateTimeType$.MODULE$.equals(standardType)) {
                    return new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.StringDiscriminator(StringType$ZoneDateTime$.MODULE$)));
                }
                throw new MatchError((Object)standardType);
            }
            if (schema instanceof Schema.Optional) {
                Schema codec = ((Schema.Optional)schema).schema();
                return this.getName(codec).flatMap((Function1 & Serializable)codecName -> MODULE$.toAvroSchema(codec).map(arg_0 -> AvroSchemaCodec$.$anonfun$toAvroSchema$4(codecName, arg_0)).map((Function1 & Serializable)x$25 -> {
                    if (x$25 != null) {
                        org.apache.avro.Schema wrappedAvroSchema = (org.apache.avro.Schema)x$25._2();
                        return org.apache.avro.Schema.createUnion((org.apache.avro.Schema[])new org.apache.avro.Schema[]{org.apache.avro.Schema.create((Schema.Type)Schema.Type.NULL), wrappedAvroSchema});
                    }
                    throw new MatchError(null);
                }));
            }
            if (schema instanceof Schema.Fail) {
                String message = ((Schema.Fail)schema).message();
                return package$.MODULE$.Left().apply((Object)message);
            }
            if (schema instanceof Schema.Tuple2) {
                Schema.Tuple2 tuple2 = (Schema.Tuple2)schema;
                return this.toAvroSchema((Schema<?>)tuple2.toRecord()).map((Function1 & Serializable)x$26 -> MODULE$.SchemaAvroExtensions((org.apache.avro.Schema)x$26).addMarkerProp(new AvroPropMarker.RecordDiscriminator(RecordType$Tuple$.MODULE$)));
            }
            if (schema instanceof Schema.Either) {
                Schema.Either either = (Schema.Either)schema;
                Schema left = either.left();
                Schema right = either.right();
                return this.toAvroSchema(left).flatMap((Function1 & Serializable)l -> MODULE$.toAvroSchema(right).flatMap((Function1 & Serializable)r -> MODULE$.getName(left).flatMap((Function1 & Serializable)lname -> MODULE$.getName(right).map((Function1 & Serializable)rname -> {
                    Schema.Type type = l.getType();
                    Schema.Type type2 = Schema.Type.UNION;
                    org.apache.avro.Schema leftSchema = !(type != null ? !type.equals(type2) : type2 != null) ? MODULE$.wrapAvro((org.apache.avro.Schema)l, (String)lname, AvroPropMarker$UnionWrapper$.MODULE$) : l;
                    Schema.Type type3 = r.getType();
                    Schema.Type type4 = Schema.Type.UNION;
                    org.apache.avro.Schema rightSchema = !(type3 != null ? !type3.equals(type4) : type4 != null) ? MODULE$.wrapAvro((org.apache.avro.Schema)r, (String)rname, AvroPropMarker$UnionWrapper$.MODULE$) : r;
                    return new Tuple3(rname, (Object)leftSchema, (Object)rightSchema);
                }).flatMap((Function1 & Serializable)x$28 -> {
                    if (x$28 != null) {
                        org.apache.avro.Schema leftSchema = (org.apache.avro.Schema)x$28._2();
                        org.apache.avro.Schema rightSchema = (org.apache.avro.Schema)x$28._3();
                        String string = leftSchema.getFullName();
                        String string2 = rightSchema.getFullName();
                        return (!(string != null ? !string.equals(string2) : string2 != null) ? package$.MODULE$.Left().apply((Object)new StringBuilder(64).append("Left and right schemas of either must have different fullnames: ").append(leftSchema.getFullName()).toString()) : new Right((Object)BoxedUnit.UNIT)).map((Function1 & Serializable)x$27 -> org.apache.avro.Schema.createUnion((org.apache.avro.Schema[])new org.apache.avro.Schema[]{leftSchema, rightSchema}));
                    }
                    throw new MatchError(null);
                })))).flatMap((Function1 & Serializable)union -> MODULE$.getName((Schema<?>)either).map((Function1 & Serializable)name2 -> MODULE$.wrapAvro((org.apache.avro.Schema)union, (String)name2, AvroPropMarker$EitherWrapper$.MODULE$)));
            }
            if (schema instanceof Schema.Fallback) {
                Schema.Fallback fallback = (Schema.Fallback)schema;
                Schema left = fallback.left();
                Schema right = fallback.right();
                schema = new Schema.Tuple2((Schema)new Schema.Optional(left, Schema.Optional$.MODULE$.apply$default$2()), (Schema)new Schema.Optional(right, Schema.Optional$.MODULE$.apply$default$2()), Schema.Tuple2$.MODULE$.apply$default$3());
                continue;
            }
            if (schema instanceof Schema.Lazy) {
                schema = (Schema)((Schema.Lazy)schema).schema0$access$0().apply();
                continue;
            }
            if (!(schema instanceof Schema.Dynamic)) break;
            schema = Schema$.MODULE$.apply(ExtensibleMetaSchema$.MODULE$.schema(SchemaInstances$.MODULE$.instancesCons(Schema$.MODULE$.dynamicValue(), SchemaInstances$.MODULE$.instancesEnd())));
        }
        throw new MatchError((Object)schema);
    }

    private boolean hasFormatToStringAnnotation(Chunk<Object> value) {
        return value.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AvroSchemaCodec$.$anonfun$hasFormatToStringAnnotation$1(x0$1)));
    }

    private Option<AvroAnnotations.TimePrecisionType> getTimeprecisionType(Chunk<Object> value) {
        return value.collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof AvroAnnotations.timeprecision) {
                    return (B1)((AvroAnnotations.timeprecision)x1).timeprecisionType();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                return x1 instanceof AvroAnnotations.timeprecision;
            }
        });
    }

    public Either<String, org.apache.avro.Schema> toAvroInstant(DateTimeFormatter formatter, Chunk<Object> annotations) {
        if (this.hasFormatToStringAnnotation(annotations)) {
            return new Right((Object)this.SchemaAvroExtensions(this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.StringDiscriminator(StringType$Instant$.MODULE$))).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
        }
        org.apache.avro.Schema baseSchema = org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG);
        AvroAnnotations.TimePrecisionType timePrecisionType = (AvroAnnotations.TimePrecisionType)this.getTimeprecisionType(annotations).getOrElse((Function0 & Serializable)() -> AvroAnnotations$TimePrecisionType$.MODULE$.default());
        if (AvroAnnotations$TimePrecisionType$Millis$.MODULE$.equals(timePrecisionType)) {
            return new Right((Object)this.SchemaAvroExtensions(LogicalTypes.timestampMillis().addToSchema(baseSchema)).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
        }
        if (AvroAnnotations$TimePrecisionType$Micros$.MODULE$.equals(timePrecisionType)) {
            return new Right((Object)this.SchemaAvroExtensions(LogicalTypes.timestampMicros().addToSchema(baseSchema)).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
        }
        throw new MatchError((Object)timePrecisionType);
    }

    public Either<String, org.apache.avro.Schema> toAvroLocalDate(DateTimeFormatter formatter, Chunk<Object> annotations) {
        if (this.hasFormatToStringAnnotation(annotations)) {
            return new Right((Object)this.SchemaAvroExtensions(this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.StringDiscriminator(StringType$LocalDate$.MODULE$))).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
        }
        return new Right((Object)this.SchemaAvroExtensions(LogicalTypes.date().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT))).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
    }

    public Either<String, org.apache.avro.Schema> toAvroLocalTime(DateTimeFormatter formatter, Chunk<Object> annotations) {
        if (this.hasFormatToStringAnnotation(annotations)) {
            return new Right((Object)this.SchemaAvroExtensions(this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.StringDiscriminator(StringType$LocalTime$.MODULE$))).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
        }
        AvroAnnotations.TimePrecisionType timePrecisionType = (AvroAnnotations.TimePrecisionType)this.getTimeprecisionType(annotations).getOrElse((Function0 & Serializable)() -> AvroAnnotations$TimePrecisionType$.MODULE$.default());
        if (AvroAnnotations$TimePrecisionType$Millis$.MODULE$.equals(timePrecisionType)) {
            return new Right((Object)this.SchemaAvroExtensions(LogicalTypes.timeMillis().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT))).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
        }
        if (AvroAnnotations$TimePrecisionType$Micros$.MODULE$.equals(timePrecisionType)) {
            return new Right((Object)this.SchemaAvroExtensions(LogicalTypes.timeMicros().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG))).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
        }
        throw new MatchError((Object)timePrecisionType);
    }

    public Either<String, org.apache.avro.Schema> toAvroLocalDateTime(DateTimeFormatter formatter, Chunk<Object> annotations) {
        if (this.hasFormatToStringAnnotation(annotations)) {
            return new Right((Object)this.SchemaAvroExtensions(this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.StringDiscriminator(StringType$LocalDateTime$.MODULE$))).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
        }
        org.apache.avro.Schema baseSchema = org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG);
        AvroAnnotations.TimePrecisionType timePrecisionType = (AvroAnnotations.TimePrecisionType)this.getTimeprecisionType(annotations).getOrElse((Function0 & Serializable)() -> AvroAnnotations$TimePrecisionType$.MODULE$.default());
        if (AvroAnnotations$TimePrecisionType$Millis$.MODULE$.equals(timePrecisionType)) {
            return new Right((Object)this.SchemaAvroExtensions(LogicalTypes.localTimestampMillis().addToSchema(baseSchema)).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
        }
        if (AvroAnnotations$TimePrecisionType$Micros$.MODULE$.equals(timePrecisionType)) {
            return new Right((Object)this.SchemaAvroExtensions(LogicalTypes.localTimestampMicros().addToSchema(baseSchema)).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
        }
        throw new MatchError((Object)timePrecisionType);
    }

    @Override
    public boolean hasAvroEnumAnnotation(Chunk<Object> annotations) {
        return annotations.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AvroSchemaCodec$.$anonfun$hasAvroEnumAnnotation$1(x0$1)));
    }

    @Override
    public org.apache.avro.Schema wrapAvro(org.apache.avro.Schema schemaAvro, String name2, AvroPropMarker marker) {
        Schema.Field field = new Schema.Field("value", schemaAvro);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(field);
        String prefixedName = new StringBuilder(1).append(AvroPropMarker$.MODULE$.wrapperNamePrefix()).append("_").append(name2).toString();
        return this.SchemaAvroExtensions(org.apache.avro.Schema.createRecord((String)prefixedName, null, (String)AvroPropMarker$.MODULE$.wrapperNamespace(), (boolean)false, fields)).addMarkerProp(marker);
    }

    public Either<String, org.apache.avro.Schema> toAvroEnum(Schema.Enum<?> enu) {
        boolean avroEnumAnnotationExists = this.hasAvroEnumAnnotation((Chunk<Object>)enu.annotations());
        if (enu.cases().map((Function1 & Serializable)x$29 -> x$29.schema()).forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AvroSchemaCodec$.$anonfun$toAvroEnum$2(avroEnumAnnotationExists, x0$1)))) {
            return this.getName((Schema<?>)enu).map((Function1 & Serializable)name2 -> {
                String doc2 = (String)MODULE$.getDoc((Chunk<Object>)enu.annotations()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                return new Tuple2(name2, (Object)doc2);
            }).flatMap((Function1 & Serializable)x$31 -> {
                if (x$31 != null) {
                    String name2 = (String)x$31._1();
                    String doc2 = (String)x$31._2();
                    return MODULE$.getNamespace((Chunk<Object>)enu.annotations()).map((Function1 & Serializable)namespaceOption -> {
                        List symbols = enu.cases().map((Function1 & Serializable)x0$2 -> (String)MODULE$.getNameOption((Chunk<Object>)x0$2.annotations()).getOrElse((Function0 & Serializable)() -> x0$2.id())).toList();
                        org.apache.avro.Schema result = org.apache.avro.Schema.createEnum((String)name2, (String)doc2, (String)((String)namespaceOption.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)symbols).asJava());
                        return new Tuple3(namespaceOption, (Object)symbols, (Object)result);
                    }).map((Function1 & Serializable)x$30 -> {
                        if (x$30 != null) {
                            return (org.apache.avro.Schema)x$30._3();
                        }
                        throw new MatchError(null);
                    });
                }
                throw new MatchError(null);
            });
        }
        Tuple2 tuple2 = enu.cases().map((Function1 & Serializable)c -> new Tuple2((Object)c.id(), (Object)new Tuple2((Object)c.schema(), (Object)c.annotations()))).map((Function1 & Serializable)x0$3 -> {
            if (x0$3 != null) {
                String symbol = (String)x0$3._1();
                Tuple2 tuple2 = (Tuple2)x0$3._2();
                if (tuple2 != null) {
                    Schema schema;
                    Schema schema2 = (Schema)tuple2._1();
                    Chunk annotations = (Chunk)tuple2._2();
                    if (schema2 instanceof Schema.Transform && (schema = ((Schema.Transform)schema2).schema()) instanceof Schema.Primitive) {
                        StandardType standardType = ((Schema.Primitive)schema).standardType();
                        StandardType.UnitType$ unitType$ = StandardType.UnitType$.MODULE$;
                        if (standardType != null && standardType.equals(unitType$)) {
                            String name2 = (String)MODULE$.getNameOption((Chunk<Object>)annotations).getOrElse((Function0 & Serializable)() -> symbol);
                            return new Right((Object)org.apache.avro.Schema.createRecord((String)name2, null, null, (boolean)false, new ArrayList()));
                        }
                    }
                }
            }
            if (x0$3 != null) {
                String symbol = (String)x0$3._1();
                Tuple2 tuple2 = (Tuple2)x0$3._2();
                if (tuple2 != null) {
                    Schema.CaseClass0 caseClass0;
                    Schema schema = (Schema)tuple2._1();
                    Chunk annotations = (Chunk)tuple2._2();
                    if (schema instanceof Schema.CaseClass0 && !Schema.CaseClass0$.MODULE$.unapply(caseClass0 = (Schema.CaseClass0)schema).isEmpty()) {
                        String name3 = (String)MODULE$.getNameOption((Chunk<Object>)annotations).getOrElse((Function0 & Serializable)() -> symbol);
                        return new Right((Object)org.apache.avro.Schema.createRecord((String)name3, null, null, (boolean)false, new ArrayList()));
                    }
                }
            }
            if (x0$3 != null) {
                String symbol = (String)x0$3._1();
                Tuple2 tuple2 = (Tuple2)x0$3._2();
                if (tuple2 != null) {
                    Schema schema = (Schema)tuple2._1();
                    Chunk annotations = (Chunk)tuple2._2();
                    String name4 = (String)MODULE$.getNameOption((Chunk<Object>)annotations).getOrElse((Function0 & Serializable)() -> symbol);
                    Schema<?> schemaWithName = MODULE$.addNameAnnotationIfMissing(schema, name4);
                    return MODULE$.toAvroSchema(schemaWithName).map((Function1 & Serializable)x0$4 -> {
                        if (x0$4 != null) {
                            Schema.Type type = x0$4.getType();
                            Schema.Type type2 = Schema.Type.UNION;
                            if (!(type != null ? !type.equals(type2) : type2 != null)) {
                                return MODULE$.wrapAvro((org.apache.avro.Schema)x0$4, name4, AvroPropMarker$UnionWrapper$.MODULE$);
                            }
                        }
                        return x0$4;
                    });
                }
            }
            throw new MatchError(x0$3);
        }).toList().map((Function1 & Serializable)x$32 -> Either.MergeableEither$.MODULE$.merge$extension(Either$.MODULE$.MergeableEither(x$32))).partition((Function1 & Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)AvroSchemaCodec$.$anonfun$toAvroEnum$16(x0$5)));
        if (tuple2 != null) {
            List list = (List)tuple2._1();
            List right = (List)tuple2._2();
            if (Nil$.MODULE$.equals(list) && right instanceof List) {
                return new Right((Object)org.apache.avro.Schema.createUnion((java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)right).asJava()));
            }
        }
        if (tuple2 != null) {
            List left = (List)tuple2._1();
            return package$.MODULE$.Left().apply((Object)left.mkString("\n"));
        }
        throw new MatchError(null);
    }

    private List<Schema.Field> extractAvroFields(Schema.Record<?> record) {
        Tuple2 tuple2 = record.fields().map((Function1 & Serializable)value -> MODULE$.toAvroRecordField((Schema.Field)value)).toList().map((Function1 & Serializable)x$33 -> Either.MergeableEither$.MODULE$.merge$extension(Either$.MODULE$.MergeableEither(x$33))).partition((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AvroSchemaCodec$.$anonfun$extractAvroFields$3(x0$1)));
        if (tuple2 != null) {
            List list = (List)tuple2._1();
            List right = (List)tuple2._2();
            if (Nil$.MODULE$.equals(list) && right instanceof List) {
                return right;
            }
        }
        return null;
    }

    public Either<String, org.apache.avro.Schema> toAvroRecord(Schema.Record<?> record) {
        return this.getName((Schema<?>)record).flatMap((Function1 & Serializable)name2 -> MODULE$.getNamespace((Chunk<Object>)record.annotations()).flatMap((Function1 & Serializable)namespaceOption -> new Right((Object)org.apache.avro.Schema.createRecord((String)name2, (String)((String)MODULE$.getDoc((Chunk<Object>)record.annotations()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (String)((String)namespaceOption.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (boolean)MODULE$.isErrorRecord(record), (java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava(MODULE$.extractAvroFields(record)).asJava())).map((Function1 & Serializable)result -> result)));
    }

    public Either<String, org.apache.avro.Schema> toAvroMap(Schema.Map<?, ?> map) {
        Schema schema = map.keySchema();
        if (schema instanceof Schema.Primitive) {
            StandardType standardType = ((Schema.Primitive)schema).standardType();
            StandardType.StringType$ stringType$ = StandardType.StringType$.MODULE$;
            if (standardType != null && standardType.equals(stringType$)) {
                return this.toAvroSchema(map.valueSchema()).map((Function1 & Serializable)valueType -> org.apache.avro.Schema.createMap((org.apache.avro.Schema)valueType));
            }
        }
        Schema.Tuple2 tupleSchema = new Schema.Tuple2(map.keySchema(), map.valueSchema(), Schema.Tuple2$.MODULE$.apply$default$3()).annotate((Object)new AvroAnnotations.name("Tuple")).annotate((Object)new AvroAnnotations.namespace("scala"));
        return this.toAvroSchema((Schema<?>)tupleSchema).map((Function1 & Serializable)elementType -> org.apache.avro.Schema.createArray((org.apache.avro.Schema)elementType));
    }

    public Either<String, org.apache.avro.Schema> toAvroDecimal(Schema<?> schema) {
        Right right;
        StandardType standardType;
        int scale2 = BoxesRunTime.unboxToInt((Object)schema.annotations().collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof AvroAnnotations.scale) {
                    return (B1)BoxesRunTime.boxToInteger((int)((AvroAnnotations.scale)x1).scale());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                return x1 instanceof AvroAnnotations.scale;
            }
        }).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> new AvroAnnotations.scale(AvroAnnotations$scale$.MODULE$.apply$default$1()).scale()));
        int precision2 = schema instanceof Schema.Primitive && StandardType.BigDecimalType$.MODULE$.equals(standardType = ((Schema.Primitive)schema).standardType()) ? BoxesRunTime.unboxToInt((Object)schema.annotations().collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                if (x2 instanceof AvroAnnotations.precision) {
                    return (B1)BoxesRunTime.boxToInteger((int)((AvroAnnotations.precision)x2).precision());
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Object x2) {
                return x2 instanceof AvroAnnotations.precision;
            }
        }).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Math.max(scale2, new AvroAnnotations.precision(AvroAnnotations$precision$.MODULE$.apply$default$1()).precision()))) : scale2;
        AvroAnnotations.DecimalType decimalType = (AvroAnnotations.DecimalType)schema.annotations().collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                if (x3 instanceof AvroAnnotations.decimal) {
                    return (B1)((AvroAnnotations.decimal)x3).decimalType();
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(Object x3) {
                return x3 instanceof AvroAnnotations.decimal;
            }
        }).getOrElse((Function0 & Serializable)() -> AvroAnnotations$DecimalType$.MODULE$.default());
        if (decimalType instanceof AvroAnnotations.DecimalType.Fixed) {
            int size = ((AvroAnnotations.DecimalType.Fixed)decimalType).size();
            right = this.getNamespace((Chunk<Object>)schema.annotations()).map((Function1 & Serializable)namespaceOption -> {
                String name2 = (String)MODULE$.getNameOption((Chunk<Object>)schema.annotations()).getOrElse((Function0 & Serializable)() -> new StringBuilder(9).append("Decimal_").append(precision2).append("_").append(scale2).toString());
                String doc2 = (String)MODULE$.getDoc((Chunk<Object>)schema.annotations()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                org.apache.avro.Schema result = org.apache.avro.Schema.createFixed((String)name2, (String)doc2, (String)((String)namespaceOption.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (int)size);
                return new Tuple4(namespaceOption, (Object)name2, (Object)doc2, (Object)result);
            }).map((Function1 & Serializable)x$34 -> {
                if (x$34 != null) {
                    return (org.apache.avro.Schema)x$34._4();
                }
                throw new MatchError(null);
            });
        } else if (AvroAnnotations$DecimalType$Bytes$.MODULE$.equals(decimalType)) {
            right = new Right((Object)org.apache.avro.Schema.create((Schema.Type)Schema.Type.BYTES));
        } else {
            throw new MatchError((Object)decimalType);
        }
        return right.map((Function1 & Serializable)x$35 -> LogicalTypes.decimal((int)precision2, (int)scale2).addToSchema(x$35));
    }

    public String toErrorMessage(Throwable err, Object at) {
        return new StringBuilder(41).append("Error mapping to Apache Avro schema: ").append(err).append(" at ").append(at.toString()).toString();
    }

    public <Z> Either<String, Schema.Field> toAvroRecordField(Schema.Field<Z, ?> value) {
        return this.toAvroSchema(value.schema()).map((Function1 & Serializable)schema -> new Schema.Field((String)MODULE$.getNameOption((Chunk<Object>)value.annotations()).getOrElse((Function0 & Serializable)() -> value.name()), schema, (String)MODULE$.getDoc((Chunk<Object>)value.annotations()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), MODULE$.getDefault((Chunk<Object>)value.annotations()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Schema.Field.Order)MODULE$.getFieldOrder((Chunk<Object>)value.annotations()).map((Function1 & Serializable)x$36 -> x$36.toAvroOrder()).getOrElse((Function0 & Serializable)() -> AvroAnnotations$FieldOrderType$.MODULE$.default().toAvroOrder())));
    }

    public Option<AvroAnnotations.FieldOrderType> getFieldOrder(Chunk<Object> annotations) {
        return annotations.collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof AvroAnnotations.fieldOrder) {
                    return (B1)((AvroAnnotations.fieldOrder)x1).fieldOrderType();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                return x1 instanceof AvroAnnotations.fieldOrder;
            }
        });
    }

    public Either<String, String> getName(Schema<?> schema) {
        Regex validNameRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[A-Za-z_][A-Za-z0-9_]*"));
        Option option = schema.annotations().collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof AvroAnnotations.name) {
                    return (B1)((AvroAnnotations.name)x1).name();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                return x1 instanceof AvroAnnotations.name;
            }
        });
        if (option instanceof Some) {
            Option option2;
            String s = (String)((Some)option).value();
            if (s != null && !(option2 = validNameRegex.unapplySeq((CharSequence)s)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(0) == 0) {
                return new Right((Object)s);
            }
            return package$.MODULE$.Left().apply((Object)new StringBuilder(19).append("Invalid Avro name: ").append(s).toString());
        }
        if (None$.MODULE$.equals(option)) {
            if (schema instanceof Schema.Record) {
                Schema.Record record = (Schema.Record)schema;
                return new Right((Object)record.id().name());
            }
            if (schema instanceof Schema.Enum) {
                Schema.Enum enum_ = (Schema.Enum)schema;
                return new Right((Object)enum_.id().name());
            }
            return new Right((Object)new StringBuilder(7).append("hashed_").append(Integer.toString(schema.ast().toString().hashCode()).replaceFirst("-", "n")).toString());
        }
        throw new MatchError((Object)option);
    }

    public Option<String> getNameOption(Chunk<Object> annotations) {
        return annotations.collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof AvroAnnotations.name) {
                    return (B1)((AvroAnnotations.name)x1).name();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                return x1 instanceof AvroAnnotations.name;
            }
        });
    }

    public Option<String> getDoc(Chunk<Object> annotations) {
        return annotations.collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof AvroAnnotations.doc) {
                    return (B1)((AvroAnnotations.doc)x1).doc();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                return x1 instanceof AvroAnnotations.doc;
            }
        });
    }

    public Option<Object> getDefault(Chunk<Object> annotations) {
        return annotations.collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof AvroAnnotations.default) {
                    return (B1)((AvroAnnotations.default)x1).javaDefaultObject();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                return x1 instanceof AvroAnnotations.default;
            }
        });
    }

    public Either<String, Option<String>> getNamespace(Chunk<Object> annotations) {
        Regex validNamespaceRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[A-Za-z_][A-Za-z0-9_]*(\\.[A-Za-z_][A-Za-z0-9_]*)*"));
        Option option = annotations.collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof AvroAnnotations.namespace) {
                    return (B1)((AvroAnnotations.namespace)x1).namespace();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                return x1 instanceof AvroAnnotations.namespace;
            }
        });
        if (option instanceof Some) {
            Option option2;
            String s = (String)((Some)option).value();
            if (s != null && !(option2 = validNamespaceRegex.unapplySeq((CharSequence)s)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(1) == 0) {
                return new Right((Object)new Some((Object)s));
            }
            return package$.MODULE$.Left().apply((Object)new StringBuilder(24).append("Invalid Avro namespace: ").append(s).toString());
        }
        if (None$.MODULE$.equals(option)) {
            return new Right((Object)None$.MODULE$);
        }
        throw new MatchError((Object)option);
    }

    public boolean isErrorRecord(Schema.Record<?> record) {
        return record.annotations().collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (AvroAnnotations$error$.MODULE$.equals(x1)) {
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                return AvroAnnotations$error$.MODULE$.equals(x1);
            }
        }).nonEmpty();
    }

    public <B extends StaticAnnotation> Schema<?> addNameAnnotationIfMissing(Schema<?> schema, String name2) {
        return (Schema)schema.annotations().collectFirst((PartialFunction)new Serializable(schema){
            private static final long serialVersionUID = 0L;
            private final Schema schema$2;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof AvroAnnotations.name) {
                    return (B1)this.schema$2;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                return x1 instanceof AvroAnnotations.name;
            }
            {
                this.schema$2 = schema$2;
            }
        }).getOrElse((Function0 & Serializable)() -> schema.annotate((Object)new AvroAnnotations.name(name2)));
    }

    public Either<String, Schema<?>> toZioDecimal(org.apache.avro.Schema avroSchema, AvroAnnotations.DecimalType decimalType) {
        int scale2;
        AvroAnnotations.decimal decimalTypeAnnotation = new AvroAnnotations.decimal(decimalType);
        LogicalTypes.Decimal decimalLogicalType = (LogicalTypes.Decimal)avroSchema.getLogicalType();
        int precision2 = decimalLogicalType.getPrecision();
        if (precision2 - (scale2 = decimalLogicalType.getScale()) > 0) {
            return new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.BigDecimalType$.MODULE$).annotate((Object)new AvroAnnotations.scale(scale2)).annotate((Object)new AvroAnnotations.precision(precision2)).annotate((Object)decimalTypeAnnotation));
        }
        return new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.BigIntegerType$.MODULE$).annotate((Object)new AvroAnnotations.scale(scale2)).annotate((Object)decimalTypeAnnotation));
    }

    /*
     * Enabled aggressive block sorting
     */
    public <A, Z> Either<String, Schema<Z>> toZioEnumeration(org.apache.avro.Schema avroSchema) {
        Left left;
        Tuple2 tuple2 = ((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(avroSchema.getTypes()).asScala().map(AvroSchemaCodec$::$anonfun$toZioEnumeration$1)).toList().map((Function1 & Serializable)x$39 -> Either.MergeableEither$.MODULE$.merge$extension(Either$.MODULE$.MergeableEither(x$39))).partition((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AvroSchemaCodec$.$anonfun$toZioEnumeration$7(x0$1)));
        if (tuple2 != null) {
            List list = (List)tuple2._1();
            List right = (List)tuple2._2();
            if (Nil$.MODULE$.equals(list) && right instanceof Seq) {
                left = Try$.MODULE$.apply((Function0 & Serializable)() -> CaseSet$.MODULE$.apply((Seq)right)).toEither().left().map((Function1 & Serializable)x$40 -> x$40.getMessage());
                return left.map((Function1 & Serializable)cs -> Schema$.MODULE$.enumeration(TypeId$.MODULE$.parse(avroSchema.getName()), cs, Schema$.MODULE$.enumeration$default$3()));
            }
        }
        if (tuple2 == null) throw new MatchError(null);
        List left2 = (List)tuple2._1();
        left = package$.MODULE$.Left().apply((Object)left2.mkString("\n"));
        return left.map((Function1 & Serializable)cs -> Schema$.MODULE$.enumeration(TypeId$.MODULE$.parse(avroSchema.getName()), cs, Schema$.MODULE$.enumeration$default$3()));
    }

    public Either<String, Schema<?>> toZioRecord(org.apache.avro.Schema avroSchema) {
        if (avroSchema.getObjectProp(AvroPropMarker$UnionWrapper$.MODULE$.propName()) != null) {
            Option option = CollectionConverters$.MODULE$.ListHasAsScala(avroSchema.getFields()).asScala().headOption();
            if (option instanceof Some) {
                Schema.Field value = (Schema.Field)((Some)option).value();
                return this.toZioSchema(value.schema());
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)"ZIO schema wrapped record must have a single field");
            }
            throw new MatchError((Object)option);
        }
        if (avroSchema.getObjectProp(AvroPropMarker$EitherWrapper$.MODULE$.propName()) != null) {
            Option option = CollectionConverters$.MODULE$.ListHasAsScala(avroSchema.getFields()).asScala().headOption();
            if (option instanceof Some) {
                Schema.Field value = (Schema.Field)((Some)option).value();
                return this.toZioSchema(value.schema()).flatMap((Function1 & Serializable)x0$1 -> {
                    if (x0$1 instanceof Schema.Enum) {
                        List list = ((Schema.Enum)x0$1).cases().toList();
                        if (list instanceof .colon.colon) {
                            .colon.colon colon2 = (.colon.colon)list;
                            Schema.Case first = (Schema.Case)colon2.head();
                            List list2 = colon2.next$access$1();
                            if (list2 instanceof .colon.colon) {
                                .colon.colon colon3 = (.colon.colon)list2;
                                Schema.Case second = (Schema.Case)colon3.head();
                                List list3 = colon3.next$access$1();
                                if (Nil$.MODULE$.equals(list3)) {
                                    return new Right((Object)Schema$.MODULE$.either(first.schema(), second.schema()));
                                }
                            }
                        }
                        return package$.MODULE$.Left().apply((Object)"ZIO schema wrapped either must have exactly two cases");
                    }
                    if (x0$1 instanceof Schema.Either) {
                        Schema.Either either = (Schema.Either)x0$1;
                        return new Right((Object)either);
                    }
                    if (x0$1 instanceof Schema.Fallback) {
                        Schema.Fallback fallback = (Schema.Fallback)x0$1;
                        return new Right((Object)fallback);
                    }
                    if (x0$1 instanceof Schema.CaseClass0) {
                        Schema.CaseClass0 caseClass0 = (Schema.CaseClass0)x0$1;
                        return new Right((Object)caseClass0);
                    }
                    if (x0$1 instanceof Schema.CaseClass1) {
                        Schema.CaseClass1 caseClass1 = (Schema.CaseClass1)x0$1;
                        return new Right((Object)caseClass1);
                    }
                    if (x0$1 instanceof Schema.CaseClass2) {
                        Schema.CaseClass2 caseClass2 = (Schema.CaseClass2)x0$1;
                        return new Right((Object)caseClass2);
                    }
                    if (x0$1 instanceof Schema.CaseClass3) {
                        Schema.CaseClass3 caseClass3 = (Schema.CaseClass3)x0$1;
                        return new Right((Object)caseClass3);
                    }
                    if (x0$1 instanceof Schema.CaseClass4) {
                        Schema.CaseClass4 caseClass4 = (Schema.CaseClass4)x0$1;
                        return new Right((Object)caseClass4);
                    }
                    if (x0$1 instanceof Schema.CaseClass5) {
                        Schema.CaseClass5 caseClass5 = (Schema.CaseClass5)x0$1;
                        return new Right((Object)caseClass5);
                    }
                    if (x0$1 instanceof Schema.CaseClass6) {
                        Schema.CaseClass6 caseClass6 = (Schema.CaseClass6)x0$1;
                        return new Right((Object)caseClass6);
                    }
                    if (x0$1 instanceof Schema.CaseClass7) {
                        Schema.CaseClass7 caseClass7 = (Schema.CaseClass7)x0$1;
                        return new Right((Object)caseClass7);
                    }
                    if (x0$1 instanceof Schema.CaseClass8) {
                        Schema.CaseClass8 caseClass8 = (Schema.CaseClass8)x0$1;
                        return new Right((Object)caseClass8);
                    }
                    if (x0$1 instanceof Schema.CaseClass9) {
                        Schema.CaseClass9 caseClass9 = (Schema.CaseClass9)x0$1;
                        return new Right((Object)caseClass9);
                    }
                    if (x0$1 instanceof Schema.CaseClass10) {
                        Schema.CaseClass10 caseClass10 = (Schema.CaseClass10)x0$1;
                        return new Right((Object)caseClass10);
                    }
                    if (x0$1 instanceof Schema.CaseClass11) {
                        Schema.CaseClass11 caseClass11 = (Schema.CaseClass11)x0$1;
                        return new Right((Object)caseClass11);
                    }
                    if (x0$1 instanceof Schema.CaseClass12) {
                        Schema.CaseClass12 caseClass12 = (Schema.CaseClass12)x0$1;
                        return new Right((Object)caseClass12);
                    }
                    if (x0$1 instanceof Schema.CaseClass13) {
                        Schema.CaseClass13 caseClass13 = (Schema.CaseClass13)x0$1;
                        return new Right((Object)caseClass13);
                    }
                    if (x0$1 instanceof Schema.CaseClass14) {
                        Schema.CaseClass14 caseClass14 = (Schema.CaseClass14)x0$1;
                        return new Right((Object)caseClass14);
                    }
                    if (x0$1 instanceof Schema.CaseClass15) {
                        Schema.CaseClass15 caseClass15 = (Schema.CaseClass15)x0$1;
                        return new Right((Object)caseClass15);
                    }
                    if (x0$1 instanceof Schema.CaseClass16) {
                        Schema.CaseClass16 caseClass16 = (Schema.CaseClass16)x0$1;
                        return new Right((Object)caseClass16);
                    }
                    if (x0$1 instanceof Schema.CaseClass17) {
                        Schema.CaseClass17 caseClass17 = (Schema.CaseClass17)x0$1;
                        return new Right((Object)caseClass17);
                    }
                    if (x0$1 instanceof Schema.CaseClass18) {
                        Schema.CaseClass18 caseClass18 = (Schema.CaseClass18)x0$1;
                        return new Right((Object)caseClass18);
                    }
                    if (x0$1 instanceof Schema.CaseClass19) {
                        Schema.CaseClass19 caseClass19 = (Schema.CaseClass19)x0$1;
                        return new Right((Object)caseClass19);
                    }
                    if (x0$1 instanceof Schema.CaseClass20) {
                        Schema.CaseClass20 caseClass20 = (Schema.CaseClass20)x0$1;
                        return new Right((Object)caseClass20);
                    }
                    if (x0$1 instanceof Schema.CaseClass21) {
                        Schema.CaseClass21 caseClass21 = (Schema.CaseClass21)x0$1;
                        return new Right((Object)caseClass21);
                    }
                    if (x0$1 instanceof Schema.CaseClass22) {
                        Schema.CaseClass22 caseClass22 = (Schema.CaseClass22)x0$1;
                        return new Right((Object)caseClass22);
                    }
                    if (x0$1 instanceof Schema.Dynamic) {
                        Schema.Dynamic dynamic = (Schema.Dynamic)x0$1;
                        return new Right((Object)dynamic);
                    }
                    if (x0$1 instanceof Schema.GenericRecord) {
                        Schema.GenericRecord genericRecord = (Schema.GenericRecord)x0$1;
                        return new Right((Object)genericRecord);
                    }
                    if (x0$1 instanceof Schema.Map) {
                        Schema.Map map = (Schema.Map)x0$1;
                        return new Right((Object)map);
                    }
                    if (x0$1 instanceof Schema.Sequence) {
                        Schema.Sequence sequence = (Schema.Sequence)x0$1;
                        return new Right((Object)sequence);
                    }
                    if (x0$1 instanceof Schema.Set) {
                        Schema.Set set = (Schema.Set)x0$1;
                        return new Right((Object)set);
                    }
                    if (x0$1 instanceof Schema.Fail) {
                        Schema.Fail fail = (Schema.Fail)x0$1;
                        return new Right((Object)fail);
                    }
                    if (x0$1 instanceof Schema.Lazy) {
                        Schema.Lazy lazy = (Schema.Lazy)x0$1;
                        return new Right((Object)lazy);
                    }
                    if (x0$1 instanceof Schema.Optional) {
                        Schema.Optional optional = (Schema.Optional)x0$1;
                        return new Right((Object)optional);
                    }
                    if (x0$1 instanceof Schema.Primitive) {
                        Schema.Primitive primitive = (Schema.Primitive)x0$1;
                        return new Right((Object)primitive);
                    }
                    if (x0$1 instanceof Schema.Transform) {
                        Schema.Transform transform = (Schema.Transform)x0$1;
                        return new Right((Object)transform);
                    }
                    if (x0$1 instanceof Schema.Tuple2) {
                        Schema.Tuple2 tuple2 = (Schema.Tuple2)x0$1;
                        return new Right((Object)tuple2);
                    }
                    throw new MatchError(x0$1);
                });
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)"ZIO schema wrapped record must have a single field");
            }
            throw new MatchError((Object)option);
        }
        Chunk<StaticAnnotation> annotations = this.buildZioAnnotations(avroSchema);
        return this.extractZioFields(avroSchema).map((Function1 & Serializable)fs -> MODULE$.SchemaExtensions(Schema$.MODULE$.record(TypeId$.MODULE$.parse(avroSchema.getName()), (Seq)fs)).addAllAnnotations((Chunk<Object>)annotations));
    }

    private <Z> Either<String, List<Schema.Field<Z, ?>>> extractZioFields(org.apache.avro.Schema avroSchema) {
        Tuple2 tuple2 = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(avroSchema.getFields()).asScala().map((Function1 & Serializable)field -> MODULE$.toZioField((Schema.Field)field))).toList().map((Function1 & Serializable)x$41 -> Either.MergeableEither$.MODULE$.merge$extension(Either$.MODULE$.MergeableEither(x$41))).partition((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AvroSchemaCodec$.$anonfun$extractZioFields$3(x0$1)));
        if (tuple2 != null) {
            List list = (List)tuple2._1();
            List right = (List)tuple2._2();
            if (Nil$.MODULE$.equals(list) && right instanceof List) {
                return new Right((Object)right);
            }
        }
        if (tuple2 != null) {
            List left = (List)tuple2._1();
            return package$.MODULE$.Left().apply((Object)left.mkString("\n"));
        }
        throw new MatchError(null);
    }

    public Either<String, Schema.Field<ListMap<String, ?>, ?>> toZioField(Schema.Field field) {
        return this.toZioSchema(field.schema()).map((Function1 & Serializable)s -> {
            String x$1 = field.name();
            Chunk<Object> x$3 = MODULE$.buildZioAnnotations(field);
            Function1 & Serializable x$4 = (Function1 & Serializable)p -> p.apply((Object)field.name());
            Function2 & Serializable x$5 = (Function2 & Serializable)(p, v) -> p.updated((Object)field.name(), v);
            Validation x$6 = Schema.Field$.MODULE$.apply$default$4();
            return Schema.Field$.MODULE$.apply(x$1, s, x$3, x$6, (Function1)x$4, (Function2)x$5);
        });
    }

    public Either<String, Schema<?>> toZioTuple(org.apache.avro.Schema schema) {
        return Either$.MODULE$.cond(schema.getFields().size() == 2, (Function0)(JFunction0.mcV.sp & Serializable)() -> {}, (Function0 & Serializable)() -> new StringBuilder(33).append("Tuple must have exactly 2 fields:").append(schema.toString(false)).toString()).flatMap((Function1 & Serializable)x$42 -> MODULE$.toZioSchema(((Schema.Field)schema.getFields().get(0)).schema()).flatMap((Function1 & Serializable)_1 -> MODULE$.toZioSchema(((Schema.Field)schema.getFields().get(1)).schema()).map((Function1 & Serializable)_2 -> new Schema.Tuple2(_1, _2, MODULE$.buildZioAnnotations(schema)))));
    }

    public Chunk<StaticAnnotation> buildZioAnnotations(org.apache.avro.Schema schema) {
        AvroAnnotations.name name2 = new AvroAnnotations.name(schema.getName());
        Option namespace2 = Try$.MODULE$.apply((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)schema.getNamespace()).map((Function1 & Serializable)namespace2 -> new AvroAnnotations.namespace((String)namespace2))).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
        None$ doc2 = schema.getDoc() != null ? new Some((Object)new AvroAnnotations.doc(schema.getDoc())) : None$.MODULE$;
        Option aliases2 = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            if (schema.getAliases() != null && !schema.getAliases().isEmpty()) {
                return new Some((Object)new AvroAnnotations.aliases((Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(schema.getAliases()).asScala().toSet()));
            }
            return None$.MODULE$;
        }).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option error = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            if (schema.isError()) {
                return new Some((Object)AvroAnnotations$error$.MODULE$);
            }
            return None$.MODULE$;
        }).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option option = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            if (schema.getEnumDefault() != null) {
                return new Some((Object)new AvroAnnotations.default(schema.getEnumDefault()));
            }
            return None$.MODULE$;
        }).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return (Chunk)((IterableOps)((IterableOps)((IterableOps)((IterableOps)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AvroAnnotations.name[]{name2})).$plus$plus((IterableOnce)namespace2)).$plus$plus((IterableOnce)doc2)).$plus$plus((IterableOnce)aliases2)).$plus$plus((IterableOnce)error)).$plus$plus((IterableOnce)option);
    }

    public Chunk<Object> buildZioAnnotations(Schema.Field field) {
        Some nameAnnotation = new Some((Object)new AvroAnnotations.name(field.name()));
        None$ docAnnotation = field.doc() != null ? new Some((Object)new AvroAnnotations.doc(field.doc())) : None$.MODULE$;
        None$ aliasesAnnotation = !field.aliases().isEmpty() ? new Some((Object)new AvroAnnotations.aliases((Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(field.aliases()).asScala().toSet())) : None$.MODULE$;
        Option option = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            if (field.hasDefaultValue()) {
                return new Some((Object)new AvroAnnotations.default(field.defaultVal()));
            }
            return None$.MODULE$;
        }).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Some orderAnnotation = new Some((Object)new AvroAnnotations.fieldOrder(AvroAnnotations$FieldOrderType$.MODULE$.fromAvroOrder(field.order())));
        Seq annotations = (Seq)new .colon.colon((Object)nameAnnotation, (List)new .colon.colon((Object)docAnnotation, (List)new .colon.colon((Object)aliasesAnnotation, (List)new .colon.colon((Object)orderAnnotation, (List)new .colon.colon((Object)option, (List)Nil$.MODULE$))))).flatten(Predef$.MODULE$.$conforms());
        return Chunk$.MODULE$.fromIterable((Iterable)annotations);
    }

    public Either<String, Schema<?>> toZioStringEnum(org.apache.avro.Schema avroSchema) {
        Seq cases = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(avroSchema.getEnumSymbols()).asScala().map((Function1 & Serializable)s -> new Schema.Case(s, Schema$.MODULE$.apply(Schema$.MODULE$.primitive((StandardType)StandardType.StringType$.MODULE$)), (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x), (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x), (Function1 & Serializable)x$43 -> BoxesRunTime.boxToBoolean((boolean)AvroSchemaCodec$.$anonfun$toZioStringEnum$4(x$43)), Schema.Case$.MODULE$.apply$default$6()))).toSeq();
        CaseSet caseSet = CaseSet$.MODULE$.apply(cases);
        Schema enumeration = Schema$.MODULE$.enumeration(TypeId$.MODULE$.parse("org.apache.avro.Schema"), caseSet, Schema$.MODULE$.enumeration$default$3());
        return new Right(this.SchemaExtensions(enumeration).addAllAnnotations(this.buildZioAnnotations(avroSchema)));
    }

    private AvroSchemaCodec.SchemaExtensions SchemaExtensions(Schema<?> schema) {
        return new AvroSchemaCodec.SchemaExtensions(schema);
    }

    private AvroSchemaCodec.SchemaAvroExtensions SchemaAvroExtensions(org.apache.avro.Schema schemaAvro) {
        return new AvroSchemaCodec.SchemaAvroExtensions(schemaAvro);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Tuple2 $anonfun$toAvroSchema$4(String codecName$1, org.apache.avro.Schema codecAvroSchema) {
        block3: {
            block2: {
                if (codecAvroSchema == null) break block2;
                v0 = codecAvroSchema.getType();
                var3_2 = Schema.Type.NULL;
                if (v0 != null ? v0.equals(var3_2) == false : var3_2 != null) break block2;
                v1 = AvroSchemaCodec$.MODULE$.wrapAvro(codecAvroSchema, codecName$1, AvroPropMarker$UnionWrapper$.MODULE$);
                break block3;
            }
            if (codecAvroSchema == null) ** GOTO lbl-1000
            v2 = codecAvroSchema.getType();
            var4_3 = Schema.Type.UNION;
            if (!(v2 != null ? v2.equals(var4_3) == false : var4_3 != null)) {
                v1 = AvroSchemaCodec$.MODULE$.wrapAvro(codecAvroSchema, codecName$1, AvroPropMarker$UnionWrapper$.MODULE$);
            } else lbl-1000:
            // 2 sources

            {
                v1 = codecAvroSchema;
            }
        }
        wrappedAvroSchema = v1;
        return new Tuple2((Object)codecAvroSchema, (Object)wrappedAvroSchema);
    }

    public static final /* synthetic */ boolean $anonfun$hasFormatToStringAnnotation$1(Object x0$1) {
        return AvroAnnotations$formatToString$.MODULE$.equals(x0$1);
    }

    public static final /* synthetic */ boolean $anonfun$hasAvroEnumAnnotation$1(Object x0$1) {
        return x0$1 instanceof AvroAnnotations.avroEnum;
    }

    public static final /* synthetic */ boolean $anonfun$toAvroEnum$2(boolean avroEnumAnnotationExists$1, Schema x0$1) {
        Schema.CaseClass0 caseClass0;
        Schema schema;
        if (x0$1 instanceof Schema.Transform && (schema = ((Schema.Transform)x0$1).schema()) instanceof Schema.Primitive) {
            StandardType standardType = ((Schema.Primitive)schema).standardType();
            StandardType.UnitType$ unitType$ = StandardType.UnitType$.MODULE$;
            if (standardType != null && standardType.equals(unitType$) && avroEnumAnnotationExists$1) {
                return true;
            }
        }
        if (x0$1 instanceof Schema.Primitive) {
            StandardType standardType = ((Schema.Primitive)x0$1).standardType();
            StandardType.StringType$ stringType$ = StandardType.StringType$.MODULE$;
            if (standardType != null && standardType.equals(stringType$)) {
                return true;
            }
        }
        return x0$1 instanceof Schema.CaseClass0 && !Schema.CaseClass0$.MODULE$.unapply(caseClass0 = (Schema.CaseClass0)x0$1).isEmpty() && avroEnumAnnotationExists$1;
    }

    public static final /* synthetic */ boolean $anonfun$toAvroEnum$16(Object x0$5) {
        return x0$5 instanceof String;
    }

    public static final /* synthetic */ boolean $anonfun$extractAvroFields$3(Object x0$1) {
        return x0$1 instanceof String;
    }

    public static final /* synthetic */ boolean $anonfun$toZioEnumeration$5(Object z) {
        return z instanceof Object;
    }

    public static final /* synthetic */ Schema.Case $anonfun$toZioEnumeration$2(org.apache.avro.Schema t$1, Schema s) {
        return new Schema.Case(t$1.getFullName(), s, (Function1 & Serializable)x$37 -> x$37, (Function1 & Serializable)x$38 -> x$38, (Function1 & Serializable)z -> BoxesRunTime.boxToBoolean((boolean)AvroSchemaCodec$.$anonfun$toZioEnumeration$5(z)), Schema.Case$.MODULE$.apply$default$6());
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Either $anonfun$toZioEnumeration$1(org.apache.avro.Schema t) {
        v0 = t.getType();
        var2_1 = Schema.Type.RECORD;
        if (v0 != null ? v0.equals(var2_1) == false : var2_1 != null) ** GOTO lbl-1000
        if (t.getFields().size() == 1 && BoxesRunTime.equals((Object)t.getObjectProp(AvroPropMarker$UnionWrapper$.MODULE$.propName()), (Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            v1 = ((Schema.Field)CollectionConverters$.MODULE$.ListHasAsScala(t.getFields()).asScala().head()).schema();
        } else lbl-1000:
        // 2 sources

        {
            v1 = t;
        }
        inner = v1;
        return AvroSchemaCodec$.MODULE$.toZioSchema(inner).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toZioEnumeration$2(org.apache.avro.Schema zio.schema.Schema ), (Lzio/schema/Schema;)Lzio/schema/Schema$Case;)((org.apache.avro.Schema)t));
    }

    public static final /* synthetic */ boolean $anonfun$toZioEnumeration$7(Object x0$1) {
        return x0$1 instanceof String;
    }

    public static final /* synthetic */ boolean $anonfun$extractZioFields$3(Object x0$1) {
        return x0$1 instanceof String;
    }

    public static final /* synthetic */ boolean $anonfun$toZioStringEnum$4(String x$43) {
        return x$43 instanceof String;
    }

    private AvroSchemaCodec$() {
    }
}

