/*
 * Decompiled with CFR 0.152.
 */
package zio.schema.codec;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.annotation.StaticAnnotation;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Either$;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scala.util.matching.Regex;
import zio.Chunk;
import zio.Chunk$;
import zio.schema.CaseSet;
import zio.schema.CaseSet$;
import zio.schema.Schema;
import zio.schema.Schema$;
import zio.schema.StandardType;
import zio.schema.TypeId$;
import zio.schema.ast.SchemaAst$;
import zio.schema.codec.AvroAnnotations;
import zio.schema.codec.AvroAnnotations$DecimalType$;
import zio.schema.codec.AvroAnnotations$DecimalType$Bytes$;
import zio.schema.codec.AvroAnnotations$FieldOrderType$;
import zio.schema.codec.AvroAnnotations$TimePrecisionType$;
import zio.schema.codec.AvroAnnotations$TimePrecisionType$Micros$;
import zio.schema.codec.AvroAnnotations$TimePrecisionType$Millis$;
import zio.schema.codec.AvroAnnotations$avroEnum$;
import zio.schema.codec.AvroAnnotations$error$;
import zio.schema.codec.AvroAnnotations$formatToString$;
import zio.schema.codec.AvroAnnotations$precision$;
import zio.schema.codec.AvroAnnotations$scale$;
import zio.schema.codec.AvroCodec;
import zio.schema.codec.AvroCodec$EitherUnion$;
import zio.schema.codec.AvroCodec$OptionUnion$;
import zio.schema.codec.AvroPropMarker;
import zio.schema.codec.AvroPropMarker$;
import zio.schema.codec.AvroPropMarker$EitherWrapper$;
import zio.schema.codec.AvroPropMarker$Formatter$;
import zio.schema.codec.AvroPropMarker$UnionWrapper$;
import zio.schema.codec.IntType;
import zio.schema.codec.IntType$;
import zio.schema.codec.IntType$Char$;
import zio.schema.codec.IntType$DayOfWeek$;
import zio.schema.codec.IntType$Month$;
import zio.schema.codec.IntType$Short$;
import zio.schema.codec.IntType$Year$;
import zio.schema.codec.IntType$ZoneOffset$;
import zio.schema.codec.RecordType;
import zio.schema.codec.RecordType$;
import zio.schema.codec.RecordType$Duration$;
import zio.schema.codec.RecordType$MonthDay$;
import zio.schema.codec.RecordType$Period$;
import zio.schema.codec.RecordType$Tuple$;
import zio.schema.codec.RecordType$YearMonth$;
import zio.schema.codec.StringType;
import zio.schema.codec.StringType$;
import zio.schema.codec.StringType$Instant$;
import zio.schema.codec.StringType$LocalDate$;
import zio.schema.codec.StringType$LocalDateTime$;
import zio.schema.codec.StringType$LocalTime$;
import zio.schema.codec.StringType$OffsetDateTime$;
import zio.schema.codec.StringType$OffsetTime$;
import zio.schema.codec.StringType$ZoneDateTime$;
import zio.schema.codec.StringType$ZoneId$;

public final class AvroCodec$
implements AvroCodec {
    public static final AvroCodec$ MODULE$ = new AvroCodec$();
    private static Seq<Schema.Field<Object>> monthDayStructure;
    private static Seq<Schema.Field<Object>> periodStructure;
    private static Seq<Schema.Field<Object>> yearMonthStructure;
    private static Seq<Schema.Field<?>> durationStructure;
    private static volatile byte bitmap$0;

    @Override
    public Either<String, String> encode(Schema<?> schema) {
        return this.toAvroSchema(schema).map((Function1 & Serializable)x$1 -> x$1.toString());
    }

    @Override
    public Either<String, org.apache.avro.Schema> encodeToApacheAvro(Schema<?> schema) {
        return this.toAvroSchema(schema);
    }

    @Override
    public Either<String, Schema<?>> decode(Chunk<Object> bytes2) {
        Schema.Parser avroSchemaParser = new Schema.Parser();
        return ((Either)Try$.MODULE$.apply((Function0 & Serializable)() -> avroSchemaParser.parse(new String((byte[])bytes2.toArray((ClassTag)ClassTag$.MODULE$.Byte()), StandardCharsets.UTF_8))).fold((Function1 & Serializable)e -> package$.MODULE$.Left().apply((Object)e.getMessage()), (Function1 & Serializable)s -> new Right(s))).flatMap((Function1 & Serializable)avroSchema -> MODULE$.toZioSchema((org.apache.avro.Schema)avroSchema));
    }

    @Override
    public Function1<org.apache.avro.Schema, Either<String, Schema<?>>> decodeFromApacheAvro() {
        return (Function1 & Serializable)avroSchema -> MODULE$.toZioSchema((org.apache.avro.Schema)avroSchema);
    }

    private Either<String, Schema<?>> toZioSchema(org.apache.avro.Schema avroSchema) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> LogicalTypes.fromSchema((org.apache.avro.Schema)avroSchema)).toEither().left().map((Function1 & Serializable)e -> e.getMessage()).flatMap(arg_0 -> AvroCodec$.$anonfun$toZioSchema$3(avroSchema, arg_0));
    }

    @Override
    public org.apache.avro.Schema toAvroBinary(Schema<?> schema) {
        return (org.apache.avro.Schema)schema.annotations().collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                AvroAnnotations.BytesType bytesType;
                if (x1 instanceof AvroAnnotations.bytes && (bytesType = ((AvroAnnotations.bytes)x1).bytesType()) instanceof AvroAnnotations.BytesType.Fixed) {
                    AvroAnnotations.BytesType.Fixed fixed = (AvroAnnotations.BytesType.Fixed)bytesType;
                    int size = fixed.size();
                    String name2 = fixed.name();
                    String doc2 = fixed.doc();
                    String space = fixed.space();
                    object = org.apache.avro.Schema.createFixed((String)name2, (String)doc2, (String)space, (int)size);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                boolean bl = x1 instanceof AvroAnnotations.bytes && ((AvroAnnotations.bytes)x1).bytesType() instanceof AvroAnnotations.BytesType.Fixed;
                return bl;
            }
        }).getOrElse((Function0 & Serializable)() -> org.apache.avro.Schema.create((Schema.Type)Schema.Type.BYTES));
    }

    private Seq<Schema.Field<Object>> monthDayStructure$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 1) == 0) {
                monthDayStructure = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Schema.Field[]{new Schema.Field("month", (Schema)new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2()), Schema.Field$.MODULE$.apply$default$3(), Schema.Field$.MODULE$.apply$default$4()), new Schema.Field("day", (Schema)new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2()), Schema.Field$.MODULE$.apply$default$3(), Schema.Field$.MODULE$.apply$default$4())}));
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return monthDayStructure;
    }

    public Seq<Schema.Field<Object>> monthDayStructure() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.monthDayStructure$lzycompute();
        }
        return monthDayStructure;
    }

    private Seq<Schema.Field<Object>> periodStructure$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 2) == 0) {
                periodStructure = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Schema.Field[]{new Schema.Field("years", (Schema)new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2()), Schema.Field$.MODULE$.apply$default$3(), Schema.Field$.MODULE$.apply$default$4()), new Schema.Field("months", (Schema)new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2()), Schema.Field$.MODULE$.apply$default$3(), Schema.Field$.MODULE$.apply$default$4()), new Schema.Field("days", (Schema)new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2()), Schema.Field$.MODULE$.apply$default$3(), Schema.Field$.MODULE$.apply$default$4())}));
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return periodStructure;
    }

    public Seq<Schema.Field<Object>> periodStructure() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.periodStructure$lzycompute();
        }
        return periodStructure;
    }

    private Seq<Schema.Field<Object>> yearMonthStructure$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 4) == 0) {
                yearMonthStructure = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Schema.Field[]{new Schema.Field("year", (Schema)new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2()), Schema.Field$.MODULE$.apply$default$3(), Schema.Field$.MODULE$.apply$default$4()), new Schema.Field("month", (Schema)new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2()), Schema.Field$.MODULE$.apply$default$3(), Schema.Field$.MODULE$.apply$default$4())}));
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return yearMonthStructure;
    }

    public Seq<Schema.Field<Object>> yearMonthStructure() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.yearMonthStructure$lzycompute();
        }
        return yearMonthStructure;
    }

    private Seq<Schema.Field<?>> durationStructure$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 8) == 0) {
                durationStructure = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Schema.Field[]{new Schema.Field("seconds", (Schema)new Schema.Primitive((StandardType)StandardType.LongType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2()), Schema.Field$.MODULE$.apply$default$3(), Schema.Field$.MODULE$.apply$default$4()), new Schema.Field("nanos", (Schema)new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2()), Schema.Field$.MODULE$.apply$default$3(), Schema.Field$.MODULE$.apply$default$4())}));
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        return durationStructure;
    }

    public Seq<Schema.Field<?>> durationStructure() {
        if ((byte)(bitmap$0 & 8) == 0) {
            return this.durationStructure$lzycompute();
        }
        return durationStructure;
    }

    private Either<String, org.apache.avro.Schema> toAvroSchema(Schema<?> schema) {
        Either either;
        block75: {
            while (true) {
                if (schema instanceof Schema.Enum) {
                    Schema.Enum enum_ = (Schema.Enum)schema;
                    either = this.toAvroEnum(enum_);
                    break block75;
                }
                if (schema instanceof Schema.Record) {
                    Schema.Record record = (Schema.Record)schema;
                    either = this.toAvroRecord(record);
                    break block75;
                }
                if (schema instanceof Schema.MapSchema) {
                    Schema.MapSchema mapSchema = (Schema.MapSchema)schema;
                    either = this.toAvroMap(mapSchema);
                    break block75;
                }
                if (schema instanceof Schema.Sequence) {
                    Schema.Sequence sequence = (Schema.Sequence)schema;
                    either = this.toAvroSchema(sequence.schemaA()).map((Function1 & Serializable)elementType -> org.apache.avro.Schema.createArray((org.apache.avro.Schema)elementType));
                    break block75;
                }
                if (schema instanceof Schema.SetSchema) {
                    Schema.SetSchema setSchema = (Schema.SetSchema)schema;
                    either = this.toAvroSchema(setSchema.as()).map((Function1 & Serializable)elementType -> org.apache.avro.Schema.createArray((org.apache.avro.Schema)elementType));
                    break block75;
                }
                if (schema instanceof Schema.Transform) {
                    schema = ((Schema.Transform)schema).codec();
                    continue;
                }
                if (schema instanceof Schema.Primitive) {
                    Right right;
                    StandardType standardType = ((Schema.Primitive)schema).standardType();
                    if (StandardType.UnitType$.MODULE$.equals(standardType)) {
                        right = new Right((Object)org.apache.avro.Schema.create((Schema.Type)Schema.Type.NULL));
                    } else if (StandardType.StringType$.MODULE$.equals(standardType)) {
                        right = new Right((Object)org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING));
                    } else if (StandardType.BoolType$.MODULE$.equals(standardType)) {
                        right = new Right((Object)org.apache.avro.Schema.create((Schema.Type)Schema.Type.BOOLEAN));
                    } else if (StandardType.ShortType$.MODULE$.equals(standardType)) {
                        right = new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT)).addMarkerProp(new AvroPropMarker.IntDiscriminator(IntType$Short$.MODULE$)));
                    } else if (StandardType.ByteType$.MODULE$.equals(standardType)) {
                        right = new Right((Object)org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT));
                    } else if (StandardType.IntType$.MODULE$.equals(standardType)) {
                        right = new Right((Object)org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT));
                    } else if (StandardType.LongType$.MODULE$.equals(standardType)) {
                        right = new Right((Object)org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG));
                    } else if (StandardType.FloatType$.MODULE$.equals(standardType)) {
                        right = new Right((Object)org.apache.avro.Schema.create((Schema.Type)Schema.Type.FLOAT));
                    } else if (StandardType.DoubleType$.MODULE$.equals(standardType)) {
                        right = new Right((Object)org.apache.avro.Schema.create((Schema.Type)Schema.Type.DOUBLE));
                    } else if (StandardType.BinaryType$.MODULE$.equals(standardType)) {
                        right = new Right((Object)this.toAvroBinary(schema));
                    } else if (StandardType.CharType$.MODULE$.equals(standardType)) {
                        right = new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT)).addMarkerProp(new AvroPropMarker.IntDiscriminator(IntType$Char$.MODULE$)));
                    } else if (StandardType.UUIDType$.MODULE$.equals(standardType)) {
                        right = new Right((Object)LogicalTypes.uuid().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)));
                    } else if (StandardType.BigDecimalType$.MODULE$.equals(standardType)) {
                        right = this.toAvroDecimal(schema);
                    } else if (StandardType.BigIntegerType$.MODULE$.equals(standardType)) {
                        right = this.toAvroDecimal(schema);
                    } else if (StandardType.DayOfWeekType$.MODULE$.equals(standardType)) {
                        right = new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT)).addMarkerProp(new AvroPropMarker.IntDiscriminator(IntType$DayOfWeek$.MODULE$)));
                    } else if (StandardType.MonthType$.MODULE$.equals(standardType)) {
                        right = new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT)).addMarkerProp(new AvroPropMarker.IntDiscriminator(IntType$Month$.MODULE$)));
                    } else if (StandardType.YearType$.MODULE$.equals(standardType)) {
                        right = new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT)).addMarkerProp(new AvroPropMarker.IntDiscriminator(IntType$Year$.MODULE$)));
                    } else if (StandardType.ZoneIdType$.MODULE$.equals(standardType)) {
                        right = new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.StringDiscriminator(StringType$ZoneId$.MODULE$)));
                    } else if (StandardType.ZoneOffsetType$.MODULE$.equals(standardType)) {
                        right = new Right((Object)this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT)).addMarkerProp(new AvroPropMarker.IntDiscriminator(IntType$ZoneOffset$.MODULE$)));
                    } else if (StandardType.MonthDayType$.MODULE$.equals(standardType)) {
                        right = new Right((Object)org.apache.avro.Schema.create((Schema.Type)Schema.Type.RECORD));
                    } else if (StandardType.PeriodType$.MODULE$.equals(standardType)) {
                        right = new Right((Object)org.apache.avro.Schema.create((Schema.Type)Schema.Type.RECORD));
                    } else if (StandardType.YearMonthType$.MODULE$.equals(standardType)) {
                        right = new Right((Object)org.apache.avro.Schema.create((Schema.Type)Schema.Type.RECORD));
                    } else if (StandardType.DurationType$.MODULE$.equals(standardType)) {
                        right = new Right((Object)org.apache.avro.Schema.create((Schema.Type)Schema.Type.RECORD));
                    } else if (standardType instanceof StandardType.InstantType) {
                        StandardType.InstantType instantType = (StandardType.InstantType)standardType;
                        right = this.toAvroInstant(instantType.formatter(), (Chunk<Object>)schema.annotations());
                    } else if (standardType instanceof StandardType.LocalDateType) {
                        StandardType.LocalDateType localDateType = (StandardType.LocalDateType)standardType;
                        right = this.toAvroLocalDate(localDateType.formatter(), (Chunk<Object>)schema.annotations());
                    } else if (standardType instanceof StandardType.LocalTimeType) {
                        StandardType.LocalTimeType localTimeType = (StandardType.LocalTimeType)standardType;
                        right = this.toAvroLocalTime(localTimeType.formatter(), (Chunk<Object>)schema.annotations());
                    } else if (standardType instanceof StandardType.LocalDateTimeType) {
                        StandardType.LocalDateTimeType localDateTimeType = (StandardType.LocalDateTimeType)standardType;
                        right = this.toAvroLocalDateTime(localDateTimeType.formatter(), (Chunk<Object>)schema.annotations());
                    } else if (standardType instanceof StandardType.OffsetTimeType) {
                        DateTimeFormatter formatter = ((StandardType.OffsetTimeType)standardType).formatter();
                        right = new Right((Object)this.SchemaAvroExtensions(this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.StringDiscriminator(StringType$OffsetTime$.MODULE$))).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
                    } else if (standardType instanceof StandardType.OffsetDateTimeType) {
                        DateTimeFormatter formatter = ((StandardType.OffsetDateTimeType)standardType).formatter();
                        right = new Right((Object)this.SchemaAvroExtensions(this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.StringDiscriminator(StringType$OffsetDateTime$.MODULE$))).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
                    } else if (standardType instanceof StandardType.ZonedDateTimeType) {
                        DateTimeFormatter formatter = ((StandardType.ZonedDateTimeType)standardType).formatter();
                        right = new Right((Object)this.SchemaAvroExtensions(this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.StringDiscriminator(StringType$ZoneDateTime$.MODULE$))).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
                    } else {
                        throw new MatchError((Object)standardType);
                    }
                    either = right;
                    break block75;
                }
                if (schema instanceof Schema.Optional) {
                    Schema codec = ((Schema.Optional)schema).codec();
                    either = this.getName(codec).flatMap((Function1 & Serializable)codecName -> MODULE$.toAvroSchema(codec).map((Function1 & Serializable)codecAvroSchema -> {
                        org.apache.avro.Schema schema;
                        if (codecAvroSchema != null) {
                            Schema.Type type = codecAvroSchema.getType();
                            Schema.Type type2 = Schema.Type.NULL;
                            if (!(type != null ? !type.equals(type2) : type2 != null)) {
                                schema = MODULE$.wrapAvro((org.apache.avro.Schema)codecAvroSchema, (String)codecName, AvroPropMarker$UnionWrapper$.MODULE$);
                                return new Tuple2(codecAvroSchema, (Object)schema);
                            }
                        }
                        if (codecAvroSchema != null) {
                            Schema.Type type = codecAvroSchema.getType();
                            Schema.Type type3 = Schema.Type.UNION;
                            if (!(type != null ? !type.equals(type3) : type3 != null)) {
                                schema = MODULE$.wrapAvro((org.apache.avro.Schema)codecAvroSchema, (String)codecName, AvroPropMarker$UnionWrapper$.MODULE$);
                                return new Tuple2(codecAvroSchema, (Object)schema);
                            }
                        }
                        schema = codecAvroSchema;
                        return new Tuple2(codecAvroSchema, (Object)schema);
                    }).map((Function1 & Serializable)x$8 -> {
                        if (x$8 == null) {
                            throw new MatchError(null);
                        }
                        org.apache.avro.Schema wrappedAvroSchema = (org.apache.avro.Schema)x$8._2();
                        org.apache.avro.Schema schema = org.apache.avro.Schema.createUnion((org.apache.avro.Schema[])new org.apache.avro.Schema[]{org.apache.avro.Schema.create((Schema.Type)Schema.Type.NULL), wrappedAvroSchema});
                        return schema;
                    }));
                    break block75;
                }
                if (schema instanceof Schema.Fail) {
                    String message = ((Schema.Fail)schema).message();
                    either = package$.MODULE$.Left().apply((Object)message);
                    break block75;
                }
                if (schema instanceof Schema.Tuple) {
                    Schema.Tuple tuple = (Schema.Tuple)schema;
                    either = this.toAvroSchema((Schema<?>)tuple.toRecord()).map((Function1 & Serializable)x$9 -> MODULE$.SchemaAvroExtensions((org.apache.avro.Schema)x$9).addMarkerProp(new AvroPropMarker.RecordDiscriminator(RecordType$Tuple$.MODULE$)));
                    break block75;
                }
                if (schema instanceof Schema.EitherSchema) {
                    Schema.EitherSchema eitherSchema = (Schema.EitherSchema)schema;
                    Schema left = eitherSchema.left();
                    Schema right = eitherSchema.right();
                    either = this.toAvroSchema(left).flatMap((Function1 & Serializable)l -> MODULE$.toAvroSchema(right).flatMap((Function1 & Serializable)r -> MODULE$.getName(left).flatMap((Function1 & Serializable)lname -> MODULE$.getName(right).map((Function1 & Serializable)rname -> {
                        Schema.Type type = l.getType();
                        Schema.Type type2 = Schema.Type.UNION;
                        org.apache.avro.Schema leftSchema = !(type != null ? !type.equals(type2) : type2 != null) ? MODULE$.wrapAvro((org.apache.avro.Schema)l, (String)lname, AvroPropMarker$UnionWrapper$.MODULE$) : l;
                        Schema.Type type3 = r.getType();
                        Schema.Type type4 = Schema.Type.UNION;
                        org.apache.avro.Schema rightSchema = !(type3 != null ? !type3.equals(type4) : type4 != null) ? MODULE$.wrapAvro((org.apache.avro.Schema)r, (String)rname, AvroPropMarker$UnionWrapper$.MODULE$) : r;
                        return new Tuple3(rname, (Object)leftSchema, (Object)rightSchema);
                    }).flatMap((Function1 & Serializable)x$11 -> {
                        if (x$11 == null) {
                            throw new MatchError(null);
                        }
                        org.apache.avro.Schema leftSchema = (org.apache.avro.Schema)x$11._2();
                        org.apache.avro.Schema rightSchema = (org.apache.avro.Schema)x$11._3();
                        String string = leftSchema.getFullName();
                        String string2 = rightSchema.getFullName();
                        Either either = (!(string != null ? !string.equals(string2) : string2 != null) ? package$.MODULE$.Left().apply((Object)new StringBuilder(64).append("Left and right schemas of either must have different fullnames: ").append(leftSchema.getFullName()).toString()) : new Right((Object)BoxedUnit.UNIT)).map((Function1 & Serializable)x$10 -> org.apache.avro.Schema.createUnion((org.apache.avro.Schema[])new org.apache.avro.Schema[]{leftSchema, rightSchema}));
                        return either;
                    })))).flatMap((Function1 & Serializable)union -> MODULE$.getName((Schema<?>)eitherSchema).map((Function1 & Serializable)name2 -> MODULE$.wrapAvro((org.apache.avro.Schema)union, (String)name2, AvroPropMarker$EitherWrapper$.MODULE$)));
                    break block75;
                }
                if (schema instanceof Schema.Lazy) {
                    schema = (Schema)((Schema.Lazy)schema).schema0$access$0().apply();
                    continue;
                }
                if (schema instanceof Schema.Meta) {
                    schema = Schema$.MODULE$.apply(SchemaAst$.MODULE$.schema());
                    continue;
                }
                if (schema instanceof Schema.Dynamic) {
                    schema = Schema$.MODULE$.apply(SchemaAst$.MODULE$.schema());
                    continue;
                }
                if (!(schema instanceof Schema.SemiDynamic)) break;
                schema = Schema$.MODULE$.apply(SchemaAst$.MODULE$.schema());
            }
            throw new MatchError((Object)schema);
        }
        return either;
    }

    private boolean hasFormatToStringAnnotation(Chunk<Object> value) {
        return value.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = AvroAnnotations$formatToString$.MODULE$.equals(x0$1))));
    }

    private Option<AvroAnnotations.TimePrecisionType> getTimeprecisionType(Chunk<Object> value) {
        return value.collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object = x1 instanceof AvroAnnotations.timeprecision ? ((AvroAnnotations.timeprecision)x1).timeprecisionType() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                boolean bl = x1 instanceof AvroAnnotations.timeprecision;
                return bl;
            }
        });
    }

    public Either<String, org.apache.avro.Schema> toAvroInstant(DateTimeFormatter formatter, Chunk<Object> annotations) {
        Right right;
        if (this.hasFormatToStringAnnotation(annotations)) {
            return new Right((Object)this.SchemaAvroExtensions(this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.StringDiscriminator(StringType$Instant$.MODULE$))).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
        }
        org.apache.avro.Schema baseSchema = org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG);
        AvroAnnotations.TimePrecisionType timePrecisionType = (AvroAnnotations.TimePrecisionType)this.getTimeprecisionType(annotations).getOrElse((Function0 & Serializable)() -> AvroAnnotations$TimePrecisionType$.MODULE$.default());
        if (AvroAnnotations$TimePrecisionType$Millis$.MODULE$.equals(timePrecisionType)) {
            right = new Right((Object)this.SchemaAvroExtensions(LogicalTypes.timestampMillis().addToSchema(baseSchema)).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
        } else if (AvroAnnotations$TimePrecisionType$Micros$.MODULE$.equals(timePrecisionType)) {
            right = new Right((Object)this.SchemaAvroExtensions(LogicalTypes.timestampMicros().addToSchema(baseSchema)).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
        } else {
            throw new MatchError((Object)timePrecisionType);
        }
        return right;
    }

    public Either<String, org.apache.avro.Schema> toAvroLocalDate(DateTimeFormatter formatter, Chunk<Object> annotations) {
        if (this.hasFormatToStringAnnotation(annotations)) {
            return new Right((Object)this.SchemaAvroExtensions(this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.StringDiscriminator(StringType$LocalDate$.MODULE$))).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
        }
        return new Right((Object)this.SchemaAvroExtensions(LogicalTypes.date().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT))).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
    }

    public Either<String, org.apache.avro.Schema> toAvroLocalTime(DateTimeFormatter formatter, Chunk<Object> annotations) {
        Right right;
        if (this.hasFormatToStringAnnotation(annotations)) {
            return new Right((Object)this.SchemaAvroExtensions(this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.StringDiscriminator(StringType$LocalTime$.MODULE$))).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
        }
        AvroAnnotations.TimePrecisionType timePrecisionType = (AvroAnnotations.TimePrecisionType)this.getTimeprecisionType(annotations).getOrElse((Function0 & Serializable)() -> AvroAnnotations$TimePrecisionType$.MODULE$.default());
        if (AvroAnnotations$TimePrecisionType$Millis$.MODULE$.equals(timePrecisionType)) {
            right = new Right((Object)this.SchemaAvroExtensions(LogicalTypes.timeMillis().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT))).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
        } else if (AvroAnnotations$TimePrecisionType$Micros$.MODULE$.equals(timePrecisionType)) {
            right = new Right((Object)this.SchemaAvroExtensions(LogicalTypes.timeMicros().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG))).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
        } else {
            throw new MatchError((Object)timePrecisionType);
        }
        return right;
    }

    public Either<String, org.apache.avro.Schema> toAvroLocalDateTime(DateTimeFormatter formatter, Chunk<Object> annotations) {
        Right right;
        if (this.hasFormatToStringAnnotation(annotations)) {
            return new Right((Object)this.SchemaAvroExtensions(this.SchemaAvroExtensions(org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING)).addMarkerProp(new AvroPropMarker.StringDiscriminator(StringType$LocalDateTime$.MODULE$))).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
        }
        org.apache.avro.Schema baseSchema = org.apache.avro.Schema.create((Schema.Type)Schema.Type.LONG);
        AvroAnnotations.TimePrecisionType timePrecisionType = (AvroAnnotations.TimePrecisionType)this.getTimeprecisionType(annotations).getOrElse((Function0 & Serializable)() -> AvroAnnotations$TimePrecisionType$.MODULE$.default());
        if (AvroAnnotations$TimePrecisionType$Millis$.MODULE$.equals(timePrecisionType)) {
            right = new Right((Object)this.SchemaAvroExtensions(LogicalTypes.localTimestampMillis().addToSchema(baseSchema)).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
        } else if (AvroAnnotations$TimePrecisionType$Micros$.MODULE$.equals(timePrecisionType)) {
            right = new Right((Object)this.SchemaAvroExtensions(LogicalTypes.localTimestampMicros().addToSchema(baseSchema)).addMarkerProp(new AvroPropMarker.Formatter(formatter)));
        } else {
            throw new MatchError((Object)timePrecisionType);
        }
        return right;
    }

    @Override
    public boolean hasAvroEnumAnnotation(Chunk<Object> annotations) {
        return annotations.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = AvroAnnotations$avroEnum$.MODULE$.equals(x0$1))));
    }

    @Override
    public org.apache.avro.Schema wrapAvro(org.apache.avro.Schema schemaAvro, String name2, AvroPropMarker marker) {
        Schema.Field field = new Schema.Field("value", schemaAvro);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(field);
        String prefixedName = new StringBuilder(1).append(AvroPropMarker$.MODULE$.wrapperNamePrefix()).append("_").append(name2).toString();
        return this.SchemaAvroExtensions(org.apache.avro.Schema.createRecord((String)prefixedName, null, (String)AvroPropMarker$.MODULE$.wrapperNamespace(), (boolean)false, fields)).addMarkerProp(marker);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Either<String, org.apache.avro.Schema> toAvroEnum(Schema.Enum<?> enu) {
        boolean avroEnumAnnotationExists = this.hasAvroEnumAnnotation((Chunk<Object>)enu.annotations());
        if (enu.structure().forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AvroCodec$.$anonfun$toAvroEnum$1(avroEnumAnnotationExists, x0$1)))) {
            return this.getName((Schema<?>)enu).map((Function1 & Serializable)name2 -> {
                String doc2 = (String)MODULE$.getDoc((Chunk<Object>)enu.annotations()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                return new Tuple2(name2, (Object)doc2);
            }).flatMap((Function1 & Serializable)x$13 -> {
                if (x$13 == null) {
                    throw new MatchError(null);
                }
                String name2 = (String)x$13._1();
                String doc2 = (String)x$13._2();
                Either either = MODULE$.getNamespace((Chunk<Object>)enu.annotations()).map((Function1 & Serializable)namespaceOption -> {
                    List symbols = ((IterableOnceOps)enu.structureWithAnnotations().map((Function1 & Serializable)x0$2 -> {
                        Tuple2 tuple2;
                        String symbol;
                        block3: {
                            block2: {
                                if (x0$2 == null) break block2;
                                symbol = (String)x0$2._1();
                                tuple2 = (Tuple2)x0$2._2();
                                if (tuple2 != null) break block3;
                            }
                            throw new MatchError(x0$2);
                        }
                        Chunk annotations = (Chunk)tuple2._2();
                        String string = (String)MODULE$.getNameOption((Chunk<Object>)annotations).getOrElse((Function0 & Serializable)() -> symbol);
                        return string;
                    })).toList();
                    org.apache.avro.Schema result = org.apache.avro.Schema.createEnum((String)name2, (String)doc2, (String)((String)namespaceOption.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)symbols).asJava());
                    return new Tuple3(namespaceOption, (Object)symbols, (Object)result);
                }).map((Function1 & Serializable)x$12 -> {
                    void var1_1;
                    if (x$12 == null) {
                        throw new MatchError(null);
                    }
                    org.apache.avro.Schema result = (org.apache.avro.Schema)x$12._3();
                    return var1_1;
                });
                return either;
            });
        }
        Tuple2 tuple2 = ((scala.collection.immutable.Iterable)enu.structureWithAnnotations().map((Function1 & Serializable)x0$3 -> {
            if (x0$3 != null) {
                String symbol = (String)x0$3._1();
                Tuple2 tuple2 = (Tuple2)x0$3._2();
                if (tuple2 != null) {
                    Schema schema;
                    Schema schema2 = (Schema)tuple2._1();
                    Chunk annotations = (Chunk)tuple2._2();
                    if (schema2 instanceof Schema.Transform && (schema = ((Schema.Transform)schema2).codec()) instanceof Schema.Primitive) {
                        StandardType standardType = ((Schema.Primitive)schema).standardType();
                        StandardType.UnitType$ unitType$ = StandardType.UnitType$.MODULE$;
                        if (standardType != null && standardType.equals(unitType$)) {
                            String name2 = (String)MODULE$.getNameOption((Chunk<Object>)annotations).getOrElse((Function0 & Serializable)() -> symbol);
                            return new Right((Object)org.apache.avro.Schema.createRecord((String)name2, null, null, (boolean)false, new ArrayList()));
                        }
                    }
                }
            }
            if (x0$3 == null) throw new MatchError(x0$3);
            String symbol = (String)x0$3._1();
            Tuple2 tuple2 = (Tuple2)x0$3._2();
            if (tuple2 == null) throw new MatchError(x0$3);
            Schema schema = (Schema)tuple2._1();
            Chunk annotations = (Chunk)tuple2._2();
            String name3 = (String)MODULE$.getNameOption((Chunk<Object>)annotations).getOrElse((Function0 & Serializable)() -> symbol);
            Schema<?> schemaWithName = MODULE$.addNameAnnotationIfMissing(schema, name3);
            return MODULE$.toAvroSchema(schemaWithName).map((Function1 & Serializable)x0$4 -> {
                if (x0$4 == null) return x0$4;
                Schema.Type type = x0$4.getType();
                Schema.Type type2 = Schema.Type.UNION;
                if (type != null) {
                    if (!type.equals(type2)) return x0$4;
                    return MODULE$.wrapAvro((org.apache.avro.Schema)x0$4, name3, AvroPropMarker$UnionWrapper$.MODULE$);
                }
                if (type2 == null) return MODULE$.wrapAvro((org.apache.avro.Schema)x0$4, name3, AvroPropMarker$UnionWrapper$.MODULE$);
                return x0$4;
            });
        })).toList().map((Function1 & Serializable)x$14 -> Either.MergeableEither$.MODULE$.merge$extension(Either$.MODULE$.MergeableEither(x$14))).partition((Function1 & Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)(bl = x0$5 instanceof String)));
        if (tuple2 != null) {
            List list = (List)tuple2._1();
            List right = (List)tuple2._2();
            Nil$ nil$ = package$.MODULE$.Nil();
            if (!(nil$ != null ? !nil$.equals(list) : list != null) && right instanceof List) {
                return new Right((Object)org.apache.avro.Schema.createUnion((java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((scala.collection.Seq)right).asJava()));
            }
        }
        if (tuple2 == null) throw new MatchError(null);
        List left = (List)tuple2._1();
        return package$.MODULE$.Left().apply((Object)left.mkString("\n"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Schema.Field> extractAvroFields(Schema.Record<?> record) {
        Tuple2 tuple2 = record.structure().map((Function1 & Serializable)value -> MODULE$.toAvroRecordField((Schema.Field<?>)value)).toList().map((Function1 & Serializable)x$15 -> Either.MergeableEither$.MODULE$.merge$extension(Either$.MODULE$.MergeableEither(x$15))).partition((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = x0$1 instanceof String)));
        if (tuple2 == null) return null;
        List list = (List)tuple2._1();
        List right = (List)tuple2._2();
        Nil$ nil$ = package$.MODULE$.Nil();
        if (nil$ == null) {
            if (list != null) {
                return null;
            }
        } else if (!nil$.equals(list)) return null;
        if (!(right instanceof List)) return null;
        return right;
    }

    public Either<String, org.apache.avro.Schema> toAvroRecord(Schema.Record<?> record) {
        return this.getName((Schema<?>)record).flatMap((Function1 & Serializable)name2 -> MODULE$.getNamespace((Chunk<Object>)record.annotations()).flatMap((Function1 & Serializable)namespaceOption -> new Right((Object)org.apache.avro.Schema.createRecord((String)name2, (String)((String)MODULE$.getDoc((Chunk<Object>)record.annotations()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (String)((String)namespaceOption.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (boolean)MODULE$.isErrorRecord(record), (java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava(MODULE$.extractAvroFields(record)).asJava())).map((Function1 & Serializable)result -> result)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Either<String, org.apache.avro.Schema> toAvroMap(Schema.MapSchema<?, ?> map) {
        Schema schema = map.ks();
        if (schema instanceof Schema.Primitive) {
            StandardType standardType = ((Schema.Primitive)schema).standardType();
            StandardType.StringType$ stringType$ = StandardType.StringType$.MODULE$;
            if (standardType != null && standardType.equals(stringType$)) {
                return this.toAvroSchema(map.vs()).map((Function1 & Serializable)valueType -> org.apache.avro.Schema.createMap((org.apache.avro.Schema)valueType));
            }
        }
        Schema.Tuple tupleSchema = new Schema.Tuple(map.ks(), map.vs(), Schema.Tuple$.MODULE$.apply$default$3()).annotate((Object)new AvroAnnotations.name("Tuple")).annotate((Object)new AvroAnnotations.namespace("scala"));
        return this.toAvroSchema((Schema<?>)tupleSchema).map((Function1 & Serializable)elementType -> org.apache.avro.Schema.createArray((org.apache.avro.Schema)elementType));
    }

    public Either<String, org.apache.avro.Schema> toAvroDecimal(Schema<?> schema) {
        Right right;
        StandardType standardType;
        int scale2 = BoxesRunTime.unboxToInt((Object)schema.annotations().collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object = x1 instanceof AvroAnnotations.scale ? BoxesRunTime.boxToInteger((int)((AvroAnnotations.scale)x1).scale()) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                boolean bl = x1 instanceof AvroAnnotations.scale;
                return bl;
            }
        }).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> new AvroAnnotations.scale(AvroAnnotations$scale$.MODULE$.apply$default$1()).scale()));
        int n = schema instanceof Schema.Primitive && StandardType.BigDecimalType$.MODULE$.equals(standardType = ((Schema.Primitive)schema).standardType()) ? BoxesRunTime.unboxToInt((Object)schema.annotations().collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object = x2 instanceof AvroAnnotations.precision ? BoxesRunTime.boxToInteger((int)((AvroAnnotations.precision)x2).precision()) : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x2) {
                boolean bl = x2 instanceof AvroAnnotations.precision;
                return bl;
            }
        }).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Math.max(scale2, new AvroAnnotations.precision(AvroAnnotations$precision$.MODULE$.apply$default$1()).precision()))) : scale2;
        AvroAnnotations.DecimalType decimalType = (AvroAnnotations.DecimalType)schema.annotations().collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object = x3 instanceof AvroAnnotations.decimal ? ((AvroAnnotations.decimal)x3).decimalType() : function1.apply(x3);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x3) {
                boolean bl = x3 instanceof AvroAnnotations.decimal;
                return bl;
            }
        }).getOrElse((Function0 & Serializable)() -> AvroAnnotations$DecimalType$.MODULE$.default());
        if (decimalType instanceof AvroAnnotations.DecimalType.Fixed) {
            int size = ((AvroAnnotations.DecimalType.Fixed)decimalType).size();
            right = this.getNamespace((Chunk<Object>)schema.annotations()).map((Function1 & Serializable)namespaceOption -> {
                String name2 = (String)MODULE$.getNameOption((Chunk<Object>)schema.annotations()).getOrElse((Function0 & Serializable)() -> new StringBuilder(9).append("Decimal_").append(n).append("_").append(scale2).toString());
                String doc2 = (String)MODULE$.getDoc((Chunk<Object>)schema.annotations()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                org.apache.avro.Schema result = org.apache.avro.Schema.createFixed((String)name2, (String)doc2, (String)((String)namespaceOption.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (int)size);
                return new Tuple4(namespaceOption, (Object)name2, (Object)doc2, (Object)result);
            }).map((Function1 & Serializable)x$16 -> {
                void var1_1;
                if (x$16 == null) {
                    throw new MatchError(null);
                }
                org.apache.avro.Schema result = (org.apache.avro.Schema)x$16._4();
                return var1_1;
            });
        } else if (AvroAnnotations$DecimalType$Bytes$.MODULE$.equals(decimalType)) {
            right = new Right((Object)org.apache.avro.Schema.create((Schema.Type)Schema.Type.BYTES));
        } else {
            throw new MatchError((Object)decimalType);
        }
        return right.map((Function1 & Serializable)x$17 -> LogicalTypes.decimal((int)n, (int)scale2).addToSchema(x$17));
    }

    public String toErrorMessage(Throwable err, Object at) {
        return new StringBuilder(41).append("Error mapping to Apache Avro schema: ").append(err).append(" at ").append(at.toString()).toString();
    }

    public Either<String, Schema.Field> toAvroRecordField(Schema.Field<?> value) {
        return this.toAvroSchema(value.schema()).map((Function1 & Serializable)schema -> new Schema.Field((String)MODULE$.getNameOption((Chunk<Object>)value.annotations()).getOrElse((Function0 & Serializable)() -> value.label()), schema, (String)MODULE$.getDoc((Chunk<Object>)value.annotations()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), MODULE$.getDefault((Chunk<Object>)value.annotations()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Schema.Field.Order)MODULE$.getFieldOrder((Chunk<Object>)value.annotations()).map((Function1 & Serializable)x$18 -> x$18.toAvroOrder()).getOrElse((Function0 & Serializable)() -> AvroAnnotations$FieldOrderType$.MODULE$.default().toAvroOrder())));
    }

    public Option<AvroAnnotations.FieldOrderType> getFieldOrder(Chunk<Object> annotations) {
        return annotations.collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object = x1 instanceof AvroAnnotations.fieldOrder ? ((AvroAnnotations.fieldOrder)x1).fieldOrderType() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                boolean bl = x1 instanceof AvroAnnotations.fieldOrder;
                return bl;
            }
        });
    }

    public Either<String, String> getName(Schema<?> schema) {
        Right right;
        Regex validNameRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[A-Za-z_][A-Za-z0-9_]*"));
        Option option = schema.annotations().collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object = x1 instanceof AvroAnnotations.name ? ((AvroAnnotations.name)x1).name() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                boolean bl = x1 instanceof AvroAnnotations.name;
                return bl;
            }
        });
        if (option instanceof Some) {
            Option option2;
            String s = (String)((Some)option).value();
            Object object = s != null && !(option2 = validNameRegex.unapplySeq((CharSequence)s)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(0) == 0 ? new Right((Object)s) : package$.MODULE$.Left().apply((Object)new StringBuilder(19).append("Invalid Avro name: ").append(s).toString());
            right = object;
        } else if (None$.MODULE$.equals(option)) {
            Right right2;
            if (schema instanceof Schema.Record) {
                Schema.Record record = (Schema.Record)schema;
                right2 = new Right((Object)record.id().name());
            } else if (schema instanceof Schema.Enum) {
                Schema.Enum enum_ = (Schema.Enum)schema;
                right2 = new Right((Object)enum_.id().name());
            } else {
                right2 = new Right((Object)new StringBuilder(7).append("hashed_").append(Integer.toString(schema.ast().toString().hashCode()).replaceFirst("-", "n")).toString());
            }
            right = right2;
        } else {
            throw new MatchError((Object)option);
        }
        return right;
    }

    public Option<String> getNameOption(Chunk<Object> annotations) {
        return annotations.collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object = x1 instanceof AvroAnnotations.name ? ((AvroAnnotations.name)x1).name() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                boolean bl = x1 instanceof AvroAnnotations.name;
                return bl;
            }
        });
    }

    public Option<String> getDoc(Chunk<Object> annotations) {
        return annotations.collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object = x1 instanceof AvroAnnotations.doc ? ((AvroAnnotations.doc)x1).doc() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                boolean bl = x1 instanceof AvroAnnotations.doc;
                return bl;
            }
        });
    }

    public Option<Object> getDefault(Chunk<Object> annotations) {
        return annotations.collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object = x1 instanceof AvroAnnotations.default ? ((AvroAnnotations.default)x1).javaDefaultObject() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                boolean bl = x1 instanceof AvroAnnotations.default;
                return bl;
            }
        });
    }

    public Either<String, Option<String>> getNamespace(Chunk<Object> annotations) {
        Right right;
        Regex validNamespaceRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[A-Za-z_][A-Za-z0-9_]*(\\.[A-Za-z_][A-Za-z0-9_]*)*"));
        Option option = annotations.collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object = x1 instanceof AvroAnnotations.namespace ? ((AvroAnnotations.namespace)x1).namespace() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                boolean bl = x1 instanceof AvroAnnotations.namespace;
                return bl;
            }
        });
        if (option instanceof Some) {
            Option option2;
            String s = (String)((Some)option).value();
            Object object = s != null && !(option2 = validNamespaceRegex.unapplySeq((CharSequence)s)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(1) == 0 ? new Right((Object)new Some((Object)s)) : package$.MODULE$.Left().apply((Object)new StringBuilder(24).append("Invalid Avro namespace: ").append(s).toString());
            right = object;
        } else if (None$.MODULE$.equals(option)) {
            right = new Right((Object)None$.MODULE$);
        } else {
            throw new MatchError((Object)option);
        }
        return right;
    }

    public boolean isErrorRecord(Schema.Record<?> record) {
        return record.annotations().collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object = AvroAnnotations$error$.MODULE$.equals(x1) ? BoxedUnit.UNIT : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                boolean bl = AvroAnnotations$error$.MODULE$.equals(x1);
                return bl;
            }
        }).nonEmpty();
    }

    public <B extends StaticAnnotation> Schema<?> addNameAnnotationIfMissing(Schema<?> schema, String name2) {
        return (Schema)schema.annotations().collectFirst((PartialFunction)new Serializable(schema){
            private static final long serialVersionUID = 0L;
            private final Schema schema$2;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object = x1 instanceof AvroAnnotations.name ? this.schema$2 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                boolean bl = x1 instanceof AvroAnnotations.name;
                return bl;
            }
            {
                this.schema$2 = schema$2;
            }
        }).getOrElse((Function0 & Serializable)() -> schema.annotate((Object)new AvroAnnotations.name(name2)));
    }

    public Either<String, Schema<?>> toZioDecimal(org.apache.avro.Schema avroSchema, AvroAnnotations.DecimalType decimalType) {
        int scale2;
        AvroAnnotations.decimal decimalTypeAnnotation = new AvroAnnotations.decimal(decimalType);
        LogicalTypes.Decimal decimalLogicalType = (LogicalTypes.Decimal)avroSchema.getLogicalType();
        int precision2 = decimalLogicalType.getPrecision();
        if (precision2 - (scale2 = decimalLogicalType.getScale()) > 0) {
            return new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.BigDecimalType$.MODULE$).annotate((Object)new AvroAnnotations.scale(scale2)).annotate((Object)new AvroAnnotations.precision(precision2)).annotate((Object)decimalTypeAnnotation));
        }
        return new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.BigIntegerType$.MODULE$).annotate((Object)new AvroAnnotations.scale(scale2)).annotate((Object)decimalTypeAnnotation));
    }

    /*
     * Enabled aggressive block sorting
     */
    public <A, Z> Either<String, Schema<Z>> toZioEnumeration(org.apache.avro.Schema avroSchema) {
        Left left;
        Tuple2 tuple2 = ((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(avroSchema.getTypes()).asScala().map(AvroCodec$::$anonfun$toZioEnumeration$1)).toList().map((Function1 & Serializable)x$20 -> Either.MergeableEither$.MODULE$.merge$extension(Either$.MODULE$.MergeableEither(x$20))).partition((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = x0$1 instanceof String)));
        if (tuple2 != null) {
            List list = (List)tuple2._1();
            List right = (List)tuple2._2();
            Nil$ nil$ = package$.MODULE$.Nil();
            if (!(nil$ != null ? !nil$.equals(list) : list != null) && right instanceof Seq) {
                left = Try$.MODULE$.apply((Function0 & Serializable)() -> CaseSet$.MODULE$.apply((Seq)right)).toEither().left().map((Function1 & Serializable)x$21 -> x$21.getMessage());
                return left.map((Function1 & Serializable)cs -> Schema$.MODULE$.enumeration(TypeId$.MODULE$.parse(avroSchema.getName()), cs));
            }
        }
        if (tuple2 == null) throw new MatchError(null);
        List left2 = (List)tuple2._1();
        left = package$.MODULE$.Left().apply((Object)left2.mkString("\n"));
        return left.map((Function1 & Serializable)cs -> Schema$.MODULE$.enumeration(TypeId$.MODULE$.parse(avroSchema.getName()), cs));
    }

    public Either<String, Schema<?>> toZioRecord(org.apache.avro.Schema avroSchema) {
        if (avroSchema.getObjectProp(AvroPropMarker$UnionWrapper$.MODULE$.propName()) != null) {
            Either<String, Schema<?>> either;
            Option option = CollectionConverters$.MODULE$.ListHasAsScala(avroSchema.getFields()).asScala().headOption();
            if (option instanceof Some) {
                Schema.Field value = (Schema.Field)((Some)option).value();
                either = this.toZioSchema(value.schema());
            } else if (None$.MODULE$.equals(option)) {
                either = package$.MODULE$.Left().apply((Object)"ZIO schema wrapped record must have a single field");
            } else {
                throw new MatchError((Object)option);
            }
            return either;
        }
        if (avroSchema.getObjectProp(AvroPropMarker$EitherWrapper$.MODULE$.propName()) != null) {
            Left left;
            Option option = CollectionConverters$.MODULE$.ListHasAsScala(avroSchema.getFields()).asScala().headOption();
            if (option instanceof Some) {
                Schema.Field value = (Schema.Field)((Some)option).value();
                left = this.toZioSchema(value.schema()).flatMap(AvroCodec$::$anonfun$toZioRecord$1);
            } else if (None$.MODULE$.equals(option)) {
                left = package$.MODULE$.Left().apply((Object)"ZIO schema wrapped record must have a single field");
            } else {
                throw new MatchError((Object)option);
            }
            return left;
        }
        Chunk<StaticAnnotation> annotations = this.buildZioAnnotations(avroSchema);
        return this.extractZioFields(avroSchema).map((Function1 & Serializable)fs -> {
            if (fs.isEmpty()) {
                return MODULE$.SchemaExtensions((Schema<?>)new Schema.Primitive((StandardType)StandardType.UnitType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2())).addAllAnnotations((Chunk<Object>)annotations);
            }
            return MODULE$.SchemaExtensions(Schema$.MODULE$.record(TypeId$.MODULE$.parse(avroSchema.getName()), (Seq)fs)).addAllAnnotations((Chunk<Object>)annotations);
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Either<String, List<Schema.Field<?>>> extractZioFields(org.apache.avro.Schema avroSchema) {
        Tuple2 tuple2 = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(avroSchema.getFields()).asScala().map((Function1 & Serializable)field -> MODULE$.toZioField((Schema.Field)field))).toList().map((Function1 & Serializable)x$22 -> Either.MergeableEither$.MODULE$.merge$extension(Either$.MODULE$.MergeableEither(x$22))).partition((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = x0$1 instanceof String)));
        if (tuple2 != null) {
            List list = (List)tuple2._1();
            List right = (List)tuple2._2();
            Nil$ nil$ = package$.MODULE$.Nil();
            if (!(nil$ != null ? !nil$.equals(list) : list != null) && right instanceof List) {
                return new Right((Object)right);
            }
        }
        if (tuple2 == null) throw new MatchError(null);
        List left = (List)tuple2._1();
        return package$.MODULE$.Left().apply((Object)left.mkString("\n"));
    }

    public Either<String, Schema.Field<?>> toZioField(Schema.Field field) {
        return this.toZioSchema(field.schema()).map((Function1 & Serializable)s -> new Schema.Field(field.name(), s, MODULE$.buildZioAnnotations(field), Schema.Field$.MODULE$.apply$default$4()));
    }

    public Either<String, Schema<?>> toZioTuple(org.apache.avro.Schema schema) {
        return package$.MODULE$.Either().cond(schema.getFields().size() == 2, (Function0)(JFunction0.mcV.sp & Serializable)() -> {}, (Function0 & Serializable)() -> new StringBuilder(33).append("Tuple must have exactly 2 fields:").append(schema.toString(false)).toString()).flatMap((Function1 & Serializable)x$23 -> MODULE$.toZioSchema(((Schema.Field)schema.getFields().get(0)).schema()).flatMap((Function1 & Serializable)_1 -> MODULE$.toZioSchema(((Schema.Field)schema.getFields().get(1)).schema()).map((Function1 & Serializable)_2 -> new Schema.Tuple(_1, _2, MODULE$.buildZioAnnotations(schema)))));
    }

    public Chunk<StaticAnnotation> buildZioAnnotations(org.apache.avro.Schema schema) {
        AvroAnnotations.name name2 = new AvroAnnotations.name(schema.getName());
        Option namespace2 = Try$.MODULE$.apply((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)schema.getNamespace()).map((Function1 & Serializable)namespace2 -> new AvroAnnotations.namespace((String)namespace2))).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
        None$ doc2 = schema.getDoc() != null ? new Some((Object)new AvroAnnotations.doc(schema.getDoc())) : None$.MODULE$;
        Option aliases2 = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            if (schema.getAliases() != null && !schema.getAliases().isEmpty()) {
                return new Some((Object)new AvroAnnotations.aliases((Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(schema.getAliases()).asScala().toSet()));
            }
            return None$.MODULE$;
        }).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option error = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            if (schema.isError()) {
                return new Some((Object)AvroAnnotations$error$.MODULE$);
            }
            return None$.MODULE$;
        }).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option option = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            if (schema.getEnumDefault() != null) {
                return new Some((Object)new AvroAnnotations.default(schema.getEnumDefault()));
            }
            return None$.MODULE$;
        }).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return (Chunk)((IterableOps)((IterableOps)((IterableOps)((IterableOps)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AvroAnnotations.name[]{name2})).$plus$plus((IterableOnce)namespace2)).$plus$plus((IterableOnce)doc2)).$plus$plus((IterableOnce)aliases2)).$plus$plus((IterableOnce)error)).$plus$plus((IterableOnce)option);
    }

    public Chunk<Object> buildZioAnnotations(Schema.Field field) {
        Some nameAnnotation = new Some((Object)new AvroAnnotations.name(field.name()));
        None$ docAnnotation = field.doc() != null ? new Some((Object)new AvroAnnotations.doc(field.doc())) : None$.MODULE$;
        None$ aliasesAnnotation = !field.aliases().isEmpty() ? new Some((Object)new AvroAnnotations.aliases((Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(field.aliases()).asScala().toSet())) : None$.MODULE$;
        Option option = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            if (field.hasDefaultValue()) {
                return new Some((Object)new AvroAnnotations.default(field.defaultVal()));
            }
            return None$.MODULE$;
        }).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Some orderAnnotation = new Some((Object)new AvroAnnotations.fieldOrder(AvroAnnotations$FieldOrderType$.MODULE$.fromAvroOrder(field.order())));
        Seq annotations = (Seq)((StrictOptimizedIterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{nameAnnotation, docAnnotation, aliasesAnnotation, orderAnnotation, option}))).flatten(Predef$.MODULE$.$conforms());
        return Chunk$.MODULE$.fromIterable((Iterable)annotations);
    }

    public Either<String, Schema<?>> toZioStringEnum(org.apache.avro.Schema avroSchema) {
        Seq cases = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(avroSchema.getEnumSymbols()).asScala().map((Function1 & Serializable)s -> new Schema.Case(s, Schema$.MODULE$.apply(Schema$.MODULE$.primitive((StandardType)StandardType.StringType$.MODULE$)), (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x), Schema.Case$.MODULE$.apply$default$4()))).toSeq();
        CaseSet caseSet = CaseSet$.MODULE$.apply(cases);
        Schema enumeration = Schema$.MODULE$.enumeration(TypeId$.MODULE$.parse("org.apache.avro.Schema"), caseSet);
        return new Right(this.SchemaExtensions(enumeration).addAllAnnotations(this.buildZioAnnotations(avroSchema)));
    }

    private AvroCodec.SchemaExtensions SchemaExtensions(Schema<?> schema) {
        return new AvroCodec.SchemaExtensions(schema);
    }

    private AvroCodec.SchemaAvroExtensions SchemaAvroExtensions(org.apache.avro.Schema schemaAvro) {
        return new AvroCodec.SchemaAvroExtensions(schemaAvro);
    }

    public static final /* synthetic */ Schema $anonfun$toZioSchema$4(Schema x$2) {
        return Schema$.MODULE$.list(x$2);
    }

    public static final /* synthetic */ Schema $anonfun$toZioSchema$5(Schema x$3) {
        return Schema$.MODULE$.map(Schema$.MODULE$.primitive((StandardType)StandardType.StringType$.MODULE$), x$3);
    }

    public static final /* synthetic */ Schema $anonfun$toZioSchema$6(Schema x$4) {
        return Schema$.MODULE$.option(x$4);
    }

    public static final /* synthetic */ Either $anonfun$toZioSchema$7(org.apache.avro.Schema right$1, Schema l) {
        return MODULE$.toZioSchema(right$1).map((Function1 & Serializable)r -> Schema$.MODULE$.either(l, r));
    }

    public static final /* synthetic */ Schema $anonfun$toZioSchema$9(org.apache.avro.Schema avroSchema$1, Schema x$5) {
        return MODULE$.SchemaExtensions(x$5).addAllAnnotations(MODULE$.buildZioAnnotations(avroSchema$1));
    }

    public static final /* synthetic */ DateTimeFormatter $anonfun$toZioSchema$10(AvroPropMarker.Formatter x$6) {
        return x$6.dateTimeFormatter();
    }

    public static final /* synthetic */ Right $anonfun$toZioSchema$11(StringType stringType$1, DateTimeFormatter formatter) {
        Right right;
        if (StringType$ZoneId$.MODULE$.equals(stringType$1)) {
            right = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.ZoneIdType$.MODULE$));
        } else if (StringType$Instant$.MODULE$.equals(stringType$1)) {
            right = new Right((Object)Schema$.MODULE$.primitive((StandardType)new StandardType.InstantType(formatter)).annotate((Object)AvroAnnotations$formatToString$.MODULE$));
        } else if (StringType$LocalDate$.MODULE$.equals(stringType$1)) {
            right = new Right((Object)Schema$.MODULE$.primitive((StandardType)new StandardType.LocalDateType(formatter)).annotate((Object)AvroAnnotations$formatToString$.MODULE$));
        } else if (StringType$LocalTime$.MODULE$.equals(stringType$1)) {
            right = new Right((Object)Schema$.MODULE$.primitive((StandardType)new StandardType.LocalTimeType(formatter)).annotate((Object)AvroAnnotations$formatToString$.MODULE$));
        } else if (StringType$LocalDateTime$.MODULE$.equals(stringType$1)) {
            right = new Right((Object)Schema$.MODULE$.primitive((StandardType)new StandardType.LocalDateTimeType(formatter)).annotate((Object)AvroAnnotations$formatToString$.MODULE$));
        } else if (StringType$OffsetTime$.MODULE$.equals(stringType$1)) {
            right = new Right((Object)Schema$.MODULE$.primitive((StandardType)new StandardType.OffsetTimeType(formatter)));
        } else if (StringType$OffsetDateTime$.MODULE$.equals(stringType$1)) {
            right = new Right((Object)Schema$.MODULE$.primitive((StandardType)new StandardType.OffsetDateTimeType(formatter)));
        } else if (StringType$ZoneDateTime$.MODULE$.equals(stringType$1)) {
            right = new Right((Object)Schema$.MODULE$.primitive((StandardType)new StandardType.ZonedDateTimeType(formatter)));
        } else {
            throw new MatchError((Object)stringType$1);
        }
        return right;
    }

    public static final /* synthetic */ Schema $anonfun$toZioSchema$12(AvroPropMarker.Formatter formatter) {
        return Schema$.MODULE$.primitive((StandardType)new StandardType.LocalTimeType(formatter.dateTimeFormatter()));
    }

    public static final /* synthetic */ Schema $anonfun$toZioSchema$13(AvroPropMarker.Formatter formatter) {
        return Schema$.MODULE$.primitive((StandardType)new StandardType.LocalDateType(formatter.dateTimeFormatter()));
    }

    public static final /* synthetic */ Schema $anonfun$toZioSchema$14(AvroPropMarker.Formatter formatter) {
        return Schema$.MODULE$.primitive((StandardType)new StandardType.LocalTimeType(formatter.dateTimeFormatter()));
    }

    public static final /* synthetic */ Schema $anonfun$toZioSchema$15(AvroPropMarker.Formatter formatter) {
        return Schema$.MODULE$.primitive((StandardType)new StandardType.InstantType(formatter.dateTimeFormatter()));
    }

    public static final /* synthetic */ Schema $anonfun$toZioSchema$16(AvroPropMarker.Formatter formatter) {
        return Schema$.MODULE$.primitive((StandardType)new StandardType.InstantType(formatter.dateTimeFormatter()));
    }

    public static final /* synthetic */ Schema $anonfun$toZioSchema$17(AvroPropMarker.Formatter formatter) {
        return Schema$.MODULE$.primitive((StandardType)new StandardType.LocalDateTimeType(formatter.dateTimeFormatter()));
    }

    public static final /* synthetic */ Schema $anonfun$toZioSchema$18(AvroPropMarker.Formatter formatter) {
        return Schema$.MODULE$.primitive((StandardType)new StandardType.LocalDateTimeType(formatter.dateTimeFormatter()));
    }

    public static final /* synthetic */ Schema $anonfun$toZioSchema$19(Schema result) {
        return result;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final /* synthetic */ Either $anonfun$toZioSchema$3(org.apache.avro.Schema avroSchema$1, LogicalType x$7) {
        block57: {
            block65: {
                block64: {
                    block63: {
                        block62: {
                            block61: {
                                block60: {
                                    block59: {
                                        block58: {
                                            block56: {
                                                var9_2 = avroSchema$1.getType();
                                                if (!Schema.Type.RECORD.equals(var9_2)) break block56;
                                                var10_3 = false;
                                                var11_4 = null;
                                                var12_5 = RecordType$.MODULE$.fromAvroRecord(avroSchema$1);
                                                if (!(var12_5 instanceof Some)) ** GOTO lbl-1000
                                                var10_3 = true;
                                                var11_4 = (Some)var12_5;
                                                var13_6 = (RecordType)var11_4.value();
                                                if (RecordType$Period$.MODULE$.equals(var13_6)) {
                                                    var8_7 = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.PeriodType$.MODULE$));
                                                } else if (var10_3 && RecordType$YearMonth$.MODULE$.equals(var14_8 = (RecordType)var11_4.value())) {
                                                    var8_7 = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.YearMonthType$.MODULE$));
                                                } else if (var10_3 && RecordType$Tuple$.MODULE$.equals(var15_9 = (RecordType)var11_4.value())) {
                                                    var8_7 = AvroCodec$.MODULE$.toZioTuple(avroSchema$1);
                                                } else if (var10_3 && RecordType$MonthDay$.MODULE$.equals(var16_10 = (RecordType)var11_4.value())) {
                                                    var8_7 = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.MonthDayType$.MODULE$));
                                                } else if (var10_3 && RecordType$Duration$.MODULE$.equals(var17_11 = (RecordType)var11_4.value())) {
                                                    var8_7 = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.DurationType$.MODULE$));
                                                } else if (None$.MODULE$.equals(var12_5)) {
                                                    var8_7 = AvroCodec$.MODULE$.toZioRecord(avroSchema$1);
                                                } else {
                                                    throw new MatchError(var12_5);
                                                }
                                                var2_12 = var8_7;
                                                break block57;
                                            }
                                            if (!Schema.Type.ENUM.equals(var9_2)) break block58;
                                            var2_12 = AvroCodec$.MODULE$.toZioStringEnum(avroSchema$1);
                                            break block57;
                                        }
                                        if (!Schema.Type.ARRAY.equals(var9_2)) break block59;
                                        var2_12 = AvroCodec$.MODULE$.toZioSchema(avroSchema$1.getElementType()).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toZioSchema$4(zio.schema.Schema ), (Lzio/schema/Schema;)Lzio/schema/Schema;)());
                                        break block57;
                                    }
                                    if (!Schema.Type.MAP.equals(var9_2)) break block60;
                                    var2_12 = AvroCodec$.MODULE$.toZioSchema(avroSchema$1.getValueType()).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toZioSchema$5(zio.schema.Schema ), (Lzio/schema/Schema;)Lzio/schema/Schema;)());
                                    break block57;
                                }
                                if (!Schema.Type.UNION.equals(var9_2)) break block61;
                                var18_13 = AvroCodec$OptionUnion$.MODULE$.unapply(avroSchema$1);
                                if (!var18_13.isEmpty()) {
                                    optionSchema = (org.apache.avro.Schema)var18_13.get();
                                    var7_15 = AvroCodec$.MODULE$.toZioSchema(optionSchema).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toZioSchema$6(zio.schema.Schema ), (Lzio/schema/Schema;)Lzio/schema/Schema;)());
                                } else if (avroSchema$1 != null && !(var20_16 = AvroCodec$EitherUnion$.MODULE$.unapply(avroSchema$1)).isEmpty()) {
                                    left = (org.apache.avro.Schema)((Tuple2)var20_16.get())._1();
                                    right = (org.apache.avro.Schema)((Tuple2)var20_16.get())._2();
                                    var7_15 = AvroCodec$.MODULE$.toZioSchema(left).flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toZioSchema$7(org.apache.avro.Schema zio.schema.Schema ), (Lzio/schema/Schema;)Lscala/util/Either;)((org.apache.avro.Schema)right));
                                } else {
                                    var7_15 = AvroCodec$.MODULE$.toZioEnumeration(avroSchema$1);
                                }
                                var2_12 = var7_15;
                                break block57;
                            }
                            if (!Schema.Type.FIXED.equals(var9_2)) break block62;
                            if (avroSchema$1.getLogicalType() == null) {
                                v0 = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.BinaryType$.MODULE$));
                            } else if (avroSchema$1.getLogicalType() instanceof LogicalTypes.Decimal) {
                                size = avroSchema$1.getFixedSize();
                                v0 = AvroCodec$.MODULE$.toZioDecimal(avroSchema$1, new AvroAnnotations.DecimalType.Fixed(size));
                            } else {
                                v0 = package$.MODULE$.Left().apply((Object)new StringBuilder(31).append("Unsupported fixed logical type ").append(avroSchema$1.getLogicalType()).toString());
                            }
                            var2_12 = v0.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toZioSchema$9(org.apache.avro.Schema zio.schema.Schema ), (Lzio/schema/Schema;)Lzio/schema/Schema;)((org.apache.avro.Schema)avroSchema$1));
                            break block57;
                        }
                        if (!Schema.Type.STRING.equals(var9_2)) break block63;
                        var24_20 = StringType$.MODULE$.fromAvroString(avroSchema$1);
                        if (var24_20 instanceof Some) {
                            stringType = (StringType)((Some)var24_20).value();
                            var6_22 = AvroPropMarker$Formatter$.MODULE$.fromAvroStringOrDefault(avroSchema$1, stringType).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toZioSchema$10(zio.schema.codec.AvroPropMarker$Formatter ), (Lzio/schema/codec/AvroPropMarker$Formatter;)Ljava/time/format/DateTimeFormatter;)()).flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toZioSchema$11(zio.schema.codec.StringType java.time.format.DateTimeFormatter ), (Ljava/time/format/DateTimeFormatter;)Lscala/util/Right;)((StringType)stringType));
                        } else if (None$.MODULE$.equals(var24_20)) {
                            if (avroSchema$1.getLogicalType() == null) {
                                v1 /* !! */  = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.StringType$.MODULE$));
                            } else {
                                v2 = avroSchema$1.getLogicalType().getName();
                                var26_23 = LogicalTypes.uuid().getName();
                                v1 /* !! */  = !(v2 != null ? v2.equals(var26_23) == false : var26_23 != null) ? new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.UUIDType$.MODULE$)) : package$.MODULE$.Left().apply((Object)new StringBuilder(33).append("Unsupported string logical type: ").append(avroSchema$1.getLogicalType().getName()).toString());
                            }
                            var6_22 = v1 /* !! */ ;
                        } else {
                            throw new MatchError(var24_20);
                        }
                        var2_12 = var6_22;
                        break block57;
                    }
                    if (!Schema.Type.BYTES.equals(var9_2)) break block64;
                    var2_12 = avroSchema$1.getLogicalType() == null ? new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.BinaryType$.MODULE$)) : (avroSchema$1.getLogicalType() instanceof LogicalTypes.Decimal != false ? AvroCodec$.MODULE$.toZioDecimal(avroSchema$1, AvroAnnotations$DecimalType$Bytes$.MODULE$) : package$.MODULE$.Left().apply((Object)new StringBuilder(31).append("Unsupported bytes logical type ").append(avroSchema$1.getLogicalType().getName()).toString()));
                    break block57;
                }
                if (!Schema.Type.INT.equals(var9_2)) break block65;
                var27_24 = false;
                var28_25 = null;
                var29_26 = IntType$.MODULE$.fromAvroInt(avroSchema$1);
                if (!(var29_26 instanceof Some)) ** GOTO lbl-1000
                var27_24 = true;
                var28_25 = (Some)var29_26;
                var30_27 = (IntType)var28_25.value();
                if (IntType$Char$.MODULE$.equals(var30_27)) {
                    var4_28 = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.CharType$.MODULE$));
                } else if (var27_24 && IntType$DayOfWeek$.MODULE$.equals(var31_29 = (IntType)var28_25.value())) {
                    var4_28 = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.DayOfWeekType$.MODULE$));
                } else if (var27_24 && IntType$Year$.MODULE$.equals(var32_30 = (IntType)var28_25.value())) {
                    var4_28 = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.YearType$.MODULE$));
                } else if (var27_24 && IntType$Short$.MODULE$.equals(var33_31 = (IntType)var28_25.value())) {
                    var4_28 = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.ShortType$.MODULE$));
                } else if (var27_24 && IntType$Month$.MODULE$.equals(var34_32 = (IntType)var28_25.value())) {
                    var4_28 = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.MonthType$.MODULE$));
                } else if (var27_24 && IntType$ZoneOffset$.MODULE$.equals(var35_33 = (IntType)var28_25.value())) {
                    var4_28 = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.ZoneOffsetType$.MODULE$));
                } else if (None$.MODULE$.equals(var29_26)) {
                    if (avroSchema$1.getLogicalType() == null) {
                        v3 = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.IntType$.MODULE$));
                    } else {
                        var36_34 = avroSchema$1.getLogicalType();
                        var5_35 /* !! */  = var36_34 instanceof LogicalTypes.TimeMillis != false ? AvroPropMarker$Formatter$.MODULE$.fromAvroStringOrDefault(avroSchema$1, avroSchema$1.getLogicalType()).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toZioSchema$12(zio.schema.codec.AvroPropMarker$Formatter ), (Lzio/schema/codec/AvroPropMarker$Formatter;)Lzio/schema/Schema;)()) : (var36_34 instanceof LogicalTypes.Date != false ? AvroPropMarker$Formatter$.MODULE$.fromAvroStringOrDefault(avroSchema$1, avroSchema$1.getLogicalType()).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toZioSchema$13(zio.schema.codec.AvroPropMarker$Formatter ), (Lzio/schema/codec/AvroPropMarker$Formatter;)Lzio/schema/Schema;)()) : package$.MODULE$.Left().apply((Object)new StringBuilder(29).append("Unsupported int logical type ").append(avroSchema$1.getLogicalType().getName()).toString()));
                        v3 = var5_35 /* !! */ ;
                    }
                    var4_28 = v3;
                } else {
                    throw new MatchError(var29_26);
                }
                var2_12 = var4_28;
                break block57;
            }
            if (Schema.Type.LONG.equals(var9_2)) {
                if (avroSchema$1.getLogicalType() == null) {
                    v4 = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.LongType$.MODULE$));
                } else {
                    var37_36 = avroSchema$1.getLogicalType();
                    var3_37 /* !! */  = var37_36 instanceof LogicalTypes.TimeMicros != false ? AvroPropMarker$Formatter$.MODULE$.fromAvroStringOrDefault(avroSchema$1, avroSchema$1.getLogicalType()).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toZioSchema$14(zio.schema.codec.AvroPropMarker$Formatter ), (Lzio/schema/codec/AvroPropMarker$Formatter;)Lzio/schema/Schema;)()) : (var37_36 instanceof LogicalTypes.TimestampMillis != false ? AvroPropMarker$Formatter$.MODULE$.fromAvroStringOrDefault(avroSchema$1, avroSchema$1.getLogicalType()).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toZioSchema$15(zio.schema.codec.AvroPropMarker$Formatter ), (Lzio/schema/codec/AvroPropMarker$Formatter;)Lzio/schema/Schema;)()) : (var37_36 instanceof LogicalTypes.TimestampMicros != false ? AvroPropMarker$Formatter$.MODULE$.fromAvroStringOrDefault(avroSchema$1, avroSchema$1.getLogicalType()).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toZioSchema$16(zio.schema.codec.AvroPropMarker$Formatter ), (Lzio/schema/codec/AvroPropMarker$Formatter;)Lzio/schema/Schema;)()) : (var37_36 instanceof LogicalTypes.LocalTimestampMillis != false ? AvroPropMarker$Formatter$.MODULE$.fromAvroStringOrDefault(avroSchema$1, avroSchema$1.getLogicalType()).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toZioSchema$17(zio.schema.codec.AvroPropMarker$Formatter ), (Lzio/schema/codec/AvroPropMarker$Formatter;)Lzio/schema/Schema;)()) : (var37_36 instanceof LogicalTypes.LocalTimestampMicros != false ? AvroPropMarker$Formatter$.MODULE$.fromAvroStringOrDefault(avroSchema$1, avroSchema$1.getLogicalType()).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toZioSchema$18(zio.schema.codec.AvroPropMarker$Formatter ), (Lzio/schema/codec/AvroPropMarker$Formatter;)Lzio/schema/Schema;)()) : package$.MODULE$.Left().apply((Object)new StringBuilder(30).append("Unsupported long logical type ").append(avroSchema$1.getLogicalType().getName()).toString())))));
                    v4 = var3_37 /* !! */ ;
                }
                var2_12 = v4;
            } else if (Schema.Type.FLOAT.equals(var9_2)) {
                var2_12 = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.FloatType$.MODULE$));
            } else if (Schema.Type.DOUBLE.equals(var9_2)) {
                var2_12 = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.DoubleType$.MODULE$));
            } else if (Schema.Type.BOOLEAN.equals(var9_2)) {
                var2_12 = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.BoolType$.MODULE$));
            } else if (Schema.Type.NULL.equals(var9_2)) {
                var2_12 = new Right((Object)Schema$.MODULE$.primitive((StandardType)StandardType.UnitType$.MODULE$));
            } else if (var9_2 == null) {
                var2_12 = package$.MODULE$.Left().apply((Object)new StringBuilder(17).append("Unsupported type ").append(avroSchema$1.getType()).toString());
            } else {
                throw new MatchError((Object)var9_2);
            }
        }
        return var2_12.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toZioSchema$19(zio.schema.Schema ), (Lzio/schema/Schema;)Lzio/schema/Schema;)());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$toAvroEnum$1(boolean avroEnumAnnotationExists$1, Tuple2 x0$1) {
        Schema schema;
        Schema schema2;
        if (x0$1 != null && (schema2 = (Schema)x0$1._2()) instanceof Schema.Transform && (schema = ((Schema.Transform)schema2).codec()) instanceof Schema.Primitive) {
            StandardType standardType = ((Schema.Primitive)schema).standardType();
            StandardType.UnitType$ unitType$ = StandardType.UnitType$.MODULE$;
            if (standardType != null && standardType.equals(unitType$) && avroEnumAnnotationExists$1) {
                return true;
            }
        }
        if (x0$1 == null) return false;
        Schema schema3 = (Schema)x0$1._2();
        if (!(schema3 instanceof Schema.Primitive)) return false;
        StandardType standardType = ((Schema.Primitive)schema3).standardType();
        StandardType.StringType$ stringType$ = StandardType.StringType$.MODULE$;
        if (standardType == null) return false;
        if (!standardType.equals(stringType$)) return false;
        return true;
    }

    public static final /* synthetic */ Schema.Case $anonfun$toZioEnumeration$2(org.apache.avro.Schema t$1, Schema s) {
        return new Schema.Case(t$1.getFullName(), s, (Function1 & Serializable)x$19 -> x$19, Schema.Case$.MODULE$.apply$default$4());
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Either $anonfun$toZioEnumeration$1(org.apache.avro.Schema t) {
        v0 = t.getType();
        var2_1 = Schema.Type.RECORD;
        if (v0 != null ? v0.equals(var2_1) == false : var2_1 != null) ** GOTO lbl-1000
        if (t.getFields().size() == 1 && BoxesRunTime.equals((Object)t.getObjectProp(AvroPropMarker$UnionWrapper$.MODULE$.propName()), (Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            v1 = ((Schema.Field)CollectionConverters$.MODULE$.ListHasAsScala(t.getFields()).asScala().head()).schema();
        } else lbl-1000:
        // 2 sources

        {
            v1 = t;
        }
        inner = v1;
        return AvroCodec$.MODULE$.toZioSchema(inner).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toZioEnumeration$2(org.apache.avro.Schema zio.schema.Schema ), (Lzio/schema/Schema;)Lzio/schema/Schema$Case;)((org.apache.avro.Schema)t));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Either $anonfun$toZioRecord$1(Schema x0$1) {
        block77: {
            block76: {
                if (!(x0$1 instanceof Schema.Enum)) break block76;
                var3_1 = ((Schema.Enum)x0$1).structure().toList();
                if (!(var3_1 instanceof .colon.colon)) ** GOTO lbl-1000
                var4_2 = (.colon.colon)var3_1;
                first = (Tuple2)var4_2.head();
                var6_4 = var4_2.next$access$1();
                if (!(var6_4 instanceof .colon.colon)) ** GOTO lbl-1000
                var7_5 = (.colon.colon)var6_4;
                second = (Tuple2)var7_5.head();
                var9_7 = var7_5.next$access$1();
                v0 = package$.MODULE$.Nil();
                if (!(v0 != null ? v0.equals(var9_7) == false : var9_7 != null)) {
                    var2_8 = new Right((Object)Schema$.MODULE$.either((Schema)first._2(), (Schema)second._2()));
                } else lbl-1000:
                // 3 sources

                {
                    var2_8 = package$.MODULE$.Left().apply((Object)"ZIO schema wrapped either must have exactly two cases");
                }
                var1_9 = var2_8;
                break block77;
            }
            if (x0$1 instanceof Schema.EitherSchema) {
                var10_10 = (Schema.EitherSchema)x0$1;
                var1_9 = new Right((Object)var10_10);
            } else if (x0$1 instanceof Schema.CaseClass0) {
                var11_11 = (Schema.CaseClass0)x0$1;
                var1_9 = new Right((Object)var11_11);
            } else if (x0$1 instanceof Schema.CaseClass1) {
                var12_12 = (Schema.CaseClass1)x0$1;
                var1_9 = new Right((Object)var12_12);
            } else if (x0$1 instanceof Schema.CaseClass2) {
                var13_13 = (Schema.CaseClass2)x0$1;
                var1_9 = new Right((Object)var13_13);
            } else if (x0$1 instanceof Schema.CaseClass3) {
                var14_14 = (Schema.CaseClass3)x0$1;
                var1_9 = new Right((Object)var14_14);
            } else if (x0$1 instanceof Schema.CaseClass4) {
                var15_15 = (Schema.CaseClass4)x0$1;
                var1_9 = new Right((Object)var15_15);
            } else if (x0$1 instanceof Schema.CaseClass5) {
                var16_16 = (Schema.CaseClass5)x0$1;
                var1_9 = new Right((Object)var16_16);
            } else if (x0$1 instanceof Schema.CaseClass6) {
                var17_17 = (Schema.CaseClass6)x0$1;
                var1_9 = new Right((Object)var17_17);
            } else if (x0$1 instanceof Schema.CaseClass7) {
                var18_18 = (Schema.CaseClass7)x0$1;
                var1_9 = new Right((Object)var18_18);
            } else if (x0$1 instanceof Schema.CaseClass8) {
                var19_19 = (Schema.CaseClass8)x0$1;
                var1_9 = new Right((Object)var19_19);
            } else if (x0$1 instanceof Schema.CaseClass9) {
                var20_20 = (Schema.CaseClass9)x0$1;
                var1_9 = new Right((Object)var20_20);
            } else if (x0$1 instanceof Schema.CaseClass10) {
                var21_21 = (Schema.CaseClass10)x0$1;
                var1_9 = new Right((Object)var21_21);
            } else if (x0$1 instanceof Schema.CaseClass11) {
                var22_22 = (Schema.CaseClass11)x0$1;
                var1_9 = new Right((Object)var22_22);
            } else if (x0$1 instanceof Schema.CaseClass12) {
                var23_23 = (Schema.CaseClass12)x0$1;
                var1_9 = new Right((Object)var23_23);
            } else if (x0$1 instanceof Schema.CaseClass13) {
                var24_24 = (Schema.CaseClass13)x0$1;
                var1_9 = new Right((Object)var24_24);
            } else if (x0$1 instanceof Schema.CaseClass14) {
                var25_25 = (Schema.CaseClass14)x0$1;
                var1_9 = new Right((Object)var25_25);
            } else if (x0$1 instanceof Schema.CaseClass15) {
                var26_26 = (Schema.CaseClass15)x0$1;
                var1_9 = new Right((Object)var26_26);
            } else if (x0$1 instanceof Schema.CaseClass16) {
                var27_27 = (Schema.CaseClass16)x0$1;
                var1_9 = new Right((Object)var27_27);
            } else if (x0$1 instanceof Schema.CaseClass17) {
                var28_28 = (Schema.CaseClass17)x0$1;
                var1_9 = new Right((Object)var28_28);
            } else if (x0$1 instanceof Schema.CaseClass18) {
                var29_29 = (Schema.CaseClass18)x0$1;
                var1_9 = new Right((Object)var29_29);
            } else if (x0$1 instanceof Schema.CaseClass19) {
                var30_30 = (Schema.CaseClass19)x0$1;
                var1_9 = new Right((Object)var30_30);
            } else if (x0$1 instanceof Schema.CaseClass20) {
                var31_31 = (Schema.CaseClass20)x0$1;
                var1_9 = new Right((Object)var31_31);
            } else if (x0$1 instanceof Schema.CaseClass21) {
                var32_32 = (Schema.CaseClass21)x0$1;
                var1_9 = new Right((Object)var32_32);
            } else if (x0$1 instanceof Schema.CaseClass22) {
                var33_33 = (Schema.CaseClass22)x0$1;
                var1_9 = new Right((Object)var33_33);
            } else if (x0$1 instanceof Schema.Dynamic) {
                var34_34 = (Schema.Dynamic)x0$1;
                var1_9 = new Right((Object)var34_34);
            } else if (x0$1 instanceof Schema.GenericRecord) {
                var35_35 = (Schema.GenericRecord)x0$1;
                var1_9 = new Right((Object)var35_35);
            } else if (x0$1 instanceof Schema.MapSchema) {
                var36_36 = (Schema.MapSchema)x0$1;
                var1_9 = new Right((Object)var36_36);
            } else if (x0$1 instanceof Schema.Sequence) {
                var37_37 = (Schema.Sequence)x0$1;
                var1_9 = new Right((Object)var37_37);
            } else if (x0$1 instanceof Schema.SetSchema) {
                var38_38 = (Schema.SetSchema)x0$1;
                var1_9 = new Right((Object)var38_38);
            } else if (x0$1 instanceof Schema.Fail) {
                var39_39 = (Schema.Fail)x0$1;
                var1_9 = new Right((Object)var39_39);
            } else if (x0$1 instanceof Schema.Lazy) {
                var40_40 = (Schema.Lazy)x0$1;
                var1_9 = new Right((Object)var40_40);
            } else if (x0$1 instanceof Schema.Meta) {
                var41_41 = (Schema.Meta)x0$1;
                var1_9 = new Right((Object)var41_41);
            } else if (x0$1 instanceof Schema.Optional) {
                var42_42 = (Schema.Optional)x0$1;
                var1_9 = new Right((Object)var42_42);
            } else if (x0$1 instanceof Schema.Primitive) {
                var43_43 = (Schema.Primitive)x0$1;
                var1_9 = new Right((Object)var43_43);
            } else if (x0$1 instanceof Schema.SemiDynamic) {
                var44_44 = (Schema.SemiDynamic)x0$1;
                var1_9 = new Right((Object)var44_44);
            } else if (x0$1 instanceof Schema.Transform) {
                var45_45 = (Schema.Transform)x0$1;
                var1_9 = new Right((Object)var45_45);
            } else if (x0$1 instanceof Schema.Tuple) {
                var46_46 = (Schema.Tuple)x0$1;
                var1_9 = new Right((Object)var46_46);
            } else {
                throw new MatchError((Object)x0$1);
            }
        }
        return var1_9;
    }

    private AvroCodec$() {
    }
}

