/*
 * Decompiled with CFR 0.152.
 */
package zio.query;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import zio.Chunk;
import zio.Chunk$;
import zio.NeedsEnv;
import zio.ZIO;
import zio.ZIO$;
import zio.query.CompletedRequestMap;
import zio.query.CompletedRequestMap$;
import zio.query.Described;
import zio.query.Described$;

public interface DataSource<R, A> {
    public String identifier();

    public ZIO<R, Nothing$, CompletedRequestMap> runAll(Chunk<Chunk<A>> var1);

    public static DataSource batchN$(DataSource $this, int n) {
        return $this.batchN(n);
    }

    default public DataSource<R, A> batchN(int n) {
        return new DataSource<R, A>(n, this){
            private final int n$1;
            private final String identifier;
            private final DataSource $outer;
            {
                this.n$1 = n$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.identifier = "" + $outer + ".batchN(" + n$1 + ")";
            }

            public String identifier() {
                return this.identifier;
            }

            public ZIO runAll(Chunk requests) {
                return this.n$1 < 1 ? ZIO$.MODULE$.die(DataSource::zio$query$DataSource$$anon$1$$_$runAll$$anonfun$1) : this.$outer.runAll((Chunk)requests.foldLeft((Object)Chunk$.MODULE$.empty(), (Function2 & Serializable)(_$1, _$2) -> (Chunk)_$1.$plus$plus((IterableOnce)_$2.grouped(this.n$1))));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{zio$query$DataSource$$anon$1$$_$runAll$$anonfun$1(), runAll$$anonfun$1(zio.Chunk zio.Chunk )}, serializedLambda);
            }
        };
    }

    public static DataSource contramap$(DataSource $this, Described f) {
        return $this.contramap(f);
    }

    default public <B> DataSource<R, B> contramap(Described<Function1<B, A>> f) {
        return new DataSource<R, B>(f, this){
            private final Described f$1;
            private final String identifier;
            private final DataSource $outer;
            {
                this.f$1 = f$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.identifier = "" + $outer.identifier() + ".contramap(" + f$1.description() + ")";
            }

            public String identifier() {
                return this.identifier;
            }

            public ZIO runAll(Chunk requests) {
                return this.$outer.runAll(requests.map((Function1 & Serializable)_$3 -> _$3.map((Function1)this.f$1.value())));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{runAll$$anonfun$1(zio.Chunk )}, serializedLambda);
            }
        };
    }

    public static DataSource contramapM$(DataSource $this, Described f) {
        return $this.contramapM(f);
    }

    default public <R1 extends R, B> DataSource<R1, B> contramapM(Described<Function1<B, ZIO<R1, Nothing$, A>>> f) {
        return new DataSource<R1, B>(f, this){
            private final Described f$1;
            private final String identifier;
            private final DataSource $outer;
            {
                this.f$1 = f$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.identifier = "" + $outer.identifier() + ".contramapM(" + f$3.description() + ")";
            }

            public String identifier() {
                return this.identifier;
            }

            public ZIO runAll(Chunk requests2) {
                return ZIO$.MODULE$.foreach((Iterable)requests2, (Function1 & Serializable)_$4 -> ZIO$.MODULE$.foreachPar((Iterable)_$4, (Function1)this.f$1.value(), BuildFrom$.MODULE$.buildFromIterableOps()), BuildFrom$.MODULE$.buildFromIterableOps()).flatMap((Function1 & Serializable)requests -> this.$outer.runAll(requests));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{runAll$$anonfun$1(zio.Chunk ), runAll$$anonfun$2(zio.Chunk )}, serializedLambda);
            }
        };
    }

    public static DataSource eitherWith$(DataSource $this, DataSource that, Described f) {
        return $this.eitherWith(that, f);
    }

    default public <R1 extends R, B, C> DataSource<R1, C> eitherWith(DataSource<R1, B> that, Described<Function1<C, Either<A, B>>> f) {
        return new DataSource<R1, C>(that, f, this){
            private final DataSource that$1;
            private final Described f$1;
            private final String identifier;
            private final DataSource $outer;
            {
                this.that$1 = that$1;
                this.f$1 = f$5;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.identifier = "" + $outer.identifier() + ".eitherWith(" + that$1.identifier() + ")(" + f$5.description() + ")";
            }

            public String identifier() {
                return this.identifier;
            }

            public ZIO runAll(Chunk requests2) {
                return ZIO$.MODULE$.foreach((Iterable)requests2, (Function1 & Serializable)requests -> {
                    Tuple2 tuple2 = requests.partitionMap((Function1)this.f$1.value());
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Chunk as = (Chunk)tuple2._1();
                    Chunk bs = (Chunk)tuple2._2();
                    Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)as, (Object)bs);
                    Chunk as2 = (Chunk)tuple22._1();
                    Chunk bs2 = (Chunk)tuple22._2();
                    return this.$outer.runAll(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Chunk[]{as2}))).zipWithPar(this.that$1.runAll(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Chunk[]{bs2}))), DataSource::zio$query$DataSource$$anon$4$$_$runAll$$anonfun$2$$anonfun$1);
                }, BuildFrom$.MODULE$.buildFromIterableOps()).map(DataSource::zio$query$DataSource$$anon$4$$_$runAll$$anonfun$4);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{runAll$$anonfun$1(zio.Chunk ), zio$query$DataSource$$anon$4$$_$runAll$$anonfun$4(zio.Chunk ), zio$query$DataSource$$anon$4$$_$runAll$$anonfun$2$$anonfun$1(zio.query.CompletedRequestMap zio.query.CompletedRequestMap )}, serializedLambda);
            }
        };
    }

    public static boolean equals$(DataSource $this, Object that) {
        return $this.equals(that);
    }

    default public boolean equals(Object that) {
        boolean bl;
        Object object = that;
        if (object instanceof DataSource) {
            DataSource that2 = (DataSource)object;
            String string = this.identifier();
            String string2 = that2.identifier();
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public static int hashCode$(DataSource $this) {
        return $this.hashCode();
    }

    default public int hashCode() {
        return this.identifier().hashCode();
    }

    public static DataSource provide$(DataSource $this, Described r, NeedsEnv ev) {
        return $this.provide(r, ev);
    }

    default public DataSource<Object, A> provide(Described<R> r, NeedsEnv<R> ev) {
        return this.provideSome(Described$.MODULE$.apply((Function1 & Serializable)_$10 -> r.value(), "_ => " + r.description()), ev);
    }

    public static DataSource provideSome$(DataSource $this, Described f, NeedsEnv ev) {
        return $this.provideSome(f, ev);
    }

    default public <R0> DataSource<R0, A> provideSome(Described<Function1<R0, R>> f, NeedsEnv<R> ev) {
        return new DataSource<R0, A>(f, ev, this){
            private final Described f$1;
            private final NeedsEnv ev$1;
            private final String identifier;
            private final DataSource $outer;
            {
                this.f$1 = f$7;
                this.ev$1 = ev$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.identifier = "" + $outer.identifier() + ".provideSome(" + f$7.description() + ")";
            }

            public String identifier() {
                return this.identifier;
            }

            public ZIO runAll(Chunk requests) {
                return this.$outer.runAll(requests).provideSome((Function1)this.f$1.value(), this.ev$1);
            }
        };
    }

    public static DataSource race$(DataSource $this, DataSource that) {
        return $this.race(that);
    }

    default public <R1 extends R, A1 extends A> DataSource<R1, A1> race(DataSource<R1, A1> that) {
        return new DataSource<R1, A1>(that, this){
            private final DataSource that$1;
            private final String identifier;
            private final DataSource $outer;
            {
                this.that$1 = that$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.identifier = "" + $outer.identifier() + ".race(" + that$3.identifier() + ")";
            }

            public String identifier() {
                return this.identifier;
            }

            public ZIO runAll(Chunk requests) {
                return this.$outer.runAll(requests).race(this.that$1.runAll(requests));
            }
        };
    }

    public static String toString$(DataSource $this) {
        return $this.toString();
    }

    default public String toString() {
        return this.identifier();
    }

    public static IllegalArgumentException zio$query$DataSource$$anon$1$$_$runAll$$anonfun$1() {
        return new IllegalArgumentException("batchN: n must be at least 1");
    }

    public static /* synthetic */ CompletedRequestMap zio$query$DataSource$$anon$4$$_$runAll$$anonfun$2$$anonfun$1(CompletedRequestMap _$5, CompletedRequestMap _$6) {
        return _$5.$plus$plus(_$6);
    }

    public static /* synthetic */ CompletedRequestMap zio$query$DataSource$$anon$4$$_$runAll$$anonfun$4(Chunk _$7) {
        return (CompletedRequestMap)_$7.foldLeft((Object)CompletedRequestMap$.MODULE$.empty(), (Function2 & Serializable)(_$8, _$9) -> _$8.$plus$plus((CompletedRequestMap)_$9));
    }

    public static interface Batched<R, A>
    extends DataSource<R, A> {
        public ZIO<R, Nothing$, CompletedRequestMap> run(Chunk<A> var1);

        public static ZIO runAll$(Batched $this, Chunk requests) {
            return $this.runAll(requests);
        }

        @Override
        default public ZIO<R, Nothing$, CompletedRequestMap> runAll(Chunk<Chunk<A>> requests) {
            return ZIO$.MODULE$.foldLeft(requests, (Object)CompletedRequestMap$.MODULE$.empty(), (Function2 & Serializable)(x$1, x$2) -> {
                CompletedRequestMap completedRequestMap;
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    completedRequestMap = (CompletedRequestMap)tuple2._1();
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Chunk requests = (Chunk)tuple2._2();
                Chunk newRequests = (Chunk)requests.filterNot((Function1 & Serializable)request -> completedRequestMap.contains(request));
                return newRequests.isEmpty() ? ZIO$.MODULE$.succeedNow((Object)completedRequestMap) : this.run(newRequests).map((Function1 & Serializable)_$11 -> completedRequestMap.$plus$plus((CompletedRequestMap)_$11));
            });
        }
    }
}

