/*
 * Decompiled with CFR 0.152.
 */
package zio.prelude;

import java.io.Serializable;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.prelude.Assertion$;
import zio.prelude.Assertion$And$;
import zio.prelude.Assertion$Between$;
import zio.prelude.Assertion$Contains$;
import zio.prelude.Assertion$DivisibleBy$;
import zio.prelude.Assertion$EndsWith$;
import zio.prelude.Assertion$EqualTo$;
import zio.prelude.Assertion$GreaterThan$;
import zio.prelude.Assertion$HasLength$;
import zio.prelude.Assertion$LessThan$;
import zio.prelude.Assertion$Matches$;
import zio.prelude.Assertion$Not$;
import zio.prelude.Assertion$Or$;
import zio.prelude.Assertion$PowerOf$;
import zio.prelude.Assertion$Regex$;
import zio.prelude.Assertion$Regex$AndThen$;
import zio.prelude.Assertion$Regex$Anything$;
import zio.prelude.Assertion$Regex$OrElse$;
import zio.prelude.Assertion$Regex$Repeat$;
import zio.prelude.Assertion$StartsWith$;
import zio.prelude.AssertionError;
import zio.prelude.AssertionError$;
import zio.prelude.AssertionError$Failure$;

public interface Assertion<A> {
    public static Assertion<Object> anything() {
        return Assertion$.MODULE$.anything();
    }

    public static <A> Assertion<A> between(A a, A a2, Ordering<A> ordering) {
        return Assertion$.MODULE$.between(a, a2, ordering);
    }

    public static Assertion<String> contains(String string) {
        return Assertion$.MODULE$.contains(string);
    }

    public static <A> Assertion<A> divisibleBy(A a, Numeric<A> numeric) {
        return Assertion$.MODULE$.divisibleBy(a, numeric);
    }

    public static Assertion<String> endsWith(String string) {
        return Assertion$.MODULE$.endsWith(string);
    }

    public static <A> Assertion<A> equalTo(A a) {
        return Assertion$.MODULE$.equalTo(a);
    }

    public static <A> Assertion<A> greaterThan(A a, Ordering<A> ordering) {
        return Assertion$.MODULE$.greaterThan(a, ordering);
    }

    public static <A> Assertion<A> greaterThanOrEqualTo(A a, Ordering<A> ordering) {
        return Assertion$.MODULE$.greaterThanOrEqualTo(a, ordering);
    }

    public static Assertion<String> hasLength(Assertion<Object> assertion) {
        return Assertion$.MODULE$.hasLength(assertion);
    }

    public static Assertion<String> isEmptyString() {
        return Assertion$.MODULE$.isEmptyString();
    }

    public static <A> Assertion<A> lessThan(A a, Ordering<A> ordering) {
        return Assertion$.MODULE$.lessThan(a, ordering);
    }

    public static <A> Assertion<A> lessThanOrEqualTo(A a, Ordering<A> ordering) {
        return Assertion$.MODULE$.lessThanOrEqualTo(a, ordering);
    }

    public static Assertion<String> matches(scala.util.matching.Regex regex) {
        return Assertion$.MODULE$.matches(regex);
    }

    public static Assertion<String> matches(Regex regex) {
        return Assertion$.MODULE$.matches(regex);
    }

    public static Assertion<String> matches(String string) {
        return Assertion$.MODULE$.matches(string);
    }

    public static Assertion<Object> never() {
        return Assertion$.MODULE$.never();
    }

    public static <A> Assertion<A> notEqualTo(A a) {
        return Assertion$.MODULE$.notEqualTo(a);
    }

    public static <A> Assertion<A> powerOf(A a, Numeric<A> numeric) {
        return Assertion$.MODULE$.powerOf(a, numeric);
    }

    public static Assertion<String> startsWith(String string) {
        return Assertion$.MODULE$.startsWith(string);
    }

    public static Assertion $amp$amp$(Assertion $this, Assertion that) {
        return $this.$amp$amp(that);
    }

    default public <A1 extends A> Assertion<A1> $amp$amp(Assertion<A1> that) {
        return Assertion$And$.MODULE$.apply(this, that);
    }

    public static Assertion $bar$bar$(Assertion $this, Assertion that) {
        return $this.$bar$bar(that);
    }

    default public <A1 extends A> Assertion<A1> $bar$bar(Assertion<A1> that) {
        return Assertion$Or$.MODULE$.apply(this, that);
    }

    public static Assertion unary_$bang$(Assertion $this) {
        return $this.unary_$bang();
    }

    default public Assertion<A> unary_$bang() {
        return Assertion$Not$.MODULE$.apply(this);
    }

    public static Either apply$(Assertion $this, Object a) {
        return $this.apply(a);
    }

    default public Either<AssertionError, BoxedUnit> apply(A a) {
        return this.apply(a, false);
    }

    public Either<AssertionError, BoxedUnit> apply(A var1, boolean var2);

    public static class And<A>
    implements Assertion<A>,
    Product,
    Serializable {
        private final Assertion left;
        private final Assertion right;

        public static And fromProduct(Product product) {
            return Assertion$And$.MODULE$.fromProduct(product);
        }

        public static <A> And<A> unapply(And<A> and) {
            return Assertion$And$.MODULE$.unapply(and);
        }

        public And(Assertion<A> left, Assertion<A> right) {
            this.left = left;
            this.right = right;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof And)) return false;
            And and = (And)object;
            Assertion<A> assertion = this.left();
            Assertion<A> assertion2 = and.left();
            if (assertion == null) {
                if (assertion2 != null) {
                    return false;
                }
            } else if (!assertion.equals(assertion2)) return false;
            Assertion<A> assertion3 = this.right();
            Assertion<A> assertion4 = and.right();
            if (assertion3 == null) {
                if (assertion4 != null) {
                    return false;
                }
            } else if (!assertion3.equals(assertion4)) return false;
            if (!and.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof And;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "And";
        }

        public Object productElement(int n) {
            Assertion<A> assertion;
            int n2 = n;
            if (0 == n2) {
                assertion = this._1();
            } else if (1 == n2) {
                assertion = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return assertion;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "left";
            } else if (1 == n2) {
                string = "right";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public Assertion<A> left() {
            return this.left;
        }

        public Assertion<A> right() {
            return this.right;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Either<AssertionError, BoxedUnit> apply(A a, boolean negated) {
            Right right;
            if (!negated) {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.left().apply(a, negated), this.right().apply(a, negated));
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Either either = (Either)tuple2._1();
                Either either2 = (Either)tuple2._2();
                if (either instanceof Right && either2 instanceof Right) {
                    right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                    return right;
                } else if (either instanceof Left) {
                    AssertionError assertionError;
                    AssertionError e1 = assertionError = (AssertionError)((Left)either).value();
                    if (either2 instanceof Left) {
                        AssertionError e2 = (AssertionError)((Left)either2).value();
                        right = package$.MODULE$.Left().apply((Object)e1.$plus$plus(e2));
                        return right;
                    } else {
                        AssertionError e12 = assertionError;
                        right = package$.MODULE$.Left().apply((Object)e12);
                    }
                    return right;
                } else {
                    if (!(either2 instanceof Left)) throw new MatchError((Object)tuple2);
                    AssertionError e2 = (AssertionError)((Left)either2).value();
                    right = package$.MODULE$.Left().apply((Object)e2);
                }
                return right;
            } else {
                right = this.left().unary_$bang().$bar$bar(this.right().unary_$bang()).apply(a, false);
            }
            return right;
        }

        public <A> And<A> copy(Assertion<A> left, Assertion<A> right) {
            return new And<A>(left, right);
        }

        public <A> Assertion<A> copy$default$1() {
            return this.left();
        }

        public <A> Assertion<A> copy$default$2() {
            return this.right();
        }

        public Assertion<A> _1() {
            return this.left();
        }

        public Assertion<A> _2() {
            return this.right();
        }
    }

    public static class Between<A>
    implements Assertion<A>,
    Product,
    Serializable {
        private final Object min;
        private final Object max;
        private final Ordering<A> ordering;

        public static <A> Between<A> unapply(Between<A> between) {
            return Assertion$Between$.MODULE$.unapply(between);
        }

        public Between(A min, A max, Ordering<A> ordering) {
            this.min = min;
            this.max = max;
            this.ordering = ordering;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Between)) return false;
            Between between = (Between)object;
            if (!BoxesRunTime.equals(this.min(), between.min())) return false;
            if (!BoxesRunTime.equals(this.max(), between.max())) return false;
            if (!between.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Between;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Between";
        }

        public Object productElement(int n) {
            A a;
            int n2 = n;
            if (0 == n2) {
                a = this._1();
            } else if (1 == n2) {
                a = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return a;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "min";
            } else if (1 == n2) {
                string = "max";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public A min() {
            return (A)this.min;
        }

        public A max() {
            return (A)this.max;
        }

        @Override
        public Either<AssertionError, BoxedUnit> apply(A a, boolean negated) {
            boolean result;
            boolean bl = result = this.ordering.gteq(a, this.min()) && this.ordering.lteq(a, this.max());
            return !negated ? (result ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)AssertionError$.MODULE$.failure(new StringBuilder(11).append("between(").append(this.min()).append(", ").append(this.max()).append(")").toString()))) : (!result ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)AssertionError$.MODULE$.failure(new StringBuilder(14).append("notBetween(").append(this.min()).append(", ").append(this.max()).append(")").toString())));
        }

        public <A> Between<A> copy(A min, A max, Ordering<A> ordering) {
            return new Between<A>(min, max, ordering);
        }

        public <A> A copy$default$1() {
            return this.min();
        }

        public <A> A copy$default$2() {
            return this.max();
        }

        public A _1() {
            return this.min();
        }

        public A _2() {
            return this.max();
        }
    }

    public static class Contains
    implements Assertion<String>,
    Product,
    Serializable {
        private final String string;

        public static Contains fromProduct(Product product) {
            return Assertion$Contains$.MODULE$.fromProduct(product);
        }

        public static Contains unapply(Contains contains) {
            return Assertion$Contains$.MODULE$.unapply(contains);
        }

        public Contains(String string) {
            this.string = string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Contains)) return false;
            Contains contains = (Contains)object;
            String string = this.string();
            String string2 = contains.string();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!contains.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Contains;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Contains";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "string";
        }

        public String string() {
            return this.string;
        }

        @Override
        public Either<AssertionError, BoxedUnit> apply(String a, boolean negated) {
            boolean result = a.contains(this.string());
            return !negated ? (result ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)AssertionError$Failure$.MODULE$.apply(new StringBuilder(10).append("contains(").append(this.string()).append(")").toString()))) : (result ? package$.MODULE$.Left().apply((Object)AssertionError$Failure$.MODULE$.apply(new StringBuilder(16).append("doesNotContain(").append(this.string()).append(")").toString())) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
        }

        public Contains copy(String string) {
            return new Contains(string);
        }

        public String copy$default$1() {
            return this.string();
        }

        public String _1() {
            return this.string();
        }
    }

    public static class DivisibleBy<A>
    implements Assertion<A>,
    Product,
    Serializable {
        private final Object n;
        private final Numeric<A> numeric;

        public static <A> DivisibleBy<A> unapply(DivisibleBy<A> divisibleBy) {
            return Assertion$DivisibleBy$.MODULE$.unapply(divisibleBy);
        }

        public DivisibleBy(A n, Numeric<A> numeric) {
            this.n = n;
            this.numeric = numeric;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DivisibleBy)) return false;
            DivisibleBy divisibleBy = (DivisibleBy)object;
            if (!BoxesRunTime.equals(this.n(), divisibleBy.n())) return false;
            if (!divisibleBy.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DivisibleBy;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "DivisibleBy";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "n";
        }

        public A n() {
            return (A)this.n;
        }

        @Override
        public Either<AssertionError, BoxedUnit> apply(A a, boolean negated) {
            boolean result;
            boolean bl = result = this.numeric.toDouble(a) % this.numeric.toDouble(this.n()) == 0.0;
            return !negated ? (result ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)AssertionError$Failure$.MODULE$.apply(new StringBuilder(13).append("divisibleBy(").append(this.n()).append(")").toString()))) : (!result ? package$.MODULE$.Left().apply((Object)AssertionError$Failure$.MODULE$.apply(new StringBuilder(16).append("notDivisibleBy(").append(this.n()).append(")").toString())) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
        }

        public <A> DivisibleBy<A> copy(A n, Numeric<A> numeric) {
            return new DivisibleBy<A>(n, numeric);
        }

        public <A> A copy$default$1() {
            return this.n();
        }

        public A _1() {
            return this.n();
        }
    }

    public static class EndsWith
    implements Assertion<String>,
    Product,
    Serializable {
        private final String suffix;

        public static EndsWith fromProduct(Product product) {
            return Assertion$EndsWith$.MODULE$.fromProduct(product);
        }

        public static EndsWith unapply(EndsWith endsWith) {
            return Assertion$EndsWith$.MODULE$.unapply(endsWith);
        }

        public EndsWith(String suffix) {
            this.suffix = suffix;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof EndsWith)) return false;
            EndsWith endsWith = (EndsWith)object;
            String string = this.suffix();
            String string2 = endsWith.suffix();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!endsWith.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof EndsWith;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "EndsWith";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "suffix";
        }

        public String suffix() {
            return this.suffix;
        }

        @Override
        public Either<AssertionError, BoxedUnit> apply(String a, boolean negated) {
            boolean result = a.endsWith(this.suffix());
            return !negated ? (result ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)AssertionError$Failure$.MODULE$.apply(new StringBuilder(12).append("startsWith(").append(this.suffix()).append(")").toString()))) : (result ? package$.MODULE$.Left().apply((Object)AssertionError$Failure$.MODULE$.apply(new StringBuilder(18).append("doesNotStartWith(").append(this.suffix()).append(")").toString())) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
        }

        public EndsWith copy(String suffix) {
            return new EndsWith(suffix);
        }

        public String copy$default$1() {
            return this.suffix();
        }

        public String _1() {
            return this.suffix();
        }
    }

    public static class EqualTo<A>
    implements Assertion<A>,
    Product,
    Serializable {
        private final Object value;

        public static EqualTo fromProduct(Product product) {
            return Assertion$EqualTo$.MODULE$.fromProduct(product);
        }

        public static <A> EqualTo<A> unapply(EqualTo<A> equalTo) {
            return Assertion$EqualTo$.MODULE$.unapply(equalTo);
        }

        public EqualTo(A value) {
            this.value = value;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof EqualTo)) return false;
            EqualTo equalTo = (EqualTo)object;
            if (!BoxesRunTime.equals(this.value(), equalTo.value())) return false;
            if (!equalTo.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof EqualTo;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "EqualTo";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "value";
        }

        public A value() {
            return (A)this.value;
        }

        @Override
        public Either<AssertionError, BoxedUnit> apply(A a, boolean negated) {
            return !negated ? (BoxesRunTime.equals(a, this.value()) ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)AssertionError$.MODULE$.failure(new StringBuilder(9).append("equalTo(").append(this.value()).append(")").toString()))) : (!BoxesRunTime.equals(a, this.value()) ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)AssertionError$.MODULE$.failure(new StringBuilder(12).append("notEqualTo(").append(this.value()).append(")").toString())));
        }

        public <A> EqualTo<A> copy(A value) {
            return new EqualTo<A>(value);
        }

        public <A> A copy$default$1() {
            return this.value();
        }

        public A _1() {
            return this.value();
        }
    }

    public static class GreaterThan<A>
    implements Assertion<A>,
    Product,
    Serializable {
        private final Object value;
        private final Ordering<A> ordering;

        public static <A> GreaterThan<A> unapply(GreaterThan<A> greaterThan) {
            return Assertion$GreaterThan$.MODULE$.unapply(greaterThan);
        }

        public GreaterThan(A value, Ordering<A> ordering) {
            this.value = value;
            this.ordering = ordering;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof GreaterThan)) return false;
            GreaterThan greaterThan = (GreaterThan)object;
            if (!BoxesRunTime.equals(this.value(), greaterThan.value())) return false;
            if (!greaterThan.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof GreaterThan;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "GreaterThan";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "value";
        }

        public A value() {
            return (A)this.value;
        }

        @Override
        public Either<AssertionError, BoxedUnit> apply(A a, boolean negated) {
            return !negated ? (this.ordering.gt(a, this.value()) ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)AssertionError$.MODULE$.failure(new StringBuilder(13).append("greaterThan(").append(this.value()).append(")").toString()))) : (this.ordering.lteq(a, this.value()) ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)AssertionError$.MODULE$.failure(new StringBuilder(19).append("lessThanOrEqualTo(").append(this.value()).append(")").toString())));
        }

        public <A> GreaterThan<A> copy(A value, Ordering<A> ordering) {
            return new GreaterThan<A>(value, ordering);
        }

        public <A> A copy$default$1() {
            return this.value();
        }

        public A _1() {
            return this.value();
        }
    }

    public static class HasLength<A>
    implements Assertion<String>,
    Product,
    Serializable {
        private final Assertion lengthAssertion;

        public static HasLength fromProduct(Product product) {
            return Assertion$HasLength$.MODULE$.fromProduct(product);
        }

        public static <A> HasLength<A> unapply(HasLength<A> hasLength) {
            return Assertion$HasLength$.MODULE$.unapply(hasLength);
        }

        public HasLength(Assertion<Object> lengthAssertion) {
            this.lengthAssertion = lengthAssertion;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof HasLength)) return false;
            HasLength hasLength = (HasLength)object;
            Assertion<Object> assertion = this.lengthAssertion();
            Assertion<Object> assertion2 = hasLength.lengthAssertion();
            if (assertion == null) {
                if (assertion2 != null) {
                    return false;
                }
            } else if (!assertion.equals(assertion2)) return false;
            if (!hasLength.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof HasLength;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "HasLength";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "lengthAssertion";
        }

        public Assertion<Object> lengthAssertion() {
            return this.lengthAssertion;
        }

        @Override
        public Either<AssertionError, BoxedUnit> apply(String string, boolean negated) {
            Left left;
            AssertionError assertionError;
            Left left2 = this.lengthAssertion().apply(BoxesRunTime.boxToInteger((int)string.length()), negated);
            if (left2 instanceof Left && (assertionError = (AssertionError)((Left)left2).value()) instanceof AssertionError.Failure) {
                String string2;
                AssertionError.Failure failure = AssertionError$Failure$.MODULE$.unapply((AssertionError.Failure)assertionError);
                String condition = string2 = failure._1();
                left = package$.MODULE$.Left().apply((Object)AssertionError$.MODULE$.failure(new StringBuilder(11).append("hasLength(").append(condition).append(")").toString()));
            } else {
                Left other;
                left = other = left2;
            }
            return left;
        }

        public <A> HasLength<A> copy(Assertion<Object> lengthAssertion) {
            return new HasLength<A>(lengthAssertion);
        }

        public <A> Assertion<Object> copy$default$1() {
            return this.lengthAssertion();
        }

        public Assertion<Object> _1() {
            return this.lengthAssertion();
        }
    }

    public static class LessThan<A>
    implements Assertion<A>,
    Product,
    Serializable {
        private final Object value;
        private final Ordering<A> ordering;

        public static <A> LessThan<A> unapply(LessThan<A> lessThan) {
            return Assertion$LessThan$.MODULE$.unapply(lessThan);
        }

        public LessThan(A value, Ordering<A> ordering) {
            this.value = value;
            this.ordering = ordering;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LessThan)) return false;
            LessThan lessThan = (LessThan)object;
            if (!BoxesRunTime.equals(this.value(), lessThan.value())) return false;
            if (!lessThan.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LessThan;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "LessThan";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "value";
        }

        public A value() {
            return (A)this.value;
        }

        @Override
        public Either<AssertionError, BoxedUnit> apply(A a, boolean negated) {
            return !negated ? (this.ordering.lt(a, this.value()) ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)AssertionError$.MODULE$.failure(new StringBuilder(10).append("lessThan(").append(this.value()).append(")").toString()))) : (this.ordering.gteq(a, this.value()) ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)AssertionError$.MODULE$.failure(new StringBuilder(22).append("greaterThanOrEqualTo(").append(this.value()).append(")").toString())));
        }

        public <A> LessThan<A> copy(A value, Ordering<A> ordering) {
            return new LessThan<A>(value, ordering);
        }

        public <A> A copy$default$1() {
            return this.value();
        }

        public A _1() {
            return this.value();
        }
    }

    public static class Matches
    implements Assertion<String>,
    Product,
    Serializable {
        private final String regexString;

        public static Matches fromProduct(Product product) {
            return Assertion$Matches$.MODULE$.fromProduct(product);
        }

        public static Matches unapply(Matches matches) {
            return Assertion$Matches$.MODULE$.unapply(matches);
        }

        public Matches(String regexString) {
            this.regexString = regexString;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Matches)) return false;
            Matches matches = (Matches)object;
            String string = this.regexString();
            String string2 = matches.regexString();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!matches.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Matches;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Matches";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "regexString";
        }

        public String regexString() {
            return this.regexString;
        }

        @Override
        public Either<AssertionError, BoxedUnit> apply(String a, boolean negated) {
            boolean result = a.matches(this.regexString());
            return !negated ? (result ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)AssertionError$Failure$.MODULE$.apply(new StringBuilder(9).append("matches(").append(StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(this.regexString()))).append(")").toString()))) : (result ? package$.MODULE$.Left().apply((Object)AssertionError$Failure$.MODULE$.apply(new StringBuilder(14).append("doesNotMatch(").append(StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(this.regexString()))).append(")").toString())) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
        }

        public Matches copy(String regexString) {
            return new Matches(regexString);
        }

        public String copy$default$1() {
            return this.regexString();
        }

        public String _1() {
            return this.regexString();
        }
    }

    public static class Not<A>
    implements Assertion<A>,
    Product,
    Serializable {
        private final Assertion assertion;

        public static Not fromProduct(Product product) {
            return Assertion$Not$.MODULE$.fromProduct(product);
        }

        public static <A> Not<A> unapply(Not<A> not) {
            return Assertion$Not$.MODULE$.unapply(not);
        }

        public Not(Assertion<A> assertion) {
            this.assertion = assertion;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Not)) return false;
            Not not = (Not)object;
            Assertion<A> assertion = this.assertion();
            Assertion<A> assertion2 = not.assertion();
            if (assertion == null) {
                if (assertion2 != null) {
                    return false;
                }
            } else if (!assertion.equals(assertion2)) return false;
            if (!not.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Not;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Not";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "assertion";
        }

        public Assertion<A> assertion() {
            return this.assertion;
        }

        @Override
        public Either<AssertionError, BoxedUnit> apply(A a, boolean negated) {
            return this.assertion().apply(a, !negated);
        }

        public <A> Not<A> copy(Assertion<A> assertion) {
            return new Not<A>(assertion);
        }

        public <A> Assertion<A> copy$default$1() {
            return this.assertion();
        }

        public Assertion<A> _1() {
            return this.assertion();
        }
    }

    public static class Or<A>
    implements Assertion<A>,
    Product,
    Serializable {
        private final Assertion left;
        private final Assertion right;

        public static Or fromProduct(Product product) {
            return Assertion$Or$.MODULE$.fromProduct(product);
        }

        public static <A> Or<A> unapply(Or<A> or) {
            return Assertion$Or$.MODULE$.unapply(or);
        }

        public Or(Assertion<A> left, Assertion<A> right) {
            this.left = left;
            this.right = right;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Or)) return false;
            Or or = (Or)object;
            Assertion<A> assertion = this.left();
            Assertion<A> assertion2 = or.left();
            if (assertion == null) {
                if (assertion2 != null) {
                    return false;
                }
            } else if (!assertion.equals(assertion2)) return false;
            Assertion<A> assertion3 = this.right();
            Assertion<A> assertion4 = or.right();
            if (assertion3 == null) {
                if (assertion4 != null) {
                    return false;
                }
            } else if (!assertion3.equals(assertion4)) return false;
            if (!or.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Or;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Or";
        }

        public Object productElement(int n) {
            Assertion<A> assertion;
            int n2 = n;
            if (0 == n2) {
                assertion = this._1();
            } else if (1 == n2) {
                assertion = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return assertion;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "left";
            } else if (1 == n2) {
                string = "right";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public Assertion<A> left() {
            return this.left;
        }

        public Assertion<A> right() {
            return this.right;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Either<AssertionError, BoxedUnit> apply(A a, boolean negated) {
            Right right;
            if (negated) {
                right = this.left().unary_$bang().$amp$amp(this.right().unary_$bang()).apply(a, false);
                return right;
            }
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.left().apply(a, negated), this.right().apply(a, negated));
            if (tuple2 != null) {
                Either either = (Either)tuple2._1();
                Either either2 = (Either)tuple2._2();
                if (either instanceof Left) {
                    AssertionError e1 = (AssertionError)((Left)either).value();
                    if (either2 instanceof Left) {
                        AssertionError e2 = (AssertionError)((Left)either2).value();
                        right = package$.MODULE$.Left().apply((Object)e1.$plus$plus(e2));
                        return right;
                    }
                }
            }
            right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            return right;
        }

        public <A> Or<A> copy(Assertion<A> left, Assertion<A> right) {
            return new Or<A>(left, right);
        }

        public <A> Assertion<A> copy$default$1() {
            return this.left();
        }

        public <A> Assertion<A> copy$default$2() {
            return this.right();
        }

        public Assertion<A> _1() {
            return this.left();
        }

        public Assertion<A> _2() {
            return this.right();
        }
    }

    public static class PowerOf<A>
    implements Assertion<A>,
    Product,
    Serializable {
        private final Object base;
        private final Numeric<A> numeric;

        public static <A> PowerOf<A> unapply(PowerOf<A> powerOf) {
            return Assertion$PowerOf$.MODULE$.unapply(powerOf);
        }

        public PowerOf(A base, Numeric<A> numeric) {
            this.base = base;
            this.numeric = numeric;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PowerOf)) return false;
            PowerOf powerOf = (PowerOf)object;
            if (!BoxesRunTime.equals(this.base(), powerOf.base())) return false;
            if (!powerOf.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PowerOf;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "PowerOf";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "base";
        }

        public A base() {
            return (A)this.base;
        }

        @Override
        public Either<AssertionError, BoxedUnit> apply(A a, boolean negated) {
            boolean result = this.isPower(this.numeric.toDouble(this.base()), this.numeric.toDouble(a));
            return !negated ? (result ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)AssertionError$Failure$.MODULE$.apply(new StringBuilder(9).append("powerOf(").append(this.base()).append(")").toString()))) : (!result ? package$.MODULE$.Left().apply((Object)AssertionError$Failure$.MODULE$.apply(new StringBuilder(12).append("notPowerOf(").append(this.base()).append(")").toString())) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
        }

        private boolean isPower(double base, double number) {
            double pow;
            if (base == 1.0) {
                return number == 1.0;
            }
            for (pow = 1.0; pow < number; pow *= base) {
            }
            return pow == number;
        }

        public <A> PowerOf<A> copy(A base, Numeric<A> numeric) {
            return new PowerOf<A>(base, numeric);
        }

        public <A> A copy$default$1() {
            return this.base();
        }

        public A _1() {
            return this.base();
        }
    }

    public static interface Regex {
        public static Regex alphanumeric() {
            return Assertion$Regex$.MODULE$.alphanumeric();
        }

        public static Regex anyChar() {
            return Assertion$Regex$.MODULE$.anyChar();
        }

        public static Regex anyCharOf(char c, char c2, Seq<Object> seq) {
            return Assertion$Regex$.MODULE$.anyCharOf(c, c2, seq);
        }

        public static Regex anyRegexOf(Regex regex, Regex regex2, Seq<Regex> seq) {
            return Assertion$Regex$.MODULE$.anyRegexOf(regex, regex2, seq);
        }

        public static Regex anything() {
            return Assertion$Regex$.MODULE$.anything();
        }

        public static Regex digit() {
            return Assertion$Regex$.MODULE$.digit();
        }

        public static Regex end() {
            return Assertion$Regex$.MODULE$.end();
        }

        public static Regex inRange(char c, char c2) {
            return Assertion$Regex$.MODULE$.inRange(c, c2);
        }

        public static Regex literal(String string) {
            return Assertion$Regex$.MODULE$.literal(string);
        }

        public static Regex nonAlphanumeric() {
            return Assertion$Regex$.MODULE$.nonAlphanumeric();
        }

        public static Regex nonDigit() {
            return Assertion$Regex$.MODULE$.nonDigit();
        }

        public static Regex nonWhitespace() {
            return Assertion$Regex$.MODULE$.nonWhitespace();
        }

        public static Regex notAnyCharOf(char c, char c2, Seq<Object> seq) {
            return Assertion$Regex$.MODULE$.notAnyCharOf(c, c2, seq);
        }

        public static Regex notAnyRegexOf(Regex regex, Regex regex2, Seq<Regex> seq) {
            return Assertion$Regex$.MODULE$.notAnyRegexOf(regex, regex2, seq);
        }

        public static Regex notInRange(char c, char c2) {
            return Assertion$Regex$.MODULE$.notInRange(c, c2);
        }

        public static int ordinal(Regex regex) {
            return Assertion$Regex$.MODULE$.ordinal(regex);
        }

        public static Regex start() {
            return Assertion$Regex$.MODULE$.start();
        }

        public static Regex whitespace() {
            return Assertion$Regex$.MODULE$.whitespace();
        }

        public static Regex $tilde$(Regex $this, Regex that) {
            return $this.$tilde(that);
        }

        default public Regex $tilde(Regex that) {
            return Assertion$Regex$AndThen$.MODULE$.apply(this, that);
        }

        public static Regex $bar$(Regex $this, Regex that) {
            return $this.$bar(that);
        }

        default public Regex $bar(Regex that) {
            return Assertion$Regex$OrElse$.MODULE$.apply(this, that);
        }

        public static Regex $times$(Regex $this) {
            return $this.$times();
        }

        default public Regex $times() {
            return this.min(0);
        }

        public static Regex $plus$(Regex $this) {
            return $this.$plus();
        }

        default public Regex $plus() {
            return this.min(1);
        }

        public static Regex $qmark$(Regex $this) {
            return $this.$qmark();
        }

        default public Regex $qmark() {
            return this.between(0, 1);
        }

        public static Regex between$(Regex $this, int min, int max) {
            return $this.between(min, max);
        }

        default public Regex between(int min, int max) {
            return Assertion$Regex$Repeat$.MODULE$.apply(this, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)min)), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)max)));
        }

        public static Regex min$(Regex $this, int n) {
            return $this.min(n);
        }

        default public Regex min(int n) {
            Repeat repeat;
            Regex regex = this;
            if (regex instanceof Repeat) {
                Repeat repeat2 = Assertion$Regex$Repeat$.MODULE$.unapply((Repeat)regex);
                Regex regex2 = repeat2._1();
                Option<Object> option = repeat2._2();
                Option<Object> option2 = repeat2._3();
                Regex regex3 = regex2;
                Option<Object> max = option2;
                repeat = Assertion$Regex$Repeat$.MODULE$.apply(regex3, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)n)), max);
            } else {
                Regex regex4 = regex;
                repeat = Assertion$Regex$Repeat$.MODULE$.apply(regex4, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)n)), (Option<Object>)None$.MODULE$);
            }
            return repeat;
        }

        public static Regex max$(Regex $this, int n) {
            return $this.max(n);
        }

        default public Regex max(int n) {
            Repeat repeat;
            Regex regex = this;
            if (regex instanceof Repeat) {
                Repeat repeat2 = Assertion$Regex$Repeat$.MODULE$.unapply((Repeat)regex);
                Regex regex2 = repeat2._1();
                Option<Object> option = repeat2._2();
                Option<Object> option2 = repeat2._3();
                Regex regex3 = regex2;
                Option<Object> min = option;
                repeat = Assertion$Regex$Repeat$.MODULE$.apply(regex3, min, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)n)));
            } else {
                Regex regex4 = regex;
                repeat = Assertion$Regex$Repeat$.MODULE$.apply(regex4, (Option<Object>)None$.MODULE$, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)n)));
            }
            return repeat;
        }

        public String compile();

        public static final class AndThen
        implements Regex,
        Product,
        Serializable {
            private final Regex first;
            private final Regex second;

            public static AndThen apply(Regex regex, Regex regex2) {
                return Assertion$Regex$AndThen$.MODULE$.apply(regex, regex2);
            }

            public static AndThen fromProduct(Product product) {
                return Assertion$Regex$AndThen$.MODULE$.fromProduct(product);
            }

            public static AndThen unapply(AndThen andThen) {
                return Assertion$Regex$AndThen$.MODULE$.unapply(andThen);
            }

            public AndThen(Regex first, Regex second) {
                this.first = first;
                this.second = second;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof AndThen)) return false;
                AndThen andThen = (AndThen)object;
                Regex regex = this.first();
                Regex regex2 = andThen.first();
                if (regex == null) {
                    if (regex2 != null) {
                        return false;
                    }
                } else if (!regex.equals(regex2)) return false;
                Regex regex3 = this.second();
                Regex regex4 = andThen.second();
                if (regex3 == null) {
                    if (regex4 == null) return true;
                    return false;
                } else {
                    if (!regex3.equals(regex4)) return false;
                    return true;
                }
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof AndThen;
            }

            public int productArity() {
                return 2;
            }

            public String productPrefix() {
                return "AndThen";
            }

            public Object productElement(int n) {
                Regex regex;
                int n2 = n;
                if (0 == n2) {
                    regex = this._1();
                } else if (1 == n2) {
                    regex = this._2();
                } else {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return regex;
            }

            public String productElementName(int n) {
                String string;
                int n2 = n;
                if (0 == n2) {
                    string = "first";
                } else if (1 == n2) {
                    string = "second";
                } else {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return string;
            }

            public Regex first() {
                return this.first;
            }

            public Regex second() {
                return this.second;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public String compile() {
                String string;
                Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)this.first(), (Object)this.second());
                if (tuple2 != null) {
                    Regex regex = (Regex)tuple2._1();
                    Regex regex2 = (Regex)tuple2._2();
                    Regex first = regex;
                    if (Assertion$Regex$Anything$.MODULE$.equals(regex2)) {
                        string = first.compile();
                        return string;
                    }
                    if (Assertion$Regex$Anything$.MODULE$.equals(regex)) {
                        Regex second = regex2;
                        string = second.compile();
                        return string;
                    }
                }
                string = new StringBuilder(0).append(this.first().compile()).append(this.second().compile()).toString();
                return string;
            }

            public AndThen copy(Regex first, Regex second) {
                return new AndThen(first, second);
            }

            public Regex copy$default$1() {
                return this.first();
            }

            public Regex copy$default$2() {
                return this.second();
            }

            public Regex _1() {
                return this.first();
            }

            public Regex _2() {
                return this.second();
            }
        }

        public static final class OrElse
        implements Regex,
        Product,
        Serializable {
            private final Regex first;
            private final Regex second;

            public static OrElse apply(Regex regex, Regex regex2) {
                return Assertion$Regex$OrElse$.MODULE$.apply(regex, regex2);
            }

            public static OrElse fromProduct(Product product) {
                return Assertion$Regex$OrElse$.MODULE$.fromProduct(product);
            }

            public static OrElse unapply(OrElse orElse) {
                return Assertion$Regex$OrElse$.MODULE$.unapply(orElse);
            }

            public OrElse(Regex first, Regex second) {
                this.first = first;
                this.second = second;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof OrElse)) return false;
                OrElse orElse = (OrElse)object;
                Regex regex = this.first();
                Regex regex2 = orElse.first();
                if (regex == null) {
                    if (regex2 != null) {
                        return false;
                    }
                } else if (!regex.equals(regex2)) return false;
                Regex regex3 = this.second();
                Regex regex4 = orElse.second();
                if (regex3 == null) {
                    if (regex4 == null) return true;
                    return false;
                } else {
                    if (!regex3.equals(regex4)) return false;
                    return true;
                }
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof OrElse;
            }

            public int productArity() {
                return 2;
            }

            public String productPrefix() {
                return "OrElse";
            }

            public Object productElement(int n) {
                Regex regex;
                int n2 = n;
                if (0 == n2) {
                    regex = this._1();
                } else if (1 == n2) {
                    regex = this._2();
                } else {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return regex;
            }

            public String productElementName(int n) {
                String string;
                int n2 = n;
                if (0 == n2) {
                    string = "first";
                } else if (1 == n2) {
                    string = "second";
                } else {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return string;
            }

            public Regex first() {
                return this.first;
            }

            public Regex second() {
                return this.second;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public String compile() {
                String string;
                Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)this.first(), (Object)this.second());
                if (tuple2 != null) {
                    Regex regex = (Regex)tuple2._1();
                    Regex regex2 = (Regex)tuple2._2();
                    Regex first = regex;
                    if (Assertion$Regex$Anything$.MODULE$.equals(regex2)) {
                        string = first.compile();
                        return string;
                    }
                    if (Assertion$Regex$Anything$.MODULE$.equals(regex)) {
                        Regex second = regex2;
                        string = second.compile();
                        return string;
                    }
                }
                string = new StringBuilder(3).append("(").append(this.first().compile()).append("|").append(this.second().compile()).append(")").toString();
                return string;
            }

            public OrElse copy(Regex first, Regex second) {
                return new OrElse(first, second);
            }

            public Regex copy$default$1() {
                return this.first();
            }

            public Regex copy$default$2() {
                return this.second();
            }

            public Regex _1() {
                return this.first();
            }

            public Regex _2() {
                return this.second();
            }
        }

        public static final class Repeat
        implements Regex,
        Product,
        Serializable {
            private final Regex regex;
            private final Option min;
            private final Option max;

            public static Repeat apply(Regex regex, Option<Object> option, Option<Object> option2) {
                return Assertion$Regex$Repeat$.MODULE$.apply(regex, option, option2);
            }

            public static Repeat fromProduct(Product product) {
                return Assertion$Regex$Repeat$.MODULE$.fromProduct(product);
            }

            public static Repeat unapply(Repeat repeat) {
                return Assertion$Regex$Repeat$.MODULE$.unapply(repeat);
            }

            public Repeat(Regex regex, Option<Object> min, Option<Object> max) {
                this.regex = regex;
                this.min = min;
                this.max = max;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Repeat)) return false;
                Repeat repeat = (Repeat)object;
                Regex regex = this.regex();
                Regex regex2 = repeat.regex();
                if (regex == null) {
                    if (regex2 != null) {
                        return false;
                    }
                } else if (!regex.equals(regex2)) return false;
                Option<Object> option = this.min();
                Option<Object> option2 = repeat.min();
                if (option == null) {
                    if (option2 != null) {
                        return false;
                    }
                } else if (!option.equals(option2)) return false;
                Option<Object> option3 = this.max();
                Option<Object> option4 = repeat.max();
                if (option3 == null) {
                    if (option4 == null) return true;
                    return false;
                } else {
                    if (!option3.equals(option4)) return false;
                    return true;
                }
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Repeat;
            }

            public int productArity() {
                return 3;
            }

            public String productPrefix() {
                return "Repeat";
            }

            public Object productElement(int n) {
                Option<Object> option;
                int n2 = n;
                switch (n2) {
                    case 0: {
                        option = this._1();
                        break;
                    }
                    case 1: {
                        option = this._2();
                        break;
                    }
                    case 2: {
                        option = this._3();
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                    }
                }
                return option;
            }

            public String productElementName(int n) {
                String string;
                int n2 = n;
                switch (n2) {
                    case 0: {
                        string = "regex";
                        break;
                    }
                    case 1: {
                        string = "min";
                        break;
                    }
                    case 2: {
                        string = "max";
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                    }
                }
                return string;
            }

            public Regex regex() {
                return this.regex;
            }

            public Option<Object> min() {
                return this.min;
            }

            public Option<Object> max() {
                return this.max;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public String compile() {
                String string;
                Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)this.regex(), this.min(), this.max());
                if (tuple3 == null) throw new MatchError((Object)tuple3);
                Option option = (Option)tuple3._2();
                Option option2 = (Option)tuple3._3();
                if (Assertion$Regex$Anything$.MODULE$.equals(tuple3._1())) {
                    string = Assertion$Regex$.MODULE$.anything().compile();
                    return string;
                }
                if (option instanceof Some) {
                    int n = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                    if (0 == n && option2 instanceof Some && 1 == BoxesRunTime.unboxToInt((Object)((Some)option2).value())) {
                        string = new StringBuilder(3).append("(").append(this.regex().compile()).append(")?").toString();
                        return string;
                    }
                    int min = n;
                    if (option2 instanceof Some) {
                        int max = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                        string = new StringBuilder(5).append("(").append(this.regex().compile()).append("){").append(min).append(",").append(max).append("}").toString();
                        return string;
                    }
                    if (0 == n && None$.MODULE$.equals(option2)) {
                        string = new StringBuilder(3).append("(").append(this.regex().compile()).append(")*").toString();
                        return string;
                    }
                    if (1 == n && None$.MODULE$.equals(option2)) {
                        string = new StringBuilder(3).append("(").append(this.regex().compile()).append(")+").toString();
                        return string;
                    }
                    int min2 = n;
                    if (None$.MODULE$.equals(option2)) {
                        string = new StringBuilder(5).append("(").append(this.regex().compile()).append("){").append(min2).append(",}").toString();
                        return string;
                    }
                }
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple3);
                if (option2 instanceof Some) {
                    int max = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    string = new StringBuilder(6).append("(").append(this.regex().compile()).append("){0,").append(max).append("}").toString();
                    return string;
                }
                if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)tuple3);
                string = this.regex().compile();
                return string;
            }

            public Repeat copy(Regex regex, Option<Object> min, Option<Object> max) {
                return new Repeat(regex, min, max);
            }

            public Regex copy$default$1() {
                return this.regex();
            }

            public Option<Object> copy$default$2() {
                return this.min();
            }

            public Option<Object> copy$default$3() {
                return this.max();
            }

            public Regex _1() {
                return this.regex();
            }

            public Option<Object> _2() {
                return this.min();
            }

            public Option<Object> _3() {
                return this.max();
            }
        }
    }

    public static class StartsWith
    implements Assertion<String>,
    Product,
    Serializable {
        private final String prefix;

        public static StartsWith fromProduct(Product product) {
            return Assertion$StartsWith$.MODULE$.fromProduct(product);
        }

        public static StartsWith unapply(StartsWith startsWith) {
            return Assertion$StartsWith$.MODULE$.unapply(startsWith);
        }

        public StartsWith(String prefix) {
            this.prefix = prefix;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StartsWith)) return false;
            StartsWith startsWith = (StartsWith)object;
            String string = this.prefix();
            String string2 = startsWith.prefix();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!startsWith.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StartsWith;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "StartsWith";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "prefix";
        }

        public String prefix() {
            return this.prefix;
        }

        @Override
        public Either<AssertionError, BoxedUnit> apply(String a, boolean negated) {
            boolean result = a.startsWith(this.prefix());
            return !negated ? (result ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)AssertionError$Failure$.MODULE$.apply(new StringBuilder(12).append("startsWith(").append(this.prefix()).append(")").toString()))) : (result ? package$.MODULE$.Left().apply((Object)AssertionError$Failure$.MODULE$.apply(new StringBuilder(18).append("doesNotStartWith(").append(this.prefix()).append(")").toString())) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
        }

        public StartsWith copy(String prefix) {
            return new StartsWith(prefix);
        }

        public String copy$default$1() {
            return this.prefix();
        }

        public String _1() {
            return this.prefix();
        }
    }
}

