/*
 * Decompiled with CFR 0.152.
 */
package zio.openai.internal;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Right;
import scala.util.control.NonFatal$;
import zio.Chunk;
import zio.Chunk$;
import zio.http.Body;
import zio.http.Body$;
import zio.openai.internal.Encoders;
import zio.openai.internal.Encoders$ToJsonBody$;
import zio.openai.internal.Encoders$URLSegmentEncoder$;
import zio.openai.model.File;
import zio.openai.model.File$;
import zio.schema.Schema;
import zio.schema.Schema$;
import zio.schema.StandardType;

public final class Encoders$
implements Serializable {
    public static final Encoders$ToJsonBody$ ToJsonBody;
    public static final Encoders$URLSegmentEncoder$ URLSegmentEncoder;
    public static final Encoders$ MODULE$;

    private Encoders$() {
    }

    static {
        MODULE$ = new Encoders$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Encoders$.class);
    }

    public <T> BoxedUnit toJsonBody() {
        return BoxedUnit.UNIT;
    }

    public <T> String toURLSegment(T value, Encoders.URLSegmentEncoder<T> encoder) {
        return encoder.encode(value);
    }

    public <T> Either<String, Body> toMultipartFormDataBody(T value, String boundary, Schema<T> evidence$1) {
        Right right;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(buffer);
        try {
            this.toMultipartFormDataBody(Schema$.MODULE$.apply(evidence$1), value, boundary, (Chunk<Object>)Chunk$.MODULE$.empty(), output);
            output.flush();
            Chunk bytes = Chunk$.MODULE$.fromArray((Object)buffer.toByteArray());
            right = package$.MODULE$.Right().apply((Object)Body$.MODULE$.fromChunk(bytes));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable err = throwable3 = (Throwable)option.get();
                right = package$.MODULE$.Left().apply((Object)err.getMessage());
            }
            throw throwable;
        }
        return right;
    }

    private <T> void toMultipartFormDataBody(Schema<T> schema, T value, String boundary, Chunk<Object> header, DataOutputStream output) {
        Schema schema2;
        while (true) {
            Function0 function0;
            schema2 = schema;
            Schema schema3 = schema;
            Schema<File> schema4 = File$.MODULE$.schema();
            if (!(schema3 != null ? !schema3.equals(schema4) : schema4 != null)) {
                output.write((byte[])header.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
                output.write((byte[])((File)value).data().toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
                return;
            }
            if (schema2 instanceof Schema.Enum) {
                throw new IllegalArgumentException("Cannot encode enum as multipart/form-data");
            }
            if (schema2 instanceof Schema.Record) {
                Schema.Record record = (Schema.Record)schema2;
                if (header.isEmpty()) {
                    record.fields().zipWithIndex().withFilter((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            Schema.Field field = (Schema.Field)tuple2._1();
                            int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                            return true;
                        }
                        return false;
                    }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            Schema.Field field = (Schema.Field)tuple2._1();
                            int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                            StringBuilder headerBuilder = new StringBuilder();
                            headerBuilder.append("--");
                            headerBuilder.append(boundary);
                            headerBuilder.append('\n');
                            headerBuilder.append("Content-Disposition: form-data; name=\"");
                            headerBuilder.append(field.name());
                            headerBuilder.append("\"");
                            Schema schema = field.schema();
                            Schema<File> schema2 = File$.MODULE$.schema();
                            if (!(schema != null ? !schema.equals(schema2) : schema2 != null)) {
                                headerBuilder.append(new java.lang.StringBuilder(13).append("; filename=\"").append(((File)field.get().apply(value)).fileName()).append("\"").toString());
                            }
                            headerBuilder.append("\n\n");
                            Chunk header = Chunk$.MODULE$.fromArray((Object)headerBuilder.toString().getBytes(StandardCharsets.UTF_8));
                            this.toMultipartFormDataBody(field.schema(), field.get().apply(value), boundary, (Chunk<Object>)header, output);
                            if (idx < record.fields().length() - 1) {
                                output.write(10);
                                return;
                            }
                            return;
                        }
                        throw new MatchError((Object)tuple2);
                    });
                    this.writeString$1(header, output, "--");
                    this.writeString$1(header, output, boundary);
                    this.writeString$1(header, output, "--");
                    return;
                }
                throw new IllegalArgumentException("Cannot encode nested record as multipart/form-data");
            }
            if (schema2 instanceof Schema.Sequence) {
                Schema.Sequence sequence = Schema.Sequence$.MODULE$.unapply((Schema.Sequence)schema2);
                Schema schema5 = sequence._1();
                Function1 function1 = sequence._2();
                Function1 function12 = sequence._3();
                Chunk chunk = sequence._4();
                Object object = sequence._5();
                Schema elemSchema = schema5;
                Function1 toChunk = function12;
                Schema schema6 = elemSchema;
                if (schema6 instanceof Schema.Primitive) {
                    Schema.Primitive primitive = Schema.Primitive$.MODULE$.unapply((Schema.Primitive)schema6);
                    StandardType standardType = primitive._1();
                    Chunk chunk2 = primitive._2();
                    if (StandardType.ByteType$.MODULE$.equals(standardType)) {
                        Chunk data = (Chunk)toChunk.apply(value);
                        output.write((byte[])header.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
                        output.write((byte[])data.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
                        return;
                    }
                }
                throw new IllegalArgumentException("Cannot encode collections as multipart/form-data");
            }
            if (schema2 instanceof Schema.Collection) {
                throw new IllegalArgumentException("Cannot encode collections as multipart/form-data");
            }
            if (schema2 instanceof Schema.Transform) {
                Schema.Transform transform = Schema.Transform$.MODULE$.unapply((Schema.Transform)schema2);
                Schema schema7 = transform._1();
                Function1 function1 = transform._2();
                Function1 function13 = transform._3();
                Chunk chunk = transform._4();
                Object object = transform._5();
                Schema schema8 = schema7;
                Function1 g = function13;
                ((Either)g.apply(value)).foreach((Function1)(JProcedure1 & Serializable)inner -> this.toMultipartFormDataBody(schema8, inner, boundary, header, output));
                return;
            }
            if (schema2 instanceof Schema.Primitive) {
                Schema.Primitive primitive = Schema.Primitive$.MODULE$.unapply((Schema.Primitive)schema2);
                StandardType standardType = primitive._1();
                Chunk chunk = primitive._2();
                StandardType standardType2 = standardType;
                StandardType standardType3 = standardType2;
                if (StandardType.UnitType$.MODULE$.equals(standardType3)) {
                    return;
                }
                if (StandardType.StringType$.MODULE$.equals(standardType3)) {
                    this.writeString$1(header, output, (String)value);
                    return;
                }
                if (StandardType.BoolType$.MODULE$.equals(standardType3)) {
                    if (BoxesRunTime.unboxToBoolean(value)) {
                        this.writeString$1(header, output, "true");
                        return;
                    }
                    this.writeString$1(header, output, "false");
                    return;
                }
                if (StandardType.BinaryType$.MODULE$.equals(standardType3)) {
                    Chunk bytes = (Chunk)value;
                    output.write((byte[])header.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
                    output.write((byte[])bytes.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
                    return;
                }
                this.writeString$1(header, output, value.toString());
                return;
            }
            if (schema2 instanceof Schema.Optional) {
                Schema.Optional optional = Schema.Optional$.MODULE$.unapply((Schema.Optional)schema2);
                Schema schema9 = optional._1();
                Chunk chunk = optional._2();
                Schema inner2 = schema9;
                Option option = (Option)value;
                if (option instanceof Some) {
                    Object innerValue = ((Some)option).value();
                    Schema schema10 = inner2;
                    Object object = innerValue;
                    schema = schema10;
                    value = object;
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    return;
                }
                throw new MatchError((Object)option);
            }
            if (schema2 instanceof Schema.Fail) {
                Schema.Fail fail = Schema.Fail$.MODULE$.unapply((Schema.Fail)schema2);
                String string = fail._1();
                Chunk chunk = fail._2();
                String message = string;
                Chunk annotations = chunk;
                throw new IllegalStateException(message);
            }
            if (schema2 instanceof Schema.Tuple2) {
                Schema.Tuple2 tuple2 = Schema.Tuple2$.MODULE$.unapply((Schema.Tuple2)schema2);
                Schema schema11 = tuple2._1();
                Schema schema12 = tuple2._2();
                Chunk chunk = tuple2._3();
                throw new IllegalArgumentException("Cannot encode tuple as multipart/form-data");
            }
            if (schema2 instanceof Schema.Either) {
                Schema.Either either = Schema.Either$.MODULE$.unapply((Schema.Either)schema2);
                Schema schema13 = either._1();
                Schema schema14 = either._2();
                Chunk chunk = either._3();
                throw new IllegalArgumentException("Cannot encode either as multipart/form-data");
            }
            if (!(schema2 instanceof Schema.Lazy)) break;
            Schema.Lazy lazy = Schema.Lazy$.MODULE$.unapply((Schema.Lazy)schema2);
            Function0 schema0 = function0 = lazy._1();
            schema = (Schema)schema0.apply();
        }
        if (schema2 instanceof Schema.Dynamic) {
            Schema.Dynamic dynamic = Schema.Dynamic$.MODULE$.unapply((Schema.Dynamic)schema2);
            Chunk chunk = dynamic._1();
            throw new IllegalArgumentException("Cannot encode dynamic as multipart/form-data");
        }
        throw new MatchError(schema2);
    }

    private final void writeString$1(Chunk header$1, DataOutputStream output$1, String s) {
        output$1.write((byte[])header$1.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
        output$1.write(s.getBytes(StandardCharsets.UTF_8));
    }
}

