/*
 * Decompiled with CFR 0.152.
 */
package zio.openai.internal;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import zio.Chunk;
import zio.Chunk$;
import zio.http.Body;
import zio.http.Body$;
import zio.http.Boundary;
import zio.http.Form;
import zio.http.FormField;
import zio.http.FormField$;
import zio.http.MediaType$;
import zio.openai.internal.Encoders;
import zio.openai.model.File;
import zio.openai.model.File$;
import zio.prelude.AssociativeBoth$;
import zio.prelude.Covariant;
import zio.prelude.Invariant$;
import zio.prelude.package$;
import zio.schema.Schema;
import zio.schema.Schema$;
import zio.schema.StandardType;

public final class Encoders$ {
    public static final Encoders$ MODULE$ = new Encoders$();

    public <T> BoxedUnit toJsonBody() {
        return BoxedUnit.UNIT;
    }

    public <T> String toURLSegment(T value, Encoders.URLSegmentEncoder<T> encoder) {
        return encoder.encode(value);
    }

    public <T> Either<String, Body> toMultipartFormDataBody(T value, Boundary boundary, Schema<T> evidence$1) {
        return this.toMultipartFormDataBody(Schema$.MODULE$.apply(evidence$1), value, (Option<String>)None$.MODULE$).map((Function1 & Serializable)formData -> Body$.MODULE$.fromMultipartForm(new Form(formData), boundary));
    }

    private <T> Either<String, Chunk<FormField>> toMultipartFormDataBody(Schema<T> schema, T value, Option<String> fieldName) {
        while (true) {
            Schema schema2 = schema;
            Schema<File> schema3 = File$.MODULE$.schema();
            if (!(schema2 != null ? !schema2.equals(schema3) : schema3 != null)) {
                File file = (File)value;
                return scala.package$.MODULE$.Right().apply((Object)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FormField[]{FormField$.MODULE$.binaryField((String)fieldName.getOrElse((Function0 & Serializable)() -> "unknown"), file.data(), MediaType$.MODULE$.application().octet$minusstream(), (Option)None$.MODULE$, (Option)new Some((Object)file.fileName()))})));
            }
            if (schema instanceof Schema.Enum) {
                return scala.package$.MODULE$.Left().apply((Object)"Cannot encode enum as multipart/form-data");
            }
            if (schema instanceof Schema.Record) {
                Schema.Record record = (Schema.Record)schema;
                if (fieldName.isEmpty()) {
                    return ((Either)package$.MODULE$.ForEachOps((Object)record.fields()).forEach((Function1 & Serializable)field -> MODULE$.toMultipartFormDataBody(field.schema(), field.get().apply(value), (Option<String>)new Some((Object)field.name())), AssociativeBoth$.MODULE$.EitherIdentityBoth(), (Covariant)Invariant$.MODULE$.EitherForEach(), Invariant$.MODULE$.ChunkForEach())).map((Function1 & Serializable)x$2 -> x$2.flatten(Predef$.MODULE$.$conforms()));
                }
                return scala.package$.MODULE$.Left().apply((Object)"Cannot encode nested record as multipart/form-data");
            }
            if (schema instanceof Schema.Sequence) {
                StandardType standardType;
                Schema.Sequence sequence = (Schema.Sequence)schema;
                Schema elemSchema = sequence.elementSchema();
                Function1 toChunk = sequence.toChunk();
                if (elemSchema instanceof Schema.Primitive && StandardType.ByteType$.MODULE$.equals(standardType = ((Schema.Primitive)elemSchema).standardType())) {
                    return scala.package$.MODULE$.Right().apply((Object)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FormField[]{FormField$.MODULE$.binaryField((String)fieldName.getOrElse((Function0 & Serializable)() -> "unknown"), (Chunk)toChunk.apply(value), MediaType$.MODULE$.application().octet$minusstream(), FormField$.MODULE$.binaryField$default$4(), FormField$.MODULE$.binaryField$default$5())})));
                }
                return scala.package$.MODULE$.Left().apply((Object)"Cannot encode collections as multipart/form-data");
            }
            if (schema instanceof Schema.Collection) {
                return scala.package$.MODULE$.Left().apply((Object)"Cannot encode collections as multipart/form-data");
            }
            if (schema instanceof Schema.Transform) {
                Schema.Transform transform = (Schema.Transform)schema;
                Schema schema4 = transform.schema();
                return ((Either)transform.g().apply(value)).flatMap((Function1 & Serializable)inner -> MODULE$.toMultipartFormDataBody(schema4, inner, fieldName));
            }
            if (schema instanceof Schema.Primitive) {
                StandardType standardType = ((Schema.Primitive)schema).standardType();
                if (StandardType.UnitType$.MODULE$.equals(standardType)) {
                    return scala.package$.MODULE$.Right().apply((Object)Chunk$.MODULE$.empty());
                }
                if (StandardType.StringType$.MODULE$.equals(standardType)) {
                    return scala.package$.MODULE$.Right().apply((Object)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FormField[]{FormField$.MODULE$.simpleField((String)fieldName.getOrElse((Function0 & Serializable)() -> "unknown"), (String)value)})));
                }
                if (StandardType.BoolType$.MODULE$.equals(standardType)) {
                    return scala.package$.MODULE$.Right().apply((Object)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FormField[]{BoxesRunTime.unboxToBoolean(value) ? FormField$.MODULE$.simpleField((String)fieldName.getOrElse((Function0 & Serializable)() -> "unknown"), "true") : FormField$.MODULE$.simpleField((String)fieldName.getOrElse((Function0 & Serializable)() -> "unknown"), "true")})));
                }
                if (StandardType.BinaryType$.MODULE$.equals(standardType)) {
                    return scala.package$.MODULE$.Right().apply((Object)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FormField[]{FormField$.MODULE$.binaryField((String)fieldName.getOrElse((Function0 & Serializable)() -> "unknown"), (Chunk)value, MediaType$.MODULE$.application().octet$minusstream(), FormField$.MODULE$.binaryField$default$4(), FormField$.MODULE$.binaryField$default$5())})));
                }
                return scala.package$.MODULE$.Right().apply((Object)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FormField[]{FormField$.MODULE$.simpleField((String)fieldName.getOrElse((Function0 & Serializable)() -> "unknown"), value.toString())})));
            }
            if (schema instanceof Schema.Optional) {
                Schema inner2 = ((Schema.Optional)schema).schema();
                Option option = (Option)value;
                if (option instanceof Some) {
                    Object innerValue;
                    value = innerValue = ((Some)option).value();
                    schema = inner2;
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    return scala.package$.MODULE$.Right().apply((Object)Chunk$.MODULE$.empty());
                }
                throw new MatchError((Object)option);
            }
            if (schema instanceof Schema.Fail) {
                String message = ((Schema.Fail)schema).message();
                return scala.package$.MODULE$.Left().apply((Object)message);
            }
            if (schema instanceof Schema.Tuple2) {
                return scala.package$.MODULE$.Left().apply((Object)"Cannot encode tuple as multipart/form-data");
            }
            if (schema instanceof Schema.Either) {
                return scala.package$.MODULE$.Left().apply((Object)"Cannot encode either as multipart/form-data");
            }
            if (!(schema instanceof Schema.Lazy)) break;
            schema = (Schema)((Schema.Lazy)schema).schema0$access$0().apply();
        }
        if (schema instanceof Schema.Dynamic) {
            return scala.package$.MODULE$.Left().apply((Object)"Cannot encode dynamic as multipart/form-data");
        }
        throw new MatchError(schema);
    }

    private Encoders$() {
    }
}

