/*
 * Decompiled with CFR 0.152.
 */
package zio.openai.internal;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.control.NonFatal$;
import zio.Chunk;
import zio.Chunk$;
import zio.http.Body;
import zio.http.Body$;
import zio.openai.internal.Encoders;
import zio.openai.model.File;
import zio.openai.model.File$;
import zio.schema.Schema;
import zio.schema.Schema$;
import zio.schema.StandardType;

public final class Encoders$ {
    public static final Encoders$ MODULE$ = new Encoders$();

    public <T> BoxedUnit toJsonBody() {
        return BoxedUnit.UNIT;
    }

    public <T> String toURLSegment(T value, Encoders.URLSegmentEncoder<T> encoder) {
        return encoder.encode(value);
    }

    public <T> Either<String, Body> toMultipartFormDataBody(T value, String boundary, Schema<T> evidence$1) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(buffer);
        try {
            this.toMultipartFormDataBody(Schema$.MODULE$.apply(evidence$1), value, boundary, (Chunk<Object>)Chunk$.MODULE$.empty(), output);
            output.flush();
            Chunk bytes = Chunk$.MODULE$.fromArray((Object)buffer.toByteArray());
            return package$.MODULE$.Right().apply((Object)Body$.MODULE$.fromChunk(bytes));
        }
        catch (Throwable throwable) {
            Option option;
            if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                Throwable err = (Throwable)option.get();
                return package$.MODULE$.Left().apply((Object)err.getMessage());
            }
            throw throwable;
        }
    }

    private <T> void toMultipartFormDataBody(Schema<T> schema, T value, String boundary, Chunk<Object> header, DataOutputStream output) {
        while (true) {
            Schema schema2 = schema;
            Schema<File> schema3 = File$.MODULE$.schema();
            if (!(schema2 != null ? !schema2.equals(schema3) : schema3 != null)) {
                output.write((byte[])header.toArray((ClassTag)ClassTag$.MODULE$.Byte()));
                output.write((byte[])((File)value).data().toArray((ClassTag)ClassTag$.MODULE$.Byte()));
                return;
            }
            if (schema instanceof Schema.Enum) {
                throw new IllegalArgumentException("Cannot encode enum as multipart/form-data");
            }
            if (schema instanceof Schema.Record) {
                Schema.Record record = (Schema.Record)schema;
                if (header.isEmpty()) {
                    record.fields().zipWithIndex().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Encoders$.$anonfun$toMultipartFormDataBody$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$2 -> {
                        Encoders$.$anonfun$toMultipartFormDataBody$2(boundary, value, output, record, x$2);
                        return BoxedUnit.UNIT;
                    });
                    Encoders$.writeString$1("--", output, header);
                    Encoders$.writeString$1(boundary, output, header);
                    Encoders$.writeString$1("--", output, header);
                    return;
                }
                throw new IllegalArgumentException("Cannot encode nested record as multipart/form-data");
            }
            if (schema instanceof Schema.Sequence) {
                StandardType standardType;
                Schema.Sequence sequence = (Schema.Sequence)schema;
                Schema elemSchema = sequence.elementSchema();
                Function1 toChunk = sequence.toChunk();
                if (elemSchema instanceof Schema.Primitive && StandardType.ByteType$.MODULE$.equals(standardType = ((Schema.Primitive)elemSchema).standardType())) {
                    Chunk data = (Chunk)toChunk.apply(value);
                    output.write((byte[])header.toArray((ClassTag)ClassTag$.MODULE$.Byte()));
                    output.write((byte[])data.toArray((ClassTag)ClassTag$.MODULE$.Byte()));
                    return;
                }
                throw new IllegalArgumentException("Cannot encode collections as multipart/form-data");
            }
            if (schema instanceof Schema.Collection) {
                throw new IllegalArgumentException("Cannot encode collections as multipart/form-data");
            }
            if (schema instanceof Schema.Transform) {
                Schema.Transform transform = (Schema.Transform)schema;
                Schema schema4 = transform.schema();
                ((Either)transform.g().apply(value)).foreach((Function1 & Serializable)inner -> {
                    Encoders$.MODULE$.toMultipartFormDataBody(schema4, inner, boundary, (Chunk<Object>)header, output);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (schema instanceof Schema.Primitive) {
                StandardType standardType = ((Schema.Primitive)schema).standardType();
                if (StandardType.UnitType$.MODULE$.equals(standardType)) {
                    return;
                }
                if (StandardType.StringType$.MODULE$.equals(standardType)) {
                    Encoders$.writeString$1((String)value, output, header);
                    return;
                }
                if (StandardType.BoolType$.MODULE$.equals(standardType)) {
                    if (BoxesRunTime.unboxToBoolean(value)) {
                        Encoders$.writeString$1("true", output, header);
                        return;
                    }
                    Encoders$.writeString$1("false", output, header);
                    return;
                }
                if (StandardType.BinaryType$.MODULE$.equals(standardType)) {
                    Chunk bytes = (Chunk)value;
                    output.write((byte[])header.toArray((ClassTag)ClassTag$.MODULE$.Byte()));
                    output.write((byte[])bytes.toArray((ClassTag)ClassTag$.MODULE$.Byte()));
                    return;
                }
                Encoders$.writeString$1(value.toString(), output, header);
                return;
            }
            if (schema instanceof Schema.Optional) {
                Schema inner2 = ((Schema.Optional)schema).schema();
                Option option = (Option)value;
                if (option instanceof Some) {
                    Object innerValue = ((Some)option).value();
                    value = innerValue;
                    schema = inner2;
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    return;
                }
                throw new MatchError((Object)option);
            }
            if (schema instanceof Schema.Fail) {
                String message = ((Schema.Fail)schema).message();
                throw new IllegalStateException(message);
            }
            if (schema instanceof Schema.Tuple2) {
                throw new IllegalArgumentException("Cannot encode tuple as multipart/form-data");
            }
            if (schema instanceof Schema.Either) {
                throw new IllegalArgumentException("Cannot encode either as multipart/form-data");
            }
            if (!(schema instanceof Schema.Lazy)) break;
            schema = (Schema)((Schema.Lazy)schema).schema0$access$0().apply();
        }
        if (schema instanceof Schema.Dynamic) {
            throw new IllegalArgumentException("Cannot encode dynamic as multipart/form-data");
        }
        throw new MatchError(schema);
    }

    private static final void writeString$1(String s, DataOutputStream output$1, Chunk header$1) {
        output$1.write((byte[])header$1.toArray((ClassTag)ClassTag$.MODULE$.Byte()));
        output$1.write(s.getBytes(StandardCharsets.UTF_8));
    }

    public static final /* synthetic */ boolean $anonfun$toMultipartFormDataBody$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$toMultipartFormDataBody$2(String boundary$1, Object value$1, DataOutputStream output$1, Schema.Record x3$1, Tuple2 x$2) {
        if (x$2 != null) {
            Schema.Field field = (Schema.Field)x$2._1();
            int idx = x$2._2$mcI$sp();
            StringBuilder headerBuilder = new StringBuilder();
            headerBuilder.append("--");
            headerBuilder.append(boundary$1);
            headerBuilder.append('\n');
            headerBuilder.append("Content-Disposition: form-data; name=\"");
            headerBuilder.append(field.name());
            headerBuilder.append("\"");
            Schema schema = field.schema();
            Schema<File> schema2 = File$.MODULE$.schema();
            if (!(schema != null ? !schema.equals(schema2) : schema2 != null)) {
                headerBuilder.append(new java.lang.StringBuilder(13).append("; filename=\"").append(((File)field.get().apply(value$1)).fileName()).append("\"").toString());
            }
            headerBuilder.append("\n\n");
            Chunk header = Chunk$.MODULE$.fromArray((Object)headerBuilder.toString().getBytes(StandardCharsets.UTF_8));
            MODULE$.toMultipartFormDataBody(field.schema(), field.get().apply(value$1), boundary$1, (Chunk<Object>)header, output$1);
            if (idx < x3$1.fields().length() - 1) {
                output$1.write(10);
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    private Encoders$() {
    }
}

