/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.file;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import zio.Chunk;
import zio.Scope;
import zio.ZIO;
import zio.nio.charset.Charset;
import zio.nio.file.Files$;
import zio.nio.file.Files$Attribute$;
import zio.nio.file.Files$AttributeNames$;
import zio.nio.file.Files$AttributeNames$All$;
import zio.nio.file.Files$AttributeNames$List$;
import zio.nio.file.Files$Attributes$;
import zio.nio.file.Path;
import zio.stream.ZStream;

public final class Files {
    public static ZIO<Object, IOException, BoxedUnit> copy(Path path, Path path2, Seq<CopyOption> seq, Object object) {
        return Files$.MODULE$.copy(path, path2, seq, object);
    }

    public static ZIO<Object, IOException, Object> copy(ZStream<Object, IOException, Object> zStream, Path path, Seq<CopyOption> seq, Object object) {
        return Files$.MODULE$.copy(zStream, path, seq, object);
    }

    public static ZIO<Object, IOException, BoxedUnit> createDirectories(Path path, Seq<FileAttribute<?>> seq, Object object) {
        return Files$.MODULE$.createDirectories(path, seq, object);
    }

    public static ZIO<Object, IOException, BoxedUnit> createDirectory(Path path, Seq<FileAttribute<?>> seq, Object object) {
        return Files$.MODULE$.createDirectory(path, seq, object);
    }

    public static ZIO<Object, IOException, BoxedUnit> createFile(Path path, Seq<FileAttribute<?>> seq, Object object) {
        return Files$.MODULE$.createFile(path, seq, object);
    }

    public static ZIO<Object, IOException, BoxedUnit> createLink(Path path, Path path2, Object object) {
        return Files$.MODULE$.createLink(path, path2, object);
    }

    public static ZIO<Object, IOException, BoxedUnit> createSymbolicLink(Path path, Path path2, Seq<FileAttribute<?>> seq, Object object) {
        return Files$.MODULE$.createSymbolicLink(path, path2, seq, object);
    }

    public static ZIO<Object, IOException, Path> createTempDirectory(Option<String> option, Iterable<FileAttribute<?>> iterable, Object object) {
        return Files$.MODULE$.createTempDirectory(option, iterable, object);
    }

    public static ZIO<Object, IOException, Path> createTempDirectory(Path path, Option<String> option, Iterable<FileAttribute<?>> iterable, Object object) {
        return Files$.MODULE$.createTempDirectory(path, option, iterable, object);
    }

    public static ZIO<Scope, IOException, Path> createTempDirectoryScoped(Option<String> option, Iterable<FileAttribute<?>> iterable, Object object) {
        return Files$.MODULE$.createTempDirectoryScoped(option, iterable, object);
    }

    public static ZIO<Scope, IOException, Path> createTempDirectoryScoped(Path path, Option<String> option, Iterable<FileAttribute<?>> iterable, Object object) {
        return Files$.MODULE$.createTempDirectoryScoped(path, option, iterable, object);
    }

    public static ZIO<Object, IOException, Path> createTempFile(String string, Option<String> option, Iterable<FileAttribute<?>> iterable, Object object) {
        return Files$.MODULE$.createTempFile(string, option, iterable, object);
    }

    public static ZIO<Object, IOException, Path> createTempFileIn(Path path, String string, Option<String> option, Iterable<FileAttribute<?>> iterable, Object object) {
        return Files$.MODULE$.createTempFileIn(path, string, option, iterable, object);
    }

    public static ZIO<Scope, IOException, Path> createTempFileInScoped(Path path, String string, Option<String> option, Iterable<FileAttribute<?>> iterable, Object object) {
        return Files$.MODULE$.createTempFileInScoped(path, string, option, iterable, object);
    }

    public static ZIO<Scope, IOException, Path> createTempFileScoped(String string, Option<String> option, Iterable<FileAttribute<?>> iterable, Object object) {
        return Files$.MODULE$.createTempFileScoped(string, option, iterable, object);
    }

    public static ZIO<Object, IOException, BoxedUnit> delete(Path path, Object object) {
        return Files$.MODULE$.delete(path, object);
    }

    public static ZIO<Object, IOException, Object> deleteIfExists(Path path, Object object) {
        return Files$.MODULE$.deleteIfExists(path, object);
    }

    public static ZIO<Object, IOException, Object> deleteRecursive(Path path, Object object) {
        return Files$.MODULE$.deleteRecursive(path, object);
    }

    public static ZIO<Object, Nothing$, Object> exists(Path path, Seq<LinkOption> seq, Object object) {
        return Files$.MODULE$.exists(path, seq, object);
    }

    public static ZStream<Object, IOException, Path> find(Path path, int n, Set<FileVisitOption> set, Function2<Path, BasicFileAttributes, Object> function2, Object object) {
        return Files$.MODULE$.find(path, n, set, function2, object);
    }

    public static ZIO<Object, IOException, Object> getAttribute(Path path, Attribute attribute, Seq<LinkOption> seq, Object object) {
        return Files$.MODULE$.getAttribute(path, attribute, seq, object);
    }

    public static ZIO<Object, IOException, FileStore> getFileStore(Path path, Object object) {
        return Files$.MODULE$.getFileStore(path, object);
    }

    public static ZIO<Object, IOException, FileTime> getLastModifiedTime(Path path, Seq<LinkOption> seq, Object object) {
        return Files$.MODULE$.getLastModifiedTime(path, seq, object);
    }

    public static ZIO<Object, IOException, UserPrincipal> getOwner(Path path, Seq<LinkOption> seq, Object object) {
        return Files$.MODULE$.getOwner(path, seq, object);
    }

    public static ZIO<Object, IOException, Set<PosixFilePermission>> getPosixFilePermissions(Path path, Seq<LinkOption> seq, Object object) {
        return Files$.MODULE$.getPosixFilePermissions(path, seq, object);
    }

    public static ZIO<Object, Nothing$, Object> isDirectory(Path path, Seq<LinkOption> seq, Object object) {
        return Files$.MODULE$.isDirectory(path, seq, object);
    }

    public static ZIO<Object, Nothing$, Object> isExecutable(Path path, Object object) {
        return Files$.MODULE$.isExecutable(path, object);
    }

    public static ZIO<Object, IOException, Object> isHidden(Path path, Object object) {
        return Files$.MODULE$.isHidden(path, object);
    }

    public static ZIO<Object, Nothing$, Object> isReadable(Path path, Object object) {
        return Files$.MODULE$.isReadable(path, object);
    }

    public static ZIO<Object, Nothing$, Object> isRegularFile(Path path, Seq<LinkOption> seq, Object object) {
        return Files$.MODULE$.isRegularFile(path, seq, object);
    }

    public static ZIO<Object, IOException, Object> isSameFile(Path path, Path path2, Object object) {
        return Files$.MODULE$.isSameFile(path, path2, object);
    }

    public static ZIO<Object, Nothing$, Object> isSymbolicLink(Path path, Object object) {
        return Files$.MODULE$.isSymbolicLink(path, object);
    }

    public static ZIO<Object, Nothing$, Object> isWritable(Path path, Object object) {
        return Files$.MODULE$.isWritable(path, object);
    }

    public static ZStream<Object, IOException, String> lines(Path path, Charset charset, Object object) {
        return Files$.MODULE$.lines(path, charset, object);
    }

    public static ZStream<Object, IOException, Path> list(Path path, Object object) {
        return Files$.MODULE$.list(path, object);
    }

    public static ZIO<Object, IOException, BoxedUnit> move(Path path, Path path2, Seq<CopyOption> seq, Object object) {
        return Files$.MODULE$.move(path, path2, seq, object);
    }

    public static ZStream<Object, IOException, Path> newDirectoryStream(Path path, Function1<Path, Object> function1, Object object) {
        return Files$.MODULE$.newDirectoryStream(path, function1, object);
    }

    public static ZStream<Object, IOException, Path> newDirectoryStream(Path path, String string, Object object) {
        return Files$.MODULE$.newDirectoryStream(path, string, object);
    }

    public static ZIO<Object, Nothing$, Object> notExists(Path path, Seq<LinkOption> seq, Object object) {
        return Files$.MODULE$.notExists(path, seq, object);
    }

    public static ZIO<Object, IOException, String> probeContentType(Path path, Object object) {
        return Files$.MODULE$.probeContentType(path, object);
    }

    public static ZIO<Object, IOException, Chunk<Object>> readAllBytes(Path path, Object object) {
        return Files$.MODULE$.readAllBytes(path, object);
    }

    public static ZIO<Object, IOException, List<String>> readAllLines(Path path, Charset charset, Object object) {
        return Files$.MODULE$.readAllLines(path, charset, object);
    }

    public static ZIO<Object, IOException, Map<String, Object>> readAttributes(Path path, Attributes attributes, Seq<LinkOption> seq, Object object) {
        return Files$.MODULE$.readAttributes(path, attributes, seq, object);
    }

    public static <A extends BasicFileAttributes> ZIO<Object, IOException, A> readAttributes(Path path, Seq<LinkOption> seq, ClassTag<A> classTag, Object object) {
        return Files$.MODULE$.readAttributes(path, seq, classTag, object);
    }

    public static ZIO<Object, IOException, Path> readSymbolicLink(Path path, Object object) {
        return Files$.MODULE$.readSymbolicLink(path, object);
    }

    public static ZIO<Object, Exception, BoxedUnit> setAttribute(Path path, Attribute attribute, Object object, Seq<LinkOption> seq, Object object2) {
        return Files$.MODULE$.setAttribute(path, attribute, object, seq, object2);
    }

    public static ZIO<Object, IOException, BoxedUnit> setLastModifiedTime(Path path, FileTime fileTime, Object object) {
        return Files$.MODULE$.setLastModifiedTime(path, fileTime, object);
    }

    public static ZIO<Object, IOException, BoxedUnit> setOwner(Path path, UserPrincipal userPrincipal, Object object) {
        return Files$.MODULE$.setOwner(path, userPrincipal, object);
    }

    public static ZIO<Object, IOException, BoxedUnit> setPosixFilePermissions(Path path, Set<PosixFilePermission> set, Object object) {
        return Files$.MODULE$.setPosixFilePermissions(path, set, object);
    }

    public static ZIO<Object, IOException, Object> size(Path path, Object object) {
        return Files$.MODULE$.size(path, object);
    }

    public static <A extends FileAttributeView, B, E> ZIO<Object, E, B> useFileAttributeView(Path path, Seq<LinkOption> seq, Function1<A, ZIO<Object, E, B>> function1, ClassTag<A> classTag, Object object) {
        return Files$.MODULE$.useFileAttributeView(path, seq, function1, classTag, object);
    }

    public static ZStream<Object, IOException, Path> walk(Path path, int n, Set<FileVisitOption> set, Object object) {
        return Files$.MODULE$.walk(path, n, set, object);
    }

    public static ZIO<Object, IOException, BoxedUnit> writeBytes(Path path, Chunk<Object> chunk, Seq<OpenOption> seq, Object object) {
        return Files$.MODULE$.writeBytes(path, chunk, seq, object);
    }

    public static ZIO<Object, IOException, BoxedUnit> writeLines(Path path, Iterable<CharSequence> iterable, Charset charset, Set<OpenOption> set, Object object) {
        return Files$.MODULE$.writeLines(path, iterable, charset, set, object);
    }

    public static String createTempFile$default$1() {
        return Files$.MODULE$.createTempFile$default$1();
    }

    public static String createTempFileScoped$default$1() {
        return Files$.MODULE$.createTempFileScoped$default$1();
    }

    public static String createTempFileIn$default$2() {
        return Files$.MODULE$.createTempFileIn$default$2();
    }

    public static String createTempFileInScoped$default$2() {
        return Files$.MODULE$.createTempFileInScoped$default$2();
    }

    public static Option<String> createTempFileScoped$default$2() {
        return Files$.MODULE$.createTempFileScoped$default$2();
    }

    public static int find$default$2() {
        return Files$.MODULE$.find$default$2();
    }

    public static Charset lines$default$2() {
        return Files$.MODULE$.lines$default$2();
    }

    public static String newDirectoryStream$default$2() {
        return Files$.MODULE$.newDirectoryStream$default$2();
    }

    public static Charset readAllLines$default$2() {
        return Files$.MODULE$.readAllLines$default$2();
    }

    public static int walk$default$2() {
        return Files$.MODULE$.walk$default$2();
    }

    public static Option<String> createTempFileInScoped$default$3() {
        return Files$.MODULE$.createTempFileInScoped$default$3();
    }

    public static Iterable<FileAttribute<?>> createTempFileScoped$default$3() {
        return Files$.MODULE$.createTempFileScoped$default$3();
    }

    public static Set<FileVisitOption> find$default$3() {
        return Files$.MODULE$.find$default$3();
    }

    public static Set<FileVisitOption> walk$default$3() {
        return Files$.MODULE$.walk$default$3();
    }

    public static Charset writeLines$default$3() {
        return Files$.MODULE$.writeLines$default$3();
    }

    public static Iterable<FileAttribute<?>> createTempFileInScoped$default$4() {
        return Files$.MODULE$.createTempFileInScoped$default$4();
    }

    public static Set<OpenOption> writeLines$default$4() {
        return Files$.MODULE$.writeLines$default$4();
    }

    public static final class Attribute
    implements Product,
    Serializable {
        private final String attributeName;
        private final String viewName;

        public static Attribute apply(String string, String string2) {
            return Files$Attribute$.MODULE$.apply(string, string2);
        }

        public static Option<Attribute> fromJava(String string) {
            return Files$Attribute$.MODULE$.fromJava(string);
        }

        public static Attribute fromProduct(Product product) {
            return Files$Attribute$.MODULE$.fromProduct(product);
        }

        public static Attribute unapply(Attribute attribute) {
            return Files$Attribute$.MODULE$.unapply(attribute);
        }

        public static String $lessinit$greater$default$2() {
            return Files$Attribute$.MODULE$.$lessinit$greater$default$2();
        }

        public Attribute(String attributeName, String viewName) {
            this.attributeName = attributeName;
            this.viewName = viewName;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Attribute)) return false;
            Attribute attribute = (Attribute)object;
            String string = this.attributeName();
            String string2 = attribute.attributeName();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.viewName();
            String string4 = attribute.viewName();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Attribute;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Attribute";
        }

        public Object productElement(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = this._1();
            } else if (1 == n2) {
                string = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "attributeName";
            } else if (1 == n2) {
                string = "viewName";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public String attributeName() {
            return this.attributeName;
        }

        public String viewName() {
            return this.viewName;
        }

        public String toJava() {
            return new StringBuilder(1).append(this.viewName()).append(":").append(this.attributeName()).toString();
        }

        public Attribute copy(String attributeName, String viewName) {
            return new Attribute(attributeName, viewName);
        }

        public String copy$default$1() {
            return this.attributeName();
        }

        public String copy$default$2() {
            return this.viewName();
        }

        public String _1() {
            return this.attributeName();
        }

        public String _2() {
            return this.viewName();
        }
    }

    public static interface AttributeNames {
        public static AttributeNames fromJava(String string) {
            return Files$AttributeNames$.MODULE$.fromJava(string);
        }

        public static int ordinal(AttributeNames attributeNames) {
            return Files$AttributeNames$.MODULE$.ordinal(attributeNames);
        }

        public static String toJava$(AttributeNames $this) {
            return $this.toJava();
        }

        default public String toJava() {
            String string;
            AttributeNames attributeNames = this;
            if (Files$AttributeNames$All$.MODULE$.equals(attributeNames)) {
                string = "*";
            } else if (attributeNames instanceof List) {
                scala.collection.immutable.List<String> list;
                List list2 = Files$AttributeNames$List$.MODULE$.unapply((List)attributeNames);
                scala.collection.immutable.List<String> names = list = list2._1();
                string = names.mkString(",");
            } else {
                throw new MatchError((Object)attributeNames);
            }
            return string;
        }

        public static final class List
        implements AttributeNames,
        Product,
        Serializable {
            private final scala.collection.immutable.List names;

            public static List apply(scala.collection.immutable.List<String> list) {
                return Files$AttributeNames$List$.MODULE$.apply(list);
            }

            public static List fromProduct(Product product) {
                return Files$AttributeNames$List$.MODULE$.fromProduct(product);
            }

            public static List unapply(List list) {
                return Files$AttributeNames$List$.MODULE$.unapply(list);
            }

            public List(scala.collection.immutable.List<String> names) {
                this.names = names;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof List)) return false;
                List list = (List)object;
                scala.collection.immutable.List<String> list2 = this.names();
                scala.collection.immutable.List<String> list3 = list.names();
                if (list2 != null) {
                    if (!list2.equals(list3)) return false;
                    return true;
                }
                if (list3 == null) return true;
                return false;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof List;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "List";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 != n2) {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return this._1();
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 != n2) {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return "names";
            }

            public scala.collection.immutable.List<String> names() {
                return this.names;
            }

            public List copy(scala.collection.immutable.List<String> names) {
                return new List(names);
            }

            public scala.collection.immutable.List<String> copy$default$1() {
                return this.names();
            }

            public scala.collection.immutable.List<String> _1() {
                return this.names();
            }
        }
    }

    public static final class Attributes
    implements Product,
    Serializable {
        private final AttributeNames attributeNames;
        private final String viewName;

        public static Attributes apply(AttributeNames attributeNames, String string) {
            return Files$Attributes$.MODULE$.apply(attributeNames, string);
        }

        public static Option<Attributes> fromJava(String string) {
            return Files$Attributes$.MODULE$.fromJava(string);
        }

        public static Attributes fromProduct(Product product) {
            return Files$Attributes$.MODULE$.fromProduct(product);
        }

        public static Attributes unapply(Attributes attributes) {
            return Files$Attributes$.MODULE$.unapply(attributes);
        }

        public static String $lessinit$greater$default$2() {
            return Files$Attributes$.MODULE$.$lessinit$greater$default$2();
        }

        public Attributes(AttributeNames attributeNames, String viewName) {
            this.attributeNames = attributeNames;
            this.viewName = viewName;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Attributes)) return false;
            Attributes attributes = (Attributes)object;
            AttributeNames attributeNames = this.attributeNames();
            AttributeNames attributeNames2 = attributes.attributeNames();
            if (attributeNames == null) {
                if (attributeNames2 != null) {
                    return false;
                }
            } else if (!attributeNames.equals(attributeNames2)) return false;
            String string = this.viewName();
            String string2 = attributes.viewName();
            if (string == null) {
                if (string2 == null) return true;
                return false;
            } else {
                if (!string.equals(string2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Attributes;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Attributes";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "attributeNames";
            } else if (1 == n2) {
                string = "viewName";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public AttributeNames attributeNames() {
            return this.attributeNames;
        }

        public String viewName() {
            return this.viewName;
        }

        public String toJava() {
            return new StringBuilder(1).append(this.viewName()).append(":").append(this.attributeNames().toJava()).toString();
        }

        public Attributes copy(AttributeNames attributeNames, String viewName) {
            return new Attributes(attributeNames, viewName);
        }

        public AttributeNames copy$default$1() {
            return this.attributeNames();
        }

        public String copy$default$2() {
            return this.viewName();
        }

        public AttributeNames _1() {
            return this.attributeNames();
        }

        public String _2() {
            return this.viewName();
        }
    }
}

