/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.channels;

import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramSocket;
import java.net.ProtocolFamily;
import java.net.SocketOption;
import java.nio.channels.GatheringByteChannel;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.IO$;
import zio.UIO$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZManaged;
import zio.nio.ByteBuffer;
import zio.nio.SocketAddress;
import zio.nio.SocketAddress$;
import zio.nio.channels.BlockingChannel;
import zio.nio.channels.Channel;
import zio.nio.channels.DatagramChannel$;
import zio.nio.channels.GatheringByteOps;
import zio.nio.channels.ScatteringByteOps;
import zio.nio.channels.SelectableChannel;

public final class DatagramChannel
implements Channel,
BlockingChannel,
SelectableChannel {
    private final java.nio.channels.DatagramChannel channel;

    public static DatagramChannel fromJava(java.nio.channels.DatagramChannel datagramChannel) {
        return DatagramChannel$.MODULE$.fromJava(datagramChannel);
    }

    public static ZManaged<Object, IOException, DatagramChannel> open(Object object) {
        return DatagramChannel$.MODULE$.open(object);
    }

    public static ZManaged<Object, IOException, DatagramChannel> open(ProtocolFamily protocolFamily, Object object) {
        return DatagramChannel$.MODULE$.open(protocolFamily, object);
    }

    public DatagramChannel(java.nio.channels.DatagramChannel channel) {
        this.channel = channel;
    }

    @Override
    public java.nio.channels.DatagramChannel channel() {
        return this.channel;
    }

    @Override
    public BlockingDatagramOps makeBlockingOps() {
        return new BlockingDatagramOps(this);
    }

    @Override
    public NonBlockingDatagramOps makeNonBlockingOps() {
        return new NonBlockingDatagramOps(this);
    }

    public ZIO<Object, IOException, BoxedUnit> bindTo(SocketAddress local, Object trace) {
        return this.bind((Option<SocketAddress>)Some$.MODULE$.apply((Object)local), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> bindAuto(Object trace) {
        return this.bind((Option<SocketAddress>)None$.MODULE$, trace);
    }

    public ZIO<Object, IOException, BoxedUnit> bind(Option<SocketAddress> local, Object trace) {
        java.net.SocketAddress addr = (java.net.SocketAddress)local.map((Function1 & Serializable)_$1 -> _$1.jSocketAddress()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.attempt(() -> this.bind$$anonfun$1(addr), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace).unit(trace);
    }

    public ZIO<Object, IOException, BoxedUnit> disconnect(Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.attempt(this::disconnect$$anonfun$1, trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, Nothing$, Object> isConnected(Object trace) {
        return UIO$.MODULE$.succeed(this::isConnected$$anonfun$1, trace);
    }

    public ZIO<Object, IOException, Option<SocketAddress>> localAddress(Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.attempt(this::localAddress$$anonfun$1, trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Option<SocketAddress>> remoteAddress(Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.attempt(this::remoteAddress$$anonfun$1, trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public <T> ZIO<Object, IOException, BoxedUnit> setOption(SocketOption<T> name, T value, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.attempt(() -> this.setOption$$anonfun$1(name, value), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace).unit(trace);
    }

    public ZIO<Object, Nothing$, DatagramSocket> socket(Object trace) {
        return IO$.MODULE$.succeed(this::socket$$anonfun$1, trace);
    }

    public static final /* synthetic */ SocketAddress zio$nio$channels$DatagramChannel$NonBlockingDatagramOps$$_$receive$$anonfun$2$$anonfun$1(java.net.SocketAddress jSocketAddress) {
        return SocketAddress$.MODULE$.fromJava(jSocketAddress);
    }

    private final java.nio.channels.DatagramChannel bind$$anonfun$1(java.net.SocketAddress addr$1) {
        return this.channel().bind(addr$1);
    }

    private final DatagramChannel disconnect$$anonfun$1() {
        return new DatagramChannel(this.channel().disconnect());
    }

    private final boolean isConnected$$anonfun$1() {
        return this.channel().isConnected();
    }

    private final Option localAddress$$anonfun$1() {
        return Option$.MODULE$.apply((Object)this.channel().getLocalAddress()).map((Function1 & Serializable)jSocketAddress -> SocketAddress$.MODULE$.fromJava((java.net.SocketAddress)jSocketAddress));
    }

    private final Option remoteAddress$$anonfun$1() {
        return Option$.MODULE$.apply((Object)this.channel().getRemoteAddress()).map((Function1 & Serializable)jSocketAddress -> SocketAddress$.MODULE$.fromJava((java.net.SocketAddress)jSocketAddress));
    }

    private final java.nio.channels.DatagramChannel setOption$$anonfun$1(SocketOption name$1, Object value$1) {
        return this.channel().setOption(name$1, value$1);
    }

    private final DatagramSocket socket$$anonfun$1() {
        return this.channel().socket();
    }

    public final class BlockingDatagramOps
    extends DatagramOps {
        private final DatagramChannel $outer;

        public BlockingDatagramOps(DatagramChannel $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer);
        }

        public ZIO<Object, IOException, SocketAddress> receive(ByteBuffer dst, Object trace) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.attempt(() -> this.receive$$anonfun$1(dst), trace));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
        }

        public final DatagramChannel zio$nio$channels$DatagramChannel$BlockingDatagramOps$$$outer() {
            return this.$outer;
        }

        private final SocketAddress receive$$anonfun$1(ByteBuffer dst$1) {
            return SocketAddress$.MODULE$.fromJava(this.$outer.channel().receive(dst$1.buffer()));
        }
    }

    public abstract class DatagramOps
    implements GatheringByteOps,
    ScatteringByteOps {
        private final DatagramChannel $outer;

        public DatagramOps(DatagramChannel $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public GatheringByteChannel channel() {
            return this.$outer.channel();
        }

        public ZIO<Object, IOException, BoxedUnit> connect(SocketAddress remote, Object trace) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.attempt(() -> this.connect$$anonfun$1(remote), trace).unit(trace));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
        }

        public ZIO<Object, IOException, Object> send(ByteBuffer src, SocketAddress target, Object trace) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.attempt(() -> this.send$$anonfun$1(src, target), trace));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
        }

        public final DatagramChannel zio$nio$channels$DatagramChannel$DatagramOps$$$outer() {
            return this.$outer;
        }

        private final DatagramChannel connect$$anonfun$1(SocketAddress remote$1) {
            return new DatagramChannel(this.$outer.channel().connect(remote$1.jSocketAddress()));
        }

        private final int send$$anonfun$1(ByteBuffer src$1, SocketAddress target$1) {
            return this.$outer.channel().send(src$1.buffer(), target$1.jSocketAddress());
        }
    }

    public final class NonBlockingDatagramOps
    extends DatagramOps {
        private final DatagramChannel $outer;

        public NonBlockingDatagramOps(DatagramChannel $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer);
        }

        public ZIO<Object, IOException, Option<SocketAddress>> receive(ByteBuffer dst, Object trace) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.attempt(() -> this.receive$$anonfun$2(dst), trace));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
        }

        public final DatagramChannel zio$nio$channels$DatagramChannel$NonBlockingDatagramOps$$$outer() {
            return this.$outer;
        }

        private final Option receive$$anonfun$2(ByteBuffer dst$2) {
            return Option$.MODULE$.apply((Object)this.$outer.channel().receive(dst$2.buffer())).map(DatagramChannel::zio$nio$channels$DatagramChannel$NonBlockingDatagramOps$$_$receive$$anonfun$2$$anonfun$1);
        }
    }
}

