/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.IsSubtypeOfError$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZManaged;
import zio.ZManaged$;
import zio.nio.charset.Charset;
import zio.nio.charset.Charset$Standard$;
import zio.nio.file.Files;
import zio.nio.file.Files$Attribute$;
import zio.nio.file.Files$AttributeNames$;
import zio.nio.file.Files$Attributes$;
import zio.nio.file.Path;
import zio.nio.file.Path$;
import zio.stream.ZChannel;
import zio.stream.ZSink;
import zio.stream.ZSink$;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class Files$
implements Serializable {
    public static final Files$Attribute$ Attribute;
    public static final Files$AttributeNames$ AttributeNames;
    public static final Files$Attributes$ Attributes;
    public static final Files$ MODULE$;

    private Files$() {
    }

    static {
        MODULE$ = new Files$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Files$.class);
    }

    public ZStream<Object, IOException, Path> newDirectoryStream(Path dir, String glob, Object trace) {
        ZManaged managed = ZManaged$.MODULE$.fromAutoCloseable(() -> this.$anonfun$1(dir, glob, trace), trace).map((Function1 & Serializable)_$1 -> _$1.iterator(), trace);
        ZStream zStream = ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaIteratorManaged(() -> this.newDirectoryStream$$anonfun$1(managed), trace).map((Function1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath), trace));
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(zStream, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public String newDirectoryStream$default$2() {
        return "*";
    }

    public ZStream<Object, IOException, Path> newDirectoryStream(Path dir, Function1<Path, Object> filter, Object trace) {
        DirectoryStream.Filter<java.nio.file.Path> javaFilter = javaPath -> BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)Path$.MODULE$.fromJava((java.nio.file.Path)javaPath)));
        ZManaged managed = ZManaged$.MODULE$.fromAutoCloseable(() -> this.$anonfun$4(dir, trace, javaFilter), trace).map((Function1 & Serializable)_$2 -> _$2.iterator(), trace);
        ZStream zStream = ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaIteratorManaged(() -> this.newDirectoryStream$$anonfun$3(managed), trace).map((Function1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath), trace));
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(zStream, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> createFile(Path path, Seq<FileAttribute<?>> attrs, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.createFile$$anonfun$1(path, attrs), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> createDirectory(Path path, Seq<FileAttribute<?>> attrs, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.createDirectory$$anonfun$1(path, attrs), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> createDirectories(Path path, Seq<FileAttribute<?>> attrs, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.createDirectories$$anonfun$1(path, attrs), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Path> createTempFileIn(Path dir, String suffix, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.createTempFileIn$$anonfun$1(dir, suffix, prefix, fileAttributes), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public String createTempFileIn$default$2() {
        return ".tmp";
    }

    public ZManaged<Object, IOException, Path> createTempFileInManaged(Path dir, String suffix, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        return ZManaged$.MODULE$.acquireReleaseWith(() -> this.createTempFileInManaged$$anonfun$1(dir, suffix, prefix, fileAttributes, trace), (Function1 & Serializable)_$3 -> this.deleteIfExists((Path)_$3, trace).ignore(trace), trace);
    }

    public String createTempFileInManaged$default$2() {
        return ".tmp";
    }

    public Option<String> createTempFileInManaged$default$3() {
        return None$.MODULE$;
    }

    public Iterable<FileAttribute<?>> createTempFileInManaged$default$4() {
        return package$.MODULE$.Nil();
    }

    public ZIO<Object, IOException, Path> createTempFile(String suffix, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.createTempFile$$anonfun$1(suffix, prefix, fileAttributes), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public String createTempFile$default$1() {
        return ".tmp";
    }

    public ZManaged<Object, IOException, Path> createTempFileManaged(String suffix, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        return ZManaged$.MODULE$.acquireReleaseWith(() -> this.createTempFileManaged$$anonfun$1(suffix, prefix, fileAttributes, trace), (Function1 & Serializable)_$4 -> this.deleteIfExists((Path)_$4, trace).ignore(trace), trace);
    }

    public String createTempFileManaged$default$1() {
        return ".tmp";
    }

    public Option<String> createTempFileManaged$default$2() {
        return None$.MODULE$;
    }

    public Iterable<FileAttribute<?>> createTempFileManaged$default$3() {
        return package$.MODULE$.Nil();
    }

    public ZIO<Object, IOException, Path> createTempDirectory(Path dir, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.createTempDirectory$$anonfun$1(dir, prefix, fileAttributes), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZManaged<Object, IOException, Path> createTempDirectoryManaged(Path dir, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        return ZManaged$.MODULE$.acquireReleaseWith(() -> this.createTempDirectoryManaged$$anonfun$1(dir, prefix, fileAttributes, trace), (Function1 & Serializable)_$5 -> this.deleteRecursive((Path)_$5, trace).ignore(trace), trace);
    }

    public ZIO<Object, IOException, Path> createTempDirectory(Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.createTempDirectory$$anonfun$2(prefix, fileAttributes), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZManaged<Object, IOException, Path> createTempDirectoryManaged(Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        return ZManaged$.MODULE$.acquireReleaseWith(() -> this.createTempDirectoryManaged$$anonfun$3(prefix, fileAttributes, trace), (Function1 & Serializable)_$6 -> this.deleteRecursive((Path)_$6, trace).ignore(trace), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> createSymbolicLink(Path link, Path target, Seq<FileAttribute<?>> fileAttributes, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.createSymbolicLink$$anonfun$1(link, target, fileAttributes), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> createLink(Path link, Path existing, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.createLink$$anonfun$1(link, existing), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> delete(Path path, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0)((JFunction0.mcV.sp & Serializable)() -> this.delete$$anonfun$1(path)), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Object> deleteIfExists(Path path, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.deleteIfExists$$anonfun$1(path), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Object> deleteRecursive(Path path2, Object trace) {
        return this.newDirectoryStream(path2, this.newDirectoryStream$default$2(), trace).mapZIO((Function1 & Serializable)path -> this.delete((Path)path, trace), trace).run((Function0 & Serializable)() -> new ZSink(this.deleteRecursive$$anonfun$3(trace)), trace).$less$times(() -> this.deleteRecursive$$anonfun$2(path2, trace), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> copy(Path source, Path target, Seq<CopyOption> copyOptions, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.copy$$anonfun$1(source, target, copyOptions), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> move(Path source, Path target, Seq<CopyOption> copyOptions, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.move$$anonfun$1(source, target, copyOptions), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Path> readSymbolicLink(Path link, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.readSymbolicLink$$anonfun$1(link), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, FileStore> getFileStore(Path path, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.getFileStore$$anonfun$1(path), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Object> isSameFile(Path path, Path path2, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.isSameFile$$anonfun$1(path, path2), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Object> isHidden(Path path, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.isHidden$$anonfun$1(path), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, String> probeContentType(Path path, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.probeContentType$$anonfun$1(path), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public <A extends FileAttributeView, B, E> ZIO<Object, E, B> useFileAttributeView(Path path, Seq<LinkOption> linkOptions, Function1<A, ZIO<Object, E, B>> f, ClassTag<A> evidence$1, Object trace) {
        Class viewClass = scala.reflect.package$.MODULE$.classTag(evidence$1).runtimeClass();
        return ZIO$.MODULE$.attemptBlocking(() -> this.useFileAttributeView$$anonfun$1(path, linkOptions, viewClass), trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace).flatMap(f, trace);
    }

    public <A extends BasicFileAttributes> ZIO<Object, IOException, A> readAttributes(Path path, Seq<LinkOption> linkOptions, ClassTag<A> evidence$2, Object trace) {
        Class attributeClass = scala.reflect.package$.MODULE$.classTag(evidence$2).runtimeClass();
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.readAttributes$$anonfun$1(path, linkOptions, attributeClass), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, Exception, BoxedUnit> setAttribute(Path path, Files.Attribute attribute, Object value, Seq<LinkOption> linkOptions, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.setAttribute$$anonfun$1(path, attribute, value, linkOptions), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(Exception.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Object> getAttribute(Path path, Files.Attribute attribute, Seq<LinkOption> linkOptions, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.getAttribute$$anonfun$1(path, attribute, linkOptions), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, scala.collection.immutable.Map<String, Object>> readAttributes(Path path, Files.Attributes attributes, Seq<LinkOption> linkOptions, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.readAttributes$$anonfun$2(path, attributes, linkOptions), trace).map((Function1 & Serializable)_$7 -> CollectionConverters$.MODULE$.MapHasAsScala(_$7).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, scala.collection.immutable.Set<PosixFilePermission>> getPosixFilePermissions(Path path, Seq<LinkOption> linkOptions, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.getPosixFilePermissions$$anonfun$1(path, linkOptions), trace).map((Function1 & Serializable)_$8 -> CollectionConverters$.MODULE$.SetHasAsScala(_$8).asScala().toSet(), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> setPosixFilePermissions(Path path, scala.collection.immutable.Set<PosixFilePermission> permissions, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.setPosixFilePermissions$$anonfun$1(path, permissions), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, UserPrincipal> getOwner(Path path, Seq<LinkOption> linkOptions, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.getOwner$$anonfun$1(path, linkOptions), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> setOwner(Path path, UserPrincipal owner, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.setOwner$$anonfun$1(path, owner), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, Nothing$, Object> isSymbolicLink(Path path, Object trace) {
        return ZIO$.MODULE$.attemptBlocking(() -> this.isSymbolicLink$$anonfun$1(path), trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, Nothing$, Object> isDirectory(Path path, Seq<LinkOption> linkOptions, Object trace) {
        return ZIO$.MODULE$.attemptBlocking(() -> this.isDirectory$$anonfun$1(path, linkOptions), trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, Nothing$, Object> isRegularFile(Path path, Seq<LinkOption> linkOptions, Object trace) {
        return ZIO$.MODULE$.attemptBlocking(() -> this.isRegularFile$$anonfun$1(path, linkOptions), trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, FileTime> getLastModifiedTime(Path path, Seq<LinkOption> linkOptions, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.getLastModifiedTime$$anonfun$1(path, linkOptions), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> setLastModifiedTime(Path path, FileTime time, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.setLastModifiedTime$$anonfun$1(path, time), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Object> size(Path path, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.size$$anonfun$1(path), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, Nothing$, Object> exists(Path path, Seq<LinkOption> linkOptions, Object trace) {
        return ZIO$.MODULE$.attemptBlocking(() -> this.exists$$anonfun$1(path, linkOptions), trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, Nothing$, Object> notExists(Path path, Seq<LinkOption> linkOptions, Object trace) {
        return ZIO$.MODULE$.attemptBlocking(() -> this.notExists$$anonfun$1(path, linkOptions), trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, Nothing$, Object> isReadable(Path path, Object trace) {
        return ZIO$.MODULE$.attemptBlocking(() -> this.isReadable$$anonfun$1(path), trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, Nothing$, Object> isWritable(Path path, Object trace) {
        return ZIO$.MODULE$.attemptBlocking(() -> this.isWritable$$anonfun$1(path), trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, Nothing$, Object> isExecutable(Path path, Object trace) {
        return ZIO$.MODULE$.attemptBlocking(() -> this.isExecutable$$anonfun$1(path), trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, Chunk<Object>> readAllBytes(Path path, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.readAllBytes$$anonfun$1(path), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, List<String>> readAllLines(Path path, Charset charset, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.readAllLines$$anonfun$1(path, charset), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public Charset readAllLines$default$2() {
        return Charset$Standard$.MODULE$.utf8();
    }

    public ZIO<Object, IOException, BoxedUnit> writeBytes(Path path, Chunk<Object> bytes, Seq<OpenOption> openOptions, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.writeBytes$$anonfun$1(path, bytes, openOptions), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> writeLines(Path path, Iterable<CharSequence> lines, Charset charset, scala.collection.immutable.Set<OpenOption> openOptions, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking(() -> this.writeLines$$anonfun$1(path, lines, charset, openOptions), trace).unit(trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public Charset writeLines$default$3() {
        return Charset$Standard$.MODULE$.utf8();
    }

    public scala.collection.immutable.Set<OpenOption> writeLines$default$4() {
        return Predef$.MODULE$.Set().empty();
    }

    public ZStream<Object, IOException, String> lines(Path path, Charset charset, Object trace) {
        ZStream zStream = ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaStreamManaged(() -> this.lines$$anonfun$1(path, charset, trace), trace));
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(zStream, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public Charset lines$default$2() {
        return Charset$Standard$.MODULE$.utf8();
    }

    public ZStream<Object, IOException, Path> list(Path path, Object trace) {
        ZStream zStream = ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaStreamManaged(() -> this.list$$anonfun$1(path, trace), trace).map((Function1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath), trace));
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(zStream, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZStream<Object, IOException, Path> walk(Path path, int maxDepth, scala.collection.immutable.Set<FileVisitOption> visitOptions, Object trace) {
        ZStream zStream = ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaStreamManaged(() -> this.walk$$anonfun$1(path, maxDepth, visitOptions, trace), trace).map((Function1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath), trace));
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(zStream, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public int walk$default$2() {
        return Integer.MAX_VALUE;
    }

    public scala.collection.immutable.Set<FileVisitOption> walk$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    public ZStream<Object, IOException, Path> find(Path path2, int maxDepth, scala.collection.immutable.Set<FileVisitOption> visitOptions, Function2<Path, BasicFileAttributes, Object> test, Object trace) {
        BiPredicate<java.nio.file.Path, BasicFileAttributes> matcher = (path, attr) -> BoxesRunTime.unboxToBoolean((Object)test.apply((Object)Path$.MODULE$.fromJava((java.nio.file.Path)path), attr));
        ZStream zStream = ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaStreamManaged(() -> this.find$$anonfun$1(path2, maxDepth, visitOptions, trace, matcher), trace).map((Function1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath), trace));
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(zStream, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public int find$default$2() {
        return Integer.MAX_VALUE;
    }

    public scala.collection.immutable.Set<FileVisitOption> find$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    public ZIO<Object, IOException, Object> copy(ZStream<Object, IOException, Object> in, Path target, Seq<CopyOption> options, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(in.toInputStream((.less.colon.less)$less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl(), trace).use((Function1 & Serializable)inputStream -> ZIO$.MODULE$.attemptBlocking(() -> this.copy$$anonfun$3$$anonfun$1(target, options, inputStream), trace), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    private final DirectoryStream $anonfun$7$$anonfun$1(Path dir$2, String glob$2) {
        return Files.newDirectoryStream(dir$2.javaPath(), glob$2);
    }

    private final ZIO $anonfun$1(Path dir$1, String glob$1, Object trace$1) {
        return ZIO$.MODULE$.attemptBlocking(() -> this.$anonfun$7$$anonfun$1(dir$1, glob$1), trace$1);
    }

    private final ZManaged newDirectoryStream$$anonfun$1(ZManaged managed$1) {
        return managed$1;
    }

    private final DirectoryStream $anonfun$8$$anonfun$1(Path dir$4, DirectoryStream.Filter javaFilter$2) {
        return Files.newDirectoryStream(dir$4.javaPath(), javaFilter$2);
    }

    private final ZIO $anonfun$4(Path dir$3, Object trace$2, DirectoryStream.Filter javaFilter$1) {
        return ZIO$.MODULE$.attemptBlocking(() -> this.$anonfun$8$$anonfun$1(dir$3, javaFilter$1), trace$2);
    }

    private final ZManaged newDirectoryStream$$anonfun$3(ZManaged managed$2) {
        return managed$2;
    }

    private final java.nio.file.Path createFile$$anonfun$1(Path path$1, Seq attrs$1) {
        return Files.createFile(path$1.javaPath(), (FileAttribute[])Arrays$.MODULE$.seqToArray(attrs$1, FileAttribute.class));
    }

    private final java.nio.file.Path createDirectory$$anonfun$1(Path path$2, Seq attrs$2) {
        return Files.createDirectory(path$2.javaPath(), (FileAttribute[])Arrays$.MODULE$.seqToArray(attrs$2, FileAttribute.class));
    }

    private final java.nio.file.Path createDirectories$$anonfun$1(Path path$3, Seq attrs$3) {
        return Files.createDirectories(path$3.javaPath(), (FileAttribute[])Arrays$.MODULE$.seqToArray(attrs$3, FileAttribute.class));
    }

    private final Path createTempFileIn$$anonfun$1(Path dir$5, String suffix$1, Option prefix$1, Iterable fileAttributes$1) {
        return Path$.MODULE$.fromJava(Files.createTempFile(dir$5.javaPath(), (String)prefix$1.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), suffix$1, (FileAttribute[])Arrays$.MODULE$.seqToArray(fileAttributes$1.toSeq(), FileAttribute.class)));
    }

    private final ZIO createTempFileInManaged$$anonfun$1(Path dir$6, String suffix$2, Option prefix$2, Iterable fileAttributes$2, Object trace$3) {
        return this.createTempFileIn(dir$6, suffix$2, (Option<String>)prefix$2, fileAttributes$2, trace$3);
    }

    private final Path createTempFile$$anonfun$1(String suffix$3, Option prefix$3, Iterable fileAttributes$3) {
        return Path$.MODULE$.fromJava(Files.createTempFile((String)prefix$3.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), suffix$3, (FileAttribute[])Arrays$.MODULE$.seqToArray(fileAttributes$3.toSeq(), FileAttribute.class)));
    }

    private final ZIO createTempFileManaged$$anonfun$1(String suffix$4, Option prefix$4, Iterable fileAttributes$4, Object trace$5) {
        return this.createTempFile(suffix$4, (Option<String>)prefix$4, fileAttributes$4, trace$5);
    }

    private final Path createTempDirectory$$anonfun$1(Path dir$7, Option prefix$5, Iterable fileAttributes$5) {
        return Path$.MODULE$.fromJava(Files.createTempDirectory(dir$7.javaPath(), (String)prefix$5.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (FileAttribute[])Arrays$.MODULE$.seqToArray(fileAttributes$5.toSeq(), FileAttribute.class)));
    }

    private final ZIO createTempDirectoryManaged$$anonfun$1(Path dir$8, Option prefix$6, Iterable fileAttributes$6, Object trace$7) {
        return this.createTempDirectory(dir$8, (Option<String>)prefix$6, fileAttributes$6, trace$7);
    }

    private final Path createTempDirectory$$anonfun$2(Option prefix$7, Iterable fileAttributes$7) {
        return Path$.MODULE$.fromJava(Files.createTempDirectory((String)prefix$7.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (FileAttribute[])Arrays$.MODULE$.seqToArray(fileAttributes$7.toSeq(), FileAttribute.class)));
    }

    private final ZIO createTempDirectoryManaged$$anonfun$3(Option prefix$8, Iterable fileAttributes$8, Object trace$9) {
        return this.createTempDirectory((Option<String>)prefix$8, fileAttributes$8, trace$9);
    }

    private final java.nio.file.Path createSymbolicLink$$anonfun$1(Path link$1, Path target$1, Seq fileAttributes$9) {
        return Files.createSymbolicLink(link$1.javaPath(), target$1.javaPath(), (FileAttribute[])Arrays$.MODULE$.seqToArray(fileAttributes$9, FileAttribute.class));
    }

    private final java.nio.file.Path createLink$$anonfun$1(Path link$2, Path existing$1) {
        return Files.createLink(link$2.javaPath(), existing$1.javaPath());
    }

    private final void delete$$anonfun$1(Path path$4) {
        Files.delete(path$4.javaPath());
    }

    private final boolean deleteIfExists$$anonfun$1(Path path$5) {
        return Files.deleteIfExists(path$5.javaPath());
    }

    private final ZChannel deleteRecursive$$anonfun$3(Object trace$12) {
        return ZSink$.MODULE$.count(trace$12);
    }

    private final ZIO deleteRecursive$$anonfun$2(Path path$6, Object trace$13) {
        return this.delete(path$6, trace$13);
    }

    private final java.nio.file.Path copy$$anonfun$1(Path source$1, Path target$2, Seq copyOptions$1) {
        return Files.copy(source$1.javaPath(), target$2.javaPath(), (CopyOption[])Arrays$.MODULE$.seqToArray(copyOptions$1, CopyOption.class));
    }

    private final java.nio.file.Path move$$anonfun$1(Path source$2, Path target$3, Seq copyOptions$2) {
        return Files.move(source$2.javaPath(), target$3.javaPath(), (CopyOption[])Arrays$.MODULE$.seqToArray(copyOptions$2, CopyOption.class));
    }

    private final Path readSymbolicLink$$anonfun$1(Path link$3) {
        return Path$.MODULE$.fromJava(Files.readSymbolicLink(link$3.javaPath()));
    }

    private final FileStore getFileStore$$anonfun$1(Path path$7) {
        return Files.getFileStore(path$7.javaPath());
    }

    private final boolean isSameFile$$anonfun$1(Path path$8, Path path2$1) {
        return Files.isSameFile(path$8.javaPath(), path2$1.javaPath());
    }

    private final boolean isHidden$$anonfun$1(Path path$9) {
        return Files.isHidden(path$9.javaPath());
    }

    private final String probeContentType$$anonfun$1(Path path$10) {
        return Files.probeContentType(path$10.javaPath());
    }

    private final FileAttributeView useFileAttributeView$$anonfun$1(Path path$11, Seq linkOptions$1, Class viewClass$1) {
        return Files.getFileAttributeView(path$11.javaPath(), viewClass$1, (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$1, LinkOption.class));
    }

    private final BasicFileAttributes readAttributes$$anonfun$1(Path path$12, Seq linkOptions$2, Class attributeClass$1) {
        return Files.readAttributes(path$12.javaPath(), attributeClass$1, (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$2, LinkOption.class));
    }

    private final java.nio.file.Path setAttribute$$anonfun$1(Path path$13, Files.Attribute attribute$1, Object value$1, Seq linkOptions$3) {
        return Files.setAttribute(path$13.javaPath(), attribute$1.toJava(), value$1, (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$3, LinkOption.class));
    }

    private final Object getAttribute$$anonfun$1(Path path$14, Files.Attribute attribute$2, Seq linkOptions$4) {
        return Files.getAttribute(path$14.javaPath(), attribute$2.toJava(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$4, LinkOption.class));
    }

    private final Map readAttributes$$anonfun$2(Path path$15, Files.Attributes attributes$1, Seq linkOptions$5) {
        return Files.readAttributes(path$15.javaPath(), attributes$1.toJava(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$5, LinkOption.class));
    }

    private final java.util.Set getPosixFilePermissions$$anonfun$1(Path path$16, Seq linkOptions$6) {
        return Files.getPosixFilePermissions(path$16.javaPath(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$6, LinkOption.class));
    }

    private final java.nio.file.Path setPosixFilePermissions$$anonfun$1(Path path$17, scala.collection.immutable.Set permissions$1) {
        return Files.setPosixFilePermissions(path$17.javaPath(), CollectionConverters$.MODULE$.SetHasAsJava((Set)permissions$1).asJava());
    }

    private final UserPrincipal getOwner$$anonfun$1(Path path$18, Seq linkOptions$7) {
        return Files.getOwner(path$18.javaPath(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$7, LinkOption.class));
    }

    private final java.nio.file.Path setOwner$$anonfun$1(Path path$19, UserPrincipal owner$1) {
        return Files.setOwner(path$19.javaPath(), owner$1);
    }

    private final boolean isSymbolicLink$$anonfun$1(Path path$20) {
        return Files.isSymbolicLink(path$20.javaPath());
    }

    private final boolean isDirectory$$anonfun$1(Path path$21, Seq linkOptions$8) {
        return Files.isDirectory(path$21.javaPath(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$8, LinkOption.class));
    }

    private final boolean isRegularFile$$anonfun$1(Path path$22, Seq linkOptions$9) {
        return Files.isRegularFile(path$22.javaPath(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$9, LinkOption.class));
    }

    private final FileTime getLastModifiedTime$$anonfun$1(Path path$23, Seq linkOptions$10) {
        return Files.getLastModifiedTime(path$23.javaPath(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$10, LinkOption.class));
    }

    private final java.nio.file.Path setLastModifiedTime$$anonfun$1(Path path$24, FileTime time$1) {
        return Files.setLastModifiedTime(path$24.javaPath(), time$1);
    }

    private final long size$$anonfun$1(Path path$25) {
        return Files.size(path$25.javaPath());
    }

    private final boolean exists$$anonfun$1(Path path$26, Seq linkOptions$11) {
        return Files.exists(path$26.javaPath(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$11, LinkOption.class));
    }

    private final boolean notExists$$anonfun$1(Path path$27, Seq linkOptions$12) {
        return Files.notExists(path$27.javaPath(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$12, LinkOption.class));
    }

    private final boolean isReadable$$anonfun$1(Path path$28) {
        return Files.isReadable(path$28.javaPath());
    }

    private final boolean isWritable$$anonfun$1(Path path$29) {
        return Files.isWritable(path$29.javaPath());
    }

    private final boolean isExecutable$$anonfun$1(Path path$30) {
        return Files.isExecutable(path$30.javaPath());
    }

    private final Chunk readAllBytes$$anonfun$1(Path path$31) {
        return Chunk$.MODULE$.fromArray((Object)Files.readAllBytes(path$31.javaPath()));
    }

    private final List readAllLines$$anonfun$1(Path path$32, Charset charset$1) {
        return CollectionConverters$.MODULE$.ListHasAsScala(Files.readAllLines(path$32.javaPath(), charset$1.javaCharset())).asScala().toList();
    }

    private final java.nio.file.Path writeBytes$$anonfun$1(Path path$33, Chunk bytes$1, Seq openOptions$1) {
        return Files.write(path$33.javaPath(), (byte[])bytes$1.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), (OpenOption[])Arrays$.MODULE$.seqToArray(openOptions$1, OpenOption.class));
    }

    private final java.nio.file.Path writeLines$$anonfun$1(Path path$34, Iterable lines$1, Charset charset$2, scala.collection.immutable.Set openOptions$2) {
        return Files.write(path$34.javaPath(), (java.lang.Iterable<? extends CharSequence>)CollectionConverters$.MODULE$.IterableHasAsJava(lines$1).asJava(), charset$2.javaCharset(), (OpenOption[])Arrays$.MODULE$.seqToArray(openOptions$2.toSeq(), OpenOption.class));
    }

    private final Stream lines$$anonfun$2$$anonfun$1$$anonfun$1(Path path$37, Charset charset$5) {
        return Files.lines(path$37.javaPath(), charset$5.javaCharset());
    }

    private final ZIO lines$$anonfun$3$$anonfun$2(Path path$36, Charset charset$4, Object trace$15) {
        return ZIO$.MODULE$.attemptBlocking(() -> this.lines$$anonfun$2$$anonfun$1$$anonfun$1(path$36, charset$4), trace$15);
    }

    private final ZManaged lines$$anonfun$1(Path path$35, Charset charset$3, Object trace$14) {
        return ZManaged$.MODULE$.fromAutoCloseable(() -> this.lines$$anonfun$3$$anonfun$2(path$35, charset$3, trace$14), trace$14);
    }

    private final Stream list$$anonfun$3$$anonfun$1$$anonfun$1(Path path$40) {
        return Files.list(path$40.javaPath());
    }

    private final ZIO list$$anonfun$4$$anonfun$2(Path path$39, Object trace$17) {
        return ZIO$.MODULE$.attemptBlocking(() -> this.list$$anonfun$3$$anonfun$1$$anonfun$1(path$39), trace$17);
    }

    private final ZManaged list$$anonfun$1(Path path$38, Object trace$16) {
        return ZManaged$.MODULE$.fromAutoCloseable(() -> this.list$$anonfun$4$$anonfun$2(path$38, trace$16), trace$16);
    }

    private final Stream walk$$anonfun$3$$anonfun$1$$anonfun$1(Path path$43, int maxDepth$3, scala.collection.immutable.Set visitOptions$3) {
        return Files.walk(path$43.javaPath(), maxDepth$3, (FileVisitOption[])Arrays$.MODULE$.seqToArray(visitOptions$3.toSeq(), FileVisitOption.class));
    }

    private final ZIO walk$$anonfun$4$$anonfun$2(Path path$42, int maxDepth$2, scala.collection.immutable.Set visitOptions$2, Object trace$19) {
        return ZIO$.MODULE$.attemptBlocking(() -> this.walk$$anonfun$3$$anonfun$1$$anonfun$1(path$42, maxDepth$2, visitOptions$2), trace$19);
    }

    private final ZManaged walk$$anonfun$1(Path path$41, int maxDepth$1, scala.collection.immutable.Set visitOptions$1, Object trace$18) {
        return ZManaged$.MODULE$.fromAutoCloseable(() -> this.walk$$anonfun$4$$anonfun$2(path$41, maxDepth$1, visitOptions$1, trace$18), trace$18);
    }

    private final Stream find$$anonfun$3$$anonfun$1$$anonfun$1(Path path$46, int maxDepth$6, scala.collection.immutable.Set visitOptions$6, BiPredicate matcher$3) {
        return Files.find(path$46.javaPath(), maxDepth$6, matcher$3, (FileVisitOption[])Arrays$.MODULE$.seqToArray(visitOptions$6.toSeq(), FileVisitOption.class));
    }

    private final ZIO find$$anonfun$4$$anonfun$2(Path path$45, int maxDepth$5, scala.collection.immutable.Set visitOptions$5, Object trace$21, BiPredicate matcher$2) {
        return ZIO$.MODULE$.attemptBlocking(() -> this.find$$anonfun$3$$anonfun$1$$anonfun$1(path$45, maxDepth$5, visitOptions$5, matcher$2), trace$21);
    }

    private final ZManaged find$$anonfun$1(Path path$44, int maxDepth$4, scala.collection.immutable.Set visitOptions$4, Object trace$20, BiPredicate matcher$1) {
        return ZManaged$.MODULE$.fromAutoCloseable(() -> this.find$$anonfun$4$$anonfun$2(path$44, maxDepth$4, visitOptions$4, trace$20, matcher$1), trace$20);
    }

    private final long copy$$anonfun$3$$anonfun$1(Path target$4, Seq options$1, InputStream inputStream$1) {
        return Files.copy(inputStream$1, target$4.javaPath(), (CopyOption[])Arrays$.MODULE$.seqToArray(options$1, CopyOption.class));
    }
}

