/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.channels;

import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.Iterator;
import java.util.Set;
import scala.Function0;
import scala.Function1;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.IO$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZManaged;
import zio.nio.IOCloseable;
import zio.nio.channels.SelectionKey;
import zio.nio.channels.Selector$;
import zio.nio.channels.spi.SelectorProvider;

public final class Selector
implements IOCloseable {
    private final java.nio.channels.Selector selector;

    public static ZManaged open(Object object) {
        return Selector$.MODULE$.open(object);
    }

    public Selector(java.nio.channels.Selector selector) {
        this.selector = selector;
    }

    public java.nio.channels.Selector selector() {
        return this.selector;
    }

    public ZIO isOpen(Object trace) {
        return IO$.MODULE$.succeed(this::isOpen$$anonfun$1, trace);
    }

    public ZIO provider(Object trace) {
        return IO$.MODULE$.succeed(this::provider$$anonfun$1, trace).map((Function1 & Serializable)_$1 -> new SelectorProvider((java.nio.channels.spi.SelectorProvider)_$1), trace);
    }

    public ZIO<Object, Nothing$, scala.collection.immutable.Set<SelectionKey>> keys(Object trace) {
        return IO$.MODULE$.succeed(this::keys$$anonfun$1, trace).map((Function1 & Serializable)_$2 -> (scala.collection.immutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(_$2).asScala().toSet().map((Function1 & Serializable)_$3 -> new SelectionKey((java.nio.channels.SelectionKey)_$3)), trace);
    }

    public ZIO<Object, Nothing$, scala.collection.mutable.Set<SelectionKey>> selectedKeys(Object trace) {
        return IO$.MODULE$.succeed(this::selectedKeys$$anonfun$1, trace).map((Function1 & Serializable)_$4 -> (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(_$4).asScala().map((Function1 & Serializable)_$5 -> new SelectionKey((java.nio.channels.SelectionKey)_$5)), trace);
    }

    public <R, E> ZIO<R, E, BoxedUnit> foreachSelectedKey(Function1<SelectionKey, ZIO<R, E, Object>> f, Object trace) {
        return ZIO$.MODULE$.succeed(this::foreachSelectedKey$$anonfun$1, trace).flatMap((Function1 & Serializable)iter -> Selector.loop$7(f, trace, iter), trace);
    }

    public ZIO removeKey(SelectionKey key, Object trace) {
        return IO$.MODULE$.succeed(() -> this.removeKey$$anonfun$1(key), trace).unit(trace);
    }

    public ZIO selectNow(Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.attempt(this::selectNow$$anonfun$1, trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZIO select(Duration timeout, Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.attemptBlocking(() -> this.select$$anonfun$1(timeout), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace).fork(trace).flatMap((Function1 & Serializable)_$7 -> _$7.join(trace), trace).onInterrupt(() -> this.select$$anonfun$3(trace), trace);
    }

    public ZIO select(Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.attemptBlocking(this::select$$anonfun$4, trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace).fork(trace).flatMap((Function1 & Serializable)_$8 -> _$8.join(trace), trace).onInterrupt(() -> this.select$$anonfun$6(trace), trace);
    }

    public ZIO wakeup(Object trace) {
        return IO$.MODULE$.succeed(this::wakeup$$anonfun$1, trace).unit(trace);
    }

    @Override
    public ZIO close(Object trace) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.attempt((Function0)((JFunction0.mcV.sp & Serializable)this::close$$anonfun$1), trace));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    private final boolean isOpen$$anonfun$1() {
        return this.selector().isOpen();
    }

    private final java.nio.channels.spi.SelectorProvider provider$$anonfun$1() {
        return this.selector().provider();
    }

    private final Set keys$$anonfun$1() {
        return this.selector().keys();
    }

    private final Set selectedKeys$$anonfun$1() {
        return this.selector().selectedKeys();
    }

    private final Iterator foreachSelectedKey$$anonfun$1() {
        return this.selector().selectedKeys().iterator();
    }

    private static final boolean loop$1$$anonfun$1$$anonfun$1$$anonfun$1(boolean _$6$1) {
        return _$6$1;
    }

    private static final void loop$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(Iterator iter$5) {
        iter$5.remove();
    }

    private static final ZIO loop$3$$anonfun$3$$anonfun$3$$anonfun$3(Object trace$5, Iterator iter$4) {
        return ZIO$.MODULE$.succeed((Function0)((JFunction0.mcV.sp & Serializable)() -> Selector.loop$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(iter$4)), trace$5);
    }

    private static final ZIO loop$6$$anonfun$6$$anonfun$5(Function1 f$4, Object trace$11, Iterator iter$7) {
        return Selector.loop$7(f$4, trace$11, iter$7);
    }

    private static final ZIO loop$8$$anonfun$7(Function1 f$2, Object trace$2, Iterator iter$2) {
        ZIO zIO;
        if (iter$2.hasNext()) {
            java.nio.channels.SelectionKey key = (java.nio.channels.SelectionKey)iter$2.next();
            zIO = ((ZIO)f$2.apply((Object)new SelectionKey(key))).flatMap((Function1 & Serializable)_$6 -> ZIO$.MODULE$.when(() -> Selector.loop$1$$anonfun$1$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)_$6)), () -> Selector.loop$3$$anonfun$3$$anonfun$3$$anonfun$3(trace$2, iter$2), trace$2), trace$2).$times$greater(() -> Selector.loop$6$$anonfun$6$$anonfun$5(f$2, trace$2, iter$2), trace$2);
        } else {
            zIO = ZIO$.MODULE$.unit();
        }
        return zIO;
    }

    private static final ZIO loop$7(Function1 f$1, Object trace$1, Iterator iter$1) {
        return ZIO$.MODULE$.suspendSucceed(() -> Selector.loop$8$$anonfun$7(f$1, trace$1, iter$1), trace$1);
    }

    private final boolean removeKey$$anonfun$1(SelectionKey key$1) {
        return this.selector().selectedKeys().remove(key$1.selectionKey());
    }

    private final int selectNow$$anonfun$1() {
        return this.selector().selectNow();
    }

    private final int select$$anonfun$1(Duration timeout$1) {
        return this.selector().select(timeout$1.toMillis());
    }

    private final ZIO select$$anonfun$3(Object trace$7) {
        return this.wakeup(trace$7);
    }

    private final int select$$anonfun$4() {
        return this.selector().select();
    }

    private final ZIO select$$anonfun$6(Object trace$9) {
        return this.wakeup(trace$9);
    }

    private final java.nio.channels.Selector wakeup$$anonfun$1() {
        return this.selector().wakeup();
    }

    private final void close$$anonfun$1() {
        this.selector().close();
    }
}

