/*
 * Decompiled with CFR 0.152.
 */
package zio.nio;

import java.nio.ByteOrder;
import scala.Function1;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import zio.Chunk;
import zio.Chunk$;
import zio.UIO$;
import zio.ZIO;
import zio.nio.Buffer;

public final class CharBuffer
extends Buffer<Object> {
    private final java.nio.CharBuffer buffer;

    public CharBuffer(java.nio.CharBuffer buffer) {
        this.buffer = buffer;
        super(ClassTag$.MODULE$.apply(Character.TYPE));
    }

    @Override
    public java.nio.CharBuffer buffer() {
        return this.buffer;
    }

    @Override
    public ZIO<Object, Nothing$, char[]> array(Object trace) {
        return UIO$.MODULE$.succeed(this::array$$anonfun$1, trace);
    }

    @Override
    public ZIO order(Object trace) {
        return UIO$.MODULE$.succeed(this::order$$anonfun$1, trace);
    }

    @Override
    public ZIO slice(Object trace) {
        return UIO$.MODULE$.succeed(this::slice$$anonfun$1, trace);
    }

    @Override
    public ZIO compact(Object trace) {
        return UIO$.MODULE$.succeed(this::compact$$anonfun$1, trace).unit(trace);
    }

    @Override
    public ZIO duplicate(Object trace) {
        return UIO$.MODULE$.succeed(this::duplicate$$anonfun$1, trace);
    }

    public <R, E, A> ZIO<R, E, A> withJavaBuffer(Function1<java.nio.CharBuffer, ZIO<R, E, A>> f, Object trace) {
        return (ZIO)f.apply((Object)this.buffer());
    }

    @Override
    public ZIO get(Object trace) {
        return UIO$.MODULE$.succeed(this::get$$anonfun$1, trace);
    }

    @Override
    public ZIO get(int i, Object trace) {
        return UIO$.MODULE$.succeed(() -> this.get$$anonfun$2(i), trace);
    }

    @Override
    public ZIO<Object, Nothing$, Chunk<Object>> getChunk(int maxLength, Object trace) {
        return UIO$.MODULE$.succeed(() -> this.getChunk$$anonfun$1(maxLength), trace);
    }

    @Override
    public int getChunk$default$1() {
        return Integer.MAX_VALUE;
    }

    public ZIO getString(Object trace) {
        return UIO$.MODULE$.succeed(this::getString$$anonfun$1, trace);
    }

    @Override
    public ZIO put(char element, Object trace) {
        return UIO$.MODULE$.succeed(() -> this.put$$anonfun$1(element), trace).unit(trace);
    }

    @Override
    public ZIO put(int index, char element, Object trace) {
        return UIO$.MODULE$.succeed(() -> this.put$$anonfun$2(index, element), trace).unit(trace);
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> putChunkAll(Chunk<Object> chunk, Object trace) {
        return UIO$.MODULE$.succeed(() -> this.putChunkAll$$anonfun$1(chunk), trace).unit(trace);
    }

    @Override
    public ZIO asReadOnlyBuffer(Object trace) {
        return UIO$.MODULE$.succeed(this::asReadOnlyBuffer$$anonfun$1, trace);
    }

    private final char[] array$$anonfun$1() {
        return this.buffer().array();
    }

    private final ByteOrder order$$anonfun$1() {
        return this.buffer().order();
    }

    private final CharBuffer slice$$anonfun$1() {
        return new CharBuffer(this.buffer().slice());
    }

    private final java.nio.CharBuffer compact$$anonfun$1() {
        return this.buffer().compact();
    }

    private final CharBuffer duplicate$$anonfun$1() {
        return new CharBuffer(this.buffer().duplicate());
    }

    private final char get$$anonfun$1() {
        return this.buffer().get();
    }

    private final char get$$anonfun$2(int i$1) {
        return this.buffer().get(i$1);
    }

    private final Chunk getChunk$$anonfun$1(int maxLength$1) {
        char[] array = new char[package$.MODULE$.min(maxLength$1, this.buffer().remaining())];
        this.buffer().get(array);
        return Chunk$.MODULE$.fromArray((Object)array);
    }

    private final String getString$$anonfun$1() {
        return this.buffer().toString();
    }

    private final java.nio.CharBuffer put$$anonfun$1(char element$1) {
        return this.buffer().put(element$1);
    }

    private final java.nio.CharBuffer put$$anonfun$2(int index$1, char element$2) {
        return this.buffer().put(index$1, element$2);
    }

    private final java.nio.CharBuffer putChunkAll$$anonfun$1(Chunk chunk$1) {
        char[] array = (char[])chunk$1.toArray(ClassTag$.MODULE$.apply(Character.TYPE));
        return this.buffer().put(array);
    }

    private final CharBuffer asReadOnlyBuffer$$anonfun$1() {
        return new CharBuffer(this.buffer().asReadOnlyBuffer());
    }
}

