/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.file;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.function.BiPredicate;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.IsSubtypeOfError$;
import zio.Scope;
import zio.ZIO;
import zio.ZIO$;
import zio.nio.charset.Charset;
import zio.nio.charset.Charset$Standard$;
import zio.nio.file.Files;
import zio.nio.file.Path;
import zio.nio.file.Path$;
import zio.stream.ZSink;
import zio.stream.ZSink$;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class Files$ {
    public static Files$ MODULE$;

    static {
        new Files$();
    }

    public ZStream<Object, IOException, Path> newDirectoryStream(Path dir, String glob, Object trace) {
        ZIO scoped = ZIO$.MODULE$.fromAutoCloseable((Function0 & Serializable & scala.Serializable)() -> ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.newDirectoryStream(dir.javaPath(), glob), trace), trace).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.iterator(), trace);
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaIteratorScoped((Function0 & Serializable & scala.Serializable)() -> scoped, trace).map((Function1 & Serializable & scala.Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZStream<Object, IOException, Path> newDirectoryStream(Path dir, Function1<Path, Object> filter, Object trace) {
        DirectoryStream.Filter<java.nio.file.Path> javaFilter = javaPath -> BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)Path$.MODULE$.fromJava((java.nio.file.Path)javaPath)));
        ZIO scoped = ZIO$.MODULE$.fromAutoCloseable((Function0 & Serializable & scala.Serializable)() -> ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.newDirectoryStream(dir.javaPath(), javaFilter), trace), trace).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.iterator(), trace);
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaIteratorScoped((Function0 & Serializable & scala.Serializable)() -> scoped, trace).map((Function1 & Serializable & scala.Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public String newDirectoryStream$default$2() {
        return "*";
    }

    public ZIO<Object, IOException, BoxedUnit> createFile(Path path, Seq<FileAttribute<?>> attrs, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.createFile(path.javaPath(), (FileAttribute[])attrs.toArray(ClassTag$.MODULE$.apply(FileAttribute.class))), trace).unit(trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> createDirectory(Path path, Seq<FileAttribute<?>> attrs, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.createDirectory(path.javaPath(), (FileAttribute[])attrs.toArray(ClassTag$.MODULE$.apply(FileAttribute.class))), trace).unit(trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> createDirectories(Path path, Seq<FileAttribute<?>> attrs, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.createDirectories(path.javaPath(), (FileAttribute[])attrs.toArray(ClassTag$.MODULE$.apply(FileAttribute.class))), trace).unit(trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, Path> createTempFileIn(Path dir, String suffix, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Path$.MODULE$.fromJava(Files.createTempFile(dir.javaPath(), (String)prefix.orNull(Predef$.MODULE$.$conforms()), suffix, (FileAttribute[])fileAttributes.toSeq().toArray(ClassTag$.MODULE$.apply(FileAttribute.class)))), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Scope, IOException, Path> createTempFileInScoped(Path dir, String suffix, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        return ZIO$.MODULE$.acquireRelease((Function0 & Serializable & scala.Serializable)() -> MODULE$.createTempFileIn(dir, suffix, prefix, fileAttributes, trace), (Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.deleteIfExists((Path)x$3, trace).ignore(trace), trace);
    }

    public ZIO<Object, IOException, Path> createTempFile(String suffix, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Path$.MODULE$.fromJava(Files.createTempFile((String)prefix.orNull(Predef$.MODULE$.$conforms()), suffix, (FileAttribute[])fileAttributes.toSeq().toArray(ClassTag$.MODULE$.apply(FileAttribute.class)))), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public String createTempFileIn$default$2() {
        return ".tmp";
    }

    public String createTempFileInScoped$default$2() {
        return ".tmp";
    }

    public Option<String> createTempFileInScoped$default$3() {
        return None$.MODULE$;
    }

    public Iterable<FileAttribute<?>> createTempFileInScoped$default$4() {
        return Nil$.MODULE$;
    }

    public String createTempFile$default$1() {
        return ".tmp";
    }

    public ZIO<Scope, IOException, Path> createTempFileScoped(String suffix, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        return ZIO$.MODULE$.acquireRelease((Function0 & Serializable & scala.Serializable)() -> MODULE$.createTempFile(suffix, prefix, fileAttributes, trace), (Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.deleteIfExists((Path)x$4, trace).ignore(trace), trace);
    }

    public String createTempFileScoped$default$1() {
        return ".tmp";
    }

    public Option<String> createTempFileScoped$default$2() {
        return None$.MODULE$;
    }

    public Iterable<FileAttribute<?>> createTempFileScoped$default$3() {
        return Nil$.MODULE$;
    }

    public ZIO<Object, IOException, Path> createTempDirectory(Path dir, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Path$.MODULE$.fromJava(Files.createTempDirectory(dir.javaPath(), (String)prefix.orNull(Predef$.MODULE$.$conforms()), (FileAttribute[])fileAttributes.toSeq().toArray(ClassTag$.MODULE$.apply(FileAttribute.class)))), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Scope, IOException, Path> createTempDirectoryScoped(Path dir, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        return ZIO$.MODULE$.acquireRelease((Function0 & Serializable & scala.Serializable)() -> MODULE$.createTempDirectory(dir, prefix, fileAttributes, trace), (Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.deleteRecursive((Path)x$5, trace).ignore(trace), trace);
    }

    public ZIO<Object, IOException, Path> createTempDirectory(Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Path$.MODULE$.fromJava(Files.createTempDirectory((String)prefix.orNull(Predef$.MODULE$.$conforms()), (FileAttribute[])fileAttributes.toSeq().toArray(ClassTag$.MODULE$.apply(FileAttribute.class)))), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Scope, IOException, Path> createTempDirectoryScoped(Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes, Object trace) {
        return ZIO$.MODULE$.acquireRelease((Function0 & Serializable & scala.Serializable)() -> MODULE$.createTempDirectory(prefix, fileAttributes, trace), (Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.deleteRecursive((Path)x$6, trace).ignore(trace), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> createSymbolicLink(Path link, Path target, Seq<FileAttribute<?>> fileAttributes, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.createSymbolicLink(link.javaPath(), target.javaPath(), (FileAttribute[])fileAttributes.toArray(ClassTag$.MODULE$.apply(FileAttribute.class))), trace).unit(trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> createLink(Path link, Path existing, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.createLink(link.javaPath(), existing.javaPath()), trace).unit(trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> delete(Path path, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Files.delete(path.javaPath()), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, Object> deleteIfExists(Path path, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.deleteIfExists(path.javaPath()), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, Object> deleteRecursive(Path path2, Object trace) {
        return this.newDirectoryStream(path2, this.newDirectoryStream$default$2(), trace).mapZIO((Function1 & Serializable & scala.Serializable)path -> MODULE$.delete((Path)path, trace), trace).run((Function0 & Serializable & scala.Serializable)() -> new ZSink(ZSink$.MODULE$.count(trace)), trace).$less$times((Function0 & Serializable & scala.Serializable)() -> MODULE$.delete(path2, trace), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> copy(Path source, Path target, Seq<CopyOption> copyOptions, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.copy(source.javaPath(), target.javaPath(), (CopyOption[])copyOptions.toArray(ClassTag$.MODULE$.apply(CopyOption.class))), trace).unit(trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> move(Path source, Path target, Seq<CopyOption> copyOptions, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.move(source.javaPath(), target.javaPath(), (CopyOption[])copyOptions.toArray(ClassTag$.MODULE$.apply(CopyOption.class))), trace).unit(trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, Path> readSymbolicLink(Path link, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Path$.MODULE$.fromJava(Files.readSymbolicLink(link.javaPath())), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, FileStore> getFileStore(Path path, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.getFileStore(path.javaPath()), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, Object> isSameFile(Path path, Path path2, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.isSameFile(path.javaPath(), path2.javaPath()), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, Object> isHidden(Path path, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.isHidden(path.javaPath()), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, String> probeContentType(Path path, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.probeContentType(path.javaPath()), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public <A extends FileAttributeView, B, E> ZIO<Object, E, B> useFileAttributeView(Path path, Seq<LinkOption> linkOptions, Function1<A, ZIO<Object, E, B>> f, ClassTag<A> evidence$1, Object trace) {
        Class viewClass = package$.MODULE$.classTag(evidence$1).runtimeClass();
        return ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.getFileAttributeView(path.javaPath(), viewClass, (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class))), trace).orDie(IsSubtypeOfError$.MODULE$.impl(Predef$.MODULE$.$conforms()), CanFail$.MODULE$.canFail(), trace).flatMap(f, trace);
    }

    public <A extends BasicFileAttributes> ZIO<Object, IOException, A> readAttributes(Path path, Seq<LinkOption> linkOptions, ClassTag<A> evidence$2, Object trace) {
        Class attributeClass = package$.MODULE$.classTag(evidence$2).runtimeClass();
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.readAttributes(path.javaPath(), attributeClass, (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class))), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, Exception, BoxedUnit> setAttribute(Path path, Files.Attribute attribute, Object value, Seq<LinkOption> linkOptions, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.setAttribute(path.javaPath(), attribute.toJava(), value, (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class))), trace).unit(trace)), ClassTag$.MODULE$.apply(Exception.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, Object> getAttribute(Path path, Files.Attribute attribute, Seq<LinkOption> linkOptions, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.getAttribute(path.javaPath(), attribute.toJava(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class))), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, Map<String, Object>> readAttributes(Path path, Files.Attributes attributes, Seq<LinkOption> linkOptions, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.readAttributes(path.javaPath(), attributes.toJava(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class))), trace).map((Function1 & Serializable & scala.Serializable)x$7 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$7).asScala()).toMap(Predef$.MODULE$.$conforms()), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, scala.collection.immutable.Set<PosixFilePermission>> getPosixFilePermissions(Path path, Seq<LinkOption> linkOptions, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.getPosixFilePermissions(path.javaPath(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class))), trace).map((Function1 & Serializable & scala.Serializable)x$8 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(x$8).asScala()).toSet(), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> setPosixFilePermissions(Path path, scala.collection.immutable.Set<PosixFilePermission> permissions, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.setPosixFilePermissions(path.javaPath(), (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)permissions).asJava()), trace).unit(trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, UserPrincipal> getOwner(Path path, Seq<LinkOption> linkOptions, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.getOwner(path.javaPath(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class))), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> setOwner(Path path, UserPrincipal owner, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.setOwner(path.javaPath(), owner), trace).unit(trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, Nothing$, Object> isSymbolicLink(Path path, Object trace) {
        return ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.isSymbolicLink(path.javaPath()), trace).orDie(IsSubtypeOfError$.MODULE$.impl(Predef$.MODULE$.$conforms()), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, Nothing$, Object> isDirectory(Path path, Seq<LinkOption> linkOptions, Object trace) {
        return ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.isDirectory(path.javaPath(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class))), trace).orDie(IsSubtypeOfError$.MODULE$.impl(Predef$.MODULE$.$conforms()), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, Nothing$, Object> isRegularFile(Path path, Seq<LinkOption> linkOptions, Object trace) {
        return ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.isRegularFile(path.javaPath(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class))), trace).orDie(IsSubtypeOfError$.MODULE$.impl(Predef$.MODULE$.$conforms()), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, FileTime> getLastModifiedTime(Path path, Seq<LinkOption> linkOptions, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.getLastModifiedTime(path.javaPath(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class))), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> setLastModifiedTime(Path path, FileTime time, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.setLastModifiedTime(path.javaPath(), time), trace).unit(trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, Object> size(Path path, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Files.size(path.javaPath()), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, Nothing$, Object> exists(Path path, Seq<LinkOption> linkOptions, Object trace) {
        return ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.exists(path.javaPath(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class))), trace).orDie(IsSubtypeOfError$.MODULE$.impl(Predef$.MODULE$.$conforms()), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, Nothing$, Object> notExists(Path path, Seq<LinkOption> linkOptions, Object trace) {
        return ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.notExists(path.javaPath(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class))), trace).orDie(IsSubtypeOfError$.MODULE$.impl(Predef$.MODULE$.$conforms()), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, Nothing$, Object> isReadable(Path path, Object trace) {
        return ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.isReadable(path.javaPath()), trace).orDie(IsSubtypeOfError$.MODULE$.impl(Predef$.MODULE$.$conforms()), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, Nothing$, Object> isWritable(Path path, Object trace) {
        return ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.isWritable(path.javaPath()), trace).orDie(IsSubtypeOfError$.MODULE$.impl(Predef$.MODULE$.$conforms()), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, Nothing$, Object> isExecutable(Path path, Object trace) {
        return ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.isExecutable(path.javaPath()), trace).orDie(IsSubtypeOfError$.MODULE$.impl(Predef$.MODULE$.$conforms()), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, Chunk<Object>> readAllBytes(Path path, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Chunk$.MODULE$.fromArray((Object)Files.readAllBytes(path.javaPath())), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, List<String>> readAllLines(Path path, Charset charset, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(path.javaPath(), charset.javaCharset())).asScala()).toList(), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public Charset readAllLines$default$2() {
        return Charset$Standard$.MODULE$.utf8();
    }

    public ZIO<Object, IOException, BoxedUnit> writeBytes(Path path, Chunk<Object> bytes, Seq<OpenOption> openOptions, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.write(path.javaPath(), (byte[])bytes.toArray(ClassTag$.MODULE$.Byte()), (OpenOption[])openOptions.toArray(ClassTag$.MODULE$.apply(OpenOption.class))), trace).unit(trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZIO<Object, IOException, BoxedUnit> writeLines(Path path, Iterable<CharSequence> lines, Charset charset, scala.collection.immutable.Set<OpenOption> openOptions, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.write(path.javaPath(), (java.lang.Iterable<? extends CharSequence>)((java.lang.Iterable)CollectionConverters$.MODULE$.asJavaIterableConverter(lines).asJava()), charset.javaCharset(), (OpenOption[])openOptions.toSeq().toArray(ClassTag$.MODULE$.apply(OpenOption.class))), trace).unit(trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public Charset writeLines$default$3() {
        return Charset$Standard$.MODULE$.utf8();
    }

    public scala.collection.immutable.Set<OpenOption> writeLines$default$4() {
        return Predef$.MODULE$.Set().empty();
    }

    public ZStream<Object, IOException, String> lines(Path path, Charset charset, Object trace) {
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaStreamScoped((Function0 & Serializable & scala.Serializable)() -> ZIO$.MODULE$.fromAutoCloseable((Function0 & Serializable & scala.Serializable)() -> ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.lines(path.javaPath(), charset.javaCharset()), trace), trace), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public Charset lines$default$2() {
        return Charset$Standard$.MODULE$.utf8();
    }

    public ZStream<Object, IOException, Path> list(Path path, Object trace) {
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaStreamScoped((Function0 & Serializable & scala.Serializable)() -> ZIO$.MODULE$.fromAutoCloseable((Function0 & Serializable & scala.Serializable)() -> ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.list(path.javaPath()), trace), trace), trace).map((Function1 & Serializable & scala.Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public ZStream<Object, IOException, Path> walk(Path path, int maxDepth, scala.collection.immutable.Set<FileVisitOption> visitOptions, Object trace) {
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaStreamScoped((Function0 & Serializable & scala.Serializable)() -> ZIO$.MODULE$.fromAutoCloseable((Function0 & Serializable & scala.Serializable)() -> ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.walk(path.javaPath(), maxDepth, (FileVisitOption[])visitOptions.toSeq().toArray(ClassTag$.MODULE$.apply(FileVisitOption.class))), trace), trace), trace).map((Function1 & Serializable & scala.Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public int walk$default$2() {
        return Integer.MAX_VALUE;
    }

    public scala.collection.immutable.Set<FileVisitOption> walk$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    public ZStream<Object, IOException, Path> find(Path path2, int maxDepth, scala.collection.immutable.Set<FileVisitOption> visitOptions, Function2<Path, BasicFileAttributes, Object> test, Object trace) {
        BiPredicate<java.nio.file.Path, BasicFileAttributes> matcher = (path, attr) -> BoxesRunTime.unboxToBoolean((Object)test.apply((Object)Path$.MODULE$.fromJava((java.nio.file.Path)path), attr));
        return ZStream.RefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZStream$.MODULE$.RefineToOrDieOps(ZStream$.MODULE$.fromJavaStreamScoped((Function0 & Serializable & scala.Serializable)() -> ZIO$.MODULE$.fromAutoCloseable((Function0 & Serializable & scala.Serializable)() -> ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Files.find(path2.javaPath(), maxDepth, matcher, (FileVisitOption[])visitOptions.toSeq().toArray(ClassTag$.MODULE$.apply(FileVisitOption.class))), trace), trace), trace).map((Function1 & Serializable & scala.Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public int find$default$2() {
        return Integer.MAX_VALUE;
    }

    public scala.collection.immutable.Set<FileVisitOption> find$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    public ZIO<Object, IOException, Object> copy(ZStream<Object, IOException, Object> in, Path target, Seq<CopyOption> options, Object trace) {
        return ZIO.ScopedPartiallyApplied$.MODULE$.apply$extension(ZIO$.MODULE$.scoped(), (Function0 & Serializable & scala.Serializable)() -> ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(in.toInputStream(Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), trace).flatMap((Function1 & Serializable & scala.Serializable)inputStream -> ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Files.copy(inputStream, target.javaPath(), (CopyOption[])options.toArray(ClassTag$.MODULE$.apply(CopyOption.class))), trace), trace)), ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(), trace), trace);
    }

    private Files$() {
        MODULE$ = this;
    }
}

