/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.charset;

import java.io.Serializable;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichFloat$;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.ZIO;
import zio.ZIO$;
import zio.nio.Buffer$;
import zio.nio.ByteBuffer;
import zio.nio.CharBuffer;
import zio.nio.charset.AutoDetect;
import zio.nio.charset.AutoDetect$NotDetected$;
import zio.nio.charset.AutoDetect$NotSupported$;
import zio.nio.charset.Charset;
import zio.nio.charset.Charset$;
import zio.nio.charset.CharsetDecoder;
import zio.nio.charset.CoderResult;
import zio.nio.charset.CoderResult$;
import zio.nio.charset.CoderResult$Overflow$;
import zio.nio.charset.CoderResult$Underflow$;
import zio.stream.ZChannel$;
import zio.stream.ZPipeline;
import zio.stream.ZPipeline$;

public final class CharsetDecoder$ {
    public static CharsetDecoder$ MODULE$;

    static {
        new CharsetDecoder$();
    }

    public java.nio.charset.CharsetDecoder fromJava(java.nio.charset.CharsetDecoder javaDecoder) {
        return javaDecoder;
    }

    public final float averageCharsPerByte$extension(java.nio.charset.CharsetDecoder $this) {
        return $this.averageCharsPerByte();
    }

    public final Charset charset$extension(java.nio.charset.CharsetDecoder $this) {
        return Charset$.MODULE$.fromJava($this.charset());
    }

    public final ZIO<Object, CharacterCodingException, CharBuffer> decode$extension0(java.nio.charset.CharsetDecoder $this, ByteBuffer in, Object trace) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(in.withJavaBuffer((Function1 & Serializable & scala.Serializable)jBuf -> ZIO$.MODULE$.attempt((Function0 & Serializable & scala.Serializable)() -> Buffer$.MODULE$.charFromJava($this.decode((java.nio.ByteBuffer)jBuf)), trace), trace)), ClassTag$.MODULE$.apply(CharacterCodingException.class), CanFail$.MODULE$.canFail(), trace);
    }

    public final ZIO<Object, Nothing$, CoderResult> decode$extension1(java.nio.charset.CharsetDecoder $this, ByteBuffer in, CharBuffer out, boolean endOfInput, Object trace) {
        return in.withJavaBuffer((Function1 & Serializable & scala.Serializable)jIn -> out.withJavaBuffer((Function1 & Serializable & scala.Serializable)jOut -> ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> CoderResult$.MODULE$.fromJava($this.decode((java.nio.ByteBuffer)jIn, (java.nio.CharBuffer)jOut, endOfInput)), trace), trace), trace);
    }

    public final ZIO<Object, Nothing$, AutoDetect> autoDetect$extension(java.nio.charset.CharsetDecoder $this, Object trace) {
        return ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> {
            if ($this.isAutoDetecting()) {
                if ($this.isCharsetDetected()) {
                    return new AutoDetect.Detected(Charset$.MODULE$.fromJava($this.detectedCharset()));
                }
                return AutoDetect$NotDetected$.MODULE$;
            }
            return AutoDetect$NotSupported$.MODULE$;
        }, trace);
    }

    public final ZIO<Object, Nothing$, CoderResult> flush$extension(java.nio.charset.CharsetDecoder $this, CharBuffer out, Object trace) {
        return out.withJavaBuffer((Function1 & Serializable & scala.Serializable)jOut -> ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> CoderResult$.MODULE$.fromJava($this.flush((java.nio.CharBuffer)jOut)), trace), trace);
    }

    public final ZIO<Object, Nothing$, CodingErrorAction> malformedInputAction$extension(java.nio.charset.CharsetDecoder $this, Object trace) {
        return ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> $this.malformedInputAction(), trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> onMalformedInput$extension(java.nio.charset.CharsetDecoder $this, CodingErrorAction errorAction, Object trace) {
        return ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> $this.onMalformedInput(errorAction), trace).unit(trace);
    }

    public final ZIO<Object, Nothing$, CodingErrorAction> unmappableCharacterAction$extension(java.nio.charset.CharsetDecoder $this, Object trace) {
        return ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> $this.unmappableCharacterAction(), trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> onUnmappableCharacter$extension(java.nio.charset.CharsetDecoder $this, CodingErrorAction errorAction, Object trace) {
        return ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> $this.onUnmappableCharacter(errorAction), trace).unit(trace);
    }

    public final float maxCharsPerByte$extension(java.nio.charset.CharsetDecoder $this) {
        return $this.maxCharsPerByte();
    }

    public final ZIO<Object, Nothing$, String> replacement$extension(java.nio.charset.CharsetDecoder $this, Object trace) {
        return ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> $this.replacement(), trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> replaceWith$extension(java.nio.charset.CharsetDecoder $this, String replacement, Object trace) {
        return ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> $this.replaceWith(replacement), trace).unit(trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> reset$extension(java.nio.charset.CharsetDecoder $this, Object trace) {
        return ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> $this.reset(), trace).unit(trace);
    }

    public final ZPipeline<Object, CharacterCodingException, Object, Object> transducer$extension(java.nio.charset.CharsetDecoder $this, int bufSize, Object trace) {
        if (bufSize < 50) {
            return ZPipeline$.MODULE$.fromChannel((Function0 & Serializable & scala.Serializable)() -> ZChannel$.MODULE$.fromZIO((Function0 & Serializable & scala.Serializable)() -> ZIO$.MODULE$.die((Function0 & Serializable & scala.Serializable)() -> new IllegalArgumentException(new StringBuilder(30).append("Buffer size is ").append(bufSize).append(", must be >= 50").toString()), trace), trace));
        }
        return ZPipeline$.MODULE$.fromPush((Function0 & Serializable & scala.Serializable)() -> CharsetDecoder$.push$1(trace, $this, bufSize), trace);
    }

    public final int transducer$default$1$extension(java.nio.charset.CharsetDecoder $this) {
        return 5000;
    }

    public final int hashCode$extension(java.nio.charset.CharsetDecoder $this) {
        return $this.hashCode();
    }

    public final boolean equals$extension(java.nio.charset.CharsetDecoder $this, Object x$1) {
        boolean bl = x$1 instanceof CharsetDecoder;
        if (bl) {
            java.nio.charset.CharsetDecoder charsetDecoder = x$1 == null ? null : ((CharsetDecoder)x$1).javaDecoder();
            java.nio.charset.CharsetDecoder charsetDecoder2 = $this;
            if (!(charsetDecoder2 != null ? !charsetDecoder2.equals(charsetDecoder) : charsetDecoder != null)) {
                return true;
            }
        }
        return false;
    }

    private static final ZIO handleCoderResult$1(CoderResult coderResult, Object trace, ByteBuffer byteBuffer$1, CharBuffer charBuffer$1) {
        ZIO zIO;
        boolean bl = CoderResult$Underflow$.MODULE$.equals(coderResult) ? true : CoderResult$Overflow$.MODULE$.equals(coderResult);
        if (bl) {
            zIO = byteBuffer$1.compact(trace).$times$greater((Function0 & Serializable & scala.Serializable)() -> charBuffer$1.flip(trace), trace).$times$greater((Function0 & Serializable & scala.Serializable)() -> charBuffer$1.getChunk(charBuffer$1.getChunk$default$1(), trace), trace).$less$times((Function0 & Serializable & scala.Serializable)() -> charBuffer$1.clear(trace), trace);
        } else if (coderResult instanceof CoderResult.Malformed) {
            int length = ((CoderResult.Malformed)coderResult).length();
            zIO = ZIO$.MODULE$.fail((Function0 & Serializable & scala.Serializable)() -> new MalformedInputException(length), trace);
        } else if (coderResult instanceof CoderResult.Unmappable) {
            int length = ((CoderResult.Unmappable)coderResult).length();
            zIO = ZIO$.MODULE$.fail((Function0 & Serializable & scala.Serializable)() -> new UnmappableCharacterException(length), trace);
        } else {
            throw new MatchError((Object)coderResult);
        }
        return zIO;
    }

    public static final /* synthetic */ Tuple2 $anonfun$transducer$11(Chunk inBytes$1, int bufRemaining) {
        Tuple2 tuple2;
        Tuple2 tuple22 = tuple2 = inBytes$1.length() > bufRemaining ? inBytes$1.splitAt(bufRemaining) : new Tuple2((Object)inBytes$1, (Object)Chunk$.MODULE$.empty());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Chunk cfr_ignored_0 = (Chunk)tuple2._1();
        Chunk cfr_ignored_1 = (Chunk)tuple2._2();
        Tuple2 x$2 = tuple2;
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)bufRemaining), (Object)x$2);
    }

    private static final ZIO decodeChunk$1(Chunk inBytes, Object trace, ByteBuffer byteBuffer$1, java.nio.charset.CharsetDecoder $this$12, CharBuffer charBuffer$1) {
        return byteBuffer$1.remaining(trace).map((Function1 & Serializable & scala.Serializable)bufRemaining -> CharsetDecoder$.$anonfun$transducer$11(inBytes, BoxesRunTime.unboxToInt((Object)bufRemaining)), trace).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2;
            if (x$4 == null || (tuple2 = (Tuple2)x$4._2()) == null) {
                throw new MatchError(x$4);
            }
            Chunk decodeBytes = (Chunk)tuple2._1();
            Chunk remainingBytes = (Chunk)tuple2._2();
            ZIO zIO = byteBuffer$1.putChunk(decodeBytes, trace).flatMap((Function1 & Serializable & scala.Serializable)_2 -> byteBuffer$1.flip(trace).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.decode$extension1($this$12, byteBuffer$1, charBuffer$1, false, trace).flatMap((Function1 & Serializable & scala.Serializable)result -> CharsetDecoder$.handleCoderResult$1(result, trace, byteBuffer$1, charBuffer$1).flatMap((Function1 & Serializable & scala.Serializable)decodedChars -> (remainingBytes.isEmpty() ? ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> Chunk$.MODULE$.empty(), trace) : CharsetDecoder$.decodeChunk$1(remainingBytes, trace, byteBuffer$1, $this$12, charBuffer$1)).map((Function1 & Serializable & scala.Serializable)remainderChars -> decodedChars.$plus$plus(remainderChars), trace), trace), trace), trace), trace);
            return zIO;
        }, trace);
    }

    private static final ZIO endOfInput$2(Object trace, java.nio.charset.CharsetDecoder $this$12, ByteBuffer byteBuffer$1, CharBuffer charBuffer$1) {
        return MODULE$.decode$extension1($this$12, byteBuffer$1, charBuffer$1, true, trace).flatMap((Function1 & Serializable & scala.Serializable)result -> CharsetDecoder$.handleCoderResult$1(result, trace, byteBuffer$1, charBuffer$1).flatMap((Function1 & Serializable & scala.Serializable)decodedChars -> {
            CoderResult coderResult = result;
            CoderResult$Overflow$ coderResult$Overflow$ = CoderResult$Overflow$.MODULE$;
            return (!(coderResult != null ? !coderResult.equals(coderResult$Overflow$) : coderResult$Overflow$ != null) ? CharsetDecoder$.endOfInput$2(trace, $this$12, byteBuffer$1, charBuffer$1) : ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> Chunk$.MODULE$.empty(), trace)).map((Function1 & Serializable & scala.Serializable)remainderChars -> decodedChars.$plus$plus(remainderChars), trace);
        }, trace), trace);
    }

    private static final ZIO flushRemaining$1(Object trace, java.nio.charset.CharsetDecoder $this$12, CharBuffer charBuffer$1, ByteBuffer byteBuffer$1) {
        return MODULE$.flush$extension($this$12, charBuffer$1, trace).flatMap((Function1 & Serializable & scala.Serializable)result -> CharsetDecoder$.handleCoderResult$1(result, trace, byteBuffer$1, charBuffer$1).flatMap((Function1 & Serializable & scala.Serializable)decodedChars -> {
            CoderResult coderResult = result;
            CoderResult$Overflow$ coderResult$Overflow$ = CoderResult$Overflow$.MODULE$;
            return (!(coderResult != null ? !coderResult.equals(coderResult$Overflow$) : coderResult$Overflow$ != null) ? CharsetDecoder$.flushRemaining$1(trace, $this$12, charBuffer$1, byteBuffer$1) : ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> Chunk$.MODULE$.empty(), trace)).map((Function1 & Serializable & scala.Serializable)remainderChars -> decodedChars.$plus$plus(remainderChars), trace);
        }, trace), trace);
    }

    private static final ZIO push$1(Object trace, java.nio.charset.CharsetDecoder $this$12, int bufSize$1) {
        return MODULE$.reset$extension($this$12, trace).flatMap((Function1 & Serializable & scala.Serializable)_ -> Buffer$.MODULE$.byte(bufSize$1, trace).flatMap((Function1 & Serializable & scala.Serializable)byteBuffer -> Buffer$.MODULE$.char(RichFloat$.MODULE$.round$extension(Predef$.MODULE$.floatWrapper((float)bufSize$1 * MODULE$.averageCharsPerByte$extension($this$12))), trace).map((Function1 & Serializable & scala.Serializable)charBuffer -> (Function1 & Serializable & scala.Serializable)x$1 -> (ZIO)x$1.map((Function1 & Serializable & scala.Serializable)inChunk -> CharsetDecoder$.decodeChunk$1(inChunk, trace, byteBuffer, $this$12, charBuffer)).getOrElse((Function0 & Serializable & scala.Serializable)() -> byteBuffer.flip(trace).$times$greater((Function0 & Serializable & scala.Serializable)() -> CharsetDecoder$.endOfInput$2(trace, $this$12, byteBuffer, charBuffer).flatMap((Function1 & Serializable & scala.Serializable)decodedChars -> CharsetDecoder$.flushRemaining$1(trace, $this$12, charBuffer, byteBuffer).map((Function1 & Serializable & scala.Serializable)x$5 -> decodedChars.$plus$plus(x$5), trace), trace), trace).$less$times((Function0 & Serializable & scala.Serializable)() -> byteBuffer.clear(trace), trace).$less$times((Function0 & Serializable & scala.Serializable)() -> charBuffer.clear(trace), trace)), trace), trace), trace);
    }

    private CharsetDecoder$() {
        MODULE$ = this;
    }
}

