/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.file;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Iterator;
import java.util.function.BiPredicate;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.UIO$;
import zio.ZIO;
import zio.ZManaged;
import zio.ZManaged$;
import zio.blocking.Blocking;
import zio.nio.core.file.Path;
import zio.nio.core.file.Path$;
import zio.nio.file.Files;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class Files$ {
    public static Files$ MODULE$;

    static {
        new Files$();
    }

    public <A> ZStream<Blocking, RuntimeException, A> fromJavaIterator(Iterator<A> iterator) {
        return ZStream$.MODULE$.unfoldM((Object)BoxedUnit.UNIT, (Function1 & Serializable & scala.Serializable)x$1 -> zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> {
            if (iterator.hasNext()) {
                return new Some((Object)new Tuple2(iterator.next(), (Object)BoxedUnit.UNIT));
            }
            return None$.MODULE$;
        }).refineToOrDie(ClassTag$.MODULE$.apply(RuntimeException.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail()));
    }

    public ZStream<Blocking, Exception, Path> newDirectoryStream(Path dir, String glob) {
        ZManaged managed = ZManaged$.MODULE$.fromAutoCloseable(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.newDirectoryStream(dir.javaPath(), glob)).refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail()));
        return ZStream$.MODULE$.managed(managed).mapM((Function1 & Serializable & scala.Serializable)dirStream -> UIO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> dirStream.iterator())).flatMap((Function1 & Serializable & scala.Serializable)iterator -> MODULE$.fromJavaIterator((Iterator)iterator)).map((Function1 & Serializable & scala.Serializable)javaPath -> Path$.MODULE$.fromJava(javaPath));
    }

    public ZStream<Blocking, Exception, Path> newDirectoryStream(Path dir, Function1<Path, Object> filter) {
        DirectoryStream.Filter<java.nio.file.Path> javaFilter = javaPath -> BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)Path$.MODULE$.fromJava(javaPath)));
        ZManaged managed = ZManaged$.MODULE$.fromAutoCloseable(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.newDirectoryStream(dir.javaPath(), javaFilter)).refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail()));
        return ZStream$.MODULE$.managed(managed).mapM((Function1 & Serializable & scala.Serializable)dirStream -> UIO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> dirStream.iterator())).flatMap((Function1 & Serializable & scala.Serializable)iterator -> MODULE$.fromJavaIterator((Iterator)iterator)).map((Function1 & Serializable & scala.Serializable)javaPath -> Path$.MODULE$.fromJava(javaPath));
    }

    public String newDirectoryStream$default$2() {
        return "*";
    }

    public ZIO<Blocking, Exception, BoxedUnit> createFile(Path path, Seq<FileAttribute<?>> attrs) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.createFile(path.javaPath(), (FileAttribute[])attrs.toArray(ClassTag$.MODULE$.apply(FileAttribute.class)))).unit().refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Exception, BoxedUnit> createDirectory(Path path, Seq<FileAttribute<?>> attrs) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.createDirectory(path.javaPath(), (FileAttribute[])attrs.toArray(ClassTag$.MODULE$.apply(FileAttribute.class)))).unit().refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Exception, BoxedUnit> createDirectories(Path path, Seq<FileAttribute<?>> attrs) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.createDirectories(path.javaPath(), (FileAttribute[])attrs.toArray(ClassTag$.MODULE$.apply(FileAttribute.class)))).unit().refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Exception, Path> createTempFileIn(Path dir, String suffix, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Path$.MODULE$.fromJava(Files.createTempFile(dir.javaPath(), (String)prefix.orNull(Predef$.MODULE$.$conforms()), suffix, (FileAttribute[])fileAttributes.toSeq().toArray(ClassTag$.MODULE$.apply(FileAttribute.class))))).refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Exception, Path> createTempFile(String suffix, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Path$.MODULE$.fromJava(Files.createTempFile((String)prefix.orNull(Predef$.MODULE$.$conforms()), suffix, (FileAttribute[])fileAttributes.toSeq().toArray(ClassTag$.MODULE$.apply(FileAttribute.class))))).refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public String createTempFileIn$default$2() {
        return ".tmp";
    }

    public String createTempFile$default$1() {
        return ".tmp";
    }

    public ZIO<Blocking, Exception, Path> createTempDirectory(Path dir, Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Path$.MODULE$.fromJava(Files.createTempDirectory(dir.javaPath(), (String)prefix.orNull(Predef$.MODULE$.$conforms()), (FileAttribute[])fileAttributes.toSeq().toArray(ClassTag$.MODULE$.apply(FileAttribute.class))))).refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Exception, Path> createTempDirectory(Option<String> prefix, Iterable<FileAttribute<?>> fileAttributes) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Path$.MODULE$.fromJava(Files.createTempDirectory((String)prefix.orNull(Predef$.MODULE$.$conforms()), (FileAttribute[])fileAttributes.toSeq().toArray(ClassTag$.MODULE$.apply(FileAttribute.class))))).refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Exception, BoxedUnit> createSymbolicLink(Path link, Path target, Seq<FileAttribute<?>> fileAttributes) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.createSymbolicLink(link.javaPath(), target.javaPath(), (FileAttribute[])fileAttributes.toArray(ClassTag$.MODULE$.apply(FileAttribute.class)))).unit().refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Exception, BoxedUnit> createLink(Path link, Path existing) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.createLink(link.javaPath(), existing.javaPath())).unit().refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, IOException, BoxedUnit> delete(Path path) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Files.delete(path.javaPath())).refineToOrDie(ClassTag$.MODULE$.apply(IOException.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, IOException, Object> deleteIfExists(Path path) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.deleteIfExists(path.javaPath())).refineToOrDie(ClassTag$.MODULE$.apply(IOException.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Exception, BoxedUnit> copy(Path source, Path target, Seq<CopyOption> copyOptions) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.copy(source.javaPath(), target.javaPath(), (CopyOption[])copyOptions.toArray(ClassTag$.MODULE$.apply(CopyOption.class)))).unit().refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Exception, BoxedUnit> move(Path source, Path target, Seq<CopyOption> copyOptions) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.move(source.javaPath(), target.javaPath(), (CopyOption[])copyOptions.toArray(ClassTag$.MODULE$.apply(CopyOption.class)))).unit().refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Exception, Path> readSymbolicLink(Path link) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Path$.MODULE$.fromJava(Files.readSymbolicLink(link.javaPath()))).refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, IOException, FileStore> getFileStore(Path path) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.getFileStore(path.javaPath())).refineToOrDie(ClassTag$.MODULE$.apply(IOException.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, IOException, Object> isSameFile(Path path, Path path2) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.isSameFile(path.javaPath(), path2.javaPath())).refineToOrDie(ClassTag$.MODULE$.apply(IOException.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, IOException, Object> isHidden(Path path) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.isHidden(path.javaPath())).refineToOrDie(ClassTag$.MODULE$.apply(IOException.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, IOException, String> probeContentType(Path path) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.probeContentType(path.javaPath())).refineToOrDie(ClassTag$.MODULE$.apply(IOException.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public <A extends FileAttributeView, B> ZIO<Blocking, Exception, B> useFileAttributeView(Path path, Seq<LinkOption> linkOptions, Function1<A, ZIO<Blocking, Exception, B>> f, ClassTag<A> evidence$1) {
        Class viewClass = package$.MODULE$.classTag(evidence$1).runtimeClass();
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.getFileAttributeView(path.javaPath(), viewClass, (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class)))).orDie(Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail()).flatMap(f);
    }

    public <A extends BasicFileAttributes> ZIO<Blocking, Exception, A> readAttributes(Path path, Seq<LinkOption> linkOptions, ClassTag<A> evidence$2) {
        Class attributeClass = package$.MODULE$.classTag(evidence$2).runtimeClass();
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.readAttributes(path.javaPath(), attributeClass, (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class)))).refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Exception, BoxedUnit> setAttribute(Path path, Files.Attribute attribute, Object value, Seq<LinkOption> linkOptions) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.setAttribute(path.javaPath(), attribute.toJava(), value, (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class)))).unit().refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Exception, Object> getAttribute(Path path, Files.Attribute attribute, Seq<LinkOption> linkOptions) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.getAttribute(path.javaPath(), attribute.toJava(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class)))).refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Exception, Map<String, Object>> readAttributes(Path path, Files.Attributes attributes, Seq<LinkOption> linkOptions) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.readAttributes(path.javaPath(), attributes.toJava(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class)))).map((Function1 & Serializable & scala.Serializable)x$2 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$2).asScala()).toMap(Predef$.MODULE$.$conforms())).refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Exception, scala.collection.immutable.Set<PosixFilePermission>> getPosixFilePermissions(Path path, Seq<LinkOption> linkOptions) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.getPosixFilePermissions(path.javaPath(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class)))).map((Function1 & Serializable & scala.Serializable)x$3 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(x$3).asScala()).toSet()).refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Exception, BoxedUnit> setPosixFilePermissions(Path path, scala.collection.immutable.Set<PosixFilePermission> permissions) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.setPosixFilePermissions(path.javaPath(), (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)permissions).asJava())).unit().refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Exception, UserPrincipal> getOwner(Path path, Seq<LinkOption> linkOptions) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.getOwner(path.javaPath(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class)))).refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Exception, BoxedUnit> setOwner(Path path, UserPrincipal owner) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.setOwner(path.javaPath(), owner)).unit().refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Nothing$, Object> isSymbolicLink(Path path) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.isSymbolicLink(path.javaPath())).orDie(Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Nothing$, Object> isDirectory(Path path, Seq<LinkOption> linkOptions) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.isDirectory(path.javaPath(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class)))).orDie(Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Nothing$, Object> isRegularFile(Path path, Seq<LinkOption> linkOptions) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.isRegularFile(path.javaPath(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class)))).orDie(Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, IOException, FileTime> getLastModifiedTime(Path path, Seq<LinkOption> linkOptions) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.getLastModifiedTime(path.javaPath(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class)))).refineToOrDie(ClassTag$.MODULE$.apply(IOException.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, IOException, BoxedUnit> setLastModifiedTime(Path path, FileTime time) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.setLastModifiedTime(path.javaPath(), time)).unit().refineToOrDie(ClassTag$.MODULE$.apply(IOException.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, IOException, Object> size(Path path) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Files.size(path.javaPath())).refineToOrDie(ClassTag$.MODULE$.apply(IOException.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Nothing$, Object> exists(Path path, Seq<LinkOption> linkOptions) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.exists(path.javaPath(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class)))).orDie(Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Nothing$, Object> notExists(Path path, Seq<LinkOption> linkOptions) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.notExists(path.javaPath(), (LinkOption[])linkOptions.toArray(ClassTag$.MODULE$.apply(LinkOption.class)))).orDie(Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Nothing$, Object> isReadable(Path path) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.isReadable(path.javaPath())).orDie(Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Nothing$, Object> isWritable(Path path) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.isWritable(path.javaPath())).orDie(Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Nothing$, Object> isExecutable(Path path) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.isExecutable(path.javaPath())).orDie(Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, IOException, Chunk<Object>> readAllBytes(Path path) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Chunk$.MODULE$.fromArray((Object)Files.readAllBytes(path.javaPath()))).refineToOrDie(ClassTag$.MODULE$.apply(IOException.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, IOException, List<String>> readAllLines(Path path, Charset charset) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(path.javaPath(), charset)).asScala()).toList()).refineToOrDie(ClassTag$.MODULE$.apply(IOException.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public Charset readAllLines$default$2() {
        return StandardCharsets.UTF_8;
    }

    public ZIO<Blocking, Exception, BoxedUnit> writeBytes(Path path, Chunk<Object> bytes, Seq<OpenOption> openOptions) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.write(path.javaPath(), (byte[])bytes.toArray(ClassTag$.MODULE$.Byte()), (OpenOption[])openOptions.toArray(ClassTag$.MODULE$.apply(OpenOption.class)))).unit().refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public ZIO<Blocking, Exception, BoxedUnit> writeLines(Path path, Iterable<CharSequence> lines, Charset charset, scala.collection.immutable.Set<OpenOption> openOptions) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.write(path.javaPath(), (java.lang.Iterable<? extends CharSequence>)((java.lang.Iterable)CollectionConverters$.MODULE$.asJavaIterableConverter(lines).asJava()), charset, (OpenOption[])openOptions.toSeq().toArray(ClassTag$.MODULE$.apply(OpenOption.class)))).unit().refineToOrDie(ClassTag$.MODULE$.apply(Exception.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail());
    }

    public Charset writeLines$default$3() {
        return StandardCharsets.UTF_8;
    }

    public scala.collection.immutable.Set<OpenOption> writeLines$default$4() {
        return Predef$.MODULE$.Set().empty();
    }

    public ZStream<Blocking, Exception, Path> list(Path path) {
        return ZStream$.MODULE$.fromEffect(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.list(path.javaPath()).iterator()).refineToOrDie(ClassTag$.MODULE$.apply(IOException.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail())).flatMap((Function1 & Serializable & scala.Serializable)iterator -> MODULE$.fromJavaIterator((Iterator)iterator)).map((Function1 & Serializable & scala.Serializable)javaPath -> Path$.MODULE$.fromJava(javaPath));
    }

    public ZStream<Blocking, Exception, Path> walk(Path path, int maxDepth, scala.collection.immutable.Set<FileVisitOption> visitOptions) {
        return ZStream$.MODULE$.fromEffect(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.walk(path.javaPath(), maxDepth, (FileVisitOption[])visitOptions.toSeq().toArray(ClassTag$.MODULE$.apply(FileVisitOption.class))).iterator()).refineToOrDie(ClassTag$.MODULE$.apply(IOException.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail())).flatMap((Function1 & Serializable & scala.Serializable)iterator -> MODULE$.fromJavaIterator((Iterator)iterator)).map((Function1 & Serializable & scala.Serializable)javaPath -> Path$.MODULE$.fromJava(javaPath));
    }

    public int walk$default$2() {
        return Integer.MAX_VALUE;
    }

    public scala.collection.immutable.Set<FileVisitOption> walk$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    public ZStream<Blocking, Exception, Path> find(Path path2, int maxDepth, scala.collection.immutable.Set<FileVisitOption> visitOptions, Function2<Path, BasicFileAttributes, Object> test) {
        BiPredicate<java.nio.file.Path, BasicFileAttributes> matcher = (path, attr) -> BoxesRunTime.unboxToBoolean((Object)test.apply((Object)Path$.MODULE$.fromJava(path), attr));
        return ZStream$.MODULE$.fromEffect(zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> Files.find(path2.javaPath(), maxDepth, matcher, (FileVisitOption[])visitOptions.toSeq().toArray(ClassTag$.MODULE$.apply(FileVisitOption.class))).iterator()).refineToOrDie(ClassTag$.MODULE$.apply(IOException.class), Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail())).flatMap((Function1 & Serializable & scala.Serializable)iterator -> MODULE$.fromJavaIterator((Iterator)iterator)).map((Function1 & Serializable & scala.Serializable)javaPath -> Path$.MODULE$.fromJava(javaPath));
    }

    public int find$default$2() {
        return Integer.MAX_VALUE;
    }

    public scala.collection.immutable.Set<FileVisitOption> find$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    private Files$() {
        MODULE$ = this;
    }
}

