/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.core.file;

import dotty.runtime.Arrays$;
import dotty.runtime.function.JFunction1;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.LinkOption;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.util.Not$;
import zio.CanFail$;
import zio.Has;
import zio.Has$;
import zio.ZIO;
import zio.ZIO$;
import zio.blocking.package;
import zio.nio.core.file.FileSystem;
import zio.nio.core.file.FileSystem$;
import zio.nio.core.file.Path$;
import zio.nio.core.file.Watchable;

public final class Path
implements Watchable {
    private final java.nio.file.Path javaPath;

    public static Path fromJava(java.nio.file.Path path) {
        return Path$.MODULE$.fromJava(path);
    }

    public Path(java.nio.file.Path javaPath) {
        this.javaPath = javaPath;
    }

    public java.nio.file.Path javaPath() {
        return this.javaPath;
    }

    public FileSystem filesystem() {
        return FileSystem$.MODULE$.fromJava(this.javaPath().getFileSystem());
    }

    public boolean isAbsolute() {
        return this.javaPath().isAbsolute();
    }

    public Option<Path> root() {
        return Option$.MODULE$.apply((Object)this.javaPath().getRoot()).map((Function1)(JFunction1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath));
    }

    public Path filename() {
        return new Path(this.javaPath().getFileName());
    }

    public Option<Path> parent() {
        return Option$.MODULE$.apply((Object)this.javaPath().getParent()).map((Function1)(JFunction1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath));
    }

    public int nameCount() {
        return this.javaPath().getNameCount();
    }

    public Path apply(int index) {
        return Path$.MODULE$.fromJava(this.javaPath().getName(index));
    }

    public Path subpath(int beginIndex, int endIndex) {
        return Path$.MODULE$.fromJava(this.javaPath().subpath(beginIndex, endIndex));
    }

    public boolean startsWith(Path other) {
        return this.javaPath().startsWith(other.javaPath());
    }

    public boolean endsWith(Path other) {
        return this.javaPath().endsWith(other.javaPath());
    }

    public Path normalize() {
        return Path$.MODULE$.fromJava(this.javaPath().normalize());
    }

    public Path $div(Path other) {
        return Path$.MODULE$.fromJava(this.javaPath().resolve(other.javaPath()));
    }

    public Path $div(String other) {
        return Path$.MODULE$.fromJava(this.javaPath().resolve(other));
    }

    public Path resolveSibling(Path other) {
        return Path$.MODULE$.fromJava(this.javaPath().resolveSibling(other.javaPath()));
    }

    public Path relativize(Path other) {
        return Path$.MODULE$.fromJava(this.javaPath().relativize(other.javaPath()));
    }

    public ZIO<Has<package.Blocking.Service>, IOError, URI> toUri() {
        boolean bl = ZIO$.MODULE$.accessM();
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO.AccessMPartiallyApplied$.MODULE$.apply$extension(bl, (Function1)(JFunction1 & Serializable)_$1 -> {
            Has has = Has$.MODULE$.HasSyntax(_$1);
            return ((package.Blocking.Service)Has.HasSyntax$.MODULE$.get$extension(has, (.less.colon.less)$less$colon$less$.MODULE$.refl(), Tag$.MODULE$.apply(Object.class, LightTypeTag$.MODULE$.parse(1217729533, "\u0004\u0000\u0001'zio.blocking.package$.Blocking$.Service\u0001\u0002\u0003\u0000\u0001\u001fzio.blocking.package$.Blocking$\u0001\u0002\u0003\u0000\u0001\u0015zio.blocking.package$\u0001\u0001", "\u0000\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0004\u0000\u0001\tscala.Any\u0001\u0001\u0004\u0000\u0001\u0010java.lang.Object\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001'zio.blocking.package$.Blocking$.Service\u0001\u0002\u0003\u0000\u0001\u001fzio.blocking.package$.Blocking$\u0001\u0002\u0003\u0000\u0001\u0015zio.blocking.package$\u0001\u0001\u0002\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0003\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0001\u0090\u0006\u0001\u0002\u0003\u0000\u0001\u0090\u0007\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 1)))).effectBlocking(this::toUri$$anonfun$2$$anonfun$1);
        }));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOError.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOError, Path> toAbsolutePath() {
        boolean bl = ZIO$.MODULE$.accessM();
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO.AccessMPartiallyApplied$.MODULE$.apply$extension(bl, (Function1)(JFunction1 & Serializable)_$2 -> {
            Has has = Has$.MODULE$.HasSyntax(_$2);
            return ((package.Blocking.Service)Has.HasSyntax$.MODULE$.get$extension(has, (.less.colon.less)$less$colon$less$.MODULE$.refl(), Tag$.MODULE$.apply(Object.class, LightTypeTag$.MODULE$.parse(1217729533, "\u0004\u0000\u0001'zio.blocking.package$.Blocking$.Service\u0001\u0002\u0003\u0000\u0001\u001fzio.blocking.package$.Blocking$\u0001\u0002\u0003\u0000\u0001\u0015zio.blocking.package$\u0001\u0001", "\u0000\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0004\u0000\u0001\tscala.Any\u0001\u0001\u0004\u0000\u0001\u0010java.lang.Object\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001'zio.blocking.package$.Blocking$.Service\u0001\u0002\u0003\u0000\u0001\u001fzio.blocking.package$.Blocking$\u0001\u0002\u0003\u0000\u0001\u0015zio.blocking.package$\u0001\u0001\u0002\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0003\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0001\u0090\u0006\u0001\u0002\u0003\u0000\u0001\u0090\u0007\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 1)))).effectBlocking(this::toAbsolutePath$$anonfun$2$$anonfun$1);
        }));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOError.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Path> toRealPath(Seq<LinkOption> linkOptions) {
        boolean bl = ZIO$.MODULE$.accessM();
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO.AccessMPartiallyApplied$.MODULE$.apply$extension(bl, (Function1)(JFunction1 & Serializable)_$3 -> {
            Has has = Has$.MODULE$.HasSyntax(_$3);
            return ((package.Blocking.Service)Has.HasSyntax$.MODULE$.get$extension(has, (.less.colon.less)$less$colon$less$.MODULE$.refl(), Tag$.MODULE$.apply(Object.class, LightTypeTag$.MODULE$.parse(1217729533, "\u0004\u0000\u0001'zio.blocking.package$.Blocking$.Service\u0001\u0002\u0003\u0000\u0001\u001fzio.blocking.package$.Blocking$\u0001\u0002\u0003\u0000\u0001\u0015zio.blocking.package$\u0001\u0001", "\u0000\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0004\u0000\u0001\tscala.Any\u0001\u0001\u0004\u0000\u0001\u0010java.lang.Object\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001'zio.blocking.package$.Blocking$.Service\u0001\u0002\u0003\u0000\u0001\u001fzio.blocking.package$.Blocking$\u0001\u0002\u0003\u0000\u0001\u0015zio.blocking.package$\u0001\u0001\u0002\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0003\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0001\u0090\u0006\u0001\u0002\u0003\u0000\u0001\u0090\u0007\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 1)))).effectBlocking(() -> this.toRealPath$$anonfun$2$$anonfun$1(linkOptions));
        }));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value()));
    }

    public File toFile() {
        return this.javaPath().toFile();
    }

    public List<Path> elements() {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.javaPath().iterator()).asScala().map((Function1)(JFunction1 & Serializable)javaPath -> Path$.MODULE$.fromJava((java.nio.file.Path)javaPath)).toList();
    }

    @Override
    public java.nio.file.Watchable javaWatchable() {
        return this.javaPath();
    }

    public int hashCode() {
        return this.javaPath().hashCode();
    }

    public boolean equals(Object obj) {
        boolean bl;
        Object object = obj;
        if (object instanceof Path) {
            Path other = (Path)object;
            bl = this.javaPath().equals(other.javaPath());
        } else {
            bl = false;
        }
        return bl;
    }

    public String toString() {
        return this.javaPath().toString();
    }

    private final URI toUri$$anonfun$2$$anonfun$1() {
        return this.javaPath().toUri();
    }

    private final Path toAbsolutePath$$anonfun$2$$anonfun$1() {
        return Path$.MODULE$.fromJava(this.javaPath().toAbsolutePath());
    }

    private final Path toRealPath$$anonfun$2$$anonfun$1(Seq linkOptions$2) {
        return Path$.MODULE$.fromJava(this.javaPath().toRealPath((LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions$2, LinkOption.class)));
    }
}

