/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.core.charset;

import dotty.runtime.function.JFunction1;
import java.io.Serializable;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Locale;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.math.Ordered;
import scala.runtime.Nothing$;
import zio.Chunk;
import zio.UIO$;
import zio.ZIO;
import zio.nio.core.Buffer$;
import zio.nio.core.ByteBuffer;
import zio.nio.core.CharBuffer;
import zio.nio.core.charset.Charset$;
import zio.nio.core.charset.CharsetDecoder$;
import zio.nio.core.charset.CharsetEncoder$;

public final class Charset
implements Ordered<Charset> {
    private final java.nio.charset.Charset javaCharset;

    public static Map availableCharsets() {
        return Charset$.MODULE$.availableCharsets();
    }

    public static Charset defaultCharset() {
        return Charset$.MODULE$.defaultCharset();
    }

    public static Charset forName(String string) {
        return Charset$.MODULE$.forName(string);
    }

    public static Option<Charset> forNameIfSupported(String string) {
        return Charset$.MODULE$.forNameIfSupported(string);
    }

    public static Charset fromJava(java.nio.charset.Charset charset) {
        return Charset$.MODULE$.fromJava(charset);
    }

    public static boolean isLegalAndSupported(String string) {
        return Charset$.MODULE$.isLegalAndSupported(string);
    }

    public static boolean isSupported(String string) {
        return Charset$.MODULE$.isSupported(string);
    }

    public Charset(java.nio.charset.Charset javaCharset) {
        this.javaCharset = javaCharset;
        Ordered.$init$((Ordered)this);
    }

    public java.nio.charset.Charset javaCharset() {
        return this.javaCharset;
    }

    public Set<String> aliases() {
        return ((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(this.javaCharset().aliases()).asScala()).toSet();
    }

    public boolean canEncode() {
        return this.javaCharset().canEncode();
    }

    public int compare(Charset that) {
        return this.javaCharset().compareTo(that.javaCharset());
    }

    public boolean contains(Charset cs) {
        return this.javaCharset().contains(cs.javaCharset());
    }

    public ZIO decode(ByteBuffer byteBuffer) {
        return byteBuffer.withJavaBuffer((JFunction1 & Serializable)jBuf -> UIO$.MODULE$.effectTotal(() -> this.decode$$anonfun$2$$anonfun$1(jBuf)));
    }

    public String displayName() {
        return this.javaCharset().displayName();
    }

    public String displayName(Locale locale) {
        return this.javaCharset().displayName(locale);
    }

    public ZIO encode(CharBuffer charBuffer) {
        return charBuffer.withJavaBuffer((JFunction1 & Serializable)jBuf -> UIO$.MODULE$.effectTotal(() -> this.encode$$anonfun$2$$anonfun$1(jBuf)));
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof Charset) {
            Charset cs = (Charset)object;
            bl = this.javaCharset().equals(cs.javaCharset());
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.javaCharset().hashCode();
    }

    public boolean isRegistered() {
        return this.javaCharset().isRegistered();
    }

    public String name() {
        return this.javaCharset().name();
    }

    public CharsetDecoder newDecoder() {
        return CharsetDecoder$.MODULE$.fromJava(this.javaCharset().newDecoder());
    }

    public CharsetEncoder newEncoder() {
        return CharsetEncoder$.MODULE$.fromJava(this.javaCharset().newEncoder());
    }

    public String toString() {
        return this.javaCharset().toString();
    }

    public ZIO<Object, Nothing$, Chunk<Object>> encodeChunk(Chunk<Object> chunk) {
        return Buffer$.MODULE$.char(chunk).flatMap((Function1)(JFunction1 & Serializable)charBuf -> this.encode((CharBuffer)charBuf).flatMap((Function1)(JFunction1 & Serializable)byteBuf -> byteBuf.getChunk(byteBuf.getChunk$default$1()).map((Function1)(JFunction1 & Serializable)chunk -> chunk)));
    }

    public ZIO<Object, Nothing$, Chunk<Object>> encodeString(CharSequence s) {
        return Buffer$.MODULE$.char(s).flatMap((Function1)(JFunction1 & Serializable)charBuf -> this.encode((CharBuffer)charBuf).flatMap((Function1)(JFunction1 & Serializable)byteBuf -> byteBuf.getChunk(byteBuf.getChunk$default$1()).map((Function1)(JFunction1 & Serializable)chunk -> chunk)));
    }

    public ZIO<Object, Nothing$, Chunk<Object>> decodeChunk(Chunk<Object> chunk) {
        return Buffer$.MODULE$.byte(chunk).flatMap((Function1)(JFunction1 & Serializable)byteBuf -> this.decode((ByteBuffer)byteBuf).flatMap((Function1)(JFunction1 & Serializable)charBuf -> charBuf.getChunk(charBuf.getChunk$default$1()).map((Function1)(JFunction1 & Serializable)chunk -> chunk)));
    }

    public ZIO<Object, Nothing$, String> decodeString(Chunk<Object> chunk) {
        return Buffer$.MODULE$.byte(chunk).flatMap((Function1)(JFunction1 & Serializable)byteBuf -> this.decode((ByteBuffer)byteBuf).flatMap((Function1)(JFunction1 & Serializable)charBuf -> charBuf.getString().map((Function1)(JFunction1 & Serializable)s -> s)));
    }

    private final CharBuffer decode$$anonfun$2$$anonfun$1(java.nio.ByteBuffer jBuf$1) {
        return Buffer$.MODULE$.charFromJava(this.javaCharset().decode(jBuf$1));
    }

    private final ByteBuffer encode$$anonfun$2$$anonfun$1(java.nio.CharBuffer jBuf$2) {
        return Buffer$.MODULE$.byteFromJava(this.javaCharset().encode(jBuf$2));
    }
}

