/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.core.channels;

import dotty.runtime.function.JFunction0;
import dotty.runtime.function.JFunction1;
import java.io.Serializable;
import java.nio.channels.Pipe;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import zio.IO$;
import zio.ZIO;
import zio.ZIO$;
import zio.nio.core.channels.Channel;
import zio.nio.core.channels.DatagramChannel;
import zio.nio.core.channels.Pipe;
import zio.nio.core.channels.SelectableChannel;
import zio.nio.core.channels.SelectionKey$Operation$;
import zio.nio.core.channels.Selector;
import zio.nio.core.channels.ServerSocketChannel;
import zio.nio.core.channels.SocketChannel;

public final class SelectionKey {
    private final java.nio.channels.SelectionKey selectionKey;

    public SelectionKey(java.nio.channels.SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
    }

    public java.nio.channels.SelectionKey selectionKey() {
        return this.selectionKey;
    }

    public SelectableChannel channel() {
        Channel channel;
        java.nio.channels.SelectableChannel selectableChannel = this.selectionKey().channel();
        if (selectableChannel instanceof java.nio.channels.SocketChannel) {
            java.nio.channels.SocketChannel c = (java.nio.channels.SocketChannel)selectableChannel;
            channel = new SocketChannel(c);
        } else if (selectableChannel instanceof java.nio.channels.ServerSocketChannel) {
            java.nio.channels.ServerSocketChannel c = (java.nio.channels.ServerSocketChannel)selectableChannel;
            channel = new ServerSocketChannel(c);
        } else if (selectableChannel instanceof java.nio.channels.DatagramChannel) {
            java.nio.channels.DatagramChannel c = (java.nio.channels.DatagramChannel)selectableChannel;
            channel = new DatagramChannel(c);
        } else if (selectableChannel instanceof Pipe.SinkChannel) {
            Pipe.SinkChannel c = (Pipe.SinkChannel)selectableChannel;
            channel = new Pipe.SinkChannel(c);
        } else if (selectableChannel instanceof Pipe.SourceChannel) {
            Pipe.SourceChannel c = (Pipe.SourceChannel)selectableChannel;
            channel = new Pipe.SourceChannel(c);
        } else {
            java.nio.channels.SelectableChannel other = selectableChannel;
            channel = new Channel(other){
                private ZIO provider;
                private ZIO validOps;
                private ZIO isRegistered;
                private ZIO isBlocking;
                private ZIO blockingLock;
                private final java.nio.channels.SelectableChannel channel;
                {
                    SelectableChannel.$init$(this);
                    this.channel = other$1;
                }

                public final ZIO provider() {
                    return this.provider;
                }

                public final ZIO validOps() {
                    return this.validOps;
                }

                public final ZIO isRegistered() {
                    return this.isRegistered;
                }

                public final ZIO isBlocking() {
                    return this.isBlocking;
                }

                public final ZIO blockingLock() {
                    return this.blockingLock;
                }

                public void zio$nio$core$channels$SelectableChannel$_setter_$provider_$eq(ZIO x$0) {
                    this.provider = x$0;
                }

                public void zio$nio$core$channels$SelectableChannel$_setter_$validOps_$eq(ZIO x$0) {
                    this.validOps = x$0;
                }

                public void zio$nio$core$channels$SelectableChannel$_setter_$isRegistered_$eq(ZIO x$0) {
                    this.isRegistered = x$0;
                }

                public void zio$nio$core$channels$SelectableChannel$_setter_$isBlocking_$eq(ZIO x$0) {
                    this.isBlocking = x$0;
                }

                public void zio$nio$core$channels$SelectableChannel$_setter_$blockingLock_$eq(ZIO x$0) {
                    this.blockingLock = x$0;
                }

                public java.nio.channels.SelectableChannel channel() {
                    return this.channel;
                }
            };
        }
        return channel;
    }

    public <R, E, A> ZIO<R, E, A> matchChannel(Function1<Set<Operation>, PartialFunction<SelectableChannel, ZIO<R, E, A>>> matcher) {
        return this.readyOps().flatMap((Function1)(JFunction1 & Serializable)_$1 -> (ZIO)((PartialFunction)matcher.apply(_$1)).applyOrElse((Object)this.channel(), (Function1)(JFunction1 & Serializable)channel -> ZIO$.MODULE$.dieMessage(() -> SelectionKey.matchChannel$$anonfun$2$$anonfun$1$$anonfun$1(channel))));
    }

    public final Selector selector() {
        return new Selector(this.selectionKey().selector());
    }

    public final ZIO isValid() {
        return IO$.MODULE$.effectTotal((Function0)((JFunction0.mcZ.sp & Serializable)this::isValid$$anonfun$1));
    }

    public final ZIO cancel() {
        return IO$.MODULE$.effectTotal((Function0)((JFunction0.mcV.sp & Serializable)this::cancel$$anonfun$1));
    }

    public final ZIO<Object, Nothing$, Set<Operation>> interestOps() {
        return IO$.MODULE$.effectTotal(this::interestOps$$anonfun$1);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> interestOps(Set<Operation> ops) {
        return IO$.MODULE$.effectTotal(() -> this.interestOps$$anonfun$2(ops)).unit();
    }

    public ZIO<Object, Nothing$, Set<Operation>> interested(Operation op) {
        return this.interestOps().map((Function1)(JFunction1 & Serializable)current -> {
            Set newInterest = (Set)current.$plus((Object)op);
            return Tuple2$.MODULE$.apply(current, (Object)newInterest);
        }).flatMap((Function1)(JFunction1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Set current = (Set)tuple2._1();
            Set newInterest = (Set)tuple2._2();
            return this.interestOps((Set<Operation>)newInterest).map((Function1)(JFunction1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
                return newInterest;
            });
        });
    }

    public ZIO<Object, Nothing$, Set<Operation>> notInterested(Operation op) {
        return this.interestOps().map((Function1)(JFunction1 & Serializable)current -> {
            Set newInterest = (Set)current.$minus((Object)op);
            return Tuple2$.MODULE$.apply(current, (Object)newInterest);
        }).flatMap((Function1)(JFunction1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Set current = (Set)tuple2._1();
            Set newInterest = (Set)tuple2._2();
            return this.interestOps((Set<Operation>)newInterest).map((Function1)(JFunction1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
                return newInterest;
            });
        });
    }

    public final ZIO<Object, Nothing$, Set<Operation>> readyOps() {
        return IO$.MODULE$.effectTotal(this::readyOps$$anonfun$1);
    }

    public final ZIO isReadable() {
        return IO$.MODULE$.effectTotal((Function0)((JFunction0.mcZ.sp & Serializable)this::isReadable$$anonfun$1));
    }

    public final ZIO isWritable() {
        return IO$.MODULE$.effectTotal((Function0)((JFunction0.mcZ.sp & Serializable)this::isWritable$$anonfun$1));
    }

    public final ZIO isConnectable() {
        return IO$.MODULE$.effectTotal((Function0)((JFunction0.mcZ.sp & Serializable)this::isConnectable$$anonfun$1));
    }

    public final ZIO isAcceptable() {
        return IO$.MODULE$.effectTotal((Function0)((JFunction0.mcZ.sp & Serializable)this::isAcceptable$$anonfun$1));
    }

    public final ZIO<Object, Nothing$, Option<Object>> attach(Option<Object> ob) {
        return IO$.MODULE$.effectTotal(() -> this.attach$$anonfun$1(ob));
    }

    public final ZIO<Object, Nothing$, Option<Object>> attachment() {
        return IO$.MODULE$.effectTotal(this::attachment$$anonfun$1).map((Function1 & Serializable)_$2 -> Option$.MODULE$.apply(_$2));
    }

    public String toString() {
        return this.selectionKey().toString();
    }

    private static final String matchChannel$$anonfun$2$$anonfun$1$$anonfun$1(SelectableChannel channel$1) {
        return "Unexpected channel type: " + channel$1;
    }

    private final boolean isValid$$anonfun$1() {
        return this.selectionKey().isValid();
    }

    private final void cancel$$anonfun$1() {
        this.selectionKey().cancel();
    }

    private final Set interestOps$$anonfun$1() {
        return SelectionKey$Operation$.MODULE$.fromInt(this.selectionKey().interestOps());
    }

    private final java.nio.channels.SelectionKey interestOps$$anonfun$2(Set ops$1) {
        return this.selectionKey().interestOps(SelectionKey$Operation$.MODULE$.toInt((Set<Operation>)ops$1));
    }

    private final Set readyOps$$anonfun$1() {
        return SelectionKey$Operation$.MODULE$.fromInt(this.selectionKey().readyOps());
    }

    private final boolean isReadable$$anonfun$1() {
        return this.selectionKey().isReadable();
    }

    private final boolean isWritable$$anonfun$1() {
        return this.selectionKey().isWritable();
    }

    private final boolean isConnectable$$anonfun$1() {
        return this.selectionKey().isConnectable();
    }

    private final boolean isAcceptable$$anonfun$1() {
        return this.selectionKey().isAcceptable();
    }

    private final Option attach$$anonfun$1(Option ob$1) {
        return Option$.MODULE$.apply(this.selectionKey().attach(ob$1.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    private final Object attachment$$anonfun$1() {
        return this.selectionKey().attachment();
    }

    public static abstract class Operation {
        private final int intVal;

        public static Set<Operation> fromInt(int n) {
            return SelectionKey$Operation$.MODULE$.fromInt(n);
        }

        public static Set fullSet() {
            return SelectionKey$Operation$.MODULE$.fullSet();
        }

        public static int ordinal(Operation operation) {
            return SelectionKey$Operation$.MODULE$.ordinal(operation);
        }

        public static int toInt(Set<Operation> set) {
            return SelectionKey$Operation$.MODULE$.toInt(set);
        }

        public Operation(int intVal) {
            this.intVal = intVal;
        }

        public int intVal() {
            return this.intVal;
        }
    }
}

