/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.core.channels;

import dotty.runtime.function.JFunction0;
import dotty.runtime.function.JFunction1;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.Not$;
import zio.CanFail$;
import zio.Has;
import zio.Has$;
import zio.IO$;
import zio.ZIO;
import zio.ZIO$;
import zio.blocking.package;
import zio.blocking.package$;
import zio.nio.core.ByteBuffer;
import zio.nio.core.MappedByteBuffer;
import zio.nio.core.channels.Channel;
import zio.nio.core.channels.FileChannel$;
import zio.nio.core.channels.FileLock;
import zio.nio.core.channels.GatheringByteChannel;
import zio.nio.core.channels.ScatteringByteChannel;
import zio.nio.core.file.Path;

public final class FileChannel
implements Channel,
GatheringByteChannel,
ScatteringByteChannel {
    private final java.nio.channels.FileChannel channel;

    public static FileChannel fromJava(java.nio.channels.FileChannel fileChannel) {
        return FileChannel$.MODULE$.fromJava(fileChannel);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, FileChannel> open(Path path, Seq<OpenOption> seq) {
        return FileChannel$.MODULE$.open(path, seq);
    }

    public static ZIO<Has<package.Blocking.Service>, IOException, FileChannel> open(Path path, Set<? extends OpenOption> set, Seq<FileAttribute<?>> seq) {
        return FileChannel$.MODULE$.open(path, set, seq);
    }

    public FileChannel(java.nio.channels.FileChannel channel) {
        this.channel = channel;
    }

    @Override
    public java.nio.channels.FileChannel channel() {
        return this.channel;
    }

    public ZIO position() {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect((Function0)((JFunction0.mcJ.sp & Serializable)this::position$$anonfun$1)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value()));
    }

    public ZIO position(long newPosition) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.position$$anonfun$2(newPosition)).unit());
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value()));
    }

    public ZIO size() {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect((Function0)((JFunction0.mcJ.sp & Serializable)this::size$$anonfun$1)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> truncate(long size) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(package$.MODULE$.effectBlocking(() -> this.truncate$$anonfun$1(size)).unit());
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, BoxedUnit> force(boolean metadata) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(package$.MODULE$.effectBlocking((Function0)((JFunction0.mcV.sp & Serializable)() -> this.force$$anonfun$1(metadata))));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Object> transferTo(long position, long count, GatheringByteChannel target) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(package$.MODULE$.effectBlocking((Function0)((JFunction0.mcJ.sp & Serializable)() -> this.transferTo$$anonfun$1(position, count, target))));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Object> transferFrom(ScatteringByteChannel src, long position, long count) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(package$.MODULE$.effectBlocking((Function0)((JFunction0.mcJ.sp & Serializable)() -> this.transferFrom$$anonfun$1(src, position, count))));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Object> read(ByteBuffer dst, long position) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(dst.withJavaBuffer((JFunction1 & Serializable)buffer -> package$.MODULE$.effectBlocking((Function0)((JFunction0.mcI.sp & Serializable)() -> this.read$$anonfun$2$$anonfun$1(position, buffer)))));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, Object> write(ByteBuffer src, long position) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(src.withJavaBuffer((JFunction1 & Serializable)buffer -> package$.MODULE$.effectBlocking((Function0)((JFunction0.mcI.sp & Serializable)() -> this.write$$anonfun$2$$anonfun$1(position, buffer)))));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, MappedByteBuffer> map(FileChannel.MapMode mode, long position, long size) {
        boolean bl = ZIO$.MODULE$.accessM();
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO.AccessMPartiallyApplied$.MODULE$.apply$extension(bl, (Function1)(JFunction1 & Serializable)_$1 -> {
            Has has = Has$.MODULE$.HasSyntax(_$1);
            return ((package.Blocking.Service)Has.HasSyntax$.MODULE$.get$extension(has, (.less.colon.less)$less$colon$less$.MODULE$.refl(), Tag$.MODULE$.apply(Object.class, LightTypeTag$.MODULE$.parse(1217729533, "\u0004\u0000\u0001'zio.blocking.package$.Blocking$.Service\u0001\u0002\u0003\u0000\u0001\u001fzio.blocking.package$.Blocking$\u0001\u0002\u0003\u0000\u0001\u0015zio.blocking.package$\u0001\u0001", "\u0000\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0004\u0000\u0001\tscala.Any\u0001\u0001\u0004\u0000\u0001\u0010java.lang.Object\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001'zio.blocking.package$.Blocking$.Service\u0001\u0002\u0003\u0000\u0001\u001fzio.blocking.package$.Blocking$\u0001\u0002\u0003\u0000\u0001\u0015zio.blocking.package$\u0001\u0001\u0002\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0003\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0001\u0090\u0006\u0001\u0002\u0003\u0000\u0001\u0090\u0007\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 1)))).effectBlocking(() -> this.map$$anonfun$2$$anonfun$1(mode, position, size));
        }));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value()));
    }

    public ZIO<Has<package.Blocking.Service>, IOException, FileLock> lock(long position, long size, boolean shared) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(package$.MODULE$.effectBlocking(() -> this.lock$$anonfun$1(position, size, shared)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value()));
    }

    public long lock$default$1() {
        return 0L;
    }

    public long lock$default$2() {
        return Long.MAX_VALUE;
    }

    public boolean lock$default$3() {
        return false;
    }

    public ZIO<Object, IOException, Option<FileLock>> tryLock(long position, long size, boolean shared) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.effect(() -> this.tryLock$$anonfun$1(position, size, shared)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value()));
    }

    public long tryLock$default$1() {
        return 0L;
    }

    public long tryLock$default$2() {
        return Long.MAX_VALUE;
    }

    public boolean tryLock$default$3() {
        return false;
    }

    private final long position$$anonfun$1() {
        return this.channel().position();
    }

    private final java.nio.channels.FileChannel position$$anonfun$2(long newPosition$1) {
        return this.channel().position(newPosition$1);
    }

    private final long size$$anonfun$1() {
        return this.channel().size();
    }

    private final java.nio.channels.FileChannel truncate$$anonfun$1(long size$1) {
        return this.channel().truncate(size$1);
    }

    private final void force$$anonfun$1(boolean metadata$1) {
        this.channel().force(metadata$1);
    }

    private final long transferTo$$anonfun$1(long position$1, long count$1, GatheringByteChannel target$1) {
        return this.channel().transferTo(position$1, count$1, target$1.channel());
    }

    private final long transferFrom$$anonfun$1(ScatteringByteChannel src$1, long position$2, long count$2) {
        return this.channel().transferFrom(src$1.channel(), position$2, count$2);
    }

    private final int read$$anonfun$2$$anonfun$1(long position$3, java.nio.ByteBuffer buffer$1) {
        return this.channel().read(buffer$1, position$3);
    }

    private final int write$$anonfun$2$$anonfun$1(long position$5, java.nio.ByteBuffer buffer$2) {
        return this.channel().write(buffer$2, position$5);
    }

    private final MappedByteBuffer map$$anonfun$2$$anonfun$1(FileChannel.MapMode mode$2, long position$8, long size$3) {
        return new MappedByteBuffer(this.channel().map(mode$2, position$8, size$3));
    }

    private final FileLock lock$$anonfun$1(long position$9, long size$4, boolean shared$1) {
        return new FileLock(this.channel().lock(position$9, size$4, shared$1));
    }

    private final Option tryLock$$anonfun$1(long position$10, long size$5, boolean shared$2) {
        return Option$.MODULE$.apply((Object)this.channel().tryLock(position$10, size$5, shared$2)).map((Function1)(JFunction1 & Serializable)_$2 -> new FileLock((java.nio.channels.FileLock)_$2));
    }
}

