/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.core.channels;

import dotty.runtime.function.JFunction0;
import dotty.runtime.function.JFunction1;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketOption;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Not$;
import zio.CanFail$;
import zio.Chunk;
import zio.IO$;
import zio.ZIO;
import zio.ZIO$;
import zio.duration.package;
import zio.interop.javaz$;
import zio.nio.core.Buffer$;
import zio.nio.core.ByteBuffer;
import zio.nio.core.SocketAddress;
import zio.nio.core.SocketAddress$;
import zio.nio.core.channels.AsynchronousByteChannel;
import zio.nio.core.channels.AsynchronousChannelGroup;
import zio.nio.core.channels.AsynchronousSocketChannel$;
import zio.nio.core.package$;

public class AsynchronousSocketChannel
extends AsynchronousByteChannel {
    private final java.nio.channels.AsynchronousSocketChannel channel;

    public static ZIO apply() {
        return AsynchronousSocketChannel$.MODULE$.apply();
    }

    public static ZIO apply(AsynchronousChannelGroup asynchronousChannelGroup) {
        return AsynchronousSocketChannel$.MODULE$.apply(asynchronousChannelGroup);
    }

    public static AsynchronousSocketChannel fromJava(java.nio.channels.AsynchronousSocketChannel asynchronousSocketChannel) {
        return AsynchronousSocketChannel$.MODULE$.fromJava(asynchronousSocketChannel);
    }

    public AsynchronousSocketChannel(java.nio.channels.AsynchronousSocketChannel channel) {
        this.channel = channel;
        super(channel);
    }

    @Override
    public java.nio.channels.AsynchronousSocketChannel channel() {
        return this.channel;
    }

    public final ZIO bind(SocketAddress address) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.bind$$anonfun$1(address)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value())).unit();
    }

    public final <T> ZIO<Object, IOException, BoxedUnit> setOption(SocketOption<T> name, T value) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.setOption$$anonfun$1(name, value)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value())).unit();
    }

    public final ZIO shutdownInput() {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(this::shutdownInput$$anonfun$1));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value())).unit();
    }

    public final ZIO shutdownOutput() {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(this::shutdownOutput$$anonfun$1));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value())).unit();
    }

    public final ZIO<Object, IOException, Option<SocketAddress>> remoteAddress() {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(this::remoteAddress$$anonfun$1));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value()));
    }

    public final ZIO<Object, IOException, Option<SocketAddress>> localAddress() {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(this::localAddress$$anonfun$1));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value()));
    }

    public final ZIO connect(SocketAddress socketAddress) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(javaz$.MODULE$.effectAsyncWithCompletionHandler((Function1)(JFunction1 & Serializable)h -> {
            this.channel().connect(socketAddress.jSocketAddress(), BoxedUnit.UNIT, h);
            return BoxedUnit.UNIT;
        }).unit());
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(Exception.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value()));
    }

    public final <A> ZIO<Object, Exception, Object> read(ByteBuffer dst, Duration timeout) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(javaz$.MODULE$.effectAsyncWithCompletionHandler((Function1)(JFunction1 & Serializable)h -> {
            this.channel().read(dst.byteBuffer(), BoxesRunTime.unboxToLong((Object)package.DurationOps$.MODULE$.fold$extension(zio.duration.package$.MODULE$.DurationOps(timeout), (Function0)((JFunction0.mcJ.sp & Serializable)AsynchronousSocketChannel::read$$anonfun$5$$anonfun$1), (Function1)(JFunction1 & Serializable)_$4 -> _$4.toNanos())), TimeUnit.NANOSECONDS, BoxedUnit.UNIT, h);
            return BoxedUnit.UNIT;
        }));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(Exception.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value())).flatMap((Function1)(JFunction1 & Serializable)_$5 -> package$.MODULE$.eofCheck(Predef$.MODULE$.Integer2int(_$5)));
    }

    public final <A> ZIO<Object, Exception, Chunk<Object>> readChunk(int capacity, Duration timeout) {
        return Buffer$.MODULE$.byte(capacity).flatMap((Function1)(JFunction1 & Serializable)b -> this.read((ByteBuffer)b, timeout).flatMap((Function1)((JFunction1 & Serializable)arg_0 -> AsynchronousSocketChannel.readChunk$$anonfun$5$$anonfun$adapted$1(b, arg_0))));
    }

    public final <A> ZIO<Object, Exception, Object> read(List<ByteBuffer> dsts, Duration timeout) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(javaz$.MODULE$.effectAsyncWithCompletionHandler((Function1)(JFunction1 & Serializable)h -> {
            java.nio.ByteBuffer[] a = (java.nio.ByteBuffer[])dsts.map((Function1)(JFunction1 & Serializable)_$6 -> _$6.byteBuffer()).toArray(ClassTag$.MODULE$.apply(java.nio.ByteBuffer.class));
            this.channel().read(a, 0, a.length, BoxesRunTime.unboxToLong((Object)package.DurationOps$.MODULE$.fold$extension(zio.duration.package$.MODULE$.DurationOps(timeout), (Function0)((JFunction0.mcJ.sp & Serializable)AsynchronousSocketChannel::read$$anonfun$7$$anonfun$1), (Function1)(JFunction1 & Serializable)_$7 -> _$7.toNanos())), TimeUnit.NANOSECONDS, BoxedUnit.UNIT, h);
            return BoxedUnit.UNIT;
        }));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(Exception.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value())).flatMap((Function1)(JFunction1 & Serializable)_$8 -> package$.MODULE$.eofCheck(Predef$.MODULE$.Long2long(_$8)));
    }

    public final <A> ZIO<Object, Exception, List<Chunk<Object>>> readChunks(List<Object> capacities, Duration timeout) {
        return ZIO$.MODULE$.foreach(capacities, (Function1)((JFunction1 & Serializable)AsynchronousSocketChannel::readChunks$$anonfun$adapted$1), BuildFrom$.MODULE$.buildFromIterableOps()).flatMap((Function1)(JFunction1 & Serializable)bs -> this.read((List<ByteBuffer>)bs, timeout).flatMap((Function1)((JFunction1 & Serializable)arg_0 -> AsynchronousSocketChannel.readChunks$$anonfun$7$$anonfun$adapted$1(bs, arg_0))));
    }

    private final java.nio.channels.AsynchronousSocketChannel bind$$anonfun$1(SocketAddress address$3) {
        return this.channel().bind(address$3.jSocketAddress());
    }

    private final java.nio.channels.AsynchronousSocketChannel setOption$$anonfun$1(SocketOption name$2, Object value$2) {
        return this.channel().setOption(name$2, value$2);
    }

    private final java.nio.channels.AsynchronousSocketChannel shutdownInput$$anonfun$1() {
        return this.channel().shutdownInput();
    }

    private final java.nio.channels.AsynchronousSocketChannel shutdownOutput$$anonfun$1() {
        return this.channel().shutdownOutput();
    }

    private final Option remoteAddress$$anonfun$1() {
        return Option$.MODULE$.apply((Object)this.channel().getRemoteAddress()).map((Function1)(JFunction1 & Serializable)jSocketAddress -> SocketAddress$.MODULE$.fromJava((java.net.SocketAddress)jSocketAddress));
    }

    private final Option localAddress$$anonfun$1() {
        return Option$.MODULE$.apply((Object)this.channel().getLocalAddress()).map((Function1)(JFunction1 & Serializable)jSocketAddress -> SocketAddress$.MODULE$.fromJava((java.net.SocketAddress)jSocketAddress));
    }

    private static final long read$$anonfun$5$$anonfun$1() {
        return Long.MAX_VALUE;
    }

    private static final /* synthetic */ ZIO readChunk$$anonfun$4$$anonfun$3(ByteBuffer b$6, int x$12) {
        int n = x$12;
        return b$6.flip().flatMap((Function1)(JFunction1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return b$6.getChunk(b$6.getChunk$default$1()).map((Function1)(JFunction1 & Serializable)r -> r);
        });
    }

    private static final ZIO readChunk$$anonfun$5$$anonfun$adapted$1(ByteBuffer b$11, Object x$1) {
        return AsynchronousSocketChannel.readChunk$$anonfun$4$$anonfun$3(b$11, BoxesRunTime.unboxToInt((Object)x$1));
    }

    private static final long read$$anonfun$7$$anonfun$1() {
        return Long.MAX_VALUE;
    }

    private static final ZIO readChunks$$anonfun$adapted$1(Object capacity) {
        return Buffer$.MODULE$.byte(BoxesRunTime.unboxToInt((Object)capacity));
    }

    private static final ZIO readChunks$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1(ByteBuffer b$8) {
        return b$8.getChunk(b$8.getChunk$default$1());
    }

    private static final /* synthetic */ ZIO readChunks$$anonfun$6$$anonfun$4(List bs$1, long x$1) {
        long l = x$1;
        return ZIO$.MODULE$.foreach((Iterable)bs$1, (Function1)(JFunction1 & Serializable)b -> b.flip().$times$greater(() -> AsynchronousSocketChannel.readChunks$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1(b)), BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1)(JFunction1 & Serializable)chunks -> chunks);
    }

    private static final ZIO readChunks$$anonfun$7$$anonfun$adapted$1(List bs$2, Object x$1) {
        return AsynchronousSocketChannel.readChunks$$anonfun$6$$anonfun$4(bs$2, BoxesRunTime.unboxToLong((Object)x$1));
    }
}

