/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.core.channels;

import dotty.runtime.function.JFunction0;
import dotty.runtime.function.JFunction1;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContextExecutorService;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Not$;
import zio.CanFail$;
import zio.Chunk;
import zio.IO$;
import zio.ZIO;
import zio.ZIO$;
import zio.interop.javaz$;
import zio.nio.core.Buffer$;
import zio.nio.core.ByteBuffer;
import zio.nio.core.channels.AsynchronousFileChannel$;
import zio.nio.core.channels.Channel;
import zio.nio.core.channels.FileLock;
import zio.nio.core.file.Path;
import zio.nio.core.package$;

public class AsynchronousFileChannel
implements Channel {
    private final java.nio.channels.AsynchronousFileChannel channel;
    private final ZIO size;

    public static AsynchronousFileChannel fromJava(java.nio.channels.AsynchronousFileChannel asynchronousFileChannel) {
        return AsynchronousFileChannel$.MODULE$.fromJava(asynchronousFileChannel);
    }

    public static ZIO<Object, IOException, AsynchronousFileChannel> open(Path path, Seq<OpenOption> seq) {
        return AsynchronousFileChannel$.MODULE$.open(path, seq);
    }

    public static ZIO<Object, IOException, AsynchronousFileChannel> open(Path path, Set<OpenOption> set, Option<ExecutionContextExecutorService> option, Set<FileAttribute<?>> set2) {
        return AsynchronousFileChannel$.MODULE$.open(path, set, option, set2);
    }

    public AsynchronousFileChannel(java.nio.channels.AsynchronousFileChannel channel) {
        this.channel = channel;
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect((Function0)((JFunction0.mcJ.sp & Serializable)() -> AsynchronousFileChannel.$init$$$anonfun$1(channel))));
        this.size = ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value()));
    }

    @Override
    public java.nio.channels.AsynchronousFileChannel channel() {
        return this.channel;
    }

    public final ZIO force(boolean metaData) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect((Function0)((JFunction0.mcV.sp & Serializable)() -> this.force$$anonfun$1(metaData))));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value()));
    }

    public final ZIO lock(long position, long size, boolean shared) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(javaz$.MODULE$.effectAsyncWithCompletionHandler((Function1)(JFunction1 & Serializable)_$1 -> {
            this.channel().lock(position, size, shared, BoxedUnit.UNIT, _$1);
            return BoxedUnit.UNIT;
        }).map((Function1)(JFunction1 & Serializable)_$2 -> new FileLock((java.nio.channels.FileLock)_$2)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(Exception.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value()));
    }

    public long lock$default$1() {
        return 0L;
    }

    public long lock$default$2() {
        return Long.MAX_VALUE;
    }

    public boolean lock$default$3() {
        return false;
    }

    public final ZIO read(ByteBuffer dst, long position) {
        return dst.withJavaBuffer((JFunction1 & Serializable)buf -> {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(javaz$.MODULE$.effectAsyncWithCompletionHandler((Function1)(JFunction1 & Serializable)_$3 -> {
                this.channel().read((java.nio.ByteBuffer)buf, position, BoxedUnit.UNIT, _$3);
                return BoxedUnit.UNIT;
            }));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(Exception.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value())).flatMap((Function1)(JFunction1 & Serializable)_$4 -> package$.MODULE$.eofCheck(Predef$.MODULE$.Integer2int(_$4)));
        });
    }

    public final ZIO<Object, Exception, Chunk<Object>> readChunk(int capacity, long position) {
        return Buffer$.MODULE$.byte(capacity).flatMap((Function1)(JFunction1 & Serializable)b -> this.read((ByteBuffer)b, position).flatMap((Function1)((JFunction1 & Serializable)arg_0 -> AsynchronousFileChannel.readChunk$$anonfun$5$$anonfun$adapted$1(b, arg_0))));
    }

    public final ZIO size() {
        return this.size;
    }

    public final ZIO truncate(long size) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.truncate$$anonfun$1(size)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value())).unit();
    }

    public final ZIO tryLock(long position, long size, boolean shared) {
        ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(IO$.MODULE$.effect(() -> this.tryLock$$anonfun$1(position, size, shared)));
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(IOException.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value()));
    }

    public long tryLock$default$1() {
        return 0L;
    }

    public long tryLock$default$2() {
        return Long.MAX_VALUE;
    }

    public boolean tryLock$default$3() {
        return false;
    }

    public final ZIO write(ByteBuffer src, long position) {
        return src.withJavaBuffer((JFunction1 & Serializable)buf -> {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(javaz$.MODULE$.effectAsyncWithCompletionHandler((Function1)(JFunction1 & Serializable)_$5 -> {
                this.channel().write((java.nio.ByteBuffer)buf, position, BoxedUnit.UNIT, _$5);
                return BoxedUnit.UNIT;
            }).map((Function1)(JFunction1 & Serializable)_$6 -> _$6));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(Exception.class), CanFail$.MODULE$.canFail(Not$.MODULE$.value()));
        });
    }

    public final ZIO<Object, Exception, BoxedUnit> writeChunk(Chunk<Object> src, long position) {
        return Buffer$.MODULE$.byte(src).flatMap((Function1)(JFunction1 & Serializable)b -> this.go$2((ByteBuffer)b, position));
    }

    private static final long $init$$$anonfun$1(java.nio.channels.AsynchronousFileChannel channel$1) {
        return channel$1.size();
    }

    private final void force$$anonfun$1(boolean metaData$1) {
        this.channel().force(metaData$1);
    }

    private static final /* synthetic */ ZIO readChunk$$anonfun$4$$anonfun$3(ByteBuffer b$1, int x$12) {
        int n = x$12;
        return b$1.flip().flatMap((Function1)(JFunction1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return b$1.getChunk(b$1.getChunk$default$1()).map((Function1)(JFunction1 & Serializable)chunk -> chunk);
        });
    }

    private static final ZIO readChunk$$anonfun$5$$anonfun$adapted$1(ByteBuffer b$6, Object x$1) {
        return AsynchronousFileChannel.readChunk$$anonfun$4$$anonfun$3(b$6, BoxesRunTime.unboxToInt((Object)x$1));
    }

    private final java.nio.channels.AsynchronousFileChannel truncate$$anonfun$1(long size$2) {
        return this.channel().truncate(size$2);
    }

    private final FileLock tryLock$$anonfun$1(long position$5, long size$3, boolean shared$2) {
        return new FileLock(this.channel().tryLock(position$5, size$3, shared$2));
    }

    private final /* synthetic */ ZIO go$1$$anonfun$1$$anonfun$1(ByteBuffer b$5, long pos$2, int bytesWritten$1, boolean x$1) {
        ZIO zIO;
        boolean bl = x$1;
        if (bl) {
            zIO = this.go$2(b$5, pos$2 + (long)bytesWritten$1);
        } else if (!bl) {
            zIO = IO$.MODULE$.unit();
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return zIO;
    }

    private final ZIO go$3$$anonfun$2$$anonfun$adapted$1(ByteBuffer b$7, long pos$3, int bytesWritten$2, Object x$1) {
        return this.go$1$$anonfun$1$$anonfun$1(b$7, pos$3, bytesWritten$2, BoxesRunTime.unboxToBoolean((Object)x$1));
    }

    private final /* synthetic */ ZIO go$4$$anonfun$3(ByteBuffer b$4, long pos$1, int bytesWritten) {
        return b$4.hasRemaining().flatMap((Function1)((JFunction1 & Serializable)arg_0 -> this.go$3$$anonfun$2$$anonfun$adapted$1(b$4, pos$1, bytesWritten, arg_0)));
    }

    private final ZIO go$5$$anonfun$adapted$1(ByteBuffer b$8, long pos$4, Object bytesWritten) {
        return this.go$4$$anonfun$3(b$8, pos$4, BoxesRunTime.unboxToInt((Object)bytesWritten));
    }

    private final ZIO go$2(ByteBuffer b$3, long pos) {
        return this.write(b$3, pos).flatMap((Function1)((JFunction1 & Serializable)arg_0 -> this.go$5$$anonfun$adapted$1(b$3, pos, arg_0)));
    }
}

