/*
 * Decompiled with CFR 0.152.
 */
package zio.nio.core;

import dotty.runtime.function.JFunction0;
import java.io.Serializable;
import java.nio.ByteOrder;
import scala.Function0;
import scala.Function1;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import zio.Chunk;
import zio.Chunk$;
import zio.UIO$;
import zio.ZIO;
import zio.nio.core.Buffer;

public final class LongBuffer
extends Buffer<Object> {
    private final java.nio.LongBuffer longBuffer;

    public LongBuffer(java.nio.LongBuffer longBuffer) {
        this.longBuffer = longBuffer;
        super(longBuffer, ClassTag$.MODULE$.apply(Long.TYPE));
    }

    @Override
    public ZIO<Object, Nothing$, long[]> array() {
        return UIO$.MODULE$.effectTotal(this::array$$anonfun$1);
    }

    @Override
    public ZIO order() {
        return UIO$.MODULE$.effectTotal(this::order$$anonfun$1);
    }

    @Override
    public ZIO slice() {
        return UIO$.MODULE$.effectTotal(this::slice$$anonfun$1);
    }

    @Override
    public ZIO compact() {
        return UIO$.MODULE$.effectTotal(this::compact$$anonfun$1).unit();
    }

    @Override
    public ZIO duplicate() {
        return UIO$.MODULE$.effectTotal(this::duplicate$$anonfun$1);
    }

    public <R, E, A> ZIO<R, E, A> withJavaBuffer(Function1<java.nio.LongBuffer, ZIO<R, E, A>> f) {
        return (ZIO)f.apply((Object)this.longBuffer);
    }

    @Override
    public ZIO get() {
        return UIO$.MODULE$.effectTotal((Function0)((JFunction0.mcJ.sp & Serializable)this::get$$anonfun$1));
    }

    @Override
    public ZIO get(int i) {
        return UIO$.MODULE$.effectTotal((Function0)((JFunction0.mcJ.sp & Serializable)() -> this.get$$anonfun$2(i)));
    }

    @Override
    public ZIO<Object, Nothing$, Chunk<Object>> getChunk(int maxLength) {
        return UIO$.MODULE$.effectTotal(() -> this.getChunk$$anonfun$1(maxLength));
    }

    @Override
    public int getChunk$default$1() {
        return Integer.MAX_VALUE;
    }

    @Override
    public ZIO put(long element) {
        return UIO$.MODULE$.effectTotal(() -> this.put$$anonfun$1(element)).unit();
    }

    @Override
    public ZIO put(int index, long element) {
        return UIO$.MODULE$.effectTotal(() -> this.put$$anonfun$2(index, element)).unit();
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> putChunkAll(Chunk<Object> chunk) {
        return UIO$.MODULE$.effectTotal(() -> this.putChunkAll$$anonfun$1(chunk)).unit();
    }

    @Override
    public ZIO asReadOnlyBuffer() {
        return UIO$.MODULE$.effectTotal(this::asReadOnlyBuffer$$anonfun$1);
    }

    private final long[] array$$anonfun$1() {
        return this.longBuffer.array();
    }

    private final ByteOrder order$$anonfun$1() {
        return this.longBuffer.order();
    }

    private final LongBuffer slice$$anonfun$1() {
        return new LongBuffer(this.longBuffer.slice());
    }

    private final java.nio.LongBuffer compact$$anonfun$1() {
        return this.longBuffer.compact();
    }

    private final LongBuffer duplicate$$anonfun$1() {
        return new LongBuffer(this.longBuffer.duplicate());
    }

    private final long get$$anonfun$1() {
        return this.longBuffer.get();
    }

    private final long get$$anonfun$2(int i$1) {
        return this.longBuffer.get(i$1);
    }

    private final Chunk getChunk$$anonfun$1(int maxLength$1) {
        long[] array = new long[package$.MODULE$.min(maxLength$1, this.longBuffer.remaining())];
        this.longBuffer.get(array);
        return Chunk$.MODULE$.fromArray((Object)array);
    }

    private final java.nio.LongBuffer put$$anonfun$1(long element$1) {
        return this.longBuffer.put(element$1);
    }

    private final java.nio.LongBuffer put$$anonfun$2(int index$1, long element$2) {
        return this.longBuffer.put(index$1, element$2);
    }

    private final java.nio.LongBuffer putChunkAll$$anonfun$1(Chunk chunk$1) {
        long[] array = (long[])chunk$1.toArray(ClassTag$.MODULE$.apply(Long.TYPE));
        return this.longBuffer.put(array);
    }

    private final LongBuffer asReadOnlyBuffer$$anonfun$1() {
        return new LongBuffer(this.longBuffer.asReadOnlyBuffer());
    }
}

