/*
 * Decompiled with CFR 0.152.
 */
package zio.mock;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import zio.mock.MockConsoleUtils$;
import zio.test.Summary;
import zio.test.TestAnnotation$;
import zio.test.TestAnnotationMap;
import zio.test.TestAnnotationRenderer;
import zio.test.render.ExecutionResult;
import zio.test.render.LogLine;
import zio.test.render.TestRenderer;

public interface MockTestRenderer
extends TestRenderer {
    public static void $init$(MockTestRenderer $this) {
        $this.zio$mock$MockTestRenderer$_setter_$zio$mock$MockTestRenderer$$tabSize_$eq(2);
    }

    public int zio$mock$MockTestRenderer$$tabSize();

    public void zio$mock$MockTestRenderer$_setter_$zio$mock$MockTestRenderer$$tabSize_$eq(int var1);

    public static Seq render$(MockTestRenderer $this, Seq results, TestAnnotationRenderer testAnnotationRenderer) {
        return $this.render((Seq<ExecutionResult>)results, testAnnotationRenderer);
    }

    default public Seq<String> render(Seq<ExecutionResult> results, TestAnnotationRenderer testAnnotationRenderer) {
        return (Seq)results.map((Function1 & Serializable)result -> {
            LogLine.Message message;
            LogLine.Message message2 = LogLine.Message$.MODULE$.apply((Seq)result.lines()).intersperse(LogLine.Line$.MODULE$.fromString("\n", LogLine.Line$.MODULE$.fromString$default$2()));
            ExecutionResult.ResultType resultType = result.resultType();
            if (ExecutionResult.ResultType$.Suite$.MODULE$.equals(resultType)) {
                message = this.renderSuite(result.status(), result.offset(), message2);
            } else if (ExecutionResult.ResultType$.Test$.MODULE$.equals(resultType)) {
                message = this.renderTest(result.status(), result.offset(), message2);
            } else if (ExecutionResult.ResultType$.Other$.MODULE$.equals(resultType)) {
                message = LogLine.Message$.MODULE$.apply((Seq)result.lines());
            } else {
                throw new MatchError((Object)resultType);
            }
            LogLine.Message output = message;
            LogLine.Message renderedAnnotations = this.renderAnnotations((List<TestAnnotationMap>)result.annotations(), testAnnotationRenderer);
            return this.renderToStringLines(output.$plus$plus(renderedAnnotations)).mkString();
        });
    }

    private LogLine.Message renderSuite(ExecutionResult.Status status, int offset, LogLine.Message message) {
        LogLine.Message message2;
        ExecutionResult.Status status2 = status;
        if (ExecutionResult.Status$.Passed$.MODULE$.equals(status2)) {
            LogLine.Line line = zio.test.render.package$.MODULE$.withOffset(offset, zio.test.render.package$.MODULE$.info("+").$plus(zio.test.render.package$.MODULE$.sp()));
            message2 = message.$plus$colon(line);
        } else if (ExecutionResult.Status$.Failed$.MODULE$.equals(status2)) {
            LogLine.Line line = zio.test.render.package$.MODULE$.withOffset(offset, LogLine.Line$.MODULE$.empty());
            message2 = message.$plus$colon(line);
        } else if (ExecutionResult.Status$.Ignored$.MODULE$.equals(status2)) {
            LogLine.Line line = zio.test.render.package$.MODULE$.withOffset(offset, LogLine.Line$.MODULE$.empty());
            message2 = message.$plus$colon(line).$colon$plus(zio.test.render.package$.MODULE$.fr(new StringBuilder(9).append(" - ").append(TestAnnotation$.MODULE$.ignored().identifier()).append(" suite").toString()).toLine());
        } else {
            throw new MatchError((Object)status2);
        }
        return message2;
    }

    private LogLine.Message renderTest(ExecutionResult.Status status, int offset, LogLine.Message message) {
        LogLine.Message message2;
        ExecutionResult.Status status2 = status;
        if (ExecutionResult.Status$.Passed$.MODULE$.equals(status2)) {
            LogLine.Line line = zio.test.render.package$.MODULE$.withOffset(offset, zio.test.render.package$.MODULE$.info("+").$plus(zio.test.render.package$.MODULE$.sp()));
            message2 = message.$plus$colon(line);
        } else if (ExecutionResult.Status$.Ignored$.MODULE$.equals(status2)) {
            LogLine.Line line = zio.test.render.package$.MODULE$.withOffset(offset, zio.test.render.package$.MODULE$.warn("-").$plus(zio.test.render.package$.MODULE$.sp()));
            message2 = message.$plus$colon(line);
        } else if (ExecutionResult.Status$.Failed$.MODULE$.equals(status2)) {
            message2 = message;
        } else {
            throw new MatchError((Object)status2);
        }
        return message2;
    }

    public static Seq renderToStringLines$(MockTestRenderer $this, LogLine.Message message) {
        return $this.renderToStringLines(message);
    }

    default public Seq<String> renderToStringLines(LogLine.Message message) {
        return (Seq)message.lines().map((Function1 & Serializable)line -> this.renderOffset(line.offset(), (String)line.optimized().fragments().foldLeft((Object)"", (Function2 & Serializable)(str, f) -> new StringBuilder(0).append((String)str).append(MockTestRenderer.renderFragment$1(f)).toString())));
    }

    private LogLine.Message renderAnnotations(List<TestAnnotationMap> annotations, TestAnnotationRenderer annotationRenderer) {
        LogLine.Message message;
        List<TestAnnotationMap> list = annotations;
        if (list instanceof .colon.colon) {
            TestAnnotationMap annotations2;
            .colon.colon colon2 = (.colon.colon)list;
            List list2 = colon2.next$access$1();
            List ancestors = list2;
            List rendered = annotationRenderer.run(ancestors, annotations2 = (TestAnnotationMap)colon2.head());
            message = rendered.isEmpty() ? LogLine.Message$.MODULE$.empty() : LogLine.Message$.MODULE$.apply(rendered.mkString(" - ", ", ", ""));
        } else {
            Nil$ nil$ = package$.MODULE$.Nil();
            List<TestAnnotationMap> list3 = list;
            if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                message = LogLine.Message$.MODULE$.empty();
            } else {
                throw new MatchError(list);
            }
        }
        return message;
    }

    private String renderOffset(int n, String s) {
        return new StringBuilder(0).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), n * this.zio$mock$MockTestRenderer$$tabSize())).append(s).toString();
    }

    public static String render$(MockTestRenderer $this, Summary summary) {
        return $this.render(summary);
    }

    default public String render(Summary summary) {
        return new StringBuilder(46).append(" ").append(summary.success()).append(" tests passed. ").append(summary.fail()).append(" tests failed. ").append(summary.ignore()).append(" tests ignored.").toString();
    }

    private static String renderFragment$1(LogLine.Fragment f) {
        String string;
        LogLine.Fragment.Style style = f.style();
        if (LogLine.Fragment$.Style$.Default$.MODULE$.equals(style)) {
            string = f.text();
        } else if (LogLine.Fragment$.Style$.Primary$.MODULE$.equals(style)) {
            string = MockConsoleUtils$.MODULE$.blue(f.text());
        } else if (LogLine.Fragment$.Style$.Warning$.MODULE$.equals(style)) {
            string = MockConsoleUtils$.MODULE$.yellow(f.text());
        } else if (LogLine.Fragment$.Style$.Error$.MODULE$.equals(style)) {
            string = MockConsoleUtils$.MODULE$.red(f.text());
        } else if (LogLine.Fragment$.Style$.Info$.MODULE$.equals(style)) {
            string = MockConsoleUtils$.MODULE$.green(f.text());
        } else if (LogLine.Fragment$.Style$.Detail$.MODULE$.equals(style)) {
            string = MockConsoleUtils$.MODULE$.cyan(f.text());
        } else if (LogLine.Fragment$.Style$.Dimmed$.MODULE$.equals(style)) {
            string = MockConsoleUtils$.MODULE$.dim(f.text());
        } else if (style instanceof LogLine.Fragment$.Style$.Bold) {
            LogLine.Fragment fragment;
            LogLine.Fragment$.Style$.Bold bold = LogLine.Fragment$.Style$.Bold$.MODULE$.unapply((LogLine.Fragment$.Style$.Bold)style);
            LogLine.Fragment fr = fragment = bold._1();
            string = MockConsoleUtils$.MODULE$.bold(MockTestRenderer.renderFragment$1(fr));
        } else if (style instanceof LogLine.Fragment$.Style$.Underlined) {
            LogLine.Fragment fragment;
            LogLine.Fragment$.Style$.Underlined underlined = LogLine.Fragment$.Style$.Underlined$.MODULE$.unapply((LogLine.Fragment$.Style$.Underlined)style);
            LogLine.Fragment fr = fragment = underlined._1();
            string = MockConsoleUtils$.MODULE$.underlined(MockTestRenderer.renderFragment$1(fr));
        } else if (style instanceof LogLine.Fragment$.Style$.Ansi) {
            LogLine.Fragment$.Style$.Ansi ansi = LogLine.Fragment$.Style$.Ansi$.MODULE$.unapply((LogLine.Fragment$.Style$.Ansi)style);
            LogLine.Fragment fragment = ansi._1();
            String string2 = ansi._2();
            LogLine.Fragment fr = fragment;
            String ansiColor = string2;
            string = MockConsoleUtils$.MODULE$.ansi(ansiColor, MockTestRenderer.renderFragment$1(fr));
        } else {
            throw new MatchError((Object)style);
        }
        return string;
    }
}

