/*
 * Decompiled with CFR 0.152.
 */
package zio.mock;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import zio.Cause;
import zio.Chunk;
import zio.Chunk$;
import zio.DurationOps$;
import zio.ZIO;
import zio.mock.Capability;
import zio.mock.Expectation;
import zio.mock.MockTestReporter$;
import zio.mock.internal.ExpectationState;
import zio.mock.internal.InvalidCall;
import zio.mock.internal.MockException;
import zio.package$;
import zio.test.Assertion;
import zio.test.AssertionResult;
import zio.test.AssertionValue;
import zio.test.BoolAlgebra;
import zio.test.BoolAlgebra$;
import zio.test.ExecutedSpec;
import zio.test.FailureCase;
import zio.test.FailureCase$;
import zio.test.FailureDetails;
import zio.test.GenFailureDetails;
import zio.test.PrettyPrint$;
import zio.test.TestAnnotationMap;
import zio.test.TestAnnotationMap$;
import zio.test.TestAnnotationRenderer;
import zio.test.TestFailure;
import zio.test.TestLogger;
import zio.test.TestLogger$;
import zio.test.TestSuccess;
import zio.test.TestTimeoutException;
import zio.test.Trace;
import zio.test.Trace$;
import zio.test.render.ExecutionResult;
import zio.test.render.LogLine;
import zio.test.render.TestRenderer;

public final class MockTestReporter$ {
    public static final MockTestReporter$ MODULE$ = new MockTestReporter$();

    public <E> Seq<ExecutionResult> render(ExecutedSpec<E> executedSpec, boolean includeCause, Object trace) {
        return this.loop$1(executedSpec, 0, scala.package$.MODULE$.List().empty(), scala.package$.MODULE$.List().empty(), includeCause, trace);
    }

    public <E> Function2<Duration, ExecutedSpec<E>, ZIO<TestLogger, Nothing$, BoxedUnit>> apply(TestRenderer testRenderer, TestAnnotationRenderer testAnnotationRenderer, Object trace) {
        return (Function2 & Serializable)(duration, executedSpec) -> {
            Seq rendered = testRenderer.render(MODULE$.render((ExecutedSpec)executedSpec, true, trace), testAnnotationRenderer);
            ExecutionResult executionResult = MODULE$.logStats((Duration)duration, (ExecutedSpec)executedSpec);
            Seq stats = testRenderer.render((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)executionResult), testAnnotationRenderer);
            return TestLogger$.MODULE$.logLine(((IterableOnceOps)rendered.$plus$plus((IterableOnce)stats)).mkString("\n"), trace);
        };
    }

    /*
     * WARNING - void declaration
     */
    private <E> ExecutionResult logStats(Duration duration, ExecutedSpec<E> executedSpec) {
        void var6_6;
        void var5_5;
        void var4_4;
        Tuple3 tuple3 = (Tuple3)executedSpec.fold(MockTestReporter$::$anonfun$logStats$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        int success = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int ignore = BoxesRunTime.unboxToInt((Object)tuple3._2());
        int failure = BoxesRunTime.unboxToInt((Object)tuple3._3());
        void total = var4_4 + var5_5 + var6_6;
        LogLine.Fragment stats = zio.test.render.package$.MODULE$.detail(new StringBuilder(44).append("Ran ").append((int)total).append(" test").append((Object)(total == true ? "" : "s")).append(" in ").append(DurationOps$.MODULE$.render$extension(package$.MODULE$.duration2DurationOps(duration))).append(": ").append((int)var4_4).append(" succeeded, ").append((int)var5_5).append(" ignored, ").append((int)var6_6).append(" failed").toString());
        return this.rendered((ExecutionResult.ResultType)ExecutionResult.ResultType$.Other$.MODULE$, "", (ExecutionResult.Status)ExecutionResult.Status$.Passed$.MODULE$, 0, (Seq<LogLine.Line>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogLine.Line[]{stats.toLine()}));
    }

    private ExecutionResult renderSuiteIgnored(String label, int offset) {
        return this.rendered((ExecutionResult.ResultType)ExecutionResult.ResultType$.Suite$.MODULE$, label, (ExecutionResult.Status)ExecutionResult.Status$.Ignored$.MODULE$, offset, (Seq<LogLine.Line>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogLine.Line[]{zio.test.render.package$.MODULE$.warn(new StringBuilder(2).append("- ").append(label).toString()).toLine()}));
    }

    private ExecutionResult renderSuiteFailed(String label, int offset) {
        return this.rendered((ExecutionResult.ResultType)ExecutionResult.ResultType$.Suite$.MODULE$, label, (ExecutionResult.Status)ExecutionResult.Status$.Failed$.MODULE$, offset, (Seq<LogLine.Line>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogLine.Line[]{zio.test.render.package$.MODULE$.error(new StringBuilder(2).append("- ").append(label).toString()).toLine()}));
    }

    private ExecutionResult renderSuiteSucceeded(String label, int offset) {
        return this.rendered((ExecutionResult.ResultType)ExecutionResult.ResultType$.Suite$.MODULE$, label, (ExecutionResult.Status)ExecutionResult.Status$.Passed$.MODULE$, offset, (Seq<LogLine.Line>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogLine.Line[]{zio.test.render.package$.MODULE$.fr(label).toLine()}));
    }

    public ExecutionResult renderAssertFailure(BoolAlgebra<AssertionResult> result, String label, int depth) {
        return (ExecutionResult)result.fold((Function1 & Serializable)details -> MODULE$.rendered((ExecutionResult.ResultType)ExecutionResult.ResultType$.Test$.MODULE$, label, (ExecutionResult.Status)ExecutionResult.Status$.Failed$.MODULE$, depth, (Seq<LogLine.Line>)MODULE$.renderFailure(label, depth, (AssertionResult)details).lines()), (Function2 & Serializable)(x$15, x$16) -> x$15.$amp$amp(x$16), (Function2 & Serializable)(x$17, x$18) -> x$17.$bar$bar(x$18), (Function1 & Serializable)x$19 -> x$19.unary_$bang());
    }

    private <E> ExecutionResult renderRuntimeCause(Cause<E> cause, String label, int depth, boolean includeCause, Object trace) {
        Seq failureDetails = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogLine.Line[]{this.renderFailureLabel(label, depth)})).$plus$plus((IterableOnce)((IterableOps)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogLine.Message[]{this.renderCause(cause, depth, trace)})).filter((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)includeCause))).flatMap((Function1 & Serializable)x$21 -> x$21.lines()));
        return this.rendered((ExecutionResult.ResultType)ExecutionResult.ResultType$.Test$.MODULE$, label, (ExecutionResult.Status)ExecutionResult.Status$.Failed$.MODULE$, depth, (Seq<LogLine.Line>)failureDetails);
    }

    public LogLine.Message renderAssertionResult(AssertionResult assertionResult, int offset) {
        LogLine.Message message;
        if (assertionResult instanceof AssertionResult.TraceResult) {
            AssertionResult.TraceResult traceResult = (AssertionResult.TraceResult)assertionResult;
            Trace trace = traceResult.trace();
            Option genFailureDetails = traceResult.genFailureDetails();
            message = (LogLine.Message)FailureCase$.MODULE$.fromTrace(trace).map((Function1 & Serializable)fc -> MODULE$.renderGenFailureDetails((Option<GenFailureDetails>)genFailureDetails, offset).$plus$plus(LogLine.Message$.MODULE$.apply(MODULE$.renderFailureCase((FailureCase)fc, offset)))).foldLeft((Object)LogLine.Message$.MODULE$.empty(), (Function2 & Serializable)(x$22, x$23) -> x$22.$plus$plus(x$23));
        } else if (assertionResult instanceof AssertionResult.FailureDetailsResult) {
            AssertionResult.FailureDetailsResult failureDetailsResult = (AssertionResult.FailureDetailsResult)assertionResult;
            FailureDetails failureDetails = failureDetailsResult.failureDetails();
            Option genFailureDetails = failureDetailsResult.genFailureDetails();
            message = this.renderGenFailureDetails((Option<GenFailureDetails>)genFailureDetails, offset).$plus$plus(this.renderFailureDetails(failureDetails, offset));
        } else {
            throw new MatchError((Object)assertionResult);
        }
        return message;
    }

    public Chunk<LogLine.Line> renderFailureCase(FailureCase failureCase, int offset) {
        Chunk chunk;
        Chunk nested;
        Chunk path;
        String location;
        String codeString;
        if (failureCase != null) {
            Option option;
            LogLine.Message errorMessage = failureCase.errorMessage();
            codeString = failureCase.codeString();
            location = failureCase.location();
            path = failureCase.path();
            nested = failureCase.nestedFailures();
            Chunk chunk2 = Chunk$.MODULE$.fromIterable((Iterable)errorMessage.lines());
            if (chunk2 != null && !(option = scala.package$.MODULE$.$plus$colon().unapply((SeqOps)chunk2)).isEmpty()) {
                LogLine.Line head = (LogLine.Line)((Tuple2)option.get())._1();
                Chunk tail = (Chunk)((Tuple2)option.get())._2();
                LogLine.Fragment fragment = zio.test.render.package$.MODULE$.error("\u2717 ");
                LogLine.Line line = head.$plus$colon(fragment);
                chunk = (Chunk)tail.map((Function1 & Serializable)x$24 -> {
                    LogLine.Fragment fragment = zio.test.render.package$.MODULE$.error("  ");
                    return x$24.$plus$colon(fragment);
                }).$plus$colon((Object)line);
            } else {
                chunk = Chunk$.MODULE$.empty();
            }
        } else {
            throw new MatchError(null);
        }
        Chunk chunk3 = chunk.$plus$plus(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogLine.Line[]{LogLine.Line$.MODULE$.fromString(codeString, LogLine.Line$.MODULE$.fromString$default$2())}))).$plus$plus(nested.flatMap((Function1 & Serializable)x$25 -> MODULE$.renderFailureCase((FailureCase)x$25, offset)).map((Function1 & Serializable)x$26 -> x$26.withOffset(1))).$plus$plus(Chunk$.MODULE$.fromIterable((Iterable)path.flatMap((Function1 & Serializable)x0$1 -> {
            Vector vector;
            if (x0$1 != null) {
                Option option;
                String label = (String)x0$1._1();
                Object value = x0$1._2();
                Chunk chunk = Chunk$.MODULE$.fromIterable((Iterable)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])PrettyPrint$.MODULE$.apply(value).split("\n")), (Function1 & Serializable)x$27 -> zio.test.render.package$.MODULE$.primary(x$27).toLine(), ClassTag$.MODULE$.apply(LogLine.Line.class))));
                if (chunk != null && !(option = scala.package$.MODULE$.$plus$colon().unapply((SeqOps)chunk)).isEmpty()) {
                    LogLine.Line head = (LogLine.Line)((Tuple2)option.get())._1();
                    Chunk lines = (Chunk)((Tuple2)option.get())._2();
                    LogLine.Fragment fragment = zio.test.render.package$.MODULE$.dim(new StringBuilder(3).append(label.trim()).append(" = ").toString());
                    LogLine.Line line = head.$plus$colon(fragment);
                    vector = (IndexedSeq)lines.$plus$colon((Object)line);
                } else {
                    vector = scala.package$.MODULE$.Vector().empty();
                }
            } else {
                throw new MatchError(null);
            }
            return vector;
        }))).$plus$plus(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogLine.Line[]{zio.test.render.package$.MODULE$.detail(new StringBuilder(3).append("at ").append(location).toString()).toLine()}))).map((Function1 & Serializable)x$28 -> x$28.withOffset(offset + 1));
        return chunk3;
    }

    private LogLine.Message renderAssertionFailureDetails(.colon.colon<AssertionValue> failureDetails, int offset) {
        return this.renderFragment((AssertionValue)failureDetails.head(), offset).toMessage().$plus$plus(this.loop$2((List)failureDetails, LogLine.Message$.MODULE$.empty(), offset)).$plus$plus(this.renderAssertionLocation((AssertionValue)failureDetails.last(), offset));
    }

    private LogLine.Message renderAssertionLocation(AssertionValue av, int offset) {
        return (LogLine.Message)av.sourceLocation().fold((Function0 & Serializable)() -> new LogLine.Message(LogLine.Message$.MODULE$.apply$default$1()), (Function1 & Serializable)location -> zio.test.render.package$.MODULE$.detail(new StringBuilder(3).append("at ").append((String)location).toString()).toLine().withOffset(offset + 1).toMessage());
    }

    private LogLine.Fragment renderSatisfied(AssertionValue assertionValue) {
        if (assertionValue.result().isSuccess()) {
            return new LogLine.Fragment(" satisfied ", LogLine.Fragment$.MODULE$.apply$default$2());
        }
        return new LogLine.Fragment(" did not satisfy ", LogLine.Fragment$.MODULE$.apply$default$2());
    }

    public LogLine.Message renderCause(Cause<Object> cause, int offset, Object trace) {
        LogLine.Message message;
        LogLine.Message prefix;
        List defects = cause.defects();
        List timeouts = defects.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 instanceof TestTimeoutException) {
                    String message = ((TestTimeoutException)x1).message();
                    object = LogLine.Message$.MODULE$.apply(message);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                boolean bl = x1 instanceof TestTimeoutException;
                return bl;
            }
        });
        List mockExceptions = defects.collect((PartialFunction)new Serializable(trace, offset){
            private static final long serialVersionUID = 0L;
            private final Object trace$3;
            private final int offset$5;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                if (x2 instanceof MockException) {
                    MockException mockException = (MockException)x2;
                    object = MockTestReporter$.MODULE$.zio$mock$MockTestReporter$$renderMockException(mockException, this.trace$3).map(arg_0 -> anonfun.2.$anonfun$applyOrElse$1(this.offset$5 + 1, arg_0));
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x2) {
                boolean bl = x2 instanceof MockException;
                return bl;
            }

            public static final /* synthetic */ LogLine.Line $anonfun$applyOrElse$1(int eta$0$1$1, LogLine.Line line) {
                return zio.test.render.package$.MODULE$.withOffset(eta$0$1$1, line);
            }
            {
                this.trace$3 = trace$3;
                this.offset$5 = offset$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(int zio.test.render.LogLine$Line )}, serializedLambda);
            }
        });
        Option remaining = cause.stripSomeDefects((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object = x3 instanceof TestTimeoutException ? BoxesRunTime.boxToBoolean((boolean)true) : (x3 instanceof MockException ? BoxesRunTime.boxToBoolean((boolean)true) : function1.apply(x3));
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x3) {
                boolean bl = x3 instanceof TestTimeoutException ? true : x3 instanceof MockException;
                return bl;
            }
        });
        LogLine.Message message2 = prefix = timeouts.nonEmpty() ? (LogLine.Message)timeouts.foldLeft((Object)LogLine.Message$.MODULE$.empty(), (Function2 & Serializable)(x$29, x$30) -> x$29.$plus$plus(x$30)) : (LogLine.Message)mockExceptions.foldLeft((Object)LogLine.Message$.MODULE$.empty(), (Function2 & Serializable)(x$31, x$32) -> x$31.$plus$plus(x$32));
        if (remaining instanceof Some) {
            Cause remainingCause = (Cause)((Some)remaining).value();
            message = prefix.$plus$plus(new LogLine.Message(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])remainingCause.prettyPrint().split("\n")), (Function1 & Serializable)s -> zio.test.render.package$.MODULE$.withOffset(offset + 1, LogLine.Line$.MODULE$.fromString(s, LogLine.Line$.MODULE$.fromString$default$2())), ClassTag$.MODULE$.apply(LogLine.Line.class))).toVector()));
        } else if (None$.MODULE$.equals(remaining)) {
            message = prefix;
        } else {
            throw new MatchError((Object)remaining);
        }
        return message;
    }

    public LogLine.Message zio$mock$MockTestReporter$$renderMockException(MockException exception, Object trace) {
        LogLine.Message message;
        if (exception instanceof MockException.InvalidCallException) {
            List<InvalidCall> failures = ((MockException.InvalidCallException)exception).failedMatches();
            LogLine.Line header = zio.test.render.package$.MODULE$.error("- could not find a matching expectation").toLine();
            message = this.renderUnmatchedExpectations(failures, trace).$plus$colon(header);
        } else if (exception instanceof MockException.UnsatisfiedExpectationsException) {
            Expectation expectation = ((MockException.UnsatisfiedExpectationsException)exception).expectation();
            LogLine.Line header = zio.test.render.package$.MODULE$.error("- unsatisfied expectations").toLine();
            message = this.renderUnsatisfiedExpectations(expectation).$plus$colon(header);
        } else if (exception instanceof MockException.UnexpectedCallException) {
            MockException.UnexpectedCallException unexpectedCallException = (MockException.UnexpectedCallException)exception;
            Capability method = unexpectedCallException.capability();
            Object args = unexpectedCallException.args();
            message = LogLine.Message$.MODULE$.apply((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogLine.Line[]{zio.test.render.package$.MODULE$.error(new StringBuilder(36).append("- unexpected call to ").append(method).append(" with arguments").toString()).toLine(), zio.test.render.package$.MODULE$.withOffset(1, zio.test.render.package$.MODULE$.detail(args.toString()).toLine())})));
        } else if (exception instanceof MockException.InvalidRangeException) {
            Range range = ((MockException.InvalidRangeException)exception).range();
            message = LogLine.Message$.MODULE$.apply((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogLine.Line[]{zio.test.render.package$.MODULE$.error(new StringBuilder(35).append("- invalid repetition range ").append(range.start()).append(" to ").append(range.end()).append(" by ").append(range.step()).toString()).toLine()})));
        } else {
            throw new MatchError((Object)exception);
        }
        return message;
    }

    private LogLine.Message renderUnmatchedExpectations(List<InvalidCall> failedMatches, Object trace) {
        return (LogLine.Message)failedMatches.map((Function1 & Serializable)x0$1 -> {
            LogLine.Message message;
            if (x0$1 instanceof InvalidCall.InvalidArguments) {
                InvalidCall.InvalidArguments invalidArguments = (InvalidCall.InvalidArguments)x0$1;
                Capability invoked = invalidArguments.invoked();
                Object args = invalidArguments.args();
                Assertion<Object> assertion = invalidArguments.assertion();
                LogLine.Line header = zio.test.render.package$.MODULE$.error(new StringBuilder(32).append("- ").append(invoked).append(" called with invalid arguments").toString()).toLine();
                message = MODULE$.renderTestFailure("", (BoolAlgebra<AssertionResult>)zio.test.package$.MODULE$.assertImpl((Function0 & Serializable)() -> args, zio.test.package$.MODULE$.assertImpl$default$2(), assertion, trace)).drop(1).$plus$colon(header).withOffset(1);
            } else if (x0$1 instanceof InvalidCall.InvalidCapability) {
                InvalidCall.InvalidCapability invalidCapability = (InvalidCall.InvalidCapability)x0$1;
                Capability invoked = invalidCapability.invoked();
                Capability expected = invalidCapability.expected();
                Assertion assertion = invalidCapability.assertion();
                message = LogLine.Message$.MODULE$.apply((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogLine.Line[]{zio.test.render.package$.MODULE$.withOffset(1, zio.test.render.package$.MODULE$.error(new StringBuilder(18).append("- invalid call to ").append(invoked).toString()).toLine()), zio.test.render.package$.MODULE$.withOffset(2, new LogLine.Fragment(new StringBuilder(25).append("expected ").append(expected).append(" with arguments ").toString(), LogLine.Fragment$.MODULE$.apply$default$2()).$plus(zio.test.render.package$.MODULE$.detail(assertion.toString())))})));
            } else if (x0$1 instanceof InvalidCall.InvalidPolyType) {
                InvalidCall.InvalidPolyType invalidPolyType = (InvalidCall.InvalidPolyType)x0$1;
                Capability invoked = invalidPolyType.invoked();
                Object args = invalidPolyType.args();
                Capability expected = invalidPolyType.expected();
                Assertion assertion = invalidPolyType.assertion();
                message = LogLine.Message$.MODULE$.apply((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogLine.Line[]{zio.test.render.package$.MODULE$.withOffset(1, zio.test.render.package$.MODULE$.error(new StringBuilder(54).append("- ").append(invoked).append(" called with arguments ").append(args).append(" and invalid polymorphic type").toString()).toLine()), zio.test.render.package$.MODULE$.withOffset(2, new LogLine.Fragment(new StringBuilder(25).append("expected ").append(expected).append(" with arguments ").toString(), LogLine.Fragment$.MODULE$.apply$default$2()).$plus(zio.test.render.package$.MODULE$.detail(assertion.toString())))})));
            } else {
                throw new MatchError(x0$1);
            }
            return message;
        }).reverse().foldLeft((Object)LogLine.Message$.MODULE$.empty(), (Function2 & Serializable)(x$33, x$34) -> x$33.$plus$plus(x$34));
    }

    private <R> LogLine.Message renderUnsatisfiedExpectations(Expectation<R> expectation) {
        Vector lines = this.loop$3((List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), expectation)})), scala.package$.MODULE$.Vector().empty());
        return new LogLine.Message(lines);
    }

    public LogLine.Message renderTestFailure(String label, BoolAlgebra<AssertionResult> testResult) {
        return (LogLine.Message)testResult.failures().fold((Function0 & Serializable)() -> LogLine.Message$.MODULE$.empty(), (Function1 & Serializable)details -> LogLine.Message$.MODULE$.apply((Seq)((ExecutionResult)details.fold((Function1 & Serializable)assertionResult -> MODULE$.rendered((ExecutionResult.ResultType)ExecutionResult.ResultType$.Test$.MODULE$, label, (ExecutionResult.Status)ExecutionResult.Status$.Failed$.MODULE$, 0, (Seq<LogLine.Line>)MODULE$.renderFailure(label, 0, (AssertionResult)assertionResult).lines()), (Function2 & Serializable)(x$40, x$41) -> x$40.$amp$amp(x$41), (Function2 & Serializable)(x$42, x$43) -> x$42.$bar$bar(x$43), (Function1 & Serializable)x$44 -> x$44.unary_$bang())).lines()));
    }

    private LogLine.Message renderFailure(String label, int offset, AssertionResult details) {
        LogLine.Line line = this.renderFailureLabel(label, offset);
        return this.renderAssertionResult(details, offset).$plus$colon(line).$colon$plus(LogLine.Line$.MODULE$.empty());
    }

    public LogLine.Line renderFailureLabel(String label, int offset) {
        return zio.test.render.package$.MODULE$.withOffset(offset, zio.test.render.package$.MODULE$.error(new StringBuilder(2).append("- ").append(label).toString()).toLine());
    }

    public LogLine.Message renderFailureDetails(FailureDetails failureDetails, int offset) {
        return this.renderAssertionFailureDetails((.colon.colon<AssertionValue>)failureDetails.assertion(), offset);
    }

    private <A> LogLine.Message renderGenFailureDetails(Option<GenFailureDetails> failureDetails, int offset) {
        LogLine.Message message;
        if (failureDetails instanceof Some) {
            GenFailureDetails details = (GenFailureDetails)((Some)failureDetails).value();
            String shrunken = details.shrunkenInput().toString();
            String initial = details.initialInput().toString();
            LogLine.Line renderShrunken = zio.test.render.package$.MODULE$.withOffset(offset + 1, new LogLine.Fragment(new StringBuilder(41).append("Test failed after ").append(details.iterations() + 1L).append(" iteration").append((Object)(details.iterations() > 0L ? "s" : "")).append(" with input: ").toString(), LogLine.Fragment$.MODULE$.apply$default$2()).$plus(zio.test.render.package$.MODULE$.error(shrunken)));
            String string = initial;
            message = !(string != null ? !string.equals(shrunken) : shrunken != null) ? renderShrunken.toMessage() : renderShrunken.$plus(zio.test.render.package$.MODULE$.withOffset(offset + 1, new LogLine.Fragment("Original input before shrinking was: ", LogLine.Fragment$.MODULE$.apply$default$2()).$plus(zio.test.render.package$.MODULE$.error(initial))));
        } else if (None$.MODULE$.equals(failureDetails)) {
            message = LogLine.Message$.MODULE$.empty();
        } else {
            throw new MatchError(failureDetails);
        }
        return message;
    }

    private LogLine.Line renderFragment(AssertionValue fragment, int offset) {
        return zio.test.render.package$.MODULE$.withOffset(offset + 1, zio.test.render.package$.MODULE$.primary(this.renderValue(fragment)).$plus(this.renderSatisfied(fragment)).$plus(zio.test.render.package$.MODULE$.detail(fragment.printAssertion())));
    }

    private LogLine.Line renderWhole(AssertionValue fragment, AssertionValue whole, int offset) {
        return zio.test.render.package$.MODULE$.withOffset(offset + 1, zio.test.render.package$.MODULE$.primary(this.renderValue(whole)).$plus(this.renderSatisfied(whole)).$plus$plus(this.highlight(zio.test.render.package$.MODULE$.detail(whole.printAssertion()), fragment.printAssertion(), this.highlight$default$3())));
    }

    private LogLine.Line highlight(LogLine.Fragment fragment, String substring, LogLine.Fragment.Style style) {
        Object[] parts = fragment.text().split(Pattern.quote(substring));
        if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(parts)) == 1) {
            return fragment.toLine();
        }
        return (LogLine.Line)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps(parts), (Object)LogLine.Line$.MODULE$.empty(), (arg_0, arg_1) -> MockTestReporter$.$anonfun$highlight$1((String[])parts, fragment, substring, style, arg_0, arg_1));
    }

    private LogLine.Fragment.Style highlight$default$3() {
        return LogLine.Fragment$.Style$.Warning$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String renderValue(AssertionValue av) {
        Option option = av.expression();
        Object object = av.value();
        if (!(option instanceof Some)) return object.toString();
        String expression = (String)((Some)option).value();
        if (this.expressionRedundant(object.toString(), expression)) return object.toString();
        return new StringBuilder(5).append("`").append(expression).append("` = ").append(object).toString();
    }

    private boolean expressionRedundant(String valueStr, String expression) {
        String string = MockTestReporter$.strip$1(valueStr);
        String string2 = MockTestReporter$.strip$1(expression);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public ExecutionResult rendered(ExecutionResult.ResultType caseType, String label, ExecutionResult.Status result, int offset, Seq<LogLine.Line> lines) {
        return new ExecutionResult(caseType, label, result, offset, (List)scala.package$.MODULE$.Nil(), lines.toList());
    }

    public static final /* synthetic */ TestAnnotationMap $anonfun$render$2(ExecutedSpec.SpecCase x0$2) {
        TestAnnotationMap testAnnotationMap;
        if (x0$2 instanceof ExecutedSpec.LabeledCase) {
            testAnnotationMap = (TestAnnotationMap)((ExecutedSpec.LabeledCase)x0$2).spec();
        } else if (x0$2 instanceof ExecutedSpec.MultipleCase) {
            testAnnotationMap = (TestAnnotationMap)((ExecutedSpec.MultipleCase)x0$2).specs().foldLeft((Object)TestAnnotationMap$.MODULE$.empty(), (Function2 & Serializable)(x$1, x$2) -> x$1.$plus$plus(x$2));
        } else if (x0$2 instanceof ExecutedSpec.TestCase) {
            testAnnotationMap = ((ExecutedSpec.TestCase)x0$2).annotations();
        } else {
            throw new MatchError((Object)x0$2);
        }
        return testAnnotationMap;
    }

    public static final /* synthetic */ Seq $anonfun$render$4(MockTestReporter$ $this, int depth$1, List allAnnotations$1, boolean includeCause$1, Object trace$1, ExecutedSpec x$4) {
        return $this.loop$1(x$4, depth$1 + 1, allAnnotations$1, scala.package$.MODULE$.List().empty(), includeCause$1, trace$1);
    }

    public static final /* synthetic */ List $anonfun$render$5(ExecutionResult x$5) {
        return x$5.lines();
    }

    public static final /* synthetic */ Option $anonfun$render$6(AssertionResult x0$3) {
        Some some;
        if (x0$3 instanceof AssertionResult.FailureDetailsResult) {
            AssertionResult.FailureDetailsResult failureDetailsResult = (AssertionResult.FailureDetailsResult)x0$3;
            some = new Some((Object)BoolAlgebra$.MODULE$.success((Object)failureDetailsResult));
        } else if (x0$3 instanceof AssertionResult.TraceResult) {
            AssertionResult.TraceResult traceResult = (AssertionResult.TraceResult)x0$3;
            Trace trace = traceResult.trace();
            Option genFailureDetails = traceResult.genFailureDetails();
            some = Trace$.MODULE$.prune(trace, false).map((Function1 & Serializable)a -> BoolAlgebra$.MODULE$.success((Object)new AssertionResult.TraceResult(a, genFailureDetails, AssertionResult.TraceResult$.MODULE$.apply$default$3())));
        } else {
            throw new MatchError((Object)x0$3);
        }
        return some;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ Option $anonfun$render$8(Option x0$4, Option x1$1) {
        if (x0$4 instanceof Some) {
            BoolAlgebra a = (BoolAlgebra)((Some)x0$4).value();
            if (x1$1 instanceof Some) {
                BoolAlgebra b = (BoolAlgebra)((Some)x1$1).value();
                return new Some((Object)a.$amp$amp(b));
            }
        }
        if (x0$4 instanceof Some) {
            BoolAlgebra a = (BoolAlgebra)((Some)x0$4).value();
            if (None$.MODULE$.equals(x1$1)) {
                return new Some((Object)a);
            }
        }
        if (!None$.MODULE$.equals(x0$4)) return None$.MODULE$;
        if (!(x1$1 instanceof Some)) return None$.MODULE$;
        BoolAlgebra b = (BoolAlgebra)((Some)x1$1).value();
        return new Some((Object)b);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ Option $anonfun$render$9(Option x0$5, Option x1$2) {
        if (x0$5 instanceof Some) {
            BoolAlgebra a = (BoolAlgebra)((Some)x0$5).value();
            if (x1$2 instanceof Some) {
                BoolAlgebra b = (BoolAlgebra)((Some)x1$2).value();
                return new Some((Object)a.$bar$bar(b));
            }
        }
        if (x0$5 instanceof Some) {
            BoolAlgebra a = (BoolAlgebra)((Some)x0$5).value();
            if (None$.MODULE$.equals(x1$2)) {
                return new Some((Object)a);
            }
        }
        if (!None$.MODULE$.equals(x0$5)) return None$.MODULE$;
        if (!(x1$2 instanceof Some)) return None$.MODULE$;
        BoolAlgebra b = (BoolAlgebra)((Some)x1$2).value();
        return new Some((Object)b);
    }

    public static final /* synthetic */ Option $anonfun$render$10(Option x$6) {
        return x$6.map((Function1 & Serializable)x$7 -> x$7.unary_$bang());
    }

    public static final /* synthetic */ ExecutionResult $anonfun$render$12(List labels$1, int depth$1, BoolAlgebra x$8) {
        return (ExecutionResult)x$8.fold((Function1 & Serializable)details -> MODULE$.rendered((ExecutionResult.ResultType)ExecutionResult.ResultType$.Test$.MODULE$, labels$1.reverse().mkString(" - "), (ExecutionResult.Status)ExecutionResult.Status$.Failed$.MODULE$, depth$1, (Seq<LogLine.Line>)MODULE$.renderFailure(labels$1.reverse().mkString(" - "), depth$1, (AssertionResult)details).lines()), (Function2 & Serializable)(x$9, x$10) -> x$9.$amp$amp(x$10), (Function2 & Serializable)(x$11, x$12) -> x$11.$bar$bar(x$12), (Function1 & Serializable)x$13 -> x$13.unary_$bang());
    }

    public static final /* synthetic */ Seq $anonfun$render$17(TestAnnotationMap annotations$1, List ancestors$1, ExecutionResult r) {
        return (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExecutionResult[]{r.withAnnotations(ancestors$1.$colon$colon((Object)annotations$1))}));
    }

    public static final /* synthetic */ Seq $anonfun$render$18() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    /*
     * Unable to fully structure code
     */
    private final Seq loop$1(ExecutedSpec executedSpec, int depth, List ancestors, List labels, boolean includeCause$1, Object trace$1) {
        block10: {
            block11: {
                block13: {
                    block14: {
                        block12: {
                            block9: {
                                while ((var9_7 = executedSpec.caseValue()) instanceof ExecutedSpec.LabeledCase) {
                                    var10_8 = (ExecutedSpec.LabeledCase)var9_7;
                                    label = var10_8.label();
                                    labels = labels.$colon$colon((Object)label);
                                    executedSpec = (ExecutedSpec)var10_8.spec();
                                }
                                if (!(var9_7 instanceof ExecutedSpec.MultipleCase)) break block9;
                                specs = ((ExecutedSpec.MultipleCase)var9_7).specs();
                                hasFailures = executedSpec.exists((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$render$1$adapted(zio.test.ExecutedSpec$SpecCase ), (Lzio/test/ExecutedSpec$SpecCase;)Ljava/lang/Object;)());
                                annotations = (TestAnnotationMap)executedSpec.fold((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$render$2(zio.test.ExecutedSpec$SpecCase ), (Lzio/test/ExecutedSpec$SpecCase;)Lzio/test/TestAnnotationMap;)());
                                if (specs.isEmpty()) {
                                    v0 = ExecutionResult.Status$.Ignored$.MODULE$;
                                    v1 = scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExecutionResult[]{this.renderSuiteIgnored(labels.reverse().mkString(" - "), depth)}));
                                } else if (hasFailures) {
                                    v0 = ExecutionResult.Status$.Failed$.MODULE$;
                                    v1 = scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExecutionResult[]{this.renderSuiteFailed(labels.reverse().mkString(" - "), depth)}));
                                } else {
                                    v0 = ExecutionResult.Status$.Passed$.MODULE$;
                                    v1 = scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExecutionResult[]{this.renderSuiteSucceeded(labels.reverse().mkString(" - "), depth)}));
                                }
                                var31_13 = v1;
                                status = (ExecutionResult.Status)v0;
                                renderedLabel = (Seq)var31_13;
                                allAnnotations = ancestors.$colon$colon((Object)annotations);
                                rest = specs.flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$render$4(zio.mock.MockTestReporter$ int scala.collection.immutable.List boolean java.lang.Object zio.test.ExecutedSpec ), (Lzio/test/ExecutedSpec;)Lscala/collection/immutable/Seq;)((MockTestReporter$)this, (int)depth, (List)allAnnotations, (boolean)includeCause$1, (Object)trace$1));
                                var19_18 = this.rendered((ExecutionResult.ResultType)ExecutionResult.ResultType$.Suite$.MODULE$, labels.reverse().mkString(" - "), (ExecutionResult.Status)var15_14, depth, (Seq<LogLine.Line>)((Seq)var16_15.flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$render$5(zio.test.render.ExecutionResult ), (Lzio/test/render/ExecutionResult;)Lscala/collection/immutable/List;)()))).withAnnotations(allAnnotations);
                                var7_19 = (Seq)rest.$plus$colon((Object)var19_18);
                                break block10;
                            }
                            if (!(var9_7 instanceof ExecutedSpec.TestCase)) break block11;
                            var20_20 = (ExecutedSpec.TestCase)var9_7;
                            result = var20_20.test();
                            annotations = var20_20.annotations();
                            var23_23 = false;
                            var24_24 = null;
                            var25_25 = false;
                            var26_26 = null;
                            if (!(result instanceof Right)) break block12;
                            var23_23 = true;
                            var24_24 = (Right)result;
                            if (!((TestSuccess)var24_24.value() instanceof TestSuccess.Succeeded)) break block12;
                            var8_27 = new Some((Object)this.rendered((ExecutionResult.ResultType)ExecutionResult.ResultType$.Test$.MODULE$, labels.reverse().mkString(" - "), (ExecutionResult.Status)ExecutionResult.Status$.Passed$.MODULE$, depth, (Seq<LogLine.Line>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogLine.Line[]{zio.test.render.package$.MODULE$.fr(labels.reverse().mkString(" - ")).toLine()})));
                            break block13;
                        }
                        if (!var23_23 || !TestSuccess.Ignored$.MODULE$.equals(var27_28 = (TestSuccess)var24_24.value())) break block14;
                        var8_27 = new Some((Object)this.rendered((ExecutionResult.ResultType)ExecutionResult.ResultType$.Test$.MODULE$, labels.reverse().mkString(" - "), (ExecutionResult.Status)ExecutionResult.Status$.Ignored$.MODULE$, depth, (Seq<LogLine.Line>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogLine.Line[]{zio.test.render.package$.MODULE$.warn(labels.reverse().mkString(" - ")).toLine()})));
                        break block13;
                    }
                    if (!(result instanceof Left)) ** GOTO lbl-1000
                    var25_25 = true;
                    var26_26 = (Left)result;
                    var28_29 = (TestFailure)var26_26.value();
                    if (var28_29 instanceof TestFailure.Assertion) {
                        var8_27 = ((Option)((TestFailure.Assertion)var28_29).result().fold((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$render$6(zio.test.AssertionResult ), (Lzio/test/AssertionResult;)Lscala/Option;)(), (Function2)(Function2 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$render$8(scala.Option scala.Option ), (Lscala/Option;Lscala/Option;)Lscala/Option;)(), (Function2)(Function2 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$render$9(scala.Option scala.Option ), (Lscala/Option;Lscala/Option;)Lscala/Option;)(), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$render$10(scala.Option ), (Lscala/Option;)Lscala/Option;)())).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$render$12(scala.collection.immutable.List int zio.test.BoolAlgebra ), (Lzio/test/BoolAlgebra;)Lzio/test/render/ExecutionResult;)((List)labels, (int)depth));
                    } else if (var25_25 && (var29_30 = (TestFailure)var26_26.value()) instanceof TestFailure.Runtime) {
                        cause = ((TestFailure.Runtime)var29_30).cause();
                        var8_27 = new Some((Object)this.renderRuntimeCause(cause, labels.reverse().mkString(" - "), depth, includeCause$1, trace$1));
                    } else {
                        throw new MatchError((Object)result);
                    }
                }
                var7_19 = (Seq)var8_27.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$render$17(zio.test.TestAnnotationMap scala.collection.immutable.List zio.test.render.ExecutionResult ), (Lzio/test/render/ExecutionResult;)Lscala/collection/immutable/Seq;)((TestAnnotationMap)annotations, (List)ancestors)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$render$18(), ()Lscala/collection/immutable/Seq;)());
                break block10;
            }
            throw new MatchError((Object)var9_7);
        }
        return var7_19;
    }

    public static final /* synthetic */ Tuple3 $anonfun$logStats$2(Tuple3 x0$2, Tuple3 x1$1) {
        int x3;
        int x2;
        int x1;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = new Tuple2((Object)x0$2, (Object)x1$1);
                if (x0$2 == null) break block2;
                x1 = BoxesRunTime.unboxToInt((Object)x0$2._1());
                x2 = BoxesRunTime.unboxToInt((Object)x0$2._2());
                x3 = BoxesRunTime.unboxToInt((Object)x0$2._3());
                if (x1$1 != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        int y1 = BoxesRunTime.unboxToInt((Object)x1$1._1());
        int y2 = BoxesRunTime.unboxToInt((Object)x1$1._2());
        int y3 = BoxesRunTime.unboxToInt((Object)x1$1._3());
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)(x1 + y1)), (Object)BoxesRunTime.boxToInteger((int)(x2 + y2)), (Object)BoxesRunTime.boxToInteger((int)(x3 + y3)));
        return tuple3;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Tuple3 $anonfun$logStats$1(ExecutedSpec.SpecCase x0$1) {
        block5: {
            block7: {
                block9: {
                    block8: {
                        block6: {
                            block4: {
                                if (!(x0$1 instanceof ExecutedSpec.LabeledCase)) break block4;
                                var1_1 = (Tuple3)((ExecutedSpec.LabeledCase)x0$1).spec();
                                break block5;
                            }
                            if (!(x0$1 instanceof ExecutedSpec.MultipleCase)) break block6;
                            var1_1 = (Tuple3)((ExecutedSpec.MultipleCase)x0$1).specs().foldLeft((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)), (Function2)(Function2 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$logStats$2(scala.Tuple3 scala.Tuple3 ), (Lscala/Tuple3;Lscala/Tuple3;)Lscala/Tuple3;)());
                            break block5;
                        }
                        if (!(x0$1 instanceof ExecutedSpec.TestCase)) break block7;
                        result = ((ExecutedSpec.TestCase)x0$1).test();
                        var4_3 = false;
                        var5_4 = null;
                        if (!(result instanceof Left)) break block8;
                        var2_5 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1));
                        break block9;
                    }
                    if (!(result instanceof Right)) ** GOTO lbl-1000
                    var4_3 = true;
                    var5_4 = (Right)result;
                    if ((TestSuccess)var5_4.value() instanceof TestSuccess.Succeeded) {
                        var2_5 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0));
                    } else if (var4_3 && TestSuccess.Ignored$.MODULE$.equals(var6_6 = (TestSuccess)var5_4.value())) {
                        var2_5 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0));
                    } else {
                        throw new MatchError((Object)result);
                    }
                }
                var1_1 = var2_5;
                break block5;
            }
            throw new MatchError((Object)x0$1);
        }
        return var1_1;
    }

    private final LogLine.Message loop$2(List failureDetails, LogLine.Message rendered, int offset$3) {
        while (failureDetails instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)failureDetails;
            AssertionValue fragment = (AssertionValue)colon2.head();
            List list = colon2.next$access$1();
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon3 = (.colon.colon)list;
            AssertionValue whole = (AssertionValue)colon3.head();
            rendered = rendered.$colon$plus(this.renderWhole(fragment, whole, offset$3));
            failureDetails = colon3.next$access$1().$colon$colon((Object)whole);
        }
        return rendered;
    }

    public static final /* synthetic */ boolean $anonfun$renderUnsatisfiedExpectations$1(Expectation x$35) {
        return x$35.state().isFailed();
    }

    public static final /* synthetic */ boolean $anonfun$renderUnsatisfiedExpectations$3(Expectation x$37) {
        return x$37.state().isFailed();
    }

    private final Vector loop$3(List stack, Vector lines) {
        block21: {
            while (true) {
                boolean bl = false;
                .colon.colon colon2 = null;
                Nil$ nil$ = scala.package$.MODULE$.Nil();
                if (!(nil$ == null ? stack != null : !nil$.equals(stack))) break block21;
                if (stack instanceof .colon.colon) {
                    bl = true;
                    colon2 = (.colon.colon)stack;
                    Tuple2 tuple2 = (Tuple2)colon2.head();
                    List tail = colon2.next$access$1();
                    if (tuple2 != null) {
                        int ident = tuple2._1$mcI$sp();
                        Expectation expectation = (Expectation)tuple2._2();
                        if (expectation instanceof Expectation.And) {
                            Expectation.And and = (Expectation.And)expectation;
                            List children = and.children();
                            if (and.state().isFailed()) {
                                LogLine.Line title = LogLine.Line$.MODULE$.fromString("in any order", ident);
                                lines = (Vector)lines.$colon$plus((Object)title);
                                stack = (List)children.filter((Function1 & Serializable)x$35 -> BoxesRunTime.boxToBoolean((boolean)MockTestReporter$.$anonfun$renderUnsatisfiedExpectations$1(x$35))).map((Function1 & Serializable)x$36 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)(ident + 1))), x$36)).$plus$plus((IterableOnce)tail);
                                continue;
                            }
                        }
                    }
                }
                if (bl) {
                    Tuple2 tuple2 = (Tuple2)colon2.head();
                    List tail = colon2.next$access$1();
                    if (tuple2 != null) {
                        int ident = tuple2._1$mcI$sp();
                        Expectation expectation = (Expectation)tuple2._2();
                        if (expectation instanceof Expectation.Call) {
                            Expectation.Call call = (Expectation.Call)expectation;
                            Capability method = call.capability();
                            Assertion assertion = call.assertion();
                            if (call.state().isFailed()) {
                                LogLine.Line rendered = zio.test.render.package$.MODULE$.withOffset(ident, new LogLine.Fragment(new StringBuilder(16).append(method).append(" with arguments ").toString(), LogLine.Fragment$.MODULE$.apply$default$2()).$plus(zio.test.render.package$.MODULE$.detail(assertion.toString())));
                                lines = (Vector)lines.$colon$plus((Object)rendered);
                                stack = tail;
                                continue;
                            }
                        }
                    }
                }
                if (bl) {
                    Tuple2 tuple2 = (Tuple2)colon2.head();
                    List tail = colon2.next$access$1();
                    if (tuple2 != null) {
                        int ident = tuple2._1$mcI$sp();
                        Expectation expectation = (Expectation)tuple2._2();
                        if (expectation instanceof Expectation.Chain) {
                            Expectation.Chain chain = (Expectation.Chain)expectation;
                            List children = chain.children();
                            if (chain.state().isFailed()) {
                                LogLine.Line title = LogLine.Line$.MODULE$.fromString("in sequential order", ident);
                                lines = (Vector)lines.$colon$plus((Object)title);
                                stack = (List)children.filter((Function1 & Serializable)x$37 -> BoxesRunTime.boxToBoolean((boolean)MockTestReporter$.$anonfun$renderUnsatisfiedExpectations$3(x$37))).map((Function1 & Serializable)x$38 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)(ident + 1))), x$38)).$plus$plus((IterableOnce)tail);
                                continue;
                            }
                        }
                    }
                }
                if (bl) {
                    Tuple2 tuple2 = (Tuple2)colon2.head();
                    List tail = colon2.next$access$1();
                    if (tuple2 != null) {
                        int ident = tuple2._1$mcI$sp();
                        Expectation expectation = (Expectation)tuple2._2();
                        if (expectation instanceof Expectation.Or) {
                            Expectation.Or or = (Expectation.Or)expectation;
                            List children = or.children();
                            if (or.state().isFailed()) {
                                LogLine.Line title = LogLine.Line$.MODULE$.fromString("one of", ident);
                                lines = (Vector)lines.$colon$plus((Object)title);
                                stack = (List)children.map((Function1 & Serializable)x$39 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)(ident + 1))), x$39)).$plus$plus((IterableOnce)tail);
                                continue;
                            }
                        }
                    }
                }
                if (bl) {
                    Tuple2 tuple2 = (Tuple2)colon2.head();
                    List tail = colon2.next$access$1();
                    if (tuple2 != null) {
                        int ident = tuple2._1$mcI$sp();
                        Expectation expectation = (Expectation)tuple2._2();
                        if (expectation instanceof Expectation.Repeated) {
                            Expectation.Repeated repeated = (Expectation.Repeated)expectation;
                            Expectation child = repeated.child();
                            Range range = repeated.range();
                            ExpectationState state = repeated.state();
                            int completed = repeated.completed();
                            if (state.isFailed()) {
                                String min = (String)Try$.MODULE$.apply((Function0 & Serializable)() -> Integer.toString(range.min((Ordering)Ordering.Int$.MODULE$))).getOrElse((Function0 & Serializable)() -> "0");
                                String max = (String)Try$.MODULE$.apply((Function0 & Serializable)() -> Integer.toString(range.max((Ordering)Ordering.Int$.MODULE$))).getOrElse((Function0 & Serializable)() -> "\u221e");
                                LogLine.Line title = LogLine.Line$.MODULE$.fromString(new StringBuilder(37).append("repeated ").append(completed).append(" times not in range ").append(min).append(" to ").append(max).append(" by ").append(range.step()).toString(), ident);
                                Tuple2 unsatisfied = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)(ident + 1))), child);
                                lines = (Vector)lines.$colon$plus((Object)title);
                                stack = tail.$colon$colon((Object)unsatisfied);
                                continue;
                            }
                        }
                    }
                }
                if (!bl) break;
                stack = colon2.next$access$1();
            }
            throw new MatchError((Object)stack);
        }
        return lines;
    }

    public static final /* synthetic */ LogLine.Line $anonfun$highlight$1(String[] parts$1, LogLine.Fragment fragment$1, String substring$1, LogLine.Fragment.Style style$1, LogLine.Line line, String part) {
        if (line.fragments().size() < ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])parts$1)) * 2 - 2) {
            return line.$plus(new LogLine.Fragment(part, fragment$1.style())).$plus(new LogLine.Fragment(substring$1, style$1));
        }
        return line.$plus(new LogLine.Fragment(part, fragment$1.style()));
    }

    private static final String strip$1(String s) {
        return s.replace("\"", "").replace(" ", "").replace("\n", "").replace("\\n", "");
    }

    private MockTestReporter$() {
    }

    public static final /* synthetic */ Object $anonfun$render$1$adapted(ExecutedSpec.SpecCase x0$1) {
        return BoxesRunTime.boxToBoolean((boolean)(bl = x0$1 instanceof ExecutedSpec.TestCase ? ((ExecutedSpec.TestCase)x0$1).test().isLeft() : false));
    }
}

