/*
 * Decompiled with CFR 0.152.
 */
package zio.mock;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.CanFail$;
import zio.Cause;
import zio.Chunk;
import zio.Chunk$;
import zio.ZIO;
import zio.ZIO$;
import zio.internal.stacktracer.SourceLocation;
import zio.mock.Capability;
import zio.mock.ConsoleFormatter;
import zio.mock.ConsoleFormatter$;
import zio.mock.Expectation;
import zio.mock.Mock;
import zio.mock.MockReporter$;
import zio.mock.internal.ExpectationState;
import zio.mock.internal.ExpectationState$PartiallySatisfied$;
import zio.mock.internal.ExpectationState$Satisfied$;
import zio.mock.internal.ExpectationState$Saturated$;
import zio.mock.internal.ExpectationState$Unsatisfied$;
import zio.mock.internal.InvalidCall;
import zio.mock.internal.MockException;
import zio.test.Assertion;
import zio.test.Assertion$;
import zio.test.CompileVariants$;
import zio.test.TestAspect;
import zio.test.TestFailure;
import zio.test.TestSuccess;

public final class MockReporter$ {
    public static final MockReporter$ MODULE$ = new MockReporter$();

    public <R0, E0, A> TestAspect.PerTest<Nothing$, R0, E0, Object> apply(ConsoleFormatter formatter) {
        return new TestAspect.PerTest<Nothing$, R0, E0, Object>(formatter){
            private final ConsoleFormatter formatter$1;

            public <R extends R0, E> ZIO<R, TestFailure<E>, TestSuccess> perTest(ZIO<R, TestFailure<E>, TestSuccess> test, Object trace) {
                return test.catchAll((Function1 & Serializable)x0$1 -> {
                    if (x0$1 instanceof TestFailure.Runtime) {
                        TestFailure.Runtime runtime = (TestFailure.Runtime)x0$1;
                        Chunk<MockException> mockExceptions = this.extractMockExceptions((TestFailure.Runtime<Object>)runtime);
                        if (mockExceptions.nonEmpty()) {
                            return this.zio$mock$MockReporter$$anon$$handleMockException((Seq<MockException>)mockExceptions);
                        }
                        return ZIO$.MODULE$.fail((Function0 & Serializable)() -> runtime, trace);
                    }
                    return ZIO$.MODULE$.fail((Function0 & Serializable)() -> x0$1, trace);
                }, CanFail$.MODULE$.canFail(), trace).catchSomeDefect((PartialFunction)new Serializable(this){
                    private static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        if (x1 instanceof MockException) {
                            MockException mockException = (MockException)x1;
                            return (B1)this.$outer.zio$mock$MockReporter$$anon$$handleMockException((Seq<MockException>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockException[]{mockException}));
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        return x1 instanceof MockException;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, trace);
            }

            private Chunk<MockException> extractMockExceptions(TestFailure.Runtime<Object> rt) {
                return this.extract$1(rt.cause(), Chunk$.MODULE$.empty());
            }

            public <E> ZIO<Object, TestFailure<E>, TestSuccess> zio$mock$MockReporter$$anon$$handleMockException(Seq<MockException> e) {
                return ZIO$.MODULE$.fail((Function0 & Serializable)() -> this.makeTestFailure((Seq<String>)((Seq)e.map((Function1 & Serializable)e -> this.makeMessages$1((MockException)e)))), (Object)"zio.mock.MockReporter.apply.$anon.handleMockException(MockReporter.scala:67)");
            }

            private TestFailure.Assertion makeTestFailure(Seq<String> messages) {
                Assertion ass = Assertion$.MODULE$.assertion(messages.mkString(new StringBuilder(1).append(" ").append(this.prefix(ExpectationState$Unsatisfied$.MODULE$)).toString()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$makeTestFailure$1(x$1)));
                return new TestFailure.Assertion(CompileVariants$.MODULE$.newAssertProxy((Function0 & Serializable)() -> "Your test case", "\"Your test case\"", "ass", ass, (Object)"zio.mock.MockReporter.apply.$anon.makeTestFailure(MockReporter.scala:75)", new SourceLocation("/home/runner/work/zio-mock/zio-mock/mock/shared/src/main/scala/zio/mock/MockReporter.scala", 75)), TestFailure.Assertion$.MODULE$.apply$default$2());
            }

            private String prefix(ExpectationState state) {
                if (ExpectationState$Unsatisfied$.MODULE$.equals(state)) {
                    return this.formatter$1.bold(this.formatter$1.red("           \u2716 "));
                }
                if (ExpectationState$PartiallySatisfied$.MODULE$.equals(state)) {
                    return this.formatter$1.bold(this.formatter$1.yellow("           \u26a0 "));
                }
                if (ExpectationState$Satisfied$.MODULE$.equals(state) ? true : ExpectationState$Saturated$.MODULE$.equals(state)) {
                    return this.formatter$1.bold(this.formatter$1.green("           \u2714 "));
                }
                throw new MatchError((Object)state);
            }

            private String renderAnd(Expectation.And<?> and) {
                String expectations = ((List)and.children().sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)anon.1.$anonfun$renderAnd$1(x$2)), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)e -> new StringBuilder(0).append(this.prefix(e.state())).append(this.render$1((Expectation)e)).toString()).mkString("\n");
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(42).append("|").append(this.formatter$1.bold(this.formatter$1.blue("some or all"))).append(" of the following expectations:\n        |").append(expectations).toString()));
            }

            private String renderAssertion(Assertion<?> ass) {
                return this.formatter$1.bold(this.formatter$1.magenta(ass.toString()));
            }

            /*
             * Enabled aggressive block sorting
             */
            private String renderMock(Mock<?> in) {
                String string;
                List list;
                Object[] fragments = in.getClass().getName().replaceAll("\\$", ".").split("\\.");
                Tuple2 tuple2 = Predef$.MODULE$.wrapRefArray(fragments).toList().splitAt(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(fragments)) - 3);
                if (tuple2 != null && (list = (List)tuple2._2()) instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    String module = (String)colon2.head();
                    List list2 = colon2.next$access$1();
                    if (list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        String service = (String)colon3.head();
                        List list3 = colon3.next$access$1();
                        if (list3 instanceof .colon.colon) {
                            .colon.colon colon4 = (.colon.colon)list3;
                            String method = (String)colon4.head();
                            List list4 = colon4.next$access$1();
                            if (Nil$.MODULE$.equals(list4)) {
                                string = new StringBuilder(2).append(module).append(".").append(service).append(".").append(method).toString();
                                return this.formatter$1.bold(this.formatter$1.green(string));
                            }
                        }
                    }
                }
                string = Predef$.MODULE$.wrapRefArray(fragments).mkString(".");
                return this.formatter$1.bold(this.formatter$1.green(string));
            }

            private String renderCall(Expectation.Call<?, ?, ?, ?> call, Option<String> additionalDetails) {
                Capability<?, ?, ?, ?> capability = call.capability();
                Assertion<?> assertion = call.assertion();
                Mock<?> mock = call.mock();
                ExpectationState state = call.state();
                call.invocations();
                String details = (String)additionalDetails.getOrElse((Function0 & Serializable)() -> new StringBuilder(43).append("However, it was ").append($this.formatter$1.bold($this.formatter$1.red("never"))).append(" called and is considered ").append(this.renderState(state)).append(".").toString());
                return new StringBuilder(56).append("Expected the call ").append(this.renderCapability(capability, (Option<Either<Assertion<?>, Object>>)new Some((Object)package$.MODULE$.Left().apply(assertion)), this.renderCapability$default$3())).append(" on ").append(this.renderMock(mock)).append(" which satisfies the assertion ").append(this.renderAssertion(assertion)).append(".  ").append(details).toString();
            }

            private Option<String> renderCall$default$2() {
                return None$.MODULE$;
            }

            private String renderCapability(Capability<?, ?, ?, ?> capability, Option<Either<Assertion<?>, Object>> ass, Function1<String, String> overrideDisplay) {
                Either either;
                boolean bl = false;
                Some some = null;
                if (ass instanceof Some) {
                    bl = true;
                    some = (Some)ass;
                    Either either2 = (Either)some.value();
                    if (either2 instanceof Left) {
                        Assertion ass2 = (Assertion)((Left)either2).value();
                        return this.formatter$1.bold(this.formatter$1.cyan(new StringBuilder(1).append(capability).append("(").append(this.renderAssertion(ass2)).append(this.formatter$1.bold(this.formatter$1.cyan(")"))).toString()));
                    }
                }
                if (bl && (either = (Either)some.value()) instanceof Right) {
                    Object value = ((Right)either).value();
                    return this.formatter$1.bold(this.formatter$1.cyan(new StringBuilder(1).append(capability).append("(").append(this.formatter$1.red(value.toString())).append(this.formatter$1.bold(this.formatter$1.cyan(")"))).toString()));
                }
                if (None$.MODULE$.equals(ass)) {
                    return this.formatter$1.bold(this.formatter$1.cyan(String.valueOf(overrideDisplay.apply((Object)capability.toString()))));
                }
                throw new MatchError(ass);
            }

            private Function1<String, String> renderCapability$default$3() {
                return (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x);
            }

            private String renderChain(Expectation.Chain<?> chain) {
                String children = chain.children().map((Function1 & Serializable)e -> new StringBuilder(0).append(this.prefix(e.state())).append(this.renderExpectation((Expectation<?>)e, this.renderExpectation$default$2())).toString()).mkString("\n");
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(63).append("|the following mocked expectations:\n            |").append(children).append("\n            |").toString()));
            }

            private String renderExactly(Expectation.Exactly<?> exactly) {
                String details = new StringBuilder(76).append("It should have been called exactly ").append(this.formatter$1.bold(this.formatter$1.green(BoxesRunTime.boxToInteger((int)exactly.times())))).append(" times but ").append(this.renderCompleted$1(exactly)).append(".  As such, it is considered ").append(this.renderState(exactly.state())).append(".").toString();
                return this.renderExpectation(exactly.child(), (Option<String>)new Some((Object)details));
            }

            private String renderExpectation(Expectation<?> expectation, Option<String> additionalDetails) {
                if (expectation instanceof Expectation.And) {
                    Expectation.And and = (Expectation.And)expectation;
                    return this.renderAnd(and);
                }
                if (expectation instanceof Expectation.Call) {
                    Expectation.Call call = (Expectation.Call)expectation;
                    return this.renderCall(call, additionalDetails);
                }
                if (expectation instanceof Expectation.Chain) {
                    Expectation.Chain chain = (Expectation.Chain)expectation;
                    return this.renderChain(chain);
                }
                if (expectation instanceof Expectation.NoCalls) {
                    Mock<R> mock = ((Expectation.NoCalls)expectation).mock();
                    return new StringBuilder(94).append("'NoCalls' on ").append(this.renderMock(mock)).append(" should always be handled by the logic that handle the 'UnexpectedCallException'.").toString();
                }
                if (expectation instanceof Expectation.Or) {
                    Expectation.Or or = (Expectation.Or)expectation;
                    return new StringBuilder(44).append("Rendering of Expectation ").append(or).append(" not supported yet.").toString();
                }
                if (expectation instanceof Expectation.Repeated) {
                    Expectation.Repeated repeated = (Expectation.Repeated)expectation;
                    return this.renderRepeated(repeated);
                }
                if (expectation instanceof Expectation.Exactly) {
                    Expectation.Exactly exactly = (Expectation.Exactly)expectation;
                    return this.renderExactly(exactly);
                }
                throw new MatchError(expectation);
            }

            private Option<String> renderExpectation$default$2() {
                return None$.MODULE$;
            }

            private String renderInvalidCall(InvalidCall ic) {
                if (ic instanceof InvalidCall.InvalidArguments) {
                    InvalidCall.InvalidArguments invalidArguments = (InvalidCall.InvalidArguments)ic;
                    Capability<R, I, E, A> capability = invalidArguments.invoked();
                    Object args = invalidArguments.args();
                    Assertion<Object> assertion = invalidArguments.assertion();
                    return new StringBuilder(84).append(this.renderCapability(capability, (Option<Either<Assertion<?>, Object>>)new Some((Object)package$.MODULE$.Right().apply(args)), this.renderCapability$default$3())).append(" was invoked with the following invalid arguments, '").append(this.formatter$1.bold(this.formatter$1.red(args.toString()))).append("', which violated the assertion ").append(this.renderAssertion(assertion)).toString();
                }
                if (ic instanceof InvalidCall.InvalidCapability) {
                    InvalidCall.InvalidCapability invalidCapability = (InvalidCall.InvalidCapability)ic;
                    Capability<R0, In0, E0, A0> invoked = invalidCapability.invoked();
                    Capability<R1, In1, E1, A1> expected = invalidCapability.expected();
                    Assertion<In1> assertion = invalidCapability.assertion();
                    return new StringBuilder(118).append("Expected a call to ").append(this.renderCapability(expected, (Option<Either<Assertion<?>, Object>>)new Some((Object)package$.MODULE$.Left().apply(assertion)), this.renderCapability$default$3())).append(", but ").append(this.renderCapability(invoked, (Option<Either<Assertion<?>, Object>>)None$.MODULE$, (Function1<String, String>)(Function1 & Serializable)name -> this.simpleNameRedWithEmphasis((String)name))).append(" was invoked instead.  (HINT: Remember order is important when considering mock invocations.)").toString();
                }
                if (ic instanceof InvalidCall.InvalidPolyType) {
                    return ((InvalidCall.InvalidPolyType)ic).toString();
                }
                throw new MatchError((Object)ic);
            }

            private String renderInvalidCalls(List<InvalidCall> invalidCalls) {
                String calls = invalidCalls.map((Function1 & Serializable)e -> new StringBuilder(0).append(this.prefix(ExpectationState$Unsatisfied$.MODULE$)).append(this.renderInvalidCall((InvalidCall)e)).toString()).mkString("\n");
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(106).append("|expected mock expectations in that it performed the following invalid calls:\n            | ").append(calls).append("\n            |").toString()));
            }

            private String renderRepeated(Expectation.Repeated<?> repeated) {
                String range = new StringBuilder(4).append(repeated.range().start()).append(" to ").append(repeated.range().end()).toString();
                String details = new StringBuilder(81).append("It should have been called anywhere from ").append(this.formatter$1.bold(this.formatter$1.green(range))).append(" time but ").append(this.renderCompleted$2(repeated)).append(".  As such, it is considered ").append(this.renderState(repeated.state())).append(".").toString();
                return this.renderExpectation(repeated.child(), (Option<String>)new Some((Object)details));
            }

            private String renderState(ExpectationState state) {
                String string;
                if (ExpectationState$PartiallySatisfied$.MODULE$.equals(state)) {
                    string = this.formatter$1.yellow("partially satisfied");
                } else if (ExpectationState$Satisfied$.MODULE$.equals(state)) {
                    string = this.formatter$1.green("satisfied");
                } else if (ExpectationState$Saturated$.MODULE$.equals(state)) {
                    string = this.formatter$1.green("saturated");
                } else if (ExpectationState$Unsatisfied$.MODULE$.equals(state)) {
                    string = this.formatter$1.red("unsatisfied");
                } else {
                    throw new MatchError((Object)state);
                }
                return this.formatter$1.bold(string);
            }

            private String simpleNameRedWithEmphasis(String name) {
                List list = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.reverse$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(name), '.')))).toList();
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    String head = (String)colon2.head();
                    List tail = colon2.next$access$1();
                    return new StringBuilder(0).append(this.formatter$1.bold(this.formatter$1.cyan(new StringBuilder(1).append(tail.reverse().mkString(".")).append(".").toString()))).append(this.formatter$1.underlined(this.formatter$1.bold(this.formatter$1.red(head)))).toString();
                }
                if (Nil$.MODULE$.equals(list)) {
                    return String.valueOf(this.formatter$1.underlined(this.formatter$1.bold(this.formatter$1.red(name))));
                }
                throw new MatchError((Object)list);
            }

            private final Chunk extract$1(Cause cause, Chunk exceptions) {
                while (true) {
                    Object me;
                    Throwable me2;
                    if (cause instanceof Cause.Die && (me2 = ((Cause.Die)cause).value()) instanceof MockException) {
                        MockException mockException = (MockException)me2;
                        return (Chunk)exceptions.$colon$plus((Object)mockException);
                    }
                    if (cause instanceof Cause.Then) {
                        Cause.Then then = (Cause.Then)cause;
                        Cause left = then.left();
                        exceptions = this.extract$1(left, exceptions);
                        cause = then.right();
                        continue;
                    }
                    if (cause instanceof Cause.Fail && (me = ((Cause.Fail)cause).value()) instanceof MockException) {
                        MockException mockException = (MockException)me;
                        return (Chunk)exceptions.$colon$plus((Object)mockException);
                    }
                    if (cause instanceof Cause.Stackless) {
                        cause = ((Cause.Stackless)cause).cause();
                        continue;
                    }
                    if (!(cause instanceof Cause.Both)) break;
                    Cause.Both both = (Cause.Both)cause;
                    Cause left = both.left();
                    exceptions = this.extract$1(left, exceptions);
                    cause = both.right();
                }
                return exceptions;
            }

            private final String makeMessages$1(MockException e) {
                if (e instanceof MockException.UnexpectedCallException) {
                    MockException.UnexpectedCallException unexpectedCallException = (MockException.UnexpectedCallException)e;
                    Capability<R, I, E, A> capability = unexpectedCallException.capability();
                    Object args = unexpectedCallException.args();
                    Mock<R> mock = capability.mock();
                    return new StringBuilder(37).append(this.formatter$1.reset("that there should have been no calls to the mock")).append(" ").append(this.renderMock(mock)).append(".  However ").append(this.renderCapability(capability, (Option<Either<Assertion<?>, Object>>)new Some((Object)package$.MODULE$.Right().apply(args)), this.renderCapability$default$3())).append(" was called unexpectedly.").toString();
                }
                if (e instanceof MockException.UnsatisfiedExpectationsException) {
                    Expectation<R> expectation = ((MockException.UnsatisfiedExpectationsException)e).expectation();
                    return this.formatter$1.reset(this.renderExpectation(expectation, this.renderExpectation$default$2()));
                }
                if (e instanceof MockException.InvalidCallException) {
                    List<InvalidCall> failedMatches = ((MockException.InvalidCallException)e).failedMatches();
                    return this.formatter$1.reset(this.renderInvalidCalls(failedMatches));
                }
                throw new MatchError((Object)e);
            }

            public static final /* synthetic */ boolean $anonfun$makeTestFailure$1(Function0 x$1) {
                return false;
            }

            public static final /* synthetic */ int $anonfun$renderAnd$1(Expectation x$2) {
                return x$2.state().value();
            }

            private final String render$1(Expectation e) {
                String string;
                ExpectationState state = e.state();
                int invocationCount = BoxesRunTime.unboxToInt((Object)e.invocations().fold((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(x$3, x$4) -> x$3 + x$4));
                if (ExpectationState$PartiallySatisfied$.MODULE$.equals(state) ? true : ExpectationState$Unsatisfied$.MODULE$.equals(state)) {
                    string = invocationCount == 0 ? new StringBuilder(37).append("Which was ").append(this.formatter$1.bold(this.formatter$1.red("never"))).append(" called and is considered ").append(this.renderState(state)).append(".").toString() : (invocationCount == 1 ? new StringBuilder(42).append("Which was only called ").append(this.formatter$1.bold(this.formatter$1.yellow("once"))).append(" and is considered ").append(this.renderState(state)).append(".").toString() : new StringBuilder(48).append("Which was only called ").append(this.formatter$1.bold(this.formatter$1.yellow(BoxesRunTime.boxToInteger((int)invocationCount)))).append(" times and is considered ").append(this.renderState(state)).append(".").toString());
                } else if (ExpectationState$Satisfied$.MODULE$.equals(state) ? true : ExpectationState$Saturated$.MODULE$.equals(state)) {
                    string = new StringBuilder(55).append("Which was called ").append(this.formatter$1.bold(this.formatter$1.green(BoxesRunTime.boxToInteger((int)invocationCount)))).append(" times as expected and is considered ").append(this.renderState(state)).append(".").toString();
                } else {
                    throw new MatchError((Object)state);
                }
                String details = string;
                return this.renderExpectation(e, (Option<String>)new Some((Object)details));
            }

            private final String renderCompleted$1(Expectation.Exactly exactly$1) {
                int n = exactly$1.completed();
                switch (n) {
                    case 0: {
                        return new StringBuilder(11).append("was ").append(this.formatter$1.bold(this.formatter$1.red("never"))).append(" called").toString();
                    }
                    case 1: {
                        return new StringBuilder(16).append("was only called ").append(this.formatter$1.bold(this.formatter$1.yellow("once"))).toString();
                    }
                }
                return new StringBuilder(22).append("was only called ").append(this.formatter$1.bold(this.formatter$1.yellow(BoxesRunTime.boxToInteger((int)n)))).append(" times").toString();
            }

            private final String renderCompleted$2(Expectation.Repeated repeated$1) {
                int n = repeated$1.completed();
                switch (n) {
                    case 0: {
                        return new StringBuilder(11).append("was ").append(this.formatter$1.bold(this.formatter$1.red("never"))).append(" called").toString();
                    }
                    case 1: {
                        return new StringBuilder(16).append("was only called ").append(this.formatter$1.bold(this.formatter$1.yellow("once"))).toString();
                    }
                }
                return new StringBuilder(22).append("was only called ").append(this.formatter$1.bold(this.formatter$1.yellow(BoxesRunTime.boxToInteger((int)n)))).append(" times").toString();
            }
            {
                this.formatter$1 = formatter$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$handleMockException$1(zio.mock.MockReporter$$anon$1 scala.collection.immutable.Seq ), $anonfun$handleMockException$2(zio.mock.MockReporter$$anon$1 zio.mock.internal.MockException ), $anonfun$makeTestFailure$1$adapted(scala.Function0 ), $anonfun$makeTestFailure$2(), $anonfun$perTest$1(zio.mock.MockReporter$$anon$1 java.lang.Object zio.test.TestFailure ), $anonfun$perTest$2(zio.test.TestFailure$Runtime ), $anonfun$perTest$3(zio.test.TestFailure ), $anonfun$renderAnd$1$adapted(zio.mock.Expectation ), $anonfun$renderAnd$2(int int ), $anonfun$renderAnd$3(zio.mock.MockReporter$$anon$1 zio.mock.Expectation ), $anonfun$renderCall$1(zio.mock.MockReporter$$anon$1 zio.mock.internal.ExpectationState ), $anonfun$renderCapability$default$3$1(java.lang.String ), $anonfun$renderChain$1(zio.mock.MockReporter$$anon$1 zio.mock.Expectation ), $anonfun$renderInvalidCall$1(zio.mock.MockReporter$$anon$1 java.lang.String ), $anonfun$renderInvalidCalls$1(zio.mock.MockReporter$$anon$1 zio.mock.internal.InvalidCall )}, serializedLambda);
            }
        };
    }

    public <R0, E0, A> ConsoleFormatter apply$default$1() {
        return ConsoleFormatter$.MODULE$.colorful();
    }

    private MockReporter$() {
    }
}

