/*
 * Decompiled with CFR 0.152.
 */
package zio.metrics.connectors.statsd;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.time.Instant;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.deriving.Mirror;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import zio.Chunk;
import zio.Chunk$;
import zio.NonEmptyChunk;
import zio.NonEmptyChunk$;
import zio.ZIO;
import zio.ZIO$;
import zio.metrics.MetricKey;
import zio.metrics.MetricLabel;
import zio.metrics.MetricLabel$;
import zio.metrics.MetricState;
import zio.metrics.connectors.MetricEvent;

public final class StatsdEncoder$
implements Product,
Serializable,
Mirror.Singleton {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(StatsdEncoder$.class.getDeclaredField("format$lzy1"));
    private static final int BUF_PER_METRIC;
    private volatile Object format$lzy1;
    public static final StatsdEncoder$ MODULE$;

    private StatsdEncoder$() {
    }

    static {
        MODULE$ = new StatsdEncoder$();
        BUF_PER_METRIC = 128;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StatsdEncoder$.class);
    }

    public int hashCode() {
        return 520522135;
    }

    public String toString() {
        return "StatsdEncoder";
    }

    public boolean canEqual(Object that) {
        return that instanceof StatsdEncoder$;
    }

    public int productArity() {
        return 0;
    }

    public String productPrefix() {
        return "StatsdEncoder";
    }

    public Object productElement(int n) {
        int n2 = n;
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public ZIO<Object, Throwable, Chunk<Object>> encode(MetricEvent event) {
        return ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$1 -> Chunk$.MODULE$.fromArray((Object)this.encodeEvent(event).toString().getBytes()), (Object)"zio.metrics.connectors.statsd.StatsdEncoder.encode(StatsdEncoder.scala:14)");
    }

    public StringBuilder encodeEvent(MetricEvent event) {
        StringBuilder stringBuilder;
        StringBuilder result = new StringBuilder(BUF_PER_METRIC);
        MetricState metricState = event.current();
        if (metricState instanceof MetricState.Counter) {
            MetricState.Counter counter = MetricState.Counter$.MODULE$.unapply((MetricState.Counter)metricState);
            double d = counter._1();
            stringBuilder = this.appendCounter(result, event);
        } else if (metricState instanceof MetricState.Gauge) {
            MetricState.Gauge g = (MetricState.Gauge)metricState;
            stringBuilder = this.appendGauge(result, (MetricKey<Object>)event.metricKey(), g);
        } else if (metricState instanceof MetricState.Histogram) {
            MetricState.Histogram h = (MetricState.Histogram)metricState;
            stringBuilder = this.appendHistogram(result, (MetricKey<Object>)event.metricKey(), h);
        } else if (metricState instanceof MetricState.Summary) {
            MetricState.Summary s = (MetricState.Summary)metricState;
            stringBuilder = this.appendSummary(result, (MetricKey<Object>)event.metricKey(), s);
        } else if (metricState instanceof MetricState.Frequency) {
            MetricState.Frequency f = (MetricState.Frequency)metricState;
            stringBuilder = this.appendFrequency(result, (MetricKey<Object>)event.metricKey(), f);
        } else {
            throw new MatchError((Object)metricState);
        }
        return result;
    }

    private StringBuilder appendCounter(StringBuilder buf, MetricEvent event) {
        double d;
        MetricEvent metricEvent = event;
        if (metricEvent instanceof MetricEvent.New) {
            MetricEvent.New new_ = MetricEvent.New$.MODULE$.unapply((MetricEvent.New)metricEvent);
            MetricKey metricKey = new_._1();
            MetricState metricState = new_._2();
            Instant instant = new_._3();
            MetricState current = metricState;
            d = ((MetricState.Counter)current).count();
        } else if (metricEvent instanceof MetricEvent.Unchanged) {
            MetricEvent.Unchanged unchanged = MetricEvent.Unchanged$.MODULE$.unapply((MetricEvent.Unchanged)metricEvent);
            MetricKey metricKey = unchanged._1();
            MetricState metricState = unchanged._2();
            Instant instant = unchanged._3();
            d = 0.0;
        } else if (metricEvent instanceof MetricEvent.Updated) {
            MetricEvent.Updated updated = MetricEvent.Updated$.MODULE$.unapply((MetricEvent.Updated)metricEvent);
            MetricKey metricKey = updated._1();
            MetricState metricState = updated._2();
            MetricState metricState2 = updated._3();
            Instant instant = updated._4();
            MetricState old = metricState;
            MetricState current = metricState2;
            d = ((MetricState.Counter)current).count() - ((MetricState.Counter)old).count();
        } else {
            throw new MatchError((Object)metricEvent);
        }
        double delta = d;
        return this.appendMetric(buf, event.metricKey().name(), (NonEmptyChunk<Object>)NonEmptyChunk$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)delta), (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[0])), "c", (Set<MetricLabel>)event.metricKey().tags(), (Seq<MetricLabel>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MetricLabel[0]));
    }

    private StringBuilder appendGauge(StringBuilder buf, MetricKey<Object> key, MetricState.Gauge g) {
        return this.appendMetric(buf, key.name(), (NonEmptyChunk<Object>)NonEmptyChunk$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)g.value()), (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[0])), "g", (Set<MetricLabel>)key.tags(), (Seq<MetricLabel>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MetricLabel[0]));
    }

    private StringBuilder appendHistogram(StringBuilder buf, MetricKey<Object> key, MetricState.Histogram h) {
        return (StringBuilder)h.buckets().foldLeft((Object)buf, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                StringBuilder cur = (StringBuilder)tuple2._1();
                if (tuple22 != null) {
                    double boundary = tuple22._1$mcD$sp();
                    long count = tuple22._2$mcJ$sp();
                    String bucket = boundary < Double.MAX_VALUE ? BoxesRunTime.boxToDouble((double)boundary).toString() : "Inf";
                    return this.appendMetric(cur, key.name(), (NonEmptyChunk<Object>)NonEmptyChunk$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Predef$.MODULE$.long2Long(count).doubleValue()), (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[0])), "g", (Set<MetricLabel>)key.tags(), (Seq<MetricLabel>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MetricLabel[]{MetricLabel$.MODULE$.apply("le", bucket)}));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private StringBuilder appendSummary(StringBuilder buf, MetricKey<Object> key, MetricState.Summary s) {
        return (StringBuilder)s.quantiles().foldLeft((Object)buf, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                StringBuilder cur = (StringBuilder)tuple2._1();
                if (tuple22 != null) {
                    double q = BoxesRunTime.unboxToDouble((Object)tuple22._1());
                    Option v = (Option)tuple22._2();
                    Option option = v;
                    if (None$.MODULE$.equals(option)) {
                        return cur;
                    }
                    if (option instanceof Some) {
                        double v2 = BoxesRunTime.unboxToDouble((Object)((Some)option).value());
                        return this.appendMetric(buf, key.name(), (NonEmptyChunk<Object>)NonEmptyChunk$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)v2), (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[0])), "g", (Set<MetricLabel>)key.tags(), (Seq<MetricLabel>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MetricLabel[]{MetricLabel$.MODULE$.apply("quantile", BoxesRunTime.boxToDouble((double)q).toString()), MetricLabel$.MODULE$.apply("error", BoxesRunTime.boxToDouble((double)s.error()).toString())}));
                    }
                    throw new MatchError((Object)option);
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private StringBuilder appendFrequency(StringBuilder buf, MetricKey<Object> key, MetricState.Frequency f) {
        return (StringBuilder)f.occurrences().foldLeft((Object)buf, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                StringBuilder cur = (StringBuilder)tuple2._1();
                if (tuple22 != null) {
                    String b = (String)tuple22._1();
                    long c = BoxesRunTime.unboxToLong((Object)tuple22._2());
                    return this.appendMetric(cur, key.name(), (NonEmptyChunk<Object>)NonEmptyChunk$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Predef$.MODULE$.long2Long(c).doubleValue()), (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[0])), "g", (Set<MetricLabel>)key.tags(), (Seq<MetricLabel>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MetricLabel[]{MetricLabel$.MODULE$.apply("bucket", b)}));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public StringBuilder appendMetric(StringBuilder buf, String name, NonEmptyChunk<Object> values, String metricType, Set<MetricLabel> tags, Seq<MetricLabel> extraTags) {
        StringBuilder tagBuf = new StringBuilder();
        StringBuilder withTags = this.appendTags(tagBuf, (Iterable<MetricLabel>)tags);
        StringBuilder withAllTags = this.appendTags(withTags, (Iterable<MetricLabel>)extraTags);
        StringBuilder withLF = buf.nonEmpty() ? buf.append("\n") : buf;
        StringBuilder withMetric = withLF.append(name).append(":");
        buf.append(this.format().format(BoxesRunTime.unboxToDouble((Object)NonEmptyChunk$.MODULE$.toChunk(values).head())));
        ((IterableOnceOps)NonEmptyChunk$.MODULE$.toChunk(values).tail()).foreach((Function1 & Serializable)value -> this.appendMetric$$anonfun$1(buf, BoxesRunTime.unboxToDouble((Object)value)));
        buf.append("|").append(metricType);
        if (withAllTags.nonEmpty()) {
            return withMetric.append("|#").append(tagBuf);
        }
        return withMetric;
    }

    private StringBuilder appendTag(StringBuilder buf, MetricLabel tag) {
        if (buf.nonEmpty()) {
            buf.append(",");
        }
        return buf.append(tag.key()).append(":").append(tag.value());
    }

    private StringBuilder appendTags(StringBuilder buf, Iterable<MetricLabel> tags) {
        return (StringBuilder)tags.foldLeft((Object)buf, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                StringBuilder cur = (StringBuilder)tuple2._1();
                MetricLabel tag = (MetricLabel)tuple2._2();
                return this.appendTag(cur, tag);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private DecimalFormat format() {
        Object object = this.format$lzy1;
        if (object instanceof DecimalFormat) {
            return (DecimalFormat)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DecimalFormat)this.format$lzyINIT1();
    }

    private Object format$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.format$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DecimalFormat decimalFormat = null;
                    try {
                        decimalFormat = new DecimalFormat("0.################");
                        object2 = decimalFormat == null ? LazyVals.NullValue$.MODULE$ : decimalFormat;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.format$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return decimalFormat;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private final /* synthetic */ StringBuilder appendMetric$$anonfun$1(StringBuilder buf$2, double value) {
        return buf$2.append(":").append(this.format().format(value));
    }
}

