/*
 * Decompiled with CFR 0.152.
 */
package zio.logging;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import zio.Cause$;
import zio.logging.LogAnnotation$;
import zio.logging.LogContext;
import zio.logging.LogFormat$;
import zio.logging.LogLevel;
import zio.logging.LogLevel$Debug$;
import zio.logging.LogLevel$Error$;
import zio.logging.LogLevel$Info$;
import zio.logging.LogLevel$Trace$;
import zio.logging.LogLevel$Warn$;

@ScalaSignature(bytes="\u0006\u0005\t=ca\u0002 @!\u0003\r\n\u0001\u0012\u0005\u0006\u0019\u00021\t!T\u0004\u0006Y~B\t!\u001c\u0004\u0006}}B\tA\u001c\u0005\u0006_\u000e!\t\u0001\u001d\u0005\bc\u000e\u0011\r\u0011\"\u0003s\u0011\u0019Q8\u0001)A\u0005g\u0016!1p\u0001\u0001}\u0011\u001d\t)a\u0001C\u0001\u0003\u000f1a!a\u0005\u0004\u0005\u0006U\u0001BCA\u0018\u0013\tU\r\u0011\"\u0001\u00022!Q\u00111G\u0005\u0003\u0012\u0003\u0006I!a\u0004\t\r=LA\u0011AA\u001b\u0011\u0019a\u0015\u0002\"\u0011\u0002<!I\u0011\u0011I\u0005\u0002\u0002\u0013\u0005\u00111\t\u0005\n\u0003\u000fJ\u0011\u0013!C\u0001\u0003\u0013B\u0001\"a\u0018\n\u0003\u0003%\tE\u001d\u0005\n\u0003CJ\u0011\u0011!C\u0001\u0003GB\u0011\"a\u001b\n\u0003\u0003%\t!!\u001c\t\u0013\u0005M\u0014\"!A\u0005B\u0005U\u0004\"CAB\u0013\u0005\u0005I\u0011AAC\u0011%\ty)CA\u0001\n\u0003\n\t\nC\u0005\u0002\u0016&\t\t\u0011\"\u0011\u0002\u0018\"I\u0011\u0011T\u0005\u0002\u0002\u0013\u0005\u00131\u0014\u0005\n\u0003;K\u0011\u0011!C!\u0003?;\u0011\"a)\u0004\u0003\u0003E\t!!*\u0007\u0013\u0005M1!!A\t\u0002\u0005\u001d\u0006BB8\u001b\t\u0003\ty\fC\u0005\u0002\u001aj\t\t\u0011\"\u0012\u0002\u001c\"I\u0011\u0011\u0019\u000e\u0002\u0002\u0013\u0005\u00151\u0019\u0005\n\u0003\u000fT\u0012\u0013!C\u0001\u0003\u0013B\u0011\"!3\u001b\u0003\u0003%\t)a3\t\u0013\u0005]'$%A\u0005\u0002\u0005%\u0003\"CAm5\u0005\u0005I\u0011BAn\r\u0019\t\u0019o\u0001\"\u0002f\"Q\u0011q\u001d\u0012\u0003\u0016\u0004%\t!!\r\t\u0015\u0005%(E!E!\u0002\u0013\ty\u0001\u0003\u0004pE\u0011\u0005\u00111\u001e\u0005\b\u0003c\u0014C\u0011BAz\u0011\u001d\tiP\tC\u0005\u0003\u007fDa\u0001\u0014\u0012\u0005\n\t=\u0001B\u0002'#\t\u0003\u0012\u0019\u0003C\u0005\u0002B\t\n\t\u0011\"\u0001\u0003*!I\u0011q\t\u0012\u0012\u0002\u0013\u0005\u0011\u0011\n\u0005\t\u0003?\u0012\u0013\u0011!C!e\"I\u0011\u0011\r\u0012\u0002\u0002\u0013\u0005\u00111\r\u0005\n\u0003W\u0012\u0013\u0011!C\u0001\u0005[A\u0011\"a\u001d#\u0003\u0003%\t%!\u001e\t\u0013\u0005\r%%!A\u0005\u0002\tE\u0002\"CAHE\u0005\u0005I\u0011\tB\u001b\u0011%\t)JIA\u0001\n\u0003\n9\nC\u0005\u0002\u001a\n\n\t\u0011\"\u0011\u0002\u001c\"I\u0011Q\u0014\u0012\u0002\u0002\u0013\u0005#\u0011H\u0004\n\u0005{\u0019\u0011\u0011!E\u0001\u0005\u007f1\u0011\"a9\u0004\u0003\u0003E\tA!\u0011\t\r=4D\u0011\u0001B#\u0011%\tIJNA\u0001\n\u000b\nY\nC\u0005\u0002BZ\n\t\u0011\"!\u0003H!I\u0011q\u0019\u001c\u0012\u0002\u0013\u0005\u0011\u0011\n\u0005\n\u0003\u00134\u0014\u0011!CA\u0005\u0017B\u0011\"a67#\u0003%\t!!\u0013\t\u0013\u0005eg'!A\u0005\n\u0005m'!\u0003'pO\u001a{'/\\1u\u0015\t\u0001\u0015)A\u0004m_\u001e<\u0017N\\4\u000b\u0003\t\u000b1A_5p\u0007\u0001)\"!R2\u0014\u0005\u00011\u0005CA$K\u001b\u0005A%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C%AB!osJ+g-\u0001\u0004g_Jl\u0017\r\u001e\u000b\u0004\u001df{\u0006CA(W\u001d\t\u0001F\u000b\u0005\u0002R\u00116\t!K\u0003\u0002T\u0007\u00061AH]8pizJ!!\u0016%\u0002\rA\u0013X\rZ3g\u0013\t9\u0006L\u0001\u0004TiJLgn\u001a\u0006\u0003+\"CQAW\u0001A\u0002m\u000bqaY8oi\u0016DH\u000f\u0005\u0002];6\tq(\u0003\u0002_\u007f\tQAj\\4D_:$X\r\u001f;\t\u000b\u0001\f\u0001\u0019A1\u0002\t1Lg.\u001a\t\u0003E\u000ed\u0001\u0001B\u0003e\u0001\t\u0007QMA\u0001B#\t1\u0017\u000e\u0005\u0002HO&\u0011\u0001\u000e\u0013\u0002\b\u001d>$\b.\u001b8h!\t9%.\u0003\u0002l\u0011\n\u0019\u0011I\\=\u0002\u00131{wMR8s[\u0006$\bC\u0001/\u0004'\t\u0019a)\u0001\u0004=S:LGO\u0010\u000b\u0002[\u0006\u0011a\nT\u000b\u0002gB\u0011A/_\u0007\u0002k*\u0011ao^\u0001\u0005Y\u0006twMC\u0001y\u0003\u0011Q\u0017M^1\n\u0005]+\u0018a\u0001(MA\tiA*\u001b8f\r>\u0014X.\u0019;uKJ\u0004RaR?\\\u007f:K!A %\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004\u0003B$\u0002\u00029K1!a\u0001I\u0005!a$-\u001f8b[\u0016t\u0014\u0001\u00044s_64UO\\2uS>tG\u0003BA\u0005\u0003\u0017\u00012\u0001\u0018\u0001O\u0011\u001d\ti\u0001\u0003a\u0001\u0003\u001f\t!A\u001a8\u0011\u0007\u0005Eq!D\u0001\u0004\u0005Y\u0019\u0016.\u001c9mK\u000e{gn]8mK2{wMR8s[\u0006$8\u0003C\u0005G\u0003\u0013\t9\"!\b\u0011\u0007\u001d\u000bI\"C\u0002\u0002\u001c!\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002 \u0005%b\u0002BA\u0011\u0003Kq1!UA\u0012\u0013\u0005I\u0015bAA\u0014\u0011\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0016\u0003[\u0011AbU3sS\u0006d\u0017N_1cY\u0016T1!a\nI\u0003\u001d1wN]7biB*\"!a\u0004\u0002\u0011\u0019|'/\\1ua\u0001\"B!a\u000e\u0002:A\u0019\u0011\u0011C\u0005\t\u0013\u0005=B\u0002%AA\u0002\u0005=A#\u0002(\u0002>\u0005}\u0002\"\u0002.\u000e\u0001\u0004Y\u0006\"\u00021\u000e\u0001\u0004q\u0015\u0001B2paf$B!a\u000e\u0002F!I\u0011q\u0006\b\u0011\u0002\u0003\u0007\u0011qB\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tYE\u000b\u0003\u0002\u0010\u000553FAA(!\u0011\t\t&a\u0017\u000e\u0005\u0005M#\u0002BA+\u0003/\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005e\u0003*\u0001\u0006b]:|G/\u0019;j_:LA!!\u0018\u0002T\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t)\u0007E\u0002H\u0003OJ1!!\u001bI\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rI\u0017q\u000e\u0005\n\u0003c\u0012\u0012\u0011!a\u0001\u0003K\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA<!\u0015\tI(a j\u001b\t\tYHC\u0002\u0002~!\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t)a\u001f\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u000f\u000bi\tE\u0002H\u0003\u0013K1!a#I\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u001d\u0015\u0003\u0003\u0005\r![\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\rF\u0002t\u0003'C\u0011\"!\u001d\u0016\u0003\u0003\u0005\r!!\u001a\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u001a\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a]\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u001d\u0015\u0011\u0015\u0005\t\u0003cB\u0012\u0011!a\u0001S\u000612+[7qY\u0016\u001cuN\\:pY\u0016dun\u001a$pe6\fG\u000fE\u0002\u0002\u0012i\u0019RAGAU\u0003k\u0003\u0002\"a+\u00022\u0006=\u0011qG\u0007\u0003\u0003[S1!a,I\u0003\u001d\u0011XO\u001c;j[\u0016LA!a-\u0002.\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0011\t\u0005]\u0016QX\u0007\u0003\u0003sS1!a/x\u0003\tIw.\u0003\u0003\u0002,\u0005eFCAAS\u0003\u0015\t\u0007\u000f\u001d7z)\u0011\t9$!2\t\u0013\u0005=R\u0004%AA\u0002\u0005=\u0011aD1qa2LH\u0005Z3gCVdG\u000fJ\u0019\u0002\u000fUt\u0017\r\u001d9msR!\u0011QZAj!\u00159\u0015qZA\b\u0013\r\t\t\u000e\u0013\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005Uw$!AA\u0002\u0005]\u0012a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!8\u0011\u0007Q\fy.C\u0002\u0002bV\u0014aa\u00142kK\u000e$(\u0001E\"pY>\u0014X\r\u001a'pO\u001a{'/\\1u'!\u0011c)!\u0003\u0002\u0018\u0005u\u0011A\u00037j]\u00164uN]7bi\u0006YA.\u001b8f\r>\u0014X.\u0019;!)\u0011\ti/a<\u0011\u0007\u0005E!\u0005C\u0005\u0002h\u0016\u0002\n\u00111\u0001\u0002\u0010\u0005Iq/\u001b;i\u0007>dwN\u001d\u000b\u0006\u001d\u0006U\u0018\u0011 \u0005\u0007\u0003o4\u0003\u0019\u0001(\u0002\u000b\r|Gn\u001c:\t\r\u0005mh\u00051\u0001O\u0003\u0005\u0019\u0018\u0001\u00045jO\"d\u0017n\u001a5u\u0019><G#\u0002(\u0003\u0002\t-\u0001b\u0002B\u0002O\u0001\u0007!QA\u0001\u0006Y\u00164X\r\u001c\t\u00049\n\u001d\u0011b\u0001B\u0005\u007f\tAAj\\4MKZ,G\u000e\u0003\u0004\u0003\u000e\u001d\u0002\rAT\u0001\b[\u0016\u001c8/Y4f)-q%\u0011\u0003B\n\u0005/\u0011IB!\b\t\u000b\u0001D\u0003\u0019\u0001(\t\r\tU\u0001\u00061\u0001O\u0003\u0011!\u0018.\\3\t\u000f\t\r\u0001\u00061\u0001\u0003\u0006!1!1\u0004\u0015A\u00029\u000b!\u0002\\8hO\u0016\u0014h*Y7f\u0011\u001d\u0011y\u0002\u000ba\u0001\u0005C\t!\"\\1zE\u0016,%O]8s!\u00119\u0015q\u001a(\u0015\u000b9\u0013)Ca\n\t\u000biK\u0003\u0019A.\t\u000b\u0001L\u0003\u0019\u0001(\u0015\t\u00055(1\u0006\u0005\n\u0003OT\u0003\u0013!a\u0001\u0003\u001f!2!\u001bB\u0018\u0011%\t\tHLA\u0001\u0002\u0004\t)\u0007\u0006\u0003\u0002\b\nM\u0002\u0002CA9a\u0005\u0005\t\u0019A5\u0015\u0007M\u00149\u0004C\u0005\u0002rE\n\t\u00111\u0001\u0002fQ!\u0011q\u0011B\u001e\u0011!\t\t\bNA\u0001\u0002\u0004I\u0017\u0001E\"pY>\u0014X\r\u001a'pO\u001a{'/\\1u!\r\t\tBN\n\u0006m\t\r\u0013Q\u0017\t\t\u0003W\u000b\t,a\u0004\u0002nR\u0011!q\b\u000b\u0005\u0003[\u0014I\u0005C\u0005\u0002hf\u0002\n\u00111\u0001\u0002\u0010Q!\u0011Q\u001aB'\u0011%\t)nOA\u0001\u0002\u0004\ti\u000f")
public interface LogFormat<A> {
    public static LogFormat<String> fromFunction(Function2<LogContext, Function0<String>, String> function2) {
        return LogFormat$.MODULE$.fromFunction(function2);
    }

    public String format(LogContext var1, A var2);

    public static final class ColoredLogFormat
    implements LogFormat<String>,
    Product,
    Serializable {
        private final Function2<LogContext, Function0<String>, String> lineFormat;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Function2<LogContext, Function0<String>, String> lineFormat() {
            return this.lineFormat;
        }

        private String withColor(String color, String s) {
            return new StringBuilder(4).append(color).append(s).append("\u001b[0m").toString();
        }

        private String highlightLog(LogLevel level, String message) {
            LogLevel logLevel = level;
            String string = LogLevel$Error$.MODULE$.equals(logLevel) ? "\u001b[31m" : (LogLevel$Warn$.MODULE$.equals(logLevel) ? "\u001b[33m" : (LogLevel$Info$.MODULE$.equals(logLevel) ? "\u001b[36m" : (LogLevel$Debug$.MODULE$.equals(logLevel) ? "\u001b[32m" : (LogLevel$Trace$.MODULE$.equals(logLevel) ? "\u001b[35m" : "\u001b[0m"))));
            String color = string;
            return this.withColor(color, message);
        }

        private String format(String line, String time, LogLevel level, String loggerName, Option<String> maybeError) {
            String logTime;
            String logTag = this.highlightLog(level, level.render());
            String arg$macro$1 = logTime = this.withColor("\u001b[34m", time);
            String arg$macro$2 = logTag;
            String arg$macro$3 = this.withColor("\u001b[37m", loggerName);
            String arg$macro$4 = this.highlightLog(level, line);
            String logMsg = StringOps$.MODULE$.format$extension("%s %14s [%s] %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, arg$macro$3, arg$macro$4}));
            return (String)maybeError.fold((Function0 & Serializable)() -> logMsg, (Function1 & Serializable)err -> new StringBuilder(0).append(logMsg).append(LogFormat$.MODULE$.zio$logging$LogFormat$$NL()).append(this.highlightLog(level, (String)err)).toString());
        }

        @Override
        public String format(LogContext context, String line) {
            String date = context.apply(LogAnnotation$.MODULE$.Timestamp());
            LogLevel level = context.get(LogAnnotation$.MODULE$.Level());
            String loggerName = context.apply(LogAnnotation$.MODULE$.Name());
            Option maybeError = context.get(LogAnnotation$.MODULE$.Throwable()).map((Function1 & Serializable)error -> Cause$.MODULE$.fail(error)).orElse((Function0 & Serializable)() -> context.get(LogAnnotation$.MODULE$.Cause())).map((Function1 & Serializable)x$3 -> x$3.prettyPrint());
            return this.format((String)this.lineFormat().apply((Object)context, (Function0 & Serializable)() -> line), date, level, loggerName, (Option<String>)maybeError);
        }

        public ColoredLogFormat copy(Function2<LogContext, Function0<String>, String> lineFormat) {
            return new ColoredLogFormat(lineFormat);
        }

        public Function2<LogContext, Function0<String>, String> copy$default$1() {
            return this.lineFormat();
        }

        public String productPrefix() {
            return "ColoredLogFormat";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.lineFormat();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ColoredLogFormat;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "lineFormat";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ColoredLogFormat)) return false;
            boolean bl = true;
            if (!bl) return false;
            ColoredLogFormat coloredLogFormat = (ColoredLogFormat)x$1;
            Function2<LogContext, Function0<String>, String> function2 = this.lineFormat();
            Function2<LogContext, Function0<String>, String> function22 = coloredLogFormat.lineFormat();
            if (function2 != null) {
                if (!function2.equals(function22)) return false;
                return true;
            }
            if (function22 == null) return true;
            return false;
        }

        public ColoredLogFormat(Function2<LogContext, Function0<String>, String> lineFormat) {
            this.lineFormat = lineFormat;
            Product.$init$((Product)this);
        }
    }

    public static final class SimpleConsoleLogFormat
    implements LogFormat<String>,
    Product,
    Serializable {
        private final Function2<LogContext, Function0<String>, String> format0;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Function2<LogContext, Function0<String>, String> format0() {
            return this.format0;
        }

        @Override
        public String format(LogContext context, String line) {
            String date = context.apply(LogAnnotation$.MODULE$.Timestamp());
            String level = context.apply(LogAnnotation$.MODULE$.Level());
            String loggerName = context.apply(LogAnnotation$.MODULE$.Name());
            String maybeError = (String)context.get(LogAnnotation$.MODULE$.Throwable()).map((Function1 & Serializable)error -> Cause$.MODULE$.fail(error)).orElse((Function0 & Serializable)() -> context.get(LogAnnotation$.MODULE$.Cause())).map((Function1 & Serializable)cause -> new StringBuilder(0).append(LogFormat$.MODULE$.zio$logging$LogFormat$$NL()).append(cause.prettyPrint()).toString()).getOrElse((Function0 & Serializable)() -> "");
            return new StringBuilder(4).append(date).append(" ").append(level).append(" ").append(loggerName).append(" ").append(this.format0().apply((Object)context, (Function0 & Serializable)() -> line)).append(" ").append(maybeError).toString();
        }

        public SimpleConsoleLogFormat copy(Function2<LogContext, Function0<String>, String> format0) {
            return new SimpleConsoleLogFormat(format0);
        }

        public Function2<LogContext, Function0<String>, String> copy$default$1() {
            return this.format0();
        }

        public String productPrefix() {
            return "SimpleConsoleLogFormat";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.format0();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SimpleConsoleLogFormat;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "format0";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SimpleConsoleLogFormat)) return false;
            boolean bl = true;
            if (!bl) return false;
            SimpleConsoleLogFormat simpleConsoleLogFormat = (SimpleConsoleLogFormat)x$1;
            Function2<LogContext, Function0<String>, String> function2 = this.format0();
            Function2<LogContext, Function0<String>, String> function22 = simpleConsoleLogFormat.format0();
            if (function2 != null) {
                if (!function2.equals(function22)) return false;
                return true;
            }
            if (function22 == null) return true;
            return false;
        }

        public SimpleConsoleLogFormat(Function2<LogContext, Function0<String>, String> format0) {
            this.format0 = format0;
            Product.$init$((Product)this);
        }
    }
}

