/*
 * Decompiled with CFR 0.152.
 */
package zio.logging;

import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import zio.Cause;
import zio.Exit;
import zio.Fiber;
import zio.FiberId;
import zio.FiberRef;
import zio.FiberRef$;
import zio.FiberRefs;
import zio.LogLevel;
import zio.LogLevel$;
import zio.LogSpan;
import zio.Queue;
import zio.Queue$;
import zio.Runtime$;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZIOAspect;
import zio.ZIOAspect$;
import zio.ZLayer;
import zio.ZLayer$;
import zio.ZLogger;
import zio.Zippable;
import zio.logging.LogContext;
import zio.logging.LogContext$;
import zio.logging.LogFilter;
import zio.logging.LogFilter$;
import zio.logging.LogFormat;
import zio.logging.LogFormat$;
import zio.logging.internal.FileWriter;
import zio.metrics.Metric;
import zio.metrics.Metric$;
import zio.metrics.MetricKeyType$Counter$;
import zio.metrics.MetricLabel;
import zio.metrics.MetricState;
import zio.package;

public final class package$ {
    public static package$ MODULE$;
    private final FiberRef<LogContext> logContext;
    private final String loggerNameAnnotationKey;
    private final String logLevelMetricLabel;
    private final Metric<MetricKeyType$Counter$, Object, MetricState.Counter> loggedTotalMetric;
    private final ZLayer<Object, Nothing$, BoxedUnit> removeDefaultLoggers;
    private final ZLayer<Object, Nothing$, BoxedUnit> logMetrics;

    static {
        new package$();
    }

    public FiberRef<LogContext> logContext() {
        return this.logContext;
    }

    public String loggerNameAnnotationKey() {
        return this.loggerNameAnnotationKey;
    }

    public String logLevelMetricLabel() {
        return this.logLevelMetricLabel;
    }

    public Metric<MetricKeyType$Counter$, Object, MetricState.Counter> loggedTotalMetric() {
        return this.loggedTotalMetric;
    }

    public ZIOAspect<Nothing$, Object, Nothing$, Object, Nothing$, Object> loggerName(String value) {
        return ZIOAspect$.MODULE$.annotated(this.loggerNameAnnotationKey(), value);
    }

    public ZLayer<Object, Nothing$, BoxedUnit> console(LogFormat format, LogLevel logLevel) {
        return this.console(format, LogFilter$.MODULE$.logLevel(logLevel));
    }

    public ZLayer<Object, Nothing$, BoxedUnit> console(LogFormat format, LogFilter<String> logFilter) {
        return this.makeConsole(format.toLogger(), System.out, logFilter);
    }

    public LogFormat console$default$1() {
        return LogFormat$.MODULE$.colored();
    }

    public LogLevel console$default$2() {
        return LogLevel$.MODULE$.Info();
    }

    public ZLayer<Object, Nothing$, BoxedUnit> consoleJson(LogFormat format, LogLevel logLevel) {
        return this.consoleJson(format, LogFilter$.MODULE$.logLevel(logLevel));
    }

    public ZLayer<Object, Nothing$, BoxedUnit> consoleJson(LogFormat format, LogFilter<String> logFilter) {
        return this.makeConsole(format.toJsonLogger(), System.out, logFilter);
    }

    public LogFormat consoleJson$default$1() {
        return LogFormat$.MODULE$.default();
    }

    public LogLevel consoleJson$default$2() {
        return LogLevel$.MODULE$.Info();
    }

    public ZLayer<Object, Nothing$, BoxedUnit> consoleErr(LogFormat format, LogLevel logLevel) {
        return this.consoleErr(format, LogFilter$.MODULE$.logLevel(logLevel));
    }

    public ZLayer<Object, Nothing$, BoxedUnit> consoleErr(LogFormat format, LogFilter<String> logFilter) {
        return this.makeConsole(format.toLogger(), System.err, logFilter);
    }

    public LogFormat consoleErr$default$1() {
        return LogFormat$.MODULE$.default();
    }

    public LogLevel consoleErr$default$2() {
        return LogLevel$.MODULE$.Info();
    }

    public ZLayer<Object, Nothing$, BoxedUnit> consoleErrJson(LogFormat format, LogLevel logLevel) {
        return this.consoleErrJson(format, LogFilter$.MODULE$.logLevel(logLevel));
    }

    public ZLayer<Object, Nothing$, BoxedUnit> consoleErrJson(LogFormat format, LogFilter<String> logFilter) {
        return this.makeConsole(format.toJsonLogger(), System.err, logFilter);
    }

    public LogFormat consoleErrJson$default$1() {
        return LogFormat$.MODULE$.default();
    }

    public LogLevel consoleErrJson$default$2() {
        return LogLevel$.MODULE$.Info();
    }

    public ZLayer<Object, Nothing$, BoxedUnit> file(Path destination, LogFormat format, LogLevel logLevel, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize) {
        return this.file(destination, format, LogFilter$.MODULE$.logLevel(logLevel), charset, autoFlushBatchSize, bufferedIOSize);
    }

    public ZLayer<Object, Nothing$, BoxedUnit> file(Path destination, LogFormat format, LogFilter<String> logFilter, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize) {
        return Runtime$.MODULE$.addLogger(this.makeStringLogger(destination, format.toLogger(), logFilter, charset, autoFlushBatchSize, bufferedIOSize), (Object)"zio.logging.package.file(package.scala:132)");
    }

    public LogFormat file$default$2() {
        return LogFormat$.MODULE$.default();
    }

    public LogLevel file$default$3() {
        return LogLevel$.MODULE$.Info();
    }

    public Charset file$default$4() {
        return StandardCharsets.UTF_8;
    }

    public int file$default$5() {
        return 1;
    }

    public Option<Object> file$default$6() {
        return None$.MODULE$;
    }

    public ZLayer<Object, Nothing$, BoxedUnit> fileJson(Path destination, LogFormat format, LogLevel logLevel, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize) {
        return this.fileJson(destination, format, LogFilter$.MODULE$.logLevel(logLevel), charset, autoFlushBatchSize, bufferedIOSize);
    }

    public ZLayer<Object, Nothing$, BoxedUnit> fileJson(Path destination, LogFormat format, LogFilter<String> logFilter, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize) {
        return Runtime$.MODULE$.addLogger(this.makeStringLogger(destination, format.toJsonLogger(), logFilter, charset, autoFlushBatchSize, bufferedIOSize), (Object)"zio.logging.package.fileJson(package.scala:161)");
    }

    public LogFormat fileJson$default$2() {
        return LogFormat$.MODULE$.default();
    }

    public LogLevel fileJson$default$3() {
        return LogLevel$.MODULE$.Info();
    }

    public Charset fileJson$default$4() {
        return StandardCharsets.UTF_8;
    }

    public int fileJson$default$5() {
        return 1;
    }

    public Option<Object> fileJson$default$6() {
        return None$.MODULE$;
    }

    public ZLayer<Object, Nothing$, BoxedUnit> fileAsync(Path destination, LogFormat format, LogLevel logLevel, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize) {
        return this.fileAsync(destination, format, LogFilter$.MODULE$.logLevel(logLevel), charset, autoFlushBatchSize, bufferedIOSize);
    }

    public ZLayer<Object, Nothing$, BoxedUnit> fileAsync(Path destination, LogFormat format, LogFilter<String> logFilter, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize) {
        return this.makeFileAsync(destination, format.toLogger(), logFilter, charset, autoFlushBatchSize, bufferedIOSize);
    }

    public LogFormat fileAsync$default$2() {
        return LogFormat$.MODULE$.default();
    }

    public LogLevel fileAsync$default$3() {
        return LogLevel$.MODULE$.Info();
    }

    public Charset fileAsync$default$4() {
        return StandardCharsets.UTF_8;
    }

    public int fileAsync$default$5() {
        return 1;
    }

    public Option<Object> fileAsync$default$6() {
        return None$.MODULE$;
    }

    public ZLayer<Object, Nothing$, BoxedUnit> fileAsyncJson(Path destination, LogFormat format, LogLevel logLevel, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize) {
        return this.fileAsyncJson(destination, format, LogFilter$.MODULE$.logLevel(logLevel), charset, autoFlushBatchSize, bufferedIOSize);
    }

    public ZLayer<Object, Nothing$, BoxedUnit> fileAsyncJson(Path destination, LogFormat format, LogFilter<String> logFilter, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize) {
        return this.makeFileAsync(destination, format.toJsonLogger(), logFilter, charset, autoFlushBatchSize, bufferedIOSize);
    }

    public LogFormat fileAsyncJson$default$2() {
        return LogFormat$.MODULE$.default();
    }

    public LogLevel fileAsyncJson$default$3() {
        return LogLevel$.MODULE$.Info();
    }

    public Charset fileAsyncJson$default$4() {
        return StandardCharsets.UTF_8;
    }

    public int fileAsyncJson$default$5() {
        return 1;
    }

    public Option<Object> fileAsyncJson$default$6() {
        return None$.MODULE$;
    }

    public ZLayer<Object, Nothing$, BoxedUnit> removeDefaultLoggers() {
        return this.removeDefaultLoggers;
    }

    private ZLayer<Object, Nothing$, BoxedUnit> makeConsole(ZLogger<String, String> logger, PrintStream stream, LogFilter<String> logFilter) {
        ZLogger stringLogger = logFilter.filter(logger.map((Function1 & Serializable & scala.Serializable)line -> {
            package$.$anonfun$makeConsole$1(stream, line);
            return BoxedUnit.UNIT;
        }));
        return Runtime$.MODULE$.addLogger(stringLogger, (Object)"zio.logging.package.makeConsole(package.scala:256)");
    }

    private ZLogger<String, Object> makeStringLogger(Path destination, ZLogger<String, String> logger, LogFilter<String> logFilter, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize) {
        FileWriter logWriter = new FileWriter(destination, charset, autoFlushBatchSize, bufferedIOSize);
        return logFilter.filter(logger.map((Function1 & Serializable & scala.Serializable)line -> {
            package$.$anonfun$makeStringLogger$1(logWriter, line);
            return BoxedUnit.UNIT;
        }));
    }

    private ZLayer<Object, Nothing$, BoxedUnit> makeFileAsync(Path destination, ZLogger<String, String> logger, LogFilter<String> logFilter, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize) {
        return ZLayer.ScopedPartiallyApplied$.MODULE$.apply$extension(ZLayer$.MODULE$.scoped(), (Function0 & Serializable & scala.Serializable)() -> Queue$.MODULE$.bounded((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1000, (Object)"zio.logging.package.makeFileAsync(package.scala:290)").map((Function1 & Serializable & scala.Serializable)queue -> {
            ZLogger<String, Object> stringLogger = MODULE$.makeAsyncStringLogger(destination, logger, logFilter, charset, autoFlushBatchSize, bufferedIOSize, (Queue<ZIO<Object, Nothing$, Object>>)queue);
            return new Tuple2(queue, stringLogger);
        }, (Object)"zio.logging.package.makeFileAsync(package.scala:290)").flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
            if (x$2 != null) {
                Queue queue = (Queue)x$2._1();
                ZLogger stringLogger = (ZLogger)x$2._2();
                return FiberRef$.MODULE$.currentLoggers().locallyScopedWith((Function1 & Serializable & scala.Serializable)x$1 -> (Set)x$1.$plus((Object)stringLogger), (Object)"zio.logging.package.makeFileAsync(package.scala:293)").flatMap((Function1 & Serializable & scala.Serializable)_2 -> queue.take((Object)"zio.logging.package.makeFileAsync(package.scala:294)").flatMap((Function1 & Serializable & scala.Serializable)task -> task.ignore((Object)"zio.logging.package.makeFileAsync(package.scala:294)"), (Object)"zio.logging.package.makeFileAsync(package.scala:294)").forever((Object)"zio.logging.package.makeFileAsync(package.scala:294)").forkScoped((Object)"zio.logging.package.makeFileAsync(package.scala:294)").map((Function1 & Serializable & scala.Serializable)_ -> {
                    package$.$anonfun$makeFileAsync$8(_);
                    return BoxedUnit.UNIT;
                }, (Object)"zio.logging.package.makeFileAsync(package.scala:294)"), (Object)"zio.logging.package.makeFileAsync(package.scala:293)");
            }
            throw new MatchError(null);
        }, (Object)"zio.logging.package.makeFileAsync(package.scala:290)"), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(BoxedUnit.class, LightTypeTag$.MODULE$.parse(1191865462, "\u0004\u0000\u0001\nscala.Unit\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\nscala.Unit\u0001\u0001\u0001\u0004\u0000\u0001\fscala.AnyVal\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001", 21))), (Object)"zio.logging.package.makeFileAsync(package.scala:288)");
    }

    private ZLogger<String, Object> makeAsyncStringLogger(Path destination, ZLogger<String, String> logger, LogFilter<String> logFilter, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize, Queue<ZIO<Object, Nothing$, Object>> queue) {
        FileWriter logWriter = new FileWriter(destination, charset, autoFlushBatchSize, bufferedIOSize);
        return logFilter.filter(logger.map((Function1 & Serializable & scala.Serializable)line -> (Exit)Unsafe$.MODULE$.unsafe((Function1 & Serializable & scala.Serializable)u -> Runtime$.MODULE$.default().unsafe().run(queue.offer((Object)ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> {
            try {
                logWriter.writeln((String)line);
                return BoxedUnit.UNIT;
            }
            catch (VirtualMachineError virtualMachineError) {
                throw virtualMachineError;
            }
            catch (Throwable throwable) {
                return BoxedUnit.UNIT;
            }
        }, (Object)"zio.logging.package.makeAsyncStringLogger.stringLogger(package.scala:311)"), (Object)"zio.logging.package.makeAsyncStringLogger.stringLogger(package.scala:311)"), (Object)"zio.logging.package.makeAsyncStringLogger.stringLogger(package.scala:311)", u))));
    }

    private ZLogger<String, BoxedUnit> metricLogger(Metric<MetricKeyType$Counter$, Object, MetricState.Counter> counter, String logLevelLabel) {
        return new ZLogger<String, BoxedUnit>(counter, logLevelLabel){
            private final Metric counter$1;
            private final String logLevelLabel$1;

            public <M extends String, O> ZLogger<M, Object> $plus$plus(ZLogger<M, O> that, Zippable<BoxedUnit, O> zippable) {
                return ZLogger.$plus$plus$((ZLogger)this, that, zippable);
            }

            public <M extends String, O> ZLogger<M, O> $plus$greater(ZLogger<M, O> that) {
                return ZLogger.$plus$greater$((ZLogger)this, that);
            }

            public <M extends String> ZLogger<M, BoxedUnit> $less$plus(ZLogger<M, Object> that) {
                return ZLogger.$less$plus$((ZLogger)this, that);
            }

            public final <Message1> ZLogger<Message1, BoxedUnit> contramap(Function1<Message1, String> f) {
                return ZLogger.contramap$((ZLogger)this, f);
            }

            public final ZLogger<String, Option<BoxedUnit>> filterLogLevel(Function1<LogLevel, Object> f) {
                return ZLogger.filterLogLevel$((ZLogger)this, f);
            }

            public final <B> ZLogger<String, B> map(Function1<BoxedUnit, B> f) {
                return ZLogger.map$((ZLogger)this, f);
            }

            public final Object test(Function0 input) {
                return ZLogger.test$((ZLogger)this, (Function0)input);
            }

            public void apply(Object trace, FiberId fiberId, LogLevel logLevel, Function0<String> message, Cause<Object> cause, FiberRefs context, List<LogSpan> spans, Map<String, String> annotations) {
                Set tags = (Set)context.get(FiberRef$.MODULE$.currentTags()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
                this.counter$1.unsafe().update((Object)BoxesRunTime.boxToLong((long)1L), (Set)tags.$plus((Object)new MetricLabel(this.logLevelLabel$1, logLevel.label().toLowerCase())), Unsafe$.MODULE$.unsafe());
            }
            {
                this.counter$1 = counter$1;
                this.logLevelLabel$1 = logLevelLabel$1;
                ZLogger.$init$((ZLogger)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$1()}, serializedLambda);
            }
        };
    }

    public ZLayer<Object, Nothing$, BoxedUnit> logMetrics() {
        return this.logMetrics;
    }

    public ZLayer<Object, Nothing$, BoxedUnit> logMetricsWith(String name, String logLevelLabel) {
        return Runtime$.MODULE$.addLogger(this.metricLogger((Metric<MetricKeyType$Counter$, Object, MetricState.Counter>)Metric$.MODULE$.counter(name), logLevelLabel), (Object)"zio.logging.package.logMetricsWith(package.scala:344)");
    }

    public static final /* synthetic */ void $anonfun$makeConsole$1(PrintStream stream$1, String line) {
        try {
            stream$1.println(line);
            return;
        }
        catch (VirtualMachineError virtualMachineError) {
            throw virtualMachineError;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$makeStringLogger$1(FileWriter logWriter$1, String line) {
        try {
            logWriter$1.writeln(line);
            return;
        }
        catch (VirtualMachineError virtualMachineError) {
            throw virtualMachineError;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$makeFileAsync$8(Fiber.Runtime _) {
    }

    private package$() {
        MODULE$ = this;
        this.logContext = (FiberRef)Unsafe$.MODULE$.unsafe((Function1 & Serializable & scala.Serializable)u -> FiberRef.unsafe$.MODULE$.make((Object)LogContext$.MODULE$.empty(), ZIO$.MODULE$.identityFn(), (Function2 & Serializable & scala.Serializable)(old, newV) -> old.$plus$plus((LogContext)newV), u));
        this.loggerNameAnnotationKey = "logger_name";
        this.logLevelMetricLabel = "level";
        this.loggedTotalMetric = Metric$.MODULE$.counter("zio_log_total");
        this.removeDefaultLoggers = Runtime$.MODULE$.removeDefaultLoggers();
        this.logMetrics = Runtime$.MODULE$.addLogger(this.metricLogger(this.loggedTotalMetric(), this.logLevelMetricLabel()), (Object)"zio.logging.package.logMetrics(package.scala:341)");
    }
}

