/*
 * Decompiled with CFR 0.152.
 */
package zio.logging.internal;

import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.java8.JFunction0;

public final class JsonValidator$ {
    public static JsonValidator$ MODULE$;
    private final boolean OBJECT;
    private final boolean ARRAY;
    private final int NOT_A_JSON;
    private final byte STATE_EXPECTING_VALUE;
    private final byte STATE_BLOCK_START;
    private final byte STATE_VALUE_PROCESSED;
    private final byte STATE_BLOCK_END;
    private final boolean[] zio$logging$internal$JsonValidator$$whitespaceLookup;

    static {
        new JsonValidator$();
    }

    public boolean isJson(String string) {
        int startIdx = this.stringCouldBeJson(string);
        if (startIdx == this.NOT_A_JSON()) {
            return false;
        }
        return this.checkJson(string, startIdx, this.STATE_EXPECTING_VALUE(), StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(string), startIdx) == '{' ? this.OBJECT() : this.ARRAY()) == string.length();
    }

    private int checkJson(String string, int startIdx, byte startState, boolean blockType) {
        int idx = startIdx;
        byte state = startState;
        while (state != this.STATE_BLOCK_END() && idx < string.length()) {
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(string), idx);
            if (this.isWhitespace(c)) {
                ++idx;
                continue;
            }
            if (state == this.STATE_EXPECTING_VALUE()) {
                idx = c == '{' ? this.checkJson(string, idx + 1, this.STATE_BLOCK_START(), this.OBJECT()) : (c == '[' ? this.checkJson(string, idx + 1, this.STATE_BLOCK_START(), this.ARRAY()) : this.skipSimpleValue(string, idx));
                state = this.STATE_VALUE_PROCESSED();
                continue;
            }
            if (state == this.STATE_VALUE_PROCESSED()) {
                if (c == ',' && blockType == this.OBJECT()) {
                    idx = this.handleObjectKey(string, this.skipWhitespaces(string, idx + 1));
                    state = this.STATE_EXPECTING_VALUE();
                    continue;
                }
                if (c == ',' && blockType == this.ARRAY()) {
                    ++idx;
                    state = this.STATE_EXPECTING_VALUE();
                    continue;
                }
                if (c == '}' && blockType == this.OBJECT() || c == ']' && blockType == this.ARRAY()) {
                    ++idx;
                    state = this.STATE_BLOCK_END();
                    continue;
                }
                idx = this.NOT_A_JSON();
                continue;
            }
            if (state == this.STATE_BLOCK_START()) {
                if (c == '}' && blockType == this.OBJECT() || c == ']' && blockType == this.ARRAY()) {
                    ++idx;
                    state = this.STATE_BLOCK_END();
                    continue;
                }
                if (blockType == this.OBJECT()) {
                    idx = this.handleObjectKey(string, this.skipWhitespaces(string, idx));
                    state = this.STATE_EXPECTING_VALUE();
                    continue;
                }
                state = this.STATE_EXPECTING_VALUE();
                continue;
            }
            idx = this.NOT_A_JSON();
        }
        return idx;
    }

    private int skipSimpleValue(String string, int startIdx) {
        if (startIdx < string.length()) {
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(string), startIdx);
            if (c == '\"') {
                return this.skipString(string, startIdx);
            }
            if (this.isDigit(c) || c == '-') {
                return this.skipNumber(string, startIdx);
            }
            if (c == 'f' || c == 'n' || c == 't') {
                return this.skipBooleanOrNull(string, startIdx);
            }
            return this.NOT_A_JSON();
        }
        return this.NOT_A_JSON();
    }

    private int handleObjectKey(String string, int startIdx) {
        int idx = this.skipWhitespaces(string, this.skipString(string, startIdx));
        if (idx < string.length() && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(string), idx) == ':') {
            return idx + 1;
        }
        return this.NOT_A_JSON();
    }

    private int stringCouldBeJson(String string) {
        int idxStart = this.skipWhitespaces(string, 0);
        int idxEnd = this.skipWhitespacesBackwards(string, string.length() - 1);
        if (idxStart >= string.length() || idxEnd <= 0) {
            return this.NOT_A_JSON();
        }
        if (string.charAt(idxStart) == '{' & string.charAt(idxEnd) == '}') {
            return idxStart;
        }
        if (string.charAt(idxStart) == '[' & string.charAt(idxEnd) == ']') {
            return idxStart;
        }
        return this.NOT_A_JSON();
    }

    private int skipBooleanOrNull(String string, int idx) {
        boolean fifthIsE;
        if (idx + 3 >= string.length()) {
            return this.NOT_A_JSON();
        }
        char c1 = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(string), idx);
        char c2 = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(string), idx + 1);
        char c3 = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(string), idx + 2);
        char c4 = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(string), idx + 3);
        boolean bl = fifthIsE = idx + 4 < string.length() && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(string), idx + 4) == 'e';
        if (c1 == 't' && c2 == 'r' && c3 == 'u' && c4 == 'e') {
            return idx + 4;
        }
        if (c1 == 'f' && c2 == 'a' && c3 == 'l' && c4 == 's' && fifthIsE) {
            return idx + 5;
        }
        if (c1 == 'n' && c2 == 'u' && c3 == 'l' && c4 == 'l') {
            return idx + 4;
        }
        return this.NOT_A_JSON();
    }

    private int skipString(String string, int startIdx) {
        if (startIdx < string.length() && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(string), startIdx) == '\"') {
            return this.inner$1(string, startIdx + 1, false);
        }
        return this.NOT_A_JSON();
    }

    private int skipWhitespaces(String string, int idx) {
        while (true) {
            if (idx >= string.length()) {
                return this.NOT_A_JSON();
            }
            if (!this.isWhitespace(string.charAt(idx))) break;
            ++idx;
        }
        return idx;
    }

    private boolean isWhitespace(char c) {
        return c <= ' ' && this.zio$logging$internal$JsonValidator$$whitespaceLookup()[c];
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private int skipWhitespacesBackwards(String string, int idx) {
        while (idx < string.length() && idx > 0) {
            if (!this.isWhitespace(string.charAt(idx))) {
                return idx;
            }
            --idx;
        }
        return idx;
    }

    private int skipDigits(String string, int idx) {
        while (idx < string.length()) {
            if (!this.isDigit(string.charAt(idx))) {
                return idx;
            }
            ++idx;
        }
        return this.NOT_A_JSON();
    }

    private int skipExponentPart(String string, int startIdx) {
        if (startIdx < string.length() && (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(string), startIdx) == 'e' || StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(string), startIdx) == 'E')) {
            int idxOfDigitMaybe;
            char c;
            int n = startIdx + 1 < string.length() ? ((c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(string), startIdx + 1)) == '-' | c == '+' ? startIdx + 2 : startIdx + 1) : (idxOfDigitMaybe = this.NOT_A_JSON());
            if (idxOfDigitMaybe < string.length() && this.isDigit(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(string), idxOfDigitMaybe))) {
                return this.skipDigits(string, idxOfDigitMaybe + 1);
            }
            return this.NOT_A_JSON();
        }
        return startIdx;
    }

    private int skipFractionPart(String string, int startIdx) {
        if (startIdx < string.length() && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(string), startIdx) == '.') {
            int digitSkippedIdx = this.skipDigits(string, startIdx + 1);
            if (digitSkippedIdx == startIdx + 1) {
                return this.NOT_A_JSON();
            }
            return digitSkippedIdx;
        }
        return startIdx;
    }

    private int skipNumber(String string, int startIdx) {
        return this.inner$2(string, startIdx, true);
    }

    private boolean OBJECT() {
        return this.OBJECT;
    }

    private boolean ARRAY() {
        return this.ARRAY;
    }

    private int NOT_A_JSON() {
        return this.NOT_A_JSON;
    }

    private byte STATE_EXPECTING_VALUE() {
        return this.STATE_EXPECTING_VALUE;
    }

    private byte STATE_BLOCK_START() {
        return this.STATE_BLOCK_START;
    }

    private byte STATE_VALUE_PROCESSED() {
        return this.STATE_VALUE_PROCESSED;
    }

    private byte STATE_BLOCK_END() {
        return this.STATE_BLOCK_END;
    }

    public boolean[] zio$logging$internal$JsonValidator$$whitespaceLookup() {
        return this.zio$logging$internal$JsonValidator$$whitespaceLookup;
    }

    private final int inner$1(String string, int idx, boolean isBackslashed) {
        while (idx < string.length()) {
            if (!isBackslashed && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(string), idx) == '\"') {
                return idx + 1;
            }
            isBackslashed = !isBackslashed && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(string), idx) == '\\';
            ++idx;
        }
        return this.NOT_A_JSON();
    }

    private final int inner$2(String string, int startIdx, boolean minusAllowed) {
        char c;
        int idxFractionPart = startIdx < string.length() ? ((c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(string), startIdx)) == '0' ? startIdx + 1 : (this.isDigit(c) ? this.skipDigits(string, startIdx + 1) : (c == '-' && minusAllowed ? this.inner$2(string, startIdx + 1, false) : this.NOT_A_JSON()))) : this.NOT_A_JSON();
        return this.skipExponentPart(string, this.skipFractionPart(string, idxFractionPart));
    }

    /*
     * WARNING - void declaration
     */
    private JsonValidator$() {
        void var1_1;
        MODULE$ = this;
        this.OBJECT = false;
        this.ARRAY = true;
        this.NOT_A_JSON = Integer.MAX_VALUE;
        this.STATE_EXPECTING_VALUE = 0;
        this.STATE_BLOCK_START = 1;
        this.STATE_VALUE_PROCESSED = (byte)2;
        this.STATE_BLOCK_END = (byte)3;
        boolean[] lookup = (boolean[])Array$.MODULE$.fill(33, (Function0)(JFunction0.mcZ.sp & java.io.Serializable & Serializable)() -> false, ClassTag$.MODULE$.Boolean());
        lookup[32] = true;
        lookup[9] = true;
        lookup[10] = true;
        lookup[13] = true;
        this.zio$logging$internal$JsonValidator$$whitespaceLookup = var1_1;
    }
}

