/*
 * Decompiled with CFR 0.152.
 */
package zio.logging;

import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple6;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import zio.Chunk$;
import zio.Config;
import zio.Config$;
import zio.Zippable$;
import zio.logging.FileLoggerConfig;
import zio.logging.LogFilter;
import zio.logging.LogFilter$;
import zio.logging.LogFilter$LogLevelByNameConfig$;
import zio.logging.LogFormat;
import zio.logging.LogFormat$;

public final class FileLoggerConfig$
implements scala.Serializable {
    public static FileLoggerConfig$ MODULE$;
    private final Config<FileLoggerConfig> config;

    static {
        new FileLoggerConfig$();
    }

    public Charset $lessinit$greater$default$4() {
        return StandardCharsets.UTF_8;
    }

    public int $lessinit$greater$default$5() {
        return 1;
    }

    public Option<Object> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    private Either<Config.Error$.InvalidData, Charset> charsetValue(String value) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Charset.forName(value));
        if (try_ instanceof Success) {
            Charset v = (Charset)((Success)try_).value();
            return package$.MODULE$.Right().apply((Object)v);
        }
        if (try_ instanceof Failure) {
            return package$.MODULE$.Left().apply((Object)new Config.Error$.InvalidData(Chunk$.MODULE$.empty(), new StringBuilder(30).append("Expected a Charset, but found ").append(value).toString()));
        }
        throw new MatchError((Object)try_);
    }

    private Either<Config.Error$.InvalidData, Path> pathValue(String value) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Paths.get(URI.create(value)));
        if (try_ instanceof Success) {
            Path v = (Path)((Success)try_).value();
            return package$.MODULE$.Right().apply((Object)v);
        }
        if (try_ instanceof Failure) {
            return package$.MODULE$.Left().apply((Object)new Config.Error$.InvalidData(Chunk$.MODULE$.empty(), new StringBuilder(27).append("Expected a Path, but found ").append(value).toString()));
        }
        throw new MatchError((Object)try_);
    }

    public Config<FileLoggerConfig> config() {
        return this.config;
    }

    public FileLoggerConfig apply(Path destination, LogFormat format, LogFilter<String> filter, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize) {
        return new FileLoggerConfig(destination, format, filter, charset, autoFlushBatchSize, bufferedIOSize);
    }

    public Charset apply$default$4() {
        return StandardCharsets.UTF_8;
    }

    public int apply$default$5() {
        return 1;
    }

    public Option<Object> apply$default$6() {
        return None$.MODULE$;
    }

    public Option<Tuple6<Path, LogFormat, LogFilter<String>, Charset, Object, Option<Object>>> unapply(FileLoggerConfig x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple6((Object)x$0.destination(), (Object)x$0.format(), x$0.filter(), (Object)x$0.charset(), (Object)BoxesRunTime.boxToInteger((int)x$0.autoFlushBatchSize()), x$0.bufferedIOSize()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private FileLoggerConfig$() {
        MODULE$ = this;
        Config autoFlushBatchSizeConfig = Config$.MODULE$.int().nested((Function0 & Serializable & scala.Serializable)() -> "autoFlushBatchSize").withDefault((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1);
        Config bufferedIOSizeConfig = Config$.MODULE$.int().nested((Function0 & Serializable & scala.Serializable)() -> "bufferedIOSize").optional();
        Config filterConfig = LogFilter$LogLevelByNameConfig$.MODULE$.config().nested((Function0 & Serializable & scala.Serializable)() -> "filter");
        Config charsetConfig = Config$.MODULE$.string().mapOrFail((Function1 & Serializable & scala.Serializable)value -> MODULE$.charsetValue((String)value)).nested((Function0 & Serializable & scala.Serializable)() -> "charset").withDefault((Function0 & Serializable & scala.Serializable)() -> StandardCharsets.UTF_8);
        Config pathConfig = Config$.MODULE$.string().mapOrFail((Function1 & Serializable & scala.Serializable)value -> MODULE$.pathValue((String)value)).nested((Function0 & Serializable & scala.Serializable)() -> "path");
        Config formatConfig = LogFormat$.MODULE$.config().nested((Function0 & Serializable & scala.Serializable)() -> "format").withDefault((Function0 & Serializable & scala.Serializable)() -> LogFormat$.MODULE$.default());
        this.config = pathConfig.$plus$plus((Function0 & Serializable & scala.Serializable)() -> formatConfig, Zippable$.MODULE$.Zippable2()).$plus$plus((Function0 & Serializable & scala.Serializable)() -> filterConfig, Zippable$.MODULE$.Zippable3()).$plus$plus((Function0 & Serializable & scala.Serializable)() -> charsetConfig, Zippable$.MODULE$.Zippable4()).$plus$plus((Function0 & Serializable & scala.Serializable)() -> autoFlushBatchSizeConfig, Zippable$.MODULE$.Zippable5()).$plus$plus((Function0 & Serializable & scala.Serializable)() -> bufferedIOSizeConfig, Zippable$.MODULE$.Zippable6()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                Path path = (Path)x0$1._1();
                LogFormat format = (LogFormat)x0$1._2();
                LogFilter.LogLevelByNameConfig filterConfig = (LogFilter.LogLevelByNameConfig)x0$1._3();
                Charset charset = (Charset)x0$1._4();
                int autoFlushBatchSize = BoxesRunTime.unboxToInt((Object)x0$1._5());
                Option bufferedIOSize = (Option)x0$1._6();
                return new FileLoggerConfig(path, format, LogFilter$.MODULE$.logLevelByName(filterConfig), charset, autoFlushBatchSize, (Option<Object>)bufferedIOSize);
            }
            throw new MatchError(null);
        });
    }
}

