/*
 * Decompiled with CFR 0.152.
 */
package zio.logging;

import java.io.Serializable;
import java.time.OffsetDateTime;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import zio.CanFail$;
import zio.Cause$;
import zio.Has;
import zio.ZIO;
import zio.console.package;
import zio.console.package$;
import zio.logging.LogAnnotation$;
import zio.logging.LogContext;
import zio.logging.LogDatetimeFormatter$;
import zio.logging.LogLevel;
import zio.logging.LogLevel$Debug$;
import zio.logging.LogLevel$Error$;
import zio.logging.LogLevel$Info$;
import zio.logging.LogLevel$Trace$;
import zio.logging.LogLevel$Warn$;
import zio.logging.LogWriter$;

@ScalaSignature(bytes="\u0006\u0001\t\reaB\u001e=!\u0003\r\n!\u0011\u0005\u0006\u0013\u00021\tAS\u0004\u0006qrB\t!\u001f\u0004\u0006wqB\tA\u001f\u0005\u0006w\u000e!\t\u0001 \u0005\b{\u000e\u0011\r\u0011\"\u0003\u007f\u0011\u001d\tia\u0001Q\u0001\n},a!a\u0004\u0004\u0001\u0005EaABA\f\u0007\u0001\u000bI\u0002\u0003\u0006\u0002X!\u0011)\u001a!C\u0001\u00033B!\"a\u0018\t\u0005#\u0005\u000b\u0011BA.\u0011\u0019Y\b\u0002\"\u0001\u0002b!1\u0011\n\u0003C!\u0003OB\u0011\"a\u001d\t\u0003\u0003%\t!!\u001e\t\u0013\u0005e\u0004\"%A\u0005\u0002\u0005m\u0004\u0002CAI\u0011\u0005\u0005I\u0011\t@\t\u0013\u0005M\u0005\"!A\u0005\u0002\u0005U\u0005\"CAO\u0011\u0005\u0005I\u0011AAP\u0011%\t)\u000bCA\u0001\n\u0003\n9\u000bC\u0005\u00026\"\t\t\u0011\"\u0001\u00028\"I\u0011\u0011\u0019\u0005\u0002\u0002\u0013\u0005\u00131\u0019\u0005\n\u0003\u000bD\u0011\u0011!C!\u0003\u000fD\u0011\"!3\t\u0003\u0003%\t%a3\b\u0013\u0005=7!!A\t\u0002\u0005Eg!CA\f\u0007\u0005\u0005\t\u0012AAj\u0011\u0019Y\b\u0004\"\u0001\u0002b\"I\u0011Q\u0019\r\u0002\u0002\u0013\u0015\u0013q\u0019\u0005\n\u0003GD\u0012\u0011!CA\u0003KD\u0011\"!;\u0019#\u0003%\t!a\u001f\t\u0013\u0005-\b$!A\u0005\u0002\u00065\b\"CA}1E\u0005I\u0011AA>\u0011%\tY\u0010GA\u0001\n\u0013\tiP\u0002\u0004\u0003\u0006\r\u0001%q\u0001\u0005\u000b\u0005\u001f\u0001#Q3A\u0005\u0002\u0005e\u0003B\u0003B\tA\tE\t\u0015!\u0003\u0002\\!11\u0010\tC\u0001\u0005'AqA!\u0007!\t\u0013\u0011Y\u0002C\u0004\u0003&\u0001\"IAa\n\t\u000f\u0005]\u0003\u0005\"\u0003\u00038!1\u0011\n\tC!\u0005+B\u0011\"a\u001d!\u0003\u0003%\tA!\u0019\t\u0013\u0005e\u0004%%A\u0005\u0002\u0005m\u0004\u0002CAIA\u0005\u0005I\u0011\t@\t\u0013\u0005M\u0005%!A\u0005\u0002\u0005U\u0005\"CAOA\u0005\u0005I\u0011\u0001B3\u0011%\t)\u000bIA\u0001\n\u0003\n9\u000bC\u0005\u00026\u0002\n\t\u0011\"\u0001\u0003j!I\u0011\u0011\u0019\u0011\u0002\u0002\u0013\u0005\u00131\u0019\u0005\n\u0003\u000b\u0004\u0013\u0011!C!\u0003\u000fD\u0011\"!3!\u0003\u0003%\tE!\u001c\b\u0013\tE4!!A\t\u0002\tMd!\u0003B\u0003\u0007\u0005\u0005\t\u0012\u0001B;\u0011\u0019Y8\u0007\"\u0001\u0003z!I\u0011QY\u001a\u0002\u0002\u0013\u0015\u0013q\u0019\u0005\n\u0003G\u001c\u0014\u0011!CA\u0005wB\u0011\"!;4#\u0003%\t!a\u001f\t\u0013\u0005-8'!A\u0005\u0002\n}\u0004\"CA}gE\u0005I\u0011AA>\u0011%\tYpMA\u0001\n\u0013\tiPA\u0005M_\u001e<&/\u001b;fe*\u0011QHP\u0001\bY><w-\u001b8h\u0015\u0005y\u0014a\u0001>j_\u000e\u0001QC\u0001\"Z'\t\u00011\t\u0005\u0002E\u000f6\tQIC\u0001G\u0003\u0015\u00198-\u00197b\u0013\tAUI\u0001\u0004B]f\u0014VMZ\u0001\toJLG/\u001a'pOR\u00191*Z6\u0011\t1#vK\u0019\b\u0003\u001bJs!AT)\u000e\u0003=S!\u0001\u0015!\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0014BA*?\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0016,\u0003\tU\u0013\u0016j\u0014\u0006\u0003'z\u0002\"\u0001W-\r\u0001\u0011)!\f\u0001b\u00017\n\t!+\u0005\u0002]?B\u0011A)X\u0005\u0003=\u0016\u0013qAT8uQ&tw\r\u0005\u0002EA&\u0011\u0011-\u0012\u0002\u0004\u0003:L\bC\u0001#d\u0013\t!WI\u0001\u0003V]&$\b\"\u00024\u0002\u0001\u00049\u0017aB2p]R,\u0007\u0010\u001e\t\u0003Q&l\u0011\u0001P\u0005\u0003Ur\u0012!\u0002T8h\u0007>tG/\u001a=u\u0011\u0019a\u0017\u0001\"a\u0001[\u0006!A.\u001b8f!\r!e\u000e]\u0005\u0003_\u0016\u0013\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0003cVt!A]:\u0011\u00059+\u0015B\u0001;F\u0003\u0019\u0001&/\u001a3fM&\u0011ao\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Q,\u0015!\u0003'pO^\u0013\u0018\u000e^3s!\tA7a\u0005\u0002\u0004\u0007\u00061A(\u001b8jiz\"\u0012!_\u0001\u0003\u001d2+\u0012a \t\u0005\u0003\u0003\tY!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003\u0011a\u0017M\\4\u000b\u0005\u0005%\u0011\u0001\u00026bm\u0006L1A^A\u0002\u0003\rqE\n\t\u0002\u000e\u0019&tWMR8s[\u0006$H/\u001a:\u0011\r\u0011\u000b\u0019bZ7q\u0013\r\t)\"\u0012\u0002\n\rVt7\r^5p]J\u0012acU5na2,7i\u001c8t_2,Gj\\4Xe&$XM]\n\t\u0011\r\u000bY\"a\u0013\u0002RA!\u0001\u000eAA\u000f%\u0019\ty\"a\t\u00028\u00191\u0011\u0011E\u0002\u0001\u0003;\u0011A\u0002\u0010:fM&tW-\\3oiz\u0002B!!\n\u000229!\u0011qEA\u0017\u001d\ri\u0015\u0011F\u0005\u0004\u0003Wq\u0014aB2p]N|G.Z\u0005\u0004'\u0006=\"bAA\u0016}%!\u00111GA\u001b\u0005\u001d\u0019uN\\:pY\u0016T1aUA\u0018!\u0011\tI$!\u0012\u000f\t\u0005m\u0012\u0011\t\b\u0004\u001b\u0006u\u0012bAA }\u0005)1\r\\8dW&\u00191+a\u0011\u000b\u0007\u0005}b(\u0003\u0003\u0002H\u0005%#!B\"m_\u000e\\'bA*\u0002DA\u0019A)!\u0014\n\u0007\u0005=SIA\u0004Qe>$Wo\u0019;\u0011\u0007\u0011\u000b\u0019&C\u0002\u0002V\u0015\u0013AbU3sS\u0006d\u0017N_1cY\u0016\faAZ8s[\u0006$XCAA.!\r\tifB\u0007\u0002\u0007\u00059am\u001c:nCR\u0004C\u0003BA2\u0003K\u00022!!\u0018\t\u0011%\t9f\u0003I\u0001\u0002\u0004\tY\u0006\u0006\u0004\u0002j\u0005=\u0014\u0011\u000f\t\u0006\u0019R\u000bYG\u0019\n\u0007\u0003[\n\u0019#a\u000e\u0007\r\u0005\u0005\u0002\u0002AA6\u0011\u00151G\u00021\u0001h\u0011\u0019aG\u0002\"a\u0001[\u0006!1m\u001c9z)\u0011\t\u0019'a\u001e\t\u0013\u0005]S\u0002%AA\u0002\u0005m\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003{RC!a\u0017\u0002\u0000-\u0012\u0011\u0011\u0011\t\u0005\u0003\u0007\u000bi)\u0004\u0002\u0002\u0006*!\u0011qQAE\u0003%)hn\u00195fG.,GMC\u0002\u0002\f\u0016\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ty)!\"\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003/\u00032\u0001RAM\u0013\r\tY*\u0012\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004?\u0006\u0005\u0006\"CAR#\u0005\u0005\t\u0019AAL\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u0016\t\u0006\u0003W\u000b\tlX\u0007\u0003\u0003[S1!a,F\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003g\u000biK\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA]\u0003\u007f\u00032\u0001RA^\u0013\r\ti,\u0012\u0002\b\u0005>|G.Z1o\u0011!\t\u0019kEA\u0001\u0002\u0004y\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005]\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003}\fa!Z9vC2\u001cH\u0003BA]\u0003\u001bD\u0001\"a)\u0017\u0003\u0003\u0005\raX\u0001\u0017'&l\u0007\u000f\\3D_:\u001cx\u000e\\3M_\u001e<&/\u001b;feB\u0019\u0011Q\f\r\u0014\u000ba\t).!\u0015\u0011\u0011\u0005]\u0017Q\\A.\u0003Gj!!!7\u000b\u0007\u0005mW)A\u0004sk:$\u0018.\\3\n\t\u0005}\u0017\u0011\u001c\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\fDCAAi\u0003\u0015\t\u0007\u000f\u001d7z)\u0011\t\u0019'a:\t\u0013\u0005]3\u0004%AA\u0002\u0005m\u0013aD1qa2LH\u0005Z3gCVdG\u000fJ\u0019\u0002\u000fUt\u0017\r\u001d9msR!\u0011q^A{!\u0015!\u0015\u0011_A.\u0013\r\t\u00190\u0012\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005]X$!AA\u0002\u0005\r\u0014a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q \t\u0005\u0003\u0003\u0011\t!\u0003\u0003\u0003\u0004\u0005\r!AB(cU\u0016\u001cGO\u0001\tD_2|'/\u001a3M_\u001e<&/\u001b;feNA\u0001e\u0011B\u0005\u0003\u0017\n\t\u0006\u0005\u0003i\u0001\t-!C\u0002B\u0007\u0003G\t9D\u0002\u0004\u0002\"\r\u0001!1B\u0001\u000bY&tWMR8s[\u0006$\u0018a\u00037j]\u00164uN]7bi\u0002\"BA!\u0006\u0003\u0018A\u0019\u0011Q\f\u0011\t\u0013\t=1\u0005%AA\u0002\u0005m\u0013!C<ji\"\u001cu\u000e\\8s)\u0015\u0001(Q\u0004B\u0011\u0011\u0019\u0011y\u0002\na\u0001a\u0006)1m\u001c7pe\"1!1\u0005\u0013A\u0002A\f\u0011a]\u0001\rQ&<\u0007\u000e\\5hQRdun\u001a\u000b\u0006a\n%\"1\u0007\u0005\b\u0005W)\u0003\u0019\u0001B\u0017\u0003\u0015aWM^3m!\rA'qF\u0005\u0004\u0005ca$\u0001\u0003'pO2+g/\u001a7\t\r\tUR\u00051\u0001q\u0003\u001diWm]:bO\u0016$2\u0002\u001dB\u001d\u0005w\u0011IEa\u0013\u0003P!1AN\nCA\u00025DqA!\u0010'\u0001\u0004\u0011y$\u0001\u0003uS6,\u0007\u0003\u0002B!\u0005\u000bj!Aa\u0011\u000b\t\tu\u0012qA\u0005\u0005\u0005\u000f\u0012\u0019E\u0001\bPM\u001a\u001cX\r\u001e#bi\u0016$\u0016.\\3\t\u000f\t-b\u00051\u0001\u0003.!1!Q\n\u0014A\u0002A\f!\u0002\\8hO\u0016\u0014h*Y7f\u0011\u001d\u0011\tF\na\u0001\u0005'\n!\"\\1zE\u0016,%O]8s!\u0011!\u0015\u0011\u001f9\u0015\r\t]#Q\fB0!\u0015aEK!\u0017c%\u0019\u0011Y&a\t\u00028\u00191\u0011\u0011\u0005\u0011\u0001\u00053BQAZ\u0014A\u0002\u001dDa\u0001\\\u0014\u0005\u0002\u0004iG\u0003\u0002B\u000b\u0005GB\u0011Ba\u0004)!\u0003\u0005\r!a\u0017\u0015\u0007}\u00139\u0007C\u0005\u0002$2\n\t\u00111\u0001\u0002\u0018R!\u0011\u0011\u0018B6\u0011!\t\u0019KLA\u0001\u0002\u0004yF\u0003BA]\u0005_B\u0001\"a)2\u0003\u0003\u0005\raX\u0001\u0011\u0007>dwN]3e\u0019><wK]5uKJ\u00042!!\u00184'\u0015\u0019$qOA)!!\t9.!8\u0002\\\tUAC\u0001B:)\u0011\u0011)B! \t\u0013\t=a\u0007%AA\u0002\u0005mC\u0003BAx\u0005\u0003C\u0011\"a>9\u0003\u0003\u0005\rA!\u0006")
public interface LogWriter<R> {
    public ZIO<R, Nothing$, BoxedUnit> writeLog(LogContext var1, Function0<String> var2);

    public static class ColoredLogWriter
    implements LogWriter<Has<package.Console.Service>>,
    Product,
    scala.Serializable {
        private final Function2<LogContext, Function0<String>, String> lineFormat;

        public Function2<LogContext, Function0<String>, String> lineFormat() {
            return this.lineFormat;
        }

        private String withColor(String color, String s) {
            return new StringBuilder(4).append(color).append(s).append("\u001b[0m").toString();
        }

        private String highlightLog(LogLevel level, String message) {
            String string = LogLevel$Error$.MODULE$.equals(level) ? "\u001b[31m" : (LogLevel$Warn$.MODULE$.equals(level) ? "\u001b[33m" : (LogLevel$Info$.MODULE$.equals(level) ? "\u001b[36m" : (LogLevel$Debug$.MODULE$.equals(level) ? "\u001b[32m" : (LogLevel$Trace$.MODULE$.equals(level) ? "\u001b[35m" : "\u001b[0m"))));
            return this.withColor(string, message);
        }

        private String format(Function0<String> line, OffsetDateTime time, LogLevel level, String loggerName, Option<String> maybeError) {
            String logTag = this.highlightLog(level, level.render());
            String logTime = this.withColor("\u001b[34m", LogDatetimeFormatter$.MODULE$.humanReadableDateTimeFormatter().format(time));
            String arg$macro$3 = this.withColor("\u001b[37m", loggerName);
            String arg$macro$4 = this.highlightLog(level, (String)line.apply());
            String logMsg = new StringOps("%s %14s [%s] %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logTime, logTag, arg$macro$3, arg$macro$4}));
            return (String)maybeError.fold((Function0 & Serializable & scala.Serializable)() -> logMsg, (Function1 & Serializable & scala.Serializable)err -> new StringBuilder(0).append(logMsg).append(LogWriter$.MODULE$.zio$logging$LogWriter$$NL()).append(this.highlightLog(level, (String)err)).toString());
        }

        @Override
        public ZIO<Has<package.Console.Service>, Nothing$, BoxedUnit> writeLog(LogContext context, Function0<String> line) {
            return zio.clock.package$.MODULE$.currentDateTime().orDie(Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail()).map((Function1 & Serializable & scala.Serializable)date -> {
                LogLevel level = context.get(LogAnnotation$.MODULE$.Level());
                String loggerName = context.apply(LogAnnotation$.MODULE$.Name());
                Option maybeError = context.get(LogAnnotation$.MODULE$.Throwable()).map((Function1 & Serializable & scala.Serializable)error -> Cause$.MODULE$.fail(error)).orElse((Function0 & Serializable & scala.Serializable)() -> context.get(LogAnnotation$.MODULE$.Cause())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.prettyPrint());
                return new Tuple4(date, (Object)level, (Object)loggerName, (Object)maybeError);
            }).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> {
                if (x$5 == null) {
                    throw new MatchError(null);
                }
                OffsetDateTime date = (OffsetDateTime)x$5._1();
                LogLevel level = (LogLevel)x$5._2();
                String loggerName = (String)x$5._3();
                Option maybeError = (Option)x$5._4();
                ZIO zIO = package$.MODULE$.putStrLn((Function0 & Serializable & scala.Serializable)() -> this.format((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> (String)this.lineFormat().apply((Object)context, (Object)line), date, level, loggerName, (Option<String>)maybeError)).map((Function1 & Serializable & scala.Serializable)_ -> {
                    ColoredLogWriter.$anonfun$writeLog$16(_);
                    return BoxedUnit.UNIT;
                });
                return zIO;
            });
        }

        public ColoredLogWriter copy(Function2<LogContext, Function0<String>, String> lineFormat) {
            return new ColoredLogWriter(lineFormat);
        }

        public Function2<LogContext, Function0<String>, String> copy$default$1() {
            return this.lineFormat();
        }

        public String productPrefix() {
            return "ColoredLogWriter";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.lineFormat();
                }
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ColoredLogWriter;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    boolean bl = x$1 instanceof ColoredLogWriter;
                    if (!bl) break block3;
                    ColoredLogWriter coloredLogWriter = (ColoredLogWriter)x$1;
                    Function2<LogContext, Function0<String>, String> function2 = this.lineFormat();
                    Function2<LogContext, Function0<String>, String> function22 = coloredLogWriter.lineFormat();
                    if (!(!(function2 != null ? !function2.equals(function22) : function22 != null) && coloredLogWriter.canEqual(this))) break block3;
                }
                return true;
            }
            return false;
        }

        public static final /* synthetic */ void $anonfun$writeLog$16(BoxedUnit _) {
        }

        public ColoredLogWriter(Function2<LogContext, Function0<String>, String> lineFormat) {
            this.lineFormat = lineFormat;
            Product.$init$((Product)this);
        }
    }

    public static class SimpleConsoleLogWriter
    implements LogWriter<Has<package.Console.Service>>,
    Product,
    scala.Serializable {
        private final Function2<LogContext, Function0<String>, String> format;

        public Function2<LogContext, Function0<String>, String> format() {
            return this.format;
        }

        @Override
        public ZIO<Has<package.Console.Service>, Nothing$, BoxedUnit> writeLog(LogContext context, Function0<String> line) {
            return zio.clock.package$.MODULE$.currentDateTime().orDie(Predef$.MODULE$.$conforms(), CanFail$.MODULE$.canFail()).map((Function1 & Serializable & scala.Serializable)date -> {
                String level = context.apply(LogAnnotation$.MODULE$.Level());
                String loggerName = context.apply(LogAnnotation$.MODULE$.Name());
                String maybeError = (String)context.get(LogAnnotation$.MODULE$.Throwable()).map((Function1 & Serializable & scala.Serializable)error -> Cause$.MODULE$.fail(error)).orElse((Function0 & Serializable & scala.Serializable)() -> context.get(LogAnnotation$.MODULE$.Cause())).map((Function1 & Serializable & scala.Serializable)cause -> new StringBuilder(0).append(LogWriter$.MODULE$.zio$logging$LogWriter$$NL()).append(cause.prettyPrint()).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                return new Tuple4(date, (Object)level, (Object)loggerName, (Object)maybeError);
            }).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
                if (x$2 == null) {
                    throw new MatchError(null);
                }
                OffsetDateTime date = (OffsetDateTime)x$2._1();
                String level = (String)x$2._2();
                String loggerName = (String)x$2._3();
                String maybeError = (String)x$2._4();
                ZIO zIO = package$.MODULE$.putStrLn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(4).append(LogDatetimeFormatter$.MODULE$.humanReadableDateTimeFormatter().format(date)).append(" ").append(level).append(" ").append(loggerName).append(" ").append(this.format().apply((Object)context, (Object)line)).append(" ").append(maybeError).toString()).map((Function1 & Serializable & scala.Serializable)_ -> {
                    SimpleConsoleLogWriter.$anonfun$writeLog$8(_);
                    return BoxedUnit.UNIT;
                });
                return zIO;
            });
        }

        public SimpleConsoleLogWriter copy(Function2<LogContext, Function0<String>, String> format) {
            return new SimpleConsoleLogWriter(format);
        }

        public Function2<LogContext, Function0<String>, String> copy$default$1() {
            return this.format();
        }

        public String productPrefix() {
            return "SimpleConsoleLogWriter";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.format();
                }
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SimpleConsoleLogWriter;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    boolean bl = x$1 instanceof SimpleConsoleLogWriter;
                    if (!bl) break block3;
                    SimpleConsoleLogWriter simpleConsoleLogWriter = (SimpleConsoleLogWriter)x$1;
                    Function2<LogContext, Function0<String>, String> function2 = this.format();
                    Function2<LogContext, Function0<String>, String> function22 = simpleConsoleLogWriter.format();
                    if (!(!(function2 != null ? !function2.equals(function22) : function22 != null) && simpleConsoleLogWriter.canEqual(this))) break block3;
                }
                return true;
            }
            return false;
        }

        public static final /* synthetic */ void $anonfun$writeLog$8(BoxedUnit _) {
        }

        public SimpleConsoleLogWriter(Function2<LogContext, Function0<String>, String> format) {
            this.format = format;
            Product.$init$((Product)this);
        }
    }
}

