/*
 * Decompiled with CFR 0.152.
 */
package zio.logging;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxesRunTime;

public class LogWriter
extends Writer {
    private final int autoFlushBatchSize;
    private final Writer writer;
    private long entriesWritten;

    public LogWriter(Path destination, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize) {
        Writer writer;
        this.autoFlushBatchSize = autoFlushBatchSize;
        OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(destination.toFile()), charset);
        Option<Object> option = bufferedIOSize;
        if (option instanceof Some) {
            int bufferSize = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            writer = new BufferedWriter(output, bufferSize);
        } else if (None$.MODULE$.equals(option)) {
            writer = output;
        } else {
            throw new MatchError(option);
        }
        this.writer = writer;
        this.entriesWritten = 0L;
    }

    @Override
    public void write(char[] buffer, int offset, int length) {
        this.writer.write(buffer, offset, length);
    }

    public void writeln(String line) {
        this.writer.write(line);
        this.writer.write(System.lineSeparator());
        ++this.entriesWritten;
        if (this.entriesWritten % (long)this.autoFlushBatchSize == 0L) {
            this.writer.flush();
        }
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public void close() {
        this.writer.close();
    }
}

