/*
 * Decompiled with CFR 0.152.
 */
package zio.logging;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Option;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JFunction1;
import zio.Cause$;
import zio.logging.LogAnnotation$;
import zio.logging.LogContext;
import zio.logging.LogFormat$;
import zio.logging.LogFormat$AssembledLogFormat$;
import zio.logging.LogFormat$AssembledLogFormat$FormatterFunction$;
import zio.logging.LogFormat$ColoredLogFormat$;
import zio.logging.LogFormat$SimpleConsoleLogFormat$;
import zio.logging.LogLevel;
import zio.logging.LogLevel$Debug$;
import zio.logging.LogLevel$Error$;
import zio.logging.LogLevel$Info$;
import zio.logging.LogLevel$Trace$;
import zio.logging.LogLevel$Warn$;

public interface LogFormat<A> {
    public String format(LogContext var1, A var2);

    public static final class AssembledLogFormat
    implements LogFormat<String> {
        private final FormatterFunction formatter;
        private final StringBuilder builder;

        public static AssembledLogFormat apply(FormatterFunction formatterFunction) {
            return LogFormat$AssembledLogFormat$.MODULE$.apply(formatterFunction);
        }

        public AssembledLogFormat(FormatterFunction formatter) {
            this.formatter = formatter;
            this.builder = new StringBuilder();
        }

        @Override
        public String format(LogContext context, String line) {
            this.builder.clear();
            this.formatter.fun().apply((Object)this.builder, (Object)context, (Object)line);
            return this.builder.toString();
        }

        public static class FormatterFunction
        implements Product,
        Serializable {
            private final Function3 fun;

            public static FormatterFunction apply(Function3<StringBuilder, LogContext, String, Object> function3) {
                return LogFormat$AssembledLogFormat$FormatterFunction$.MODULE$.apply(function3);
            }

            public static FormatterFunction fromProduct(Product product) {
                return LogFormat$AssembledLogFormat$FormatterFunction$.MODULE$.fromProduct(product);
            }

            public static FormatterFunction unapply(FormatterFunction formatterFunction) {
                return LogFormat$AssembledLogFormat$FormatterFunction$.MODULE$.unapply(formatterFunction);
            }

            public FormatterFunction(Function3<StringBuilder, LogContext, String, Object> fun) {
                this.fun = fun;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof FormatterFunction)) return false;
                FormatterFunction formatterFunction = (FormatterFunction)object;
                Function3<StringBuilder, LogContext, String, Object> function3 = this.fun();
                Function3<StringBuilder, LogContext, String, Object> function32 = formatterFunction.fun();
                if (function3 == null) {
                    if (function32 != null) {
                        return false;
                    }
                } else if (!function3.equals(function32)) return false;
                if (!formatterFunction.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof FormatterFunction;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "FormatterFunction";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 != n2) {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return this._1();
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 != n2) {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return "fun";
            }

            public Function3<StringBuilder, LogContext, String, Object> fun() {
                return this.fun;
            }

            public FormatterFunction $plus(FormatterFunction other) {
                return LogFormat$AssembledLogFormat$FormatterFunction$.MODULE$.apply((Function3<StringBuilder, LogContext, String, Object>)(Function3 & Serializable)(builder, ctx, line) -> {
                    this.fun().apply(builder, ctx, line);
                    return other.fun().apply(builder, ctx, line);
                });
            }

            public FormatterFunction $bar$minus$bar(FormatterFunction other) {
                return LogFormat$AssembledLogFormat$FormatterFunction$.MODULE$.apply((Function3<StringBuilder, LogContext, String, Object>)(Function3 & Serializable)(builder, ctx, line) -> {
                    this.fun().apply(builder, ctx, line);
                    builder.append(' ');
                    return other.fun().apply(builder, ctx, line);
                });
            }

            public FormatterFunction concat(FormatterFunction other) {
                return this.$plus(other);
            }

            public FormatterFunction spaced(FormatterFunction other) {
                return this.$bar$minus$bar(other);
            }

            public FormatterFunction copy(Function3<StringBuilder, LogContext, String, Object> fun) {
                return new FormatterFunction(fun);
            }

            public Function3<StringBuilder, LogContext, String, Object> copy$default$1() {
                return this.fun();
            }

            public Function3<StringBuilder, LogContext, String, Object> _1() {
                return this.fun();
            }
        }
    }

    public static final class ColoredLogFormat
    implements LogFormat<String>,
    Product,
    Serializable {
        private final Function2 lineFormat;

        public static ColoredLogFormat apply(Function2 function2) {
            return LogFormat$ColoredLogFormat$.MODULE$.apply(function2);
        }

        public static ColoredLogFormat fromProduct(Product product) {
            return LogFormat$ColoredLogFormat$.MODULE$.fromProduct(product);
        }

        public static ColoredLogFormat unapply(ColoredLogFormat coloredLogFormat) {
            return LogFormat$ColoredLogFormat$.MODULE$.unapply(coloredLogFormat);
        }

        public static Function2 $lessinit$greater$default$1() {
            return LogFormat$ColoredLogFormat$.MODULE$.$lessinit$greater$default$1();
        }

        public ColoredLogFormat(Function2 lineFormat) {
            this.lineFormat = lineFormat;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ColoredLogFormat)) return false;
            ColoredLogFormat coloredLogFormat = (ColoredLogFormat)object;
            Function2 function2 = this.lineFormat();
            Function2 function22 = coloredLogFormat.lineFormat();
            if (function2 != null) {
                if (!function2.equals(function22)) return false;
                return true;
            }
            if (function22 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ColoredLogFormat;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ColoredLogFormat";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "lineFormat";
        }

        public Function2 lineFormat() {
            return this.lineFormat;
        }

        private String withColor(String color, String s) {
            return "" + color + s + "\u001b[0m";
        }

        private String highlightLog(LogLevel level, String message) {
            LogLevel logLevel = level;
            String color = LogLevel$Error$.MODULE$.equals(logLevel) ? "\u001b[31m" : (LogLevel$Warn$.MODULE$.equals(logLevel) ? "\u001b[33m" : (LogLevel$Info$.MODULE$.equals(logLevel) ? "\u001b[36m" : (LogLevel$Debug$.MODULE$.equals(logLevel) ? "\u001b[32m" : (LogLevel$Trace$.MODULE$.equals(logLevel) ? "\u001b[35m" : "\u001b[0m"))));
            return this.withColor(color, message);
        }

        private String format(String line, String time, LogLevel level, String loggerName, Option<String> maybeError) {
            String logTag = this.highlightLog(level, level.render());
            String logTime = this.withColor("\u001b[34m", time);
            String logMsg = StringOps$.MODULE$.format$extension("%s %14s [%s] %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{logTime, logTag, this.withColor("\u001b[37m", loggerName), this.highlightLog(level, line)}));
            return (String)maybeError.fold(() -> this.format$$anonfun$1(logMsg), (Function1)(JFunction1 & Serializable)err -> "" + logMsg + LogFormat$.zio$logging$LogFormat$$$NL + this.highlightLog(level, (String)err));
        }

        @Override
        public String format(LogContext context, String line) {
            String date = context.apply(LogAnnotation$.MODULE$.Timestamp());
            LogLevel level = context.get(LogAnnotation$.MODULE$.Level());
            String loggerName = context.apply(LogAnnotation$.MODULE$.Name());
            Option maybeError = context.get(LogAnnotation$.MODULE$.Throwable()).map((Function1)(JFunction1 & Serializable)error -> Cause$.MODULE$.fail(error)).orElse(() -> this.$anonfun$2(context)).map((Function1)(JFunction1 & Serializable)_$3 -> _$3.prettyPrint());
            return this.format((String)this.lineFormat().apply((Object)context, () -> this.format$$anonfun$3(line)), date, level, loggerName, (Option<String>)maybeError);
        }

        public ColoredLogFormat copy(Function2 lineFormat) {
            return new ColoredLogFormat(lineFormat);
        }

        public Function2 copy$default$1() {
            return this.lineFormat();
        }

        public Function2 _1() {
            return this.lineFormat();
        }

        private final String format$$anonfun$1(String logMsg$1) {
            return logMsg$1;
        }

        private final Option $anonfun$2(LogContext context$2) {
            return context$2.get(LogAnnotation$.MODULE$.Cause());
        }

        private final String format$$anonfun$3(String line$3) {
            return line$3;
        }
    }

    public static final class SimpleConsoleLogFormat
    implements LogFormat<String>,
    Product,
    Serializable {
        private final Function2 format0;

        public static SimpleConsoleLogFormat apply(Function2 function2) {
            return LogFormat$SimpleConsoleLogFormat$.MODULE$.apply(function2);
        }

        public static SimpleConsoleLogFormat fromProduct(Product product) {
            return LogFormat$SimpleConsoleLogFormat$.MODULE$.fromProduct(product);
        }

        public static SimpleConsoleLogFormat unapply(SimpleConsoleLogFormat simpleConsoleLogFormat) {
            return LogFormat$SimpleConsoleLogFormat$.MODULE$.unapply(simpleConsoleLogFormat);
        }

        public static Function2 $lessinit$greater$default$1() {
            return LogFormat$SimpleConsoleLogFormat$.MODULE$.$lessinit$greater$default$1();
        }

        public SimpleConsoleLogFormat(Function2 format0) {
            this.format0 = format0;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SimpleConsoleLogFormat)) return false;
            SimpleConsoleLogFormat simpleConsoleLogFormat = (SimpleConsoleLogFormat)object;
            Function2 function2 = this.format0();
            Function2 function22 = simpleConsoleLogFormat.format0();
            if (function2 != null) {
                if (!function2.equals(function22)) return false;
                return true;
            }
            if (function22 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SimpleConsoleLogFormat;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "SimpleConsoleLogFormat";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "format0";
        }

        public Function2 format0() {
            return this.format0;
        }

        @Override
        public String format(LogContext context, String line) {
            String date = context.apply(LogAnnotation$.MODULE$.Timestamp());
            String level = context.apply(LogAnnotation$.MODULE$.Level());
            String loggerName = context.apply(LogAnnotation$.MODULE$.Name());
            String maybeError = (String)context.get(LogAnnotation$.MODULE$.Throwable()).map((Function1)(JFunction1 & Serializable)error -> Cause$.MODULE$.fail(error)).orElse(() -> this.$anonfun$2(context)).map((Function1)(JFunction1 & Serializable)cause -> LogFormat$.zio$logging$LogFormat$$$NL + cause.prettyPrint()).getOrElse(this::$anonfun$4);
            return date + " " + level + " " + loggerName + " " + this.format0().apply((Object)context, () -> this.format$$anonfun$1(line)) + " " + maybeError;
        }

        public SimpleConsoleLogFormat copy(Function2 format0) {
            return new SimpleConsoleLogFormat(format0);
        }

        public Function2 copy$default$1() {
            return this.format0();
        }

        public Function2 _1() {
            return this.format0();
        }

        private final Option $anonfun$2(LogContext context$1) {
            return context$1.get(LogAnnotation$.MODULE$.Cause());
        }

        private final String $anonfun$4() {
            return "";
        }

        private final String format$$anonfun$1(String line$2) {
            return line$2;
        }
    }
}

