/*
 * Decompiled with CFR 0.152.
 */
package zio.logging;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.function.JFunction0;
import scala.runtime.function.JFunction1;
import scala.runtime.function.JFunction2;
import zio.ZIO;
import zio.logging.LogAnnotation$;
import zio.logging.LogContext;
import zio.logging.LogFiltering;
import zio.logging.LogFiltering$LogFilterNode$;
import zio.logging.LogLevel;
import zio.stm.TMap;
import zio.stm.ZSTM;
import zio.stm.ZSTM$;

public final class LogFiltering$
implements Serializable {
    public static final LogFiltering$LogFilterNode$ LogFilterNode;
    public static final LogFiltering$ MODULE$;

    private LogFiltering$() {
    }

    static {
        MODULE$ = new LogFiltering$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LogFiltering$.class);
    }

    public <A> Function2<LogContext, A, Object> filterBy(LogLevel rootLevel, Seq<Tuple2<String, LogLevel>> mappings) {
        return this.filterByTree(this.buildLogFilterTree(rootLevel, mappings));
    }

    public <A> Function2<LogContext, A, Object> filterByTree(LogFiltering.LogFilterNode root) {
        return (JFunction2 & Serializable)(ctx, _$1) -> {
            List<String> loggerName = ctx.get(LogAnnotation$.MODULE$.Name());
            LogLevel logLevel = this.findMostSpecificLogLevel(loggerName, root);
            return ctx.get(LogAnnotation$.MODULE$.Level()).$greater$eq(logLevel);
        };
    }

    public <A> Function2<LogContext, A, ZIO<Object, Nothing$, Object>> cachedFilterBy(TMap<Tuple2<List<String>, LogLevel>, Object> cache, LogLevel rootLevel, Seq<Tuple2<String, LogLevel>> mappings) {
        return this.cachedFilterByTree(cache, this.buildLogFilterTree(rootLevel, mappings));
    }

    public <A> Function2<LogContext, A, ZIO<Object, Nothing$, Object>> cachedFilterByTree(TMap<Tuple2<List<String>, LogLevel>, Object> cache, LogFiltering.LogFilterNode root) {
        return (JFunction2 & Serializable)(ctx, _$2) -> {
            List<String> loggerName = ctx.get(LogAnnotation$.MODULE$.Name());
            LogLevel level = ctx.get(LogAnnotation$.MODULE$.Level());
            Tuple2 key = Tuple2$.MODULE$.apply(loggerName, (Object)level);
            Function4 function4 = cache.get((Object)key);
            Function4 stm = ZSTM$.MODULE$.flatMap$extension(function4, (Function1)((JFunction1 & Serializable)arg_0 -> this.$anonfun$adapted$1(cache, root, loggerName, level, key, arg_0)));
            return ZSTM$.MODULE$.commit$extension(stm);
        };
    }

    private LogFiltering.LogFilterNode buildLogFilterTree(LogLevel rootLevel, Seq<Tuple2<String, LogLevel>> mappings) {
        return (LogFiltering.LogFilterNode)mappings.foldLeft((Object)LogFiltering$LogFilterNode$.MODULE$.apply(rootLevel, (Map<String, LogFiltering.LogFilterNode>)Predef$.MODULE$.Map().empty()), (Function2)(JFunction2 & Serializable)(x$1, x$2) -> {
            LogFiltering.LogFilterNode tree;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._2();
                    tree = (LogFiltering.LogFilterNode)tuple22._1();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            String name = (String)tuple2._1();
            LogLevel logLevel = (LogLevel)tuple2._2();
            List nameList = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(name), '.')).toList();
            return this.add$1(tree, nameList, logLevel);
        });
    }

    private LogLevel findMostSpecificLogLevel(List<String> names, LogFiltering.LogFilterNode currentNode) {
        LogLevel logLevel;
        block5: {
            List list;
            LogFiltering.LogFilterNode logFilterNode = currentNode;
            List list2 = names;
            while ((list = list2) instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                List list3 = colon2.next$access$1();
                String next = (String)colon2.head();
                List remaining = list3;
                Option option = logFilterNode.children().get((Object)next);
                if (option instanceof Some) {
                    LogFiltering.LogFilterNode nextNode = (LogFiltering.LogFilterNode)((Some)option).value();
                    List list4 = remaining;
                    LogFiltering.LogFilterNode logFilterNode2 = nextNode;
                    list2 = list4;
                    logFilterNode = logFilterNode2;
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    logLevel = logFilterNode.logLevel();
                    break block5;
                }
                throw new MatchError((Object)option);
            }
            Nil$ nil$ = package$.MODULE$.Nil();
            List list5 = list;
            if (!(nil$ != null ? !nil$.equals(list5) : list5 != null)) {
                logLevel = logFilterNode.logLevel();
            } else {
                throw new MatchError(list);
            }
        }
        return logLevel;
    }

    private final boolean $anonfun$1$$anonfun$1(boolean value$1) {
        return value$1;
    }

    private final boolean $anonfun$2$$anonfun$2(boolean answer$1) {
        return answer$1;
    }

    private final /* synthetic */ boolean $anonfun$3$$anonfun$3(boolean result) {
        return result;
    }

    private final boolean $anonfun$4$$anonfun$adapted$1(Object result) {
        return this.$anonfun$3$$anonfun$3(BoxesRunTime.unboxToBoolean((Object)result));
    }

    private final /* synthetic */ Function4 $anonfun$5(TMap cache$2, LogFiltering.LogFilterNode root$3, List loggerName$1, LogLevel level$1, Tuple2 key$1, Option cached) {
        Function4 function4;
        Option option = cached;
        if (option instanceof Some) {
            boolean value = BoxesRunTime.unboxToBoolean((Object)((Some)option).value());
            function4 = ZSTM$.MODULE$.succeed((Function0)((JFunction0.mcZ.sp & Serializable)() -> this.$anonfun$1$$anonfun$1(value)));
        } else if (None$.MODULE$.equals(option)) {
            LogLevel mostSpecificLogLevel = this.findMostSpecificLogLevel((List<String>)loggerName$1, root$3);
            boolean answer = level$1.$greater$eq(mostSpecificLogLevel);
            Function4 function42 = cache$2.put((Object)key$1, (Object)BoxesRunTime.boxToBoolean((boolean)answer));
            function4 = ZSTM$.MODULE$.as$extension(function42, (Function0)((JFunction0.mcZ.sp & Serializable)() -> this.$anonfun$2$$anonfun$2(answer)));
        } else {
            throw new MatchError((Object)option);
        }
        Function4 function43 = function4;
        return ZSTM$.MODULE$.map$extension(function43, (Function1)((JFunction1 & Serializable)this::$anonfun$4$$anonfun$adapted$1));
    }

    private final Object $anonfun$adapted$1(TMap cache$3, LogFiltering.LogFilterNode root$4, List loggerName$2, LogLevel level$2, Tuple2 key$2, Option cached) {
        return new ZSTM(this.$anonfun$5(cache$3, root$4, loggerName$2, level$2, key$2, cached));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final LogFiltering.LogFilterNode add$1(LogFiltering.LogFilterNode tree, List names, LogLevel level) {
        LogFiltering.LogFilterNode logFilterNode;
        List list = names;
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            logFilterNode = tree.copy(level, tree.copy$default$2());
            return logFilterNode;
        } else {
            if (!(list instanceof .colon.colon)) throw new MatchError((Object)list);
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            String name = (String)colon2.head();
            List remaining = list3;
            Option option = tree.children().get((Object)name);
            if (option instanceof Some) {
                LogFiltering.LogFilterNode subtree = (LogFiltering.LogFilterNode)((Some)option).value();
                logFilterNode = tree.copy(tree.copy$default$1(), (Map<String, LogFiltering.LogFilterNode>)((Map)tree.children().updated((Object)name, (Object)this.add$1(subtree, remaining, level))));
                return logFilterNode;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)name);
                logFilterNode = tree.copy(tree.copy$default$1(), (Map<String, LogFiltering.LogFilterNode>)((Map)tree.children().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.add$1(LogFiltering$LogFilterNode$.MODULE$.apply(tree.logLevel(), (Map<String, LogFiltering.LogFilterNode>)Predef$.MODULE$.Map().empty()), remaining, level)))));
            }
        }
        return logFilterNode;
    }
}

