/*
 * Decompiled with CFR 0.152.
 */
package zio.logging.slf4j.bridge;

import java.util.Collections;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.event.LoggingEvent;
import org.slf4j.helpers.AbstractLogger;
import org.slf4j.spi.LoggingEventAware;
import zio.logging.slf4j.bridge.LoggerFactory;

final class Logger
extends AbstractLogger
implements LoggingEventAware {
    private LoggerFactory factory;

    Logger(String string, LoggerFactory loggerFactory) {
        this.name = string;
        this.factory = loggerFactory;
    }

    protected String getFullyQualifiedCallerName() {
        return null;
    }

    protected void handleNormalizedLoggingCall(Level level, Marker marker, String string, Object[] objectArray, Throwable throwable) {
        this.factory.log(this.name, level, string, objectArray, throwable, Collections.emptyList());
    }

    public boolean isTraceEnabled() {
        return this.factory.isEnabled(this.name, Level.TRACE);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.factory.isEnabled(this.name, Level.DEBUG);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.factory.isEnabled(this.name, Level.INFO);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.factory.isEnabled(this.name, Level.WARN);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.factory.isEnabled(this.name, Level.ERROR);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    public void log(LoggingEvent loggingEvent) {
        if (this.factory.isEnabled(this.name, loggingEvent.getLevel())) {
            this.factory.log(this.name, loggingEvent.getLevel(), loggingEvent.getMessage(), loggingEvent.getArgumentArray(), loggingEvent.getThrowable(), loggingEvent.getKeyValuePairs());
        }
    }
}

