/*
 * Decompiled with CFR 0.152.
 */
package zio.logging.slf4j.bridge;

import java.io.Serializable;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.impl.LoggerRuntime;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapOps;
import scala.reflect.ClassTag$;
import scala.runtime.LazyRef;
import scala.runtime.function.JProcedure1;
import zio.Cause;
import zio.Cause$;
import zio.Fiber;
import zio.Fiber$;
import zio.FiberId;
import zio.FiberId$;
import zio.FiberRef$;
import zio.FiberRefs;
import zio.FiberRefs$;
import zio.LogLevel;
import zio.LogSpan;
import zio.LogSpan$;
import zio.Runtime;
import zio.Trace$;
import zio.Unsafe$;
import zio.internal.FiberRuntime;
import zio.internal.FiberRuntime$;
import zio.logging.slf4j.bridge.ZioLoggerRuntime$;

public final class ZioLoggerRuntime
implements LoggerRuntime {
    private final Runtime<Object> runtime;
    private final String loggerNameAnnotationKey;

    public static Map<Level, LogLevel> logLevelMapping() {
        return ZioLoggerRuntime$.MODULE$.logLevelMapping();
    }

    public ZioLoggerRuntime(Runtime<Object> runtime, String loggerNameAnnotationKey) {
        this.runtime = runtime;
        this.loggerNameAnnotationKey = loggerNameAnnotationKey;
    }

    @Override
    public void log(String name, Level level, Marker marker, String messagePattern, Object[] arguments, Throwable throwable) {
        Unsafe$.MODULE$.unsafe((Function1)(JProcedure1 & Serializable)u -> {
            LazyRef lazyRef = new LazyRef();
            LogLevel logLevel = (LogLevel)ZioLoggerRuntime$.MODULE$.logLevelMapping().apply((Object)level);
            Object trace = Trace$.MODULE$.empty();
            FiberId.Runtime fiberId = FiberId$.MODULE$.make(trace, u);
            Fiber.Runtime currentFiber = (Fiber.Runtime)Fiber$.MODULE$._currentFiber().get();
            FiberRefs currentFiberRefs = currentFiber == null ? this.runtime.fiberRefs().joinAs(fiberId, FiberRefs$.MODULE$.empty()) : this.runtime.fiberRefs().joinAs(fiberId, currentFiber.unsafe().getFiberRefs(u));
            LogSpan logSpan = LogSpan$.MODULE$.apply(name, System.currentTimeMillis());
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.loggerNameAnnotationKey);
            Tuple2 loggerName = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)name);
            FiberRefs fiberRefs = currentFiberRefs.updatedAs(fiberId, FiberRef$.MODULE$.currentLogSpan(), (Object)((List)currentFiberRefs.getOrDefault(FiberRef$.MODULE$.currentLogSpan())).$colon$colon((Object)logSpan)).updatedAs(fiberId, FiberRef$.MODULE$.currentLogAnnotations(), (Object)((MapOps)currentFiberRefs.getOrDefault(FiberRef$.MODULE$.currentLogAnnotations())).$plus(loggerName));
            FiberRuntime fiberRuntime = FiberRuntime$.MODULE$.apply(fiberId, fiberRefs, this.runtime.runtimeFlags());
            Cause cause = throwable != null ? Cause$.MODULE$.die(throwable, Cause$.MODULE$.die$default$2()) : Cause$.MODULE$.empty();
            fiberRuntime.log((Function0 & Serializable)() -> ZioLoggerRuntime.msg$1(messagePattern, arguments, lazyRef), cause, (Option)Some$.MODULE$.apply((Object)logLevel), trace, u);
        });
    }

    private static final String msg$lzyINIT1$1(String messagePattern$2, Object[] arguments$2, LazyRef msg$lzy1$1) {
        String string;
        LazyRef lazyRef = msg$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (msg$lzy1$1.initialized()) {
                object = msg$lzy1$1.value();
            } else {
                String string2;
                if (arguments$2 != null) {
                    Object object2 = Predef$.MODULE$.refArrayOps(arguments$2);
                    string2 = MessageFormatter.arrayFormat((String)messagePattern$2, (Object[])((Object[])ArrayOps$.MODULE$.toArray$extension(object2, ClassTag$.MODULE$.apply(Object.class)))).getMessage();
                } else {
                    string2 = messagePattern$2;
                }
                object = msg$lzy1$1.initialize((Object)string2);
            }
            string = (String)object;
        }
        return string;
    }

    private static final String msg$1(String messagePattern$3, Object[] arguments$3, LazyRef msg$lzy1$2) {
        return (String)(msg$lzy1$2.initialized() ? msg$lzy1$2.value() : ZioLoggerRuntime.msg$lzyINIT1$1(messagePattern$3, arguments$3, msg$lzy1$2));
    }
}

