/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public abstract class ZioLoggerBase
extends MarkerIgnoringBase {
    public ZioLoggerBase(String string) {
        this.name = string;
    }

    protected abstract void log(Level var1, Marker var2, String var3, Object[] var4, Throwable var5);

    protected abstract boolean isEnabled(String var1, Level var2);

    private void logWithThrowable(Level level, Marker marker, String string, Throwable throwable) {
        this.log(level, marker, string, null, throwable);
    }

    private void logWithArg(Level level, Marker marker, String string, Object object) {
        this.log(level, marker, string, new Object[]{object}, null);
    }

    private void logWithArgs(Level level, Marker marker, String string, Object object, Object object2) {
        if (object2 instanceof Throwable) {
            this.log(level, marker, string, new Object[]{object}, (Throwable)object2);
        } else {
            this.log(level, marker, string, new Object[]{object, object2}, null);
        }
    }

    private void logWithArgs(Level level, Marker marker, String string, Object[] objectArray) {
        Throwable throwable = MessageFormatter.getThrowableCandidate((Object[])objectArray);
        if (throwable != null) {
            Object[] objectArray2 = MessageFormatter.trimmedCopy((Object[])objectArray);
            this.log(level, marker, string, objectArray2, throwable);
        } else {
            this.log(level, marker, string, objectArray, null);
        }
    }

    public boolean isTraceEnabled() {
        return this.isEnabled(this.name, Level.TRACE);
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(this.name, Level.DEBUG);
    }

    public boolean isErrorEnabled() {
        return this.isEnabled(this.name, Level.ERROR);
    }

    public boolean isWarnEnabled() {
        return this.isEnabled(this.name, Level.WARN);
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(this.name, Level.INFO);
    }

    public void trace(String string) {
        if (this.isTraceEnabled()) {
            this.logWithThrowable(Level.TRACE, null, string, null);
        }
    }

    public void trace(String string, Object object) {
        if (this.isTraceEnabled()) {
            this.logWithArg(Level.TRACE, null, string, object);
        }
    }

    public void trace(String string, Object object, Object object2) {
        if (this.isTraceEnabled()) {
            this.logWithArgs(Level.TRACE, null, string, object, object2);
        }
    }

    public void trace(String string, Object ... objectArray) {
        if (this.isTraceEnabled()) {
            this.logWithArgs(Level.TRACE, null, string, objectArray);
        }
    }

    public void trace(String string, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.logWithThrowable(Level.TRACE, null, string, throwable);
        }
    }

    public void debug(String string) {
        if (this.isDebugEnabled()) {
            this.logWithThrowable(Level.DEBUG, null, string, null);
        }
    }

    public void debug(String string, Object object) {
        if (this.isDebugEnabled()) {
            this.logWithArg(Level.DEBUG, null, string, object);
        }
    }

    public void debug(String string, Object object, Object object2) {
        if (this.isDebugEnabled()) {
            this.logWithArgs(Level.DEBUG, null, string, object, object2);
        }
    }

    public void debug(String string, Object ... objectArray) {
        if (this.isDebugEnabled()) {
            this.logWithArgs(Level.DEBUG, null, string, objectArray);
        }
    }

    public void debug(String string, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.logWithThrowable(Level.DEBUG, null, string, throwable);
        }
    }

    public void info(String string) {
        if (this.isInfoEnabled()) {
            this.logWithThrowable(Level.INFO, null, string, null);
        }
    }

    public void info(String string, Object object) {
        if (this.isInfoEnabled()) {
            this.logWithArg(Level.INFO, null, string, object);
        }
    }

    public void info(String string, Object object, Object object2) {
        if (this.isInfoEnabled()) {
            this.logWithArgs(Level.INFO, null, string, object, object2);
        }
    }

    public void info(String string, Object ... objectArray) {
        if (this.isInfoEnabled()) {
            this.logWithArgs(Level.INFO, null, string, objectArray);
        }
    }

    public void info(String string, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.logWithThrowable(Level.INFO, null, string, throwable);
        }
    }

    public void warn(String string) {
        if (this.isWarnEnabled()) {
            this.logWithThrowable(Level.WARN, null, string, null);
        }
    }

    public void warn(String string, Object object) {
        if (this.isWarnEnabled()) {
            this.logWithArg(Level.WARN, null, string, object);
        }
    }

    public void warn(String string, Object object, Object object2) {
        if (this.isWarnEnabled()) {
            this.logWithArgs(Level.WARN, null, string, object, object2);
        }
    }

    public void warn(String string, Object ... objectArray) {
        if (this.isWarnEnabled()) {
            this.logWithArgs(Level.WARN, null, string, objectArray);
        }
    }

    public void warn(String string, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.logWithThrowable(Level.WARN, null, string, throwable);
        }
    }

    public void error(String string) {
        if (this.isErrorEnabled()) {
            this.logWithThrowable(Level.ERROR, null, string, null);
        }
    }

    public void error(String string, Object object) {
        if (this.isErrorEnabled()) {
            this.logWithArg(Level.ERROR, null, string, object);
        }
    }

    public void error(String string, Object object, Object object2) {
        if (this.isErrorEnabled()) {
            this.logWithArgs(Level.ERROR, null, string, object, object2);
        }
    }

    public void error(String string, Object ... objectArray) {
        if (this.isErrorEnabled()) {
            this.logWithArgs(Level.ERROR, null, string, objectArray);
        }
    }

    public void error(String string, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.logWithThrowable(Level.ERROR, null, string, throwable);
        }
    }
}

