/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public abstract class ZioLoggerBase
extends MarkerIgnoringBase {
    public ZioLoggerBase(String string) {
        this.name = string;
    }

    protected abstract void log(Level var1, Marker var2, String var3, Object[] var4, Throwable var5);

    private void logWithThrowable(Level level, Marker marker, String string, Throwable throwable) {
        this.log(level, marker, string, null, throwable);
    }

    private void logWithArg(Level level, Marker marker, String string, Object object) {
        this.log(level, marker, string, new Object[]{object}, null);
    }

    private void logWithArgs(Level level, Marker marker, String string, Object object, Object object2) {
        if (object2 instanceof Throwable) {
            this.log(level, marker, string, new Object[]{object}, (Throwable)object2);
        } else {
            this.log(level, marker, string, new Object[]{object, object2}, null);
        }
    }

    private void logWithArgs(Level level, Marker marker, String string, Object[] objectArray) {
        Throwable throwable = MessageFormatter.getThrowableCandidate((Object[])objectArray);
        if (throwable != null) {
            Object[] objectArray2 = MessageFormatter.trimmedCopy((Object[])objectArray);
            this.log(level, marker, string, objectArray2, throwable);
        } else {
            this.log(level, marker, string, objectArray, null);
        }
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void trace(String string) {
        this.logWithThrowable(Level.TRACE, null, string, null);
    }

    public void trace(String string, Object object) {
        this.logWithArg(Level.TRACE, null, string, object);
    }

    public void trace(String string, Object object, Object object2) {
        this.logWithArgs(Level.TRACE, null, string, object, object2);
    }

    public void trace(String string, Object ... objectArray) {
        this.logWithArgs(Level.TRACE, null, string, objectArray);
    }

    public void trace(String string, Throwable throwable) {
        this.logWithThrowable(Level.TRACE, null, string, throwable);
    }

    public void debug(String string) {
        this.logWithThrowable(Level.DEBUG, null, string, null);
    }

    public void debug(String string, Object object) {
        this.logWithArg(Level.DEBUG, null, string, object);
    }

    public void debug(String string, Object object, Object object2) {
        this.logWithArgs(Level.DEBUG, null, string, object, object2);
    }

    public void debug(String string, Object ... objectArray) {
        this.logWithArgs(Level.DEBUG, null, string, objectArray);
    }

    public void debug(String string, Throwable throwable) {
        this.logWithThrowable(Level.DEBUG, null, string, throwable);
    }

    public void info(String string) {
        this.logWithThrowable(Level.INFO, null, string, null);
    }

    public void info(String string, Object object) {
        this.logWithArg(Level.INFO, null, string, object);
    }

    public void info(String string, Object object, Object object2) {
        this.logWithArgs(Level.INFO, null, string, object, object2);
    }

    public void info(String string, Object ... objectArray) {
        this.logWithArgs(Level.INFO, null, string, objectArray);
    }

    public void info(String string, Throwable throwable) {
        this.logWithThrowable(Level.INFO, null, string, throwable);
    }

    public void warn(String string) {
        this.logWithThrowable(Level.WARN, null, string, null);
    }

    public void warn(String string, Object object) {
        this.logWithArg(Level.WARN, null, string, object);
    }

    public void warn(String string, Object object, Object object2) {
        this.logWithArgs(Level.WARN, null, string, object, object2);
    }

    public void warn(String string, Object ... objectArray) {
        this.logWithArgs(Level.WARN, null, string, objectArray);
    }

    public void warn(String string, Throwable throwable) {
        this.logWithThrowable(Level.WARN, null, string, throwable);
    }

    public void error(String string) {
        this.logWithThrowable(Level.ERROR, null, string, null);
    }

    public void error(String string, Object object) {
        this.logWithArg(Level.ERROR, null, string, object);
    }

    public void error(String string, Object object, Object object2) {
        this.logWithArgs(Level.ERROR, null, string, object, object2);
    }

    public void error(String string, Object ... objectArray) {
        this.logWithArgs(Level.ERROR, null, string, objectArray);
    }

    public void error(String string, Throwable throwable) {
        this.logWithThrowable(Level.ERROR, null, string, throwable);
    }
}

