/*
 * Decompiled with CFR 0.152.
 */
package zio.logging.jul.bridge;

import java.io.Serializable;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapOps;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import zio.Cause;
import zio.Cause$;
import zio.Fiber;
import zio.Fiber$;
import zio.FiberId;
import zio.FiberRef$;
import zio.FiberRefs;
import zio.FiberRefs$;
import zio.LogLevel;
import zio.LogSpan;
import zio.LogSpan$;
import zio.Runtime;
import zio.Trace$;
import zio.Unsafe$;
import zio.internal.FiberRuntime;
import zio.internal.FiberRuntime$;
import zio.logging.LogFilter;
import zio.logging.jul.bridge.ZioLoggerRuntime$;
import zio.logging.package$;

public final class ZioLoggerRuntime
extends Handler {
    private final Runtime<Object> runtime;
    private final LogFilter<Object> filter;

    public ZioLoggerRuntime(Runtime<Object> runtime, LogFilter<Object> filter) {
        this.runtime = runtime;
        this.filter = filter;
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isEnabled(record.getLoggerName(), record.getLevel())) {
            return;
        }
        Unsafe$.MODULE$.unsafe((Function1)(JProcedure1 & Serializable)u -> {
            String msg = record.getMessage();
            Level level = record.getLevel();
            String name = record.getLoggerName();
            Throwable throwable = record.getThrown();
            LogLevel logLevel = (LogLevel)ZioLoggerRuntime$.zio$logging$jul$bridge$ZioLoggerRuntime$$$logLevelMapping.apply((Object)level);
            Object trace = Trace$.MODULE$.empty();
            FiberId.Runtime fiberId = FiberId.Gen$.Live$.MODULE$.make(trace, u);
            Fiber.Runtime currentFiber = (Fiber.Runtime)Fiber$.MODULE$._currentFiber().get();
            FiberRefs currentFiberRefs = currentFiber == null ? this.runtime.fiberRefs().joinAs(fiberId, FiberRefs$.MODULE$.empty()) : this.runtime.fiberRefs().joinAs(fiberId, currentFiber.unsafe().getFiberRefs(u));
            LogSpan logSpan = LogSpan$.MODULE$.apply(name, System.currentTimeMillis());
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.loggerNameAnnotationKey());
            Tuple2 loggerName = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)name);
            FiberRefs fiberRefs = currentFiberRefs.updatedAs(fiberId, FiberRef$.MODULE$.currentLogSpan(), (Object)((List)currentFiberRefs.getOrDefault(FiberRef$.MODULE$.currentLogSpan())).$colon$colon((Object)logSpan)).updatedAs(fiberId, FiberRef$.MODULE$.currentLogAnnotations(), (Object)((MapOps)currentFiberRefs.getOrDefault(FiberRef$.MODULE$.currentLogAnnotations())).$plus(loggerName));
            FiberRuntime fiberRuntime = FiberRuntime$.MODULE$.apply(fiberId, fiberRefs, this.runtime.runtimeFlags());
            Cause cause = throwable != null ? Cause$.MODULE$.die(throwable, Cause$.MODULE$.die$default$2()) : Cause$.MODULE$.empty();
            fiberRuntime.log((Function0 & Serializable)() -> msg, cause, (Option)Some$.MODULE$.apply((Object)logLevel), trace);
        });
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    private boolean isEnabled(String name, Level level) {
        LogLevel logLevel = (LogLevel)ZioLoggerRuntime$.zio$logging$jul$bridge$ZioLoggerRuntime$$$logLevelMapping.apply((Object)level);
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.loggerNameAnnotationKey());
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)name);
        return this.filter.apply(Trace$.MODULE$.apply(name, "", 0), (FiberId)FiberId.None$.MODULE$, logLevel, (Function0 & Serializable)() -> "", Cause$.MODULE$.empty(), FiberRefs$.MODULE$.empty(), scala.package$.MODULE$.List().empty(), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
    }
}

