/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.consumer.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.util.Collection;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.TopicPartition;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.Exit$;
import zio.Fiber;
import zio.Has;
import zio.Promise;
import zio.Promise$;
import zio.Runtime;
import zio.Task$;
import zio.UIO$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZManaged;
import zio.clock.package;
import zio.duration.package$;
import zio.kafka.consumer.CommittableRecord;
import zio.kafka.consumer.CommittableRecord$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent;
import zio.kafka.consumer.internal.Runloop;
import zio.kafka.consumer.internal.Runloop$State$;
import zio.kafka.consumer.package;
import zio.stream.Take;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class Runloop$
implements scala.Serializable {
    public static Runloop$ MODULE$;
    private volatile byte bitmap$init$0;

    static {
        new Runloop$();
    }

    public ZManaged<Has<package.Clock.Service>, Throwable, Runloop> apply(Runloop.Deps deps) {
        return ZStream$.MODULE$.mergeAll(3, 32, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new ZStream[]{deps.polls(), deps.requests(), deps.commits()})).foldM((Object)Runloop$State$.MODULE$.initial(), (Function2 & Serializable & scala.Serializable)(state, cmd) -> deps.isShutdown().flatMap((Function1 & Serializable & scala.Serializable)shutdown -> Runloop$.$anonfun$apply$69(state, cmd, deps, BoxesRunTime.unboxToBoolean((Object)shutdown)))).onError((Function1 & Serializable & scala.Serializable)cause -> deps.partitions().offer((Object)new Take.Fail(cause))).unit().toManaged_().fork().map((Function1 & Serializable & scala.Serializable)x$25 -> new Runloop((Fiber<Throwable, BoxedUnit>)x$25, deps));
    }

    public Runloop apply(Fiber<Throwable, BoxedUnit> fiber, Runloop.Deps deps) {
        return new Runloop(fiber, deps);
    }

    public Option<Tuple2<Fiber<Throwable, BoxedUnit>, Runloop.Deps>> unapply(Runloop x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.fiber(), (Object)x$0.deps()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$apply$4(BoxedUnit _) {
    }

    private static final ZIO commit$1(scala.collection.immutable.Map offsets, Runloop.Deps deps$1) {
        return Promise$.MODULE$.make().flatMap((Function1 & Serializable & scala.Serializable)p -> deps$1.commit(new Runloop.Command.Commit((scala.collection.immutable.Map<TopicPartition, Object>)offsets, (Promise<Throwable, BoxedUnit>)p)).flatMap((Function1 & Serializable & scala.Serializable)_ -> deps$1.emitIfEnabledDiagnostic(new DiagnosticEvent.Commit.Started((scala.collection.immutable.Map<TopicPartition, Object>)offsets)).flatMap((Function1 & Serializable & scala.Serializable)_2 -> p.await().map((Function1 & Serializable & scala.Serializable)_ -> {
            Runloop$.$anonfun$apply$4(_);
            return BoxedUnit.UNIT;
        }))));
    }

    public static final /* synthetic */ void $anonfun$apply$6(scala.collection.mutable.Map offsets$2, Runloop.Command.Commit commit) {
        commit.offsets().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long offset = tuple2._2$mcJ$sp();
            long existing = BoxesRunTime.unboxToLong((Object)offsets$2.get((Object)tp).fold((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L, (Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.offset())));
            BoxedUnit boxedUnit = existing < offset ? offsets$2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetAndMetadata(offset + 1L))) : BoxedUnit.UNIT;
            return boxedUnit;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$17(BoxedUnit _) {
    }

    private static final ZIO doCommit$1(List cmds, Runloop.Deps deps$1) {
        return ZIO$.MODULE$.runtime().map((Function1 & Serializable & scala.Serializable)runtime -> {
            scala.collection.mutable.Map offsets = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            cmds.foreach((Function1 & Serializable & scala.Serializable)commit -> {
                Runloop$.$anonfun$apply$6(offsets, commit);
                return BoxedUnit.UNIT;
            });
            scala.collection.immutable.Map offsets2 = offsets.toMap(Predef$.MODULE$.$conforms());
            Function1 & Serializable & scala.Serializable cont = (Function1 & Serializable & scala.Serializable)e -> ZIO$.MODULE$.foreach_((Iterable)cmds, (Function1 & Serializable & scala.Serializable)x$8 -> x$8.cont().done(e));
            return new Tuple3(runtime, (Object)offsets2, (Object)cont);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> {
            Tuple3 tuple3 = x$9;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Runtime runtime = (Runtime)tuple3._1();
            scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)tuple3._2();
            Function1 cont = (Function1)tuple3._3();
            ZIO zIO = deps$1.consumer().withConsumerM((Function1 & Serializable & scala.Serializable)c -> ZIO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> c.commitAsync((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsets).asJava(), new OffsetCommitCallback(runtime, cont, deps$1, offsets){
                private final Runtime runtime$2;
                private final Function1 cont$1;
                private final Runloop.Deps deps$1;
                private final scala.collection.immutable.Map offsets$3;

                public void onComplete(java.util.Map<TopicPartition, OffsetAndMetadata> data, Exception err) {
                    if (err == null) {
                        this.runtime$2.unsafeRun((Function0 & Serializable & scala.Serializable)() -> ((ZIO)$this.cont$1.apply((Object)Exit$.MODULE$.succeed((Object)BoxedUnit.UNIT))).$less$times((Function0 & Serializable & scala.Serializable)() -> $this.deps$1.emitIfEnabledDiagnostic(new DiagnosticEvent.Commit.Success((scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)$this.offsets$3))));
                    } else {
                        this.runtime$2.unsafeRun((Function0 & Serializable & scala.Serializable)() -> ((ZIO)$this.cont$1.apply((Object)Exit$.MODULE$.fail((Object)err))).$less$times((Function0 & Serializable & scala.Serializable)() -> $this.deps$1.emitIfEnabledDiagnostic(new DiagnosticEvent.Commit.Failure((scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)$this.offsets$3, err))));
                    }
                }
                {
                    this.runtime$2 = runtime$2;
                    this.cont$1 = cont$1;
                    this.deps$1 = deps$1;
                    this.offsets$3 = offsets$3;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(zio.kafka.consumer.internal.Runloop$$anon$2 ), $anonfun$onComplete$3(zio.kafka.consumer.internal.Runloop$$anon$2 java.lang.Exception ), $anonfun$onComplete$2(zio.kafka.consumer.internal.Runloop$$anon$2 ), $anonfun$onComplete$4(zio.kafka.consumer.internal.Runloop$$anon$2 java.lang.Exception )}, serializedLambda);
                }
            }))).catchAll((Function1 & Serializable & scala.Serializable)e -> ((ZIO)cont.apply((Object)Exit$.MODULE$.fail(e))).$less$times((Function0 & Serializable & scala.Serializable)() -> deps$1.emitIfEnabledDiagnostic(new DiagnosticEvent.Commit.Failure((scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsets, (Throwable)e))), CanFail$.MODULE$.canFail()).map((Function1 & Serializable & scala.Serializable)_ -> {
                Runloop$.$anonfun$apply$17(_);
                return BoxedUnit.UNIT;
            });
            return zIO;
        });
    }

    private static final ZIO endRevoked$1(List reqs, scala.collection.immutable.Map bufferedRecords, Function1 revoked) {
        ObjectRef acc = ObjectRef.create((Object)Nil$.MODULE$);
        scala.collection.mutable.Map buf = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        buf.$plus$plus$eq((TraversableOnce)bufferedRecords);
        ZIO revokeAction = UIO$.MODULE$.unit();
        for (Runloop.Command.Request req : reqs) {
            BoxedUnit boxedUnit;
            if (BoxesRunTime.unboxToBoolean((Object)revoked.apply((Object)req.tp()))) {
                revokeAction = revokeAction.$times$greater((Function0 & Serializable & scala.Serializable)() -> req.cont().fail((Object)None$.MODULE$));
                boxedUnit = buf.$minus$eq((Object)req.tp());
                continue;
            }
            acc.elem = ((List)acc.elem).$colon$colon((Object)req);
            boxedUnit = BoxedUnit.UNIT;
        }
        return revokeAction.as((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)((List)acc$1.elem).reverse(), (Object)buf.toMap(Predef$.MODULE$.$conforms())));
    }

    private static final ZIO fulfillRequests$1(List pendingRequests, scala.collection.immutable.Map bufferedRecords, ConsumerRecords records, Runloop.Deps deps$1) {
        ObjectRef acc = ObjectRef.create((Object)Nil$.MODULE$);
        scala.collection.mutable.Map buf = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        buf.$plus$plus$eq((TraversableOnce)bufferedRecords);
        ZIO fulfillAction = UIO$.MODULE$.unit();
        for (Runloop.Command.Request req : pendingRequests) {
            BoxedUnit boxedUnit;
            Chunk bufferedChunk = (Chunk)buf.getOrElse((Object)req.tp(), (Function0 & Serializable & scala.Serializable)() -> Chunk$.MODULE$.empty());
            java.util.List reqRecs = records.records(req.tp());
            if (bufferedChunk.length() + reqRecs.size() == 0) {
                acc.elem = ((List)acc.elem).$colon$colon((Object)req);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Chunk concatenatedChunk = bufferedChunk.$plus$plus(Chunk$.MODULE$.fromArray((Object)reqRecs.toArray((Object[])Array$.MODULE$.ofDim(reqRecs.size(), ClassTag$.MODULE$.apply(ConsumerRecord.class)))));
            fulfillAction = fulfillAction.$times$greater((Function0 & Serializable & scala.Serializable)() -> req.cont().succeed((Object)concatenatedChunk.map((Function1 & Serializable & scala.Serializable)x$10 -> CommittableRecord$.MODULE$.apply(x$10, (Function1<scala.collection.immutable.Map<TopicPartition, Object>, ZIO<Object, Throwable, BoxedUnit>>)(Function1 & Serializable & scala.Serializable)x$11 -> Runloop$.commit$1(x$11, deps$1)))));
            boxedUnit = buf.$minus$eq((Object)req.tp());
        }
        return fulfillAction.as((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)((List)acc$2.elem), (Object)buf.toMap(Predef$.MODULE$.$conforms())));
    }

    private static final scala.collection.immutable.Map bufferUnrequestedPartitions$1(ConsumerRecords records, Iterable unrequestedTps) {
        Builder builder = Predef$.MODULE$.Map().newBuilder();
        builder.sizeHint(unrequestedTps.size());
        for (TopicPartition tp : unrequestedTps) {
            java.util.List recs = records.records(tp);
            Object object = recs.size() > 0 ? builder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Chunk$.MODULE$.fromArray((Object)recs.toArray((Object[])Array$.MODULE$.ofDim(recs.size(), ClassTag$.MODULE$.apply(ConsumerRecord.class)))))) : BoxedUnit.UNIT;
        }
        return (scala.collection.immutable.Map)builder.result();
    }

    private static final ZIO doSeekForNewPartitions$1(scala.collection.immutable.Set tps, Runloop.Deps deps$1, KafkaConsumer c$2) {
        ZIO zIO;
        package.Consumer.OffsetRetrieval offsetRetrieval = deps$1.offsetRetrieval();
        if (offsetRetrieval instanceof package.Consumer.OffsetRetrieval.Manual) {
            package.Consumer.OffsetRetrieval.Manual manual = (package.Consumer.OffsetRetrieval.Manual)offsetRetrieval;
            Function1<scala.collection.immutable.Set<TopicPartition>, ZIO<Object, Throwable, scala.collection.immutable.Map<TopicPartition, Object>>> getOffsets = manual.getOffsets();
            zIO = ((ZIO)getOffsets.apply((Object)tps)).flatMap((Function1 & Serializable & scala.Serializable)offsets -> ZIO$.MODULE$.foreach((Iterable)offsets, (Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                long offset = tuple2._2$mcJ$sp();
                ZIO zIO = ZIO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> c$2.seek(tp, offset));
                return zIO;
            })).when((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> tps.nonEmpty());
        } else if (offsetRetrieval instanceof package.Consumer.OffsetRetrieval.Auto) {
            zIO = ZIO$.MODULE$.unit();
        } else {
            throw new MatchError((Object)offsetRetrieval);
        }
        return zIO;
    }

    public static final /* synthetic */ ZIO $anonfun$apply$32(KafkaConsumer c$2, scala.collection.immutable.Set requestedPartitions$1, Runloop.State state$1, ConsumerRecords records$1, scala.collection.immutable.Set prevAssigned$1, Runloop.Deps deps$1, boolean shutdown) {
        ZIO zIO;
        if (shutdown) {
            zIO = ZIO$.MODULE$.effectTotal((Function0 & Serializable & scala.Serializable)() -> {
                scala.collection.immutable.Set currentAssigned = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(c$2.assignment()).asScala()).toSet();
                c$2.pause((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)requestedPartitions$1.intersect((GenSet)currentAssigned)).asJava());
                return new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)new Tuple2(state$1.pendingRequests(), (Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
            });
        } else if (records$1 == null) {
            zIO = ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)new Tuple2(state$1.pendingRequests(), (Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$))));
        } else {
            scala.collection.immutable.Set tpsInResponse = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(records$1.partitions()).asScala()).toSet();
            scala.collection.immutable.Set currentAssigned = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(c$2.assignment()).asScala()).toSet();
            scala.collection.immutable.Set newlyAssigned = (scala.collection.immutable.Set)currentAssigned.$minus$minus((GenTraversableOnce)prevAssigned$1);
            scala.collection.immutable.Set revoked = (scala.collection.immutable.Set)prevAssigned$1.$minus$minus((GenTraversableOnce)currentAssigned);
            scala.collection.immutable.Map unrequestedRecords = Runloop$.bufferUnrequestedPartitions$1(records$1, (Iterable)tpsInResponse.$minus$minus((GenTraversableOnce)requestedPartitions$1));
            zIO = Runloop$.doSeekForNewPartitions$1(newlyAssigned, deps$1, c$2).$times$greater((Function0 & Serializable & scala.Serializable)() -> Runloop$.endRevoked$1(state$1.pendingRequests(), state$1.addBufferedRecords((scala.collection.immutable.Map<TopicPartition, Chunk<ConsumerRecord<byte[], byte[]>>>)unrequestedRecords).bufferedRecords(), (Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)revoked.apply((Object)x$13))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                List pendingRequests = (List)tuple2._1();
                scala.collection.immutable.Map bufferedRecords = (scala.collection.immutable.Map)tuple2._2();
                ZIO zIO = Runloop$.fulfillRequests$1(pendingRequests, bufferedRecords, records$1, deps$1).map((Function1 & Serializable & scala.Serializable)output -> {
                    Tuple2 tuple2 = output;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    List notFulfilled = (List)tuple2._1();
                    scala.collection.immutable.Map fulfilled = (scala.collection.immutable.Map)tuple2._2();
                    Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)notFulfilled, (Object)fulfilled);
                    Tuple3 tuple32 = tuple3;
                    Tuple2 x$15 = (Tuple2)tuple32._1();
                    List notFulfilled2 = (List)tuple32._2();
                    scala.collection.immutable.Map fulfilled2 = (scala.collection.immutable.Map)tuple32._3();
                    return new Tuple2(output, (Object)x$15);
                }).flatMap((Function1 & Serializable & scala.Serializable)x$17 -> {
                    Tuple2 tuple2;
                    Tuple2 output;
                    block3: {
                        Tuple2 tuple22;
                        block2: {
                            tuple22 = x$17;
                            if (tuple22 == null) break block2;
                            output = (Tuple2)tuple22._1();
                            tuple2 = (Tuple2)tuple22._2();
                            if (tuple2 != null) break block3;
                        }
                        throw new MatchError((Object)tuple22);
                    }
                    List notFulfilled = (List)tuple2._1();
                    scala.collection.immutable.Map fulfilled = (scala.collection.immutable.Map)tuple2._2();
                    ZIO zIO = deps$1.emitIfEnabledDiagnostic(new DiagnosticEvent.Poll((scala.collection.immutable.Set<TopicPartition>)requestedPartitions$1, (scala.collection.immutable.Set<TopicPartition>)fulfilled.keySet(), (scala.collection.immutable.Set<TopicPartition>)((TraversableOnce)notFulfilled.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.tp(), List$.MODULE$.canBuildFrom())).toSet())).map((Function1 & Serializable & scala.Serializable)_ -> output);
                    return zIO;
                });
                return zIO;
            }).map((Function1 & Serializable & scala.Serializable)x$18 -> new Tuple2((Object)newlyAssigned, x$18)));
        }
        return zIO;
    }

    public static final /* synthetic */ ZIO $anonfun$apply$47(Runloop.State state$1, List unfulfilledRequests$1, scala.collection.immutable.Map bufferedRecords$1, Runloop.Deps deps$1, boolean stillRebalancing) {
        return (!stillRebalancing && state$1.pendingCommits().nonEmpty() ? Runloop$.doCommit$1(state$1.pendingCommits(), deps$1).as((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$) : ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> state$1.pendingCommits())).map((Function1 & Serializable & scala.Serializable)newPendingCommits -> new Runloop.State((List<Runloop.Command.Request>)unfulfilledRequests$1, (List<Runloop.Command.Commit>)newPendingCommits, (scala.collection.immutable.Map<TopicPartition, Chunk<ConsumerRecord<byte[], byte[]>>>)bufferedRecords$1));
    }

    private static final ZIO handlePoll$1(Runloop.State state, Runloop.Deps deps$1) {
        return deps$1.consumer().withConsumerM((Function1 & Serializable & scala.Serializable)c -> Task$.MODULE$.effectSuspend((Function0 & Serializable & scala.Serializable)() -> {
            ConsumerRecords consumerRecords;
            scala.collection.immutable.Set prevAssigned = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(c.assignment()).asScala()).toSet();
            scala.collection.immutable.Set requestedPartitions = ((TraversableOnce)state.pendingRequests().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.tp(), List$.MODULE$.canBuildFrom())).toSet();
            scala.collection.immutable.Set toResume = (scala.collection.immutable.Set)prevAssigned.intersect((GenSet)requestedPartitions);
            scala.collection.immutable.Set toPause = (scala.collection.immutable.Set)prevAssigned.$minus$minus((GenTraversableOnce)requestedPartitions);
            c.resume((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)toResume).asJava());
            c.pause((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)toPause).asJava());
            Duration pollTimeout = requestedPartitions.nonEmpty() ? deps$1.pollTimeout().asJava() : package$.MODULE$.durationInt(0).millis().asJava();
            try {
                consumerRecords = c.poll(pollTimeout);
            }
            catch (IllegalStateException illegalStateException) {
                consumerRecords = null;
            }
            ConsumerRecords records = consumerRecords;
            return deps$1.isShutdown().flatMap((Function1 & Serializable & scala.Serializable)shutdown -> Runloop$.$anonfun$apply$32(c, requestedPartitions, state, records, prevAssigned, deps$1, BoxesRunTime.unboxToBoolean((Object)shutdown)));
        })).map((Function1 & Serializable & scala.Serializable)pollResult -> {
            Tuple2 tuple2;
            scala.collection.immutable.Set newlyAssigned;
            Tuple2 tuple22;
            block3: {
                block2: {
                    tuple22 = pollResult;
                    if (tuple22 == null) break block2;
                    newlyAssigned = (scala.collection.immutable.Set)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            List unfulfilledRequests = (List)tuple2._1();
            scala.collection.immutable.Map bufferedRecords = (scala.collection.immutable.Map)tuple2._2();
            Tuple4 tuple4 = new Tuple4((Object)tuple22, (Object)newlyAssigned, (Object)unfulfilledRequests, (Object)bufferedRecords);
            Tuple4 tuple42 = tuple4;
            Tuple2 x$19 = (Tuple2)tuple42._1();
            scala.collection.immutable.Set newlyAssigned2 = (scala.collection.immutable.Set)tuple42._2();
            List unfulfilledRequests2 = (List)tuple42._3();
            scala.collection.immutable.Map bufferedRecords2 = (scala.collection.immutable.Map)tuple42._4();
            return new Tuple2(pollResult, (Object)x$19);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$21 -> {
            Tuple2 tuple2;
            scala.collection.immutable.Set newlyAssigned;
            block3: {
                Tuple2 tuple22;
                block2: {
                    Tuple2 tuple23;
                    tuple22 = x$21;
                    if (tuple22 == null || (tuple23 = (Tuple2)tuple22._2()) == null) break block2;
                    newlyAssigned = (scala.collection.immutable.Set)tuple23._1();
                    tuple2 = (Tuple2)tuple23._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            List unfulfilledRequests = (List)tuple2._1();
            scala.collection.immutable.Map bufferedRecords = (scala.collection.immutable.Map)tuple2._2();
            ZIO zIO = ZIO$.MODULE$.foreach_((Iterable)newlyAssigned, (Function1 & Serializable & scala.Serializable)tp -> deps$1.newPartitionStream((TopicPartition)tp)).flatMap((Function1 & Serializable & scala.Serializable)_ -> deps$1.isRebalancing().flatMap((Function1 & Serializable & scala.Serializable)stillRebalancing -> Runloop$.$anonfun$apply$47(state, unfulfilledRequests, bufferedRecords, deps$1, BoxesRunTime.unboxToBoolean((Object)stillRebalancing))));
            return zIO;
        });
    }

    public static final /* synthetic */ ZIO $anonfun$apply$53(scala.collection.mutable.Set assignment$1, Runloop.Command.Request req$3, Runloop.State state$2, boolean rebalancing) {
        return (!rebalancing && !assignment$1.contains((Object)req$3.tp()) ? req$3.cont().fail((Object)None$.MODULE$).as((Function0 & Serializable & scala.Serializable)() -> state$2) : UIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> state$2.addRequest(req$3))).map((Function1 & Serializable & scala.Serializable)newState -> newState);
    }

    private static final ZIO handleRequest$1(Runloop.State state, Runloop.Command.Request req, Runloop.Deps deps$1) {
        return deps$1.consumer().withConsumer((Function1 & Serializable & scala.Serializable)x$22 -> (scala.collection.mutable.Set)CollectionConverters$.MODULE$.asScalaSetConverter(x$22.assignment()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)assignment -> deps$1.isRebalancing().flatMap((Function1 & Serializable & scala.Serializable)rebalancing -> Runloop$.$anonfun$apply$53(assignment, req, state, BoxesRunTime.unboxToBoolean((Object)rebalancing)))).orElse((Function0 & Serializable & scala.Serializable)() -> UIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> state.addRequest(req)), CanFail$.MODULE$.canFail());
    }

    public static final /* synthetic */ ZIO $anonfun$apply$59(Runloop.State state$3, Runloop.Command.Commit cmd$1, Runloop.Deps deps$1, boolean rebalancing) {
        return (rebalancing ? UIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> state$3.addCommit(cmd$1)) : Runloop$.doCommit$1((List)new .colon.colon((Object)cmd$1, (List)Nil$.MODULE$), deps$1).as((Function0 & Serializable & scala.Serializable)() -> state$3)).map((Function1 & Serializable & scala.Serializable)newState -> newState);
    }

    private static final ZIO handleCommit$1(Runloop.State state, Runloop.Command.Commit cmd, Runloop.Deps deps$1) {
        return deps$1.isRebalancing().flatMap((Function1 & Serializable & scala.Serializable)rebalancing -> Runloop$.$anonfun$apply$59(state, cmd, deps$1, BoxesRunTime.unboxToBoolean((Object)rebalancing)));
    }

    private static final ZIO handleShutdown$1(Runloop.State state, Runloop.Command cmd, Runloop.Deps deps$1) {
        ZIO zIO;
        Runloop.Command command = cmd;
        if (command instanceof Runloop.Command.Poll) {
            ZIO zIO2;
            List<Runloop.Command.Request> list = state.pendingRequests();
            if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                Runloop.Command.Request h = (Runloop.Command.Request)colon2.head();
                List t = colon2.tl$access$1();
                zIO2 = Runloop$.handleShutdown$1(state, h, deps$1).flatMap((Function1 & Serializable & scala.Serializable)s -> Runloop$.handleShutdown$1(s.copy((List<Runloop.Command.Request>)t, s.copy$default$2(), s.copy$default$3()), cmd, deps$1));
            } else if (Nil$.MODULE$.equals(list)) {
                zIO2 = Runloop$.handlePoll$1(state, deps$1);
            } else {
                throw new MatchError(list);
            }
            zIO = zIO2;
        } else if (command instanceof Runloop.Command.Request) {
            ZIO zIO3;
            Runloop.Command.Request request = (Runloop.Command.Request)command;
            TopicPartition tp = request.tp();
            Promise<Option<Throwable>, Chunk<CommittableRecord<byte[], byte[]>>> cont = request.cont();
            Option option = state.bufferedRecords().get((Object)tp);
            if (option instanceof Some) {
                Some some = (Some)option;
                Chunk recs = (Chunk)some.value();
                zIO3 = cont.succeed((Object)recs.map((Function1 & Serializable & scala.Serializable)x$23 -> CommittableRecord$.MODULE$.apply(x$23, (Function1<scala.collection.immutable.Map<TopicPartition, Object>, ZIO<Object, Throwable, BoxedUnit>>)(Function1 & Serializable & scala.Serializable)x$24 -> Runloop$.commit$1(x$24, deps$1)))).as((Function0 & Serializable & scala.Serializable)() -> state.removeBufferedRecordsFor(tp));
            } else if (None$.MODULE$.equals(option)) {
                zIO3 = cont.fail((Object)None$.MODULE$).as((Function0 & Serializable & scala.Serializable)() -> state);
            } else {
                throw new MatchError((Object)option);
            }
            zIO = zIO3;
        } else if (command instanceof Runloop.Command.Commit) {
            Runloop.Command.Commit commit = (Runloop.Command.Commit)command;
            zIO = Runloop$.handleCommit$1(state, commit, deps$1);
        } else {
            throw new MatchError((Object)command);
        }
        return zIO;
    }

    public static final /* synthetic */ ZIO $anonfun$apply$69(Runloop.State state$5, Runloop.Command cmd$3, Runloop.Deps deps$1, boolean shutdown) {
        ZIO zIO;
        if (shutdown) {
            zIO = Runloop$.handleShutdown$1(state$5, cmd$3, deps$1);
        } else {
            ZIO zIO2;
            Runloop.Command command = cmd$3;
            if (command instanceof Runloop.Command.Poll) {
                zIO2 = Runloop$.handlePoll$1(state$5, deps$1);
            } else if (command instanceof Runloop.Command.Request) {
                Runloop.Command.Request request = (Runloop.Command.Request)command;
                zIO2 = Runloop$.handleRequest$1(state$5, request, deps$1);
            } else if (command instanceof Runloop.Command.Commit) {
                Runloop.Command.Commit commit = (Runloop.Command.Commit)command;
                zIO2 = Runloop$.handleCommit$1(state$5, commit, deps$1);
            } else {
                throw new MatchError((Object)command);
            }
            zIO = zIO2;
        }
        return zIO;
    }

    private Runloop$() {
        MODULE$ = this;
    }
}

