/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.testkit;

import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import zio.Cause$;
import zio.Chunk;
import zio.Chunk$;
import zio.DurationSyntax$;
import zio.Exit;
import zio.Runtime$;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.ZLayer$;
import zio.kafka.admin.AdminClient;
import zio.kafka.admin.AdminClient$;
import zio.kafka.admin.AdminClientSettings;
import zio.kafka.admin.AdminClientSettings$;
import zio.kafka.consumer.Consumer;
import zio.kafka.consumer.Consumer$;
import zio.kafka.consumer.ConsumerSettings;
import zio.kafka.consumer.ConsumerSettings$;
import zio.kafka.consumer.RebalanceListener;
import zio.kafka.consumer.RebalanceListener$;
import zio.kafka.consumer.Subscription;
import zio.kafka.consumer.diagnostics.Diagnostics;
import zio.kafka.producer.Producer;
import zio.kafka.producer.Producer$;
import zio.kafka.producer.ProducerSettings;
import zio.kafka.producer.ProducerSettings$;
import zio.kafka.producer.TransactionalProducer;
import zio.kafka.producer.TransactionalProducer$;
import zio.kafka.producer.TransactionalProducerSettings;
import zio.kafka.producer.TransactionalProducerSettings$;
import zio.kafka.serde.Deserializer;
import zio.kafka.serde.Deserializer$;
import zio.kafka.serde.Serde$;
import zio.kafka.serde.Serializer;
import zio.kafka.testkit.Kafka;
import zio.package;
import zio.package$;

public final class KafkaTestUtils$ {
    public static final KafkaTestUtils$ MODULE$ = new KafkaTestUtils$();
    private static File trustStoreFile;
    private static File keyStoreFile;
    private static final ZIO<Kafka, Nothing$, ProducerSettings> producerSettings;
    private static final ZLayer<Kafka, Throwable, Producer> producer;
    private static final ZIO<Kafka, Nothing$, TransactionalProducerSettings> transactionalProducerSettings;
    private static final ZLayer<Kafka, Throwable, TransactionalProducer> transactionalProducer;
    private static final ZIO<Kafka, Nothing$, AdminClientSettings> adminSettings;
    private static final ZIO<Kafka, Nothing$, AdminClientSettings> sslAdminSettings;
    private static volatile byte bitmap$0;

    static {
        producerSettings = ZIO.ServiceWithPartiallyApplied$.MODULE$.apply$extension(ZIO$.MODULE$.serviceWith(), (Function1 & Serializable)x$1 -> x$1.bootstrapServers(), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(Kafka.class, LightTypeTag$.MODULE$.parse(1661891183, "\u0004\u0000\u0001\u0017zio.kafka.testkit.Kafka\u0001\u0001", "\u0000\u0000\u0000", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.producerSettings(KafkaTestUtils.scala:23)").map((Function1 & Serializable)x$2 -> ProducerSettings$.MODULE$.apply(x$2), (Object)"zio.kafka.testkit.KafkaTestUtils.producerSettings(KafkaTestUtils.scala:24)");
        ZLayer layer$macro$1 = ZLayer$.MODULE$.environment((Object)"zio.kafka.testkit.KafkaTestUtils.producer.layer$macro$1(KafkaTestUtils.scala:30)");
        ZLayer layer$macro$2 = ZLayer$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.producerSettings(), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(ProducerSettings.class, LightTypeTag$.MODULE$.parse(1379118631, "\u0004\u0000\u0001#zio.kafka.producer.ProducerSettings\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001#zio.kafka.producer.ProducerSettings\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0003\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.producer(KafkaTestUtils.scala:31)");
        ZLayer layer$macro$3 = Producer$.MODULE$.live();
        producer = ZLayer.ZLayerProvideSomeOps$.MODULE$.$greater$greater$greater$extension(ZLayer$.MODULE$.ZLayerProvideSomeOps(ZLayer.ZLayerProvideSomeOps$.MODULE$.$greater$greater$greater$extension(ZLayer$.MODULE$.ZLayerProvideSomeOps(layer$macro$1), (Function0 & Serializable)() -> layer$macro$2, (Object)"zio.kafka.testkit.KafkaTestUtils.producer(KafkaTestUtils.scala:30)")), (Function0 & Serializable)() -> layer$macro$3, (Object)"zio.kafka.testkit.KafkaTestUtils.producer(KafkaTestUtils.scala:30)");
        transactionalProducerSettings = ZIO.ServiceWithPartiallyApplied$.MODULE$.apply$extension(ZIO$.MODULE$.serviceWith(), (Function1 & Serializable)x$3 -> x$3.bootstrapServers(), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(Kafka.class, LightTypeTag$.MODULE$.parse(1661891183, "\u0004\u0000\u0001\u0017zio.kafka.testkit.Kafka\u0001\u0001", "\u0000\u0000\u0000", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.transactionalProducerSettings(KafkaTestUtils.scala:40)").map((Function1 & Serializable)x$4 -> TransactionalProducerSettings$.MODULE$.apply(x$4, "test-transaction"), (Object)"zio.kafka.testkit.KafkaTestUtils.transactionalProducerSettings(KafkaTestUtils.scala:41)");
        ZLayer layer$macro$4 = ZLayer$.MODULE$.environment((Object)"zio.kafka.testkit.KafkaTestUtils.transactionalProducer.layer$macro$4(KafkaTestUtils.scala:47)");
        ZLayer layer$macro$5 = ZLayer$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.transactionalProducerSettings(), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(TransactionalProducerSettings.class, LightTypeTag$.MODULE$.parse(1506795726, "\u0004\u0000\u00010zio.kafka.producer.TransactionalProducerSettings\u0001\u0001", "\u0000\u0001\u0004\u0000\u00010zio.kafka.producer.TransactionalProducerSettings\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0003\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.transactionalProducer(KafkaTestUtils.scala:48)");
        ZLayer layer$macro$6 = TransactionalProducer$.MODULE$.live();
        transactionalProducer = ZLayer.ZLayerProvideSomeOps$.MODULE$.$greater$greater$greater$extension(ZLayer$.MODULE$.ZLayerProvideSomeOps(ZLayer.ZLayerProvideSomeOps$.MODULE$.$greater$greater$greater$extension(ZLayer$.MODULE$.ZLayerProvideSomeOps(layer$macro$4), (Function0 & Serializable)() -> layer$macro$5, (Object)"zio.kafka.testkit.KafkaTestUtils.transactionalProducer(KafkaTestUtils.scala:47)")), (Function0 & Serializable)() -> layer$macro$6, (Object)"zio.kafka.testkit.KafkaTestUtils.transactionalProducer(KafkaTestUtils.scala:47)");
        adminSettings = ZIO.ServiceWithPartiallyApplied$.MODULE$.apply$extension(ZIO$.MODULE$.serviceWith(), (Function1 & Serializable)x$7 -> x$7.bootstrapServers(), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(Kafka.class, LightTypeTag$.MODULE$.parse(1661891183, "\u0004\u0000\u0001\u0017zio.kafka.testkit.Kafka\u0001\u0001", "\u0000\u0000\u0000", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.adminSettings(KafkaTestUtils.scala:251)").map((Function1 & Serializable)x$8 -> AdminClientSettings$.MODULE$.apply(x$8), (Object)"zio.kafka.testkit.KafkaTestUtils.adminSettings(KafkaTestUtils.scala:251)");
        sslAdminSettings = ZIO.ServiceWithPartiallyApplied$.MODULE$.apply$extension(ZIO$.MODULE$.serviceWith(), (Function1 & Serializable)x$11 -> x$11.bootstrapServers(), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(Kafka.class, LightTypeTag$.MODULE$.parse(1661891183, "\u0004\u0000\u0001\u0017zio.kafka.testkit.Kafka\u0001\u0001", "\u0000\u0000\u0000", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.sslAdminSettings(KafkaTestUtils.scala:272)").map((Function1 & Serializable)bootstrap -> AdminClientSettings$.MODULE$.apply(bootstrap).withProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"security.protocol"), (Object)"SSL"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.truststore.location"), (Object)MODULE$.trustStoreFile().getAbsolutePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.truststore.password"), (Object)"123456"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)MODULE$.keyStoreFile().getAbsolutePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"123456"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.key.password"), (Object)"123456"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.truststore.type"), (Object)"JKS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.type"), (Object)"JKS")})), (Object)"zio.kafka.testkit.KafkaTestUtils.sslAdminSettings(KafkaTestUtils.scala:273)");
    }

    public ZIO<Kafka, Nothing$, ProducerSettings> producerSettings() {
        return producerSettings;
    }

    public ZLayer<Kafka, Throwable, Producer> producer() {
        return producer;
    }

    public ZIO<Kafka, Nothing$, TransactionalProducerSettings> transactionalProducerSettings() {
        return transactionalProducerSettings;
    }

    public ZLayer<Kafka, Throwable, TransactionalProducer> transactionalProducer() {
        return transactionalProducer;
    }

    public ZIO<Producer, Throwable, RecordMetadata> produceOne(String topic, String key, String message) {
        return Producer$.MODULE$.produce(new ProducerRecord(topic, (Object)key, (Object)message), (Serializer)Serde$.MODULE$.string(), (Serializer)Serde$.MODULE$.string());
    }

    public ZIO<Producer, Throwable, Chunk<RecordMetadata>> produceMany(String topic, int partition, Iterable<Tuple2<String, String>> kvs) {
        return Producer$.MODULE$.produceChunk(Chunk$.MODULE$.fromIterable((Iterable)kvs.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), null, (Object)k, (Object)v);
            }
            throw new MatchError((Object)tuple2);
        })), (Serializer)Serde$.MODULE$.string(), (Serializer)Serde$.MODULE$.string());
    }

    public ZIO<Producer, Throwable, Chunk<RecordMetadata>> produceMany(String topic, Iterable<Tuple2<String, String>> kvs) {
        return Producer$.MODULE$.produceChunk(Chunk$.MODULE$.fromIterable((Iterable)kvs.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new ProducerRecord(topic, (Object)k, (Object)v);
            }
            throw new MatchError((Object)tuple2);
        })), (Serializer)Serde$.MODULE$.string(), (Serializer)Serde$.MODULE$.string());
    }

    public ZIO<Kafka, Nothing$, ConsumerSettings> consumerSettings(String clientId, Option<String> groupId, Option<String> clientInstanceId, boolean allowAutoCreateTopics, Consumer.OffsetRetrieval offsetRetrieval, boolean restartStreamOnRebalancing, int max$u002Epoll$u002Erecords, Duration runloopTimeout, Map<String, String> properties) {
        return ZIO.ServiceWithPartiallyApplied$.MODULE$.apply$extension(ZIO$.MODULE$.serviceWith(), (Function1 & Serializable)kafka -> {
            ConsumerSettings settings = ConsumerSettings$.MODULE$.apply(kafka.bootstrapServers()).withClientId(clientId).withCloseTimeout(DurationSyntax$.MODULE$.seconds$extension(package$.MODULE$.durationInt(5))).withPollTimeout(DurationSyntax$.MODULE$.millis$extension(package$.MODULE$.durationInt(100))).withRunloopTimeout(runloopTimeout).withProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"auto.offset.reset"), (Object)"earliest"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"session.timeout.ms"), (Object)"3000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max.poll.interval.ms"), (Object)"10000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"heartbeat.interval.ms"), (Object)"1000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max.poll.records"), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)max$u002Epoll$u002Erecords))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"allow.auto.create.topics"), (Object)Boolean.toString(allowAutoCreateTopics))})).withOffsetRetrieval(offsetRetrieval).withRestartStreamOnRebalancing(restartStreamOnRebalancing).withProperties(properties);
            ConsumerSettings withClientInstanceId = (ConsumerSettings)clientInstanceId.fold((Function0 & Serializable)() -> settings, (Function1 & Serializable)groupInstanceId -> settings.withGroupInstanceId(groupInstanceId));
            return (ConsumerSettings)groupId.fold((Function0 & Serializable)() -> withClientInstanceId, (Function1 & Serializable)groupId -> withClientInstanceId.withGroupId(groupId));
        }, package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(Kafka.class, LightTypeTag$.MODULE$.parse(1661891183, "\u0004\u0000\u0001\u0017zio.kafka.testkit.Kafka\u0001\u0001", "\u0000\u0000\u0000", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.consumerSettings(KafkaTestUtils.scala:109)");
    }

    public ZIO<Kafka, Nothing$, ConsumerSettings> transactionalConsumerSettings(String groupId, String clientId, Option<String> clientInstanceId, boolean allowAutoCreateTopics, Consumer.OffsetRetrieval offsetRetrieval, boolean restartStreamOnRebalancing, Map<String, String> properties) {
        String x$1 = clientId;
        Some x$2 = new Some((Object)groupId);
        Option<String> x$3 = clientInstanceId;
        boolean x$4 = allowAutoCreateTopics;
        Consumer.OffsetRetrieval x$52 = offsetRetrieval;
        boolean x$6 = restartStreamOnRebalancing;
        Map<String, String> x$7 = properties;
        int x$8 = this.consumerSettings$default$7();
        Duration x$9 = this.consumerSettings$default$8();
        return this.consumerSettings(x$1, (Option<String>)x$2, x$3, x$4, x$52, x$6, x$8, x$9, x$7).map((Function1 & Serializable)x$5 -> x$5.withProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isolation.level"), (Object)"read_committed")})), (Object)"zio.kafka.testkit.KafkaTestUtils.transactionalConsumerSettings(KafkaTestUtils.scala:153)");
    }

    public ZLayer<ConsumerSettings, Throwable, Consumer> simpleConsumer(Diagnostics diagnostics) {
        ZLayer layer$macro$1 = ZLayer$.MODULE$.environment((Object)"zio.kafka.testkit.KafkaTestUtils.simpleConsumer.layer$macro$1(KafkaTestUtils.scala:164)");
        ZLayer layer$macro$2 = ZLayer.ZLayerProvideSomeOps$.MODULE$.$greater$greater$greater$extension(ZLayer$.MODULE$.ZLayerProvideSomeOps(ZLayer$.MODULE$.succeed((Function0 & Serializable)() -> diagnostics, package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(Diagnostics.class, LightTypeTag$.MODULE$.parse(-1422547270, "\u0004\u0000\u0001*zio.kafka.consumer.diagnostics.Diagnostics\u0001\u0001", "\u0000\u0000\u0000", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.simpleConsumer(KafkaTestUtils.scala:165)")), (Function0 & Serializable)() -> Consumer$.MODULE$.live(), Tag$.MODULE$.apply(Diagnostics.class, LightTypeTag$.MODULE$.parse(-1422547270, "\u0004\u0000\u0001*zio.kafka.consumer.diagnostics.Diagnostics\u0001\u0001", "\u0000\u0000\u0000", 30)), (Object)"zio.kafka.testkit.KafkaTestUtils.simpleConsumer(KafkaTestUtils.scala:165)");
        return ZLayer.ZLayerProvideSomeOps$.MODULE$.$greater$greater$greater$extension(ZLayer$.MODULE$.ZLayerProvideSomeOps(layer$macro$1), (Function0 & Serializable)() -> layer$macro$2, (Object)"zio.kafka.testkit.KafkaTestUtils.simpleConsumer(KafkaTestUtils.scala:164)");
    }

    public Diagnostics simpleConsumer$default$1() {
        return Diagnostics.NoOp$.MODULE$;
    }

    public ZLayer<ConsumerSettings, Throwable, Consumer> minimalConsumer(Diagnostics diagnostics) {
        ZLayer layer$macro$1 = ZLayer$.MODULE$.environment((Object)"zio.kafka.testkit.KafkaTestUtils.minimalConsumer.layer$macro$1(KafkaTestUtils.scala:175)");
        ZLayer layer$macro$2 = ZLayer.ZLayerProvideSomeOps$.MODULE$.$greater$greater$greater$extension(ZLayer$.MODULE$.ZLayerProvideSomeOps(ZLayer$.MODULE$.succeed((Function0 & Serializable)() -> diagnostics, package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(Diagnostics.class, LightTypeTag$.MODULE$.parse(-1422547270, "\u0004\u0000\u0001*zio.kafka.consumer.diagnostics.Diagnostics\u0001\u0001", "\u0000\u0000\u0000", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.minimalConsumer(KafkaTestUtils.scala:176)")), (Function0 & Serializable)() -> Consumer$.MODULE$.live(), Tag$.MODULE$.apply(Diagnostics.class, LightTypeTag$.MODULE$.parse(-1422547270, "\u0004\u0000\u0001*zio.kafka.consumer.diagnostics.Diagnostics\u0001\u0001", "\u0000\u0000\u0000", 30)), (Object)"zio.kafka.testkit.KafkaTestUtils.minimalConsumer(KafkaTestUtils.scala:176)");
        return ZLayer.ZLayerProvideSomeOps$.MODULE$.$greater$greater$greater$extension(ZLayer$.MODULE$.ZLayerProvideSomeOps(layer$macro$1), (Function0 & Serializable)() -> layer$macro$2, (Object)"zio.kafka.testkit.KafkaTestUtils.minimalConsumer(KafkaTestUtils.scala:175)");
    }

    public Diagnostics minimalConsumer$default$1() {
        return Diagnostics.NoOp$.MODULE$;
    }

    public ZLayer<Kafka, Throwable, Consumer> consumer(String clientId, Option<String> groupId, Option<String> clientInstanceId, Consumer.OffsetRetrieval offsetRetrieval, boolean allowAutoCreateTopics, Diagnostics diagnostics, boolean restartStreamOnRebalancing, Map<String, String> properties) {
        return ZLayer.ZLayerProvideSomeOps$.MODULE$.$greater$greater$greater$extension(ZLayer$.MODULE$.ZLayerProvideSomeOps(ZLayer$.MODULE$.apply((Function0 & Serializable)() -> {
            String x$1 = clientId;
            Option x$2 = groupId;
            Option x$3 = clientInstanceId;
            boolean x$4 = allowAutoCreateTopics;
            Consumer.OffsetRetrieval x$5 = offsetRetrieval;
            boolean x$6 = restartStreamOnRebalancing;
            Map x$7 = properties;
            int x$8 = MODULE$.consumerSettings$default$7();
            Duration x$9 = MODULE$.consumerSettings$default$8();
            return MODULE$.consumerSettings(x$1, (Option<String>)x$2, (Option<String>)x$3, x$4, x$5, x$6, x$8, x$9, (Map<String, String>)x$7);
        }, package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(ConsumerSettings.class, LightTypeTag$.MODULE$.parse(1918370364, "\u0004\u0000\u0001#zio.kafka.consumer.ConsumerSettings\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001#zio.kafka.consumer.ConsumerSettings\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0003\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.consumer(KafkaTestUtils.scala:192)").$plus$plus((Function0 & Serializable)() -> ZLayer$.MODULE$.succeed((Function0 & Serializable)() -> diagnostics, package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(Diagnostics.class, LightTypeTag$.MODULE$.parse(-1422547270, "\u0004\u0000\u0001*zio.kafka.consumer.diagnostics.Diagnostics\u0001\u0001", "\u0000\u0000\u0000", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.consumer(KafkaTestUtils.scala:202)"), Tag$.MODULE$.apply(Diagnostics.class, LightTypeTag$.MODULE$.parse(-1422547270, "\u0004\u0000\u0001*zio.kafka.consumer.diagnostics.Diagnostics\u0001\u0001", "\u0000\u0000\u0000", 30)))), (Function0 & Serializable)() -> Consumer$.MODULE$.live(), (Object)"zio.kafka.testkit.KafkaTestUtils.consumer(KafkaTestUtils.scala:202)");
    }

    public Option<String> consumerSettings$default$2() {
        return None$.MODULE$;
    }

    public Option<String> consumerSettings$default$3() {
        return None$.MODULE$;
    }

    public boolean consumerSettings$default$4() {
        return true;
    }

    public Consumer.OffsetRetrieval consumerSettings$default$5() {
        return new Consumer.OffsetRetrieval$.Auto(Consumer.OffsetRetrieval$.Auto$.MODULE$.apply$default$1());
    }

    public boolean consumerSettings$default$6() {
        return false;
    }

    public int consumerSettings$default$7() {
        return 100;
    }

    public Duration consumerSettings$default$8() {
        return ConsumerSettings$.MODULE$.defaultRunloopTimeout();
    }

    public Map<String, String> consumerSettings$default$9() {
        return Predef$.MODULE$.Map().empty();
    }

    public Option<String> consumer$default$2() {
        return None$.MODULE$;
    }

    public Option<String> consumer$default$3() {
        return None$.MODULE$;
    }

    public Consumer.OffsetRetrieval consumer$default$4() {
        return new Consumer.OffsetRetrieval$.Auto((Consumer.AutoOffsetStrategy)Consumer.AutoOffsetStrategy$.Earliest$.MODULE$);
    }

    public boolean consumer$default$5() {
        return true;
    }

    public Diagnostics consumer$default$6() {
        return Diagnostics.NoOp$.MODULE$;
    }

    public boolean consumer$default$7() {
        return false;
    }

    public Map<String, String> consumer$default$8() {
        return Predef$.MODULE$.Map().empty();
    }

    public ZLayer<Kafka, Throwable, Consumer> transactionalConsumer(String clientId, String groupId, Option<String> clientInstanceId, Consumer.OffsetRetrieval offsetRetrieval, boolean allowAutoCreateTopics, Diagnostics diagnostics, boolean restartStreamOnRebalancing, Map<String, String> properties, RebalanceListener rebalanceListener) {
        return ZLayer.ZLayerProvideSomeOps$.MODULE$.$greater$greater$greater$extension(ZLayer$.MODULE$.ZLayerProvideSomeOps(ZLayer$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.transactionalConsumerSettings(groupId, clientId, clientInstanceId, allowAutoCreateTopics, offsetRetrieval, restartStreamOnRebalancing, properties).map((Function1 & Serializable)x$6 -> x$6.withRebalanceListener(rebalanceListener), (Object)"zio.kafka.testkit.KafkaTestUtils.transactionalConsumer(KafkaTestUtils.scala:227)"), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(ConsumerSettings.class, LightTypeTag$.MODULE$.parse(1918370364, "\u0004\u0000\u0001#zio.kafka.consumer.ConsumerSettings\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001#zio.kafka.consumer.ConsumerSettings\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0003\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.transactionalConsumer(KafkaTestUtils.scala:218)").$plus$plus((Function0 & Serializable)() -> ZLayer$.MODULE$.succeed((Function0 & Serializable)() -> diagnostics, package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(Diagnostics.class, LightTypeTag$.MODULE$.parse(-1422547270, "\u0004\u0000\u0001*zio.kafka.consumer.diagnostics.Diagnostics\u0001\u0001", "\u0000\u0000\u0000", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.transactionalConsumer(KafkaTestUtils.scala:228)"), Tag$.MODULE$.apply(Diagnostics.class, LightTypeTag$.MODULE$.parse(-1422547270, "\u0004\u0000\u0001*zio.kafka.consumer.diagnostics.Diagnostics\u0001\u0001", "\u0000\u0000\u0000", 30)))), (Function0 & Serializable)() -> Consumer$.MODULE$.live(), (Object)"zio.kafka.testkit.KafkaTestUtils.transactionalConsumer(KafkaTestUtils.scala:228)");
    }

    public Option<String> transactionalConsumerSettings$default$3() {
        return None$.MODULE$;
    }

    public boolean transactionalConsumerSettings$default$4() {
        return true;
    }

    public Consumer.OffsetRetrieval transactionalConsumerSettings$default$5() {
        return new Consumer.OffsetRetrieval$.Auto(Consumer.OffsetRetrieval$.Auto$.MODULE$.apply$default$1());
    }

    public boolean transactionalConsumerSettings$default$6() {
        return false;
    }

    public Map<String, String> transactionalConsumerSettings$default$7() {
        return Predef$.MODULE$.Map().empty();
    }

    public Option<String> transactionalConsumer$default$3() {
        return None$.MODULE$;
    }

    public Consumer.OffsetRetrieval transactionalConsumer$default$4() {
        return new Consumer.OffsetRetrieval$.Auto(Consumer.OffsetRetrieval$.Auto$.MODULE$.apply$default$1());
    }

    public boolean transactionalConsumer$default$5() {
        return true;
    }

    public Diagnostics transactionalConsumer$default$6() {
        return Diagnostics.NoOp$.MODULE$;
    }

    public boolean transactionalConsumer$default$7() {
        return false;
    }

    public Map<String, String> transactionalConsumer$default$8() {
        return Predef$.MODULE$.Map().empty();
    }

    public RebalanceListener transactionalConsumer$default$9() {
        return RebalanceListener$.MODULE$.noop();
    }

    public ZIO<Kafka, Throwable, BoxedUnit> consumeWithStrings(String clientId, Option<String> groupId, Subscription subscription, Function1<ConsumerRecord<String, String>, ZIO<Object, Nothing$, BoxedUnit>> r) {
        return this.consumerSettings(clientId, groupId, (Option<String>)None$.MODULE$, this.consumerSettings$default$4(), this.consumerSettings$default$5(), this.consumerSettings$default$6(), this.consumerSettings$default$7(), this.consumerSettings$default$8(), this.consumerSettings$default$9()).flatMap((Function1 & Serializable)settings -> Consumer$.MODULE$.consumeWith(settings, subscription, (Deserializer)Deserializer$.MODULE$.string(), (Deserializer)Deserializer$.MODULE$.string(), Consumer$.MODULE$.consumeWith$default$5(), r, package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(Object.class, LightTypeTag$.MODULE$.parse(-85095185, "\u0004\u0000\u0001\tscala.Any\u0001\u0001", "\u0000\u0000\u0000", 30))), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(Object.class, LightTypeTag$.MODULE$.parse(-85095185, "\u0004\u0000\u0001\tscala.Any\u0001\u0001", "\u0000\u0000\u0000", 30)))), (Object)"zio.kafka.testkit.KafkaTestUtils.consumeWithStrings(KafkaTestUtils.scala:238)");
    }

    public Option<String> consumeWithStrings$default$2() {
        return None$.MODULE$;
    }

    public ZIO<Kafka, Nothing$, AdminClientSettings> adminSettings() {
        return adminSettings;
    }

    public ZIO<Kafka.Sasl, Nothing$, AdminClientSettings> saslAdminSettings(String username, String password) {
        return ZIO.ServiceWithPartiallyApplied$.MODULE$.apply$extension(ZIO$.MODULE$.serviceWith(), (Function1 & Serializable)x$9 -> ((Kafka.Sasl)x$9).value().bootstrapServers(), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(Kafka.class, LightTypeTag$.MODULE$.parse(606355400, "\u0004\u0000\u0001\u001czio.kafka.testkit.Kafka.Sasl\u0001\u0002\u0003\u0000\u0000\u0017zio.kafka.testkit.Kafka\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\u001czio.kafka.testkit.Kafka.Sasl\u0001\u0002\u0003\u0000\u0000\u0017zio.kafka.testkit.Kafka\u0001\u0001\u0004\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0004\u0000\u0001\fscala.AnyVal\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.saslAdminSettings(KafkaTestUtils.scala:258)").map((Function1 & Serializable)x$10 -> AdminClientSettings$.MODULE$.apply(x$10).withProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.mechanism"), (Object)"PLAIN"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"security.protocol"), (Object)"SASL_PLAINTEXT"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)new StringBuilder(89).append("org.apache.kafka.common.security.plain.PlainLoginModule required username=\"").append(username).append("\" password=\"").append(password).append("\";").toString())})), (Object)"zio.kafka.testkit.KafkaTestUtils.saslAdminSettings(KafkaTestUtils.scala:259)");
    }

    public ZIO<Kafka, Nothing$, AdminClientSettings> sslAdminSettings() {
        return sslAdminSettings;
    }

    public <T> ZIO<Kafka, Throwable, T> withAdmin(Function1<AdminClient, ZIO<Kafka, Throwable, T>> f) {
        return this.adminSettings().flatMap((Function1 & Serializable)settings -> MODULE$.withAdminClient((AdminClientSettings)settings, (Function1)f), (Object)"zio.kafka.testkit.KafkaTestUtils.withAdmin(KafkaTestUtils.scala:292)");
    }

    public <T> ZIO<Kafka.Sasl, Throwable, T> withSaslAdmin(String username, String password, Function1<AdminClient, ZIO<Kafka.Sasl, Throwable, T>> f) {
        return this.saslAdminSettings(username, password).flatMap((Function1 & Serializable)settings -> MODULE$.withAdminClient((AdminClientSettings)settings, (Function1)f), (Object)"zio.kafka.testkit.KafkaTestUtils.withSaslAdmin(KafkaTestUtils.scala:305)");
    }

    public <T> String withSaslAdmin$default$1() {
        return "admin";
    }

    public <T> String withSaslAdmin$default$2() {
        return "admin-secret";
    }

    public <T> ZIO<Kafka, Throwable, T> withSslAdmin(Function1<AdminClient, ZIO<Kafka, Throwable, T>> f) {
        return this.sslAdminSettings().flatMap((Function1 & Serializable)settings -> MODULE$.withAdminClient((AdminClientSettings)settings, (Function1)f), (Object)"zio.kafka.testkit.KafkaTestUtils.withSslAdmin(KafkaTestUtils.scala:314)");
    }

    private <R, T> ZIO<R, Throwable, T> withAdminClient(AdminClientSettings settings, Function1<AdminClient, ZIO<R, Throwable, T>> f) {
        return ZIO.ScopedPartiallyApplied$.MODULE$.apply$extension(ZIO$.MODULE$.scoped(), (Function0 & Serializable)() -> AdminClient$.MODULE$.make(settings).flatMap(f, (Object)"zio.kafka.testkit.KafkaTestUtils.withAdminClient(KafkaTestUtils.scala:320)"), (Object)"zio.kafka.testkit.KafkaTestUtils.withAdminClient(KafkaTestUtils.scala:319)");
    }

    private File readResourceFile(String file, String tmpFileName, String tmpFileSuffix) {
        File file2;
        try {
            Path tmpFile = Files.createTempFile(tmpFileName, tmpFileSuffix, new FileAttribute[0]);
            Files.copy(this.getClass().getClassLoader().getResourceAsStream(file), tmpFile, StandardCopyOption.REPLACE_EXISTING);
            File result = tmpFile.toFile();
            result.deleteOnExit();
            file2 = result;
        }
        catch (Throwable e) {
            Exit exit = (Exit)Unsafe$.MODULE$.unsafe((Function1 & Serializable)u -> Runtime$.MODULE$.default().unsafe().run(ZIO$.MODULE$.logErrorCause((Function0 & Serializable)() -> "Failed to read resource file", (Function0 & Serializable)() -> Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), (Object)"zio.kafka.testkit.KafkaTestUtils.readResourceFile.x$12(KafkaTestUtils.scala:333)"), (Object)"zio.kafka.testkit.KafkaTestUtils.readResourceFile.x$12(KafkaTestUtils.scala:333)", u));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            throw e;
        }
        return file2;
    }

    private File trustStoreFile$lzycompute() {
        KafkaTestUtils$ kafkaTestUtils$ = this;
        synchronized (kafkaTestUtils$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                trustStoreFile = this.readResourceFile("truststore/kafka.truststore.jks", "truststore", ".jks");
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return trustStoreFile;
    }

    public File trustStoreFile() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.trustStoreFile$lzycompute();
        }
        return trustStoreFile;
    }

    private File keyStoreFile$lzycompute() {
        KafkaTestUtils$ kafkaTestUtils$ = this;
        synchronized (kafkaTestUtils$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                keyStoreFile = this.readResourceFile("keystore/kafka.keystore.jks", "keystore", ".jks");
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return keyStoreFile;
    }

    public File keyStoreFile() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.keyStoreFile$lzycompute();
        }
        return keyStoreFile;
    }

    private KafkaTestUtils$() {
    }
}

