/*
 * Decompiled with CFR 0.152.
 */
package zio.json.javatime;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.concurrent.ConcurrentHashMap;
import scala.MatchError;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.util.control.NoStackTrace;

public final class parsers$
implements Serializable {
    private static final ZoneOffset[] zoneOffsets;
    private static final ConcurrentHashMap<String, ZoneId> zoneIds;
    public static final parsers$ MODULE$;

    private parsers$() {
    }

    static {
        MODULE$ = new parsers$();
        zoneOffsets = new ZoneOffset[145];
        zoneIds = new ConcurrentHashMap(256);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(parsers$.class);
    }

    public Duration unsafeParseDuration(String input) {
        boolean isNeg;
        int len = input.length();
        int pos = 0;
        long seconds = 0L;
        int nanos = 0;
        int state = 0;
        if (pos >= len) {
            throw this.durationError(pos);
        }
        char ch = input.charAt(pos);
        ++pos;
        boolean bl = isNeg = ch == '-';
        if (isNeg) {
            if (pos >= len) {
                throw this.durationError(pos);
            }
            ch = input.charAt(pos);
            ++pos;
        }
        if (ch != 'P') {
            throw this.durationOrPeriodStartError(isNeg, pos - 1);
        }
        if (pos >= len) {
            throw this.durationError(pos);
        }
        ch = input.charAt(pos);
        ++pos;
        do {
            boolean isNegX;
            if (state == 0) {
                if (ch == 'T') {
                    if (pos >= len) {
                        throw this.durationError(pos);
                    }
                    ch = input.charAt(pos);
                    ++pos;
                    state = 1;
                }
            } else if (state == 1) {
                if (ch != 'T') {
                    throw this.charsError('T', '\"', pos - 1);
                }
                if (pos >= len) {
                    throw this.durationError(pos);
                }
                ch = input.charAt(pos);
                ++pos;
            } else if (state == 4 && pos >= len) {
                throw this.durationError(pos - 1);
            }
            boolean bl2 = isNegX = ch == '-';
            if (isNegX) {
                if (pos >= len) {
                    throw this.durationError(pos);
                }
                ch = input.charAt(pos);
                ++pos;
            }
            if (ch < '0' || ch > '9') {
                throw this.durationOrPeriodDigitError(isNegX, state <= 1, pos - 1);
            }
            long x = 48 - ch;
            while (pos < len && (ch = input.charAt(pos)) >= '0' && ch <= '9') {
                if (x < -922337203685477580L || (x = x * 10L + (long)(48 - ch)) > 0L) {
                    throw this.durationError(pos);
                }
                ++pos;
            }
            if (!(isNeg ^ isNegX)) {
                if (x == Long.MIN_VALUE) {
                    throw this.durationError(pos);
                }
                x = -x;
            }
            if (ch == 'D' && state <= 0) {
                if (x < -106751991167300L || x > 106751991167300L) {
                    throw this.durationError(pos);
                }
                seconds = x * 86400L;
                state = 1;
            } else if (ch == 'H' && state <= 1) {
                if (x < -2562047788015215L || x > 2562047788015215L) {
                    throw this.durationError(pos);
                }
                seconds = this.sumSeconds(x * 3600L, seconds, pos);
                state = 2;
            } else if (ch == 'M' && state <= 2) {
                if (x < -153722867280912930L || x > 0x222222222222222L) {
                    throw this.durationError(pos);
                }
                seconds = this.sumSeconds(x * 60L, seconds, pos);
                state = 3;
            } else if (ch == '.') {
                seconds = this.sumSeconds(x, seconds, ++pos);
                int nanoDigitWeight = 100000000;
                while (pos < len && (ch = input.charAt(pos)) >= '0' && ch <= '9' && nanoDigitWeight != 0) {
                    nanos += (ch - 48) * nanoDigitWeight;
                    nanoDigitWeight = (int)((long)nanoDigitWeight * 0xCCCCCCCDL >> 35);
                    ++pos;
                }
                if (ch != 'S') {
                    throw this.nanoError(nanoDigitWeight, 'S', pos);
                }
                if (isNeg ^ isNegX) {
                    nanos = -nanos;
                }
                state = 4;
            } else if (ch == 'S') {
                seconds = this.sumSeconds(x, seconds, pos);
                state = 4;
            } else {
                throw this.durationError(state, pos);
            }
            if (++pos >= len) break;
            ch = input.charAt(pos);
            ++pos;
        } while (true);
        return Duration.ofSeconds(seconds, nanos);
    }

    public Instant unsafeParseInstant(String input) {
        int year;
        int n;
        int pos = 0;
        int len = input.length();
        if (pos + 4 >= len) {
            throw this.instantError(pos);
        }
        char ch0 = input.charAt(pos);
        char ch1 = input.charAt(pos + 1);
        char ch2 = input.charAt(pos + 2);
        char ch3 = input.charAt(pos + 3);
        char ch4 = input.charAt(pos + 4);
        if (ch0 >= '0' && ch0 <= '9') {
            if (ch1 < '0' || ch1 > '9') {
                throw this.digitError(pos + 1);
            }
            if (ch2 < '0' || ch2 > '9') {
                throw this.digitError(pos + 2);
            }
            if (ch3 < '0' || ch3 > '9') {
                throw this.digitError(pos + 3);
            }
            if (ch4 != '-') {
                throw this.charError('-', pos + 4);
            }
            pos += 5;
            n = ch0 * 1000 + ch1 * 100 + ch2 * 10 + ch3 - 53328;
        } else {
            boolean yearNeg;
            boolean bl;
            if (ch0 == '-') {
                bl = true;
            } else {
                if (ch0 != '+') {
                    throw this.charsOrDigitError('-', '+', pos);
                }
                bl = yearNeg = false;
            }
            if (ch1 < '0' || ch1 > '9') {
                throw this.digitError(pos + 1);
            }
            if (ch2 < '0' || ch2 > '9') {
                throw this.digitError(pos + 2);
            }
            if (ch3 < '0' || ch3 > '9') {
                throw this.digitError(pos + 3);
            }
            if (ch4 < '0' || ch4 > '9') {
                throw this.digitError(pos + 4);
            }
            pos += 5;
            int year2 = ch1 * 1000 + ch2 * 100 + ch3 * 10 + ch4 - 53328;
            int yearDigits = 4;
            int ch = 48;
            while (true) {
                if (pos >= len) {
                    throw this.instantError(pos);
                }
                ch = input.charAt(pos);
                ++pos;
                if (ch < 48 || ch > 57 || yearDigits >= 10) break;
                year2 = year2 > 100000000 ? Integer.MAX_VALUE : year2 * 10 + (ch - 48);
                ++yearDigits;
            }
            if (yearDigits == 10 && year2 > 1000000000) {
                throw this.yearError(pos - 2);
            }
            if (yearNeg) {
                if (year2 == 0) {
                    throw this.yearError(pos - 2);
                }
                year2 = -year2;
            }
            if (ch != 45) {
                throw this.yearError(yearNeg, yearDigits, pos - 1);
            }
            n = year = year2;
        }
        if (pos + 2 >= len) {
            throw this.instantError(pos);
        }
        char ch02 = input.charAt(pos);
        char ch12 = input.charAt(pos + 1);
        char ch22 = input.charAt(pos + 2);
        int month = ch02 * 10 + ch12 - 528;
        if (ch02 < '0' || ch02 > '9') {
            throw this.digitError(pos);
        }
        if (ch12 < '0' || ch12 > '9') {
            throw this.digitError(pos + 1);
        }
        if (month < 1 || month > 12) {
            throw this.monthError(pos + 1);
        }
        if (ch22 != '-') {
            throw this.charError('-', pos + 2);
        }
        int month2 = month;
        if ((pos += 3) + 2 >= len) {
            throw this.instantError(pos);
        }
        char ch03 = input.charAt(pos);
        char ch13 = input.charAt(pos + 1);
        char ch23 = input.charAt(pos + 2);
        int day = ch03 * 10 + ch13 - 528;
        if (ch03 < '0' || ch03 > '9') {
            throw this.digitError(pos);
        }
        if (ch13 < '0' || ch13 > '9') {
            throw this.digitError(pos + 1);
        }
        if (day == 0 || day > 28 && day > this.maxDayForYearMonth(year, month2)) {
            throw this.dayError(pos + 1);
        }
        if (ch23 != 'T') {
            throw this.charError('T', pos + 2);
        }
        int day2 = day;
        long epochDay = this.epochDayForYear(year) + (long)(this.dayOfYearForYearMonth(year, month2) + day2 - 719529);
        if ((pos += 3) + 2 >= len) {
            throw this.instantError(pos);
        }
        char ch04 = input.charAt(pos);
        char ch14 = input.charAt(pos + 1);
        char ch24 = input.charAt(pos + 2);
        int hour = ch04 * 10 + ch14 - 528;
        if (ch04 < '0' || ch04 > '9') {
            throw this.digitError(pos);
        }
        if (ch14 < '0' || ch14 > '9') {
            throw this.digitError(pos + 1);
        }
        if (hour > 23) {
            throw this.hourError(pos + 1);
        }
        if (ch24 != ':') {
            throw this.charError(':', pos + 2);
        }
        int epochSecond = hour * 3600;
        if ((pos += 3) + 1 >= len) {
            throw this.instantError(pos);
        }
        char ch05 = input.charAt(pos);
        char ch15 = input.charAt(pos + 1);
        if (ch05 < '0' || ch05 > '9') {
            throw this.digitError(pos);
        }
        if (ch15 < '0' || ch15 > '9') {
            throw this.digitError(pos + 1);
        }
        if (ch05 > '5') {
            throw this.minuteError(pos + 1);
        }
        epochSecond += (ch05 * 10 + ch15 - 528) * 60;
        int nanoDigitWeight = -1;
        int nano = 0;
        char ch = '\u0000';
        if ((pos += 2) < len) {
            ch = input.charAt(pos);
            ++pos;
            if (ch == ':') {
                nanoDigitWeight = -2;
                if (pos + 1 >= len) {
                    throw this.instantError(pos);
                }
                char ch06 = input.charAt(pos);
                char ch16 = input.charAt(pos + 1);
                if (ch06 < '0' || ch06 > '9') {
                    throw this.digitError(pos);
                }
                if (ch16 < '0' || ch16 > '9') {
                    throw this.digitError(pos + 1);
                }
                if (ch06 > '5') {
                    throw this.secondError(pos + 1);
                }
                epochSecond += ch06 * 10 + ch16 - 528;
                if ((pos += 2) < len) {
                    ch = input.charAt(pos);
                    ++pos;
                    if (ch == '.') {
                        nanoDigitWeight = 100000000;
                        while (pos < len) {
                            ch = input.charAt(pos);
                            ++pos;
                            if (ch < '0' || ch > '9' || nanoDigitWeight == 0) break;
                            nano += (ch - 48) * nanoDigitWeight;
                            nanoDigitWeight = (int)((long)nanoDigitWeight * 0xCCCCCCCDL >> 35);
                        }
                    }
                }
            }
        }
        int offsetTotal = 0;
        if (ch != 'Z') {
            boolean offsetNeg;
            boolean bl;
            if (ch == '-') {
                bl = true;
            } else {
                if (ch != '+') {
                    throw this.timezoneSignError(nanoDigitWeight, pos - 1);
                }
                bl = offsetNeg = false;
            }
            if (pos + 1 >= len) {
                throw this.instantError(pos);
            }
            char ch07 = input.charAt(pos);
            char ch17 = input.charAt(pos + 1);
            int offsetHour = ch07 * 10 + ch17 - 528;
            if (ch07 < '0' || ch07 > '9') {
                throw this.digitError(pos);
            }
            if (ch17 < '0' || ch17 > '9') {
                throw this.digitError(pos + 1);
            }
            if (offsetHour > 18) {
                throw this.timezoneOffsetHourError(pos + 1);
            }
            offsetTotal = offsetHour * 3600;
            if ((pos += 2) < len) {
                ch = input.charAt(pos);
                ++pos;
                if (ch == ':') {
                    if (pos + 1 >= len) {
                        throw this.instantError(pos);
                    }
                    char ch08 = input.charAt(pos);
                    char ch18 = input.charAt(pos + 1);
                    if (ch08 < '0' || ch08 > '9') {
                        throw this.digitError(pos);
                    }
                    if (ch18 < '0' || ch18 > '9') {
                        throw this.digitError(pos + 1);
                    }
                    if (ch08 > '5') {
                        throw this.timezoneOffsetMinuteError(pos + 1);
                    }
                    offsetTotal += (ch08 * 10 + ch18 - 528) * 60;
                    if ((pos += 2) < len) {
                        ch = input.charAt(pos);
                        ++pos;
                        if (ch == ':') {
                            if (pos + 1 >= len) {
                                throw this.instantError(pos);
                            }
                            char ch09 = input.charAt(pos);
                            char ch19 = input.charAt(pos + 1);
                            if (ch09 < '0' || ch09 > '9') {
                                throw this.digitError(pos);
                            }
                            if (ch19 < '0' || ch19 > '9') {
                                throw this.digitError(pos + 1);
                            }
                            if (ch09 > '5') {
                                throw this.timezoneOffsetSecondError(pos + 1);
                            }
                            pos += 2;
                            offsetTotal += ch09 * 10 + ch19 - 528;
                        }
                    }
                }
            }
            if (offsetTotal > 64800) {
                throw this.zoneOffsetError(pos);
            }
            if (offsetNeg) {
                offsetTotal = -offsetTotal;
            }
        }
        if (pos != len) {
            throw this.instantError(pos);
        }
        return Instant.ofEpochSecond(epochDay * 86400L + (long)(epochSecond - offsetTotal), nano);
    }

    public LocalDate unsafeParseLocalDate(String input) {
        int year;
        int n;
        int pos = 0;
        int len = input.length();
        if (pos + 4 >= len) {
            throw this.localDateError(pos);
        }
        char ch0 = input.charAt(pos);
        char ch1 = input.charAt(pos + 1);
        char ch2 = input.charAt(pos + 2);
        char ch3 = input.charAt(pos + 3);
        char ch4 = input.charAt(pos + 4);
        if (ch0 >= '0' && ch0 <= '9') {
            if (ch1 < '0' || ch1 > '9') {
                throw this.digitError(pos + 1);
            }
            if (ch2 < '0' || ch2 > '9') {
                throw this.digitError(pos + 2);
            }
            if (ch3 < '0' || ch3 > '9') {
                throw this.digitError(pos + 3);
            }
            if (ch4 != '-') {
                throw this.charError('-', pos + 4);
            }
            pos += 5;
            n = ch0 * 1000 + ch1 * 100 + ch2 * 10 + ch3 - 53328;
        } else {
            boolean yearNeg;
            boolean bl;
            if (ch0 == '-') {
                bl = true;
            } else {
                if (ch0 != '+') {
                    throw this.charsOrDigitError('-', '+', pos);
                }
                bl = yearNeg = false;
            }
            if (ch1 < '0' || ch1 > '9') {
                throw this.digitError(pos + 1);
            }
            if (ch2 < '0' || ch2 > '9') {
                throw this.digitError(pos + 2);
            }
            if (ch3 < '0' || ch3 > '9') {
                throw this.digitError(pos + 3);
            }
            if (ch4 < '0' || ch4 > '9') {
                throw this.digitError(pos + 4);
            }
            pos += 5;
            int year2 = ch1 * 1000 + ch2 * 100 + ch3 * 10 + ch4 - 53328;
            int yearDigits = 4;
            int ch = 48;
            while (true) {
                if (pos >= len) {
                    throw this.localDateError(pos);
                }
                ch = input.charAt(pos);
                ++pos;
                if (ch < 48 || ch > 57 || yearDigits >= 9) break;
                year2 = year2 * 10 + (ch - 48);
                ++yearDigits;
            }
            if (yearNeg) {
                if (year2 == 0) {
                    throw this.yearError(pos - 2);
                }
                year2 = -year2;
            }
            if (ch != 45) {
                throw this.yearError(yearNeg, yearDigits, pos - 1);
            }
            n = year = year2;
        }
        if (pos + 2 >= len) {
            throw this.localDateError(pos);
        }
        char ch02 = input.charAt(pos);
        char ch12 = input.charAt(pos + 1);
        char ch22 = input.charAt(pos + 2);
        int month = ch02 * 10 + ch12 - 528;
        if (ch02 < '0' || ch02 > '9') {
            throw this.digitError(pos);
        }
        if (ch12 < '0' || ch12 > '9') {
            throw this.digitError(pos + 1);
        }
        if (month < 1 || month > 12) {
            throw this.monthError(pos + 1);
        }
        if (ch22 != '-') {
            throw this.charError('-', pos + 2);
        }
        int month2 = month;
        if ((pos += 3) + 1 >= len) {
            throw this.localDateError(pos);
        }
        char ch03 = input.charAt(pos);
        char ch13 = input.charAt(pos + 1);
        int day = ch03 * 10 + ch13 - 528;
        if (ch03 < '0' || ch03 > '9') {
            throw this.digitError(pos);
        }
        if (ch13 < '0' || ch13 > '9') {
            throw this.digitError(pos + 1);
        }
        if (day == 0 || day > 28 && day > this.maxDayForYearMonth(year, month2)) {
            throw this.dayError(pos + 1);
        }
        int day2 = day;
        if ((pos += 2) != len) {
            throw this.localDateError(pos);
        }
        return LocalDate.of(year, month2, day2);
    }

    public LocalDateTime unsafeParseLocalDateTime(String input) {
        int year;
        int n;
        int pos = 0;
        int len = input.length();
        if (pos + 4 >= len) {
            throw this.localDateTimeError(pos);
        }
        char ch0 = input.charAt(pos);
        char ch1 = input.charAt(pos + 1);
        char ch2 = input.charAt(pos + 2);
        char ch3 = input.charAt(pos + 3);
        char ch4 = input.charAt(pos + 4);
        if (ch0 >= '0' && ch0 <= '9') {
            if (ch1 < '0' || ch1 > '9') {
                throw this.digitError(pos + 1);
            }
            if (ch2 < '0' || ch2 > '9') {
                throw this.digitError(pos + 2);
            }
            if (ch3 < '0' || ch3 > '9') {
                throw this.digitError(pos + 3);
            }
            if (ch4 != '-') {
                throw this.charError('-', pos + 4);
            }
            pos += 5;
            n = ch0 * 1000 + ch1 * 100 + ch2 * 10 + ch3 - 53328;
        } else {
            boolean yearNeg;
            boolean bl;
            if (ch0 == '-') {
                bl = true;
            } else {
                if (ch0 != '+') {
                    throw this.charsOrDigitError('-', '+', pos);
                }
                bl = yearNeg = false;
            }
            if (ch1 < '0' || ch1 > '9') {
                throw this.digitError(pos + 1);
            }
            if (ch2 < '0' || ch2 > '9') {
                throw this.digitError(pos + 2);
            }
            if (ch3 < '0' || ch3 > '9') {
                throw this.digitError(pos + 3);
            }
            if (ch4 < '0' || ch4 > '9') {
                throw this.digitError(pos + 4);
            }
            pos += 5;
            int year2 = ch1 * 1000 + ch2 * 100 + ch3 * 10 + ch4 - 53328;
            int yearDigits = 4;
            int ch = 48;
            while (true) {
                if (pos >= len) {
                    throw this.localDateTimeError(pos);
                }
                ch = input.charAt(pos);
                ++pos;
                if (ch < 48 || ch > 57 || yearDigits >= 9) break;
                year2 = year2 * 10 + (ch - 48);
                ++yearDigits;
            }
            if (yearNeg) {
                if (year2 == 0) {
                    throw this.yearError(pos - 2);
                }
                year2 = -year2;
            }
            if (ch != 45) {
                throw this.yearError(yearNeg, yearDigits, pos - 1);
            }
            n = year = year2;
        }
        if (pos + 2 >= len) {
            throw this.localDateTimeError(pos);
        }
        char ch02 = input.charAt(pos);
        char ch12 = input.charAt(pos + 1);
        char ch22 = input.charAt(pos + 2);
        int month = ch02 * 10 + ch12 - 528;
        if (ch02 < '0' || ch02 > '9') {
            throw this.digitError(pos);
        }
        if (ch12 < '0' || ch12 > '9') {
            throw this.digitError(pos + 1);
        }
        if (month < 1 || month > 12) {
            throw this.monthError(pos + 1);
        }
        if (ch22 != '-') {
            throw this.charError('-', pos + 2);
        }
        int month2 = month;
        if ((pos += 3) + 2 >= len) {
            throw this.localDateTimeError(pos);
        }
        char ch03 = input.charAt(pos);
        char ch13 = input.charAt(pos + 1);
        char ch23 = input.charAt(pos + 2);
        int day = ch03 * 10 + ch13 - 528;
        if (ch03 < '0' || ch03 > '9') {
            throw this.digitError(pos);
        }
        if (ch13 < '0' || ch13 > '9') {
            throw this.digitError(pos + 1);
        }
        if (day == 0 || day > 28 && day > this.maxDayForYearMonth(year, month2)) {
            throw this.dayError(pos + 1);
        }
        if (ch23 != 'T') {
            throw this.charError('T', pos + 2);
        }
        int day2 = day;
        if ((pos += 3) + 2 >= len) {
            throw this.localDateTimeError(pos);
        }
        char ch04 = input.charAt(pos);
        char ch14 = input.charAt(pos + 1);
        char ch24 = input.charAt(pos + 2);
        int hour = ch04 * 10 + ch14 - 528;
        if (ch04 < '0' || ch04 > '9') {
            throw this.digitError(pos);
        }
        if (ch14 < '0' || ch14 > '9') {
            throw this.digitError(pos + 1);
        }
        if (hour > 23) {
            throw this.hourError(pos + 1);
        }
        if (ch24 != ':') {
            throw this.charError(':', pos + 2);
        }
        int hour2 = hour;
        if ((pos += 3) + 1 >= len) {
            throw this.localDateTimeError(pos);
        }
        char ch05 = input.charAt(pos);
        char ch15 = input.charAt(pos + 1);
        if (ch05 < '0' || ch05 > '9') {
            throw this.digitError(pos);
        }
        if (ch15 < '0' || ch15 > '9') {
            throw this.digitError(pos + 1);
        }
        if (ch05 > '5') {
            throw this.minuteError(pos + 1);
        }
        int minute = ch05 * 10 + ch15 - 528;
        int second = 0;
        int nano = 0;
        if ((pos += 2) < len) {
            if (input.charAt(pos) != ':') {
                throw this.charError(':', pos);
            }
            if (++pos + 1 >= len) {
                throw this.localDateTimeError(pos);
            }
            char ch06 = input.charAt(pos);
            char ch16 = input.charAt(pos + 1);
            if (ch06 < '0' || ch06 > '9') {
                throw this.digitError(pos);
            }
            if (ch16 < '0' || ch16 > '9') {
                throw this.digitError(pos + 1);
            }
            if (ch06 > '5') {
                throw this.secondError(pos + 1);
            }
            second = ch06 * 10 + ch16 - 528;
            if ((pos += 2) < len) {
                if (input.charAt(pos) != '.') {
                    throw this.charError('.', pos);
                }
                ++pos;
                int nanoDigitWeight = 100000000;
                int ch = 48;
                while (pos < len) {
                    ch = input.charAt(pos);
                    ++pos;
                    if (ch < 48 || ch > 57 || nanoDigitWeight == 0) break;
                    nano += (ch - 48) * nanoDigitWeight;
                    nanoDigitWeight = (int)((long)nanoDigitWeight * 0xCCCCCCCDL >> 35);
                }
                if (pos != len || ch < 48 || ch > 57) {
                    throw this.localDateTimeError(pos - 1);
                }
            }
        }
        return LocalDateTime.of(year, month2, day2, hour2, minute, second, nano);
    }

    public LocalTime unsafeParseLocalTime(String input) {
        int pos = 0;
        int len = input.length();
        if (pos + 2 >= len) {
            throw this.localTimeError(pos);
        }
        char ch0 = input.charAt(pos);
        char ch1 = input.charAt(pos + 1);
        char ch2 = input.charAt(pos + 2);
        int hour = ch0 * 10 + ch1 - 528;
        if (ch0 < '0' || ch0 > '9') {
            throw this.digitError(pos);
        }
        if (ch1 < '0' || ch1 > '9') {
            throw this.digitError(pos + 1);
        }
        if (hour > 23) {
            throw this.hourError(pos + 1);
        }
        if (ch2 != ':') {
            throw this.charError(':', pos + 2);
        }
        int hour2 = hour;
        if ((pos += 3) + 1 >= len) {
            throw this.localTimeError(pos);
        }
        char ch02 = input.charAt(pos);
        char ch12 = input.charAt(pos + 1);
        if (ch02 < '0' || ch02 > '9') {
            throw this.digitError(pos);
        }
        if (ch12 < '0' || ch12 > '9') {
            throw this.digitError(pos + 1);
        }
        if (ch02 > '5') {
            throw this.minuteError(pos + 1);
        }
        int minute = ch02 * 10 + ch12 - 528;
        int second = 0;
        int nano = 0;
        if ((pos += 2) < len) {
            if (input.charAt(pos) != ':') {
                throw this.charError(':', pos);
            }
            if (++pos + 1 >= len) {
                throw this.localTimeError(pos);
            }
            char ch03 = input.charAt(pos);
            char ch13 = input.charAt(pos + 1);
            if (ch03 < '0' || ch03 > '9') {
                throw this.digitError(pos);
            }
            if (ch13 < '0' || ch13 > '9') {
                throw this.digitError(pos + 1);
            }
            if (ch03 > '5') {
                throw this.secondError(pos + 1);
            }
            second = ch03 * 10 + ch13 - 528;
            if ((pos += 2) < len) {
                if (input.charAt(pos) != '.') {
                    throw this.charError('.', pos);
                }
                ++pos;
                int nanoDigitWeight = 100000000;
                int ch = 48;
                while (pos < len) {
                    ch = input.charAt(pos);
                    ++pos;
                    if (ch < 48 || ch > 57 || nanoDigitWeight == 0) break;
                    nano += (ch - 48) * nanoDigitWeight;
                    nanoDigitWeight = (int)((long)nanoDigitWeight * 0xCCCCCCCDL >> 35);
                }
                if (pos != len || ch < 48 || ch > 57) {
                    throw this.localTimeError(pos - 1);
                }
            }
        }
        return LocalTime.of(hour2, minute, second, nano);
    }

    public MonthDay unsafeParseMonthDay(String input) {
        if (input.length() != 7) {
            throw this.error("illegal month day", 0);
        }
        char ch0 = input.charAt(0);
        char ch1 = input.charAt(1);
        char ch2 = input.charAt(2);
        char ch3 = input.charAt(3);
        char ch4 = input.charAt(4);
        char ch5 = input.charAt(5);
        char ch6 = input.charAt(6);
        int month = ch2 * 10 + ch3 - 528;
        int day = ch5 * 10 + ch6 - 528;
        if (ch0 != '-') {
            throw this.charError('-', 0);
        }
        if (ch1 != '-') {
            throw this.charError('-', 1);
        }
        if (ch2 < '0' || ch2 > '9') {
            throw this.digitError(2);
        }
        if (ch3 < '0' || ch3 > '9') {
            throw this.digitError(3);
        }
        if (month < 1 || month > 12) {
            throw this.monthError(3);
        }
        if (ch4 != '-') {
            throw this.charError('-', 4);
        }
        if (ch5 < '0' || ch5 > '9') {
            throw this.digitError(5);
        }
        if (ch6 < '0' || ch6 > '9') {
            throw this.digitError(6);
        }
        if (day == 0 || day > 28 && day > this.maxDayForMonth(month)) {
            throw this.dayError(6);
        }
        return MonthDay.of(month, day);
    }

    public OffsetDateTime unsafeParseOffsetDateTime(String input) {
        ZoneOffset zoneOffset;
        ZoneOffset zoneOffset2;
        int year;
        int n;
        int pos = 0;
        int len = input.length();
        if (pos + 4 >= len) {
            throw this.offsetDateTimeError(pos);
        }
        char ch0 = input.charAt(pos);
        char ch1 = input.charAt(pos + 1);
        char ch2 = input.charAt(pos + 2);
        char ch3 = input.charAt(pos + 3);
        char ch4 = input.charAt(pos + 4);
        if (ch0 >= '0' && ch0 <= '9') {
            if (ch1 < '0' || ch1 > '9') {
                throw this.digitError(pos + 1);
            }
            if (ch2 < '0' || ch2 > '9') {
                throw this.digitError(pos + 2);
            }
            if (ch3 < '0' || ch3 > '9') {
                throw this.digitError(pos + 3);
            }
            if (ch4 != '-') {
                throw this.charError('-', pos + 4);
            }
            pos += 5;
            n = ch0 * 1000 + ch1 * 100 + ch2 * 10 + ch3 - 53328;
        } else {
            boolean yearNeg;
            boolean bl;
            if (ch0 == '-') {
                bl = true;
            } else {
                if (ch0 != '+') {
                    throw this.charsOrDigitError('-', '+', pos);
                }
                bl = yearNeg = false;
            }
            if (ch1 < '0' || ch1 > '9') {
                throw this.digitError(pos + 1);
            }
            if (ch2 < '0' || ch2 > '9') {
                throw this.digitError(pos + 2);
            }
            if (ch3 < '0' || ch3 > '9') {
                throw this.digitError(pos + 3);
            }
            if (ch4 < '0' || ch4 > '9') {
                throw this.digitError(pos + 4);
            }
            pos += 5;
            int year2 = ch1 * 1000 + ch2 * 100 + ch3 * 10 + ch4 - 53328;
            int yearDigits = 4;
            int ch = 48;
            while (true) {
                if (pos >= len) {
                    throw this.offsetDateTimeError(pos);
                }
                ch = input.charAt(pos);
                ++pos;
                if (ch < 48 || ch > 57 || yearDigits >= 9) break;
                year2 = year2 * 10 + (ch - 48);
                ++yearDigits;
            }
            if (yearNeg) {
                if (year2 == 0) {
                    throw this.yearError(pos - 2);
                }
                year2 = -year2;
            }
            if (ch != 45) {
                throw this.yearError(yearNeg, yearDigits, pos - 1);
            }
            n = year = year2;
        }
        if (pos + 2 >= len) {
            throw this.offsetDateTimeError(pos);
        }
        char ch02 = input.charAt(pos);
        char ch12 = input.charAt(pos + 1);
        char ch22 = input.charAt(pos + 2);
        int month = ch02 * 10 + ch12 - 528;
        if (ch02 < '0' || ch02 > '9') {
            throw this.digitError(pos);
        }
        if (ch12 < '0' || ch12 > '9') {
            throw this.digitError(pos + 1);
        }
        if (month < 1 || month > 12) {
            throw this.monthError(pos + 1);
        }
        if (ch22 != '-') {
            throw this.charError('-', pos + 2);
        }
        int month2 = month;
        if ((pos += 3) + 2 >= len) {
            throw this.offsetDateTimeError(pos);
        }
        char ch03 = input.charAt(pos);
        char ch13 = input.charAt(pos + 1);
        char ch23 = input.charAt(pos + 2);
        int day = ch03 * 10 + ch13 - 528;
        if (ch03 < '0' || ch03 > '9') {
            throw this.digitError(pos);
        }
        if (ch13 < '0' || ch13 > '9') {
            throw this.digitError(pos + 1);
        }
        if (day == 0 || day > 28 && day > this.maxDayForYearMonth(year, month2)) {
            throw this.dayError(pos + 1);
        }
        if (ch23 != 'T') {
            throw this.charError('T', pos + 2);
        }
        int day2 = day;
        if ((pos += 3) + 2 >= len) {
            throw this.offsetDateTimeError(pos);
        }
        char ch04 = input.charAt(pos);
        char ch14 = input.charAt(pos + 1);
        char ch24 = input.charAt(pos + 2);
        int hour = ch04 * 10 + ch14 - 528;
        if (ch04 < '0' || ch04 > '9') {
            throw this.digitError(pos);
        }
        if (ch14 < '0' || ch14 > '9') {
            throw this.digitError(pos + 1);
        }
        if (hour > 23) {
            throw this.hourError(pos + 1);
        }
        if (ch24 != ':') {
            throw this.charError(':', pos + 2);
        }
        int hour2 = hour;
        if ((pos += 3) + 1 >= len) {
            throw this.offsetDateTimeError(pos);
        }
        char ch05 = input.charAt(pos);
        char ch15 = input.charAt(pos + 1);
        if (ch05 < '0' || ch05 > '9') {
            throw this.digitError(pos);
        }
        if (ch15 < '0' || ch15 > '9') {
            throw this.digitError(pos + 1);
        }
        if (ch05 > '5') {
            throw this.minuteError(pos + 1);
        }
        int minute = ch05 * 10 + ch15 - 528;
        int second = 0;
        int nano = 0;
        int nanoDigitWeight = -1;
        if ((pos += 2) >= len) {
            throw this.timezoneSignError(nanoDigitWeight, pos);
        }
        char ch = input.charAt(pos);
        ++pos;
        if (ch == ':') {
            nanoDigitWeight = -2;
            if (pos + 1 >= len) {
                throw this.offsetDateTimeError(pos);
            }
            char ch06 = input.charAt(pos);
            char ch16 = input.charAt(pos + 1);
            if (ch06 < '0' || ch06 > '9') {
                throw this.digitError(pos);
            }
            if (ch16 < '0' || ch16 > '9') {
                throw this.digitError(pos + 1);
            }
            if (ch06 > '5') {
                throw this.secondError(pos + 1);
            }
            second = ch06 * 10 + ch16 - 528;
            if ((pos += 2) >= len) {
                throw this.timezoneSignError(nanoDigitWeight, pos);
            }
            ch = input.charAt(pos);
            ++pos;
            if (ch == '.') {
                nanoDigitWeight = 100000000;
                while (true) {
                    if (pos >= len) {
                        throw this.timezoneSignError(nanoDigitWeight, pos);
                    }
                    ch = input.charAt(pos);
                    ++pos;
                    if (ch < '0' || ch > '9' || nanoDigitWeight == 0) break;
                    nano += (ch - 48) * nanoDigitWeight;
                    nanoDigitWeight = (int)((long)nanoDigitWeight * 0xCCCCCCCDL >> 35);
                }
            }
        }
        if (ch == 'Z') {
            zoneOffset2 = ZoneOffset.UTC;
        } else {
            boolean offsetNeg;
            boolean bl;
            if (ch == '-') {
                bl = true;
            } else {
                if (ch != '+') {
                    throw this.timezoneSignError(nanoDigitWeight, pos - 1);
                }
                bl = offsetNeg = false;
            }
            if (pos + 1 >= len) {
                throw this.offsetDateTimeError(pos);
            }
            char ch07 = input.charAt(pos);
            char ch17 = input.charAt(pos + 1);
            int offsetHour = ch07 * 10 + ch17 - 528;
            if (ch07 < '0' || ch07 > '9') {
                throw this.digitError(pos);
            }
            if (ch17 < '0' || ch17 > '9') {
                throw this.digitError(pos + 1);
            }
            if (offsetHour > 18) {
                throw this.timezoneOffsetHourError(pos + 1);
            }
            int offsetHour2 = offsetHour;
            int offsetMinute = 0;
            int offsetSecond = 0;
            if ((pos += 2) < len) {
                ch = input.charAt(pos);
                ++pos;
                if (ch == ':') {
                    if (pos + 1 >= len) {
                        throw this.offsetDateTimeError(pos);
                    }
                    char ch08 = input.charAt(pos);
                    char ch18 = input.charAt(pos + 1);
                    if (ch08 < '0' || ch08 > '9') {
                        throw this.digitError(pos);
                    }
                    if (ch18 < '0' || ch18 > '9') {
                        throw this.digitError(pos + 1);
                    }
                    if (ch08 > '5') {
                        throw this.timezoneOffsetMinuteError(pos + 1);
                    }
                    offsetMinute = ch08 * 10 + ch18 - 528;
                    if ((pos += 2) < len) {
                        ch = input.charAt(pos);
                        ++pos;
                        if (ch == ':') {
                            if (pos + 1 >= len) {
                                throw this.offsetDateTimeError(pos);
                            }
                            char ch09 = input.charAt(pos);
                            char ch19 = input.charAt(pos + 1);
                            if (ch09 < '0' || ch09 > '9') {
                                throw this.digitError(pos);
                            }
                            if (ch19 < '0' || ch19 > '9') {
                                throw this.digitError(pos + 1);
                            }
                            if (ch09 > '5') {
                                throw this.timezoneOffsetSecondError(pos + 1);
                            }
                            pos += 2;
                            offsetSecond = ch09 * 10 + ch19 - 528;
                        }
                    }
                }
            }
            zoneOffset2 = zoneOffset = this.toZoneOffset(offsetNeg, offsetHour2, offsetMinute, offsetSecond, pos);
        }
        if (pos != len) {
            throw this.offsetDateTimeError(pos);
        }
        return OffsetDateTime.of(year, month2, day2, hour2, minute, second, nano, zoneOffset);
    }

    public OffsetTime unsafeParseOffsetTime(String input) {
        ZoneOffset zoneOffset;
        ZoneOffset zoneOffset2;
        int pos = 0;
        int len = input.length();
        if (pos + 2 >= len) {
            throw this.offsetTimeError(pos);
        }
        char ch0 = input.charAt(pos);
        char ch1 = input.charAt(pos + 1);
        char ch2 = input.charAt(pos + 2);
        int hour = ch0 * 10 + ch1 - 528;
        if (ch0 < '0' || ch0 > '9') {
            throw this.digitError(pos);
        }
        if (ch1 < '0' || ch1 > '9') {
            throw this.digitError(pos + 1);
        }
        if (hour > 23) {
            throw this.hourError(pos + 1);
        }
        if (ch2 != ':') {
            throw this.charError(':', pos + 2);
        }
        int hour2 = hour;
        if ((pos += 3) + 1 >= len) {
            throw this.offsetTimeError(pos);
        }
        char ch02 = input.charAt(pos);
        char ch12 = input.charAt(pos + 1);
        if (ch02 < '0' || ch02 > '9') {
            throw this.digitError(pos);
        }
        if (ch12 < '0' || ch12 > '9') {
            throw this.digitError(pos + 1);
        }
        if (ch02 > '5') {
            throw this.minuteError(pos + 1);
        }
        int minute = ch02 * 10 + ch12 - 528;
        int second = 0;
        int nano = 0;
        int nanoDigitWeight = -1;
        if ((pos += 2) >= len) {
            throw this.timezoneSignError(nanoDigitWeight, pos);
        }
        char ch = input.charAt(pos);
        ++pos;
        if (ch == ':') {
            nanoDigitWeight = -2;
            if (pos + 1 >= len) {
                throw this.offsetTimeError(pos);
            }
            char ch03 = input.charAt(pos);
            char ch13 = input.charAt(pos + 1);
            if (ch03 < '0' || ch03 > '9') {
                throw this.digitError(pos);
            }
            if (ch13 < '0' || ch13 > '9') {
                throw this.digitError(pos + 1);
            }
            if (ch03 > '5') {
                throw this.secondError(pos + 1);
            }
            second = ch03 * 10 + ch13 - 528;
            if ((pos += 2) >= len) {
                throw this.timezoneSignError(nanoDigitWeight, pos);
            }
            ch = input.charAt(pos);
            ++pos;
            if (ch == '.') {
                nanoDigitWeight = 100000000;
                while (true) {
                    if (pos >= len) {
                        throw this.timezoneSignError(nanoDigitWeight, pos);
                    }
                    ch = input.charAt(pos);
                    ++pos;
                    if (ch < '0' || ch > '9' || nanoDigitWeight == 0) break;
                    nano += (ch - 48) * nanoDigitWeight;
                    nanoDigitWeight = (int)((long)nanoDigitWeight * 0xCCCCCCCDL >> 35);
                }
            }
        }
        if (ch == 'Z') {
            zoneOffset2 = ZoneOffset.UTC;
        } else {
            boolean bl;
            if (ch == '-') {
                bl = true;
            } else {
                if (ch != '+') {
                    throw this.timezoneSignError(nanoDigitWeight, pos - 1);
                }
                bl = false;
            }
            boolean offsetNeg = bl;
            nanoDigitWeight = -3;
            if (pos + 1 >= len) {
                throw this.offsetTimeError(pos);
            }
            char ch04 = input.charAt(pos);
            char ch14 = input.charAt(pos + 1);
            int offsetHour = ch04 * 10 + ch14 - 528;
            if (ch04 < '0' || ch04 > '9') {
                throw this.digitError(pos);
            }
            if (ch14 < '0' || ch14 > '9') {
                throw this.digitError(pos + 1);
            }
            if (offsetHour > 18) {
                throw this.timezoneOffsetHourError(pos + 1);
            }
            int offsetHour2 = offsetHour;
            int offsetMinute = 0;
            int offsetSecond = 0;
            if ((pos += 2) < len) {
                ch = input.charAt(pos);
                ++pos;
                if (ch == ':') {
                    if (pos + 1 >= len) {
                        throw this.offsetTimeError(pos);
                    }
                    char ch05 = input.charAt(pos);
                    char ch15 = input.charAt(pos + 1);
                    if (ch05 < '0' || ch05 > '9') {
                        throw this.digitError(pos);
                    }
                    if (ch15 < '0' || ch15 > '9') {
                        throw this.digitError(pos + 1);
                    }
                    if (ch05 > '5') {
                        throw this.timezoneOffsetMinuteError(pos + 1);
                    }
                    offsetMinute = ch05 * 10 + ch15 - 528;
                    if ((pos += 2) < len) {
                        ch = input.charAt(pos);
                        ++pos;
                        if (ch == ':') {
                            nanoDigitWeight = -4;
                            if (pos + 1 >= len) {
                                throw this.offsetTimeError(pos);
                            }
                            char ch06 = input.charAt(pos);
                            char ch16 = input.charAt(pos + 1);
                            if (ch06 < '0' || ch06 > '9') {
                                throw this.digitError(pos);
                            }
                            if (ch16 < '0' || ch16 > '9') {
                                throw this.digitError(pos + 1);
                            }
                            if (ch06 > '5') {
                                throw this.timezoneOffsetSecondError(pos + 1);
                            }
                            pos += 2;
                            offsetSecond = ch06 * 10 + ch16 - 528;
                        }
                    }
                }
            }
            zoneOffset2 = zoneOffset = this.toZoneOffset(offsetNeg, offsetHour2, offsetMinute, offsetSecond, pos);
        }
        if (pos != len) {
            throw this.offsetTimeError(pos);
        }
        return OffsetTime.of(hour2, minute, second, nano, zoneOffset);
    }

    public Period unsafeParsePeriod(String input) {
        boolean isNeg;
        int len = input.length();
        int pos = 0;
        int state = 0;
        int years = 0;
        int months = 0;
        int days = 0;
        if (pos >= len) {
            throw this.periodError(pos);
        }
        char ch = input.charAt(pos);
        ++pos;
        boolean bl = isNeg = ch == '-';
        if (isNeg) {
            if (pos >= len) {
                throw this.periodError(pos);
            }
            ch = input.charAt(pos);
            ++pos;
        }
        if (ch != 'P') {
            throw this.durationOrPeriodStartError(isNeg, pos - 1);
        }
        if (pos >= len) {
            throw this.periodError(pos);
        }
        ch = input.charAt(pos);
        ++pos;
        do {
            boolean isNegX;
            if (state == 4 && pos >= len) {
                throw this.periodError(pos - 1);
            }
            boolean bl2 = isNegX = ch == '-';
            if (isNegX) {
                if (pos >= len) {
                    throw this.periodError(pos);
                }
                ch = input.charAt(pos);
                ++pos;
            }
            if (ch < '0' || ch > '9') {
                throw this.durationOrPeriodDigitError(isNegX, state <= 1, pos - 1);
            }
            int x = 48 - ch;
            while (pos < len && (ch = input.charAt(pos)) >= '0' && ch <= '9') {
                if (x < -214748364 || (x = x * 10 + (48 - ch)) > 0) {
                    throw this.periodError(pos);
                }
                ++pos;
            }
            if (!(isNeg ^ isNegX)) {
                if (x == Integer.MIN_VALUE) {
                    throw this.periodError(pos);
                }
                x = -x;
            }
            if (ch == 'Y' && state <= 0) {
                years = x;
                state = 1;
            } else if (ch == 'M' && state <= 1) {
                months = x;
                state = 2;
            } else if (ch == 'W' && state <= 2) {
                if (x < -306783378 || x > 306783378) {
                    throw this.periodError(pos);
                }
                days = x * 7;
                state = 3;
            } else if (ch == 'D') {
                long ds = (long)x + (long)days;
                if (ds != (long)((int)ds)) {
                    throw this.periodError(pos);
                }
                days = (int)ds;
                state = 4;
            } else {
                throw this.periodError(state, pos);
            }
            if (++pos >= len) break;
            ch = input.charAt(pos);
            ++pos;
        } while (true);
        return Period.of(years, months, days);
    }

    public Year unsafeParseYear(String input) {
        int n;
        int pos = 0;
        int len = input.length();
        if (pos + 3 >= len) {
            throw this.yearError(pos);
        }
        char ch0 = input.charAt(pos);
        char ch1 = input.charAt(pos + 1);
        char ch2 = input.charAt(pos + 2);
        char ch3 = input.charAt(pos + 3);
        if (ch0 >= '0' && ch0 <= '9') {
            if (ch1 < '0' || ch1 > '9') {
                throw this.digitError(pos + 1);
            }
            if (ch2 < '0' || ch2 > '9') {
                throw this.digitError(pos + 2);
            }
            if (ch3 < '0' || ch3 > '9') {
                throw this.digitError(pos + 3);
            }
            if (len != 4) {
                throw this.yearError(pos + 4);
            }
            pos += 4;
            n = ch0 * 1000 + ch1 * 100 + ch2 * 10 + ch3 - 53328;
        } else {
            int yearDigits;
            boolean yearNeg;
            boolean bl;
            if (ch0 == '-') {
                bl = true;
            } else {
                if (ch0 != '+') {
                    throw this.charsOrDigitError('-', '+', pos);
                }
                bl = yearNeg = false;
            }
            if (ch1 < '0' || ch1 > '9') {
                throw this.digitError(pos + 1);
            }
            if (ch2 < '0' || ch2 > '9') {
                throw this.digitError(pos + 2);
            }
            if (ch3 < '0' || ch3 > '9') {
                throw this.digitError(pos + 3);
            }
            pos += 4;
            int year = ch1 * 100 + ch2 * 10 + ch3 - 5328;
            int ch = 48;
            for (yearDigits = 3; pos < len && (ch = (int)input.charAt(pos)) >= 48 && ch <= 57 && yearDigits < 9; ++yearDigits, ++pos) {
                year = year * 10 + (ch - 48);
            }
            if (yearNeg) {
                if (year == 0) {
                    throw this.yearError(pos - 1);
                }
                year = -year;
            }
            if (pos != len || ch < 48 || ch > 57) {
                if (yearDigits == 9) {
                    throw this.yearError(pos);
                }
                throw this.digitError(pos);
            }
            n = year;
        }
        int year = n;
        return Year.of(year);
    }

    public YearMonth unsafeParseYearMonth(String input) {
        int year;
        int n;
        int pos = 0;
        int len = input.length();
        if (pos + 4 >= len) {
            throw this.yearMonthError(pos);
        }
        char ch0 = input.charAt(pos);
        char ch1 = input.charAt(pos + 1);
        char ch2 = input.charAt(pos + 2);
        char ch3 = input.charAt(pos + 3);
        char ch4 = input.charAt(pos + 4);
        if (ch0 >= '0' && ch0 <= '9') {
            if (ch1 < '0' || ch1 > '9') {
                throw this.digitError(pos + 1);
            }
            if (ch2 < '0' || ch2 > '9') {
                throw this.digitError(pos + 2);
            }
            if (ch3 < '0' || ch3 > '9') {
                throw this.digitError(pos + 3);
            }
            if (ch4 != '-') {
                throw this.charError('-', pos + 4);
            }
            pos += 5;
            n = ch0 * 1000 + ch1 * 100 + ch2 * 10 + ch3 - 53328;
        } else {
            boolean yearNeg;
            boolean bl;
            if (ch0 == '-') {
                bl = true;
            } else {
                if (ch0 != '+') {
                    throw this.charsOrDigitError('-', '+', pos);
                }
                bl = yearNeg = false;
            }
            if (ch1 < '0' || ch1 > '9') {
                throw this.digitError(pos + 1);
            }
            if (ch2 < '0' || ch2 > '9') {
                throw this.digitError(pos + 2);
            }
            if (ch3 < '0' || ch3 > '9') {
                throw this.digitError(pos + 3);
            }
            if (ch4 < '0' || ch4 > '9') {
                throw this.digitError(pos + 4);
            }
            pos += 5;
            int year2 = ch1 * 1000 + ch2 * 100 + ch3 * 10 + ch4 - 53328;
            int yearDigits = 4;
            int ch = 48;
            while (true) {
                if (pos >= len) {
                    throw this.yearMonthError(pos);
                }
                ch = input.charAt(pos);
                ++pos;
                if (ch < 48 || ch > 57 || yearDigits >= 9) break;
                year2 = year2 * 10 + (ch - 48);
                ++yearDigits;
            }
            if (yearNeg) {
                if (year2 == 0) {
                    throw this.yearError(pos - 2);
                }
                year2 = -year2;
            }
            if (ch != 45) {
                throw this.yearError(yearNeg, yearDigits, pos - 1);
            }
            n = year = year2;
        }
        if (pos + 1 >= len) {
            throw this.yearMonthError(pos);
        }
        char ch02 = input.charAt(pos);
        char ch12 = input.charAt(pos + 1);
        int month = ch02 * 10 + ch12 - 528;
        if (ch02 < '0' || ch02 > '9') {
            throw this.digitError(pos);
        }
        if (ch12 < '0' || ch12 > '9') {
            throw this.digitError(pos + 1);
        }
        if (month < 1 || month > 12) {
            throw this.monthError(pos + 1);
        }
        int month2 = month;
        if ((pos += 2) != len) {
            throw this.yearMonthError(pos);
        }
        return YearMonth.of(year, month2);
    }

    public ZonedDateTime unsafeParseZonedDateTime(String input) {
        ZoneOffset zoneOffset;
        ZoneOffset zoneOffset2;
        int year;
        int n;
        int pos = 0;
        int len = input.length();
        if (pos + 4 >= len) {
            throw this.zonedDateTimeError(pos);
        }
        char ch0 = input.charAt(pos);
        char ch1 = input.charAt(pos + 1);
        char ch2 = input.charAt(pos + 2);
        char ch3 = input.charAt(pos + 3);
        char ch4 = input.charAt(pos + 4);
        if (ch0 >= '0' && ch0 <= '9') {
            if (ch1 < '0' || ch1 > '9') {
                throw this.digitError(pos + 1);
            }
            if (ch2 < '0' || ch2 > '9') {
                throw this.digitError(pos + 2);
            }
            if (ch3 < '0' || ch3 > '9') {
                throw this.digitError(pos + 3);
            }
            if (ch4 != '-') {
                throw this.charError('-', pos + 4);
            }
            pos += 5;
            n = ch0 * 1000 + ch1 * 100 + ch2 * 10 + ch3 - 53328;
        } else {
            boolean yearNeg;
            boolean bl;
            if (ch0 == '-') {
                bl = true;
            } else {
                if (ch0 != '+') {
                    throw this.charsOrDigitError('-', '+', pos);
                }
                bl = yearNeg = false;
            }
            if (ch1 < '0' || ch1 > '9') {
                throw this.digitError(pos + 1);
            }
            if (ch2 < '0' || ch2 > '9') {
                throw this.digitError(pos + 2);
            }
            if (ch3 < '0' || ch3 > '9') {
                throw this.digitError(pos + 3);
            }
            if (ch4 < '0' || ch4 > '9') {
                throw this.digitError(pos + 4);
            }
            pos += 5;
            int year2 = ch1 * 1000 + ch2 * 100 + ch3 * 10 + ch4 - 53328;
            int yearDigits = 4;
            int ch = 48;
            while (true) {
                if (pos >= len) {
                    throw this.zonedDateTimeError(pos);
                }
                ch = input.charAt(pos);
                ++pos;
                if (ch < 48 || ch > 57 || yearDigits >= 9) break;
                year2 = year2 * 10 + (ch - 48);
                ++yearDigits;
            }
            if (yearNeg) {
                if (year2 == 0) {
                    throw this.yearError(pos - 2);
                }
                year2 = -year2;
            }
            if (ch != 45) {
                throw this.yearError(yearNeg, yearDigits, pos - 1);
            }
            n = year = year2;
        }
        if (pos + 2 >= len) {
            throw this.zonedDateTimeError(pos);
        }
        char ch02 = input.charAt(pos);
        char ch12 = input.charAt(pos + 1);
        char ch22 = input.charAt(pos + 2);
        int month = ch02 * 10 + ch12 - 528;
        if (ch02 < '0' || ch02 > '9') {
            throw this.digitError(pos);
        }
        if (ch12 < '0' || ch12 > '9') {
            throw this.digitError(pos + 1);
        }
        if (month < 1 || month > 12) {
            throw this.monthError(pos + 1);
        }
        if (ch22 != '-') {
            throw this.charError('-', pos + 2);
        }
        int month2 = month;
        if ((pos += 3) + 2 >= len) {
            throw this.zonedDateTimeError(pos);
        }
        char ch03 = input.charAt(pos);
        char ch13 = input.charAt(pos + 1);
        char ch23 = input.charAt(pos + 2);
        int day = ch03 * 10 + ch13 - 528;
        if (ch03 < '0' || ch03 > '9') {
            throw this.digitError(pos);
        }
        if (ch13 < '0' || ch13 > '9') {
            throw this.digitError(pos + 1);
        }
        if (day == 0 || day > 28 && day > this.maxDayForYearMonth(year, month2)) {
            throw this.dayError(pos + 1);
        }
        if (ch23 != 'T') {
            throw this.charError('T', pos + 2);
        }
        int day2 = day;
        if ((pos += 3) + 2 >= len) {
            throw this.zonedDateTimeError(pos);
        }
        char ch04 = input.charAt(pos);
        char ch14 = input.charAt(pos + 1);
        char ch24 = input.charAt(pos + 2);
        int hour = ch04 * 10 + ch14 - 528;
        if (ch04 < '0' || ch04 > '9') {
            throw this.digitError(pos);
        }
        if (ch14 < '0' || ch14 > '9') {
            throw this.digitError(pos + 1);
        }
        if (hour > 23) {
            throw this.hourError(pos + 1);
        }
        if (ch24 != ':') {
            throw this.charError(':', pos + 2);
        }
        int hour2 = hour;
        if ((pos += 3) + 1 >= len) {
            throw this.zonedDateTimeError(pos);
        }
        char ch05 = input.charAt(pos);
        char ch15 = input.charAt(pos + 1);
        if (ch05 < '0' || ch05 > '9') {
            throw this.digitError(pos);
        }
        if (ch15 < '0' || ch15 > '9') {
            throw this.digitError(pos + 1);
        }
        if (ch05 > '5') {
            throw this.minuteError(pos + 1);
        }
        int minute = ch05 * 10 + ch15 - 528;
        int second = 0;
        int nano = 0;
        int nanoDigitWeight = -1;
        if ((pos += 2) >= len) {
            throw this.timezoneSignError(nanoDigitWeight, pos);
        }
        char ch = input.charAt(pos);
        ++pos;
        if (ch == ':') {
            nanoDigitWeight = -2;
            if (pos + 1 >= len) {
                throw this.zonedDateTimeError(pos);
            }
            char ch06 = input.charAt(pos);
            char ch16 = input.charAt(pos + 1);
            if (ch06 < '0' || ch06 > '9') {
                throw this.digitError(pos);
            }
            if (ch16 < '0' || ch16 > '9') {
                throw this.digitError(pos + 1);
            }
            if (ch06 > '5') {
                throw this.secondError(pos + 1);
            }
            second = ch06 * 10 + ch16 - 528;
            if ((pos += 2) >= len) {
                throw this.timezoneSignError(nanoDigitWeight, pos);
            }
            ch = input.charAt(pos);
            ++pos;
            if (ch == '.') {
                nanoDigitWeight = 100000000;
                while (true) {
                    if (pos >= len) {
                        throw this.timezoneSignError(nanoDigitWeight, pos);
                    }
                    ch = input.charAt(pos);
                    ++pos;
                    if (ch < '0' || ch > '9' || nanoDigitWeight == 0) break;
                    nano += (ch - 48) * nanoDigitWeight;
                    nanoDigitWeight = (int)((long)nanoDigitWeight * 0xCCCCCCCDL >> 35);
                }
            }
        }
        LocalDateTime localDateTime = LocalDateTime.of(year, month2, day2, hour2, minute, second, nano);
        if (ch == 'Z') {
            if (pos < len) {
                ch = input.charAt(pos);
                if (ch != '[') {
                    throw this.charError('[', pos);
                }
                ++pos;
            }
            zoneOffset2 = ZoneOffset.UTC;
        } else {
            boolean bl;
            if (ch == '-') {
                bl = true;
            } else {
                if (ch != '+') {
                    throw this.timezoneSignError(nanoDigitWeight, pos - 1);
                }
                bl = false;
            }
            boolean offsetNeg = bl;
            nanoDigitWeight = -3;
            if (pos + 1 >= len) {
                throw this.zonedDateTimeError(pos);
            }
            char ch07 = input.charAt(pos);
            char ch17 = input.charAt(pos + 1);
            int offsetHour = ch07 * 10 + ch17 - 528;
            if (ch07 < '0' || ch07 > '9') {
                throw this.digitError(pos);
            }
            if (ch17 < '0' || ch17 > '9') {
                throw this.digitError(pos + 1);
            }
            if (offsetHour > 18) {
                throw this.timezoneOffsetHourError(pos + 1);
            }
            int offsetHour2 = offsetHour;
            int offsetMinute = 0;
            int offsetSecond = 0;
            if ((pos += 2) < len) {
                ch = input.charAt(pos);
                ++pos;
                if (ch != ':') {
                    if (ch != '[') {
                        throw this.charError('[', pos - 1);
                    }
                } else {
                    if (pos + 1 >= len) {
                        throw this.zonedDateTimeError(pos);
                    }
                    char ch08 = input.charAt(pos);
                    char ch18 = input.charAt(pos + 1);
                    if (ch08 < '0' || ch08 > '9') {
                        throw this.digitError(pos);
                    }
                    if (ch18 < '0' || ch18 > '9') {
                        throw this.digitError(pos + 1);
                    }
                    if (ch08 > '5') {
                        throw this.timezoneOffsetMinuteError(pos + 1);
                    }
                    offsetMinute = ch08 * 10 + ch18 - 528;
                    if ((pos += 2) < len) {
                        ch = input.charAt(pos);
                        ++pos;
                        if (ch != ':') {
                            if (ch != '[') {
                                throw this.charError('[', pos - 1);
                            }
                        } else {
                            nanoDigitWeight = -4;
                            if (pos + 1 >= len) {
                                throw this.zonedDateTimeError(pos);
                            }
                            char ch09 = input.charAt(pos);
                            char ch19 = input.charAt(pos + 1);
                            if (ch09 < '0' || ch09 > '9') {
                                throw this.digitError(pos);
                            }
                            if (ch19 < '0' || ch19 > '9') {
                                throw this.digitError(pos + 1);
                            }
                            if (ch09 > '5') {
                                throw this.timezoneOffsetSecondError(pos + 1);
                            }
                            offsetSecond = ch09 * 10 + ch19 - 528;
                            if ((pos += 2) < len) {
                                ch = input.charAt(pos);
                                if (ch != '[') {
                                    throw this.charError('[', pos);
                                }
                                ++pos;
                            }
                        }
                    }
                }
            }
            zoneOffset2 = zoneOffset = this.toZoneOffset(offsetNeg, offsetHour2, offsetMinute, offsetSecond, pos);
        }
        if (ch == '[') {
            ZoneId zoneId;
            try {
                int from = pos;
                while (true) {
                    if (pos >= len) {
                        throw this.zonedDateTimeError(pos);
                    }
                    ch = input.charAt(pos);
                    if (ch == ']') break;
                    ++pos;
                }
                String key = input.substring(from, pos);
                ZoneId zoneId2 = zoneIds.get(key);
                if (!(zoneId2 != null || (zoneId2 = ZoneId.of(key)) instanceof ZoneOffset && ((ZoneOffset)zoneId2).getTotalSeconds() % 900 != 0)) {
                    zoneIds.put(key, zoneId2);
                }
                zoneId = zoneId2;
            }
            catch (DateTimeException dateTimeException) {
                throw this.zonedDateTimeError(pos - 1);
            }
            ZoneId zone = zoneId;
            if (++pos != len) {
                throw this.zonedDateTimeError(pos);
            }
            return ZonedDateTime.ofInstant(localDateTime, zoneOffset, zone);
        }
        return ZonedDateTime.ofLocal(localDateTime, zoneOffset, null);
    }

    /*
     * WARNING - void declaration
     */
    public ZoneId unsafeParseZoneId(String input) {
        void v0;
        try {
            void var2_2;
            ZoneId zoneId = zoneIds.get(input);
            if (!(zoneId != null || (zoneId = ZoneId.of(input)) instanceof ZoneOffset && ((ZoneOffset)zoneId).getTotalSeconds() % 900 != 0)) {
                zoneIds.put(input, zoneId);
            }
            v0 = var2_2;
        }
        catch (DateTimeException dateTimeException) {
            throw this.error("illegal zone id", 0);
        }
        return v0;
    }

    public ZoneOffset unsafeParseZoneOffset(String input) {
        boolean bl;
        int len = input.length();
        int pos = 0;
        int nanoDigitWeight = 0;
        if (pos >= len) {
            throw this.zoneOffsetError(pos);
        }
        char ch = input.charAt(pos);
        ++pos;
        if (ch == 'Z') {
            return ZoneOffset.UTC;
        }
        if (ch == '-') {
            bl = true;
        } else {
            if (ch != '+') {
                throw this.timezoneSignError(nanoDigitWeight, pos - 1);
            }
            bl = false;
        }
        boolean offsetNeg = bl;
        nanoDigitWeight = -3;
        if (pos + 1 >= len) {
            throw this.zoneOffsetError(pos);
        }
        char ch0 = input.charAt(pos);
        char ch1 = input.charAt(pos + 1);
        int offsetHour = ch0 * 10 + ch1 - 528;
        if (ch0 < '0' || ch0 > '9') {
            throw this.digitError(pos);
        }
        if (ch1 < '0' || ch1 > '9') {
            throw this.digitError(pos + 1);
        }
        if (offsetHour > 18) {
            throw this.timezoneOffsetHourError(pos + 1);
        }
        int offsetHour2 = offsetHour;
        int offsetMinute = 0;
        int offsetSecond = 0;
        if ((pos += 2) < len) {
            ch = input.charAt(pos);
            ++pos;
            if (ch == ':') {
                if (pos + 1 >= len) {
                    throw this.zoneOffsetError(pos);
                }
                char ch02 = input.charAt(pos);
                char ch12 = input.charAt(pos + 1);
                if (ch02 < '0' || ch02 > '9') {
                    throw this.digitError(pos);
                }
                if (ch12 < '0' || ch12 > '9') {
                    throw this.digitError(pos + 1);
                }
                if (ch02 > '5') {
                    throw this.timezoneOffsetMinuteError(pos + 1);
                }
                offsetMinute = ch02 * 10 + ch12 - 528;
                if ((pos += 2) < len) {
                    ch = input.charAt(pos);
                    ++pos;
                    if (ch == ':') {
                        nanoDigitWeight = -4;
                        if (pos + 1 >= len) {
                            throw this.zoneOffsetError(pos);
                        }
                        char ch03 = input.charAt(pos);
                        char ch13 = input.charAt(pos + 1);
                        if (ch03 < '0' || ch03 > '9') {
                            throw this.digitError(pos);
                        }
                        if (ch13 < '0' || ch13 > '9') {
                            throw this.digitError(pos + 1);
                        }
                        if (ch03 > '5') {
                            throw this.timezoneOffsetSecondError(pos + 1);
                        }
                        pos += 2;
                        offsetSecond = ch03 * 10 + ch13 - 528;
                    }
                }
            }
        }
        if (pos != len) {
            throw this.zoneOffsetError(pos);
        }
        return this.toZoneOffset(offsetNeg, offsetHour2, offsetMinute, offsetSecond, pos);
    }

    private ZoneOffset toZoneOffset(boolean offsetNeg, int offsetHour, int offsetMinute, int offsetSecond, int pos) {
        int offsetTotal = offsetHour * 3600 + offsetMinute * 60 + offsetSecond;
        int qp = offsetTotal * 37283;
        if (offsetTotal > 64800) {
            throw this.zoneOffsetError(pos);
        }
        if ((qp & 0x1FF8000) == 0) {
            ZoneOffset zoneOffset;
            qp >>>= 25;
            if (offsetNeg) {
                qp = -qp;
            }
            if ((zoneOffset = zoneOffsets[qp + 72]) != null) {
                return zoneOffset;
            }
            if (offsetNeg) {
                offsetTotal = -offsetTotal;
            }
            parsers$.zoneOffsets[qp + 72] = zoneOffset = ZoneOffset.ofTotalSeconds(offsetTotal);
            return zoneOffset;
        }
        if (offsetNeg) {
            offsetTotal = -offsetTotal;
        }
        return ZoneOffset.ofTotalSeconds(offsetTotal);
    }

    private long sumSeconds(long s1, long s2, int pos) {
        long s = s1 + s2;
        if (((s1 ^ s) & (s2 ^ s)) < 0L) {
            throw this.durationError(pos);
        }
        return s;
    }

    private long epochDayForYear(int year) {
        long cp = (long)year * 1374389535L;
        return (long)year * 365L + (long)((year + 3 >> 2) - (int)(year < 0 ? (cp >> 37) - (cp >> 39) : (cp + 136064563965L >> 37) - (cp + 548381424465L >> 39)));
    }

    private int dayOfYearForYearMonth(int year, int month) {
        return (month * 1002277 - 988622 >> 15) - (month <= 2 ? 0 : (this.isLeap(year) ? 1 : 2));
    }

    private int maxDayForMonth(int month) {
        if (month != 2) {
            return (month >> 3 ^ month & 1) + 30;
        }
        return 29;
    }

    private int maxDayForYearMonth(int year, int month) {
        if (month != 2) {
            return (month >> 3 ^ month & 1) + 30;
        }
        if (this.isLeap(year)) {
            return 29;
        }
        return 28;
    }

    private boolean isLeap(int year) {
        int cc;
        long cp;
        return (year & 3) == 0 && ((((cp = (long)year * 1374389535L) ^ (long)(cc = year >> 31)) & 0x1FC0000000L) != 0L || ((int)(cp >> 37) - cc & 3) == 0);
    }

    private Nothing$ nanoError(int nanoDigitWeight, char ch, int pos) {
        if (nanoDigitWeight == 0) {
            throw this.charError(ch, pos);
        }
        return this.charOrDigitError(ch, pos);
    }

    private Nothing$ durationOrPeriodStartError(boolean isNeg, int pos) {
        return this.error(isNeg ? "expected 'P'" : "expected 'P' or '-'", pos);
    }

    private Nothing$ durationOrPeriodDigitError(boolean isNegX, boolean isNumReq, int pos) {
        return this.error(isNegX ? "expected digit" : (isNumReq ? "expected '-' or digit" : "expected '\"' or '-' or digit"), pos);
    }

    private Nothing$ durationError(int state, int pos) {
        String string;
        int n = state;
        switch (n) {
            case 0: {
                string = "expected 'D' or digit";
                break;
            }
            case 1: {
                string = "expected 'H' or 'M' or 'S or '.' or digit";
                break;
            }
            case 2: {
                string = "expected 'M' or 'S or '.' or digit";
                break;
            }
            case 3: {
                string = "expected 'S or '.' or digit";
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return this.error(string, pos);
    }

    private Nothing$ durationError(int pos) {
        return this.error("illegal duration", pos);
    }

    private Nothing$ timezoneSignError(int nanoDigitWeight, int pos) {
        return this.error(nanoDigitWeight == -2 ? "expected '.' or '+' or '-' or 'Z'" : (nanoDigitWeight == -1 ? "expected ':' or '+' or '-' or 'Z'" : (nanoDigitWeight == 0 ? "expected '+' or '-' or 'Z'" : "expected digit or '+' or '-' or 'Z'")), pos);
    }

    private Nothing$ instantError(int pos) {
        return this.error("illegal instant", pos);
    }

    private Nothing$ localDateError(int pos) {
        return this.error("illegal local date", pos);
    }

    private Nothing$ localDateTimeError(int pos) {
        return this.error("illegal local date time", pos);
    }

    private Nothing$ localTimeError(int pos) {
        return this.error("illegal local time", pos);
    }

    private Nothing$ offsetDateTimeError(int pos) {
        return this.error("illegal offset date time", pos);
    }

    private Nothing$ offsetTimeError(int pos) {
        return this.error("illegal offset time", pos);
    }

    private Nothing$ periodError(int state, int pos) {
        String string;
        int n = state;
        switch (n) {
            case 0: {
                string = "expected 'Y' or 'M' or 'W' or 'D' or digit";
                break;
            }
            case 1: {
                string = "expected 'M' or 'W' or 'D' or digit";
                break;
            }
            case 2: {
                string = "expected 'W' or 'D' or digit";
                break;
            }
            case 3: {
                string = "expected 'D' or digit";
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return this.error(string, pos);
    }

    private Nothing$ periodError(int pos) {
        return this.error("illegal period", pos);
    }

    private Nothing$ yearMonthError(int pos) {
        return this.error("illegal year month", pos);
    }

    private Nothing$ zonedDateTimeError(int pos) {
        return this.error("illegal zoned date time", pos);
    }

    private Nothing$ zoneOffsetError(int pos) {
        return this.error("illegal zone offset", pos);
    }

    private Nothing$ yearError(boolean yearNeg, int yearDigits, int pos) {
        if (!yearNeg && yearDigits == 4) {
            throw this.digitError(pos);
        }
        if (yearDigits == 9) {
            throw this.charError('-', pos);
        }
        return this.charOrDigitError('-', pos);
    }

    private Nothing$ yearError(int pos) {
        return this.error("illegal year", pos);
    }

    private Nothing$ monthError(int pos) {
        return this.error("illegal month", pos);
    }

    private Nothing$ dayError(int pos) {
        return this.error("illegal day", pos);
    }

    private Nothing$ hourError(int pos) {
        return this.error("illegal hour", pos);
    }

    private Nothing$ minuteError(int pos) {
        return this.error("illegal minute", pos);
    }

    private Nothing$ secondError(int pos) {
        return this.error("illegal second", pos);
    }

    private Nothing$ timezoneOffsetHourError(int pos) {
        return this.error("illegal timezone offset hour", pos);
    }

    private Nothing$ timezoneOffsetMinuteError(int pos) {
        return this.error("illegal timezone offset minute", pos);
    }

    private Nothing$ timezoneOffsetSecondError(int pos) {
        return this.error("illegal timezone offset second", pos);
    }

    private Nothing$ digitError(int pos) {
        return this.error("expected digit", pos);
    }

    private Nothing$ charsOrDigitError(char ch1, char ch2, int pos) {
        return this.error(new StringBuilder(26).append("expected '").append(ch1).append("' or '").append(ch2).append("' or digit").toString(), pos);
    }

    private Nothing$ charsError(char ch1, char ch2, int pos) {
        return this.error(new StringBuilder(17).append("expected '").append(ch1).append("' or '").append(ch2).append("'").toString(), pos);
    }

    private Nothing$ charOrDigitError(char ch1, int pos) {
        return this.error(new StringBuilder(20).append("expected '").append(ch1).append("' or digit").toString(), pos);
    }

    private Nothing$ charError(char ch, int pos) {
        return this.error(new StringBuilder(11).append("expected '").append(ch).append("'").toString(), pos);
    }

    private Nothing$ error(String msg, int pos) {
        throw new NoStackTrace(msg, pos, this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(new StringBuilder(10).append(msg$1).append(" at index ").append(pos$1).toString());
                NoStackTrace.$init$((NoStackTrace)this);
            }

            public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
                return super.fillInStackTrace();
            }
        };
    }
}

