/*
 * Decompiled with CFR 0.152.
 */
package zio.json.internal;

import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import zio.json.internal.StringMatrix$;

public final class StringMatrix {
    private final String[] xs;
    private final int width;
    private final int height;
    private final int[] lengths;
    private final long initial;
    private final int[] matrix;
    private final int[] resolve;

    public static Tuple2<String, Object>[] $lessinit$greater$default$2() {
        return StringMatrix$.MODULE$.$lessinit$greater$default$2();
    }

    public StringMatrix(String[] xs, Tuple2<String, Object>[] aliases) {
        int n;
        this.xs = xs;
        Object object = Predef$.MODULE$.refArrayOps((Object[])xs);
        Predef$.MODULE$.require(ArrayOps$.MODULE$.forall$extension(object, (Function1 & Serializable)_$1 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$1))));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])xs);
        Predef$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(object2));
        Predef$.MODULE$.require(xs.length + aliases.length < 64);
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])aliases);
        Predef$.MODULE$.require(ArrayOps$.MODULE$.forall$extension(object3, (Function1 & Serializable)_$2 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)_$2._1()))));
        Object object4 = Predef$.MODULE$.refArrayOps((Object[])aliases);
        Predef$.MODULE$.require(ArrayOps$.MODULE$.forall$extension(object4, (Function1 & Serializable)p -> BoxesRunTime.unboxToInt((Object)p._2()) >= 0 && BoxesRunTime.unboxToInt((Object)p._2()) < xs.length));
        this.width = xs.length + aliases.length;
        Object object5 = Predef$.MODULE$.refArrayOps((Object[])xs);
        int n2 = Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(object5, (Function1 & Serializable)_$3 -> _$3.length(), ClassTag$.MODULE$.apply(Integer.TYPE))).max((Ordering)Ordering.Int$.MODULE$)));
        Object object6 = Predef$.MODULE$.refArrayOps((Object[])aliases);
        if (ArrayOps$.MODULE$.isEmpty$extension(object6)) {
            n = 0;
        } else {
            Object object7 = Predef$.MODULE$.refArrayOps((Object[])aliases);
            n = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(object7, (Function1 & Serializable)_$4 -> ((String)_$4._1()).length(), ClassTag$.MODULE$.apply(Integer.TYPE))).max((Ordering)Ordering.Int$.MODULE$));
        }
        this.height = RichInt$.MODULE$.max$extension(n2, n);
        Object object8 = Predef$.MODULE$.refArrayOps((Object[])xs);
        Object object9 = Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.map$extension(object8, (Function1 & Serializable)_$5 -> _$5.length(), ClassTag$.MODULE$.apply(Integer.TYPE)));
        Object object10 = Predef$.MODULE$.refArrayOps((Object[])aliases);
        this.lengths = (int[])ArrayOps$.MODULE$.$plus$plus$extension(object9, ArrayOps$.MODULE$.map$extension(object10, (Function1 & Serializable)_$6 -> ((String)_$6._1()).length(), ClassTag$.MODULE$.apply(Integer.TYPE)), ClassTag$.MODULE$.apply(Integer.TYPE));
        this.initial = BoxesRunTime.unboxToLong((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.width()).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJI.sp & Serializable)(bs, r) -> bs | 1L << r));
        int[] m = (int[])Array$.MODULE$.fill(this.width() * this.height(), StringMatrix::$anonfun$1, ClassTag$.MODULE$.apply(Integer.TYPE));
        for (int string = 0; string < this.width(); ++string) {
            String s = string < xs.length ? xs[string] : (String)aliases[string - xs.length]._1();
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                m[this.width() * i + string] = s.codePointAt(i);
            }
        }
        this.matrix = m;
        int[] r2 = (int[])Array$.MODULE$.tabulate(xs.length + aliases.length, (Function1)(JFunction1.mcII.sp & Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x))), ClassTag$.MODULE$.apply(Integer.TYPE));
        Object object11 = Predef$.MODULE$.refArrayOps((Object[])aliases);
        Object object12 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object11));
        ArrayOps$.MODULE$.foreach$extension(object12, (Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                int pi = BoxesRunTime.unboxToInt((Object)tuple2._2());
                int i = BoxesRunTime.unboxToInt((Object)tuple22._2());
                r$1[xs$2.length + i] = pi;
                return;
            }
            throw new MatchError((Object)tuple22);
        });
        this.resolve = r2;
    }

    public String[] xs() {
        return this.xs;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int[] lengths() {
        return this.lengths;
    }

    public long initial() {
        return this.initial;
    }

    public long update(long bitset, int n, int c) {
        if (n >= this.height()) {
            return 0L;
        }
        if (bitset == 0L) {
            return 0L;
        }
        long latest = bitset;
        int base = this.width() * n;
        if (bitset == this.initial()) {
            for (int string = 0; string < this.width(); ++string) {
                if (this.matrix[base + string] == c) continue;
                latest ^= 1L << string;
            }
        } else {
            long bit;
            for (long remaining = bitset; remaining != 0L; remaining ^= bit) {
                int string = Long.numberOfTrailingZeros(remaining);
                bit = 1L << string;
                if (this.matrix[base + string] == c) continue;
                latest ^= bit;
            }
        }
        return latest;
    }

    public long exact(long bitset, int length) {
        long bit;
        if (length > this.height()) {
            return 0L;
        }
        long latest = bitset;
        for (long remaining = bitset; remaining != 0L; remaining ^= bit) {
            int string = Long.numberOfTrailingZeros(remaining);
            bit = 1L << string;
            if (this.lengths()[string] == length) continue;
            latest ^= bit;
        }
        return latest;
    }

    public int first(long bitset) {
        if (bitset == 0L) {
            return -1;
        }
        return this.resolve[Long.numberOfTrailingZeros(bitset)];
    }

    private static final int $anonfun$1() {
        return -1;
    }
}

