/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.Serializable;
import java.net.URI;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import zio.Chunk;
import zio.http.Path;
import zio.http.Path$;
import zio.http.Path$Flags$;
import zio.http.QueryParams;
import zio.http.Scheme;
import zio.http.Scheme$HTTP$;
import zio.http.URL;
import zio.http.URL$;
import zio.http.URL$Fragment$;
import zio.http.URL$Location$;
import zio.http.URL$Location$Absolute$;
import zio.http.URL$Location$Relative$;
import zio.http.URLPlatformSpecific;
import zio.http.internal.QueryOps;

public final class URL
implements URLPlatformSpecific,
QueryOps<URL>,
Product,
Serializable {
    private final Path path;
    private final Location kind;
    private final QueryParams queryParams;
    private final Option fragment;

    public static URL apply(Path path, Location location, QueryParams queryParams, Option<Fragment> option) {
        return URL$.MODULE$.apply(path, location, queryParams, option);
    }

    public static Either<Exception, URL> decode(String string) {
        return URL$.MODULE$.decode(string);
    }

    public static URL empty() {
        return URL$.MODULE$.empty();
    }

    public static Option<URL> fromAbsoluteURI(URI uRI) {
        return URL$.MODULE$.fromAbsoluteURI(uRI);
    }

    public static URL fromProduct(Product product) {
        return URL$.MODULE$.fromProduct(product);
    }

    public static Option<URL> fromRelativeURI(URI uRI) {
        return URL$.MODULE$.fromRelativeURI(uRI);
    }

    public static Option<URL> fromURI(URI uRI) {
        return URL$.MODULE$.fromURI(uRI);
    }

    public static URL root() {
        return URL$.MODULE$.root();
    }

    public static URL unapply(URL uRL) {
        return URL$.MODULE$.unapply(uRL);
    }

    public static Location $lessinit$greater$default$2() {
        return URL$.MODULE$.$lessinit$greater$default$2();
    }

    public static QueryParams $lessinit$greater$default$3() {
        return URL$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Fragment> $lessinit$greater$default$4() {
        return URL$.MODULE$.$lessinit$greater$default$4();
    }

    public URL(Path path, Location kind, QueryParams queryParams, Option<Fragment> fragment) {
        this.path = path;
        this.kind = kind;
        this.queryParams = queryParams;
        this.fragment = fragment;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof URL;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "URL";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "path";
            }
            case 1: {
                return "kind";
            }
            case 2: {
                return "queryParams";
            }
            case 3: {
                return "fragment";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Path path() {
        return this.path;
    }

    public Location kind() {
        return this.kind;
    }

    public QueryParams queryParams() {
        return this.queryParams;
    }

    public Option<Fragment> fragment() {
        return this.fragment;
    }

    public URL $plus$plus(URL that) {
        return URL$.MODULE$.apply(this.path().$plus$plus(that.path()), this.kind().$plus$plus(that.kind()), (QueryParams)this.queryParams().$plus$plus(that.queryParams()), (Option<Fragment>)that.fragment().orElse(this::$plus$plus$$anonfun$1));
    }

    public URL $div(String segment) {
        return this.copy(this.path().$div(segment), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public URL absolute(String host) {
        Location.Absolute absolute = URL$Location$Absolute$.MODULE$.apply(Scheme$HTTP$.MODULE$, host, (Option<Object>)None$.MODULE$);
        Path path = this.copy$default$1();
        QueryParams queryParams = this.copy$default$3();
        Option<Fragment> option = this.copy$default$4();
        return this.copy(path, absolute, queryParams, option);
    }

    public URL absolute(Scheme scheme, String host, int port) {
        Location.Absolute absolute = URL$Location$Absolute$.MODULE$.apply(scheme, host, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)port)));
        Path path = this.copy$default$1();
        QueryParams queryParams = this.copy$default$3();
        Option<Fragment> option = this.copy$default$4();
        return this.copy(path, absolute, queryParams, option);
    }

    public URL addLeadingSlash() {
        return this.copy(this.path().addLeadingSlash(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public URL addPath(Path path) {
        return this.copy(this.path().$plus$plus(path), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public URL addPath(String path) {
        return this.copy(this.path().$plus$plus(Path$.MODULE$.decode(path)), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public URL addTrailingSlash() {
        return this.copy(this.path().addTrailingSlash(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public URL addQueryParams(QueryParams queryParams) {
        QueryParams queryParams2 = (QueryParams)this.queryParams().$plus$plus(queryParams);
        Path path = this.copy$default$1();
        Location location = this.copy$default$2();
        Option<Fragment> option = this.copy$default$4();
        return this.copy(path, location, queryParams2, option);
    }

    public URL dropLeadingSlash() {
        return this.copy(this.path().dropLeadingSlash(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public URL dropTrailingSlash() {
        return this.copy(this.path().dropTrailingSlash(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public String encode() {
        return URL$.MODULE$.zio$http$URL$$$encode(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof URL)) return false;
        URL that2 = (URL)object;
        URL left = this.normalize();
        URL right = that2.normalize();
        Location location = left.kind();
        Location location2 = right.kind();
        if (location == null) {
            if (location2 != null) {
                return false;
            }
        } else if (!location.equals(location2)) return false;
        Path path = left.path();
        Path path2 = right.path();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!((Object)path).equals(path2)) return false;
        QueryParams queryParams = left.queryParams();
        QueryParams queryParams2 = right.queryParams();
        if (queryParams == null) {
            if (queryParams2 != null) {
                return false;
            }
        } else if (!((Object)queryParams).equals(queryParams2)) return false;
        Option<Fragment> option = left.fragment();
        Option<Fragment> option2 = right.fragment();
        if (option == null) {
            if (option2 == null) return true;
            return false;
        } else {
            if (!option.equals(option2)) return false;
            return true;
        }
    }

    public int hashCode() {
        URL normalized = this.normalize();
        int hash = 17;
        hash = hash * 31 + normalized.kind().hashCode();
        hash = hash * 31 + normalized.path().hashCode();
        hash = hash * 31 + normalized.queryParams().hashCode();
        hash = hash * 31 + normalized.fragment().hashCode();
        return hash;
    }

    public Option<String> host() {
        Location location = this.kind();
        if (URL$Location$Relative$.MODULE$.equals(location)) {
            return None$.MODULE$;
        }
        if (location instanceof Location.Absolute) {
            Location.Absolute abs = (Location.Absolute)location;
            return Option$.MODULE$.apply((Object)abs.host());
        }
        throw new MatchError((Object)location);
    }

    public URL host(String host) {
        Location.Absolute absolute;
        Location location = this.kind();
        if (URL$Location$Relative$.MODULE$.equals(location)) {
            absolute = URL$Location$Absolute$.MODULE$.apply(Scheme$HTTP$.MODULE$, host, (Option<Object>)None$.MODULE$);
        } else if (location instanceof Location.Absolute) {
            Location.Absolute abs = (Location.Absolute)location;
            absolute = abs.copy(abs.copy$default$1(), host, abs.copy$default$3());
        } else {
            throw new MatchError((Object)location);
        }
        Location.Absolute location2 = absolute;
        return this.copy(this.copy$default$1(), location2, this.copy$default$3(), this.copy$default$4());
    }

    public Option<String> hostPort() {
        Location location = this.kind();
        if (URL$Location$Relative$.MODULE$.equals(location)) {
            return None$.MODULE$;
        }
        if (location instanceof Location.Absolute) {
            Location.Absolute abs = (Location.Absolute)location;
            Option<Object> option = abs.portIfNotDefault();
            if (None$.MODULE$.equals(option)) {
                return Some$.MODULE$.apply((Object)abs.host());
            }
            if (option instanceof Some) {
                int customPort = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                return Some$.MODULE$.apply((Object)new StringBuilder(1).append(abs.host()).append(":").append(customPort).toString());
            }
            throw new MatchError(option);
        }
        throw new MatchError((Object)location);
    }

    public boolean isAbsolute() {
        Location location = this.kind();
        if (location instanceof Location.Absolute) {
            Location.Absolute absolute = URL$Location$Absolute$.MODULE$.unapply((Location.Absolute)location);
            Scheme scheme = absolute._1();
            String string = absolute._2();
            Option<Object> option = absolute._3();
            return true;
        }
        if (URL$Location$Relative$.MODULE$.equals(location)) {
            return false;
        }
        throw new MatchError((Object)location);
    }

    public boolean isRelative() {
        return !this.isAbsolute();
    }

    public URL normalize() {
        Path path = URL.normalizePath$1(this.path());
        QueryParams queryParams = this.queryParams().normalize();
        Location location = this.copy$default$2();
        Option<Fragment> option = this.copy$default$4();
        return this.copy(path, location, queryParams, option);
    }

    public URL path(Path path) {
        return this.copy(path, this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public URL path(String path) {
        return this.copy(Path$.MODULE$.decode(path), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public URL port(int port) {
        Location.Absolute absolute;
        Location location = this.kind();
        if (URL$Location$Relative$.MODULE$.equals(location)) {
            absolute = URL$Location$Absolute$.MODULE$.apply(Scheme$HTTP$.MODULE$, "", (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)port)));
        } else if (location instanceof Location.Absolute) {
            Location.Absolute abs = (Location.Absolute)location;
            Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)port));
            Scheme scheme = abs.copy$default$1();
            String string = abs.copy$default$2();
            absolute = abs.copy(scheme, string, (Option<Object>)some);
        } else {
            throw new MatchError((Object)location);
        }
        Location.Absolute location2 = absolute;
        return this.copy(this.copy$default$1(), location2, this.copy$default$3(), this.copy$default$4());
    }

    public Option<Object> port() {
        Location location = this.kind();
        if (URL$Location$Relative$.MODULE$.equals(location)) {
            return None$.MODULE$;
        }
        if (location instanceof Location.Absolute) {
            Location.Absolute abs = (Location.Absolute)location;
            return abs.originalPort();
        }
        throw new MatchError((Object)location);
    }

    public Option<Object> portOrDefault() {
        Location location = this.kind();
        if (URL$Location$Relative$.MODULE$.equals(location)) {
            return None$.MODULE$;
        }
        if (location instanceof Location.Absolute) {
            Location.Absolute abs = (Location.Absolute)location;
            return abs.portOrDefault();
        }
        throw new MatchError((Object)location);
    }

    public Option<Object> portIfNotDefault() {
        Location location = this.kind();
        if (URL$Location$Relative$.MODULE$.equals(location)) {
            return None$.MODULE$;
        }
        if (location instanceof Location.Absolute) {
            Location.Absolute abs = (Location.Absolute)location;
            return abs.portIfNotDefault();
        }
        throw new MatchError((Object)location);
    }

    @Override
    public QueryParams queryParameters() {
        return this.queryParams();
    }

    public URL relative() {
        Location location = this.kind();
        if (URL$Location$Relative$.MODULE$.equals(location)) {
            return this;
        }
        URL$Location$Relative$ uRL$Location$Relative$ = URL$Location$Relative$.MODULE$;
        Path path = this.copy$default$1();
        QueryParams queryParams = this.copy$default$3();
        Option<Fragment> option = this.copy$default$4();
        return this.copy(path, uRL$Location$Relative$, queryParams, option);
    }

    public Either<String, URL> resolve(URL reference) {
        if (reference.kind().isRelative()) {
            Location location = this.kind();
            if (URL$Location$Relative$.MODULE$.equals(location)) {
                return package$.MODULE$.Left().apply((Object)"cannot resolve against relative url");
            }
            if (location instanceof Location.Absolute) {
                Location.Absolute location2 = (Location.Absolute)location;
                Path path = null;
                QueryParams query = null;
                if (reference.path().isEmpty()) {
                    path = this.path();
                    query = reference.queryParams().isEmpty() ? this.queryParams() : reference.queryParams();
                } else {
                    query = reference.queryParams();
                    if (reference.path().hasLeadingSlash()) {
                        path = reference.path().removeDotSegments();
                    } else {
                        path = this.path().isEmpty() ? reference.path().addLeadingSlash() : Path$.MODULE$.apply(Path$Flags$.MODULE$.concat(this.path().flags(), reference.path().flags()), (Chunk<String>)this.path().segments().dropRight(1).$plus$plus(reference.path().segments()));
                        path = path.removeDotSegments();
                    }
                }
                URL url = URL$.MODULE$.apply(path, location2, query, reference.fragment());
                return package$.MODULE$.Right().apply((Object)url);
            }
            throw new MatchError((Object)location);
        }
        return package$.MODULE$.Right().apply((Object)reference.copy(reference.path().removeDotSegments(), reference.copy$default$2(), reference.copy$default$3(), reference.copy$default$4()));
    }

    public Option<Scheme> scheme() {
        Location location = this.kind();
        if (location instanceof Location.Absolute) {
            Location.Absolute absolute = URL$Location$Absolute$.MODULE$.unapply((Location.Absolute)location);
            Scheme scheme = absolute._1();
            String string = absolute._2();
            Option<Object> option = absolute._3();
            Scheme scheme2 = scheme;
            return Some$.MODULE$.apply((Object)scheme2);
        }
        if (URL$Location$Relative$.MODULE$.equals(location)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)location);
    }

    public URL scheme(Scheme scheme) {
        Location.Absolute absolute;
        Location location = this.kind();
        if (URL$Location$Relative$.MODULE$.equals(location)) {
            absolute = URL$Location$Absolute$.MODULE$.apply(scheme, "", (Option<Object>)None$.MODULE$);
        } else if (location instanceof Location.Absolute) {
            Location.Absolute abs = (Location.Absolute)location;
            absolute = abs.copy(scheme, abs.copy$default$2(), abs.copy$default$3());
        } else {
            throw new MatchError((Object)location);
        }
        Location.Absolute location2 = absolute;
        return this.copy(this.copy$default$1(), location2, this.copy$default$3(), this.copy$default$4());
    }

    public URI toJavaURI() {
        return new URI(this.encode());
    }

    @Override
    public URL updateQueryParams(Function1<QueryParams, QueryParams> f) {
        QueryParams queryParams = (QueryParams)f.apply((Object)this.queryParams());
        Path path = this.copy$default$1();
        Location location = this.copy$default$2();
        Option<Fragment> option = this.copy$default$4();
        return this.copy(path, location, queryParams, option);
    }

    public URL copy(Path path, Location kind, QueryParams queryParams, Option<Fragment> fragment) {
        return new URL(path, kind, queryParams, fragment);
    }

    public Path copy$default$1() {
        return this.path();
    }

    public Location copy$default$2() {
        return this.kind();
    }

    public QueryParams copy$default$3() {
        return this.queryParams();
    }

    public Option<Fragment> copy$default$4() {
        return this.fragment();
    }

    public Path _1() {
        return this.path();
    }

    public Location _2() {
        return this.kind();
    }

    public QueryParams _3() {
        return this.queryParams();
    }

    public Option<Fragment> _4() {
        return this.fragment();
    }

    private final Option $plus$plus$$anonfun$1() {
        return this.fragment();
    }

    private static final Path normalizePath$1(Path path) {
        if (path.isEmpty() || path.isRoot()) {
            return Path$.MODULE$.empty();
        }
        return path.addLeadingSlash();
    }

    public static final class Fragment
    implements Product,
    Serializable {
        private final String raw;
        private final String decoded;

        public static Fragment fromProduct(Product product) {
            return URL$Fragment$.MODULE$.fromProduct(product);
        }

        public static Option<Fragment> fromURI(URI uRI) {
            return URL$Fragment$.MODULE$.fromURI(uRI);
        }

        public static Fragment unapply(Fragment fragment) {
            return URL$Fragment$.MODULE$.unapply(fragment);
        }

        public Fragment(String raw, String decoded) {
            this.raw = raw;
            this.decoded = decoded;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Fragment)) return false;
            Fragment fragment = (Fragment)object;
            String string = this.raw();
            String string2 = fragment.raw();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.decoded();
            String string4 = fragment.decoded();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Fragment;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Fragment";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "raw";
            }
            if (1 == n2) {
                return "decoded";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String raw() {
            return this.raw;
        }

        public String decoded() {
            return this.decoded;
        }

        private Fragment copy(String raw, String decoded) {
            return new Fragment(raw, decoded);
        }

        private String copy$default$1() {
            return this.raw();
        }

        private String copy$default$2() {
            return this.decoded();
        }

        public String _1() {
            return this.raw();
        }

        public String _2() {
            return this.decoded();
        }
    }

    public static interface Location {
        public static int ordinal(Location location) {
            return URL$Location$.MODULE$.ordinal(location);
        }

        public static Location $plus$plus$(Location $this, Location that) {
            return $this.$plus$plus(that);
        }

        default public Location $plus$plus(Location that) {
            if (that.isRelative()) {
                return this;
            }
            return that;
        }

        public static boolean isAbsolute$(Location $this) {
            return $this.isAbsolute();
        }

        default public boolean isAbsolute() {
            return !this.isRelative();
        }

        public static boolean isRelative$(Location $this) {
            return $this.isRelative();
        }

        default public boolean isRelative() {
            Location location = this;
            return URL$Location$Relative$.MODULE$.equals(location);
        }
    }
}

