/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.Serializable;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import zio.http.Scheme$;
import zio.http.Scheme$Custom$;
import zio.http.Scheme$HTTP$;
import zio.http.Scheme$HTTPS$;
import zio.http.Scheme$WS$;
import zio.http.Scheme$WSS$;

public interface Scheme {
    public static Option<Scheme> decode(String string) {
        return Scheme$.MODULE$.decode(string);
    }

    public static int defaultPortForHTTP() {
        return Scheme$.MODULE$.defaultPortForHTTP();
    }

    public static int defaultPortForHTTPS() {
        return Scheme$.MODULE$.defaultPortForHTTPS();
    }

    public static int defaultPortForWS() {
        return Scheme$.MODULE$.defaultPortForWS();
    }

    public static int defaultPortForWSS() {
        return Scheme$.MODULE$.defaultPortForWSS();
    }

    public static String encode$(Scheme $this) {
        return $this.encode();
    }

    default public String encode() {
        Scheme scheme = this;
        if (Scheme$HTTP$.MODULE$.equals(scheme)) {
            return "http";
        }
        if (Scheme$HTTPS$.MODULE$.equals(scheme)) {
            return "https";
        }
        if (Scheme$WS$.MODULE$.equals(scheme)) {
            return "ws";
        }
        if (Scheme$WSS$.MODULE$.equals(scheme)) {
            return "wss";
        }
        if (scheme instanceof Custom) {
            String string;
            Custom custom = Scheme$Custom$.MODULE$.unapply((Custom)scheme);
            String scheme2 = string = custom._1();
            return scheme2;
        }
        throw new MatchError((Object)scheme);
    }

    public static boolean isHttp$(Scheme $this) {
        return $this.isHttp();
    }

    default public boolean isHttp() {
        Scheme scheme = this;
        return Scheme$HTTP$.MODULE$.equals(scheme) || Scheme$HTTPS$.MODULE$.equals(scheme);
        {
        }
    }

    public static boolean isWebSocket$(Scheme $this) {
        return $this.isWebSocket();
    }

    default public boolean isWebSocket() {
        Scheme scheme = this;
        if (Scheme$WS$.MODULE$.equals(scheme)) {
            return true;
        }
        return Scheme$WSS$.MODULE$.equals(scheme);
    }

    public static Option isSecure$(Scheme $this) {
        return $this.isSecure();
    }

    default public Option<Object> isSecure() {
        Scheme scheme = this;
        if (Scheme$HTTPS$.MODULE$.equals(scheme) || Scheme$WSS$.MODULE$.equals(scheme)) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        if (Scheme$HTTP$.MODULE$.equals(scheme) || Scheme$WS$.MODULE$.equals(scheme)) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return None$.MODULE$;
    }

    public static Option defaultPort$(Scheme $this) {
        return $this.defaultPort();
    }

    default public Option<Object> defaultPort() {
        Scheme scheme = this;
        if (Scheme$HTTP$.MODULE$.equals(scheme)) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Scheme$.MODULE$.defaultPortForHTTP()));
        }
        if (Scheme$HTTPS$.MODULE$.equals(scheme)) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Scheme$.MODULE$.defaultPortForHTTPS()));
        }
        if (Scheme$WS$.MODULE$.equals(scheme)) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Scheme$.MODULE$.defaultPortForWS()));
        }
        if (Scheme$WSS$.MODULE$.equals(scheme)) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Scheme$.MODULE$.defaultPortForWSS()));
        }
        if (scheme instanceof Custom) {
            Custom custom = Scheme$Custom$.MODULE$.unapply((Custom)scheme);
            String string = custom._1();
            return None$.MODULE$;
        }
        throw new MatchError((Object)scheme);
    }

    public static abstract class Custom
    implements Scheme,
    Product,
    Serializable {
        private final String scheme;

        public static Custom unapply(Custom custom) {
            return Scheme$Custom$.MODULE$.unapply(custom);
        }

        public Custom(String scheme) {
            this.scheme = scheme;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Custom)) return false;
            Custom custom = (Custom)object;
            String string = this.scheme();
            String string2 = custom.scheme();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!custom.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Custom;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Custom";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "scheme";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String scheme() {
            return this.scheme;
        }

        public String _1() {
            return this.scheme();
        }
    }
}

