/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import izumi.reflect.Tag;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Clock;
import zio.DurationSyntax$;
import zio.Fiber;
import zio.Ref;
import zio.ZEnvironment;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.http.Body;
import zio.http.Body$;
import zio.http.Channel;
import zio.http.ChannelEvent;
import zio.http.ChannelEvent$;
import zio.http.ClientSSLConfig;
import zio.http.Handler$;
import zio.http.Http;
import zio.http.Http$;
import zio.http.Path;
import zio.http.Path$;
import zio.http.QueryParams;
import zio.http.QueryParams$;
import zio.http.Request;
import zio.http.Request$;
import zio.http.Response;
import zio.http.Response$;
import zio.http.TestChannel;
import zio.http.TestChannel$;
import zio.http.TestClient$;
import zio.http.URL;
import zio.http.URL$;
import zio.http.ZClient;
import zio.http.model.Headers;
import zio.http.model.Headers$;
import zio.http.model.Method;
import zio.http.model.Scheme;
import zio.http.model.Status;
import zio.http.model.Version;
import zio.http.socket.SocketApp;
import zio.http.socket.WebSocketFrame;
import zio.package;
import zio.package$;

public final class TestClient
implements ZClient<Object, Body, Throwable, Response>,
Product,
Serializable {
    private final Ref behavior;
    private final Ref serverSocketBehavior;
    private final Headers headers;
    private final Option hostOption;
    private final Path pathPrefix;
    private final Option portOption;
    private final QueryParams queries;
    private final Option schemeOption;
    private final Option sslConfig;
    private final ZIO<Object, Nothing$, Nothing$> warnLongRunning;

    public static TestClient apply(Ref<Http<Object, Throwable, Request, Response>> ref, Ref<SocketApp<Object>> ref2) {
        return TestClient$.MODULE$.apply(ref, ref2);
    }

    public static TestClient fromProduct(Product product) {
        return TestClient$.MODULE$.fromProduct(product);
    }

    public static ZLayer<Object, Nothing$, TestClient> layer() {
        return TestClient$.MODULE$.layer();
    }

    public static TestClient unapply(TestClient testClient) {
        return TestClient$.MODULE$.unapply(testClient);
    }

    public TestClient(Ref<Http<Object, Throwable, Request, Response>> behavior, Ref<SocketApp<Object>> serverSocketBehavior) {
        this.behavior = behavior;
        this.serverSocketBehavior = serverSocketBehavior;
        this.headers = Headers$.MODULE$.empty();
        this.hostOption = None$.MODULE$;
        this.pathPrefix = Path$.MODULE$.empty();
        this.portOption = None$.MODULE$;
        this.queries = QueryParams$.MODULE$.empty();
        this.schemeOption = None$.MODULE$;
        this.sslConfig = None$.MODULE$;
        Tag tag0 = package$.MODULE$.EnvironmentTag().apply(Tag$.MODULE$.apply(Clock.ClockLive$.class, LightTypeTag$.MODULE$.parse(1344758313, "\u0004\u0000\u0000\u0014zio.Clock$.ClockLive\u0001\u0002\u0003\u0000\u0000\tzio.Clock\u0001\u0001", "\u0000\u0001\u0004\u0000\u0000\u0014zio.Clock$.ClockLive\u0001\u0002\u0003\u0000\u0000\tzio.Clock\u0001\u0001\u0002\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0001\u0000\u0000\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0005\u0000\u0001\tscala.Any\u0001\u0001\u0000\u0001\u0010java.lang.Object\u0001\u0001\u0000\u0001\u000fscala.Matchable\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001", 21)));
        this.warnLongRunning = ZIO$.MODULE$.log(TestClient::$init$$$anonfun$1, (Object)"zio.http.TestClient.warnLongRunning(TestClient.scala:130)").delay(TestClient::$init$$$anonfun$2, (Object)"zio.http.TestClient.warnLongRunning(TestClient.scala:131)").withClock(TestClient::$init$$$anonfun$3, (package.Tag)new package.Tag<Clock.ClockLive$>(tag0){
            private final Tag tag0$1;
            {
                this.tag0$1 = tag0$6;
            }

            public LightTypeTag tag() {
                return this.tag0$1.tag();
            }

            public Class closestClass() {
                return this.tag0$1.closestClass();
            }
        }, (Object)"zio.http.TestClient.warnLongRunning(TestClient.scala:132)").$times$greater(TestClient::$init$$$anonfun$4, (Object)"zio.http.TestClient.warnLongRunning(TestClient.scala:132)");
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TestClient)) return false;
        TestClient testClient = (TestClient)object;
        Ref<Http<Object, Throwable, Request, Response>> ref = this.behavior();
        Ref<Http<Object, Throwable, Request, Response>> ref2 = testClient.behavior();
        if (ref == null) {
            if (ref2 != null) {
                return false;
            }
        } else if (!ref.equals(ref2)) return false;
        Ref<SocketApp<Object>> ref3 = this.serverSocketBehavior();
        Ref<SocketApp<Object>> ref4 = testClient.serverSocketBehavior();
        if (ref3 == null) {
            if (ref4 == null) return true;
            return false;
        } else {
            if (!ref3.equals(ref4)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof TestClient;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "TestClient";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "behavior";
        }
        if (1 == n2) {
            return "serverSocketBehavior";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Ref<Http<Object, Throwable, Request, Response>> behavior() {
        return this.behavior;
    }

    public Ref<SocketApp<Object>> serverSocketBehavior() {
        return this.serverSocketBehavior;
    }

    public ZIO<Object, Nothing$, BoxedUnit> addRequestResponse(Request expectedRequest, Response response) {
        Serializable handler = new Serializable(expectedRequest, response){
            private final Request expectedRequest$1;
            private final Response response$1;
            {
                this.expectedRequest$1 = expectedRequest$2;
                this.response$1 = response$3;
            }

            public final boolean isDefinedAt(Request x) {
                Request request;
                Request realRequest = request = x;
                URL uRL = this.expectedRequest$1.url().relative();
                URL uRL2 = realRequest.url();
                if (!(uRL != null ? !uRL.equals(uRL2) : uRL2 != null)) {
                    Method method = this.expectedRequest$1.method();
                    Method method2 = realRequest.method();
                    if (!(method != null ? !method.equals(method2) : method2 != null) && this.expectedRequest$1.headers().toSet().forall(arg_0 -> TestClient.zio$http$TestClient$$anon$2$$_$isDefinedAt$$anonfun$1(realRequest, arg_0))) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Request x, Function1 function1) {
                Request request;
                Request realRequest = request = x;
                URL uRL = this.expectedRequest$1.url().relative();
                URL uRL2 = realRequest.url();
                if (!(uRL != null ? !uRL.equals(uRL2) : uRL2 != null)) {
                    Method method = this.expectedRequest$1.method();
                    Method method2 = realRequest.method();
                    if (!(method != null ? !method.equals(method2) : method2 != null) && this.expectedRequest$1.headers().toSet().forall(arg_0 -> TestClient.zio$http$TestClient$$anon$2$$_$applyOrElse$$anonfun$1(realRequest, arg_0))) {
                        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$1 -> this.response$1, (Object)"zio.http.TestClient.addRequestResponse.handler(TestClient.scala:44)");
                    }
                }
                return function1.apply((Object)x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{zio$http$TestClient$$anon$2$$_$isDefinedAt$$anonfun$1(zio.http.Request zio.http.model.Headers$Header ), zio$http$TestClient$$anon$2$$_$applyOrElse$$anonfun$1(zio.http.Request zio.http.model.Headers$Header ), applyOrElse$$anonfun$2(zio.Unsafe )}, serializedLambda);
            }
        };
        return this.addHandler((PartialFunction)handler);
    }

    public <R> ZIO<R, Nothing$, BoxedUnit> addHandler(PartialFunction<Request, ZIO<R, Throwable, Response>> handler) {
        return ZIO$.MODULE$.environment((Object)"zio.http.TestClient.addHandler(TestClient.scala:65)").flatMap((Function1 & Serializable)r -> this.behavior().get((Object)"zio.http.TestClient.addHandler(TestClient.scala:66)").map((Function1 & Serializable)previousBehavior -> {
            PartialFunction newBehavior = handler.andThen((Function1 & Serializable)_$1 -> _$1.provideEnvironment(() -> TestClient.$anonfun$1$$anonfun$1(r), (Object)"zio.http.TestClient.addHandler.newBehavior(TestClient.scala:67)"));
            BoxedUnit boxedUnit = Http$.MODULE$.collectZIO();
            Http app = Http.CollectZIO$.MODULE$.apply$extension(boxedUnit, newBehavior);
            return Tuple3$.MODULE$.apply(previousBehavior, (Object)newBehavior, (Object)app);
        }, (Object)"zio.http.TestClient.addHandler(TestClient.scala:68)").flatMap((Function1 & Serializable)x$12 -> {
            Tuple3 tuple3 = x$12;
            if (tuple3 != null) {
                Http http = (Http)tuple3._3();
                Http previousBehavior = (Http)tuple3._1();
                PartialFunction newBehavior = (PartialFunction)tuple3._2();
                if (http instanceof Http) {
                    Http app = http;
                    return this.behavior().set((Object)previousBehavior.defaultWith(app, (Object)"zio.http.TestClient.addHandler(TestClient.scala:69)"), (Object)"zio.http.TestClient.addHandler(TestClient.scala:69)").map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = x$1;
                    }, (Object)"zio.http.TestClient.addHandler(TestClient.scala:70)");
                }
            }
            throw new MatchError((Object)tuple3);
        }, (Object)"zio.http.TestClient.addHandler(TestClient.scala:70)"), (Object)"zio.http.TestClient.addHandler(TestClient.scala:70)");
    }

    public Headers headers() {
        return this.headers;
    }

    public Option<String> hostOption() {
        return this.hostOption;
    }

    public Path pathPrefix() {
        return this.pathPrefix;
    }

    public Option<Object> portOption() {
        return this.portOption;
    }

    public QueryParams queries() {
        return this.queries;
    }

    public Option<Scheme> schemeOption() {
        return this.schemeOption;
    }

    public Option<ClientSSLConfig> sslConfig() {
        return this.sslConfig;
    }

    public ZIO<Object, Throwable, Response> request(Body body, Headers headers, Option<String> hostOption, Method method, Path pathPrefix, Option<Object> portOption, QueryParams queries, Option<Scheme> schemeOption, Option<ClientSSLConfig> sslConfig, Version version, Object trace) {
        return this.behavior().get(trace).map((Function1 & Serializable)currentBehavior -> {
            Request request = Request$.MODULE$.apply(body, headers, method, URL$.MODULE$.apply(pathPrefix, (URL.Location)URL.Location$.Relative$.MODULE$, URL$.MODULE$.$lessinit$greater$default$3(), URL$.MODULE$.$lessinit$greater$default$4()), version, (Option)None$.MODULE$);
            return Tuple2$.MODULE$.apply(currentBehavior, (Object)request);
        }, trace).flatMap((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                Http currentBehavior = (Http)tuple2._1();
                Request request = (Request)tuple2._2();
                return currentBehavior.runZIO((Object)request, trace).catchAll((Function1 & Serializable)x$1 -> {
                    Option option = x$1;
                    if (option instanceof Some) {
                        Throwable value = (Throwable)((Some)option).value();
                        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$2 -> {
                            Status.BadRequest$ badRequest$ = Status.BadRequest$.MODULE$;
                            Body body = Body$.MODULE$.fromString(value.toString(), Body$.MODULE$.fromString$default$2());
                            Headers headers = Response$.MODULE$.apply$default$2();
                            return Response$.MODULE$.apply((Status)badRequest$, headers, body);
                        }, trace);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$3 -> Response$.MODULE$.status((Status)Status.NotFound$.MODULE$), trace);
                    }
                    throw new MatchError((Object)option);
                }, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace).map((Function1 & Serializable)response -> response, trace);
            }
            throw new MatchError((Object)tuple2);
        }, trace);
    }

    public <Env1> ZIO<Env1, Throwable, Response> socket(SocketApp<Env1> app, Headers headers, Option<String> hostOption, Path pathPrefix, Option<Object> portOption, QueryParams queries, Option<Scheme> schemeOption, Version version, Object trace) {
        return ZIO$.MODULE$.environment(trace).flatMap((Function1 & Serializable)env -> this.serverSocketBehavior().get(trace).flatMap((Function1 & Serializable)currentSocketBehavior -> TestChannel$.MODULE$.make().flatMap((Function1 & Serializable)testChannelClient -> TestChannel$.MODULE$.make().flatMap((Function1 & Serializable)testChannelServer -> this.eventLoop("Server", (TestChannel)testChannelClient, (SocketApp<Object>)currentSocketBehavior, (TestChannel)testChannelServer).forkDaemon(trace).flatMap((Function1 & Serializable)x$12 -> {
            Fiber.Runtime runtime = x$12;
            return this.eventLoop("Client", (TestChannel)testChannelServer, (SocketApp<Object>)app.provideEnvironment(env, trace), (TestChannel)testChannelClient).forkDaemon(trace).map((Function1 & Serializable)x$1 -> {
                Fiber.Runtime runtime = x$1;
                return Response$.MODULE$.status((Status)Status.SwitchingProtocols$.MODULE$);
            }, trace);
        }, trace), trace), trace), trace), trace);
    }

    private ZIO<Object, Throwable, ChannelEvent.Event<WebSocketFrame>> eventLoop(String name, TestChannel channel, SocketApp<Object> app, TestChannel otherChannel) {
        return channel.pending("zio.http.TestClient.eventLoop(TestClient.scala:136)").race(this::eventLoop$$anonfun$1, (Object)"zio.http.TestClient.eventLoop(TestClient.scala:136)").flatMap((Function1 & Serializable)pendEvent -> ((ZIO)((Function1)app.message().get()).apply((Object)ChannelEvent$.MODULE$.apply((Channel)otherChannel, pendEvent))).tapError((Function1 & Serializable)e -> ZIO$.MODULE$.debug(() -> TestClient.eventLoop$$anonfun$2$$anonfun$1$$anonfun$1(name, e), (Object)"zio.http.TestClient.eventLoop(TestClient.scala:139)").$times$greater(() -> TestClient.eventLoop$$anonfun$2$$anonfun$1$$anonfun$2(otherChannel), (Object)"zio.http.TestClient.eventLoop(TestClient.scala:139)"), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.http.TestClient.eventLoop(TestClient.scala:139)").flatMap((Function1 & Serializable)x$12 -> {
            Object object = x$12;
            return ZIO$.MODULE$.when(() -> TestClient.eventLoop$$anonfun$2$$anonfun$2$$anonfun$1(pendEvent), () -> TestClient.eventLoop$$anonfun$2$$anonfun$2$$anonfun$2(otherChannel), (Object)"zio.http.TestClient.eventLoop(TestClient.scala:142)").map((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                return pendEvent;
            }, (Object)"zio.http.TestClient.eventLoop(TestClient.scala:143)");
        }, (Object)"zio.http.TestClient.eventLoop(TestClient.scala:143)"), (Object)"zio.http.TestClient.eventLoop(TestClient.scala:143)").repeatWhile((Function1 & Serializable)event -> this.shouldContinue((ChannelEvent.Event<WebSocketFrame>)event), (Object)"zio.http.TestClient.eventLoop(TestClient.scala:143)");
    }

    private boolean shouldContinue(ChannelEvent.Event<WebSocketFrame> event) {
        ChannelEvent.Event<WebSocketFrame> event2 = event;
        if (event2 instanceof ChannelEvent.ExceptionCaught) {
            ChannelEvent.ExceptionCaught exceptionCaught = ChannelEvent.ExceptionCaught$.MODULE$.unapply((ChannelEvent.ExceptionCaught)event2);
            Throwable throwable = exceptionCaught._1();
            return false;
        }
        if (event2 instanceof ChannelEvent.ChannelRead) {
            ChannelEvent.ChannelRead channelRead = ChannelEvent.ChannelRead$.MODULE$.unapply((ChannelEvent.ChannelRead)event2);
            Object object = channelRead._1();
            WebSocketFrame message = (WebSocketFrame)object;
            WebSocketFrame webSocketFrame = message;
            if (webSocketFrame instanceof WebSocketFrame.Close) {
                WebSocketFrame.Close close = WebSocketFrame.Close$.MODULE$.unapply((WebSocketFrame.Close)webSocketFrame);
                int n = close._1();
                Option option = close._2();
                return false;
            }
            return true;
        }
        if (event2 instanceof ChannelEvent.UserEventTriggered) {
            ChannelEvent.UserEventTriggered userEventTriggered = ChannelEvent.UserEventTriggered$.MODULE$.unapply((ChannelEvent.UserEventTriggered)event2);
            ChannelEvent.UserEvent userEvent = userEventTriggered._1();
            ChannelEvent.UserEvent userEvent2 = userEvent;
            ChannelEvent.UserEvent userEvent3 = userEvent2;
            if (ChannelEvent.UserEvent$.HandshakeTimeout$.MODULE$.equals(userEvent3)) {
                return false;
            }
            if (ChannelEvent.UserEvent$.HandshakeComplete$.MODULE$.equals(userEvent3)) {
                return true;
            }
            throw new MatchError((Object)userEvent3);
        }
        if (ChannelEvent.ChannelRegistered$.MODULE$.equals(event2)) {
            return true;
        }
        if (ChannelEvent.ChannelUnregistered$.MODULE$.equals(event2)) {
            return false;
        }
        throw new MatchError(event2);
    }

    public <Env1> ZIO<Env1, Nothing$, BoxedUnit> installSocketApp(Http<Object, Throwable, ChannelEvent<WebSocketFrame, WebSocketFrame>, BoxedUnit> app) {
        return ZIO$.MODULE$.environment((Object)"zio.http.TestClient.installSocketApp(TestClient.scala:166)").flatMap((Function1 & Serializable)env -> this.serverSocketBehavior().set((Object)app.defaultWith(TestClient$.zio$http$TestClient$$$warnOnUnrecognizedEvent, (Object)"zio.http.TestClient.installSocketApp(TestClient.scala:169)").toHandler(Handler$.MODULE$.response(Response$.MODULE$.apply((Status)Status.NotFound$.MODULE$, Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3())), (Object)"zio.http.TestClient.installSocketApp(TestClient.scala:170)").toSocketApp((.less.colon.less)$less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl(), (Object)"zio.http.TestClient.installSocketApp(TestClient.scala:171)").provideEnvironment(env, (Object)"zio.http.TestClient.installSocketApp(TestClient.scala:172)"), (Object)"zio.http.TestClient.installSocketApp(TestClient.scala:173)").map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
        }, (Object)"zio.http.TestClient.installSocketApp(TestClient.scala:174)"), (Object)"zio.http.TestClient.installSocketApp(TestClient.scala:174)");
    }

    public TestClient copy(Ref<Http<Object, Throwable, Request, Response>> behavior, Ref<SocketApp<Object>> serverSocketBehavior) {
        return new TestClient(behavior, serverSocketBehavior);
    }

    public Ref<Http<Object, Throwable, Request, Response>> _1() {
        return this.behavior();
    }

    public Ref<SocketApp<Object>> _2() {
        return this.serverSocketBehavior();
    }

    private static final String $init$$$anonfun$1() {
        return "Socket Application is taking a long time to run. You might have logic that does not terminate.";
    }

    private static final Duration $init$$$anonfun$2() {
        return DurationSyntax$.MODULE$.seconds$extension(package$.MODULE$.durationInt(15));
    }

    private static final Clock.ClockLive$ $init$$$anonfun$3() {
        return Clock.ClockLive$.MODULE$;
    }

    private static final ZIO $init$$$anonfun$4() {
        return ZIO$.MODULE$.never((Object)"zio.http.TestClient.warnLongRunning(TestClient.scala:132)");
    }

    public static final /* synthetic */ boolean zio$http$TestClient$$anon$2$$_$isDefinedAt$$anonfun$1(Request realRequest$1, Headers.Header expectedHeader) {
        return realRequest$1.headers().toSet().contains((Object)expectedHeader);
    }

    public static final /* synthetic */ boolean zio$http$TestClient$$anon$2$$_$applyOrElse$$anonfun$1(Request realRequest$2, Headers.Header expectedHeader) {
        return realRequest$2.headers().toSet().contains((Object)expectedHeader);
    }

    private static final ZEnvironment $anonfun$1$$anonfun$1(ZEnvironment r$3) {
        return r$3;
    }

    private final ZIO eventLoop$$anonfun$1() {
        return this.warnLongRunning;
    }

    private static final Object eventLoop$$anonfun$2$$anonfun$1$$anonfun$1(String name$3, Throwable e$1) {
        return new StringBuilder(29).append("Unexpected WebSocket ").append(name$3).append(" error: ").append(e$1).toString();
    }

    private static final ZIO eventLoop$$anonfun$2$$anonfun$1$$anonfun$2(TestChannel otherChannel$3) {
        return otherChannel$3.close();
    }

    private static final boolean eventLoop$$anonfun$2$$anonfun$2$$anonfun$1(ChannelEvent.Event pendEvent$2) {
        ChannelEvent.Event event = pendEvent$2;
        ChannelEvent.ChannelUnregistered$ channelUnregistered$ = ChannelEvent.ChannelUnregistered$.MODULE$;
        return !(event != null ? !event.equals(channelUnregistered$) : channelUnregistered$ != null);
    }

    private static final ZIO eventLoop$$anonfun$2$$anonfun$2$$anonfun$2(TestChannel otherChannel$5) {
        return otherChannel$5.close();
    }
}

