/*
 * Decompiled with CFR 0.152.
 */
package zio.http.codec;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import zio.Chunk;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$;
import zio.http.Header;
import zio.http.Header$ContentType$;
import zio.http.MediaType;
import zio.http.MediaType$;
import zio.http.Request;
import zio.http.Response;
import zio.http.codec.BinaryCodecWithSchema;
import zio.http.codec.HttpCodec;
import zio.http.codec.HttpCodecError;
import zio.http.codec.HttpCodecType;
import zio.http.codec.HttpContentCodec$;
import zio.http.codec.HttpContentCodec$DefaultCodecError$;
import zio.http.internal.HeaderOps;
import zio.schema.Schema;
import zio.schema.codec.BinaryCodec;

public final class HttpContentCodec<A>
implements Product,
Serializable {
    private final ListMap choices;
    private Map<MediaType, Option<BinaryCodecWithSchema<A>>> lookupCache;
    private final MediaType defaultMediaType;
    private final BinaryCodec defaultCodec;
    private final Schema defaultSchema;
    private final BinaryCodecWithSchema defaultBinaryCodecWithSchema;

    public static <A> HttpContentCodec<A> apply(ListMap<MediaType, BinaryCodecWithSchema<A>> listMap) {
        return HttpContentCodec$.MODULE$.apply(listMap);
    }

    public static HttpContentCodec<Chunk<Object>> byteChunkCodec() {
        return HttpContentCodec$.MODULE$.byteChunkCodec();
    }

    public static HttpContentCodec<Object> byteCodec() {
        return HttpContentCodec$.MODULE$.byteCodec();
    }

    public static <A> HttpContentCodec<A> from(Tuple2<MediaType, BinaryCodecWithSchema<A>> tuple2, Seq<Tuple2<MediaType, BinaryCodecWithSchema<A>>> seq) {
        return HttpContentCodec$.MODULE$.from(tuple2, seq);
    }

    public static HttpContentCodec<?> fromProduct(Product product) {
        return HttpContentCodec$.MODULE$.fromProduct(product);
    }

    public static <A> HttpContentCodec<A> fromSchema(Schema<A> schema) {
        return HttpContentCodec$.MODULE$.fromSchema(schema);
    }

    public static HttpCodec<HttpCodecType, HttpCodecError> responseErrorCodec() {
        return HttpContentCodec$.MODULE$.responseErrorCodec();
    }

    public static <A> HttpContentCodec<A> unapply(HttpContentCodec<A> httpContentCodec) {
        return HttpContentCodec$.MODULE$.unapply(httpContentCodec);
    }

    public HttpContentCodec(ListMap<MediaType, BinaryCodecWithSchema<A>> choices) {
        this.choices = choices;
        this.lookupCache = Predef$.MODULE$.Map().empty();
        this.defaultMediaType = (MediaType)choices.headOption().map((Function1 & Serializable)_$1 -> (MediaType)_$1._1()).getOrElse(HttpContentCodec::$init$$$anonfun$2);
        this.defaultCodec = (BinaryCodec)choices.headOption().map((Function1 & Serializable)_$2 -> ((BinaryCodecWithSchema)_$2._2()).codec()).getOrElse(HttpContentCodec::$init$$$anonfun$4);
        this.defaultSchema = (Schema)choices.headOption().map((Function1 & Serializable)_$3 -> ((BinaryCodecWithSchema)_$3._2()).schema()).getOrElse(HttpContentCodec::$init$$$anonfun$6);
        this.defaultBinaryCodecWithSchema = (BinaryCodecWithSchema)choices.headOption().map((Function1 & Serializable)_$4 -> (BinaryCodecWithSchema)_$4._2()).getOrElse(HttpContentCodec::$init$$$anonfun$8);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof HttpContentCodec)) return false;
        HttpContentCodec httpContentCodec = (HttpContentCodec)object;
        ListMap<MediaType, BinaryCodecWithSchema<A>> listMap = this.choices();
        ListMap<MediaType, BinaryCodecWithSchema<A>> listMap2 = httpContentCodec.choices();
        if (listMap != null) {
            if (!listMap.equals(listMap2)) return false;
            return true;
        }
        if (listMap2 == null) return true;
        return false;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof HttpContentCodec;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "HttpContentCodec";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "choices";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public ListMap<MediaType, BinaryCodecWithSchema<A>> choices() {
        return this.choices;
    }

    public HttpContentCodec<A> $plus$plus(HttpContentCodec<A> that) {
        return HttpContentCodec$.MODULE$.apply((ListMap)this.choices().$plus$plus(that.choices()));
    }

    public ZIO<Object, Throwable, A> decodeRequest(Request request) {
        MediaType contentType = this.mediaTypeFromContentTypeHeader(request);
        Option<BinaryCodecWithSchema<A>> option = this.lookup(contentType);
        if (option instanceof Some) {
            BinaryCodecWithSchema codec = (BinaryCodecWithSchema)((Some)option).value();
            return request.body().asChunk("zio.http.codec.HttpContentCodec.decodeRequest(HttpContentCodec.scala:34)").flatMap((Function1 & Serializable)bytes -> ZIO$.MODULE$.fromEither(() -> HttpContentCodec.decodeRequest$$anonfun$1$$anonfun$1(codec, bytes), (Object)"zio.http.codec.HttpContentCodec.decodeRequest(HttpContentCodec.scala:35)"), (Object)"zio.http.codec.HttpContentCodec.decodeRequest(HttpContentCodec.scala:36)");
        }
        if (None$.MODULE$.equals(option)) {
            return ZIO$.MODULE$.fail(() -> HttpContentCodec.decodeRequest$$anonfun$2(contentType), (Object)"zio.http.codec.HttpContentCodec.decodeRequest(HttpContentCodec.scala:38)");
        }
        throw new MatchError(option);
    }

    public ZIO<Object, Throwable, A> decodeResponse(Response response) {
        MediaType contentType = this.mediaTypeFromContentTypeHeader(response);
        Option<BinaryCodecWithSchema<A>> option = this.lookup(contentType);
        if (option instanceof Some) {
            BinaryCodecWithSchema codec = (BinaryCodecWithSchema)((Some)option).value();
            return response.body().asChunk("zio.http.codec.HttpContentCodec.decodeResponse(HttpContentCodec.scala:46)").flatMap((Function1 & Serializable)bytes -> ZIO$.MODULE$.fromEither(() -> HttpContentCodec.decodeResponse$$anonfun$1$$anonfun$1(codec, bytes), (Object)"zio.http.codec.HttpContentCodec.decodeResponse(HttpContentCodec.scala:47)"), (Object)"zio.http.codec.HttpContentCodec.decodeResponse(HttpContentCodec.scala:48)");
        }
        if (None$.MODULE$.equals(option)) {
            return ZIO$.MODULE$.fail(() -> HttpContentCodec.decodeResponse$$anonfun$2(contentType), (Object)"zio.http.codec.HttpContentCodec.decodeResponse(HttpContentCodec.scala:50)");
        }
        throw new MatchError(option);
    }

    private MediaType mediaTypeFromContentTypeHeader(HeaderOps<?> header) {
        if (header.headers().contains(Header$ContentType$.MODULE$.name())) {
            String contentType = header.headers().getUnsafe(Header$ContentType$.MODULE$.name());
            if (MediaType$.MODULE$.contentTypeMap().contains((Object)contentType)) {
                return (MediaType)MediaType$.MODULE$.contentTypeMap().apply((Object)contentType);
            }
            return MediaType$.MODULE$.unsafeParseCustomMediaType(contentType);
        }
        return MediaType$.MODULE$.application().json();
    }

    public Either<String, Body> encode(A value) {
        if (this.choices().isEmpty()) {
            return package$.MODULE$.Left().apply((Object)"No codec defined");
        }
        return package$.MODULE$.Right().apply((Object)Body$.MODULE$.fromChunk((Chunk<Object>)((Chunk)((BinaryCodecWithSchema)((Tuple2)this.choices().head())._2()).codec().encode(value)), (MediaType)((Tuple2)this.choices().head())._1()));
    }

    public HttpContentCodec<A> only(MediaType mediaType) {
        Object[] objectArray = new Tuple2[1];
        MediaType mediaType2 = (MediaType)Predef$.MODULE$.ArrowAssoc((Object)mediaType);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)mediaType2, this.lookup(mediaType).getOrElse(() -> this.only$$anonfun$1(mediaType)));
        return HttpContentCodec$.MODULE$.apply((ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
    }

    public HttpContentCodec<A> only(Option<MediaType> mediaType) {
        Option<MediaType> option = mediaType;
        if (option instanceof Some) {
            MediaType mediaType2 = (MediaType)((Some)option).value();
            Object[] objectArray = new Tuple2[1];
            MediaType mediaType3 = (MediaType)Predef$.MODULE$.ArrowAssoc((Object)mediaType2);
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)mediaType3, this.lookup(mediaType2).getOrElse(() -> this.only$$anonfun$2(mediaType2)));
            return HttpContentCodec$.MODULE$.apply((ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        }
        if (None$.MODULE$.equals(option)) {
            return this;
        }
        throw new MatchError(option);
    }

    public Tuple2<MediaType, BinaryCodecWithSchema<A>> chooseFirst(Chunk<Header.Accept.MediaTypeWithQFactor> mediaTypes) {
        if (mediaTypes.isEmpty()) {
            return Tuple2$.MODULE$.apply((Object)this.defaultMediaType(), this.defaultBinaryCodecWithSchema());
        }
        Tuple2 result = null;
        for (int i = 0; i < mediaTypes.size() && result == null; ++i) {
            Header.Accept.MediaTypeWithQFactor mediaType = (Header.Accept.MediaTypeWithQFactor)mediaTypes.apply(i);
            Option<BinaryCodecWithSchema<A>> lookupResult = this.lookup(mediaType.mediaType());
            if (!lookupResult.isDefined()) continue;
            result = Tuple2$.MODULE$.apply((Object)mediaType.mediaType(), lookupResult.get());
        }
        if (result == null) {
            throw new IllegalArgumentException(new StringBuilder(42).append("None of the media types ").append(mediaTypes).append(" are supported by ").append(this).toString());
        }
        return result;
    }

    public Tuple2<MediaType, BinaryCodecWithSchema<A>> chooseFirstOrDefault(Chunk<Header.Accept.MediaTypeWithQFactor> mediaTypes) {
        if (mediaTypes.isEmpty()) {
            return Tuple2$.MODULE$.apply((Object)this.defaultMediaType(), this.defaultBinaryCodecWithSchema());
        }
        Tuple2 result = null;
        for (int i = 0; i < mediaTypes.size() && result == null; ++i) {
            Header.Accept.MediaTypeWithQFactor mediaType = (Header.Accept.MediaTypeWithQFactor)mediaTypes.apply(i);
            Option<BinaryCodecWithSchema<A>> lookupResult = this.lookup(mediaType.mediaType());
            if (!lookupResult.isDefined()) continue;
            result = Tuple2$.MODULE$.apply((Object)mediaType.mediaType(), lookupResult.get());
        }
        if (result == null) {
            return Tuple2$.MODULE$.apply((Object)this.defaultMediaType(), this.defaultBinaryCodecWithSchema());
        }
        return result;
    }

    public Option<BinaryCodecWithSchema<A>> lookup(MediaType mediaType) {
        if (this.lookupCache.contains((Object)mediaType)) {
            return (Option)this.lookupCache.apply((Object)mediaType);
        }
        Option codec = this.choices().collectFirst((PartialFunction)new Serializable(mediaType){
            private final MediaType mediaType$3;
            {
                this.mediaType$3 = mediaType$4;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    MediaType mt = (MediaType)tuple2._1();
                    BinaryCodecWithSchema codec = (BinaryCodecWithSchema)tuple2._2();
                    if (mt.matches(this.mediaType$3, mt.matches$default$2())) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    MediaType mt = (MediaType)tuple2._1();
                    BinaryCodecWithSchema codec = (BinaryCodecWithSchema)tuple2._2();
                    if (mt.matches(this.mediaType$3, mt.matches$default$2())) {
                        return codec;
                    }
                }
                return function1.apply((Object)x);
            }
        });
        MediaType mediaType2 = (MediaType)Predef$.MODULE$.ArrowAssoc((Object)mediaType);
        this.lookupCache = (Map)this.lookupCache.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)mediaType2, (Object)codec));
        return codec;
    }

    public MediaType defaultMediaType() {
        return this.defaultMediaType;
    }

    public BinaryCodec<A> defaultCodec() {
        return this.defaultCodec;
    }

    public Schema<A> defaultSchema() {
        return this.defaultSchema;
    }

    public BinaryCodecWithSchema<A> defaultBinaryCodecWithSchema() {
        return this.defaultBinaryCodecWithSchema;
    }

    public <A> HttpContentCodec<A> copy(ListMap<MediaType, BinaryCodecWithSchema<A>> choices) {
        return new HttpContentCodec<A>(choices);
    }

    public <A> ListMap<MediaType, BinaryCodecWithSchema<A>> copy$default$1() {
        return this.choices();
    }

    public ListMap<MediaType, BinaryCodecWithSchema<A>> _1() {
        return this.choices();
    }

    private static final MediaType $init$$$anonfun$2() {
        throw new IllegalArgumentException("No codec defined");
    }

    private static final BinaryCodec $init$$$anonfun$4() {
        throw new IllegalArgumentException("No codec defined");
    }

    private static final Schema $init$$$anonfun$6() {
        throw new IllegalArgumentException("No codec defined");
    }

    private static final BinaryCodecWithSchema $init$$$anonfun$8() {
        throw new IllegalArgumentException("No codec defined");
    }

    private static final Either decodeRequest$$anonfun$1$$anonfun$1(BinaryCodecWithSchema codec$2, Chunk bytes$1) {
        return codec$2.codec().decode((Object)bytes$1);
    }

    private static final Nothing$ decodeRequest$$anonfun$2(MediaType contentType$1) {
        throw new IllegalArgumentException(new StringBuilder(32).append("No codec found for content type ").append(contentType$1).toString());
    }

    private static final Either decodeResponse$$anonfun$1$$anonfun$1(BinaryCodecWithSchema codec$4, Chunk bytes$2) {
        return codec$4.codec().decode((Object)bytes$2);
    }

    private static final Nothing$ decodeResponse$$anonfun$2(MediaType contentType$2) {
        throw new IllegalArgumentException(new StringBuilder(32).append("No codec found for content type ").append(contentType$2).toString());
    }

    private final BinaryCodecWithSchema only$$anonfun$1(MediaType mediaType$1) {
        throw new IllegalArgumentException(new StringBuilder(31).append("MediaType ").append(mediaType$1).append(" is not supported by ").append(this).toString());
    }

    private final BinaryCodecWithSchema only$$anonfun$2(MediaType mediaType$2) {
        throw new IllegalArgumentException(new StringBuilder(31).append("MediaType ").append(mediaType$2).append(" is not supported by ").append(this).toString());
    }

    public static final class DefaultCodecError
    implements Product,
    Serializable {
        private final String name;
        private final String message;

        public static DefaultCodecError apply(String string, String string2) {
            return HttpContentCodec$DefaultCodecError$.MODULE$.apply(string, string2);
        }

        public static DefaultCodecError fromProduct(Product product) {
            return HttpContentCodec$DefaultCodecError$.MODULE$.fromProduct(product);
        }

        public static Schema<DefaultCodecError> schema() {
            return HttpContentCodec$DefaultCodecError$.MODULE$.schema();
        }

        public static DefaultCodecError unapply(DefaultCodecError defaultCodecError) {
            return HttpContentCodec$DefaultCodecError$.MODULE$.unapply(defaultCodecError);
        }

        public DefaultCodecError(String name, String message) {
            this.name = name;
            this.message = message;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DefaultCodecError)) return false;
            DefaultCodecError defaultCodecError = (DefaultCodecError)object;
            String string = this.name();
            String string2 = defaultCodecError.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.message();
            String string4 = defaultCodecError.message();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DefaultCodecError;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "DefaultCodecError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "name";
            }
            if (1 == n2) {
                return "message";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public String message() {
            return this.message;
        }

        public DefaultCodecError copy(String name, String message) {
            return new DefaultCodecError(name, message);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.message();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.message();
        }
    }
}

