/*
 * Decompiled with CFR 0.152.
 */
package zio.http.codec;

import java.io.Serializable;
import java.net.URI;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import zio.Chunk;
import zio.Chunk$;
import zio.http.codec.Doc$;
import zio.http.codec.Doc$DescriptionList$;
import zio.http.codec.Doc$Empty$;
import zio.http.codec.Doc$Header$;
import zio.http.codec.Doc$Listing$;
import zio.http.codec.Doc$ListingType$;
import zio.http.codec.Doc$ListingType$Ordered$;
import zio.http.codec.Doc$ListingType$Unordered$;
import zio.http.codec.Doc$Paragraph$;
import zio.http.codec.Doc$Raw$;
import zio.http.codec.Doc$RawDocType$;
import zio.http.codec.Doc$RawDocType$CommonMark$;
import zio.http.codec.Doc$RawDocType$Html$;
import zio.http.codec.Doc$RawDocType$Plain$;
import zio.http.codec.Doc$Sequence$;
import zio.http.codec.Doc$Span$;
import zio.http.codec.Doc$Span$Bold$;
import zio.http.codec.Doc$Span$Code$;
import zio.http.codec.Doc$Span$CodeStyle$;
import zio.http.codec.Doc$Span$CodeStyle$Block$;
import zio.http.codec.Doc$Span$CodeStyle$Inline$;
import zio.http.codec.Doc$Span$Error$;
import zio.http.codec.Doc$Span$Italic$;
import zio.http.codec.Doc$Span$Link$;
import zio.http.codec.Doc$Span$Sequence$;
import zio.http.codec.Doc$Span$Text$;
import zio.http.codec.DocWriter;
import zio.http.codec.DocWriter$;
import zio.http.template.Dom;
import zio.http.template.Html;
import zio.http.template.Html$;
import zio.http.template.Html$Empty$;
import zio.http.template.IsAttributeValue$;
import zio.schema.Schema;

public interface Doc {
    public static Doc blocks(Doc doc, Seq<Doc> seq) {
        return Doc$.MODULE$.blocks(doc, seq);
    }

    public static Doc blocks(Iterable<Doc> iterable) {
        return Doc$.MODULE$.blocks(iterable);
    }

    public static Doc descriptionList(Seq<Tuple2<Span, Doc>> seq) {
        return Doc$.MODULE$.descriptionList(seq);
    }

    public static Doc empty() {
        return Doc$.MODULE$.empty();
    }

    public static Doc fromCommonMark(String string) {
        return Doc$.MODULE$.fromCommonMark(string);
    }

    public static Doc h1(String string) {
        return Doc$.MODULE$.h1(string);
    }

    public static Doc h2(String string) {
        return Doc$.MODULE$.h2(string);
    }

    public static Doc h3(String string) {
        return Doc$.MODULE$.h3(string);
    }

    public static Doc h4(String string) {
        return Doc$.MODULE$.h4(string);
    }

    public static Doc h5(String string) {
        return Doc$.MODULE$.h5(string);
    }

    public static Doc h6(String string) {
        return Doc$.MODULE$.h6(string);
    }

    public static Doc orderedListing(Seq<Doc> seq) {
        return Doc$.MODULE$.orderedListing(seq);
    }

    public static int ordinal(Doc doc) {
        return Doc$.MODULE$.ordinal(doc);
    }

    public static Doc p(Span span) {
        return Doc$.MODULE$.p(span);
    }

    public static Doc p(String string) {
        return Doc$.MODULE$.p(string);
    }

    public static Schema<Doc> schemaDocSchema() {
        return Doc$.MODULE$.schemaDocSchema();
    }

    public static Doc unorderedListing(Seq<Doc> seq) {
        return Doc$.MODULE$.unorderedListing(seq);
    }

    public static Doc $plus$(Doc $this, Doc that) {
        return $this.$plus(that);
    }

    default public Doc $plus(Doc that) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)this, (Object)that);
        if (tuple2 != null) {
            Doc doc = (Doc)tuple2._1();
            Doc doc2 = (Doc)tuple2._2();
            Doc self = doc;
            Doc that2 = doc2;
            if (self.isEmpty()) {
                return that2;
            }
            Doc self2 = doc;
            Doc that3 = doc2;
            if (that3.isEmpty()) {
                return self2;
            }
        }
        return Doc$Sequence$.MODULE$.apply(this, that);
    }

    public static boolean isEmpty$(Doc $this) {
        return $this.isEmpty();
    }

    default public boolean isEmpty() {
        Doc doc = this;
        if (Doc$Empty$.MODULE$.equals(doc)) {
            return true;
        }
        if (doc instanceof DescriptionList) {
            List<Tuple2<Span, Doc>> list;
            DescriptionList descriptionList = Doc$DescriptionList$.MODULE$.unapply((DescriptionList)doc);
            List<Tuple2<Span, Doc>> xs = list = descriptionList._1();
            return xs.forall((Function1 & Serializable)_$1 -> ((Doc)_$1._2()).isEmpty());
        }
        if (doc instanceof Sequence) {
            Sequence sequence = Doc$Sequence$.MODULE$.unapply((Sequence)doc);
            Doc doc2 = sequence._1();
            Doc doc3 = sequence._2();
            Doc left = doc2;
            Doc right = doc3;
            return left.isEmpty() && right.isEmpty();
        }
        if (doc instanceof Listing) {
            Listing listing = Doc$Listing$.MODULE$.unapply((Listing)doc);
            List<Doc> list = listing._1();
            ListingType listingType = listing._2();
            List<Doc> xs = list;
            return xs.forall((Function1 & Serializable)_$2 -> _$2.isEmpty());
        }
        if (doc instanceof Raw) {
            Raw raw = Doc$Raw$.MODULE$.unapply((Raw)doc);
            String string = raw._1();
            RawDocType rawDocType = raw._2();
            String value = string;
            return value.isEmpty();
        }
        return false;
    }

    public static Chunk flattened$(Doc $this) {
        return $this.flattened();
    }

    default public Chunk<Doc> flattened() {
        Doc doc = this;
        if (Doc$Empty$.MODULE$.equals(doc)) {
            return Chunk$.MODULE$.empty();
        }
        if (doc instanceof Sequence) {
            Sequence sequence = Doc$Sequence$.MODULE$.unapply((Sequence)doc);
            Doc doc2 = sequence._1();
            Doc doc3 = sequence._2();
            Doc left = doc2;
            Doc right = doc3;
            return left.flattened().$plus$plus(right.flattened());
        }
        Doc x = doc;
        return Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Doc[]{x}));
    }

    public static String toCommonMark$(Doc $this) {
        return $this.toCommonMark();
    }

    default public String toCommonMark() {
        StringBuilder writer = new StringBuilder();
        Doc.render$2(writer, this, Doc.render$default$2$1());
        return writer.toString();
    }

    public static Html toHtml$(Doc $this) {
        return $this.toHtml();
    }

    default public Html toHtml() {
        Doc doc2 = this;
        if (Doc$Empty$.MODULE$.equals(doc2)) {
            return Html$Empty$.MODULE$;
        }
        if (doc2 instanceof Header) {
            int level;
            Header header = Doc$Header$.MODULE$.unapply((Header)doc2);
            String string = header._1();
            int n = header._2();
            String value = string;
            int n2 = level = n;
            switch (n2) {
                case 1: {
                    return Html$.MODULE$.fromDomElement(zio.http.template.package$.MODULE$.h1().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{Html$.MODULE$.fromString(value)})));
                }
                case 2: {
                    return Html$.MODULE$.fromDomElement(zio.http.template.package$.MODULE$.h2().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{Html$.MODULE$.fromString(value)})));
                }
                case 3: {
                    return Html$.MODULE$.fromDomElement(zio.http.template.package$.MODULE$.h3().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{Html$.MODULE$.fromString(value)})));
                }
                case 4: {
                    return Html$.MODULE$.fromDomElement(zio.http.template.package$.MODULE$.h4().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{Html$.MODULE$.fromString(value)})));
                }
                case 5: {
                    return Html$.MODULE$.fromDomElement(zio.http.template.package$.MODULE$.h5().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{Html$.MODULE$.fromString(value)})));
                }
                case 6: {
                    return Html$.MODULE$.fromDomElement(zio.http.template.package$.MODULE$.h6().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{Html$.MODULE$.fromString(value)})));
                }
            }
            throw new IllegalArgumentException(new java.lang.StringBuilder(22).append("Invalid header level: ").append(level).toString());
        }
        if (doc2 instanceof Paragraph) {
            Span span;
            Paragraph paragraph = Doc$Paragraph$.MODULE$.unapply((Paragraph)doc2);
            Span value = span = paragraph._1();
            return Html$.MODULE$.fromDomElement(zio.http.template.package$.MODULE$.p().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{value.toHtml()})));
        }
        if (doc2 instanceof DescriptionList) {
            List<Tuple2<Span, Doc>> list;
            DescriptionList descriptionList = Doc$DescriptionList$.MODULE$.unapply((DescriptionList)doc2);
            List<Tuple2<Span, Doc>> definitions = list = descriptionList._1();
            return Html$.MODULE$.fromDomElement(zio.http.template.package$.MODULE$.dl().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{Html$.MODULE$.fromSeq((Seq<Dom>)definitions.flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Span span = (Span)tuple2._1();
                    Doc helpDoc = (Doc)tuple2._2();
                    return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Dom[]{zio.http.template.package$.MODULE$.dt().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{span.toHtml()})), zio.http.template.package$.MODULE$.dd().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{helpDoc.toHtml()}))}));
                }
                throw new MatchError((Object)tuple2);
            }))})));
        }
        if (doc2 instanceof Sequence) {
            Sequence sequence = Doc$Sequence$.MODULE$.unapply((Sequence)doc2);
            Doc doc3 = sequence._1();
            Doc doc4 = sequence._2();
            Doc left = doc3;
            Doc right = doc4;
            return left.toHtml().$plus$plus(right.toHtml());
        }
        if (doc2 instanceof Listing) {
            Listing listing = Doc$Listing$.MODULE$.unapply((Listing)doc2);
            List<Doc> list = listing._1();
            ListingType listingType = listing._2();
            List<Doc> elements = list;
            ListingType listingType2 = listingType;
            List elementsHtml = elements.map((Function1 & Serializable)doc -> zio.http.template.package$.MODULE$.li().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{doc.toHtml()})));
            ListingType listingType3 = listingType2;
            if (Doc$ListingType$Unordered$.MODULE$.equals(listingType3)) {
                return Html$.MODULE$.fromDomElement(zio.http.template.package$.MODULE$.ul().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{Html$.MODULE$.fromSeq((Seq<Dom>)elementsHtml)})));
            }
            if (Doc$ListingType$Ordered$.MODULE$.equals(listingType3)) {
                return Html$.MODULE$.fromDomElement(zio.http.template.package$.MODULE$.ol().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{Html$.MODULE$.fromSeq((Seq<Dom>)elementsHtml)})));
            }
            throw new MatchError((Object)listingType3);
        }
        if (doc2 instanceof Raw) {
            Raw raw = Doc$Raw$.MODULE$.unapply((Raw)doc2);
            String string = raw._1();
            RawDocType rawDocType = raw._2();
            String value = string;
            if (Doc$RawDocType$Html$.MODULE$.equals(rawDocType)) {
                return Html$.MODULE$.fromString(value);
            }
            RawDocType docType = rawDocType;
            throw new IllegalArgumentException(new java.lang.StringBuilder(26).append("Unsupported raw doc type: ").append(docType).toString());
        }
        throw new MatchError((Object)doc2);
    }

    public static String toHtmlSnippet$(Doc $this) {
        return $this.toHtmlSnippet();
    }

    default public String toHtmlSnippet() {
        return this.toHtml().encode(2).toString();
    }

    public static String toPlaintext$(Doc $this, int columnWidth, boolean color) {
        return $this.toPlaintext(columnWidth, color);
    }

    default public String toPlaintext(int columnWidth, boolean color) {
        boolean bl = color;
        DocWriter writer = DocWriter$.MODULE$.apply(0, columnWidth);
        BooleanRef uppercase = BooleanRef.create((boolean)false);
        ObjectRef styles = ObjectRef.create((Object)package$.MODULE$.List().empty());
        ObjectRef lastStyle = ObjectRef.create((Object)"\u001b[0m");
        IntRef printedSep = IntRef.create((int)0);
        Doc.renderHelpDoc$1(writer, uppercase, printedSep, styles, color, lastStyle, this);
        return new java.lang.StringBuilder(0).append(writer.toString()).append(color ? "\u001b[0m" : "").toString();
    }

    public static int toPlaintext$default$1$(Doc $this) {
        return $this.toPlaintext$default$1();
    }

    default public int toPlaintext$default$1() {
        return 100;
    }

    public static boolean toPlaintext$default$2$(Doc $this) {
        return $this.toPlaintext$default$2();
    }

    default public boolean toPlaintext$default$2() {
        return true;
    }

    private static String render$1(int indent$1, String s) {
        return new java.lang.StringBuilder(0).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("  "), indent$1)).append(s).toString();
    }

    private static Comparable renderSpan$1$$anonfun$1(URI value$1) {
        return value$1;
    }

    private static String renderSpan$1(Span span, int indent) {
        Span span2 = span;
        if (span2 instanceof Span.Text) {
            String string;
            Span.Text text = Doc$Span$Text$.MODULE$.unapply((Span.Text)span2);
            String value = string = text._1();
            return Doc.render$1(indent, value);
        }
        if (span2 instanceof Span.Code) {
            Span.Code code = Doc$Span$Code$.MODULE$.unapply((Span.Code)span2);
            String string = code._1();
            Span.CodeStyle codeStyle = code._2();
            String value = string;
            if (Doc$Span$CodeStyle$Block$.MODULE$.equals(codeStyle)) {
                return Doc.render$1(indent, new java.lang.StringBuilder(7).append("```").append(value.trim()).append("\n```").toString());
            }
            String value2 = string;
            if (Doc$Span$CodeStyle$Inline$.MODULE$.equals(codeStyle)) {
                return Doc.render$1(indent, new java.lang.StringBuilder(2).append("`").append(value2).append("`").toString());
            }
        }
        if (span2 instanceof Span.Link) {
            Span.Link link = Doc$Span$Link$.MODULE$.unapply((Span.Link)span2);
            URI uRI = link._1();
            Option<String> option = link._2();
            URI value = uRI;
            Option<String> text = option;
            return Doc.render$1(indent, new java.lang.StringBuilder(4).append("[").append(text.getOrElse(() -> Doc.renderSpan$1$$anonfun$1(value))).append("](").append(value).append(")").toString());
        }
        if (span2 instanceof Span.Bold) {
            Span span3;
            Span.Bold bold = Doc$Span$Bold$.MODULE$.unapply((Span.Bold)span2);
            Span value = span3 = bold._1();
            return new java.lang.StringBuilder(0).append(Doc.render$1(indent, "**")).append(Doc.renderSpan$1(value, indent).trim()).append(Doc.render$1(indent, "**")).toString();
        }
        if (span2 instanceof Span.Italic) {
            Span span4;
            Span.Italic italic = Doc$Span$Italic$.MODULE$.unapply((Span.Italic)span2);
            Span value = span4 = italic._1();
            return new java.lang.StringBuilder(0).append(Doc.render$1(indent, "*")).append(Doc.renderSpan$1(value, indent).trim()).append(Doc.render$1(indent, "*")).toString();
        }
        if (span2 instanceof Span.Error) {
            String string;
            Span.Error error = Doc$Span$Error$.MODULE$.unapply((Span.Error)span2);
            String value = string = error._1();
            return new java.lang.StringBuilder(0).append(Doc.render$1(indent, "<span style=\"color: red\">")).append(Doc.render$1(indent, value)).append(Doc.render$1(indent, "</span>")).toString();
        }
        if (span2 instanceof Span.Sequence) {
            Span.Sequence sequence = Doc$Span$Sequence$.MODULE$.unapply((Span.Sequence)span2);
            Span span5 = sequence._1();
            Span span6 = sequence._2();
            Span left = span5;
            Span right = span6;
            String l = Doc.renderSpan$1(left, indent);
            String r = Doc.renderSpan$1(right, indent);
            return new java.lang.StringBuilder(0).append(l).append(r).toString();
        }
        throw new MatchError((Object)span2);
    }

    private static void append$1(StringBuilder writer$2, int indent$2, String s) {
        writer$2.append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("  "), indent$2)).append(s);
    }

    private static /* synthetic */ void render$2$$anonfun$1(StringBuilder writer$3, int indent$3, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            Span span = (Span)tuple2._1();
            Doc helpDoc = (Doc)tuple2._2();
            writer$3.append(Doc.renderSpan$1(span, indent$3));
            Doc.append$1(writer$3, indent$3, ":\n");
            Doc.render$2(writer$3, helpDoc, indent$3);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static void render$2(StringBuilder writer$1, Doc doc, int indent) {
        Doc doc2;
        while (true) {
            if (Doc$Empty$.MODULE$.equals(doc2 = doc)) {
                return;
            }
            if (doc2 instanceof Header) {
                Header header = Doc$Header$.MODULE$.unapply((Header)doc2);
                String string = header._1();
                int n = header._2();
                String value = string;
                int level = n;
                if (writer$1.nonEmpty() && BoxesRunTime.unboxToChar((Object)writer$1.last()) != '\n') {
                    Doc.append$1(writer$1, indent, "\n");
                }
                Doc.append$1(writer$1, indent, new java.lang.StringBuilder(3).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("#"), level)).append(" ").append(value).append("\n\n").toString());
                return;
            }
            if (doc2 instanceof Paragraph) {
                Span span;
                Paragraph paragraph = Doc$Paragraph$.MODULE$.unapply((Paragraph)doc2);
                Span value = span = paragraph._1();
                writer$1.append(Doc.renderSpan$1(value, indent));
                writer$1.append("\n\n");
                return;
            }
            if (doc2 instanceof DescriptionList) {
                List<Tuple2<Span, Doc>> list;
                DescriptionList descriptionList = Doc$DescriptionList$.MODULE$.unapply((DescriptionList)doc2);
                List<Tuple2<Span, Doc>> definitions = list = descriptionList._1();
                definitions.foreach((Function1 & Serializable)x$1 -> {
                    Doc.render$2$$anonfun$1(writer$1, indent, x$1);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (doc2 instanceof Listing) {
                Listing listing = Doc$Listing$.MODULE$.unapply((Listing)doc2);
                List<Doc> list = listing._1();
                ListingType listingType = listing._2();
                List<Doc> elements = list;
                ListingType listingType2 = listingType;
                ((List)elements.zipWithIndex()).foreach((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        Doc doc = (Doc)tuple2._1();
                        int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        ListingType listingType = listingType2;
                        Doc$ListingType$Ordered$ doc$ListingType$Ordered$ = Doc$ListingType$Ordered$.MODULE$;
                        if (!(listingType != null ? !listingType.equals(doc$ListingType$Ordered$) : doc$ListingType$Ordered$ != null)) {
                            Doc.append$1(writer$1, indent, new java.lang.StringBuilder(2).append(i + 1).append(". ").toString());
                        } else {
                            Doc.append$1(writer$1, indent, "- ");
                        }
                        Doc doc2 = doc;
                        if (doc2 instanceof Listing) {
                            Listing listing = Doc$Listing$.MODULE$.unapply((Listing)doc2);
                            List<Doc> list = listing._1();
                            ListingType listingType2 = listing._2();
                            Doc.render$2(writer$1, doc, indent + 1);
                            boxedUnit = writer$1.append("\n");
                        } else if (doc2 instanceof Sequence) {
                            Sequence sequence = Doc$Sequence$.MODULE$.unapply((Sequence)doc2);
                            Doc doc3 = sequence._1();
                            Doc doc4 = sequence._2();
                            Doc left = doc3;
                            Doc right = doc4;
                            Doc.render$2(writer$1, left, indent);
                            writer$1.deleteCharAt(writer$1.length() - 1);
                            Doc.render$2(writer$1, right, indent + 1);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            Doc.render$2(writer$1, doc, indent);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return writer$1.deleteCharAt(writer$1.length() - 1);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return;
            }
            if (!(doc2 instanceof Sequence)) break;
            Sequence sequence = Doc$Sequence$.MODULE$.unapply((Sequence)doc2);
            Doc doc3 = sequence._1();
            Doc doc4 = sequence._2();
            Doc left = doc3;
            Doc right = doc4;
            Doc.render$2(writer$1, left, indent);
            doc = right;
        }
        if (doc2 instanceof Raw) {
            Raw raw = Doc$Raw$.MODULE$.unapply((Raw)doc2);
            String string = raw._1();
            RawDocType rawDocType = raw._2();
            String value = string;
            if (Doc$RawDocType$CommonMark$.MODULE$.equals(rawDocType)) {
                writer$1.append(value);
                return;
            }
            RawDocType docType = rawDocType;
            throw new IllegalArgumentException(new java.lang.StringBuilder(26).append("Unsupported raw doc type: ").append(docType).toString());
        }
        throw new MatchError((Object)doc2);
    }

    private static int render$default$2$1() {
        return 0;
    }

    private static void setStyle$1(ObjectRef styles$1, String style) {
        List list = ((List)styles$1.elem).$colon$colon((Object)style);
        styles$1.elem = list;
        list = null;
    }

    private static String currentStyle$1$$anonfun$1() {
        return "\u001b[0m";
    }

    private static String currentStyle$1(ObjectRef styles$2) {
        return (String)((List)styles$2.elem).headOption().getOrElse(Doc::currentStyle$1$$anonfun$1);
    }

    private static void resetStyle$1(ObjectRef styles$3) {
        List list = (List)((List)styles$3.elem).drop(1);
        styles$3.elem = list;
        list = null;
    }

    private static void renderText$1(boolean color$5, ObjectRef lastStyle$5, DocWriter writer$11, BooleanRef uppercase$5, IntRef printedSep$7, ObjectRef styles$8, String text) {
        Doc.renderSpan$2(color$5, lastStyle$5, writer$11, uppercase$5, printedSep$7, styles$8, Doc$Span$.MODULE$.text(text));
    }

    private static void renderNewline$1(IntRef printedSep$1, DocWriter writer$5) {
        if (printedSep$1.elem < 2) {
            int n;
            printedSep$1.elem = n = printedSep$1.elem + 1;
            DocWriter docWriter = writer$5.append("\n");
            return;
        }
    }

    private static void clearSep$1(IntRef printedSep$2) {
        int n;
        printedSep$2.elem = n = 0;
    }

    private static /* synthetic */ void renderHelpDoc$1$$anonfun$1(DocWriter writer$7, ObjectRef styles$5, boolean color$2, ObjectRef lastStyle$2, BooleanRef uppercase$2, IntRef printedSep$4, Tuple2 x$1) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x$1;
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
            Span span = (Span)tuple2._1();
            Doc helpDoc = (Doc)tuple2._2();
            Doc.setStyle$1(styles$5, "\u001b[1m");
            Doc.renderSpan$2(color$2, lastStyle$2, writer$7, uppercase$2, printedSep$4, styles$5, span);
            Doc.resetStyle$1(styles$5);
            Doc.renderNewline$1(printedSep$4, writer$7);
            writer$7.indent(2);
            Doc.renderHelpDoc$1(writer$7, uppercase$2, printedSep$4, styles$5, color$2, lastStyle$2, helpDoc);
            writer$7.unindent();
            Doc.renderNewline$1(printedSep$4, writer$7);
            return;
        }
        throw new MatchError((Object)tuple22);
    }

    private static /* synthetic */ void renderHelpDoc$1$$anonfun$2(ListingType listingType$2, DocWriter writer$8, boolean color$3, ObjectRef lastStyle$3, BooleanRef uppercase$3, IntRef printedSep$5, ObjectRef styles$6, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            Doc helpDoc = (Doc)tuple2._1();
            int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
            ListingType listingType = listingType$2;
            Doc$ListingType$Ordered$ doc$ListingType$Ordered$ = Doc$ListingType$Ordered$.MODULE$;
            if (!(listingType != null ? !listingType.equals(doc$ListingType$Ordered$) : doc$ListingType$Ordered$ != null)) {
                Doc.renderText$1(color$3, lastStyle$3, writer$8, uppercase$3, printedSep$5, styles$6, new java.lang.StringBuilder(2).append(i + 1).append(". ").toString());
            } else {
                Doc.renderText$1(color$3, lastStyle$3, writer$8, uppercase$3, printedSep$5, styles$6, "- ");
            }
            Doc doc = helpDoc;
            if (doc instanceof Listing) {
                Listing listing = Doc$Listing$.MODULE$.unapply((Listing)doc);
                List<Doc> list = listing._1();
                ListingType listingType2 = listing._2();
                writer$8.indent(2);
                Doc.renderHelpDoc$1(writer$8, uppercase$3, printedSep$5, styles$6, color$3, lastStyle$3, helpDoc);
                writer$8.unindent();
                return;
            }
            if (doc instanceof Sequence) {
                Sequence sequence = Doc$Sequence$.MODULE$.unapply((Sequence)doc);
                Doc doc2 = sequence._1();
                Doc doc3 = sequence._2();
                Doc left = doc2;
                Doc right = doc3;
                Doc.renderHelpDoc$1(writer$8, uppercase$3, printedSep$5, styles$6, color$3, lastStyle$3, left);
                writer$8.deleteLastChar();
                writer$8.indent(2);
                Doc.renderHelpDoc$1(writer$8, uppercase$3, printedSep$5, styles$6, color$3, lastStyle$3, right);
                writer$8.unindent();
                return;
            }
            Doc.renderHelpDoc$1(writer$8, uppercase$3, printedSep$5, styles$6, color$3, lastStyle$3, helpDoc);
            writer$8.deleteLastChar();
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static void renderHelpDoc$1(DocWriter writer$6, BooleanRef uppercase$1, IntRef printedSep$3, ObjectRef styles$4, boolean color$1, ObjectRef lastStyle$1, Doc helpDoc) {
        Doc doc;
        while (true) {
            if (Doc$Empty$.MODULE$.equals(doc = helpDoc)) {
                return;
            }
            if (doc instanceof Header) {
                boolean bl;
                boolean bl2;
                Header header = Doc$Header$.MODULE$.unapply((Header)doc);
                String string = header._1();
                int n = header._2();
                String value = string;
                writer$6.unindent();
                Doc.renderNewline$1(printedSep$3, writer$6);
                uppercase$1.elem = bl2 = true;
                Doc.setStyle$1(styles$4, "\u001b[1m");
                Doc.renderSpan$2(color$1, lastStyle$1, writer$6, uppercase$1, printedSep$3, styles$4, Doc$Span$.MODULE$.text(value));
                Doc.resetStyle$1(styles$4);
                uppercase$1.elem = bl = false;
                Doc.renderNewline$1(printedSep$3, writer$6);
                Doc.renderNewline$1(printedSep$3, writer$6);
                writer$6.indent(2);
                return;
            }
            if (doc instanceof Paragraph) {
                Span span;
                Paragraph paragraph = Doc$Paragraph$.MODULE$.unapply((Paragraph)doc);
                Span value = span = paragraph._1();
                Doc.renderSpan$2(color$1, lastStyle$1, writer$6, uppercase$1, printedSep$3, styles$4, value);
                Doc.renderNewline$1(printedSep$3, writer$6);
                Doc.renderNewline$1(printedSep$3, writer$6);
                return;
            }
            if (doc instanceof DescriptionList) {
                List<Tuple2<Span, Doc>> list;
                DescriptionList descriptionList = Doc$DescriptionList$.MODULE$.unapply((DescriptionList)doc);
                List<Tuple2<Span, Doc>> definitions = list = descriptionList._1();
                ((List)definitions.zipWithIndex()).foreach((Function1 & Serializable)x$1 -> {
                    Doc.renderHelpDoc$1$$anonfun$1(writer$6, styles$4, color$1, lastStyle$1, uppercase$1, printedSep$3, x$1);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (doc instanceof Listing) {
                Listing listing = Doc$Listing$.MODULE$.unapply((Listing)doc);
                List<Doc> list = listing._1();
                ListingType listingType = listing._2();
                List<Doc> elements = list;
                ListingType listingType2 = listingType;
                ((List)elements.zipWithIndex()).foreach((Function1 & Serializable)x$1 -> {
                    Doc.renderHelpDoc$1$$anonfun$2(listingType2, writer$6, color$1, lastStyle$1, uppercase$1, printedSep$3, styles$4, x$1);
                    return BoxedUnit.UNIT;
                });
                writer$6.unindent();
                return;
            }
            if (!(doc instanceof Sequence)) break;
            Sequence sequence = Doc$Sequence$.MODULE$.unapply((Sequence)doc);
            Doc doc2 = sequence._1();
            Doc doc3 = sequence._2();
            Doc left = doc2;
            Doc right = doc3;
            Doc.renderHelpDoc$1(writer$6, uppercase$1, printedSep$3, styles$4, color$1, lastStyle$1, left);
            helpDoc = right;
        }
        if (doc instanceof Raw) {
            Raw raw = Doc$Raw$.MODULE$.unapply((Raw)doc);
            String string = raw._1();
            RawDocType rawDocType = raw._2();
            String value = string;
            if (Doc$RawDocType$Plain$.MODULE$.equals(rawDocType)) {
                writer$6.append(value);
                return;
            }
            RawDocType docType = rawDocType;
            throw new IllegalArgumentException(new java.lang.StringBuilder(26).append("Unsupported raw doc type: ").append(docType).toString());
        }
        throw new MatchError((Object)doc);
    }

    private static String renderSpan$2$$anonfun$2(URI value$3) {
        return value$3.toASCIIString();
    }

    private static void renderSpan$2(boolean color$4, ObjectRef lastStyle$4, DocWriter writer$9, BooleanRef uppercase$4, IntRef printedSep$6, ObjectRef styles$7, Span span) {
        DocWriter docWriter;
        Doc.clearSep$1(printedSep$6);
        Span span2 = span;
        if (span2 instanceof Span.Text) {
            String string;
            Span.Text text = Doc$Span$Text$.MODULE$.unapply((Span.Text)span2);
            String value = string = text._1();
            if (color$4) {
                String string2 = (String)lastStyle$4.elem;
                String string3 = Doc.currentStyle$1(styles$7);
                if (string2 == null ? string3 != null : !string2.equals(string3)) {
                    writer$9.append(Doc.currentStyle$1(styles$7));
                    String string4 = Doc.currentStyle$1(styles$7);
                    lastStyle$4.elem = string4;
                    string4 = null;
                }
            }
            docWriter = writer$9.append(uppercase$4.elem ? value.toUpperCase() : value);
        } else if (span2 instanceof Span.Code) {
            Span.Code code = Doc$Span$Code$.MODULE$.unapply((Span.Code)span2);
            String string = code._1();
            Span.CodeStyle codeStyle = code._2();
            String value = string;
            Doc.setStyle$1(styles$7, "\u001b[37m");
            writer$9.append(value);
            Doc.resetStyle$1(styles$7);
            docWriter = BoxedUnit.UNIT;
        } else if (span2 instanceof Span.Error) {
            String string;
            Span.Error error = Doc$Span$Error$.MODULE$.unapply((Span.Error)span2);
            String value = string = error._1();
            Doc.setStyle$1(styles$7, "\u001b[31m");
            Doc.renderSpan$2(color$4, lastStyle$4, writer$9, uppercase$4, printedSep$6, styles$7, Doc$Span$.MODULE$.text(value));
            Doc.resetStyle$1(styles$7);
            docWriter = BoxedUnit.UNIT;
        } else if (span2 instanceof Span.Italic) {
            Span span3;
            Span.Italic italic = Doc$Span$Italic$.MODULE$.unapply((Span.Italic)span2);
            Span value = span3 = italic._1();
            Doc.setStyle$1(styles$7, "\u001b[1m");
            Doc.renderSpan$2(color$4, lastStyle$4, writer$9, uppercase$4, printedSep$6, styles$7, value);
            Doc.resetStyle$1(styles$7);
            docWriter = BoxedUnit.UNIT;
        } else if (span2 instanceof Span.Bold) {
            Span span4;
            Span.Bold bold = Doc$Span$Bold$.MODULE$.unapply((Span.Bold)span2);
            Span value = span4 = bold._1();
            Doc.setStyle$1(styles$7, "\u001b[1m");
            Doc.renderSpan$2(color$4, lastStyle$4, writer$9, uppercase$4, printedSep$6, styles$7, value);
            Doc.resetStyle$1(styles$7);
            docWriter = BoxedUnit.UNIT;
        } else if (span2 instanceof Span.Link) {
            Span.Link link = Doc$Span$Link$.MODULE$.unapply((Span.Link)span2);
            URI uRI = link._1();
            Option<String> option = link._2();
            URI value = uRI;
            Option<String> text = option;
            Doc.setStyle$1(styles$7, "\u001b[4m");
            Doc.renderSpan$2(color$4, lastStyle$4, writer$9, uppercase$4, printedSep$6, styles$7, Doc$Span$.MODULE$.text((String)text.map((Function1 & Serializable)t -> new java.lang.StringBuilder(4).append("[").append((String)t).append("](").append(value.toASCIIString()).append(")").toString()).getOrElse(() -> Doc.renderSpan$2$$anonfun$2(value))));
            Doc.resetStyle$1(styles$7);
            docWriter = BoxedUnit.UNIT;
        } else if (span2 instanceof Span.Sequence) {
            Span.Sequence sequence = Doc$Span$Sequence$.MODULE$.unapply((Span.Sequence)span2);
            Span span5 = sequence._1();
            Span span6 = sequence._2();
            Span left = span5;
            Span right = span6;
            Doc.renderSpan$2(color$4, lastStyle$4, writer$9, uppercase$4, printedSep$6, styles$7, left);
            Doc.renderSpan$2(color$4, lastStyle$4, writer$9, uppercase$4, printedSep$6, styles$7, right);
            docWriter = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)span2);
        }
        DocWriter docWriter2 = docWriter;
    }

    public static final class DescriptionList
    implements Doc,
    Product,
    Serializable {
        private final List definitions;

        public static DescriptionList apply(List<Tuple2<Span, Doc>> list) {
            return Doc$DescriptionList$.MODULE$.apply(list);
        }

        public static DescriptionList fromProduct(Product product) {
            return Doc$DescriptionList$.MODULE$.fromProduct(product);
        }

        public static DescriptionList unapply(DescriptionList descriptionList) {
            return Doc$DescriptionList$.MODULE$.unapply(descriptionList);
        }

        public DescriptionList(List<Tuple2<Span, Doc>> definitions) {
            this.definitions = definitions;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DescriptionList)) return false;
            DescriptionList descriptionList = (DescriptionList)object;
            List<Tuple2<Span, Doc>> list = this.definitions();
            List<Tuple2<Span, Doc>> list2 = descriptionList.definitions();
            if (list != null) {
                if (!list.equals(list2)) return false;
                return true;
            }
            if (list2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DescriptionList;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "DescriptionList";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "definitions";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<Tuple2<Span, Doc>> definitions() {
            return this.definitions;
        }

        public DescriptionList copy(List<Tuple2<Span, Doc>> definitions) {
            return new DescriptionList(definitions);
        }

        public List<Tuple2<Span, Doc>> copy$default$1() {
            return this.definitions();
        }

        public List<Tuple2<Span, Doc>> _1() {
            return this.definitions();
        }
    }

    public static final class Header
    implements Doc,
    Product,
    Serializable {
        private final String value;
        private final int level;

        public static Header apply(String string, int n) {
            return Doc$Header$.MODULE$.apply(string, n);
        }

        public static Header fromProduct(Product product) {
            return Doc$Header$.MODULE$.fromProduct(product);
        }

        public static Header unapply(Header header) {
            return Doc$Header$.MODULE$.unapply(header);
        }

        public Header(String value, int level) {
            this.value = value;
            this.level = level;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.value()));
            n = Statics.mix((int)n, (int)this.level());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Header)) return false;
            Header header = (Header)object;
            if (this.level() != header.level()) return false;
            String string = this.value();
            String string2 = header.value();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Header;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Header";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToInteger((int)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            if (1 == n2) {
                return "level";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String value() {
            return this.value;
        }

        public int level() {
            return this.level;
        }

        public Header copy(String value, int level) {
            return new Header(value, level);
        }

        public String copy$default$1() {
            return this.value();
        }

        public int copy$default$2() {
            return this.level();
        }

        public String _1() {
            return this.value();
        }

        public int _2() {
            return this.level();
        }
    }

    public static final class Listing
    implements Doc,
    Product,
    Serializable {
        private final List elements;
        private final ListingType listingType;

        public static Listing apply(List<Doc> list, ListingType listingType) {
            return Doc$Listing$.MODULE$.apply(list, listingType);
        }

        public static Listing fromProduct(Product product) {
            return Doc$Listing$.MODULE$.fromProduct(product);
        }

        public static Listing unapply(Listing listing) {
            return Doc$Listing$.MODULE$.unapply(listing);
        }

        public Listing(List<Doc> elements, ListingType listingType) {
            this.elements = elements;
            this.listingType = listingType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Listing)) return false;
            Listing listing = (Listing)object;
            List<Doc> list = this.elements();
            List<Doc> list2 = listing.elements();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            ListingType listingType = this.listingType();
            ListingType listingType2 = listing.listingType();
            if (listingType == null) {
                if (listingType2 == null) return true;
                return false;
            } else {
                if (!listingType.equals(listingType2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Listing;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Listing";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "elements";
            }
            if (1 == n2) {
                return "listingType";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<Doc> elements() {
            return this.elements;
        }

        public ListingType listingType() {
            return this.listingType;
        }

        public Listing copy(List<Doc> elements, ListingType listingType) {
            return new Listing(elements, listingType);
        }

        public List<Doc> copy$default$1() {
            return this.elements();
        }

        public ListingType copy$default$2() {
            return this.listingType();
        }

        public List<Doc> _1() {
            return this.elements();
        }

        public ListingType _2() {
            return this.listingType();
        }
    }

    public static interface ListingType {
        public static int ordinal(ListingType listingType) {
            return Doc$ListingType$.MODULE$.ordinal(listingType);
        }
    }

    public static final class Paragraph
    implements Doc,
    Product,
    Serializable {
        private final Span value;

        public static Paragraph apply(Span span) {
            return Doc$Paragraph$.MODULE$.apply(span);
        }

        public static Paragraph fromProduct(Product product) {
            return Doc$Paragraph$.MODULE$.fromProduct(product);
        }

        public static Paragraph unapply(Paragraph paragraph) {
            return Doc$Paragraph$.MODULE$.unapply(paragraph);
        }

        public Paragraph(Span value) {
            this.value = value;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Paragraph)) return false;
            Paragraph paragraph = (Paragraph)object;
            Span span = this.value();
            Span span2 = paragraph.value();
            if (span != null) {
                if (!span.equals(span2)) return false;
                return true;
            }
            if (span2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Paragraph;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Paragraph";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Span value() {
            return this.value;
        }

        public Paragraph copy(Span value) {
            return new Paragraph(value);
        }

        public Span copy$default$1() {
            return this.value();
        }

        public Span _1() {
            return this.value();
        }
    }

    public static final class Raw
    implements Doc,
    Product,
    Serializable {
        private final String value;
        private final RawDocType docType;

        public static Raw apply(String string, RawDocType rawDocType) {
            return Doc$Raw$.MODULE$.apply(string, rawDocType);
        }

        public static Raw fromProduct(Product product) {
            return Doc$Raw$.MODULE$.fromProduct(product);
        }

        public static Raw unapply(Raw raw) {
            return Doc$Raw$.MODULE$.unapply(raw);
        }

        public Raw(String value, RawDocType docType) {
            this.value = value;
            this.docType = docType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Raw)) return false;
            Raw raw = (Raw)object;
            String string = this.value();
            String string2 = raw.value();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            RawDocType rawDocType = this.docType();
            RawDocType rawDocType2 = raw.docType();
            if (rawDocType == null) {
                if (rawDocType2 == null) return true;
                return false;
            } else {
                if (!rawDocType.equals(rawDocType2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Raw;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Raw";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            if (1 == n2) {
                return "docType";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String value() {
            return this.value;
        }

        public RawDocType docType() {
            return this.docType;
        }

        public Raw copy(String value, RawDocType docType) {
            return new Raw(value, docType);
        }

        public String copy$default$1() {
            return this.value();
        }

        public RawDocType copy$default$2() {
            return this.docType();
        }

        public String _1() {
            return this.value();
        }

        public RawDocType _2() {
            return this.docType();
        }
    }

    public static interface RawDocType {
        public static int ordinal(RawDocType rawDocType) {
            return Doc$RawDocType$.MODULE$.ordinal(rawDocType);
        }
    }

    public static final class Sequence
    implements Doc,
    Product,
    Serializable {
        private final Doc left;
        private final Doc right;

        public static Sequence apply(Doc doc, Doc doc2) {
            return Doc$Sequence$.MODULE$.apply(doc, doc2);
        }

        public static Sequence fromProduct(Product product) {
            return Doc$Sequence$.MODULE$.fromProduct(product);
        }

        public static Sequence unapply(Sequence sequence) {
            return Doc$Sequence$.MODULE$.unapply(sequence);
        }

        public Sequence(Doc left, Doc right) {
            this.left = left;
            this.right = right;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Sequence)) return false;
            Sequence sequence = (Sequence)object;
            Doc doc = this.left();
            Doc doc2 = sequence.left();
            if (doc == null) {
                if (doc2 != null) {
                    return false;
                }
            } else if (!doc.equals(doc2)) return false;
            Doc doc3 = this.right();
            Doc doc4 = sequence.right();
            if (doc3 == null) {
                if (doc4 == null) return true;
                return false;
            } else {
                if (!doc3.equals(doc4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Sequence;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Sequence";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "left";
            }
            if (1 == n2) {
                return "right";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Doc left() {
            return this.left;
        }

        public Doc right() {
            return this.right;
        }

        public Sequence copy(Doc left, Doc right) {
            return new Sequence(left, right);
        }

        public Doc copy$default$1() {
            return this.left();
        }

        public Doc copy$default$2() {
            return this.right();
        }

        public Doc _1() {
            return this.left();
        }

        public Doc _2() {
            return this.right();
        }
    }

    public static interface Span {
        public static Span bold(Span span) {
            return Doc$Span$.MODULE$.bold(span);
        }

        public static Span bold(String string) {
            return Doc$Span$.MODULE$.bold(string);
        }

        public static Span code(String string) {
            return Doc$Span$.MODULE$.code(string);
        }

        public static Span codeBlock(String string) {
            return Doc$Span$.MODULE$.codeBlock(string);
        }

        public static Span empty() {
            return Doc$Span$.MODULE$.empty();
        }

        public static Span error(String string) {
            return Doc$Span$.MODULE$.error(string);
        }

        public static Span italic(Span span) {
            return Doc$Span$.MODULE$.italic(span);
        }

        public static Span italic(String string) {
            return Doc$Span$.MODULE$.italic(string);
        }

        public static Span link(URI uRI) {
            return Doc$Span$.MODULE$.link(uRI);
        }

        public static Span link(URI uRI, String string) {
            return Doc$Span$.MODULE$.link(uRI, string);
        }

        public static int ordinal(Span span) {
            return Doc$Span$.MODULE$.ordinal(span);
        }

        public static Span spans(Iterable<Span> iterable) {
            return Doc$Span$.MODULE$.spans(iterable);
        }

        public static Span spans(Span span, Seq<Span> seq) {
            return Doc$Span$.MODULE$.spans(span, seq);
        }

        public static Span text(String string) {
            return Doc$Span$.MODULE$.text(string);
        }

        public static Span $plus$(Span $this, Span that) {
            return $this.$plus(that);
        }

        default public Span $plus(Span that) {
            if (this.isEmpty()) {
                return that;
            }
            if (that.isEmpty()) {
                return this;
            }
            return Doc$Span$Sequence$.MODULE$.apply(this, that);
        }

        public static boolean isEmpty$(Span $this) {
            return $this.isEmpty();
        }

        default public boolean isEmpty() {
            return this.size() == 0;
        }

        public static int size$(Span $this) {
            return $this.size();
        }

        default public int size() {
            Span span;
            while (true) {
                Span span2;
                Span value;
                Span this_;
                if ((span = this_) instanceof Text) {
                    String string;
                    Text text = Doc$Span$Text$.MODULE$.unapply((Text)span);
                    String value2 = string = text._1();
                    return value2.length();
                }
                if (span instanceof Code) {
                    Code code = Doc$Span$Code$.MODULE$.unapply((Code)span);
                    String string = code._1();
                    CodeStyle codeStyle = code._2();
                    String value3 = string;
                    return value3.length();
                }
                if (span instanceof Error) {
                    String string;
                    Error error = Doc$Span$Error$.MODULE$.unapply((Error)span);
                    String value4 = string = error._1();
                    return value4.length();
                }
                if (span instanceof Bold) {
                    Span span3;
                    Span value5;
                    Bold bold = Doc$Span$Bold$.MODULE$.unapply((Bold)span);
                    this_ = value5 = (span3 = bold._1());
                    continue;
                }
                if (!(span instanceof Italic)) break;
                Italic italic = Doc$Span$Italic$.MODULE$.unapply((Italic)span);
                this_ = value = (span2 = italic._1());
            }
            if (span instanceof Link) {
                Link link = Doc$Span$Link$.MODULE$.unapply((Link)span);
                URI uRI = link._1();
                Option<String> option = link._2();
                URI value = uRI;
                return value.toString().length();
            }
            if (span instanceof Sequence) {
                Sequence sequence = Doc$Span$Sequence$.MODULE$.unapply((Sequence)span);
                Span span4 = sequence._1();
                Span span5 = sequence._2();
                Span left = span4;
                Span right = span5;
                return left.size() + right.size();
            }
            throw new MatchError((Object)span);
        }

        public static Html toHtml$(Span $this) {
            return $this.toHtml();
        }

        default public Html toHtml() {
            Span span = this;
            if (span instanceof Text) {
                String string;
                Text text = Doc$Span$Text$.MODULE$.unapply((Text)span);
                String value = string = text._1();
                return Html$.MODULE$.fromString(value);
            }
            if (span instanceof Code) {
                Code code = Doc$Span$Code$.MODULE$.unapply((Code)span);
                String string = code._1();
                CodeStyle codeStyle = code._2();
                String value = string;
                if (Doc$Span$CodeStyle$Block$.MODULE$.equals(codeStyle)) {
                    return Html$.MODULE$.fromDomElement(zio.http.template.package$.MODULE$.pre().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{Html$.MODULE$.fromDomElement(zio.http.template.package$.MODULE$.code().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{Html$.MODULE$.fromString(value)})))})));
                }
                String value2 = string;
                if (Doc$Span$CodeStyle$Inline$.MODULE$.equals(codeStyle)) {
                    return Html$.MODULE$.fromDomElement(zio.http.template.package$.MODULE$.code().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{Html$.MODULE$.fromString(value2)})));
                }
            }
            if (span instanceof Error) {
                String string;
                Error error = Doc$Span$Error$.MODULE$.unapply((Error)span);
                String value = string = error._1();
                return Html$.MODULE$.fromDomElement(zio.http.template.package$.MODULE$.span().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{zio.http.template.package$.MODULE$.styleAttr().$colon$eq("color: red", IsAttributeValue$.MODULE$.instanceString()), Html$.MODULE$.fromString(value)})));
            }
            if (span instanceof Bold) {
                Span span2;
                Bold bold = Doc$Span$Bold$.MODULE$.unapply((Bold)span);
                Span value = span2 = bold._1();
                return Html$.MODULE$.fromDomElement(zio.http.template.package$.MODULE$.b().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{value.toHtml()})));
            }
            if (span instanceof Italic) {
                Span span3;
                Italic italic = Doc$Span$Italic$.MODULE$.unapply((Italic)span);
                Span value = span3 = italic._1();
                return Html$.MODULE$.fromDomElement(zio.http.template.package$.MODULE$.i().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{value.toHtml()})));
            }
            if (span instanceof Link) {
                Link link = Doc$Span$Link$.MODULE$.unapply((Link)span);
                URI uRI = link._1();
                Option<String> option = link._2();
                URI value = uRI;
                Option<String> text = option;
                return Html$.MODULE$.fromDomElement(zio.http.template.package$.MODULE$.a().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{zio.http.template.package$.MODULE$.href().$colon$eq(value.toASCIIString(), IsAttributeValue$.MODULE$.instanceString()), Html$.MODULE$.fromString((CharSequence)text.getOrElse(() -> this.toHtml$$anonfun$2(value)))})));
            }
            if (span instanceof Sequence) {
                Sequence sequence = Doc$Span$Sequence$.MODULE$.unapply((Sequence)span);
                Span span4 = sequence._1();
                Span span5 = sequence._2();
                Span left = span4;
                Span right = span5;
                return left.toHtml().$plus$plus(right.toHtml());
            }
            throw new MatchError((Object)span);
        }

        private String toHtml$$anonfun$2(URI value$4) {
            return value$4.toASCIIString();
        }

        public static final class Bold
        implements Span,
        Product,
        Serializable {
            private final Span value;

            public static Bold apply(Span span) {
                return Doc$Span$Bold$.MODULE$.apply(span);
            }

            public static Bold fromProduct(Product product) {
                return Doc$Span$Bold$.MODULE$.fromProduct(product);
            }

            public static Bold unapply(Bold bold) {
                return Doc$Span$Bold$.MODULE$.unapply(bold);
            }

            public Bold(Span value) {
                this.value = value;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Bold)) return false;
                Bold bold = (Bold)object;
                Span span = this.value();
                Span span2 = bold.value();
                if (span != null) {
                    if (!span.equals(span2)) return false;
                    return true;
                }
                if (span2 == null) return true;
                return false;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Bold;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "Bold";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "value";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public Span value() {
                return this.value;
            }

            public Bold copy(Span value) {
                return new Bold(value);
            }

            public Span copy$default$1() {
                return this.value();
            }

            public Span _1() {
                return this.value();
            }
        }

        public static final class Code
        implements Span,
        Product,
        Serializable {
            private final String value;
            private final CodeStyle codeStyle;

            public static Code apply(String string, CodeStyle codeStyle) {
                return Doc$Span$Code$.MODULE$.apply(string, codeStyle);
            }

            public static Code fromProduct(Product product) {
                return Doc$Span$Code$.MODULE$.fromProduct(product);
            }

            public static Code unapply(Code code) {
                return Doc$Span$Code$.MODULE$.unapply(code);
            }

            public Code(String value, CodeStyle codeStyle) {
                this.value = value;
                this.codeStyle = codeStyle;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Code)) return false;
                Code code = (Code)object;
                String string = this.value();
                String string2 = code.value();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                CodeStyle codeStyle = this.codeStyle();
                CodeStyle codeStyle2 = code.codeStyle();
                if (codeStyle == null) {
                    if (codeStyle2 == null) return true;
                    return false;
                } else {
                    if (!codeStyle.equals(codeStyle2)) return false;
                    return true;
                }
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Code;
            }

            public int productArity() {
                return 2;
            }

            public String productPrefix() {
                return "Code";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                if (1 == n2) {
                    return this._2();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "value";
                }
                if (1 == n2) {
                    return "codeStyle";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String value() {
                return this.value;
            }

            public CodeStyle codeStyle() {
                return this.codeStyle;
            }

            public Code copy(String value, CodeStyle codeStyle) {
                return new Code(value, codeStyle);
            }

            public String copy$default$1() {
                return this.value();
            }

            public CodeStyle copy$default$2() {
                return this.codeStyle();
            }

            public String _1() {
                return this.value();
            }

            public CodeStyle _2() {
                return this.codeStyle();
            }
        }

        public static interface CodeStyle {
            public static int ordinal(CodeStyle codeStyle) {
                return Doc$Span$CodeStyle$.MODULE$.ordinal(codeStyle);
            }
        }

        public static final class Error
        implements Span,
        Product,
        Serializable {
            private final String value;

            public static Error apply(String string) {
                return Doc$Span$Error$.MODULE$.apply(string);
            }

            public static Error fromProduct(Product product) {
                return Doc$Span$Error$.MODULE$.fromProduct(product);
            }

            public static Error unapply(Error error) {
                return Doc$Span$Error$.MODULE$.unapply(error);
            }

            public Error(String value) {
                this.value = value;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Error)) return false;
                Error error = (Error)object;
                String string = this.value();
                String string2 = error.value();
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Error;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "Error";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "value";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String value() {
                return this.value;
            }

            public Error copy(String value) {
                return new Error(value);
            }

            public String copy$default$1() {
                return this.value();
            }

            public String _1() {
                return this.value();
            }
        }

        public static final class Italic
        implements Span,
        Product,
        Serializable {
            private final Span value;

            public static Italic apply(Span span) {
                return Doc$Span$Italic$.MODULE$.apply(span);
            }

            public static Italic fromProduct(Product product) {
                return Doc$Span$Italic$.MODULE$.fromProduct(product);
            }

            public static Italic unapply(Italic italic) {
                return Doc$Span$Italic$.MODULE$.unapply(italic);
            }

            public Italic(Span value) {
                this.value = value;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Italic)) return false;
                Italic italic = (Italic)object;
                Span span = this.value();
                Span span2 = italic.value();
                if (span != null) {
                    if (!span.equals(span2)) return false;
                    return true;
                }
                if (span2 == null) return true;
                return false;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Italic;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "Italic";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "value";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public Span value() {
                return this.value;
            }

            public Italic copy(Span value) {
                return new Italic(value);
            }

            public Span copy$default$1() {
                return this.value();
            }

            public Span _1() {
                return this.value();
            }
        }

        public static final class Link
        implements Span,
        Product,
        Serializable {
            private final URI value;
            private final Option text;

            public static Link apply(URI uRI, Option<String> option) {
                return Doc$Span$Link$.MODULE$.apply(uRI, option);
            }

            public static Link fromProduct(Product product) {
                return Doc$Span$Link$.MODULE$.fromProduct(product);
            }

            public static Link unapply(Link link) {
                return Doc$Span$Link$.MODULE$.unapply(link);
            }

            public Link(URI value, Option<String> text) {
                this.value = value;
                this.text = text;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Link)) return false;
                Link link = (Link)object;
                URI uRI = this.value();
                URI uRI2 = link.value();
                if (uRI == null) {
                    if (uRI2 != null) {
                        return false;
                    }
                } else if (!((Object)uRI).equals(uRI2)) return false;
                Option<String> option = this.text();
                Option<String> option2 = link.text();
                if (option == null) {
                    if (option2 == null) return true;
                    return false;
                } else {
                    if (!option.equals(option2)) return false;
                    return true;
                }
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Link;
            }

            public int productArity() {
                return 2;
            }

            public String productPrefix() {
                return "Link";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                if (1 == n2) {
                    return this._2();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "value";
                }
                if (1 == n2) {
                    return "text";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public URI value() {
                return this.value;
            }

            public Option<String> text() {
                return this.text;
            }

            public Link copy(URI value, Option<String> text) {
                return new Link(value, text);
            }

            public URI copy$default$1() {
                return this.value();
            }

            public Option<String> copy$default$2() {
                return this.text();
            }

            public URI _1() {
                return this.value();
            }

            public Option<String> _2() {
                return this.text();
            }
        }

        public static final class Sequence
        implements Span,
        Product,
        Serializable {
            private final Span left;
            private final Span right;

            public static Sequence apply(Span span, Span span2) {
                return Doc$Span$Sequence$.MODULE$.apply(span, span2);
            }

            public static Sequence fromProduct(Product product) {
                return Doc$Span$Sequence$.MODULE$.fromProduct(product);
            }

            public static Sequence unapply(Sequence sequence) {
                return Doc$Span$Sequence$.MODULE$.unapply(sequence);
            }

            public Sequence(Span left, Span right) {
                this.left = left;
                this.right = right;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Sequence)) return false;
                Sequence sequence = (Sequence)object;
                Span span = this.left();
                Span span2 = sequence.left();
                if (span == null) {
                    if (span2 != null) {
                        return false;
                    }
                } else if (!span.equals(span2)) return false;
                Span span3 = this.right();
                Span span4 = sequence.right();
                if (span3 == null) {
                    if (span4 == null) return true;
                    return false;
                } else {
                    if (!span3.equals(span4)) return false;
                    return true;
                }
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Sequence;
            }

            public int productArity() {
                return 2;
            }

            public String productPrefix() {
                return "Sequence";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                if (1 == n2) {
                    return this._2();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "left";
                }
                if (1 == n2) {
                    return "right";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public Span left() {
                return this.left;
            }

            public Span right() {
                return this.right;
            }

            public Sequence copy(Span left, Span right) {
                return new Sequence(left, right);
            }

            public Span copy$default$1() {
                return this.left();
            }

            public Span copy$default$2() {
                return this.right();
            }

            public Span _1() {
                return this.left();
            }

            public Span _2() {
                return this.right();
            }
        }

        public static final class Text
        implements Span,
        Product,
        Serializable {
            private final String value;

            public static Text apply(String string) {
                return Doc$Span$Text$.MODULE$.apply(string);
            }

            public static Text fromProduct(Product product) {
                return Doc$Span$Text$.MODULE$.fromProduct(product);
            }

            public static Text unapply(Text text) {
                return Doc$Span$Text$.MODULE$.unapply(text);
            }

            public Text(String value) {
                this.value = value;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Text)) return false;
                Text text = (Text)object;
                String string = this.value();
                String string2 = text.value();
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Text;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "Text";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "value";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String value() {
                return this.value;
            }

            public Text copy(String value) {
                return new Text(value);
            }

            public String copy$default$1() {
                return this.value();
            }

            public String _1() {
                return this.value();
            }
        }
    }
}

