/*
 * Decompiled with CFR 0.152.
 */
package zio.http.codec.internal;

import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Chunk;
import zio.IsSubtypeOfError$;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$;
import zio.http.Header;
import zio.http.MediaType;
import zio.http.codec.HttpCodecError;
import zio.http.codec.HttpContentCodec;
import zio.http.codec.internal.BodyCodec$;
import zio.http.codec.internal.BodyCodec$Multiple$;
import zio.http.codec.internal.BodyCodec$Single$;
import zio.schema.Schema;
import zio.schema.Schema$;
import zio.schema.StandardType;
import zio.schema.codec.BinaryCodec;
import zio.stream.ZPipeline;
import zio.stream.ZStream;

public interface BodyCodec<A> {
    public static int ordinal(BodyCodec<?> bodyCodec) {
        return BodyCodec$.MODULE$.ordinal(bodyCodec);
    }

    public static <E> ZPipeline<Object, HttpCodecError, E, E> validateStream(Schema<E> schema, Object object) {
        return BodyCodec$.MODULE$.validateStream(schema, object);
    }

    public static <A> ZIO<Object, HttpCodecError, A> validateZIO(Schema<A> schema, A a, Object object) {
        return BodyCodec$.MODULE$.validateZIO(schema, a, object);
    }

    public ZIO<Object, Throwable, A> decodeFromBody(Body var1, Object var2);

    public Body encodeToBody(A var1, Chunk<Header.Accept.MediaTypeWithQFactor> var2, Object var3);

    public static BodyCodec erase$(BodyCodec $this) {
        return $this.erase();
    }

    default public BodyCodec<Object> erase() {
        return this;
    }

    public Schema<Object> schema();

    public Option<MediaType> mediaType();

    public Option<String> name();

    public static final class Multiple<E>
    implements BodyCodec<ZStream<Object, Nothing$, E>>,
    Product,
    Serializable {
        private final HttpContentCodec codec;
        private final Option name;

        public static <E> Multiple<E> apply(HttpContentCodec<E> httpContentCodec, Option<String> option) {
            return BodyCodec$Multiple$.MODULE$.apply(httpContentCodec, option);
        }

        public static Multiple<?> fromProduct(Product product) {
            return BodyCodec$Multiple$.MODULE$.fromProduct(product);
        }

        public static <E> Multiple<E> unapply(Multiple<E> multiple) {
            return BodyCodec$Multiple$.MODULE$.unapply(multiple);
        }

        public Multiple(HttpContentCodec<E> codec, Option<String> name) {
            this.codec = codec;
            this.name = name;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Multiple)) return false;
            Multiple multiple = (Multiple)object;
            HttpContentCodec<E> httpContentCodec = this.codec();
            HttpContentCodec<E> httpContentCodec2 = multiple.codec();
            if (httpContentCodec == null) {
                if (httpContentCodec2 != null) {
                    return false;
                }
            } else if (!((Object)httpContentCodec).equals(httpContentCodec2)) return false;
            Option<String> option = this.name();
            Option<String> option2 = multiple.name();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Multiple;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Multiple";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "codec";
            }
            if (1 == n2) {
                return "name";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public HttpContentCodec<E> codec() {
            return this.codec;
        }

        @Override
        public Option<String> name() {
            return this.name;
        }

        @Override
        public Schema<E> schema() {
            return this.codec().schema();
        }

        @Override
        public Option<MediaType> mediaType() {
            return Some$.MODULE$.apply((Object)this.codec().defaultMediaType());
        }

        @Override
        public ZIO<Object, Throwable, ZStream<Object, Nothing$, E>> decodeFromBody(Body body, Object trace) {
            return ZIO$.MODULE$.fromEither(() -> this.decodeFromBody$$anonfun$3(body, trace), trace);
        }

        @Override
        public Body encodeToBody(ZStream<Object, Nothing$, E> value, Chunk<Header.Accept.MediaTypeWithQFactor> mediaTypes, Object trace) {
            Tuple2<MediaType, BinaryCodec<E>> tuple2 = this.codec().chooseFirst(mediaTypes);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            MediaType mediaType = (MediaType)tuple2._1();
            BinaryCodec codec0 = (BinaryCodec)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)mediaType, (Object)codec0);
            MediaType mediaType2 = (MediaType)tuple22._1();
            BinaryCodec codec02 = (BinaryCodec)tuple22._2();
            return Body$.MODULE$.fromStreamChunked((ZStream<Object, Throwable, Object>)value.$greater$greater$greater(() -> this.encodeToBody$$anonfun$1(codec02), trace)).contentType(mediaType2);
        }

        public <E> Multiple<E> copy(HttpContentCodec<E> codec, Option<String> name) {
            return new Multiple<E>(codec, name);
        }

        public <E> HttpContentCodec<E> copy$default$1() {
            return this.codec();
        }

        public <E> Option<String> copy$default$2() {
            return this.name();
        }

        public HttpContentCodec<E> _1() {
            return this.codec();
        }

        public Option<String> _2() {
            return this.name();
        }

        private final ZPipeline decodeFromBody$$anonfun$3$$anonfun$1$$anonfun$1(BinaryCodec codec$1) {
            return codec$1.streamDecoder();
        }

        private final ZPipeline decodeFromBody$$anonfun$3$$anonfun$1$$anonfun$2(Object trace$5) {
            return BodyCodec$.MODULE$.validateStream(this.schema(), trace$5);
        }

        private final Either decodeFromBody$$anonfun$3(Body body$3, Object trace$3) {
            return BodyCodec$.MODULE$.zio$http$codec$internal$BodyCodec$$$codecForBody(this.codec(), body$3).map((Function1 & Serializable)codec -> body$3.asStream(trace$3).$greater$greater$greater(() -> this.decodeFromBody$$anonfun$3$$anonfun$1$$anonfun$1(codec), trace$3).$greater$greater$greater(() -> this.decodeFromBody$$anonfun$3$$anonfun$1$$anonfun$2(trace$3), trace$3).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace$3));
        }

        private final ZPipeline encodeToBody$$anonfun$1(BinaryCodec codec0$1) {
            return codec0$1.streamEncoder();
        }
    }

    public static final class Single<A>
    implements BodyCodec<A>,
    Product,
    Serializable {
        private final HttpContentCodec codec;
        private final Option name;

        public static <A> Single<A> apply(HttpContentCodec<A> httpContentCodec, Option<String> option) {
            return BodyCodec$Single$.MODULE$.apply(httpContentCodec, option);
        }

        public static Single<?> fromProduct(Product product) {
            return BodyCodec$Single$.MODULE$.fromProduct(product);
        }

        public static <A> Single<A> unapply(Single<A> single) {
            return BodyCodec$Single$.MODULE$.unapply(single);
        }

        public Single(HttpContentCodec<A> codec, Option<String> name) {
            this.codec = codec;
            this.name = name;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Single)) return false;
            Single single = (Single)object;
            HttpContentCodec<A> httpContentCodec = this.codec();
            HttpContentCodec<A> httpContentCodec2 = single.codec();
            if (httpContentCodec == null) {
                if (httpContentCodec2 != null) {
                    return false;
                }
            } else if (!((Object)httpContentCodec).equals(httpContentCodec2)) return false;
            Option<String> option = this.name();
            Option<String> option2 = single.name();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Single;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Single";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "codec";
            }
            if (1 == n2) {
                return "name";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public HttpContentCodec<A> codec() {
            return this.codec;
        }

        @Override
        public Option<String> name() {
            return this.name;
        }

        @Override
        public Schema<A> schema() {
            return this.codec().schema();
        }

        @Override
        public Option<MediaType> mediaType() {
            return Some$.MODULE$.apply((Object)this.codec().defaultMediaType());
        }

        @Override
        public ZIO<Object, Throwable, A> decodeFromBody(Body body, Object trace) {
            Schema<A> schema = this.schema();
            Schema schema2 = Schema$.MODULE$.apply(Schema$.MODULE$.primitive((StandardType)StandardType.UnitType$.MODULE$));
            if (!(schema != null ? !schema.equals((Object)schema2) : schema2 != null)) {
                return ZIO$.MODULE$.unit();
            }
            Schema<A> schema3 = this.schema();
            return body.asChunk(trace).flatMap((Function1 & Serializable)chunk -> ZIO$.MODULE$.fromEither(() -> this.decodeFromBody$$anonfun$1$$anonfun$1(body, chunk), trace), trace).flatMap((Function1 & Serializable)e -> BodyCodec$.MODULE$.validateZIO(schema3, e, trace), trace);
        }

        @Override
        public Body encodeToBody(A value, Chunk<Header.Accept.MediaTypeWithQFactor> mediaTypes, Object trace) {
            Tuple2<MediaType, BinaryCodec<A>> tuple2 = this.codec().chooseFirst(mediaTypes);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            MediaType mediaType = (MediaType)tuple2._1();
            BinaryCodec encoder = (BinaryCodec)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)mediaType, (Object)encoder);
            MediaType mediaType2 = (MediaType)tuple22._1();
            BinaryCodec encoder2 = (BinaryCodec)tuple22._2();
            return Body$.MODULE$.fromChunk((Chunk<Object>)((Chunk)encoder2.encode(value))).contentType(mediaType2);
        }

        public <A> Single<A> copy(HttpContentCodec<A> codec, Option<String> name) {
            return new Single<A>(codec, name);
        }

        public <A> HttpContentCodec<A> copy$default$1() {
            return this.codec();
        }

        public <A> Option<String> copy$default$2() {
            return this.name();
        }

        public HttpContentCodec<A> _1() {
            return this.codec();
        }

        public Option<String> _2() {
            return this.name();
        }

        private final Either decodeFromBody$$anonfun$1$$anonfun$1(Body body$2, Chunk chunk$1) {
            return BodyCodec$.MODULE$.zio$http$codec$internal$BodyCodec$$$codecForBody(this.codec(), body$2).flatMap((Function1 & Serializable)_$1 -> _$1.decode((Object)chunk$1));
        }
    }
}

